import { PrismaClient } from '@prisma/sql/client';
import fs from 'fs';
import path from 'path';

const prisma = new PrismaClient();

// Define the wizard groups (assuming you only have one entry)
const wizardGroups = [{ id: 1, name: 'Static', slug: 'static' }];

// Read the dashboard wizard data from JSON
const dashboardWizardData = JSON.parse(
  fs.readFileSync(path.join(__dirname, 'json/dashboard-wizard.json'), 'utf-8')
);

export async function wizardGroupSeeder(company_id: number) {
  try {
    console.log("🚀 Starting Wizard Group Seeder...");

    for (const wizardGroup of wizardGroups) {
      let existingwizardGroup = await prisma.wizardGroup.findFirst({
        where: { id: wizardGroup.id },
      });

      if (!existingwizardGroup) {
        await prisma.$executeRawUnsafe(`
          SET IDENTITY_INSERT wizard_group ON;
          
          INSERT INTO wizard_group (id, name, slug, company_id)
          VALUES (${wizardGroup.id}, '${wizardGroup.name}', '${wizardGroup.slug}', ${company_id});
        
          SET IDENTITY_INSERT wizard_group OFF;
        `);       

        existingwizardGroup = await prisma.wizardGroup.findFirst({
          where: { id: wizardGroup.id },
        });

        console.log(`✅ Created wizardGroup: ${existingwizardGroup?.name}`);
      } else {
        console.log(`🔄 wizardGroup with id ${wizardGroup.id} already exists.`);
      }

      // ✅ Process the dashboard wizard data
      for (const dashboardWizard of dashboardWizardData) {
        let existingMasterEntity = await prisma.masterEntity.findFirst({
          where: {
            company_id: company_id,
            entity_name: dashboardWizard.entity_name,
          },
        });

        if (!existingMasterEntity) {
          await prisma.masterEntity.create({
            data: {
              ...Object.fromEntries(
                Object.entries(dashboardWizard).map(([key, value]) => [
                  key,
                  typeof value === "object" && value !== null ? JSON.stringify(value) : value,
                ])
              ),
              company_id: company_id,
              entity_name: dashboardWizard.entity_name ?? null,
              entity_type: dashboardWizard.entity_type ?? null,
              dashboard_wizard_group_id: existingwizardGroup?.id,
              name: dashboardWizard.name ?? null,
            },
          });

          console.log(
            `✅ Created master entity with order no ${dashboardWizard.dashboard_wizard_order_no}`
          );
        } else {
          console.log(
            `🔄 Master entity with name ${dashboardWizard.entity_name} already exists.`
          );
        }
      }
    }

    console.log("✅ Wizard Group Seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Error in wizardGroupSeeder: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
