import { PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

const productStatuses = [
    {
      "code": "new",
      "name": "New"
    },
    {
      "code": "reusable",
      "name": "Reusable"
    },
    {
      "code": "scrap",
      "name": "Scrap"
    }
  ];

export async function productStatusesSeeder(company_id: number) {
  try {

    let user = await prisma.user.findFirst({
        where: {company_id:company_id, role: 'super_admin'}
    });
    if(!user){
        console.log(`productStatuses seeder failed: admin user not available for company id ${company_id}`);
        return false;
    }

    const createdBy = user.id;

    for (const productStatus of productStatuses) {
      const existingActionType = await prisma.productStatuses.findFirst({
        where: { code: productStatus.code },
      });

      if (!existingActionType) {
        await prisma.productStatuses.create({
          data: {
            code: productStatus.code, 
            name: productStatus.name,
            company_id: company_id,
            created_by:createdBy,
          },
        });
        console.log(
          `Created productStatus with name ${productStatus.name}`,
        );
      } else {
        console.log(`productStatus with name ${productStatus.name} already exists.`);
      }
    }
  } catch (error) {
    console.error(`Error in productStatusSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
