create index idx_stocks_id on
   stocks (
      id
   );
create index idx_stocks_company_status_quantity on
   stocks (
      company_id,
      status_id,
      quantity
   );
create index idx_stocks_item_id on
   stocks (
      item_id
   );
create index idx_stocks_final_item_id on
   stocks (
      final_item_id
   );
create index idx_stocks_parent_id on
   stocks (
      parent_id
   );
create index idx_stocks_zain_tag on
   stocks (
      zain_tag
   );
create index idx_stocks_uom_id on
   stocks (
      uom_id
   );
create index idx_stocks_created_at on
   stocks (
      created_at
   );
create index idx_stocks_project_id on
   stocks (
      project_id
   );
create index idx_stocks_team_id on
   stocks (
      team_id
   );
create index idx_stocks_vendor_id on
   stocks (
      vendor_id
   );
create index idx_stocks_bin_id on
   stocks (
      bin_id
   );
create index idx_stocks_site_id_origin_destn on
   stocks (
      site_id_origin,
      site_id_destn
   );
create index idx_stocks_old_warehouse_id on
   stocks (
      old_warehouse_id
   );
create index idx_stocks_warehouse_id on
   stocks (
      warehouse_id
   );
create index idx_stocks_region_id on
   stocks (
      region_id
   );
create index idx_stocks_item_action_id on
   stocks (
      item_action_id
   );
create index idx_stocks_item_condition_id on
   stocks (
      item_condition_id
   );

-- Items table
create index idx_items_id on
   items (
      id
   );
create index idx_items_sku on
   items (
      sku
   );
create index idx_items_manufacturer_id on
   items (
      manufacturer_id
   );
create index idx_items_department_id on
   items (
      department_id
   );
create index idx_items_item_type_id on
   items (
      item_type_id
   );
create index idx_items_team_id on
   items (
      team_id
   );

-- Parent Items
create index idx_parent_items_id on
   items (
      id
   );

-- Final Items
create index idx_final_items_id on
   items (
      id
   );

-- Item Types
create index idx_item_types_id on
   item_types (
      id
   );

-- Units of Measure
create index idx_uom_id on
   units_of_measure (
      id
   );

-- Item UOMs
create index idx_item_uoms_item_uom on
   item_uoms (
      item_id,
      uom_id
   );
create index idx_item_uoms_is_base on
   item_uoms (
      item_id,
      is_base_uom
   );

-- MRN Line Items
create index idx_mrn_line_items_zain_tag on
   mrn_line_items (
      zain_tag
   );
create index idx_mrn_line_items_header_id on
   mrn_line_items (
      mrn_header_id
   );

-- MTR Line Items
create index idx_mtr_line_items_zain_tag on
   mtr_line_items (
      zain_tag
   );

-- MRN Header
create index idx_mrn_header_id on
   mrn_header (
      id
   );

-- MIN Line Items
create index idx_min_line_items_zain_tag on
   min_line_items (
      zain_tag
   );

-- MIN Header
create index idx_min_header_id_status on
   min_header (
      id,
      min_status
   );

-- Vendors, Teams, Departments, Sites, Warehouses
create index idx_vendors_id on
   vendors (
      id
   );
create index idx_teams_id on
   teams (
      id
   );
create index idx_departments_id on
   departments (
      id
   );
create index idx_sites_id on
   sites (
      id
   );
create index idx_warehouses_id on
   warehouses (
      id
   );
create index idx_regions_id on
   regions (
      id
   );
create index idx_bins_id on
   bins (
      id
   );
create index idx_pallets_id on
   pallets (
      id
   );
create index idx_projects_id on
   projects (
      id
   );


create index idx_stocks_sys_tag_status on
   stocks (
      sys_tag_status
   );