import { PrismaClient} from '@prisma/sql/client'
import fs from 'fs';
import path from 'path';

const prisma = new PrismaClient();

export async function formEntitiesSeeder(company_id: number) {
  try {
    console.log("🚀 Starting Form Entities Seeder...");

    const formEntities = JSON.parse(
      fs.readFileSync(path.join(__dirname, 'json/form-entities.json'), 'utf-8')
    );
    const jobBuilder = JSON.parse(
      fs.readFileSync(path.join(__dirname, 'json/job-builder.json'), 'utf-8')
    );

    const allEntities = [...formEntities, ...jobBuilder];

    for (const formEntity of allEntities) {
      const formEntityData:any = Object.fromEntries(
        Object.entries(formEntity).map(([key, value]) => [
          key,
          typeof value === "object" && value !== null ? JSON.stringify(value) : value,
        ])
      );

      // ✅ Check if the entity exists
      let existingEntity = await prisma.masterEntity.findFirst({
        where: { company_id, entity_name: formEntityData.entity_name },
      });

      if (existingEntity) {
        await prisma.masterEntity.update({
          where: { id: existingEntity.id },
          data: formEntityData,
        });
        console.log(`🔄 Updated Form Entity: ${formEntityData.entity_name}`);
      } else {
        await prisma.masterEntity.create({
          data: { ...formEntityData, company_id },
        });
        console.log(`✅ Created Form Entity: ${formEntityData.entity_name}`);
      }
    }

    console.log("✅ Form Entities Seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Form entity seeder failed: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
