import { PrismaClient } from '@prisma/pg/client';
const prisma = new PrismaClient();

function getCurrentUtcTime() {
  return new Date().toISOString();
}

export async function approvalWorkflowApproverTag(company_id: number) {
  console.log("Seeding ApprovalWorkflowApproverTag...");

  let user = await prisma.user.findFirst({
    where: { company_id: company_id, role: 'super_admin' }
  });
  if (!user) {
      console.log(`Department seeder failed: admin user not available for company id ${company_id}`);
      return false;
  }

  const createdBy = user.id;
  const utcNow = getCurrentUtcTime();

  const approverTags = [
    {
      slug: "department_head",
      name: "Department Head",
      description: "Approver is the head of the department",
      query_information: `SELECT dh.user_id from user_details as ud 
                          INNER JOIN departments as d ON d.id = ud.department_id
                          INNER JOIN user_details as dh ON dh.id = d.department_head_id
                          WHERE ud.user_id = $session_user_id;`,
      company_id,
      created_by: createdBy,
      updated_by: createdBy,
      created_at: utcNow,
      updated_at: utcNow,
    },
    {
      slug: "requested_user",
      name: "Requested User",
      description: "Approver is the user who made the request",
      query_information: `SELECT * FROM users WHERE id = $session_user_id`,
      company_id,
      created_by: createdBy,
      updated_by: createdBy,
      created_at: utcNow,
      updated_at: utcNow,
    },
    {
      slug: "finance_manager",
      name: "Finance Manager",
      description: "Approver is the finance department head",
      query_information: `SELECT u.* FROM users AS u 
                          WHERE u.role_id = (SELECT id FROM roles WHERE name = 'Admin')`,
      company_id,
      created_by: createdBy,
      updated_by: createdBy,
      created_at: utcNow,
      updated_at: utcNow,
    }
  ];

  // Insert data using upsert (to prevent duplicate entries)
  for (const tag of approverTags) {
    await prisma.approvalWorkflowApproverTag.upsert({
      where: { company_id_slug: {company_id, slug:tag.slug} },
      update: tag,
      create: tag,
    });
  }

  console.log("Seeding completed!");
}

