import { statusSeeder } from './seeds/status-seeds';
import { usersSeeder } from './seeds/user-seeds';
import { permissionsSeeder } from './seeds/permission-seeds';
import { menuItemsSeeder } from './seeds/menuItems-seeds';
import { fieldTypesSeeder } from './seeds/field-types-seeds';
import { gridSeeder } from './seeds/master-grid-seeds';
import { importTemplatesSeeder } from './seeds/import-template-seeds';
import { entityTypeSeeder } from './seeds/entity-type-seeds';
import { actionTypeSeeder } from './seeds/action-type-seeds';
import { languageSeeds } from './seeds/language-seeds';
import { formEntitiesSeeder } from './seeds/form-entity-seeds';
import { languageContentSeeds } from './seeds/languageContent-seeds';
import { wizardTypeSeeder } from './seeds/wizard-type-seeds';
import { wizardGroupSeeder } from './seeds/dashboard-wizard-seeds';
import { menusSeeder } from './seeds/menus-seeds';
import { mobileMenuItemsSeeder } from './seeds/mobileMenuItems-seeds';
import { menuTypesSeeds } from './seeds/menuTypes-seeds';
import { roleSeeds } from './seeds/role-seeds';
import { userRolesSeeds } from './seeds/userRoles-seeds';
import { emailTemplatesProcessSeeder } from './seeds/email-template-process-seeds';
import { emailTemplatesSeeder } from './seeds/email-template-seeds';
import { configurationsSeeder } from './seeds/configuration-seeds';
import { emailTemplateAssignmentsSeeder } from './seeds/email-template-assignment-seeds';
import { financialYearSeeder } from './seeds/program-year-seeds';
import { documentSequenceSeeder } from './seeds/document-sequence-seeds';
import { dataTransferQueries } from './seeds/data-transfer-queries-seeds';
import { deviceRegistrationSeeder } from './seeds/device-registration-seeds';
import { exportTemplatesSeeder } from './seeds/export-template-seeds';
import { policiesSeeder } from './seeds/policy-seeds';
import { departmentSeeds } from './seeds/department-seeds';
import { appVersionsSeeder } from './seeds/app-version-seeds';
import { approvalWorkflowApproverTag } from './seeds/approval-workflow-approver-tag-seed';
import { approvalWorkflow } from './seeds/approval-workflow-seeds';
import { scheduledJobSeeder } from './seeds/scheduled-job-seeds';
import { aboutLCPSeeder } from './seeds/about-lcp-seeds';
import { chileProcessSeeder } from './seeds/child-process-seeds';
import { carouselTemplatesSeeder } from './seeds/carousel-template-seeds';
import { whatsappTemplatesSeeder } from './seeds/whatsapp-template-seeds';
import { whatsappTemplatesProcessSeeder } from './seeds/whatsapp-template-process-seeds';
import { whatsappTemplateAssignmentsSeeder } from './seeds/whatsapp-template-assignment-seeds';

const company_id = 1;

async function applicationSeeders() {
  try {
    await statusSeeder();
    await scheduledJobSeeder();
    await entityTypeSeeder(company_id);
    await actionTypeSeeder(company_id);
    await wizardTypeSeeder(company_id);

    await usersSeeder(company_id);
    await financialYearSeeder(company_id);
    await documentSequenceSeeder(company_id);
    await fieldTypesSeeder(company_id);
    await exportTemplatesSeeder(company_id);
    await importTemplatesSeeder(company_id);
    await gridSeeder(company_id);
    await wizardGroupSeeder(company_id);
    await formEntitiesSeeder(company_id);
    await permissionsSeeder(company_id);
    await menusSeeder(company_id);
    await menuItemsSeeder(company_id);
    await mobileMenuItemsSeeder(company_id);
    await menuTypesSeeds(company_id);
    await languageSeeds(company_id);
    await languageContentSeeds(company_id);
    await roleSeeds(company_id);
    await userRolesSeeds(company_id);
    await emailTemplatesProcessSeeder(company_id);
    await emailTemplatesSeeder(company_id);
    await configurationsSeeder(company_id);
    await emailTemplateAssignmentsSeeder(company_id);
    await dataTransferQueries(company_id);
    await deviceRegistrationSeeder(company_id);
    await policiesSeeder(company_id);
    await departmentSeeds(company_id);
    await appVersionsSeeder(company_id);
    await approvalWorkflowApproverTag(company_id);
    await approvalWorkflow(company_id);
    await aboutLCPSeeder(company_id);
    await chileProcessSeeder(company_id);
    await carouselTemplatesSeeder(company_id);
    await whatsappTemplatesProcessSeeder(company_id);
    await whatsappTemplatesSeeder(company_id);
    await whatsappTemplateAssignmentsSeeder(company_id);
  } catch (error) {
    console.log(`Application seeder error: `, error);
  }
}

applicationSeeders();
