import { statusSeeder } from './app-seeds/status-seeds';
import { usersSeeder } from './app-seeds/user-seeds';
import { permissionsSeeder } from './app-seeds/permission-seeds';
import { menuItemsSeeder } from './app-seeds/menuItems-seeds';
import { fieldTypesSeeder } from './app-seeds/field-types-seeds';
import { gridSeeder } from './app-seeds/master-grid-seeds';
import { importTemplatesSeeder } from './app-seeds/import-template-seeds';
import { entityTypeSeeder } from './app-seeds/entity-type-seeds';
import { actionTypeSeeder } from './app-seeds/action-type-seeds';
import { languageSeeds } from './app-seeds/language-seeds';
import { formEntitiesSeeder } from './app-seeds/form-entity-seeds';
import { languageContentSeeds } from './app-seeds/languageContent-seeds';
import { wizardTypeSeeder } from './app-seeds/wizard-type-seeds';
import { wizardGroupSeeder } from './app-seeds/dashboard-wizard-seeds';
import { menusSeeder } from './app-seeds/menus-seeds';
import { mobileMenuItemsSeeder } from './app-seeds/mobileMenuItems-seeds';
import { menuTypesSeeds } from './app-seeds/menuTypes-seeds';
import { roleSeeds } from './app-seeds/role-seeds';
import { userRolesSeeds } from './app-seeds/userRoles-seeds';
import { emailTemplatesProcessSeeder } from './app-seeds/email-template-process-seeds';
import { emailTemplatesSeeder } from './app-seeds/email-template-seeds';
import { configurationsSeeder } from './app-seeds/configuration-seeds';
import { emailTemplateAssignmentsSeeder } from './app-seeds/email-template-assignment-seeds';
import { financialYearSeeder } from './app-seeds/program-year-seeds';
import { documentSequenceSeeder } from './app-seeds/document-sequence-seeds';
import { dataTransferQueries } from './app-seeds/data-transfer-queries-seeds';
import { deviceRegistrationSeeder } from './app-seeds/device-registration-seeds';
import { exportTemplatesSeeder } from './app-seeds/export-template-seeds';
import { policiesSeeder } from './app-seeds/policy-seeds';
import { departmentSeeds } from './app-seeds/department-seeds';
import { appVersionsSeeder } from './app-seeds/app-version-seeds';
import { approvalWorkflowApproverTag } from './app-seeds/approval-workflow-approver-tag-seed';
import { approvalWorkflow } from './app-seeds/approval-workflow-seeds';
import { scheduledJobSeeder } from './app-seeds/scheduled-job-seeds';
import { aboutLCPSeeder } from './app-seeds/about-lcp-seeds';
import { chileProcessSeeder } from './app-seeds/child-process-seeds';
import { carouselTemplatesSeeder } from './app-seeds/carousel-template-seeds';
import { whatsappTemplatesSeeder } from './app-seeds/whatsapp-template-seeds';
import { whatsappTemplatesProcessSeeder } from './app-seeds/whatsapp-template-process-seeds';
import { whatsappTemplateAssignmentsSeeder } from './app-seeds/whatsapp-template-assignment-seeds';

const company_id = 1;

async function applicationSeeders() {
  try {
    await statusSeeder();
    await scheduledJobSeeder();
    await entityTypeSeeder(company_id);
    await actionTypeSeeder(company_id);
    await wizardTypeSeeder(company_id);

    await usersSeeder(company_id);
    await financialYearSeeder(company_id);
    await documentSequenceSeeder(company_id);
    await fieldTypesSeeder(company_id);
    await exportTemplatesSeeder(company_id);
    await importTemplatesSeeder(company_id);
    await gridSeeder(company_id);
    await wizardGroupSeeder(company_id);
    await formEntitiesSeeder(company_id);
    await permissionsSeeder(company_id);
    await menusSeeder(company_id);
    await menuItemsSeeder(company_id);
    await mobileMenuItemsSeeder(company_id);
    await menuTypesSeeds(company_id);
    await languageSeeds(company_id);
    await languageContentSeeds(company_id);
    await roleSeeds(company_id);
    await userRolesSeeds(company_id);
    await emailTemplatesProcessSeeder(company_id);
    await emailTemplatesSeeder(company_id);
    await configurationsSeeder(company_id);
    await emailTemplateAssignmentsSeeder(company_id);
    await dataTransferQueries(company_id);
    await deviceRegistrationSeeder(company_id);
    await policiesSeeder(company_id);
    await departmentSeeds(company_id);
    await appVersionsSeeder(company_id);
    await approvalWorkflowApproverTag(company_id);
    await approvalWorkflow(company_id);
    await aboutLCPSeeder(company_id);
    await chileProcessSeeder(company_id);
    await carouselTemplatesSeeder(company_id);
    await whatsappTemplatesProcessSeeder(company_id);
    await whatsappTemplatesSeeder(company_id);
    await whatsappTemplateAssignmentsSeeder(company_id);
  } catch (error) {
    console.log(`Application seeder error: `, error);
  }
}

applicationSeeders();
