import { Menus, PrismaClient } from '@prisma/pg/client'
import fs from 'fs';
const prisma = new PrismaClient();

function getCurrentUtcTime() {
  return new Date().toISOString();
}

export async function menusSeeder(company_id: number) {
  try {
    const utcNow = getCurrentUtcTime();
    let user = await prisma.user.findFirst({
      where: { company_id, role: 'super_admin' },
    });
    if (!user) {
      console.log(
        `Menu seeder failed: admin user not available for company id ${company_id}`,
      );
      return false;
    }
    const menus = JSON.parse(
      fs.readFileSync(__dirname + '/json/menus-seeds.json', 'utf-8'),
    );
    for (const menu of menus) {
      await createMenu(company_id, menu, user.id);
    }
  } catch (error) {
    throw error;
  }
}

async function createMenu(company_id: number, menu: any, created_by:number) {
    // Check if the menu already exists
    let existingMenu = await prisma.menus.findFirst({
      where: { company_id, name: menu.name },
    });
  
    // If it does not exist, create it
    if (!existingMenu) {
      const data = {
        name: menu.name,
        slug: menu.slug,
        menu_type: menu.type,
        company_id,
        created_by
      };
      existingMenu = await prisma.menus.create({
        data,
      });
      console.log(`Menu created successfully: ${existingMenu.name}`);
    }
    else{
      const data = {
        name: menu.name,
        slug: menu.slug,
        menu_type: menu.type,
        company_id,
        created_by
      };
  
      menu = await prisma.menus.update({
        where: { company_id_id: { company_id, id: existingMenu.id } },
        data,
      });
      console.log(`Menu updated successfully: ${menu.name}`);
    }
 
}
