"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});const express_1=__importDefault(require("express")),jwt_middleware_1=require("../../middlewares/jwt.middleware"),common_controller_1=require("../../controller/admin/common.controller"),common_validate_1=require("../../schema/common.validate"),validate_1=require("../../middlewares/validate"),auth_validate_1=require("../../schema/auth.validate"),cron_controller_1=require("../../controller/common/cron.controller"),decryptPayload_middleware_1=require("../../middlewares/decryptPayload.middleware"),router=express_1.default.Router();router.post("/axios-call",decryptPayload_middleware_1.decryptPayloadMiddleware,common_controller_1.commonController.axiosCall),router.post("/language-content",decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({body:common_validate_1.languageIdSchema}),common_controller_1.commonController.getLanguageContent),router.get("/grid-data/:entity_name",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:common_validate_1.entityNameSchema}),common_controller_1.commonController.getGridColumns),router.get("/attached-policies/:entity_name",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:common_validate_1.entityNameSchema}),common_controller_1.commonController.getAttachedPolicies),router.post("/grid-data",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({body:common_validate_1.gridParamSchema}),common_controller_1.commonController.getGridData),router.post("/grid-data-export",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,common_controller_1.commonController.getGridDataExport),router.post("/individual-data-export",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,common_controller_1.commonController.getIndividualDataExport),router.post("/list-data",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({body:common_validate_1.multipleRecordsParamSchema}),common_controller_1.commonController.getTableData),router.post("/unauth-list-data",decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({body:common_validate_1.multipleRecordsParamSchema}),common_controller_1.commonController.unAuthGetTableData),router.post("/create-data",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({body:common_validate_1.createRecordsParamSchema}),common_controller_1.commonController.createTableData),router.post("/update-data",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({body:common_validate_1.updateRecordsParamSchema}),common_controller_1.commonController.updateTableData),router.post("/execute-transaction",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,common_controller_1.commonController.executeTransactions),router.get("/tables",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,common_controller_1.commonController.getAllTableNames),router.post("/procedure/:procedure",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,common_controller_1.commonController.callDynamicProcedure),router.post("/call-procedure/:procedure",decryptPayload_middleware_1.decryptPayloadMiddleware,common_controller_1.commonController.unAuthCallDynamicProcedure),router.post("/file-upload/image",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,((e,a,o)=>{console.log("Content-Type:",e.headers["content-type"]),console.log("Files:",e.files),o()}),(0,validate_1.validateRequest)({body:auth_validate_1.imgUploadSchema}),common_controller_1.commonController.imageUpload),router.post("/file-delete/image",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,common_controller_1.commonController.fileDelete),router.post("/import-template/details",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,((e,a,o)=>{console.log("Content-Type:",e.headers["content-type"]),console.log("Files:",e.files),o()}),(0,validate_1.validateRequest)({body:common_validate_1.importMasterTeplateRequest}),common_controller_1.commonController.getSheetDetails),router.post("/import-template/validate/:template_uuid/:file_uuid",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:common_validate_1.fileAndTemplateUuidSchema}),common_controller_1.commonController.validateAndGetSheetData),router.delete("/import-template/remove/:file_uuid",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:common_validate_1.fileUuidSchema}),common_controller_1.commonController.removeFileByUuid),router.put("/import-template/upload/:template_uuid/:file_uuid",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:common_validate_1.fileAndTemplateUuidSchema}),common_controller_1.commonController.importTemplateDetail),router.get("/import-template/details/:uuid",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:common_validate_1.uuidSchema}),common_controller_1.commonController.getTemplateDetail),router.post("/create-cron-jobs",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,cron_controller_1.cronController.createCronJobs),router.get("/get-cron-jobs",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,cron_controller_1.cronController.getCronJobs),router.get("/stop-cron-jobs",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,cron_controller_1.cronController.stopCronJobs),router.get("/stop-cron-job/:id",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,cron_controller_1.cronController.stopCronJob),router.get("/start-cron-job/:id",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,cron_controller_1.cronController.startCronJob),router.get("/restart-cron-jobs",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,cron_controller_1.cronController.restartCronJobs),router.put("/edit-cron-job/:id",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,cron_controller_1.cronController.updateCronJob),router.delete("/delete-cron-job/:id",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,cron_controller_1.cronController.removeCronJob),router.post("/execute-child-process/:id",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:common_validate_1.childProcessIdSchema}),common_controller_1.commonController.executeChildProcess),exports.default=router;