import { PrismaClient } from '@prisma/sql/client'
const prisma = new PrismaClient();

const entityTypes = [
  {
    name: '2023-2024',
    code: '2023_2024',
    start_date: '2023-04-01',
    end_date: '2024-03-31',
  },
  {
    name: '2024-2025',
    code: '2024_2025',
    start_date: '2024-04-01',
    end_date: '2025-03-31',
    is_freezed: true,
  }
];

export async function financialYearSeeder(company_id: number) {
  try {
    console.log("🚀 Starting Financial Year Seeder...");

    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    await prisma.$transaction(async (tx) => {
      for (const entityType of entityTypes) {
        const existingRecord = await tx.financialYear.findFirst({
          where: { company_id: company_id, code: entityType.code },
        });

        if (existingRecord) {
          // ✅ Update existing financial year
          await tx.$executeRawUnsafe(`
            UPDATE financial_years 
            SET name = '${entityType.name}', 
                start_date = '${new Date(entityType.start_date).toISOString()}',
                end_date = '${new Date(entityType.end_date).toISOString()}',
                updated_by = ${user?.id}
            WHERE company_id = ${company_id} AND code = '${entityType.code}';
          `);
          console.log(`🔄 Updated Financial Year with code ${entityType.code}`);
        } else {
          // ✅ Insert new financial year
          await tx.$executeRawUnsafe(`
            INSERT INTO financial_years (name, code, start_date, end_date, is_freezed, company_id, created_by, updated_by) 
            VALUES (
              '${entityType.name}', 
              '${entityType.code}', 
              '${new Date(entityType.start_date).toISOString()}',
              '${new Date(entityType.end_date).toISOString()}',
              ${entityType.is_freezed ? 1 : 0}, 
              ${company_id}, 
              ${user?.id}, 
              ${user?.id}
            );
          `);
          console.log(`✅ Created Financial Year with code ${entityType.code}`);
        }
      }
    });

    console.log("✅ Financial Year Seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Error in financialYearSeeder: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
