import { PrismaClient } from '@prisma/sql/client'
import fs from 'fs';
import path from 'path';

const prisma = new PrismaClient();

export async function menusSeeder(company_id: number) {
  try {
    console.log("🚀 Starting Menu Seeder...");

    let user = await prisma.user.findFirst({
      where: { company_id, role: 'super_admin' },
    });

    if (!user) {
      console.log(`❌ Menu seeder failed: No super_admin user for company_id ${company_id}`);
      return false;
    }

    const menus = JSON.parse(
      fs.readFileSync(path.join(__dirname, 'json/menus-seeds.json'), 'utf-8')
    );

    for (const menu of menus) {
      await createMenu(company_id, menu, user.id);
    }

    console.log("✅ Menu Seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Menu seeder failed: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}

async function createMenu(company_id: number, menu: any, created_by: number) {
  // ✅ Check if the menu already exists
  let existingMenu = await prisma.menus.findFirst({
    where: { company_id, name: menu.name },
  });

  const data = {
    name: menu.name,
    slug: menu.slug,
    menu_type: menu.type,
    company_id,
    created_by,
  };

  if (existingMenu) {
    await prisma.menus.update({
      where: { id: existingMenu.id },
      data,
    });
    console.log(`🔄 Menu updated successfully: ${menu.name}`);
  } else {
    const newMenu = await prisma.menus.create({ data });
    console.log(`✅ Menu created successfully: ${newMenu.name}`);
  }
}
