DROP FUNCTION IF EXISTS public.get_whatsapp_template(INT);
CREATE OR REPLACE FUNCTION public.get_whatsapp_template(p_template_id INT)
RETURNS JSONB
LANGUAGE plpgsql
AS $function$
DECLARE
    result JSONB;
BEGIN
    SELECT 
	    jsonb_build_object(
	        'whatsapp_template', to_jsonb(et),
	        'whatsapp_template_process', to_jsonb(etp)
	    ) INTO result
	FROM whatsapp_templates et
	INNER JOIN whatsapp_template_process etp 
	    ON etp.id = et.whatsapp_template_process_id
	WHERE et.id = p_template_id;

    RETURN result;
EXCEPTION
    WHEN OTHERS THEN
        RAISE EXCEPTION 'Unexpected error in get_whatsapp_template: %', SQLERRM;
END;
$function$;
