
CREATE OR REPLACE FUNCTION set_storage_age_to_zero()
RETURNS TRIGGER AS $$
BEGIN
  IF NEW.storage_age IS NULL THEN
    NEW.storage_age := 0;
  END IF;
  RETURN NEW;
END;
$$ LANGUAGE plpgsql;


CREATE TRIGGER trg_set_storage_age_to_zero_mtr
BEFORE INSERT ON mtr_line_items
FOR EACH ROW
EXECUTE FUNCTION set_storage_age_to_zero();


CREATE TRIGGER trg_set_storage_age_to_zero_mrn
BEFORE INSERT ON mrn_line_items
FOR EACH ROW
EXECUTE FUNCTION set_storage_age_to_zero();