import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

export async function SiteSeeder(company_id: number) {
  try {
    const rows = JSON.parse(
      fs.readFileSync(__dirname + '/json/sites-seeds.json', 'utf-8'),
    );

    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    if (!user?.id) {
      throw new Error('Super admin user not found!');
    }

    for (const row of rows) {
      // Check if the ItemType already exists by its name and company_id
      const existingsites = await prisma.sites.findUnique({
        where: { company_id_name: { company_id, name: row.name } }, // Assuming 'name' as code for sites
      });

      if (existingsites) {
        // Update the sites if it already exists
        await prisma.sites.update({
          where: { id: existingsites.id },
          data: {
            name: row.name,
            status_id: row.status_id || 1, // Default to active status if not provided
            updated_by: user.id, // Ensure updated_by is assigned
          },
        });
        console.log(`Updated sites with name ${row.name}`);
      } else {
        // Create a new sites if it doesn't exist
        await prisma.sites.create({
          data: {
            name: row.name,
            company_id,
            status_id: row.status_id || 1, // Default to active status if not provided
            created_by: user.id, // Ensure created_by is assigned
            updated_by: user.id, // Ensure updated_by is assigned
          },
        });
        console.log(`Created sites with name ${row.name}`);
      }
    }
  } catch (error) {
    console.error(`Error in SiteSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
