import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

export async function DepartmentSeeder(company_id: number) {
  try {
    console.log('coming');
    const rows = JSON.parse(
      fs.readFileSync(__dirname + '/json/department-seeds.json', 'utf-8'),
    );

    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    for (const row of rows) {
      // Check if the department already exists by its code and company_id
      const existingDepartment = await prisma.department.findUnique({
        where: { company_id_code: { company_id, code: row.code } },
      });

      if (existingDepartment) {
        // Update the department if it already exists
        await prisma.department.update({
          where: { id: existingDepartment.id },
          data: {
            name: row.name,
            description: row.description,
            updated_by: user?.id,
          },
        });
        console.log(`Updated department with code ${row.code}: ${row.name}`);
      } else {
        // Create a new department if it doesn't exist
        await prisma.department.create({
          data: {
            code: row.code,
            name: row.name,
            description: row.description,
            company_id,
            created_by: user?.id,
            updated_by: user?.id,
          },
        });
        console.log(`Created department with code ${row.code}: ${row.name}`);
      }
    }
  } catch (error) {
    console.error(`Error in DepartmentSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
