"use strict";
/**
 * @openapi
 * /auth/{role}/login:
 *   post:
 *     tags:
 *       - Auth
 *     summary: Super admin / Admin / User Login.
 *     parameters:
 *       - in: path
 *         name: role
 *         required: true
 *         description: role to indicate it is 'super_admin', 'admin' or 'user'
 *         schema:
 *           type: string
 *           example: super_admin
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/Login'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - DeviceId: []
 *       - DeviceType: []
 *       - FcmToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/{role}/verify/{type}/otp:
 *   post:
 *     tags:
 *      - Auth
 *     summary: Verfy OTP.
 *     parameters:
 *       - in: path
 *         name: role
 *         required: true
 *         description: role to indicate it is 'super_admin', 'admin' or 'user'
 *         schema:
 *           type: string
 *           example: super_admin
 *       - in: path
 *         name: type
 *         required: true
 *         description: Otp verification type must be 'login' or 'email'
 *         schema:
 *           type: string
 *           example: login
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/OtpVerify'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - DeviceId: []
 *       - DeviceType: []
 *       - FcmToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/{role}/password/request/{email}:
 *   get:
 *     tags:
 *       - Auth
 *     summary: PasswordRequest.
 *     parameters:
 *       - in: path
 *         name: role
 *         required: true
 *         description: role to indicate it is 'super_admin', 'admin' or 'user'
 *         schema:
 *           type: string
 *           example: super_admin
 *       - in: path
 *         name: email
 *         required: true
 *         description: Email to mail the reset request
 *         schema:
 *           type: string
 *           example: karthickn@techcedence.com
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - DeviceId: []
 *       - DeviceType: []
 *       - FcmToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/{role}/password/reset:
 *   post:
 *     tags:
 *       - Auth
 *     summary: PasswordReset.
 *     parameters:
 *       - in: path
 *         name: role
 *         required: true
 *         description: role to indicate it is 'super_admin', 'admin' or 'user'
 *         schema:
 *           type: string
 *           example: super_admin
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/PasswordUpdate'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - DeviceId: []
 *       - DeviceType: []
 *       - FcmToken: []
 *       - Language: []
 */
/**
* @openapi
* /auth/{role}/register:
*   post:
*     tags:
*       - Auth
*     summary: Register.
*     parameters:
*       - in: path
*         name: role
*         required: true
*         description: role to indicate it is 'super_admin', 'admin' or 'user'
*         schema:
*           type: string
*           example: super_admin
*     requestBody:
*       content:
*         'application/json':
*           schema:
*             $ref: '#/definitions/Register'
*     responses:
*       200:
*         description: OK
*     security:
*       - DeviceId: []
*       - DeviceType: []
*       - FcmToken: []
*       - Language: []
*/
/**
 * @openapi
 * /auth/logout:
 *   get:
 *     tags:
 *       - Auth
 *     summary: Logout.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - DeviceId: []
 *       - DeviceType: []
 *       - FcmToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/profile:
 *   get:
 *     tags:
 *       - Auth
 *     summary: My profile.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/profile:
 *   put:
 *     tags:
 *       - Auth
 *     summary: Update my profile.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/UpdateProfile'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/profile/picture:
 *   put:
 *     tags:
 *       - Auth
 *     summary: Update profile picture.
 *     requestBody:
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/definitions/UpdateProfilePic'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/password/change:
 *   post:
 *     tags:
 *       - Auth
 *     summary: Change Password.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/ChangePassword'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/account:
 *   delete:
 *     tags:
 *       - Auth
 *     summary: Delete Account.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/permissions:
 *   get:
 *     tags:
 *       - Auth
 *     summary: My roles & permissions.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/menus:
 *   get:
 *     tags:
 *       - Auth
 *     summary: Auth Menus.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /auth/powerbi/report/generate-embed-token:
 *   get:
 *     tags:
 *       - Auth
 *     summary: Power Bi authentication for reports.
 *     parameters:
 *       - in: query
 *         name: reportId
 *         schema:
 *           type: string
 *           example: "1234"
 *         required: true
 *         description: Search query for report id
 *       - in: query
 *         name: groupId
 *         schema:
 *           type: string
 *           example: "1234"
 *         required: true
 *         description: Search query for workspace/group id
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * definitions:
 *   Login:
 *     type: object
 *     properties:
 *       email:
 *         type: string
 *         example: karthickn@techcedence.com
 *       password:
 *         type: string
 *         example: SAdmin@123#
 *
 *   Register:
 *     type: object
 *     properties:
 *       first_name:
 *         type: string
 *         example: Test
 *       last_name:
 *         type: string
 *         example: User 1
 *       email:
 *         type: string
 *         example: karthickn@techcedence.com
 *       dob:
 *         type: string
 *         example: "1995-06-27"
 *       country_code:
 *         type: string
 *         example: "+91"
 *       phone_number:
 *         type: string
 *         example: 8875458855
 *       gender:
 *         type: string
 *         example: Male
 *       user_time_zone:
 *         type: string
 *         example: "+05:30"
 *       address:
 *         type: string
 *         example: "Coimbatore"
 *       password:
 *         type: string
 *         example: Test@123
 *       confirm_password:
 *         type: string
 *         example: Test@12
 *
 *   OtpVerify:
 *    type: object
 *    properties:
 *      uuid:
 *        type: string
 *        example: 0664b4aa-2463-4e3a-b61b-432c0dd34430
 *      otp:
 *        type: string
 *        example: 123456
 *
 *   PasswordUpdate:
 *     type: object
 *     properties:
 *       uuid:
 *         type: string
 *         example: 0664b4aa-2463-4e3a-b61b-432c0dd34430
 *       otp:
 *         type: string
 *         example: 123456
 *       new_password:
 *         type: string
 *         example: Test@123
 *       confirm_password:
 *         type: string
 *         example: Test@12
 *
 *   ChangePassword:
 *     type: object
 *     properties:
 *       old_password:
 *         type: string
 *         example: Test@123
 *       new_password:
 *         type: string
 *         example: Test@123
 *
 *   UpdateProfile:
 *     type: object
 *     properties:
 *       first_name:
 *         type: string
 *         example: Test
 *       last_name:
 *         type: string
 *         example: User 1
 *       dob:
 *         type: string
 *         example: "1995-06-27"
 *       country_code:
 *         type: string
 *         example: "+91"
 *       phone_number:
 *         type: string
 *         example: 8875458855
 *       gender:
 *         type: string
 *         example: Male
 *       user_time_zone:
 *         type: string
 *         example: "+05:30"
 *       address:
 *         type: string
 *         example: "Coimbatore"
 *
 *   UpdateProfilePic:
 *     type: object
 *     properties:
 *       profile_pic:
 *         type: file
 *         format: binary
 */
