import { Status, PrismaClient} from '@prisma/sql/client'
const prisma = new PrismaClient();

export async function statusSeeder() {
    try {  
        console.log("🚀 Starting Status Seeder...");

        const statusArr = [
            { id: 1, name: "Active", slug: "active" },
            { id: 2, name: "Inactive", slug: "inactive" },
            { id: 3, name: "Delete", slug: "delete" },
        ];

        // ✅ Use a transaction to ensure IDENTITY_INSERT applies correctly
        await prisma.$transaction(async (tx) => {
            for (const status of statusArr) {
                await findOrCreateStatus(status, tx);
            }
        });

        console.log("✅ Status seeder completed successfully.");
    } catch (error) {
        console.error("❌ Status seeder failed:", error);
    } finally {
        await prisma.$disconnect();
    }
}

async function findOrCreateStatus(status: any, tx: any) {
    try {
        let resData = await tx.status.findUnique({
            where: { id: status.id },
        });

        if (!resData) {
            await tx.$executeRawUnsafe(`SET IDENTITY_INSERT statuses ON; 
                INSERT INTO statuses (id, name, slug) 
                VALUES (${status.id}, '${status.name}', '${status.slug}'); 
                SET IDENTITY_INSERT statuses OFF;
            `);
            console.log(`✅ Status created successfully: ${status.name}`);
        } else {
            resData = await tx.status.update({
                where: { id: resData.id },
                data: {
                    name: status.name,
                    slug: status.slug,
                },
            });
            console.log(`🔄 Status updated successfully: ${resData.name}`);
        }

        return resData;
    } catch (error) {
        console.error(`❌ Status seeder failed: ${status.name}`, error);
        throw error;
    }
}
