import { PrismaClient } from '@prisma/pg/client';
const prisma = new PrismaClient();

const entityTypes = [
  {
    name: '2025-2026',
    code: '2025_2026',
    start_date: '2025-04-01',
    end_date: '2026-03-31',
    is_freezed: true,
  },
];

export async function AppFinancialYearSeeder(company_id: number) {
  try {
    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });
    for (const entityType of entityTypes) {
      await prisma.financialYear.upsert({
        where: { company_id_code: { company_id, code: entityType.code } },
        update: {
          ...entityType,
          updated_by: user?.id,
          start_date: new Date(entityType.start_date).toISOString(),
          end_date: new Date(entityType.end_date).toISOString(),
        },
        create: {
          ...entityType,
          company_id,
          created_by: user?.id,
          updated_by: user?.id,
          start_date: new Date(entityType.start_date).toISOString(),
          end_date: new Date(entityType.end_date).toISOString(),
        },
      });
      console.log(
        `Updated financialYear with code ${entityType.code}: ${entityType.name}`,
      );
    }
  } catch (error) {
    console.error(`Error in financialYearSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
