-- RedefineTables
PRAGMA foreign_keys=OFF;
CREATE TABLE "new_app_category_types" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "category_type_id" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "transfer_status" INTEGER DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    CONSTRAINT "app_category_types_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "app_category_types_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "app_category_types_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_app_category_types" ("category_type_id", "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "name", "transfer_status", "updated_at", "updated_by", "uuid") SELECT "category_type_id", "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "name", "transfer_status", "updated_at", "updated_by", "uuid" FROM "app_category_types";
DROP TABLE "app_category_types";
ALTER TABLE "new_app_category_types" RENAME TO "app_category_types";
CREATE UNIQUE INDEX "app_category_types_company_id_category_type_id_key" ON "app_category_types"("company_id", "category_type_id");
CREATE UNIQUE INDEX "app_category_types_company_id_id_key" ON "app_category_types"("company_id", "id");
CREATE UNIQUE INDEX "app_category_types_company_id_name_key" ON "app_category_types"("company_id", "name");
CREATE TABLE "new_users" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "username" TEXT NOT NULL,
    "email" TEXT NOT NULL,
    "email_verified" BOOLEAN NOT NULL DEFAULT false,
    "password" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "role" TEXT NOT NULL DEFAULT 'user',
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "last_login" DATETIME,
    "last_login_device" TEXT,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "users_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "users_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "users_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "users_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_users" ("company_id", "created_at", "created_by", "deleted_at", "deleted_by", "email", "email_verified", "id", "last_login", "last_login_device", "password", "role", "status_id", "transfer_status", "updated_at", "updated_by", "username", "uuid") SELECT "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "email", "email_verified", "id", "last_login", "last_login_device", "password", "role", "status_id", "transfer_status", "updated_at", "updated_by", "username", "uuid" FROM "users";
DROP TABLE "users";
ALTER TABLE "new_users" RENAME TO "users";
CREATE UNIQUE INDEX "users_company_id_uuid_key" ON "users"("company_id", "uuid");
CREATE UNIQUE INDEX "users_company_id_email_role_key" ON "users"("company_id", "email", "role");
CREATE UNIQUE INDEX "users_company_id_username_key" ON "users"("company_id", "username");
CREATE UNIQUE INDEX "users_company_id_id_key" ON "users"("company_id", "id");
CREATE TABLE "new_app_categories" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "category_type_id" TEXT NOT NULL,
    "category_id" TEXT NOT NULL,
    "parent_id" TEXT,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "app_categories_parent_id_fkey" FOREIGN KEY ("parent_id") REFERENCES "app_categories" ("category_id") ON DELETE SET NULL ON UPDATE CASCADE,
    CONSTRAINT "app_categories_category_type_id_company_id_fkey" FOREIGN KEY ("category_type_id", "company_id") REFERENCES "app_category_types" ("category_type_id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE,
    CONSTRAINT "app_categories_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "app_categories_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "app_categories_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_app_categories" ("category_id", "category_type_id", "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "name", "parent_id", "transfer_status", "updated_at", "updated_by", "uuid") SELECT "category_id", "category_type_id", "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "name", "parent_id", "transfer_status", "updated_at", "updated_by", "uuid" FROM "app_categories";
DROP TABLE "app_categories";
ALTER TABLE "new_app_categories" RENAME TO "app_categories";
CREATE UNIQUE INDEX "app_categories_category_id_key" ON "app_categories"("category_id");
CREATE UNIQUE INDEX "app_categories_company_id_category_id_key" ON "app_categories"("company_id", "category_id");
CREATE UNIQUE INDEX "app_categories_company_id_id_key" ON "app_categories"("company_id", "id");
CREATE UNIQUE INDEX "app_categories_company_id_name_key" ON "app_categories"("company_id", "name");
CREATE TABLE "new_menu_items" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "menu_id" INTEGER NOT NULL,
    "name" TEXT NOT NULL,
    "target" TEXT,
    "parent_id" INTEGER,
    "permission_id" INTEGER,
    "entity_id" INTEGER,
    "link_type" INTEGER,
    "order_no" DECIMAL NOT NULL DEFAULT 0,
    "menu_img" TEXT,
    "short_cut_keys" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "menu_items_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "menu_items_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE,
    CONSTRAINT "menu_items_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE,
    CONSTRAINT "menu_items_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE
);
INSERT INTO "new_menu_items" ("company_id", "created_at", "created_by", "deleted_at", "deleted_by", "entity_id", "id", "link_type", "menu_id", "menu_img", "name", "order_no", "parent_id", "permission_id", "short_cut_keys", "status_id", "target", "transfer_status", "updated_at", "updated_by") SELECT "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "entity_id", "id", "link_type", "menu_id", "menu_img", "name", "order_no", "parent_id", "permission_id", "short_cut_keys", "status_id", "target", "transfer_status", "updated_at", "updated_by" FROM "menu_items";
DROP TABLE "menu_items";
ALTER TABLE "new_menu_items" RENAME TO "menu_items";
CREATE UNIQUE INDEX "menu_items_company_id_id_key" ON "menu_items"("company_id", "id");
CREATE TABLE "new_menu_types" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "name" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "menu_types_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_menu_types" ("company_id", "created_at", "id", "name", "status_id", "transfer_status") SELECT "company_id", "created_at", "id", "name", "status_id", "transfer_status" FROM "menu_types";
DROP TABLE "menu_types";
ALTER TABLE "new_menu_types" RENAME TO "menu_types";
CREATE UNIQUE INDEX "menu_types_company_id_id_key" ON "menu_types"("company_id", "id");
CREATE TABLE "new_app_configurations" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "order_no" DECIMAL NOT NULL DEFAULT 0,
    "config_key" TEXT NOT NULL,
    "category_id" TEXT NOT NULL,
    "config_value" TEXT,
    "config_file_value" TEXT,
    "config_value_type" TEXT NOT NULL,
    "config_field_type" TEXT NOT NULL,
    "display_config" BOOLEAN NOT NULL DEFAULT true,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "app_configurations_category_id_company_id_fkey" FOREIGN KEY ("category_id", "company_id") REFERENCES "app_categories" ("category_id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE,
    CONSTRAINT "app_configurations_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "app_configurations_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "app_configurations_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_app_configurations" ("category_id", "company_id", "config_field_type", "config_file_value", "config_key", "config_value", "config_value_type", "created_at", "created_by", "deleted_at", "deleted_by", "display_config", "id", "order_no", "transfer_status", "updated_at", "updated_by", "uuid") SELECT "category_id", "company_id", "config_field_type", "config_file_value", "config_key", "config_value", "config_value_type", "created_at", "created_by", "deleted_at", "deleted_by", "display_config", "id", "order_no", "transfer_status", "updated_at", "updated_by", "uuid" FROM "app_configurations";
DROP TABLE "app_configurations";
ALTER TABLE "new_app_configurations" RENAME TO "app_configurations";
CREATE UNIQUE INDEX "app_configurations_company_id_id_key" ON "app_configurations"("company_id", "id");
CREATE UNIQUE INDEX "app_configurations_company_id_config_key_key" ON "app_configurations"("company_id", "config_key");
CREATE TABLE "new_master_entities" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "entity_name" TEXT NOT NULL,
    "entity_type" TEXT NOT NULL,
    "primary_table" TEXT,
    "associated_tables" TEXT,
    "query_information" TEXT,
    "form_information" TEXT,
    "add_query_information" TEXT,
    "edit_query_information" TEXT,
    "preset_query_information" TEXT,
    "static_page_content" TEXT,
    "dashboard_wizard_group_id" INTEGER,
    "dashboard_wizard_type" TEXT,
    "dashboard_wizard_rows" INTEGER,
    "dashboard_wizard_columns" INTEGER,
    "dashboard_wizard_order_no" DECIMAL DEFAULT 0,
    "dashboard_wizard_options" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "master_entities_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_master_entities" ("add_query_information", "associated_tables", "company_id", "created_at", "dashboard_wizard_columns", "dashboard_wizard_group_id", "dashboard_wizard_options", "dashboard_wizard_order_no", "dashboard_wizard_rows", "dashboard_wizard_type", "deleted_at", "edit_query_information", "entity_name", "entity_type", "form_information", "id", "name", "preset_query_information", "primary_table", "query_information", "static_page_content", "status_id", "transfer_status", "uuid") SELECT "add_query_information", "associated_tables", "company_id", "created_at", "dashboard_wizard_columns", "dashboard_wizard_group_id", "dashboard_wizard_options", "dashboard_wizard_order_no", "dashboard_wizard_rows", "dashboard_wizard_type", "deleted_at", "edit_query_information", "entity_name", "entity_type", "form_information", "id", "name", "preset_query_information", "primary_table", "query_information", "static_page_content", "status_id", "transfer_status", "uuid" FROM "master_entities";
DROP TABLE "master_entities";
ALTER TABLE "new_master_entities" RENAME TO "master_entities";
CREATE UNIQUE INDEX "master_entities_name_key" ON "master_entities"("name");
CREATE UNIQUE INDEX "master_entities_company_id_id_key" ON "master_entities"("company_id", "id");
CREATE UNIQUE INDEX "master_entities_company_id_entity_name_key" ON "master_entities"("company_id", "entity_name");
CREATE TABLE "new_menu" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "slug" TEXT,
    "description" TEXT,
    "menu_type" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER NOT NULL,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "menu_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "menu_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE,
    CONSTRAINT "menu_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE,
    CONSTRAINT "menu_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE
);
INSERT INTO "new_menu" ("company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "menu_type", "name", "slug", "status_id", "transfer_status", "updated_at", "updated_by", "uuid") SELECT "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "menu_type", "name", "slug", "status_id", "transfer_status", "updated_at", "updated_by", "uuid" FROM "menu";
DROP TABLE "menu";
ALTER TABLE "new_menu" RENAME TO "menu";
CREATE UNIQUE INDEX "menu_company_id_id_key" ON "menu"("company_id", "id");
CREATE UNIQUE INDEX "menu_company_id_uuid_key" ON "menu"("company_id", "uuid");
CREATE TABLE "new_user_details" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "user_id" INTEGER NOT NULL,
    "code" TEXT NOT NULL,
    "first_name" TEXT NOT NULL,
    "last_name" TEXT,
    "designation_id" INTEGER,
    "department_id" INTEGER,
    "profile_pic" TEXT,
    "dob" DATETIME,
    "country_code" TEXT,
    "phone_number" TEXT,
    "gender" TEXT DEFAULT 'male',
    "user_time_zone" TEXT,
    "address" TEXT,
    "culture" TEXT,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER NOT NULL,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "user_details_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_designation_id_fkey" FOREIGN KEY ("company_id", "designation_id") REFERENCES "designations" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_department_id_fkey" FOREIGN KEY ("company_id", "department_id") REFERENCES "departments" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_user_details" ("address", "code", "company_id", "country_code", "created_at", "created_by", "culture", "deleted_at", "deleted_by", "department_id", "designation_id", "dob", "first_name", "gender", "id", "last_name", "phone_number", "profile_pic", "transfer_status", "updated_at", "updated_by", "user_id", "user_time_zone") SELECT "address", "code", "company_id", "country_code", "created_at", "created_by", "culture", "deleted_at", "deleted_by", "department_id", "designation_id", "dob", "first_name", "gender", "id", "last_name", "phone_number", "profile_pic", "transfer_status", "updated_at", "updated_by", "user_id", "user_time_zone" FROM "user_details";
DROP TABLE "user_details";
ALTER TABLE "new_user_details" RENAME TO "user_details";
CREATE UNIQUE INDEX "user_details_company_id_user_id_key" ON "user_details"("company_id", "user_id");
CREATE TABLE "new_permissions" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "name" TEXT NOT NULL,
    "slug" TEXT NOT NULL,
    "entity_id" INTEGER,
    "order_no" DECIMAL NOT NULL DEFAULT 0,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "permissions_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "permissions_company_id_entity_id_fkey" FOREIGN KEY ("company_id", "entity_id") REFERENCES "master_entities" ("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE
);
INSERT INTO "new_permissions" ("company_id", "created_at", "entity_id", "id", "name", "order_no", "slug", "status_id", "transfer_status") SELECT "company_id", "created_at", "entity_id", "id", "name", "order_no", "slug", "status_id", "transfer_status" FROM "permissions";
DROP TABLE "permissions";
ALTER TABLE "new_permissions" RENAME TO "permissions";
CREATE INDEX "permissions_company_id_order_no_idx" ON "permissions"("company_id", "order_no");
CREATE UNIQUE INDEX "permissions_company_id_slug_key" ON "permissions"("company_id", "slug");
CREATE UNIQUE INDEX "permissions_company_id_id_key" ON "permissions"("company_id", "id");
CREATE TABLE "new_field_types" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "field_type" TEXT NOT NULL,
    "company_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "field_types_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_field_types" ("company_id", "created_at", "field_type", "id", "status_id", "transfer_status") SELECT "company_id", "created_at", "field_type", "id", "status_id", "transfer_status" FROM "field_types";
DROP TABLE "field_types";
ALTER TABLE "new_field_types" RENAME TO "field_types";
CREATE UNIQUE INDEX "field_types_company_id_id_key" ON "field_types"("company_id", "id");
CREATE TABLE "new_master_entity_line_items" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "master_grid_id" INTEGER NOT NULL,
    "field_name" TEXT NOT NULL,
    "display_name" TEXT NOT NULL,
    "width" INTEGER DEFAULT 0,
    "format" TEXT,
    "is_default" BOOLEAN NOT NULL DEFAULT true,
    "order_no" DECIMAL NOT NULL DEFAULT 0,
    "is_grid_column" BOOLEAN NOT NULL DEFAULT true,
    "is_searchable" BOOLEAN NOT NULL DEFAULT true,
    "is_sortable" BOOLEAN NOT NULL DEFAULT true,
    "field_type_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "master_entity_line_items_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "master_entity_line_items_company_id_master_grid_id_fkey" FOREIGN KEY ("company_id", "master_grid_id") REFERENCES "master_entities" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "master_entity_line_items_company_id_field_type_id_fkey" FOREIGN KEY ("company_id", "field_type_id") REFERENCES "field_types" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_master_entity_line_items" ("company_id", "created_at", "display_name", "field_name", "field_type_id", "format", "id", "is_default", "is_grid_column", "is_searchable", "is_sortable", "master_grid_id", "order_no", "status_id", "transfer_status", "width") SELECT "company_id", "created_at", "display_name", "field_name", "field_type_id", "format", "id", "is_default", "is_grid_column", "is_searchable", "is_sortable", "master_grid_id", "order_no", "status_id", "transfer_status", "width" FROM "master_entity_line_items";
DROP TABLE "master_entity_line_items";
ALTER TABLE "new_master_entity_line_items" RENAME TO "master_entity_line_items";
CREATE UNIQUE INDEX "master_entity_line_items_company_id_id_key" ON "master_entity_line_items"("company_id", "id");
CREATE UNIQUE INDEX "master_entity_line_items_company_id_master_grid_id_field_name_display_name_key" ON "master_entity_line_items"("company_id", "master_grid_id", "field_name", "display_name");
CREATE TABLE "new_roles" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "roles_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "roles_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "roles_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "roles_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_roles" ("company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "name", "status_id", "transfer_status", "updated_at", "updated_by", "uuid") SELECT "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "name", "status_id", "transfer_status", "updated_at", "updated_by", "uuid" FROM "roles";
DROP TABLE "roles";
ALTER TABLE "new_roles" RENAME TO "roles";
CREATE UNIQUE INDEX "roles_company_id_id_key" ON "roles"("company_id", "id");
CREATE UNIQUE INDEX "roles_company_id_uuid_key" ON "roles"("company_id", "uuid");
CREATE TABLE "new_designations" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "code" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "designations_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "designations_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "designations_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "designations_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_designations" ("code", "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "name", "status_id", "transfer_status", "updated_at", "updated_by", "uuid") SELECT "code", "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "description", "id", "name", "status_id", "transfer_status", "updated_at", "updated_by", "uuid" FROM "designations";
DROP TABLE "designations";
ALTER TABLE "new_designations" RENAME TO "designations";
CREATE UNIQUE INDEX "designations_company_id_id_key" ON "designations"("company_id", "id");
CREATE UNIQUE INDEX "designations_company_id_uuid_key" ON "designations"("company_id", "uuid");
CREATE TABLE "new_wizard_group" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "slug" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "company_id" INTEGER NOT NULL,
    "transfer_status" INTEGER DEFAULT 1
);
INSERT INTO "new_wizard_group" ("company_id", "created_at", "description", "id", "name", "slug", "status_id", "transfer_status", "uuid") SELECT "company_id", "created_at", "description", "id", "name", "slug", "status_id", "transfer_status", "uuid" FROM "wizard_group";
DROP TABLE "wizard_group";
ALTER TABLE "new_wizard_group" RENAME TO "wizard_group";
CREATE UNIQUE INDEX "wizard_group_company_id_id_key" ON "wizard_group"("company_id", "id");
CREATE UNIQUE INDEX "wizard_group_company_id_slug_key" ON "wizard_group"("company_id", "slug");
CREATE TABLE "new_departments" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "code" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "department_head_id" INTEGER,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "departments_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "departments_company_id_department_head_id_fkey" FOREIGN KEY ("company_id", "department_head_id") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "departments_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "departments_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "departments_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);
INSERT INTO "new_departments" ("code", "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "department_head_id", "description", "id", "name", "status_id", "transfer_status", "updated_at", "updated_by", "uuid") SELECT "code", "company_id", "created_at", "created_by", "deleted_at", "deleted_by", "department_head_id", "description", "id", "name", "status_id", "transfer_status", "updated_at", "updated_by", "uuid" FROM "departments";
DROP TABLE "departments";
ALTER TABLE "new_departments" RENAME TO "departments";
CREATE UNIQUE INDEX "departments_company_id_id_key" ON "departments"("company_id", "id");
CREATE UNIQUE INDEX "departments_company_id_uuid_key" ON "departments"("company_id", "uuid");
PRAGMA foreign_key_check("app_category_types");
PRAGMA foreign_key_check("users");
PRAGMA foreign_key_check("app_categories");
PRAGMA foreign_key_check("menu_items");
PRAGMA foreign_key_check("menu_types");
PRAGMA foreign_key_check("app_configurations");
PRAGMA foreign_key_check("master_entities");
PRAGMA foreign_key_check("menu");
PRAGMA foreign_key_check("user_details");
PRAGMA foreign_key_check("permissions");
PRAGMA foreign_key_check("field_types");
PRAGMA foreign_key_check("master_entity_line_items");
PRAGMA foreign_key_check("roles");
PRAGMA foreign_key_check("designations");
PRAGMA foreign_key_check("wizard_group");
PRAGMA foreign_key_check("departments");
PRAGMA foreign_keys=ON;
