import { PrismaClient } from '@prisma/sql/client'

const prisma = new PrismaClient();

const entityTypes = [
  {
    id: 1,
    name: 'MasterListComponent',
    slug: 'grid_builder_module',
    description: 'Grid Builder Module',
  },
  {
    id: 2,
    name: 'FormBuilderComponent',
    slug: 'form_builder_module',
    description: 'Form Builder Module',
  },
  {
    id: 3,
    name: 'StaticPageComponent',
    slug: 'static_page_builder_module',
    description: 'Static Page Builder Module',
  },
  {
    id: 4,
    name: 'EntityUserRoleMappingComponent',
    slug: 'entity_user_role_map_module',
    description: 'Entity User/Role Map Module',
  },
  {
    id: 5,
    name: 'MenuMappingComponent',
    slug: 'menu_module',
    description: 'Menu Module',
  },
  {
    id: 6,
    name: 'ImportMasterComponent',
    slug: 'import_module',
    description: 'Import Module',
  },
  {
    id: 7,
    name: 'MasterEntityComponent',
    slug: 'entity_form_module',
    description: 'Entity Add / Edit Form Module',
  },
];

export async function entityTypeSeeder(company_id: number) {
  try {
    console.log("🚀 Starting EntityType Seeder...");

    // ✅ Run all inserts in a single transaction
    await prisma.$transaction(async (tx) => {

      for (const entityType of entityTypes) {
        const existingEntity = await tx.entityType.findUnique({
          where: { id: entityType.id },
        });

        if (!existingEntity) {
          // ✅ Use raw SQL for inserting records
          await tx.$executeRawUnsafe(` SET IDENTITY_INSERT entity_types ON;
            INSERT INTO entity_types (id, name, slug, description, company_id) 
            VALUES (${entityType.id}, '${entityType.name}', '${entityType.slug}', '${entityType.description}', ${company_id});
            SET IDENTITY_INSERT entity_types OFF;
          `);
          console.log(`✅ Created EntityType with id ${entityType.id}: ${entityType.name}`);
        } else {
          console.log(`🔄 EntityType with id ${entityType.id} already exists.`);
        }
      }
    });

    console.log("✅ EntityType seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Error in entityTypeSeeder: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
