import { PrismaClient } from '@prisma/pg/client';
import { v4 as uuidv4 } from 'uuid';

const prisma = new PrismaClient();

function getCurrentUtcTime() {
  return new Date().toISOString();
}

export async function aboutLCPSeeder(company_id: number) {
  try {

    // Fetch the super_admin user
    const user = await prisma.user.findFirst({
      where: { company_id, role: 'super_admin' },
    });

    if (!user) {
      console.log(
        `AboutLCP seeder failed: admin user not available for company id ${company_id}`,
      );
      return false;
    }

    const createdBy = user.id;

    // Sample AboutLCP data
    const aboutLCPs = [
      {
        type: 'lcp',
        name: 'LCP trial video',
        description: 'LCP trial video.',
        order_no:1,
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EV5kDzlBk3dDttyCvlG0mcYBoiXSRbtXUTN_Gh7b-ae65g?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=ljiOZi',
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'LCP introduction',
        description: 'LCP introduction.',
        order_no:2,
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EYE6WHBz_0tMjLUtY6awjIMBgLQGYqSh6acywUALoi6nSA?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=C0qGBt',
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Cron settings',
        description: 'LCP - Dynamic Cron settings.',
        order_no:3,
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/ETtJGwY5HOhLrL6f5U9UrJ8BVhC7fzBHI4afY5QeH6p_zw?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=p8JTfd',
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'App version',
        description: 'LCP - App version maintain document video.',
        order_no:4,
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/ET3CpjhBw01Kt6IDVcm4sT4Bl6TCw4yWqXTFGOPJuGfCGw?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=BvFY9H',
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Document preparation',
        description: 'LCP - Document How to maintain document preparation video.',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EZ5-1_ujT0tJoEkndvEIOggBpkflaGOPIQUM_GwDePNwEQ?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=AR9T8U',
        order_no:5,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Menu Mapping',
        description: 'LCP - No code - Menu mapping with document video.',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/ERYJKjAlXiNFrfJPvhE-c7cBx7RRYggVdG_dCgNw1CjUlQ?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=Z1PKXA',
        order_no:6,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Child menu',
        description: 'LCP - No-code child menu platform utilizing document video.',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EdWdVjulyXtBgZk1x7lN7fcBDRGCiugGG9E3X3RAACh4Ng?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=V8jEgy',
        order_no:6.1,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Grid builder',
        description: 'LCP - Grid builder setup document video.',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EaaUazUGeQJPiSL9p6FjMPAB4tRqhk68XfZ8rgMYpkcQIQ?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=qAmMp8',
        order_no:7,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Grid builder using SQL query',
        description: 'LCP - Grid builder using SQL query.',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/Eed6FDfNE29BrOyuWqujADABFPYzszr9Dg4vyi93qaEOQg?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=bBcuej',
        order_no:7.1,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Form builder',
        description: 'LCP - Form builder.',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EXVuUME_6tpHteiqasgtXFwB-slQFUKaEgXzZOinzQupUQ?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=TQ2bDN',
        order_no:8,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Form information - Form builder',
        description: 'LCP - Form builder - Form information',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EcxeyQY38jJEov1uSIhQwnUBez2_ObWwmOTWKVZDWN3y_w?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=pJX3F5',
        order_no:8.1,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Query information - Form builder',
        description: 'LCP - Form builder - Query information',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EQOJG_6XmCRFkbgV4qxz26QBhX77bAq8p22f1CI9lPqM4Q?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=aNieVa',
        order_no:8.2,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Add JSON structure - Form builder',
        description: 'LCP - Form builder - Add JSON structure',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EZAv1uUpOqJAkMlCEozGqvMBXNal_xBvq2Gd2_wWZzVriA?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=MP3cgu',
        order_no:8.3,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Preset JSON structure - Form builder',
        description: 'LCP - Form builder - Preset JSON structure',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EVD1YYVGS_RJjMERVESPi-kBafodrT6CvbZI2O6R1Xo1HA?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=MaKSVh',
        order_no:8.4,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Edit JSON structure - Form builder',
        description: 'LCP - Form builder - Edit JSON structure',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EdFTP4jOP7hKi_lUeP2EwbQBSfvPbCBFqfP0PE1rzmhzZg?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=WShhcf',
        order_no:8.5,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Details screen - Page builder',
        description: 'LCP - Page builder - Static page details screen',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EfUEaNm4erhLoepB7zVEQKsBnYvUo7wKr2mbNvpKTYmodQ?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=vLVCTa',
        order_no:9,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'Query information and Static page content - Page builder',
        description: 'LCP - Page builder - Static page details screen wiht query information and static page content document',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EdrnKVDsYxJGtYiA5maIyg0BrJkc8Rf9s9nGPuhmC8i6CA?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=Py6RWd',
        order_no:9.1,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'LCP - Job builder',
        description: 'LCP - Job builder - Records delete document video',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/Ea0oihsO7ntAi3UJTV0xDU4BYY_flV3kIkSN-NYu1_n8vw?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=qusQ12',
        order_no:10,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'LCP - Policy settings',
        description: 'LCP - Policy setting document video',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/ET8HYkuPmCBFjwHHJ_aia3UBCetrmVZWha4PKuRzXbASHA?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=Ow5gKP',
        order_no:11,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'LCP - Approval workflow',
        description: 'LCP - Approval workflow and assignment document video',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EfI_RHBH4HZCmgHcvLYvXRoBMbBNLepNT2WslAS_aawyMw?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=dQ0nh2',
        order_no:12,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'LCP - Approval request',
        description: 'LCP - Approval request document video',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EQQzQC0QW1ZNmgamSRzkXzcBIVbrov8TYpaxu6PZzVo0gg?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=rPxCuy',
        order_no:12.1,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'LCP - Delegation request',
        description: 'LCP - Delegation request approval document video',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EZMSa3eTiNpFgoBko2AqtTEBNbUWDfTeMjnO54D0rUrWKg?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=Y3Oj6i',
        order_no:12.2,
        documentation_pdf: '',
        documentation_word: ''
      },
      {
        type: 'lcp',
        name: 'LCP - Predefined custom approval tags',
        description: 'LCP - Predefined custom user tags document video',
        documentation_video_url: 'https://techcedenceinfosystems-my.sharepoint.com/:v:/g/personal/learning_techcedence_com/EQ9IvEnCXfVBriQqHro97IcBqxjKQ2kBDgWBCqcNkiwK0Q?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=vKGIJU',
        order_no:12.3,
        documentation_pdf: '',
        documentation_word: ''
      },
    ];

    for (const aboutLCP of aboutLCPs) {
      await createOrUpdateAboutLCP(company_id, aboutLCP,createdBy);
    }

    console.log('AboutLCP seeder executed successfully.');
  } catch (error) {
    console.error(`Error in aboutLCPSeeder: ${error}`);
    throw error;
  }
}

async function createOrUpdateAboutLCP(
  company_id: number,
  data: any,
  createdBy:any
) {

  const utcNow = getCurrentUtcTime();

  const existing = await prisma.aboutLCP.findFirst({
    where: {
      company_id,
      name: data.name,
    },
  });

  if (!existing) {
    const newAbout = await prisma.aboutLCP.create({
      data: {
        ...data,
        company_id,
        created_by:createdBy,
        created_at:utcNow
      },
    });

    console.log(`AboutLCP created: ${newAbout.name}`);
  } else {
    await prisma.aboutLCP.update({
      where: { id: existing.id },
      data: {
        ...data
      },
    });

    console.log(`AboutLCP updated: ${existing.name}`);
  }
}
