CREATE OR REPLACE FUNCTION replace_values(
  input_json JSONB
)
RETURNS JSONB AS $$
DECLARE
  placeholder TEXT;
  value_json JSONB;
  resolved_value JSONB;
BEGIN
  -- Extract the input parameters
  placeholder := input_json ->> 'placeholder';
  value_json := input_json -> 'value_json';

  BEGIN
    -- Try to get the value corresponding to the placeholder in value_json
    resolved_value := value_json -> placeholder;

    -- If the placeholder is found in value_json, return it
    IF resolved_value IS NOT NULL THEN
      RETURN jsonb_build_object('value', resolved_value);
    ELSE
      -- If not found, return the placeholder itself
      RETURN jsonb_build_object('value', placeholder);
    END IF;

  EXCEPTION
    WHEN OTHERS THEN
      -- If any error occurs, return the placeholder as value
      RETURN jsonb_build_object('value', placeholder);
  END;
END;
$$ LANGUAGE plpgsql;