-- CreateEnum
CREATE TYPE "UserRole" AS ENUM ('super_admin', 'company_admin', 'admin', 'user');

-- CreateEnum
CREATE TYPE "Gender" AS ENUM ('male', 'female', 'others');

-- CreateEnum
CREATE TYPE "OtpPurpose" AS ENUM ('login', 'password_reset', 'verify_email', 'others');

-- CreateEnum
CREATE TYPE "RecipientType" AS ENUM ('tag', 'user_id', 'custom');

-- CreateEnum
CREATE TYPE "NotifyType" AS ENUM ('email', 'push');

-- CreateTable
CREATE TABLE "users" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "username" VARCHAR(100) NOT NULL,
    "email" VARCHAR(100) NOT NULL,
    "email_verified" BOOLEAN NOT NULL DEFAULT false,
    "password" VARCHAR(255),
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "role" "UserRole" NOT NULL DEFAULT 'user',
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,
    "last_login" TIMESTAMPTZ,
    "last_login_device" VARCHAR(100),

    CONSTRAINT "users_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "user_details" (
    "id" SERIAL NOT NULL,
    "user_id" INTEGER NOT NULL,
    "code" VARCHAR(100) NOT NULL,
    "first_name" VARCHAR(100) NOT NULL,
    "last_name" VARCHAR(100),
    "designation_id" INTEGER,
    "department_id" INTEGER,
    "profile_pic" VARCHAR(255),
    "dob" DATE,
    "country_code" VARCHAR(100),
    "phone_number" VARCHAR(100),
    "gender" "Gender" NOT NULL DEFAULT 'male',
    "user_time_zone" VARCHAR(100),
    "address" VARCHAR(255),
    "culture" VARCHAR(100),
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "user_details_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "designations" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "code" VARCHAR(100) NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "designations_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "departments" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "code" VARCHAR(100) NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "department_head_id" INTEGER,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "departments_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "request_logs" (
    "id" BIGSERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "user_id" INTEGER,
    "req_method" VARCHAR(100),
    "req_url" VARCHAR(255),
    "req_body" TEXT,
    "res_status" BOOLEAN NOT NULL DEFAULT false,
    "res_code" INTEGER NOT NULL DEFAULT 500,
    "res_message" TEXT,
    "req_response" TEXT,
    "req_headers" TEXT,
    "req_ip" VARCHAR(255),
    "req_device" VARCHAR(255),
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "request_logs_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "financial_years" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "code" VARCHAR(100) NOT NULL,
    "is_freezed" BOOLEAN NOT NULL DEFAULT false,
    "start_date" TIMESTAMPTZ NOT NULL,
    "end_date" TIMESTAMPTZ NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "financial_years_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "document_sequences" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "module_name" VARCHAR(100) NOT NULL,
    "financial_year_id" INTEGER,
    "current_sequence_no" INTEGER NOT NULL DEFAULT 0,
    "start_sequence_no" INTEGER NOT NULL DEFAULT 0,
    "end_sequence_no" INTEGER NOT NULL DEFAULT 0,
    "sequence_length" INTEGER NOT NULL DEFAULT 6,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "code_format" VARCHAR(100),
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "document_sequences_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "audit_logs" (
    "id" SERIAL NOT NULL,
    "operation_type" VARCHAR(10) NOT NULL,
    "table_name" VARCHAR(100) NOT NULL,
    "field_name" VARCHAR(100) NOT NULL,
    "old_value" TEXT,
    "new_value" TEXT,
    "entity_id" INTEGER NOT NULL,
    "user_id" INTEGER,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "audit_logs_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "permissions" (
    "id" SERIAL NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "slug" VARCHAR(100) NOT NULL,
    "entity_id" INTEGER,
    "order_no" DECIMAL(4,2) NOT NULL DEFAULT 0,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "permissions_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "roles" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "roles_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "role_permissions" (
    "role_id" INTEGER NOT NULL,
    "permission_id" INTEGER NOT NULL,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "role_permissions_pkey" PRIMARY KEY ("company_id","role_id","permission_id")
);

-- CreateTable
CREATE TABLE "user_roles" (
    "user_id" INTEGER NOT NULL,
    "role_id" INTEGER NOT NULL,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "user_roles_pkey" PRIMARY KEY ("company_id","user_id","role_id")
);

-- CreateTable
CREATE TABLE "user_permissions" (
    "user_id" INTEGER NOT NULL,
    "permission_id" INTEGER NOT NULL,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "user_permissions_pkey" PRIMARY KEY ("company_id","user_id","permission_id")
);

-- CreateTable
CREATE TABLE "otps" (
    "id" SERIAL NOT NULL,
    "user_id" INTEGER NOT NULL,
    "otp" VARCHAR(8) NOT NULL,
    "purpose" "OtpPurpose" NOT NULL,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "otps_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "languages" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "name_in_english" VARCHAR(100),
    "flag" VARCHAR(10),
    "code" VARCHAR(10),
    "rtl" BOOLEAN NOT NULL DEFAULT false,
    "description" TEXT NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "languages_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "language_contents" (
    "id" SERIAL NOT NULL,
    "language_id" INTEGER NOT NULL DEFAULT 1,
    "key_content" VARCHAR(100) NOT NULL,
    "values" VARCHAR(100) NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "language_contents_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "menu" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "slug" VARCHAR(255),
    "description" VARCHAR(100),
    "menu_type" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "menu_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "menu_items" (
    "id" SERIAL NOT NULL,
    "menu_id" INTEGER NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "target" VARCHAR(255),
    "parent_id" INTEGER,
    "permission_id" INTEGER,
    "entity_id" INTEGER,
    "link_type" INTEGER,
    "order_no" DECIMAL(4,2) NOT NULL DEFAULT 0,
    "menu_img" VARCHAR(255),
    "short_cut_keys" VARCHAR(255),
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "menu_items_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "action_types" (
    "id" SERIAL NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "description" VARCHAR(255) NOT NULL,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "action_types_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "entity_types" (
    "id" SERIAL NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "slug" VARCHAR(100) NOT NULL,
    "description" VARCHAR(255) NOT NULL,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "entity_types_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "wizard_group" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "slug" VARCHAR(100) NOT NULL,
    "description" VARCHAR(100),
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "wizard_group_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "wizard_types" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "description" VARCHAR(100) NOT NULL,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "wizard_types_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "master_entities" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "entity_name" VARCHAR(100) NOT NULL,
    "entity_type" VARCHAR(100) NOT NULL,
    "primary_table" VARCHAR(100),
    "is_admin_module" BOOLEAN NOT NULL DEFAULT false,
    "associated_tables" JSONB,
    "query_information" JSONB,
    "form_information" JSONB,
    "add_query_information" JSONB,
    "edit_query_information" JSONB,
    "preset_query_information" JSONB,
    "static_page_content" TEXT,
    "dashboard_wizard_group_id" INTEGER,
    "dashboard_wizard_type" VARCHAR(100),
    "dashboard_wizard_rows" INTEGER,
    "dashboard_wizard_columns" INTEGER,
    "dashboard_wizard_order_no" DECIMAL(4,2) DEFAULT 0,
    "dashboard_wizard_options" JSONB,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "master_entities_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "master_entity_line_items" (
    "id" SERIAL NOT NULL,
    "master_grid_id" INTEGER NOT NULL,
    "field_name" VARCHAR(255) NOT NULL,
    "display_name" VARCHAR(100) NOT NULL,
    "width" INTEGER DEFAULT 0,
    "format" VARCHAR(100),
    "is_default" BOOLEAN NOT NULL DEFAULT true,
    "order_no" DECIMAL(4,2) NOT NULL DEFAULT 0,
    "is_grid_column" BOOLEAN NOT NULL DEFAULT true,
    "is_searchable" BOOLEAN NOT NULL DEFAULT true,
    "is_sortable" BOOLEAN NOT NULL DEFAULT true,
    "field_type_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "master_entity_line_items_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "field_types" (
    "id" SERIAL NOT NULL,
    "field_type" VARCHAR(100) NOT NULL,
    "company_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "field_types_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "menu_types" (
    "id" SERIAL NOT NULL,
    "name" VARCHAR(100),
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "menu_types_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "email_template_process" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "slug" VARCHAR(100) NOT NULL,
    "query_information" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "email_template_process_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "email_template_tags" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "slug" VARCHAR(100) NOT NULL,
    "name" VARCHAR(100),
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "email_template_tags_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "email_template_recipient_tags" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "slug" VARCHAR(100) NOT NULL,
    "name" VARCHAR(100),
    "description" TEXT,
    "query_information" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "email_template_recipient_tags_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "email_template_process_tags_mapping" (
    "email_template_process_id" INTEGER NOT NULL,
    "email_template_tag_id" INTEGER NOT NULL,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "email_template_process_tags_mapping_pkey" PRIMARY KEY ("email_template_process_id","email_template_tag_id","company_id")
);

-- CreateTable
CREATE TABLE "email_templates" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "slug" VARCHAR(100) NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "subject" VARCHAR(255) NOT NULL,
    "template_body" TEXT NOT NULL,
    "email_template_process_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "created_by" INTEGER,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_by" INTEGER,
    "deleted_at" TIMESTAMPTZ,
    "deleted_by" INTEGER,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "email_templates_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "email_template_assignments" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "email_template_process_id" INTEGER NOT NULL,
    "template_id" INTEGER NOT NULL,
    "recipient_type" "RecipientType" NOT NULL DEFAULT 'tag',
    "email_to" VARCHAR(100),
    "mail_cc" TEXT,
    "mail_bcc" TEXT,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "created_by" INTEGER NOT NULL,

    CONSTRAINT "email_template_assignments_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "email_process_jobs" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "email_template_process_slug" VARCHAR(100) NOT NULL,
    "unique_id" VARCHAR(100) NOT NULL,
    "user_id" VARCHAR(100) NOT NULL,
    "prefill_data" TEXT,
    "company_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "created_by" INTEGER,

    CONSTRAINT "email_process_jobs_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "notification_jobs" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "process_slug" VARCHAR(100) NOT NULL,
    "notification_to" TEXT,
    "notification_subject" VARCHAR(100),
    "notification_content" TEXT,
    "notification_cc" VARCHAR(100),
    "notification_bcc" VARCHAR(100),
    "notification_type_id" VARCHAR(10) NOT NULL,
    "notification_status_id" VARCHAR(10) NOT NULL,
    "company_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "created_by" INTEGER,

    CONSTRAINT "notification_jobs_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "import_templates" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "name" VARCHAR(100) NOT NULL,
    "slug" VARCHAR(100) NOT NULL,
    "description" VARCHAR(100),
    "primary_table" VARCHAR(100) NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_by" INTEGER,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_by" INTEGER,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "import_templates_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "import_template_line_items" (
    "id" SERIAL NOT NULL,
    "import_template_id" INTEGER NOT NULL,
    "field_name" VARCHAR(255) NOT NULL,
    "display_name" VARCHAR(100) NOT NULL,
    "order_no" DECIMAL(4,2) NOT NULL DEFAULT 0,
    "width" INTEGER DEFAULT 0,
    "default_value" VARCHAR(100),
    "is_nullable" BOOLEAN NOT NULL DEFAULT true,
    "is_unique" BOOLEAN NOT NULL DEFAULT false,
    "is_foreign" BOOLEAN NOT NULL DEFAULT false,
    "is_enum" BOOLEAN NOT NULL DEFAULT false,
    "enum_values" VARCHAR(100),
    "foreign_table" VARCHAR(100),
    "foreign_column" VARCHAR(100),
    "foreign_create_data" JSONB,
    "foreign_can_create" BOOLEAN NOT NULL DEFAULT false,
    "field_type_id" INTEGER,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "import_template_line_items_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "statuses" (
    "id" SERIAL NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "slug" VARCHAR(100) NOT NULL,
    "description" TEXT,
    "status_id" INTEGER DEFAULT 1,

    CONSTRAINT "statuses_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "app_category_types" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "category_type_id" VARCHAR(10) NOT NULL,
    "name" VARCHAR(100) NOT NULL,
    "description" VARCHAR(255),
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "app_category_types_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "app_categories" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "category_type_id" VARCHAR(10) NOT NULL,
    "category_id" VARCHAR(10) NOT NULL,
    "parent_id" VARCHAR(10),
    "name" VARCHAR(100) NOT NULL,
    "description" VARCHAR(255),
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "app_categories_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "app_configurations" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "order_no" DECIMAL(4,2) NOT NULL DEFAULT 0,
    "config_key" VARCHAR(100) NOT NULL,
    "category_id" VARCHAR(10) NOT NULL,
    "config_value" VARCHAR(255),
    "config_file_value" TEXT,
    "config_value_type" VARCHAR(100) NOT NULL,
    "config_field_type" VARCHAR(100) NOT NULL,
    "display_config" BOOLEAN NOT NULL DEFAULT true,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMPTZ DEFAULT CURRENT_TIMESTAMP,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "app_configurations_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "file_upload_logs" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "doc_name" VARCHAR(255),
    "org_name" VARCHAR(255),
    "extension" VARCHAR(100),
    "description" VARCHAR(100),
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "file_upload_logs_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "data_transfer_queries" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "select_query" TEXT NOT NULL,
    "insert_query" TEXT NOT NULL,
    "transfer_type" TEXT NOT NULL,
    "job_name" TEXT NOT NULL,
    "destination_table" TEXT NOT NULL,
    "clear_destination_table" BOOLEAN NOT NULL,
    "execution_order" INTEGER NOT NULL,
    "command_type" TEXT NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_by" INTEGER,
    "created_at" TIMESTAMP(3) DEFAULT CURRENT_TIMESTAMP,
    "company_id" INTEGER NOT NULL,

    CONSTRAINT "data_transfer_queries_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "device_registration" (
    "id" SERIAL NOT NULL,
    "uuid" UUID NOT NULL DEFAULT uuid_generate_v4(),
    "company_id" INTEGER NOT NULL,
    "device_name" VARCHAR(255) NOT NULL,
    "device_unique_id" VARCHAR(255) NOT NULL,
    "user_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_by" INTEGER NOT NULL,
    "created_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_by" INTEGER,
    "updated_at" TIMESTAMPTZ NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "deleted_by" INTEGER,
    "deleted_at" TIMESTAMPTZ,

    CONSTRAINT "device_registration_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "users_company_id_uuid_key" ON "users"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "users_company_id_email_role_key" ON "users"("company_id", "email", "role");

-- CreateIndex
CREATE UNIQUE INDEX "users_company_id_username_key" ON "users"("company_id", "username");

-- CreateIndex
CREATE UNIQUE INDEX "users_company_id_id_key" ON "users"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "user_details_company_id_user_id_key" ON "user_details"("company_id", "user_id");

-- CreateIndex
CREATE UNIQUE INDEX "designations_company_id_id_key" ON "designations"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "designations_company_id_uuid_key" ON "designations"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "departments_company_id_id_key" ON "departments"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "departments_company_id_uuid_key" ON "departments"("company_id", "uuid");

-- CreateIndex
CREATE INDEX "request_logs_company_id_idx" ON "request_logs"("company_id");

-- CreateIndex
CREATE UNIQUE INDEX "financial_years_company_id_id_key" ON "financial_years"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "financial_years_company_id_uuid_key" ON "financial_years"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "financial_years_company_id_code_key" ON "financial_years"("company_id", "code");

-- CreateIndex
CREATE UNIQUE INDEX "document_sequences_company_id_id_key" ON "document_sequences"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "document_sequences_company_id_uuid_key" ON "document_sequences"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "document_sequences_company_id_financial_year_id_module_name_key" ON "document_sequences"("company_id", "financial_year_id", "module_name");

-- CreateIndex
CREATE UNIQUE INDEX "audit_logs_company_id_id_key" ON "audit_logs"("company_id", "id");

-- CreateIndex
CREATE INDEX "permissions_company_id_order_no_idx" ON "permissions"("company_id", "order_no");

-- CreateIndex
CREATE UNIQUE INDEX "permissions_company_id_slug_key" ON "permissions"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "permissions_company_id_id_key" ON "permissions"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "roles_company_id_id_key" ON "roles"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "roles_company_id_uuid_key" ON "roles"("company_id", "uuid");

-- CreateIndex
CREATE INDEX "otps_company_id_user_id_purpose_idx" ON "otps"("company_id", "user_id", "purpose");

-- CreateIndex
CREATE UNIQUE INDEX "languages_company_id_id_key" ON "languages"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "languages_company_id_uuid_key" ON "languages"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "languages_company_id_code_key" ON "languages"("company_id", "code");

-- CreateIndex
CREATE UNIQUE INDEX "language_contents_company_id_id_key" ON "language_contents"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "menu_company_id_id_key" ON "menu"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "menu_company_id_uuid_key" ON "menu"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "menu_items_company_id_id_key" ON "menu_items"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "action_types_company_id_id_key" ON "action_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "entity_types_company_id_id_key" ON "entity_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "wizard_group_company_id_id_key" ON "wizard_group"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "wizard_group_company_id_slug_key" ON "wizard_group"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "wizard_types_company_id_id_key" ON "wizard_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "wizard_types_company_id_name_key" ON "wizard_types"("company_id", "name");

-- CreateIndex
CREATE UNIQUE INDEX "master_entities_company_id_id_key" ON "master_entities"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "master_entities_company_id_entity_name_key" ON "master_entities"("company_id", "entity_name");

-- CreateIndex
CREATE UNIQUE INDEX "master_entity_line_items_company_id_id_key" ON "master_entity_line_items"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "master_entity_line_items_company_id_master_grid_id_field_na_key" ON "master_entity_line_items"("company_id", "master_grid_id", "field_name", "display_name");

-- CreateIndex
CREATE UNIQUE INDEX "field_types_company_id_id_key" ON "field_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "menu_types_company_id_id_key" ON "menu_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "email_template_process_company_id_id_key" ON "email_template_process"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "email_template_process_company_id_slug_key" ON "email_template_process"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "email_template_process_id_company_id_key" ON "email_template_process"("id", "company_id");

-- CreateIndex
CREATE UNIQUE INDEX "email_template_tags_company_id_id_key" ON "email_template_tags"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "email_template_tags_company_id_slug_key" ON "email_template_tags"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "email_template_recipient_tags_company_id_id_key" ON "email_template_recipient_tags"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "email_template_recipient_tags_company_id_slug_key" ON "email_template_recipient_tags"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "email_templates_company_id_id_key" ON "email_templates"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "email_templates_company_id_slug_key" ON "email_templates"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "import_templates_company_id_id_key" ON "import_templates"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "import_templates_company_id_slug_key" ON "import_templates"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "import_template_line_items_company_id_id_key" ON "import_template_line_items"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "import_template_line_items_company_id_field_name_display_na_key" ON "import_template_line_items"("company_id", "field_name", "display_name");

-- CreateIndex
CREATE UNIQUE INDEX "statuses_id_key" ON "statuses"("id");

-- CreateIndex
CREATE UNIQUE INDEX "statuses_slug_key" ON "statuses"("slug");

-- CreateIndex
CREATE UNIQUE INDEX "app_category_types_category_type_id_key" ON "app_category_types"("category_type_id");

-- CreateIndex
CREATE UNIQUE INDEX "app_category_types_company_id_category_type_id_key" ON "app_category_types"("company_id", "category_type_id");

-- CreateIndex
CREATE UNIQUE INDEX "app_category_types_company_id_id_key" ON "app_category_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "app_category_types_company_id_name_key" ON "app_category_types"("company_id", "name");

-- CreateIndex
CREATE UNIQUE INDEX "app_categories_category_id_key" ON "app_categories"("category_id");

-- CreateIndex
CREATE UNIQUE INDEX "app_categories_company_id_category_id_key" ON "app_categories"("company_id", "category_id");

-- CreateIndex
CREATE UNIQUE INDEX "app_categories_company_id_id_key" ON "app_categories"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "app_categories_company_id_name_key" ON "app_categories"("company_id", "name");

-- CreateIndex
CREATE UNIQUE INDEX "app_configurations_company_id_id_key" ON "app_configurations"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "app_configurations_company_id_config_key_key" ON "app_configurations"("company_id", "config_key");

-- CreateIndex
CREATE UNIQUE INDEX "file_upload_logs_company_id_id_key" ON "file_upload_logs"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "data_transfer_queries_company_id_id_key" ON "data_transfer_queries"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "device_registration_company_id_id_key" ON "device_registration"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "device_registration_company_id_uuid_key" ON "device_registration"("company_id", "uuid");

-- AddForeignKey
ALTER TABLE "users" ADD CONSTRAINT "users_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "users" ADD CONSTRAINT "users_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "users" ADD CONSTRAINT "users_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "users" ADD CONSTRAINT "users_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_details" ADD CONSTRAINT "user_details_company_id_designation_id_fkey" FOREIGN KEY ("company_id", "designation_id") REFERENCES "designations"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_details" ADD CONSTRAINT "user_details_company_id_department_id_fkey" FOREIGN KEY ("company_id", "department_id") REFERENCES "departments"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_details" ADD CONSTRAINT "user_details_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_details" ADD CONSTRAINT "user_details_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_details" ADD CONSTRAINT "user_details_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_details" ADD CONSTRAINT "user_details_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "designations" ADD CONSTRAINT "designations_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "designations" ADD CONSTRAINT "designations_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "designations" ADD CONSTRAINT "designations_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "designations" ADD CONSTRAINT "designations_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "departments" ADD CONSTRAINT "departments_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "departments" ADD CONSTRAINT "departments_company_id_department_head_id_fkey" FOREIGN KEY ("company_id", "department_head_id") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "departments" ADD CONSTRAINT "departments_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "departments" ADD CONSTRAINT "departments_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "departments" ADD CONSTRAINT "departments_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "request_logs" ADD CONSTRAINT "request_logs_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "request_logs" ADD CONSTRAINT "request_logs_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "financial_years" ADD CONSTRAINT "financial_years_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "financial_years" ADD CONSTRAINT "financial_years_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "financial_years" ADD CONSTRAINT "financial_years_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "financial_years" ADD CONSTRAINT "financial_years_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "document_sequences" ADD CONSTRAINT "document_sequences_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "document_sequences" ADD CONSTRAINT "document_sequences_company_id_financial_year_id_fkey" FOREIGN KEY ("company_id", "financial_year_id") REFERENCES "financial_years"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "document_sequences" ADD CONSTRAINT "document_sequences_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "document_sequences" ADD CONSTRAINT "document_sequences_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "document_sequences" ADD CONSTRAINT "document_sequences_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "audit_logs" ADD CONSTRAINT "audit_logs_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "audit_logs" ADD CONSTRAINT "audit_logs_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "users"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "permissions" ADD CONSTRAINT "permissions_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "permissions" ADD CONSTRAINT "permissions_company_id_entity_id_fkey" FOREIGN KEY ("company_id", "entity_id") REFERENCES "master_entities"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "roles" ADD CONSTRAINT "roles_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "roles" ADD CONSTRAINT "roles_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "roles" ADD CONSTRAINT "roles_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "roles" ADD CONSTRAINT "roles_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "role_permissions" ADD CONSTRAINT "role_permissions_company_id_role_id_fkey" FOREIGN KEY ("company_id", "role_id") REFERENCES "roles"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "role_permissions" ADD CONSTRAINT "role_permissions_company_id_permission_id_fkey" FOREIGN KEY ("company_id", "permission_id") REFERENCES "permissions"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_roles" ADD CONSTRAINT "user_roles_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_roles" ADD CONSTRAINT "user_roles_company_id_role_id_fkey" FOREIGN KEY ("company_id", "role_id") REFERENCES "roles"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_permissions" ADD CONSTRAINT "user_permissions_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "user_permissions" ADD CONSTRAINT "user_permissions_company_id_permission_id_fkey" FOREIGN KEY ("company_id", "permission_id") REFERENCES "permissions"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "otps" ADD CONSTRAINT "otps_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "languages" ADD CONSTRAINT "languages_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "languages" ADD CONSTRAINT "languages_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "languages" ADD CONSTRAINT "languages_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "languages" ADD CONSTRAINT "languages_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "language_contents" ADD CONSTRAINT "language_contents_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "language_contents" ADD CONSTRAINT "language_contents_company_id_language_id_fkey" FOREIGN KEY ("company_id", "language_id") REFERENCES "languages"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu" ADD CONSTRAINT "menu_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu" ADD CONSTRAINT "menu_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu" ADD CONSTRAINT "menu_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu" ADD CONSTRAINT "menu_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_items" ADD CONSTRAINT "menu_items_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_items" ADD CONSTRAINT "menu_items_company_id_menu_id_fkey" FOREIGN KEY ("company_id", "menu_id") REFERENCES "menu"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_items" ADD CONSTRAINT "menu_items_company_id_entity_id_fkey" FOREIGN KEY ("company_id", "entity_id") REFERENCES "master_entities"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_items" ADD CONSTRAINT "menu_items_company_id_permission_id_fkey" FOREIGN KEY ("company_id", "permission_id") REFERENCES "permissions"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_items" ADD CONSTRAINT "menu_items_company_id_parent_id_fkey" FOREIGN KEY ("company_id", "parent_id") REFERENCES "menu_items"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_items" ADD CONSTRAINT "menu_items_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_items" ADD CONSTRAINT "menu_items_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_items" ADD CONSTRAINT "menu_items_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "master_entities" ADD CONSTRAINT "master_entities_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "master_entity_line_items" ADD CONSTRAINT "master_entity_line_items_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "master_entity_line_items" ADD CONSTRAINT "master_entity_line_items_company_id_master_grid_id_fkey" FOREIGN KEY ("company_id", "master_grid_id") REFERENCES "master_entities"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "master_entity_line_items" ADD CONSTRAINT "master_entity_line_items_company_id_field_type_id_fkey" FOREIGN KEY ("company_id", "field_type_id") REFERENCES "field_types"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "field_types" ADD CONSTRAINT "field_types_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "menu_types" ADD CONSTRAINT "menu_types_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_template_process" ADD CONSTRAINT "email_template_process_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_template_tags" ADD CONSTRAINT "email_template_tags_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_template_recipient_tags" ADD CONSTRAINT "email_template_recipient_tags_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_template_process_tags_mapping" ADD CONSTRAINT "email_template_process_tags_mapping_email_template_process_fkey" FOREIGN KEY ("email_template_process_id", "company_id") REFERENCES "email_template_process"("id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_template_process_tags_mapping" ADD CONSTRAINT "email_template_process_tags_mapping_email_template_tag_id__fkey" FOREIGN KEY ("email_template_tag_id", "company_id") REFERENCES "email_template_tags"("id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_templates" ADD CONSTRAINT "email_templates_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_templates" ADD CONSTRAINT "email_templates_email_template_process_id_company_id_fkey" FOREIGN KEY ("email_template_process_id", "company_id") REFERENCES "email_template_process"("id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_templates" ADD CONSTRAINT "email_templates_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_templates" ADD CONSTRAINT "email_templates_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_templates" ADD CONSTRAINT "email_templates_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_template_assignments" ADD CONSTRAINT "email_template_assignments_email_template_process_id_compa_fkey" FOREIGN KEY ("email_template_process_id", "company_id") REFERENCES "email_template_process"("id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_template_assignments" ADD CONSTRAINT "email_template_assignments_template_id_company_id_fkey" FOREIGN KEY ("template_id", "company_id") REFERENCES "email_templates"("id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_template_assignments" ADD CONSTRAINT "email_template_assignments_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_process_jobs" ADD CONSTRAINT "email_process_jobs_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "email_process_jobs" ADD CONSTRAINT "email_process_jobs_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "notification_jobs" ADD CONSTRAINT "notification_jobs_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "notification_jobs" ADD CONSTRAINT "notification_jobs_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "import_templates" ADD CONSTRAINT "import_templates_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "import_templates" ADD CONSTRAINT "import_templates_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "import_templates" ADD CONSTRAINT "import_templates_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "import_templates" ADD CONSTRAINT "import_templates_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "import_template_line_items" ADD CONSTRAINT "import_template_line_items_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "import_template_line_items" ADD CONSTRAINT "import_template_line_items_company_id_import_template_id_fkey" FOREIGN KEY ("company_id", "import_template_id") REFERENCES "import_templates"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "statuses" ADD CONSTRAINT "statuses_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_category_types" ADD CONSTRAINT "app_category_types_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_category_types" ADD CONSTRAINT "app_category_types_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_category_types" ADD CONSTRAINT "app_category_types_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_categories" ADD CONSTRAINT "app_categories_parent_id_fkey" FOREIGN KEY ("parent_id") REFERENCES "app_categories"("category_id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_categories" ADD CONSTRAINT "app_categories_category_type_id_company_id_fkey" FOREIGN KEY ("category_type_id", "company_id") REFERENCES "app_category_types"("category_type_id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_categories" ADD CONSTRAINT "app_categories_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_categories" ADD CONSTRAINT "app_categories_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_categories" ADD CONSTRAINT "app_categories_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_configurations" ADD CONSTRAINT "app_configurations_category_id_company_id_fkey" FOREIGN KEY ("category_id", "company_id") REFERENCES "app_categories"("category_id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_configurations" ADD CONSTRAINT "app_configurations_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_configurations" ADD CONSTRAINT "app_configurations_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "app_configurations" ADD CONSTRAINT "app_configurations_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "file_upload_logs" ADD CONSTRAINT "file_upload_logs_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "device_registration" ADD CONSTRAINT "device_registration_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "device_registration" ADD CONSTRAINT "device_registration_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "device_registration" ADD CONSTRAINT "device_registration_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "device_registration" ADD CONSTRAINT "device_registration_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "device_registration" ADD CONSTRAINT "device_registration_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users"("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE;
