"use strict";var __awaiter=this&&this.__awaiter||function(e,t,s,o){return new(s||(s=Promise))((function(a,i){function n(e){try{c(o.next(e))}catch(e){i(e)}}function d(e){try{c(o.throw(e))}catch(e){i(e)}}function c(e){var t;e.done?a(e.value):(t=e.value,t instanceof s?t:new s((function(e){e(t)}))).then(n,d)}c((o=o.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});const supertest_1=__importDefault(require("supertest")),__1=require("../../"),child_process_1=require("child_process"),util_1=require("util");let token="",passwordResetToken="",acoountActivationToken="";const params={login:{admin:!0,email:"logesht@techcedence.com",password:"SAdmin@123#"},changePassword:{id:1,oldPassword:"SAdmin@123#",newPassword:"SAdmin@123#"},activateAccount:{token:"",email:"123@gmail.com",newPassword:"SAdmin@123#",activateAccount:!0},resetPassword:{token:"",email:"logesht@techcedence.com",newPassword:"SAdmin@123#",activateAccount:!1},sendResetPasswordLink:{email:"logesht@techcedence.com",admin:!0},sendAccountActivationLink:{email:"123@gmail.com",admin:!1}};beforeAll((()=>__awaiter(void 0,void 0,void 0,(function*(){(0,util_1.promisify)(child_process_1.exec);try{const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/login").send(Object.assign({},params.login));token=e.body&&e.body.result&&e.body.result.token?e.body.result.token:""}catch(e){console.error("Error during setup:",e)}})))),describe("POST /api/auth/login",(()=>{it("should return status 200 if user credentials are correct",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/login").send(Object.assign({},params.login));expect(e.status).toBe(200),expect(e.body).toMatchObject({status:!0,code:200,message:"User logged in successfully"})}))))})),describe("POST /api/auth/login",(()=>{it("should return status 401 if user email is not found",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/login").send(Object.assign(Object.assign({},params.login),{email:"dummyemail@gmail.com"}));expect(e.status).toBe(401),expect(e.body).toEqual({status:!1,code:401,message:"Invalid email."})}))))})),describe("POST /api/auth/login",(()=>{it("should return status 401 if the user is not admin but tried to login in using super admin portal, vice versa for company login",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/login").send(Object.assign(Object.assign({},params.login),{admin:!1}));expect(e.status).toBe(401),expect(e.body).toMatchObject({status:!1,code:401,message:"Your account does not have permission to access this resource."})}))))})),describe("POST /api/auth/login",(()=>{it("should return status 401 if user password is incorrect",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/login").send(Object.assign(Object.assign({},params.login),{password:"gfdgjmc12"}));expect(e.status).toBe(401),expect(e.body).toEqual({status:!1,code:401,message:"Invalid password."})}))))})),describe("POST /api/auth/login",(()=>{it("should return status 403 if the user has not activate his account yet",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/login").send(Object.assign({},params.login));expect(e.status).toBe(403),expect(e.body).toEqual({status:!1,code:403,message:"Your account has not been activated yet."})}))))})),describe("POST /api/auth/changePassword",(()=>{it("should return status 404 if the user is not found.",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/changePassword").set("Authorization",`Bearer ${token}`).send(Object.assign(Object.assign({},params.changePassword),{id:-1}));expect(e.status).toBe(404),expect(e.body).toEqual({status:!1,code:404,message:"User not found."})}))))})),describe("POST /api/auth/changePassword",(()=>{it("should return status 401 if the old password is incorrect.",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/changePassword").set("Authorization",`Bearer ${token}`).send(Object.assign(Object.assign({},params.changePassword),{oldPassword:"123"}));expect(e.status).toBe(401),expect(e.body).toEqual({status:!1,code:401,message:"Incorrect old password."})}))))})),describe("POST /api/auth/changePassword",(()=>{it("should return status 422 if the new password is not strong enough.",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/changePassword").set("Authorization",`Bearer ${token}`).send(Object.assign(Object.assign({},params.changePassword),{newPassword:"123"}));expect(e.status).toBe(422),expect(e.body).toEqual({status:!1,code:422,message:"New password is not strong enough."})}))))})),describe("POST /api/auth/changePassword",(()=>{it("should return status 200 if the password changed successfully.",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/changePassword").set("Authorization",`Bearer ${token}`).send(Object.assign({},params.changePassword));expect(e.status).toBe(200),expect(e.body).toEqual({status:!0,code:200,message:"Password changed successfully. Kindly login again."})}))))})),describe("POST /api/auth/sendResetPasswordLink",(()=>{it("should return status 404 if the user is not found.",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/sendResetPasswordLink").send(Object.assign(Object.assign({},params.sendResetPasswordLink),{email:"dummyuser@gmail.com"}));expect(e.status).toBe(404),expect(e.body).toEqual({status:!1,code:404,message:"User not found."})}))))})),describe("POST /api/auth/sendResetPasswordLink",(()=>{it("should return status 401 if the user is not admin but tried to login in using super admin portal, vice versa for company login.",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/sendResetPasswordLink").send(Object.assign(Object.assign({},params.sendResetPasswordLink),{admin:!1}));expect(e.status).toBe(401),expect(e.body).toEqual({status:!1,code:401,message:"Your account does not have permission to access this resource."})}))))}));