"use strict";var __awaiter=this&&this.__awaiter||function(e,r,t,i){return new(t||(t=Promise))((function(s,a){function d(e){try{n(i.next(e))}catch(e){a(e)}}function o(e){try{n(i.throw(e))}catch(e){a(e)}}function n(e){var r;e.done?s(e.value):(r=e.value,r instanceof t?r:new t((function(e){e(r)}))).then(d,o)}n((i=i.apply(e,r||[])).next())}))},__rest=this&&this.__rest||function(e,r){var t={};for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&r.indexOf(i)<0&&(t[i]=e[i]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var s=0;for(i=Object.getOwnPropertySymbols(e);s<i.length;s++)r.indexOf(i[s])<0&&Object.prototype.propertyIsEnumerable.call(e,i[s])&&(t[i[s]]=e[i[s]])}return t},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.userService=exports.roleTypes=exports.genderTypes=exports.OtpPurpose=void 0;const config_1=require("../../config"),uuid_1=require("uuid"),custom_validations_1=require("../utilities/custom.validations"),datetime_1=require("../utilities/datetime"),response_1=require("../utilities/response"),password_service_1=require("./password.service"),prisma_service_1=__importDefault(require("./prisma.service")),common_service_1=require("./common.service");var OtpPurpose,genderTypes,roleTypes;!function(e){e.login="login",e.password_reset="password_reset",e.verify_email="verify_email",e.others="others"}(OtpPurpose||(exports.OtpPurpose=OtpPurpose={})),function(e){e.male="male",e.female="female",e.others="others"}(genderTypes||(exports.genderTypes=genderTypes={})),function(e){e.super_admin="super_admin",e.company_admin="company_admin",e.admin="admin",e.user="user"}(roleTypes||(exports.roleTypes=roleTypes={}));class userService{static getUserByUsername(e,r){return __awaiter(this,arguments,void 0,(function*(e,r,t=!1,i=!1,s=!1,a=!1,d){var o,n,u,_;try{let a={company_id:r,OR:[{email:e},{username:e}]};d&&(a.role=d),i&&(a.deleted_at=null),s||(a.status_id=1);const l=yield prisma_service_1.default.user.findFirst({where:a,select:{id:!0,uuid:!0,email:!0,username:!0,company_id:!0,email_verified:!0,password:t,status_id:!0,role:!0,created_by:!0,updated_by:!0,deleted_by:t,created_at:!0,updated_at:!0,deleted_at:t,created:{select:{user_detail:{select:{first_name:!0,last_name:!0}}}},updated:{select:{user_detail:{select:{first_name:!0,last_name:!0}}}},user_detail:{where:{deleted_at:null},select:{id:!0,user_id:!0,first_name:!0,last_name:!0,profile_pic:!0,dob:!0,country_code:!0,phone_number:!0,gender:!0,user_time_zone:!0,address:!0}}},orderBy:{id:"desc"}});if(l){const{user_detail:e,created:r,updated:t}=l,i=__rest(l,["user_detail","created","updated"]);return Object.assign(Object.assign(Object.assign({},i),e),{id:l.id,created:r?`${null===(o=r.user_detail)||void 0===o?void 0:o.first_name} ${null===(n=r.user_detail)||void 0===n?void 0:n.last_name}`:"-",updated:t?`${null===(u=t.user_detail)||void 0===u?void 0:u.first_name} ${null===(_=t.user_detail)||void 0===_?void 0:_.last_name}`:"-"})}return{}}catch(e){throw console.error("Error getting user by email:",e),e}}))}static getUserByUuid(e,r){return __awaiter(this,arguments,void 0,(function*(e,r,t=!1,i=!1,s=!1,a){var d,o,n,u;try{let _={uuid:e,company_id:r};a&&(_.role=a),i||(_.deleted_at=null),s||(_.status_id=1);const l=yield prisma_service_1.default.user.findFirst({where:_,select:{id:!0,uuid:!0,email:!0,username:!0,company_id:!0,email_verified:!0,password:t,status_id:!0,role:!0,created_by:!0,updated_by:!0,deleted_by:t,created_at:!0,updated_at:!0,deleted_at:t,created:{select:{user_detail:{select:{first_name:!0,last_name:!0}}}},updated:{select:{user_detail:{select:{first_name:!0,last_name:!0}}}},user_detail:{where:{deleted_at:null},select:{id:!0,user_id:!0,first_name:!0,last_name:!0,profile_pic:!0,dob:!0,country_code:!0,phone_number:!0,gender:!0,user_time_zone:!0,address:!0}}},orderBy:{id:"desc"}});if(l){const{user_detail:e,created:r,updated:t}=l,i=__rest(l,["user_detail","created","updated"]);return Object.assign(Object.assign(Object.assign({},i),e),{id:l.id,created:r?`${null===(d=r.user_detail)||void 0===d?void 0:d.first_name} ${null===(o=r.user_detail)||void 0===o?void 0:o.last_name}`:"-",updated:t?`${null===(n=t.user_detail)||void 0===n?void 0:n.first_name} ${null===(u=t.user_detail)||void 0===u?void 0:u.last_name}`:"-"})}throw new response_1.MyError({message:"Invalid user detail given.",code:config_1.statusCodes.invalid_user})}catch(e){throw console.error("Error getting user by uuid:",e),e}}))}static updateUserEmailVerified(e,r){return __awaiter(this,void 0,void 0,(function*(){try{let t={company_id:e,table_name:"users",where_all:[{column_name:"deleted_at",operator:"IS",value:null},{column_name:"id",operator:"=",value:r}],update_values:[{email_verified:!0}],updated_at:"now()",updated_by:r};return yield common_service_1.commonService.updateTableData(e,t)}catch(e){throw console.error("Error update user mail verify status:",e),e}}))}static updateUserPassword(e,r){return __awaiter(this,arguments,void 0,(function*(e,r,t=""){try{const i=yield password_service_1.PasswordService.hashPassword(r,t);return yield prisma_service_1.default.user.update({where:{id:e},data:{password:i,updated_by:e}})}catch(e){throw console.error("Error update user mail verify status:",e),e}}))}static updateUserOtp(e,r,t){return __awaiter(this,void 0,void 0,(function*(){try{const i=(0,datetime_1.addMinutes)((0,datetime_1.utcNow)(),-15),s=5;if((yield prisma_service_1.default.otp.count({where:{user_id:e,company_id:r,purpose:t,created_at:{gte:i}}}))>=s)throw new response_1.MyError({message:"Too many OTP requests in the last 15 minutes. Please try again later.",code:config_1.statusCodes.invalid_otp});const a=Math.floor(1e5+9e5*Math.random());return yield prisma_service_1.default.otp.create({data:{user_id:e,otp:`${a}`,created_at:(0,datetime_1.utcNow)(),purpose:t,company_id:r}})}catch(e){throw console.error("Error updating user otp:",e),e}}))}static getUserOtp(e,r){return __awaiter(this,void 0,void 0,(function*(){try{const t=yield prisma_service_1.default.otp.findFirst({where:{user_id:e,purpose:r},orderBy:{id:"desc"}});if(!t)throw new response_1.MyError({message:"Invalid OTP, Please try again.",code:config_1.statusCodes.invalid_otp});return t}catch(e){throw console.error("Error verifing user otp:",e),e}}))}static updateUserDetail(e,r,t){return __awaiter(this,void 0,void 0,(function*(){try{let i=Object.assign(Object.assign({},r),{updated_by:t});"dob"in r&&r.dob&&(i.dob=(0,datetime_1.dbDate)(r.dob));return yield prisma_service_1.default.userDetail.update({where:{deleted_at:null,id:e},data:i})}catch(e){throw console.error("Error updating user detail:",e),e}}))}static deleteUser(e,r,t){return __awaiter(this,void 0,void 0,(function*(){let i;try{const s=yield prisma_service_1.default.user.findFirst({where:{uuid:e,company_id:t,deleted_at:null},select:{id:!0}});if(!s||0===Object.keys(s).length)throw new response_1.MyError({message:"User not found.",code:config_1.statusCodes.invalid_user});return i=yield prisma_service_1.default.$transaction((e=>__awaiter(this,void 0,void 0,(function*(){yield e.userDetail.update({where:{company_id_user_id:{user_id:s.id,company_id:t},deleted_at:null},data:{deleted_at:(0,datetime_1.utcNow)(),deleted_by:r}});return(yield e.user.update({where:{deleted_at:null,id:s.id,company_id:t},data:{deleted_at:(0,datetime_1.utcNow)(),deleted_by:r}})).uuid})))),i}catch(e){throw console.error("Error deleting user:",e),e}}))}static getUsers(){return __awaiter(this,arguments,void 0,(function*(e=1,r=10,t="id",i="desc",s,a){try{let d={deleted_at:null};a&&(d.role=a),s&&(d.OR=[{user_detail:{first_name:{contains:s}}},{user_detail:{last_name:{contains:s}}},{email:{contains:s}},{username:{contains:s}},{uuid:{contains:s}}]);const o={};"first_name"===t||"last_name"===t?o.user_detail={[t]:i}:"created"===t?o.created={userDetail:{first_name:i}}:"updated"===t?o.updated={userDetail:{first_name:i}}:o[t]=i;const n=(yield prisma_service_1.default.user.findMany({where:d,select:{id:!0,uuid:!0,email:!0,username:!0,email_verified:!0,status_id:!0,role:!0,created_by:!0,updated_by:!0,created_at:!0,updated_at:!0,created:{select:{user_detail:{select:{first_name:!0,last_name:!0}}}},updated:{select:{user_detail:{select:{first_name:!0,last_name:!0}}}},user_detail:{select:{first_name:!0,last_name:!0,profile_pic:!0,dob:!0,country_code:!0,phone_number:!0,gender:!0,user_time_zone:!0,address:!0}}},orderBy:o,skip:(e-1)*r,take:r})).map((e=>{var r,t,i,s;const{user_detail:a,created:d,updated:o}=e,n=__rest(e,["user_detail","created","updated"]);return Object.assign(Object.assign(Object.assign({},n),a),{id:e.id,created:d?`${null===(r=d.user_detail)||void 0===r?void 0:r.first_name} ${null===(t=d.user_detail)||void 0===t?void 0:t.last_name}`:"-",updated:o?`${null===(i=o.user_detail)||void 0===i?void 0:i.first_name} ${null===(s=o.user_detail)||void 0===s?void 0:s.last_name}`:"-"})})),u=yield prisma_service_1.default.user.count({where:d});return{totalCount:u,totalPages:Math.ceil(u/r),page:e,per_page:r,sort_field:t,sort_order:i,search:s,data:n}}catch(e){throw console.error("Error getting user by uuid:",e),e}}))}static addUser(e,r){return __awaiter(this,void 0,void 0,(function*(){var t;let i;try{const s=yield prisma_service_1.default.user.findFirst({where:{email:e.email,role:e.role,company_id:r},select:{id:!0,uuid:!0,email:!0,email_verified:!0,status_id:!0,role:!0,deleted_by:!0,deleted_at:!0},orderBy:{id:"desc"}});if(s&&0!==Object.keys(s).length){if(s.deleted_at)throw new response_1.MyError({message:"User with given email already deleted from application, Try diffrent email.",code:config_1.statusCodes.invalid_user,data:s});throw new response_1.MyError({message:"User with given email already exists. Please login.",code:config_1.statusCodes.invalid_user,data:s})}if("otp"!==config_1.generalSettings.login_type){if(!(null===(t=e.password)||void 0===t?void 0:t.length))throw new response_1.MyError({message:"Please enter valid password.",code:config_1.statusCodes.validation_error});if(!e.created_by&&e.password!==e.confirm_password)throw new response_1.MyError({message:"Password and confirm password do not match.",code:config_1.statusCodes.invalid_token});if(config_1.generalSettings.password_criteria&&!(0,custom_validations_1.isStrongPassword)(e.password))throw new response_1.MyError({message:"Password does not meet the criteria for a strong password.",code:config_1.statusCodes.password_criteria})}return i=yield prisma_service_1.default.$transaction((t=>__awaiter(this,void 0,void 0,(function*(){const i=yield t.user.create({data:{uuid:(0,uuid_1.v4)(),username:e.email,email:e.email,role:e.role,company_id:r}});let s={created_by:e.created_by||i.id};if(e.password){const r=yield password_service_1.PasswordService.hashPassword(e.password,i.role);s.password=r}return yield t.user.update({where:{id:i.id},data:s}),yield t.userDetail.create({data:{user_id:i.id,code:e.email,first_name:e.first_name,last_name:e.last_name,dob:e.dob?(0,datetime_1.dbDate)(e.dob):null,country_code:e.country_code,phone_number:e.phone_number,gender:e.gender||"male",user_time_zone:e.user_time_zone,address:e.address,created_by:s.created_by,company_id:r}}),i.uuid})))),yield this.getUserByUuid(i,r,!1,!1,!0)}catch(e){throw i&&(yield prisma_service_1.default.$queryRaw`ROLLBACK`),console.error("Error adding user:",e),e}}))}static updateUser(e,r,t){return __awaiter(this,void 0,void 0,(function*(){let i;try{const s=yield prisma_service_1.default.user.findFirst({where:{uuid:e,company_id:t},select:{id:!0,uuid:!0,email:!0,username:!0,status_id:!0,role:!0,deleted_at:!0}});if(!s||s.deleted_at)throw new response_1.MyError({message:"User not found or has been deleted.",code:config_1.statusCodes.invalid_user});if(r.password&&r.confirm_password&&r.password!==r.confirm_password)throw new response_1.MyError({message:"Password and confirm password do not match.",code:config_1.statusCodes.invalid_token});if(r.password&&config_1.generalSettings.password_criteria&&!(0,custom_validations_1.isStrongPassword)(r.password))throw new response_1.MyError({message:"Password does not meet the criteria for a strong password.",code:config_1.statusCodes.password_criteria});return i=yield prisma_service_1.default.$transaction((i=>__awaiter(this,void 0,void 0,(function*(){const a={updated_by:r.updated_by||s.id};if(r.password){const e=yield password_service_1.PasswordService.hashPassword(r.password,s.role);a.password=e}yield i.user.update({where:{company_id_uuid:{uuid:e,company_id:t},deleted_at:null},data:a}),yield i.userDetail.update({where:{company_id_user_id:{user_id:s.id,company_id:t}},data:{first_name:r.first_name,last_name:r.last_name,dob:r.dob?(0,datetime_1.dbDate)(r.dob):null,country_code:r.country_code,phone_number:r.phone_number,gender:r.gender||"male",user_time_zone:r.user_time_zone,address:r.address,updated_by:r.updated_by||s.id}});return s.uuid})))),yield this.getUserByUuid(i,t,!1,!1,!0)}catch(e){throw i&&(yield prisma_service_1.default.$queryRaw`ROLLBACK`),console.error("Error updating user:",e),e}}))}static changeUserStatus(e,r,t,i){return __awaiter(this,void 0,void 0,(function*(){try{if((yield prisma_service_1.default.user.count({where:{uuid:r,company_id:i,deleted_at:null}}))<=0)throw new response_1.MyError({message:"User not found.",code:config_1.statusCodes.invalid_user});return yield prisma_service_1.default.user.update({where:{company_id_uuid:{uuid:r,company_id:i},deleted_at:null},data:{status_id:e,updated_by:t}})}catch(e){throw console.error("Error changing user status:",e),e}}))}static getUserForSelect(e,r,t){return __awaiter(this,void 0,void 0,(function*(){try{const i=r&&"all"!==r?` AND u.role = '${r}'`:"",s=t?"sql"===config_1.dbDetails.from?` AND ( ud.first_name + ' ' + ud.last_name LIKE '%${t}%' OR u.username LIKE '%${t}%' OR u.email LIKE '%${t}%' OR u.uuid LIKE '%${t}%' ) `:` AND ( CONCAT(ud.first_name, ' ', ud.last_name) LIKE '%${t}%' OR u.username LIKE '%${t}%' OR u.email LIKE '%${t}%' OR u.uuid LIKE '%${t}%' ) `:"",a=t?"sql"===config_1.dbDetails.from?" TOP 10 ":" LIMIT 10 ":"";return[...yield prisma_service_1.default.$queryRawUnsafe(`\n        SELECT ${"sql"===config_1.dbDetails.from?"TOP 10":""} \n          u.id, u.uuid, u.email, u.username, u.role, ud.first_name, ud.last_name,\n          ${"sql"===config_1.dbDetails.from?"ud.first_name + ' ' + ud.last_name":"CONCAT(ud.first_name, ' ', ud.last_name)"} AS full_name\n        FROM users u\n        INNER JOIN user_details ud ON u.id = ud.user_id \n        WHERE u.deleted_at IS NULL \n          AND u.company_id = ${e} \n          AND ud.company_id = ${e} \n          AND u.status_id = 1\n          ${i} ${s}\n        ORDER BY full_name ASC\n        ${"sql"===config_1.dbDetails.from?"":a} \n      `)]}catch(e){throw console.error("Error getting user for select:",e),e}}))}static getuser_idByUuid(e){return __awaiter(this,void 0,void 0,(function*(){try{let r={uuid:e};const t=yield prisma_service_1.default.user.findFirst({where:r,select:{id:!0,uuid:!0}});if(t)return Object.assign({},t);throw new response_1.MyError({message:"Invalid user detail given.",code:config_1.statusCodes.invalid_user})}catch(e){throw console.error("Error getting user id by uuid:",e),e}}))}static getUserMenus(e,r){return __awaiter(this,void 0,void 0,(function*(){try{let r={status_id:1,parent_id:null,company_id:e};return[...yield prisma_service_1.default.menuItems.findMany({where:r,select:{id:!0,name:!0,target:!0,permission_id:!0,menu_img:!0,short_cut_keys:!0,order_no:!0,parent_id:!0,created_at:!0,children:{where:{status_id:1},select:{id:!0,name:!0,target:!0,permission_id:!0,menu_img:!0,short_cut_keys:!0,order_no:!0,parent_id:!0,created_at:!0,children:{where:{status_id:1},select:{id:!0,name:!0,target:!0,permission_id:!0,menu_img:!0,short_cut_keys:!0,order_no:!0,parent_id:!0,created_at:!0},orderBy:{order_no:"asc"}}},orderBy:{order_no:"asc"}}},orderBy:{order_no:"asc"}})]}catch(e){throw console.error("Error getting menus:",e),e}}))}static getUserRolePolicies(e,r){return __awaiter(this,void 0,void 0,(function*(){try{const t=`WITH policy_data AS (\n          SELECT\n            policies.slug,\n            jsonb_build_object(\n                'id', policies.id,\n                'name', policies.name,\n                'query_information', policies.query_information,\n                'user_id', user_policies.user_id\n                ${r.length?",'role_id', role_policies.role_id":""}\n            ) AS policies_object\n          FROM\n              policies\n              LEFT JOIN user_policies ON user_policies.policy_id = policies.id AND user_policies.user_id = ${e}\n              ${r.length?`LEFT JOIN role_policies ON role_policies.policy_id = policies.id AND role_policies.role_id IN (${r.join(",")})`:""}\n          WHERE\n              policies.status_id = 1 AND (user_policies.user_id IS NOT NULL ${r.length?"OR role_policies.role_id IS NOT NULL":""})\n          GROUP BY\n              policies.id,\n              user_policies.user_id\n              ${r.length?", role_policies.role_id":""}\n        )\n        SELECT\n            jsonb_object_agg(slug, policies_object) AS result\n        FROM\n            policy_data;\n      `;return yield prisma_service_1.default.$queryRawUnsafe(t)}catch(e){throw console.error("Error getting policy data:",e),e}}))}}exports.userService=userService;