"use strict";var __awaiter=this&&this.__awaiter||function(e,t,s,n){return new(s||(s=Promise))((function(i,r){function a(e){try{o(n.next(e))}catch(e){r(e)}}function l(e){try{o(n.throw(e))}catch(e){r(e)}}function o(e){var t;e.done?i(e.value):(t=e.value,t instanceof s?t:new s((function(e){e(t)}))).then(a,l)}o((n=n.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.transactionQueryBuilderService=void 0;const pg_escape_1=__importDefault(require("pg-escape")),response_1=require("../utilities/response"),config_1=require("../../config"),sql_database_1=require("../utilities/sql-database"),postgres_database_1=require("../utilities/postgres-database");class transactionQueryBuilderService{static dateNow(){return"sql"===config_1.dbDetails.from?"GETDATE()":"NOW()"}static validateArrayLengths(e,t,s){if(e.length!==t.length||t.length!==s.length)throw new response_1.MyError({message:`The lengths of action, table, and table_mapping must be equal. Found lengths: action=${e.length}, table=${t.length}, table_mapping=${s.length}`,code:config_1.statusCodes.validation_error,data:{action:e,table:t,table_mapping:s}})}static validateTableMappings(e){const t={};e.forEach((s=>{if(!s.startsWith("table"))throw new response_1.MyError({message:`Invalid table mapping: "${s}". All table mappings must start with "table".`,code:config_1.statusCodes.validation_error,data:e});if(t[s])throw new response_1.MyError({message:`Duplicate table mapping found: "${s}". All table mappings must be unique.`,code:config_1.statusCodes.validation_error,data:e});t[s]=!0}))}static extractDuplicateKeys(e){var t;return((null===(t=e.match(/\((.*?)\)=\(/))||void 0===t?void 0:t[1].split(", ").filter((e=>"company_id"!==e)).map((e=>e.replace(/_/g," ").toLowerCase().replace(/\b\w/g,(e=>e.toUpperCase())))))||[]).join(", ")}static executeTransactions(e,t,s){return __awaiter(this,void 0,void 0,(function*(){this.validateArrayLengths(e.action,e.table,e.table_mapping),this.validateTableMappings(e.table_mapping);const n={};let i;if("sql"===config_1.dbDetails.from)i=new sql_database_1.SqlDatabase;else i=new postgres_database_1.PostgresDatabase;try{yield i.beginTransaction();let r="",a="";if("sql"===config_1.dbDetails.from)r=`EXEC sp_set_session_context @key = N'app.lcp_user_id', @value = ${s};`,a=`EXEC sp_set_session_context @key = N'app.lcp_company_id', @value = ${t};`;else r=`SET LOCAL app.lcp_user_id = '${s}';`,a=`SET LOCAL app.lcp_company_id = '${t}';`;yield i.executeQuery(r),yield i.executeQuery(a);for(let r=0;r<e.action.length;r++){const a=e.action[r],l=e.table[r],o=e.table_mapping[r],c=e.data&&e.data[o]||[],u=e.conditions?e.conditions[o]:[],p=e.columns?e.columns[o]:[],h=e.reset_unique&&e.reset_unique[o]||[],d=yield this.generateQueries(a,l,c,u,p,n,o,t,s,h);for(const e of d)if(""!==e.text){const t=yield i.executeQuery(e.text,e.values);if(n[o]||(n[o]=[]),"insert"===a&&t.length>1)for(const e of t)n[o].push([e]);else n[o].push(t)}}yield i.commitTransaction()}catch(e){yield i.rollbackTransaction(),console.error("Error executing transactions:",e);let t=e.message;throw e?(t=config_1.dbErrorMessages[null==e?void 0:e.code]||config_1.dbErrorMessages.default,t.includes("duplicate")&&(t+=` (${this.extractDuplicateKeys(e.detail)})`)):t="An unexpected error occurred.",new response_1.MyError({message:t,code:config_1.statusCodes.something_wrong,data:e})}finally{i&&(yield i.release()),console.log("Database connection closed")}}))}static generateQueries(e,t,s,n,i,r,a,l,o){return __awaiter(this,arguments,void 0,(function*(e,t,s,n,i,r,a,l,o,c=[]){const u=[];switch(e){case"insert":if(0===s.length)u.push({text:"",values:[]});else{const e=this.generateChunkedQueries(t,s,r,a,l,o);u.push(...e)}break;case"update":if(0===s.length){const e={text:"",values:[]};u.push(e)}else{const e=Math.max(s.length,n.length);for(let i=0;i<e;i++){const e=s[i]||s[0]||{},c=n[i]||n[0]||{};u.push(Object.assign(Object.assign({},this.generateUpdateQuery(t,e,c,r,a,i,l,o)),{index:i}))}}break;case"upsert":if(0===s.length)u.push({text:"",values:[]});else{const e=Math.max(s.length,n.length);for(let i=0;i<e;i++){const e=s[i]||s[0]||{},c=n[i]||n[0]||{};u.push(Object.assign(Object.assign({},this.generateUpsertQuery(t,e,c,r,a,i,l,o)),{index:i}))}}break;case"select":if(0===n.length){const e={text:"",values:[]};u.push(e)}else n.forEach(((e,s)=>{u.push(this.generateSelectQuery(t,i,e,r,a,l))}));break;case"delete":if(0===n.length){const e={text:"",values:[]};u.push(e)}else{const e=Math.max(s.length,n.length);for(let i=0;i<e;i++){const e=n[i]||n[0]||{},p=s[i]||s[0]||{};u.push(this.generateSoftDeleteQuery(t,e,r,a,i,p,l,o,c))}}break;case"hard_delete":if(0===n.length){const e={text:"",values:[]};u.push(e)}else{const e=Math.max(s.length,n.length);for(let s=0;s<e;s++){const e=n[s]||n[0]||{};u.push(this.generateDeleteQuery(t,e,r,a,s,l))}}break;default:throw new Error(`Unknown transaction action: "${e}"`)}return u}))}static generateChunkedQueries(e,t,s,n,i,r){if(0===t.length)return[{text:"",values:[]}];console.log(t.length);const a=Object.keys(t[0]).length+1;console.log(a);const l=Math.floor(65e3/a);console.log(l);const o=[];for(let a=0;a<t.length;a+=l){const c=t.slice(a,a+l);o.push({table:e,data:c,transactionResults:s,tableMapping:n,company_id:i,created_by:r})}return o.map((e=>this.generateBatchInsertQuery(e.table,e.data,e.transactionResults,e.tableMapping,e.company_id,e.created_by)))}static generateBatchInsertQuery(e,t,s,n,i,r){if(0===t.length)return{text:"",values:[]};const a=Object.keys(t[0]).length+1,l=Math.floor(65e3/a),o=[],c=[],u=t.slice(0,l),p=Object.keys(u[0]).join(", ");u.forEach(((e,t)=>{const a=[];e.company_id=i,Object.entries(e).forEach((([e,i],l)=>{if("created_by"===e&&!0===i)o.push(r),a.push(`$${o.length}`);else if("updated_by"===e&&!0===i)o.push(r),a.push(`$${o.length}`);else if("created_at"===e&&!0===i)a.push(this.dateNow());else if("updated_at"===e&&!0===i)a.push(this.dateNow());else if("string"==typeof i&&i.includes("{{{")&&i.includes("}}}")){const e=i.slice(3,-3),r=this.sanitizeAndBuildRawExpression(e,s,n,t);a.push(r)}else if("string"==typeof i&&i.includes("{#{")&&i.includes("}#}")){const e=i.replace("{#{","{{{").replace("}#}","}}}"),r=this.sanitizeAndBuildRawExpression(e,s,n,t,!1);o.push(r),a.push(`$${o.length}`)}else if("string"==typeof i&&i.includes("@table")){const e=this.resolvePlaceholder(i,s,n,t);o.push(e),a.push(`$${o.length}`)}else if("string"==typeof i&&i.includes("##table")){const e=this.resolvePlaceholder(i,s,n,t);a.push(e)}else o.push(i),a.push(`$${o.length}`)})),c.push(`(${a.join(", ")})`)}));let h="";if("sql"===config_1.dbDetails.from)h=`INSERT INTO ${e} (${p}, company_id) OUTPUT INSERTED.* VALUES ${c.join(", ")}`;else h=`INSERT INTO ${e} (${p}, company_id) VALUES ${c.join(", ")} RETURNING *`;return{text:h,values:o}}static generateUpdateQuery(e,t,s,n,i,r,a,l){const o=[],c=[];let u=1;for(const[e,s]of Object.entries(t))if("updated_at"===e&&s)o.push(`${e} = ${this.dateNow()}`);else if("updated_by"===e&&s)o.push(`${e} = $${u}`),c.push(l),u++;else if("string"==typeof s&&s.startsWith("CASE WHEN"))o.push(`${e} = ${s}`);else if("string"==typeof s&&s.includes("{{{")&&s.includes("}}}")){const t=s.slice(3,-3),a=this.sanitizeAndBuildRawExpression(t,n,i,r);o.push(`${e} = ${a}`)}else if("string"==typeof s&&s.includes("{#{")&&s.includes("}#}")){const t=s.replace("{#{","{{{").replace("}#}","}}}"),a=this.sanitizeAndBuildRawExpression(t,n,i,r,!1);o.push(`${e} = $${u}`),c.push(a),u++}else if("string"==typeof s&&s.includes("@table")){const t=s.replace(/@table\w+\.\w+/g,(e=>this.resolvePlaceholder(e,n,i,r)));o.push(`${e} = $${u}`),c.push(t),u++}else if("string"==typeof s&&s.includes("##table")){const t=s.replace(/##table\w+\.\w+/g,(e=>this.resolvePlaceholder(e,n,i,r)));o.push(`${e} = $${u}`),c.push(t),u++}else o.push(`${e} = $${u}`),c.push(s),u++;s.company_id=a,u=u>0?u-1:0;const p=Object.entries(s).map((([e,t],s)=>{if("raw"===e){let e=t;return"string"==typeof e&&e.includes("@table")&&(e=this.sanitizeAndBuildRawExpression(e,n,i,r)),`${e}`}if("object"==typeof t){const s=t.operator||"=";let a=t.value;if("string"==typeof a&&a.includes("@table")&&(a=this.resolvePlaceholder(a,n,i,r)),"IN"===s||"NOT IN"===s){if(Array.isArray(a)){const t=a.map(((e,t)=>(u++,`$${u}`)));return c.push(...a),`${e} ${s} (${t.join(", ")})`}return`${e} ${s} (${a})`}return c.push(a),u++,`${e} ${s} $${u}`}if("string"==typeof t&&t.includes("{{{")&&t.includes("}}}")){const s=t.slice(3,-3);return`${e} = ${this.sanitizeAndBuildRawExpression(s,n,i,r)}`}if("string"==typeof t&&t.includes("@table")){const s=this.resolvePlaceholder(t,n,i,r);return c.push(s),u++,`${e} = $${u}`}return c.push(t),u++,`${e} = $${u}`})).join(" AND ");let h="";if("sql"===config_1.dbDetails.from)h=`UPDATE ${e} SET ${o.join(", ")} OUTPUT INSERTED.* WHERE ${p}`;else h=`UPDATE ${e} SET ${o.join(", ")} WHERE ${p} RETURNING *`;return{text:h,values:c}}static generateSelectQuery(e,t,s,n,i,r){const a=t.join(", "),l=[];s.company_id=r;let o=0;const c={text:`SELECT ${a} FROM ${e} WHERE ${Object.entries(s).map((([e,t],s)=>{if("raw"===e){let e=t;return"string"==typeof e&&e.includes("@table")&&(e=this.sanitizeAndBuildRawExpression(e,n,i,s)),`${e}`}if("object"==typeof t){const r=t.operator||"=";let a=t.value;if("string"==typeof a&&a.includes("@table")&&(a=this.resolvePlaceholder(a,n,i,s)),"IN"===r||"NOT IN"===r){if(Array.isArray(a)){const t=a.map(((e,t)=>(o++,`$${o}`)));return l.push(...a),`${e} ${r} (${t.join(", ")})`}return`${e} ${r} (${a})`}return l.push(a),o++,`${e} ${r} $${o}`}if("string"==typeof t&&t.includes("{{{")&&t.includes("}}}")){const r=t.slice(3,-3);return`${e} = ${this.sanitizeAndBuildRawExpression(r,n,i,s)}`}if("string"==typeof t&&t.includes("@table")){const r=this.resolvePlaceholder(t,n,i,s);return l.push(r),o++,`${e} = $${o}`}return l.push(t),o++,`${e} = $${o}`})).join(" AND ")} LIMIT 1`,values:l};return console.log("Generated Select Query:",c),c}static generateDeleteQuery(e,t,s,n,i,r){const a=[];t.company_id=r;let l=0;const o=Object.entries(t).map((([e,t],r)=>{if("raw"===e){let e=t;return"string"==typeof e&&e.includes("@table")&&(e=this.sanitizeAndBuildRawExpression(e,s,n,i)),`${e}`}if("object"==typeof t){const r=t.operator||"=";let o=t.value;if("string"==typeof o&&o.includes("@table")&&(o=this.resolvePlaceholder(o,s,n,i)),"IN"===r||"NOT IN"===r){if(Array.isArray(o)){const t=o.map(((e,t)=>(l++,`$${l}`)));return a.push(...o),`${e} ${r} (${t.join(", ")})`}return`${e} ${r} (${o})`}return a.push(o),l++,`${e} ${r} $${l}`}if("string"==typeof t&&t.includes("{{{")&&t.includes("}}}")){const r=t.slice(3,-3);return`${e} = ${this.sanitizeAndBuildRawExpression(r,s,n,i)}`}if("string"==typeof t&&t.includes("@table")){const r=this.resolvePlaceholder(t,s,n,i);return a.push(r),l++,`${e} = $${l}`}return a.push(t),l++,`${e} = $${l}`})).join(" AND ");let c="";if("sql"===config_1.dbDetails.from)c=`DELETE FROM ${e} OUTPUT DELETED.* WHERE ${o}`;else c=`DELETE FROM ${e} WHERE ${o} RETURNING *`;const u={text:c,values:a};return console.log("Generated Delete Query:",u),u}static generateSoftDeleteQuery(e,t,s,n,i,r,a,l,o=[]){const c=[];let u="status_id = 3";r.deleted_by&&(u+=`, deleted_by = ${l}`),r.deleted_at&&(u+=`, deleted_at = ${this.dateNow()}`),t.company_id=a;let p=0;const h=Object.entries(t).map((([e,t],r)=>{if("raw"===e){let e=t;return"string"==typeof e&&e.includes("@table")&&(e=this.sanitizeAndBuildRawExpression(e,s,n,i)),`${e}`}if("object"==typeof t){const r=t.operator||"=";let a=t.value;if("string"==typeof a&&a.includes("@table")&&(a=this.resolvePlaceholder(a,s,n,i)),"IN"===r||"NOT IN"===r){if(Array.isArray(a)){const t=a.map(((e,t)=>(p++,`$${p}`)));return c.push(...a),`${e} ${r} (${t.join(", ")})`}return`${e} ${r} (${a})`}return c.push(a),p++,`${e} ${r} $${p}`}if("string"==typeof t&&t.includes("{{{")&&t.includes("}}}")){const r=t.slice(3,-3);return`${e} = ${this.sanitizeAndBuildRawExpression(r,s,n,i)}`}if("string"==typeof t&&t.includes("@table")){const r=this.resolvePlaceholder(t,s,n,i);return c.push(r),p++,`${e} = $${p}`}return c.push(t),p++,`${e} = $${p}`})).join(" AND ");let d="";if("sql"===config_1.dbDetails.from){if(o.length){const e=Date.now();o.map((t=>{t.column_name&&t.column_length&&(u+=`, \n                ${t.column_name} = CASE \n                  WHEN LEN(${t.column_name} + '_' + CAST(${e} AS NVARCHAR)) > ${t.column_length} THEN\n                      LEFT(${t.column_name}, ${t.column_length} - LEN('_' + CAST(${e} AS NVARCHAR))) + '_' + CAST(${e} AS NVARCHAR)\n                  ELSE\n                    ${t.column_name} + '_' + CAST(${e} AS NVARCHAR)\n                END`)}))}d=`UPDATE ${e} SET ${u} OUTPUT INSERTED.* WHERE ${h}`}else{if(o.length){const e=Date.now();o.map((t=>{t.column_name&&t.column_length&&(u+=`, \n                ${t.column_name} = CASE \n                  WHEN LENGTH(${t.column_name} || '_' || ${e}) > ${t.column_length} THEN\n                      LEFT(${t.column_name}, ${t.column_length} - LENGTH('_' || ${e})) || '_' || ${e}\n                  ELSE\n                    ${t.column_name} || '_' || ${e}\n                END`)}))}d=`UPDATE ${e} SET ${u} WHERE ${h} RETURNING *`}const $={text:d,values:c};return console.log("Generated Soft Delete Query:",$),$}static sanitizeAndBuildRawExpression(e,t,s,n,i=!0){let r=e.match(/@table\w+\.\w+/g);return r&&r.forEach((r=>{const a=this.resolvePlaceholder(r,t,s,n),l="string"==typeof a&&i?pg_escape_1.default.literal(a):a;e=e.replace(r,l)})),r=e.match(/##table\w+\.\w+/g),r&&r.forEach((r=>{const a=this.resolvePlaceholder(r,t,s,n),l="string"==typeof a&&i?pg_escape_1.default.literal(a):a;e=e.replace(r,l)})),e}static resolvePlaceholder(e,t,s,n){if(e.startsWith("##"))return`${e.replace("##","@")}`;{const[s,i]=e.slice(1).split("."),r=t[s];if(!r||0===r.length)throw new Error(`No result for given table: "${s}"`);const a=r.length>n?r[n]:r[0];if(!a||0===a.length)throw new Error(`No record found for given parameter: "${s}"`);const l=a[0][i];if(void 0===l)throw new Error(`Field not found for given table (${s}): "${i}"`);return l}}static generateUpsertQuery(e,t,s,n,i,r,a,l){const o=[],c=[],u=[],p=[];let h=1;for(const[e,s]of Object.entries(t))if("created_by"===e&&!0===s)o.push(e),c.push(`$${h}`),p.push(l),h++;else if("created_at"===e&&!0===s)o.push(e),c.push(this.dateNow());else if("updated_at"===e&&s)u.push(`${e} = ${this.dateNow()}`),o.push(e),c.push(this.dateNow());else if("updated_by"===e&&s)u.push(`${e} = $${h}`),o.push(e),c.push(`$${h}`),p.push(l),h++;else if("string"==typeof s&&s.includes("{{{")&&s.includes("}}}")){const t=s.slice(3,-3),a=this.sanitizeAndBuildRawExpression(t,n,i,r);u.push(`${e} = ${a}`),o.push(e),c.push(a)}else if("string"==typeof s&&s.includes("{#{")&&s.includes("}#}")){const t=s.replace("{#{","{{{").replace("}#}","}}}"),a=this.sanitizeAndBuildRawExpression(t,n,i,r,!1);u.push(`${e} = $${h}`),o.push(e),c.push(`$${h}`),p.push(a),h++}else if("string"==typeof s&&s.includes("@table")){const t=s.replace(/@table\w+\.\w+/g,(e=>this.resolvePlaceholder(e,n,i,r)));u.push(`${e} = $${h}`),o.push(e),c.push(`$${h}`),p.push(t),h++}else if("string"==typeof s&&s.includes("##table")){const t=s.replace(/##table\w+\.\w+/g,(e=>this.resolvePlaceholder(e,n,i,r)));u.push(`${e} = $${h}`),o.push(e),c.push(`$${h}`),p.push(t),h++}else u.push(`${e} = $${h}`),o.push(e),c.push(`$${h}`),p.push(s),h++;t.company_id=a,o.push("company_id"),c.push(`$${h}`),p.push(a);const d=Object.entries(s).map((([e,t])=>{if("raw"===e){let e=t;return"string"==typeof e&&e.includes("@table")&&(e=this.sanitizeAndBuildRawExpression(e,n,i,r)),`${e}`}if("object"==typeof t){const s=t.operator||"=";let a=t.value;if("string"==typeof a&&a.includes("@table")&&(a=this.resolvePlaceholder(a,n,i,r)),"IN"===s||"NOT IN"===s){if(Array.isArray(a)){const t=a.map(((e,t)=>(h++,`$${h}`)));return p.push(...a),`${e} ${s} (${t.join(", ")})`}return`${e} ${s} (${a})`}return p.push(a),h++,`${e} ${s} $${h}`}if("string"==typeof t&&t.includes("{{{")&&t.includes("}}}")){const s=t.slice(3,-3);return`${e} = ${this.sanitizeAndBuildRawExpression(s,n,i,r)}`}if("string"==typeof t&&t.includes("@table")){const s=this.resolvePlaceholder(t,n,i,r);return p.push(s),h++,`${e} = $${h}`}return p.push(t),h++,`${e} = $${h}`})).join(" AND ");let $="";if("sql"===config_1.dbDetails.from)$=`MERGE ${e} AS target\n              USING (SELECT 1 as dummy) AS source\n              ON ${d}\n              WHEN MATCHED THEN\n                UPDATE SET ${u.join(", ")}\n              WHEN NOT MATCHED THEN\n                INSERT (${o.join(", ")})\n                VALUES (${c.join(", ")})\n              OUTPUT INSERTED.*;`;else $=`WITH upsert AS (\n                  UPDATE ${e}\n                  SET ${u.join(", ")}\n                  WHERE ${d}\n                  RETURNING *\n              )\n              INSERT INTO ${e} (${o.join(", ")})\n              SELECT ${c.join(", ")}\n              WHERE NOT EXISTS (SELECT 1 FROM upsert)\n              RETURNING *`;const f={text:$,values:p};return console.log("Generated Conditional Upsert Query:",f),f}}exports.transactionQueryBuilderService=transactionQueryBuilderService;