"use strict";
/**
 * @openapi
 * /cron/truncate-audit-logs:
 *   get:
 *     tags:
 *       - Cron
 *     summary: truncate audit logs.
 *     description: |
 *       Truncate the audit logs.
 *
 *       **Note:**
 *       - **API should not contain the `/api` prefix in URL.**
 *       - **Use the server URL `${appDetails.baseUrl}` for this API.**
 *     responses:
 *       200:
 *         description: OK
 */
/**
 * @openapi
 * /cron/truncate-request-logs:
 *   get:
 *     tags:
 *       - Cron
 *     summary: truncate request logs.
 *     description: |
 *       Truncate the request logs.
 *
 *       **Note:**
 *       - **API should not contain the `/api` prefix in URL.**
 *       - **Use the server URL `${appDetails.baseUrl}` for this API.**
 *     responses:
 *       200:
 *         description: OK
 */
/**
 * @openapi
 * /cron/schedule-import-job:
 *   get:
 *     tags:
 *       - Cron
 *     summary: Schedule import jobs.
 *     description: |
 *       Process the schedule import jobs.
 *
 *       **Note:**
 *       - **API should not contain the `/api` prefix in URL.**
 *       - **Use the server URL `${appDetails.baseUrl}` for this API.**
 *     responses:
 *       200:
 *         description: OK
 */
/**
 * @openapi
 * /cron/process-email-jobs:
 *   get:
 *     tags:
 *       - Cron
 *     summary: Process email jobs.
 *     description: |
 *       Process the email template content and recipient using inserted email process jobs.
 *
 *       **Note:**
 *       - **API should not contain the `/api` prefix in URL.**
 *       - **Use the server URL `${appDetails.baseUrl}` for this API.**
 *     responses:
 *       200:
 *         description: OK
 */
/**
 * @openapi
 * /cron/process-whatsapp-jobs:
 *   get:
 *     tags:
 *       - Cron
 *     summary: Process whatsapp jobs.
 *     description: |
 *       Process the whatsapp template content and recipient using inserted whatsapp process jobs.
 *
 *       **Note:**
 *       - **API should not contain the `/api` prefix in URL for whatsapp cron.**
 *       - **Use the server URL `${appDetails.baseUrl}` for this API.**
 *     responses:
 *       200:
 *         description: OK
 */
/**
 * @openapi
 * /cron/send-notification-jobs:
 *   get:
 *     tags:
 *       - Cron
 *     summary: Send notification jobs.
 *     description: |
 *       Send the notifications which are processed by the notification process jobs like email or whatsapp.
 *
 *       **Note:**
 *       - **API should not contain the `/api` prefix in URL.**
 *       - **Use the server URL `${appDetails.baseUrl}` for this API.**
 *     responses:
 *       200:
 *         description: OK
 */
/**
 * @openapi
 * /cron/sync-whatsapp-templates:
 *   get:
 *     tags:
 *       - Cron
 *     summary: Sync whatsapp templates.
 *     description: |
 *       Sync whatsapp templates to LCP DB.
 *
 *       **Note:**
 *       - **API should not contain the `/api` prefix in URL.**
 *       - **Use the server URL `${appDetails.baseUrl}` for this API.**
 *     responses:
 *       200:
 *         description: OK
 */
/**
 * @openapi
 * /datasync/push:
 *   post:
 *     tags:
 *       - Data Sync
 *     summary: Push data from PostgreSQL to SQLite.
 *     description: Push data from PostgreSQL to SQLite based on the queries defined in the DataTransferQueryTable.
 *     requestBody:
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             required:
 *               - dbFileName
 *               - serverURL
 *               - deviceRegistrationID
 *             properties:
 *               dbFileName:
 *                 type: string
 *                 description: SQLite database file path
 *               serverURL:
 *                 type: string
 *                 description: Server URL for additional configuration ex:http://localhost:3131/
 *               deviceRegistrationID:
 *                 type: string
 *                 description: Device Registration ID to track the operation
 *     responses:
 *       200:
 *         description: Data pushed successfully
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *       500:
 *         description: Error occurred during the push operation
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *                 error:
 *                   type: string
 */
/**
 * @openapi
 * /datasync/pull:
 *   post:
 *     tags:
 *       - Data Sync
 *     summary: Pull data from SQLite to PostgreSQL.
 *     description: Pull data from SQLite to PostgreSQL based on the queries defined in the DataTransferQueryTable.
 *     requestBody:
 *       content:
 *         multipart/form-data:
 *           schema:
 *             type: object
 *             required:
 *               - dbFile
 *             properties:
 *               dbFile:
 *                 type: string
 *                 format: binary
 *                 description: SQLite database file to upload
 *     responses:
 *       200:
 *         description: Data pulled successfully
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *       400:
 *         description: Invalid request, missing file or userID
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *       500:
 *         description: Error occurred during the pull operation
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *                 error:
 *                   type: string
 */
