import { PrismaClient } from '@prisma/pg/client';
import { v4 as uuidv4 } from 'uuid';

const prisma = new PrismaClient();

const datas = [
  {
    slug: 'forgot-password',
    name: 'Forgot Password',
    subject: 'Account Password Reset Request',
    template_body:
      "<p>Please use the following OTP to reset your password:</p><h2>[otp]</h2> <p>If you didn't request this OTP, please ignore this email.</p>",
    email_template_process_slug: 'forgot-password',
    status_id: 1,
  },
  {
    slug: 'login-otp',
    name: 'Login OTP',
    subject: 'Your One-Time Password (OTP) for Login Verification',
    template_body:
      "<p>Please use this OTP to login to your account:</p> <h2>[otp]</h2> <p>If you didn't request this OTP, please ignore this email.</p>",
    email_template_process_slug: 'login-otp',
    status_id: 1,
  },
  {
    slug: 'email-verify',
    name: 'Email Verification',
    subject: 'Verify Email Address',
    template_body:
      "<p>Please use the following OTP to verify your email address:</p> <h2>[otp]</h2> <p>If you didn't request this OTP, please ignore this email.</p>",
    email_template_process_slug: 'email-verify',
    status_id: 1,
  },
  {
    slug: 'user-register',
    name: 'User Register',
    subject: 'New User Registration',
    template_body:
      '<h1>Welcome aboard!</h1><p>Thank you for registering with us.</p>',
    email_template_process_slug: 'user-register',
    status_id: 1,
  },
  {
    slug: 'user_template_user_created',
    name: 'user template - user created',
    subject: 'Welcome to LCP',
    template_body:
      '<p>Hi [user_fullname], </p><p></p><h1 class="ql-align-center">Welcome aboard!</h1><p class="ql-align-center">Thank you for registering with us.</p><p class="ql-align-center">Your user details given below.</p><p class="ql-align-center"></p><ol><li>email : [user_email]</li><li>phone : [user_phone]</li><li>username : [username]</li></ol>',
    email_template_process_slug: 'user-created',
    status_id: 1,
  },
  {
    slug: 'admin_template_user_created',
    name: 'admin template - user created',
    subject: 'New user created',
    template_body:
      '<p>Hi Admin,</p><p></p><h1 class="ql-align-center">New user created!</h1><p class="ql-align-center">User details given below.</p><p class="ql-align-center"></p><ol><li>email : [user_email]</li><li>phone : [user_phone]</li><li>username : [username]</li></ol>',
    email_template_process_slug: 'user-created',
    status_id: 1,
  },
  {
    slug: 'department_head_template_user_created',
    name: 'department head template - user created',
    subject: 'New user created in your Department',
    template_body:
      '<p>Hi,</p><p></p><h1 class="ql-align-center">New user created in your Department!</h1><p class="ql-align-center">User details given below.</p><p class="ql-align-center"></p><ol><li>email : [user_email]</li><li>phone : [user_phone]</li><li>username : [username]</li></ol>',
    email_template_process_slug: 'user-created',
    status_id: 1,
  },
  {
    slug: 'mail-import',
    name: 'Mail Import',
    subject: 'Details Imported by  [user_fullname],',
    template_body:
      '<p>Hi, [user_email] - [user_fullname] data has been imported and attached the details in the below file</p><p></p>',
    email_template_process_slug: 'mail-import',
    status_id: 1,
  },
  {
    slug: 'user_rejected',
    name: 'reject-user-mail',
    subject: 'Request Rejected',
    template_body:
      '<p>Hi [user_fullname],</p><p></p><p>The latest update on your profile : [user_email], has been rejected by the admin.</p><p></p>',
    email_template_process_slug: 'reject-user-mail',
    status_id: 1,
  },
  {
    slug: 'user_accepted',
    name: 'accept-user-mail',
    subject: 'Request Accepted',
    template_body:
      '<p>Hi [user_fullname],</p><p></p><p>The latest update on your profile : [user_email], has been accepted by the admin.</p>',
    email_template_process_slug: 'approval-user-mail',
    status_id: 1,
  }
];

export async function emailTemplatesSeeder(company_id: number) {
  try {
    let user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });
    if (!user) {
      console.log(
        `Menu seeder failed: admin user not available for company id ${company_id}`,
      );
      return false;
    }

    const created_by = user.id;

    const company = await prisma.user.findFirst({
      where: { company_id: company_id },
    });

    if (!company) {
      console.log(`WARNING: Company with id ${company_id} does not exist.`);
      return;
    }

    for (const data of datas) {
      const emailTemplateProcess = await prisma.emailTemplateProcess.findFirst({
        where: {
          slug: data.email_template_process_slug,
          company_id: company_id,
        },
      });

      if (!emailTemplateProcess) {
        console.log(
          `Email Template Process with slug "${data.email_template_process_slug}" not found for company_id ${company_id}. Skipping template creation.`,
        );
        continue;
      }

      const existingTemplate = await prisma.emailTemplate.findFirst({
        where: {
          slug: data.slug,
          company_id: company_id,
        },
      });

      if (!existingTemplate) {
        try {
          await prisma.emailTemplate.create({
            data: {
              uuid: uuidv4(),
              slug: data.slug,
              name: data.name,
              subject: data.subject,
              template_body: data.template_body,
              email_template_process_id: emailTemplateProcess.id,
              status_id: data.status_id,
              company_id: company_id,
              created_by: created_by,
            },
          });
          console.log(
            `Created new Email Template: ${data.name} for company_id ${company_id}`,
          );
        } catch (createError) {
          console.error(
            `Error creating email template with slug "${data.slug}":`,
            createError,
          );
        }
      } else {
        console.log(
          `Email Template with slug "${data.slug}" already exists for company_id ${company_id}.`,
        );
      }
    }
  } catch (error) {
    console.error(`Error in seedEmailTemplates: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
