CREATE OR REPLACE VIEW unsubmitted_timesheet AS
WITH past_week AS (
    SELECT id 
    FROM yearly_week 
    WHERE is_current_year = true AND EXTRACT(WEEK FROM start_date) = EXTRACT(WEEK FROM CURRENT_DATE - interval '1 week') -- This gets the past week
    ORDER BY start_date DESC 
    LIMIT 1
),
users_unsubmitted_timesheets AS (
    SELECT COUNT(DISTINCT u.id) AS total_count
    FROM users u 
    LEFT JOIN time_sheet ts ON ts.user_id = u.id AND u.role = 'admin' 
    WHERE ts.is_saved = false AND u.azure_id is not null AND ts.week_id = (SELECT id FROM past_week)
),
reportees_unsubmitted_timesheets AS (
    SELECT 
        u.id AS manager_id,
        COUNT(DISTINCT r.id) AS reportee_count
    FROM 
        users u
    LEFT JOIN 
        users r ON u.id = r.reporting_to
    LEFT JOIN 
        time_sheet ts ON r.id = ts.user_id AND ts.week_id = (SELECT id FROM past_week)
    WHERE 
        ts.is_saved = false
    GROUP BY 
        u.id
)
SELECT 
    u.id AS user_id,
    u.status_id AS status_id,
    u.company_id AS company_id,
    CASE 
        WHEN u.email IN ('venkatesha@techcedence.com', 'gobij@techcedence.com', 'krishnak@techcedence.com') 
        THEN (SELECT total_count FROM users_unsubmitted_timesheets)
        ELSE COALESCE(r.reportee_count, 0)
    END AS user_reportees_count
FROM 
    users u
LEFT JOIN 
    reportees_unsubmitted_timesheets r ON u.id = r.manager_id
ORDER BY 
    u.id;