import { ScheduledJob, PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

export async function scheduledJobSeeder() {
  try {
    const scheduledJobArr: any[] = [];

    for (const scheduledJob of scheduledJobArr) {
      await findOrCreateScheduledJob(scheduledJob);
    }

    console.log('ScheduledJob creation completed.');
  } catch (error) {
    throw error;
  }
}

async function findOrCreateScheduledJob(scheduledJob: any) {
  try {
    let resData: ScheduledJob | undefined | null;

    resData = await prisma.scheduledJob.findUnique({
      where: { id: scheduledJob.id },
    });

    if (!resData) {
      let data = {
        ...scheduledJob,
      };

      resData = await prisma.scheduledJob.create({
        data,
      });
      console.log(
        `ScheduledJob created successfully: ${scheduledJob.cron_url}`,
      );
    } else {
      let data = {
        ...scheduledJob,
      };

      resData = await prisma.scheduledJob.update({
        where: { id: resData.id },
        data,
      });
      console.log(`ScheduledJob updated successfully: ${resData.cron_url}`);
    }

    return resData;
  } catch (error) {
    console.log(`ScheduledJob seeder failed: ${scheduledJob.cron_url}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
