import { PrismaClient} from '@prisma/pg/client'
import fs from 'fs';
const prisma = new PrismaClient();
  
export async function gridSeeder(company_id:number) {
    try {  
        const fieldTypes = JSON.parse(fs.readFileSync(__dirname+'/json/field-types.json', 'utf-8'));
        const masterEntitys = JSON.parse(fs.readFileSync(__dirname+'/json/master-grid.json', 'utf-8'));
        for (const masterEntity of masterEntitys) {
            const { export_template_id, lineitems, ...masterEntityData } = masterEntity;

            let export_template:any = null;
            if(export_template_id){
              const template:any = await prisma.exportTemplate.findFirst({
                where : {
                  company_id: company_id,
                  slug: export_template_id
                }
              });
              export_template = template?.id || null;
            }
        
            // Upsert MasterEntity
            const mg = await prisma.masterEntity.upsert({
              where: {
                company_id_entity_name: {
                  company_id, entity_name: masterEntity.entity_name
                }
              },
              update: {...masterEntityData, export_template_id: export_template },
              create: {...masterEntityData, export_template_id: export_template, company_id}
            });
        
            // Upsert MasterEntityLineItems
            const fieldTypeLength = fieldTypes?.length || 1;
            if(lineitems && lineitems.length){
              for (const lineitem of lineitems) {
                const field_type_id = lineitem.field_type_id + ((company_id - 1) * fieldTypeLength);
                await prisma.masterEntityLineItem.upsert({
                  where: { company_id_master_grid_id_display_name: {  // this should match the name of your composite unique constraint
                      company_id,
                      master_grid_id:mg.id,
                      display_name: lineitem.display_name
                    }
                  },
                  update: {...lineitem, company_id, master_grid_id: mg.id, field_type_id},
                  create: {...lineitem, company_id, master_grid_id: mg.id, field_type_id}
                });
              }
            }
          }
      console.log('Grid creation completed.');
    } catch (error) {
      console.log(`Grid seeder failed.`);
      throw error;
    }
}
