import {
  EmailTemplateProcessTagsMapping,
  EmailTemplateProcess,
  EmailTemplateTag,
  PrismaClient,
  EmailTemplateRecipientTag,
} from '@prisma/pg/client';
const prisma = new PrismaClient();
import fs from 'fs';

async function findOrCreateProcess(process: any, company_id: number) {
  try {
    let templateProcess: EmailTemplateProcess | null =
      await prisma.emailTemplateProcess.findUnique({
        where: { company_id_slug: { company_id, slug: process.slug } },
      });

    if (!templateProcess) {
      let data = {
        ...process,
        company_id,
        query_information: '',
      };
      if (process.query_information) {
        data.query_information = JSON.stringify(process.query_information);
      }

      templateProcess = await prisma.emailTemplateProcess.create({
        data,
      });
      console.log(
        `Email Template Process created successfully: ${templateProcess.name}`,
      );
    } else {
      let data = {
        ...process,
        query_information: '',
      };
      if (process.query_information) {
        data.query_information = JSON.stringify(process.query_information);
      }

      templateProcess = await prisma.emailTemplateProcess.update({
        where: { company_id_slug: { company_id, slug: process.slug } },
        data,
      });
      console.log(
        `Email Template Process updated successfully: ${templateProcess.name}`,
      );
    }

    return templateProcess;
  } catch (error) {
    console.log(`Email Template Process seeder failed: ${process.name}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}

async function findOrCreateEmailTags(tag: any, company_id: number) {
  try {
    let templateTag: EmailTemplateTag | null =
      await prisma.emailTemplateTag.findUnique({
        where: { company_id_slug: { company_id, slug: tag.slug } },
      });

    if (!templateTag) {
      let data = {
        ...tag,
        company_id,
      };

      templateTag = await prisma.emailTemplateTag.create({
        data,
      });
      console.log(`Email Template Tag created successfully: ${tag.slug}`);
    } else {
      let data = {
        ...tag,
      };

      templateTag = await prisma.emailTemplateTag.update({
        where: { company_id_slug: { company_id, slug: tag.slug } },
        data,
      });
      console.log(
        `Email Template Tag updated successfully: ${templateTag.slug}`,
      );
    }

    return templateTag;
  } catch (error) {
    console.log(`Email Template Tag seeder failed: ${tag.slug}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}

async function findOrCreateEmailRecipientTags(tag: any, company_id: number) {
  try {
    let templateTag: EmailTemplateRecipientTag | null =
      await prisma.emailTemplateRecipientTag.findUnique({
        where: { company_id_slug: { company_id, slug: tag.slug } },
      });

    if (!templateTag) {
      let data = {
        ...tag,
        company_id,
        query_information: '',
      };
      if (tag.query_information) {
        data.query_information = JSON.stringify(tag.query_information);
      }

      templateTag = await prisma.emailTemplateRecipientTag.create({
        data,
      });
      console.log(
        `Email Template Recipient Tag created successfully: ${tag.slug}`,
      );
    } else {
      let data = {
        ...tag,
        query_information: '',
      };
      if (tag.query_information) {
        data.query_information = JSON.stringify(tag.query_information);
      }

      templateTag = await prisma.emailTemplateRecipientTag.update({
        where: { company_id_slug: { company_id, slug: tag.slug } },
        data,
      });
      console.log(
        `Email Template Recipient Tag updated successfully: ${templateTag.slug}`,
      );
    }

    return templateTag;
  } catch (error) {
    console.log(`Email Template Recipient Tag seeder failed: ${tag.slug}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}

async function findOrCreateEmailTagsAndTemplateMap(
  map: any,
  company_id: number,
) {
  try {
    const email_template_process = await prisma.emailTemplateProcess.findUnique(
      {
        where: {
          company_id_slug: { company_id, slug: map.email_template_process },
        },
      },
    );
    const email_template_tag = await prisma.emailTemplateTag.findUnique({
      where: { company_id_slug: { company_id, slug: map.email_template_tag } },
    });
    if (email_template_process && email_template_tag) {
      let templateGroup: EmailTemplateProcessTagsMapping | null =
        await prisma.emailTemplateProcessTagsMapping.findUnique({
          where: {
            email_template_process_id_email_template_tag_id_company_id: {
              email_template_process_id: email_template_process.id,
              email_template_tag_id: email_template_tag.id,
              company_id,
            },
          },
        });

      if (!templateGroup) {
        let data = {
          email_template_process_id: email_template_process.id,
          email_template_tag_id: email_template_tag.id,
          company_id,
        };

        templateGroup = await prisma.emailTemplateProcessTagsMapping.create({
          data,
        });
        console.log(
          `Email Template group map created successfully: ${email_template_process.id}, ${email_template_tag.id}, ${company_id}`,
        );
      } else {
        console.log(
          `Email Template group map already exist: ${email_template_process.id}, ${email_template_tag.id}, ${company_id}`,
        );
      }

      return templateGroup;
    }
    return false;
  } catch (error) {
    console.log(
      `Email Template group map seeder failed: ${map.email_template_process}, ${map.email_template_tag}, ${company_id}`,
    );
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}

export async function emailTemplatesProcessSeeder(company_id: number) {
  try {
    const company = await prisma.user.findFirst({
      where: { company_id: company_id },
    });

    if (!company) {
      console.log(
        `WARNING: emailTemplatesProcessSeeder: Company with id ${company_id} does not exist.`,
      );
      return;
    }

    const datas = JSON.parse(
      fs.readFileSync(__dirname + '/json/email-template-process.json', 'utf-8'),
    );;

    for (const process of datas) {
      await findOrCreateProcess(process, company_id);
    }

    const tags: any = [];

    for (const tag of tags) {
      await findOrCreateEmailTags(tag, company_id);
    }

    const emailProcessAndTagGroup: any = [];

    for (const map of emailProcessAndTagGroup) {
      await findOrCreateEmailTagsAndTemplateMap(map, company_id);
    }

    const recipientTags: any = [];

    for (const tag of recipientTags) {
      await findOrCreateEmailRecipientTags(tag, company_id);
    }

    console.log('Email Template process creation completed.');
  } catch (error) {
    throw error;
  }
}
