import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';

const prisma = new PrismaClient();

// Define the wizard groups (assuming you only have one entry)
const wizardGroups = [{ id: 1, name: 'Static', slug: 'static' }];
let wizID: number = 0;

// Read the dashboard wizard data from JSON
const dashboardWizardData = JSON.parse(
  fs.readFileSync(__dirname + '/json/dashboard-wizard.json', 'utf-8'),
);

export async function wizardGroupSeeder(company_id: number) {
  try {
    // Delete existing entities to avoid conflicts (optional)

    for (const wizardGroup of wizardGroups) {
      const existingwizardGroup = await prisma.wizardGroup.findUnique({
        where: { id: wizardGroup.id },
      });
      wizID = existingwizardGroup?.id ?? 0;

      if (!existingwizardGroup) {
        const createdwizardGroup = await prisma.wizardGroup.create({
          data: {
            id: wizardGroup.id,
            name: wizardGroup.name,
            slug: wizardGroup.slug,
            company_id: company_id,
          },
        });
        console.log(
          `Created wizardGroup with id ${createdwizardGroup.id}: ${createdwizardGroup.name}`,
        );
        wizID = createdwizardGroup?.id ?? 0;
      }
        // Now process the dashboard wizard data
      for (const dashboardWizard of dashboardWizardData) {
          const existingMasterEntity = await prisma.masterEntity.findFirst({
            where: {
              company_id: company_id,
              entity_name: dashboardWizard.entity_name,
            },
          });
          if (!existingMasterEntity) {
            await prisma.masterEntity.create({
              data: {
                company_id: company_id,
                entity_name: dashboardWizard.entity_name,
                entity_type: dashboardWizard.entity_type,
                dashboard_wizard_group_id: wizID,
                dashboard_wizard_columns:
                  dashboardWizard.dashboard_wizard_columns,
                dashboard_wizard_rows: dashboardWizard.dashboard_wizard_rows,
                dashboard_wizard_type: dashboardWizard.dashboard_wizard_type,
                name: dashboardWizard.name,
                static_page_content: dashboardWizard.static_page_content,
                report_type: dashboardWizard.report_type || 'lcp',
                report_information: dashboardWizard.report_information || null,
                dashboard_wizard_order_no:
                  dashboardWizard.dashboard_wizard_order_no,
                dashboard_wizard_options:
                  dashboardWizard.dashboard_wizard_options,
                query_information: dashboardWizard.query_information,
                status_id: dashboardWizard.status_id|| 1
              },
            });
            console.log(
              `Created master entity with order no ${dashboardWizard.dashboard_wizard_order_no}`,
            ); 
        } else {
          await prisma.masterEntity.updateMany({
              where: {entity_name: dashboardWizard.entity_name},
              data: {
                company_id: company_id,
                entity_type: dashboardWizard.entity_type,
                dashboard_wizard_group_id: wizID,
                entity_name: dashboardWizard.entity_name,
                dashboard_wizard_columns:
                  dashboardWizard.dashboard_wizard_columns,
                dashboard_wizard_rows: dashboardWizard.dashboard_wizard_rows,
                dashboard_wizard_type: dashboardWizard.dashboard_wizard_type,
                name: dashboardWizard.name,
                static_page_content: dashboardWizard.static_page_content,
                report_type: dashboardWizard.report_type || 'lcp',
                report_information: dashboardWizard.report_information || null,
                dashboard_wizard_order_no:
                  dashboardWizard.dashboard_wizard_order_no,
                dashboard_wizard_options:
                  dashboardWizard.dashboard_wizard_options,
                query_information: dashboardWizard.query_information,
                status_id: dashboardWizard.status_id|| 1
              },
            });
        }
      }
    }
  } catch (error) {
    console.error(`Error in wizardGroupSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
