import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

function getCurrentUtcTime(): string {
  return new Date().toISOString();
}

export async function chileProcessSeeder(company_id: number) {
  try {
    const processes = JSON.parse(
      fs.readFileSync(__dirname + '/json/child-process.json', 'utf-8'),
    );
    const user = await prisma.user.findFirst({
      where: { company_id, role: 'super_admin' },
      select: { id: true },
    });

    if (!user) {
      console.log(
        `Menu seeder failed: admin user not available for company id ${company_id}`,
      );
      return;
    }

    const utcNow = getCurrentUtcTime();

    for (const process of processes) {
      await prisma.childProcess.upsert({
        where: {
          company_id_slug: {
            slug: process.slug,
            company_id,
          },
        },
        update: {
          ...process,
          updated_at: utcNow,
          updated_by: user.id,
          company_id,
        },
        create: {
          ...process,
          created_at: utcNow,
          created_by: user.id,
          company_id,
        },
      });
    }
  } catch (error) {
    console.log(`Background Process seeder failed.`);
    throw error;
  }
}
