"use strict";var __awaiter=this&&this.__awaiter||function(e,t,s,o){return new(s||(s=Promise))((function(r,i){function c(e){try{a(o.next(e))}catch(e){i(e)}}function n(e){try{a(o.throw(e))}catch(e){i(e)}}function a(e){var t;e.done?r(e.value):(t=e.value,t instanceof s?t:new s((function(e){e(t)}))).then(c,n)}a((o=o.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.cronController=void 0;const cron_service_1=require("../../services/cron.service"),response_1=require("../../utilities/response"),common_service_1=require("../../services/common.service"),mail_1=require("../../utilities/mail"),path_1=__importDefault(require("path")),fs_1=__importDefault(require("fs")),prisma_service_1=__importDefault(require("../../services/prisma.service")),lcp_cron_1=__importDefault(require("../../utilities/lcp-cron")),config_1=require("../../../config"),whatsapp_1=require("../../utilities/whatsapp");class CronController{constructor(){this.processEmailJobs=this.processEmailJobs.bind(this),this.processSingleEmailJob=this.processSingleEmailJob.bind(this),this.processMailData=this.processMailData.bind(this)}createCronJobs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=e.body,o=yield cron_service_1.cronService.createCronJobs(s);return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){s(e)}}))}getCronJobs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=yield cron_service_1.cronService.getCronJobs();return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}stopCronJobs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{lcp_cron_1.default.stop();const s=lcp_cron_1.default.getStatus();return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}stopCronJob(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=e.params.id;if(lcp_cron_1.default.getStatus().jobs[s]){lcp_cron_1.default.stopJob(`${s}`);const o=lcp_cron_1.default.getStatus();return(0,response_1.successResponse)(e,t,o,"Success.")}return(0,response_1.errorResponse)(e,t,"Job does not exist","Job does not exist",config_1.statusCodes.data_not_found)}catch(e){s(e)}}))}startCronJob(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=e.params.id,o=lcp_cron_1.default.getStatus();if(console.log("jobs",o),o.jobs[s]){lcp_cron_1.default.startJob(`${s}`);const o=lcp_cron_1.default.getStatus();return(0,response_1.successResponse)(e,t,o,"Success.")}return(0,response_1.errorResponse)(e,t,"Job does not exist","Job does not exist",config_1.statusCodes.data_not_found)}catch(e){s(e)}}))}restartCronJobs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{yield lcp_cron_1.default.refreshJobs();const s=yield cron_service_1.cronService.getCronJobs();return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}removeCronJob(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=e.params.id;if(lcp_cron_1.default.getStatus().jobs[s]){lcp_cron_1.default.stopJob(`${s}`),yield cron_service_1.cronService.removeCronJob(parseInt(s));const o=yield cron_service_1.cronService.getCronJobs();return(0,response_1.successResponse)(e,t,o,"Success.")}{yield cron_service_1.cronService.removeCronJob(parseInt(s));const o=yield cron_service_1.cronService.getCronJobs();return(0,response_1.successResponse)(e,t,o,"Success.")}}catch(e){s(e)}}))}updateCronJob(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=e.body,o=parseInt(e.params.id);if(isNaN(o))return(0,response_1.errorResponse)(e,t,"Invalid job ID: must be a number");lcp_cron_1.default.stopJob(o.toString());const r=yield cron_service_1.cronService.updateCronJob(o,s);return(0,response_1.successResponse)(e,t,Object.assign(Object.assign({},r),{message:"Cron job updated successfully"}),"Success")}catch(e){s(e)}}))}processAuditLogs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=yield cron_service_1.cronService.runScheduledJob("cron/truncate-audit-logs",cron_service_1.cronService.processAuditLogs);return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}processRequestLogs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=yield cron_service_1.cronService.runScheduledJob("cron/truncate-request-logs",cron_service_1.cronService.processRequestLogs);return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}scheduleImportJob(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=yield cron_service_1.cronService.runScheduledJob("cron/schedule-import-job",cron_service_1.cronService.scheduleImportJob);return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}processEmailJobs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=yield cron_service_1.cronService.runScheduledJob("cron/process-email-jobs",(()=>__awaiter(this,void 0,void 0,(function*(){const e=yield cron_service_1.cronService.getProcessEmailJobs(),t=yield Promise.all(e.map(this.processSingleEmailJob)),s=e.map((e=>e.id));let o=t.flat().filter((e=>null!==e));return o.length>0&&(yield this.insertNotificationJobs(o)),s.length>0&&(yield cron_service_1.cronService.updateProcessEmailJobs(s)),{status:"success",message:`Processed ${o.length} email jobs.`}}))));return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}processWhatsappJobs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=yield cron_service_1.cronService.runScheduledJob("cron/process-whatsapp-jobs",(()=>__awaiter(this,void 0,void 0,(function*(){const e=yield cron_service_1.cronService.getProcessWhatsappJobs();for(let t of e){yield cron_service_1.cronService.processWhatsappSingleJob(t)}return{status:"success",message:"Processed whatsapp jobs."}}))));return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}processSingleEmailJob(e){return __awaiter(this,void 0,void 0,(function*(){const{unique_id:t,user_id:s,email_template_process_slug:o,prefill_data:r,company_id:i,created_by:c,attachments_name:n,attachments_path:a}=e,_=yield cron_service_1.cronService.getEmailProcess(i,o);if(!_)return null;let l=cron_service_1.cronService.replacePlaceholders(_.query_information||"",t,s,r);const u=l?yield cron_service_1.cronService.getTagData(l,i):{},d=yield cron_service_1.cronService.getAssignedMailData(_.id);return(yield Promise.all(d.map((e=>this.processMailData(e,u,s,r,n,a,i,c,o))))).filter((e=>null!==e))}))}processMailData(e,t,s,o,r,i,c,n,a){return __awaiter(this,void 0,void 0,(function*(){const{recipient_type:_,email_to:l,email_template_cc_bcc:u,email_template:d}=e;let p=cron_service_1.cronService.parseEmailToArray(l);if("tag"===_&&(p=yield this.getEmailsForTagRecipients(p,s,o,c)),p.length>0){const e=Object.assign(Object.assign({},t),JSON.parse(o||"{}")),_=yield cron_service_1.cronService.replaceContentPlaceholders(d.template_body,e),l=yield cron_service_1.cronService.replaceContentPlaceholders(d.subject,e);let v="",f=[],h="",m=[];for(let e of u){let t=cron_service_1.cronService.parseEmailToArray(e.email_to);"tag"===e.recipient_type&&(t=yield this.getEmailsForTagRecipients(t,s,o,c)),"cc"===e.send_type?f.push(t.join(", ")):m.push(t.join(", "))}return f.length&&(v+=f.join(", ")),m.length&&(h+=m.join(", ")),p.map((e=>({process_slug:a,notification_type_id:"ac4",notification_status_id:"ac7",notification_to:e,notification_subject:l,attachments_name:r,attachments_path:i,notification_content:_,notification_cc:v,notification_bcc:h,company_id:c,created_by:n})))}return null}))}getEmailsForTagRecipients(e,t,s,o){return __awaiter(this,void 0,void 0,(function*(){const r=e.map((e=>Number(e))),i=yield cron_service_1.cronService.getMailRecipientTags(r);return(yield Promise.all(i.map((e=>__awaiter(this,void 0,void 0,(function*(){let r=cron_service_1.cronService.replacePlaceholders(e.query_information,"",t,s);const i=JSON.parse(r),c=yield common_service_1.commonService.getTableData(o,i);return!c||c.total_records<1?null:1===c.total_records?c.records[0].email_to||c.records[0].email||null:c.total_records>1?c.records.map((e=>e.email_to||e.email)).filter((e=>null!==e)):void 0})))))).flat().filter((e=>null!==e))}))}insertNotificationJobs(e){return __awaiter(this,void 0,void 0,(function*(){try{yield cron_service_1.cronService.insertNotificationJobs(e.flat())}catch(e){throw new Error(`Failed to insert notification jobs: ${null==e?void 0:e.message}`)}}))}sendNotificationJobs(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=yield cron_service_1.cronService.runScheduledJob("cron/send-notification-jobs",(()=>__awaiter(this,void 0,void 0,(function*(){const e=yield cron_service_1.cronService.getNonsentNotifications();let t=[];const s=[],o=[];for(let r of e){if("email"===r.notification_type){const e=`\n                      <!DOCTYPE html>\n                      <html lang="en">\n                      <head>\n                        <meta charset="UTF-8">\n                        <meta name="viewport" content="width=device-width, initial-scale=1.0">\n                        <title>${r.notification_subject}</title>\n                      </head>\n                      <body>\n                        ${r.notification_content}\n                      </body>\n                      </html>`,t={to:r.notification_to||"",subject:r.notification_subject||"",html:e,attachments:[]};if(r.notification_cc&&(t.cc=r.notification_cc),r.notification_bcc&&(t.bcc=r.notification_bcc),r.attachments_path){const e=path_1.default.join(__dirname,"../../../public/",r.attachments_path);fs_1.default.existsSync(e)?(console.log(`📂 Attaching local file: ${e}`),t.attachments.push({filename:r.attachments_name,path:e})):console.warn(`❌ File not found: ${e}`)}s.push(t)}else{const e={messaging_product:"whatsapp",to:r.notification_to,type:"template",template:r.whatsapp_notification_data};o.push(e)}try{for(let e of s)yield(0,mail_1.sendMail)(e),console.log(`Mail with job id : ${r.id} sent successfully`);for(let e of o)yield(0,whatsapp_1.sendWhatsappMessage)(e),console.log(`Message with job id : ${r.id} sent successfully`);yield cron_service_1.cronService.updateNotificationStatus(r)}catch(e){t.push({id:r.id,no_of_attempts:r.no_of_attempts}),console.error(`Error sending notification ${r.id}:`,e)}}if(t.length)for(let e of t)yield prisma_service_1.default.notificationJob.update({where:{id:e.id},data:{notification_status_id:"ac7",no_of_attempts:e.no_of_attempts+1}});return{status:"success",message:`Processed ${e.length} notifications. Failed: ${t.length}`}}))));return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}createWeeklyDates(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{let s=yield cron_service_1.cronService.createWeeklyDates();return(0,response_1.successResponse)(e,t,s,"All Weeks added successfully for the current year.")}catch(e){throw new Error(`Failed to insert notification jobs: ${null==e?void 0:e.message}`)}}))}syncWhatsappTemplates(e,t,s){return __awaiter(this,void 0,void 0,(function*(){try{const s=yield cron_service_1.cronService.syncWhatsappTemplates();return(0,response_1.successResponse)(e,t,s,"Success.")}catch(e){s(e)}}))}}exports.cronController=new CronController;