import {
  FormlyBootstrapModule,
  FormlyConfigModule,
  FormlyModule
} from "./chunk-NFRJCL7R.js";
import {
  EditorComponent,
  MonacoEditorModule
} from "./chunk-62OL73TD.js";
import "./chunk-IGGXREIH.js";
import {
  LoaderComponent
} from "./chunk-X5XWBDVM.js";
import {
  MenuMapService
} from "./chunk-3FLJCSSF.js";
import {
  ToastrService
} from "./chunk-2YLAF7RI.js";
import {
  CommonSharedModule,
  DynamicFontSizeDirective,
  NgOptionComponent,
  NgSelectComponent,
  NgSelectModule
} from "./chunk-7NQGM4EA.js";
import {
  DefaultValueAccessor,
  FormArrayName,
  FormBuilder,
  FormControlName,
  FormGroupDirective,
  FormGroupName,
  FormsModule,
  NG_VALUE_ACCESSOR,
  NgControlStatus,
  NgControlStatusGroup,
  NgModel,
  NumberValueAccessor,
  ReactiveFormsModule,
  RequiredValidator,
  TranslatePipe,
  TranslateService,
  Validators,
  ɵNgNoValidate
} from "./chunk-NLYGDKUR.js";
import {
  animate,
  state,
  style,
  transition,
  trigger
} from "./chunk-ZEL7H2AL.js";
import {
  ActivatedRoute,
  GridApiService,
  LocalStorageService,
  Router
} from "./chunk-P7K2QEDI.js";
import {
  CommonModule,
  EventEmitter,
  Location,
  NgClass,
  NgForOf,
  NgIf,
  forwardRef,
  ɵsetClassDebugInfo,
  ɵɵNgOnChangesFeature,
  ɵɵProvidersFeature,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵconditional,
  ɵɵdefineComponent,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnamespaceHTML,
  ɵɵnamespaceSVG,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵpureFunction1,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵstyleProp,
  ɵɵtemplate,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-GKZIWABI.js";
import {
  __async,
  __spreadProps,
  __spreadValues
} from "./chunk-CVWHNZRK.js";

// src/app/@lcp-framework/components/autocomplete-form/autocomplete-form.component.ts
var _c0 = (a0) => ({ "required-mark mb-2 block font-medium": a0 });
function AutocompleteFormComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label", 1);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(4, _c0, ctx_r0.required));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(2, 2, ctx_r0.label));
  }
}
function AutocompleteFormComponent_ul_3_li_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "li", 6);
    \u0275\u0275listener("mousedown", function AutocompleteFormComponent_ul_3_li_1_Template_li_mousedown_0_listener() {
      const item_r3 = \u0275\u0275restoreView(_r2).$implicit;
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.selectItem(item_r3));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r3 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", item_r3.name, " ");
  }
}
function AutocompleteFormComponent_ul_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ul", 4);
    \u0275\u0275template(1, AutocompleteFormComponent_ul_3_li_1_Template, 2, 1, "li", 5);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r0.filteredItems);
  }
}
var _AutocompleteFormComponent = class _AutocompleteFormComponent {
  constructor() {
    this.label = "";
    this.items = [];
    this.placeholder = "";
    this.hidelabel = false;
    this.dispLabel = null;
    this.width = null;
    this.required = false;
    this.itemSelected = new EventEmitter();
    this.filteredItems = [];
    this.showDropdown = false;
    this.innerValue = null;
    this.onChange = (value) => {
    };
    this.onTouched = () => {
    };
  }
  ngOnChanges(changes) {
    this.filteredItems = this.items;
  }
  // This is called when Angular sets a value (ex: setValue(null))
  writeValue(value) {
    this.innerValue = value;
    if (value) {
      const selectedItem = this.items.find((item) => item.id === value);
      this.dispLabel = selectedItem ? selectedItem.name : null;
    } else {
      this.dispLabel = null;
    }
  }
  // This is called when form is touched
  registerOnTouched(fn) {
    this.onTouched = fn;
  }
  // This is called when form value is changed
  registerOnChange(fn) {
    this.onChange = fn;
  }
  showDropdowndisp() {
    this.showDropdown = true;
  }
  filterItems(event) {
    const term = event.target.value ?? "";
    const searchTerm = term.toLowerCase();
    this.filteredItems = this.items.filter((item) => item.name.toLowerCase().includes(searchTerm));
    this.showDropdown = this.filteredItems.length > 0;
  }
  selectItem(item) {
    this.value = item.id;
    this.dispLabel = item.name;
    this.itemSelected.emit(item);
    this.showDropdown = false;
  }
  hideDropdown() {
    setTimeout(() => {
      this.showDropdown = false;
    }, 200);
  }
};
_AutocompleteFormComponent.\u0275fac = function AutocompleteFormComponent_Factory(t) {
  return new (t || _AutocompleteFormComponent)();
};
_AutocompleteFormComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AutocompleteFormComponent, selectors: [["app-autocomplete-form"]], inputs: { value: "value", label: "label", items: "items", fieldName: "fieldName", placeholder: "placeholder", hidelabel: "hidelabel", width: "width", required: "required" }, outputs: { itemSelected: "itemSelected" }, standalone: true, features: [\u0275\u0275ProvidersFeature([
  {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => _AutocompleteFormComponent),
    multi: true
  }
]), \u0275\u0275NgOnChangesFeature, \u0275\u0275StandaloneFeature], decls: 4, vars: 6, consts: [[1, "relative", "flex", "flex-col", "gap-1"], [3, "ngClass"], ["type", "text", 1, "w-250", "form-input", "w-full", "rounded", "border", "border-gray-300", "py-1", "text-xs", "text-gray-600", "placeholder:text-white-dark", "focus:outline-none", "focus:ring-2", "focus:ring-blue-500", 3, "focus", "blur", "input", "placeholder", "value"], ["class", "absolute top-full z-10 mt-1 max-h-60 w-full overflow-y-auto rounded border border-gray-300 bg-white text-xs shadow", 4, "ngIf"], [1, "absolute", "top-full", "z-10", "mt-1", "max-h-60", "w-full", "overflow-y-auto", "rounded", "border", "border-gray-300", "bg-white", "text-xs", "shadow"], ["class", "cursor-pointer px-3 py-1 hover:bg-blue-100", 3, "mousedown", 4, "ngFor", "ngForOf"], [1, "cursor-pointer", "px-3", "py-1", "hover:bg-blue-100", 3, "mousedown"]], template: function AutocompleteFormComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0);
    \u0275\u0275template(1, AutocompleteFormComponent_Conditional_1_Template, 3, 6, "label", 1);
    \u0275\u0275elementStart(2, "input", 2);
    \u0275\u0275listener("focus", function AutocompleteFormComponent_Template_input_focus_2_listener() {
      return ctx.showDropdowndisp();
    })("blur", function AutocompleteFormComponent_Template_input_blur_2_listener() {
      return ctx.hideDropdown();
    })("input", function AutocompleteFormComponent_Template_input_input_2_listener($event) {
      return ctx.filterItems($event);
    });
    \u0275\u0275elementEnd();
    \u0275\u0275template(3, AutocompleteFormComponent_ul_3_Template, 2, 1, "ul", 3);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275conditional(1, !ctx.hidelabel ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275styleProp("width", ctx.width);
    \u0275\u0275property("placeholder", ctx.placeholder)("value", ctx.dispLabel);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.showDropdown && ctx.filteredItems.length);
  }
}, dependencies: [CommonModule, NgClass, NgForOf, NgIf, ReactiveFormsModule, FormsModule, CommonSharedModule, TranslatePipe] });
var AutocompleteFormComponent = _AutocompleteFormComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AutocompleteFormComponent, { className: "AutocompleteFormComponent", filePath: "src\\app\\@lcp-framework\\components\\autocomplete-form\\autocomplete-form.component.ts", lineNumber: 21 });
})();

// src/app/@lcp-framework/pages/approval-workflow-assignment/approval-workflow-assignment.component.ts
var _c02 = ["monacoEditor"];
var _c1 = (a0) => ({ "!text-primary": a0 });
var _c2 = (a0) => ({ "rotate-180": a0 });
function ApprovalWorkflowAssignmentComponent_For_26_For_18_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-option", 27);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const type_r4 = ctx.$implicit;
    \u0275\u0275property("value", type_r4.value);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(type_r4.label);
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_19_For_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-option", 27);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const tag_r8 = ctx.$implicit;
    \u0275\u0275property("value", tag_r8.value);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(tag_r8.label);
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_19_div_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 46);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "approver_tag_is_required"), " ");
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_19_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 9)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275elementStart(4, "span", 11);
    \u0275\u0275text(5, "*");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "ng-select", 45);
    \u0275\u0275listener("search", function ApprovalWorkflowAssignmentComponent_For_26_div_19_Template_ng_select_search_6_listener($event) {
      \u0275\u0275restoreView(_r5);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.getTags(assignment_r2, i_r7, $event.term || ""));
    })("clear", function ApprovalWorkflowAssignmentComponent_For_26_div_19_Template_ng_select_clear_6_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.getTags(assignment_r2, i_r7, ""));
    })("change", function ApprovalWorkflowAssignmentComponent_For_26_div_19_Template_ng_select_change_6_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.updateApprovers(assignment_r2, i_r7));
    });
    \u0275\u0275repeaterCreate(7, ApprovalWorkflowAssignmentComponent_For_26_div_19_For_8_Template, 2, 2, "ng-option", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275template(9, ApprovalWorkflowAssignmentComponent_For_26_div_19_div_9_Template, 3, 3, "div", 30);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    let tmp_15_0;
    let tmp_16_0;
    const assignment_r2 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(3, 5, "approver_tag"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275property("clearable", true)("searchable", true)("multiple", true);
    \u0275\u0275advance();
    \u0275\u0275repeater((tmp_15_0 = assignment_r2.get("tag_list")) == null ? null : tmp_15_0.value);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ((tmp_16_0 = assignment_r2.get("tag")) == null ? null : tmp_16_0.invalid) && (((tmp_16_0 = assignment_r2.get("tag")) == null ? null : tmp_16_0.touched) || ((tmp_16_0 = assignment_r2.get("tag")) == null ? null : tmp_16_0.dirty)));
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_20_For_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-option", 27);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const user_r10 = ctx.$implicit;
    \u0275\u0275property("value", user_r10.value);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(user_r10.label);
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_20_div_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 46);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "user_email_is_required"), " ");
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_20_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 9)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275elementStart(4, "span", 11);
    \u0275\u0275text(5, "*");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "ng-select", 47);
    \u0275\u0275listener("search", function ApprovalWorkflowAssignmentComponent_For_26_div_20_Template_ng_select_search_6_listener($event) {
      \u0275\u0275restoreView(_r9);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.getUsers(assignment_r2, i_r7, $event.term || ""));
    })("clear", function ApprovalWorkflowAssignmentComponent_For_26_div_20_Template_ng_select_clear_6_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.getUsers(assignment_r2, i_r7, ""));
    })("change", function ApprovalWorkflowAssignmentComponent_For_26_div_20_Template_ng_select_change_6_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.updateApprovers(assignment_r2, i_r7));
    });
    \u0275\u0275repeaterCreate(7, ApprovalWorkflowAssignmentComponent_For_26_div_20_For_8_Template, 2, 2, "ng-option", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275template(9, ApprovalWorkflowAssignmentComponent_For_26_div_20_div_9_Template, 3, 3, "div", 30);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    let tmp_15_0;
    let tmp_16_0;
    const assignment_r2 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(3, 5, "user_email"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275property("multiple", true)("clearable", true)("searchable", true);
    \u0275\u0275advance();
    \u0275\u0275repeater((tmp_15_0 = assignment_r2.get("user_list")) == null ? null : tmp_15_0.value);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ((tmp_16_0 = assignment_r2.get("users")) == null ? null : tmp_16_0.invalid) && (((tmp_16_0 = assignment_r2.get("users")) == null ? null : tmp_16_0.touched) || ((tmp_16_0 = assignment_r2.get("users")) == null ? null : tmp_16_0.dirty)));
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_21_For_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-option", 27);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const role_r12 = ctx.$implicit;
    \u0275\u0275property("value", role_r12.value);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(role_r12.label);
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_21_div_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 46);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "role_is_required"), " ");
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_21_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 9)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275elementStart(4, "span", 11);
    \u0275\u0275text(5, "*");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "ng-select", 48);
    \u0275\u0275listener("search", function ApprovalWorkflowAssignmentComponent_For_26_div_21_Template_ng_select_search_6_listener($event) {
      \u0275\u0275restoreView(_r11);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.getRoles(assignment_r2, i_r7, $event.term || ""));
    })("clear", function ApprovalWorkflowAssignmentComponent_For_26_div_21_Template_ng_select_clear_6_listener() {
      \u0275\u0275restoreView(_r11);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.getRoles(assignment_r2, i_r7, ""));
    })("change", function ApprovalWorkflowAssignmentComponent_For_26_div_21_Template_ng_select_change_6_listener() {
      \u0275\u0275restoreView(_r11);
      const ctx_r5 = \u0275\u0275nextContext();
      const assignment_r2 = ctx_r5.$implicit;
      const i_r7 = ctx_r5.$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.updateApprovers(assignment_r2, i_r7));
    });
    \u0275\u0275repeaterCreate(7, ApprovalWorkflowAssignmentComponent_For_26_div_21_For_8_Template, 2, 2, "ng-option", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275template(9, ApprovalWorkflowAssignmentComponent_For_26_div_21_div_9_Template, 3, 3, "div", 30);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    let tmp_15_0;
    let tmp_16_0;
    const assignment_r2 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(3, 5, "role"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275property("multiple", true)("clearable", true)("searchable", true);
    \u0275\u0275advance();
    \u0275\u0275repeater((tmp_15_0 = assignment_r2.get("role_list")) == null ? null : tmp_15_0.value);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ((tmp_16_0 = assignment_r2.get("roles")) == null ? null : tmp_16_0.invalid) && (((tmp_16_0 = assignment_r2.get("roles")) == null ? null : tmp_16_0.touched) || ((tmp_16_0 = assignment_r2.get("roles")) == null ? null : tmp_16_0.dirty)));
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_29_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 46);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "approver_order_is_required"), " ");
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_For_37_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-option", 27);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const template_r13 = ctx.$implicit;
    \u0275\u0275property("value", template_r13.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(template_r13.name);
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_For_45_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-option", 27);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const template_r14 = ctx.$implicit;
    \u0275\u0275property("value", template_r14.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(template_r14.name);
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_For_53_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-option", 27);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const template_r15 = ctx.$implicit;
    \u0275\u0275property("value", template_r15.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(template_r15.name);
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_For_61_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-option", 27);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const template_r16 = ctx.$implicit;
    \u0275\u0275property("value", template_r16.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(template_r16.name);
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_Conditional_62_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "i", 49);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_For_26_Conditional_62_Template_i_click_0_listener() {
      \u0275\u0275restoreView(_r17);
      const i_r7 = \u0275\u0275nextContext().$index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.removeApprovalWorkflowAssignment(i_r7));
    });
    \u0275\u0275elementEnd();
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_72_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 46);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "approve_query_information_is_required"), " ");
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_div_81_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 46);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "reject_query_information_is_required"), " ");
  }
}
function ApprovalWorkflowAssignmentComponent_For_26_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 15)(1, "div", 18)(2, "button", 19);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_For_26_Template_button_click_2_listener() {
      const assignment_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.updateAccordianState(assignment_r2));
    });
    \u0275\u0275text(3);
    \u0275\u0275elementStart(4, "div", 20);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(5, "svg", 21);
    \u0275\u0275element(6, "path", 22);
    \u0275\u0275elementEnd()()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(7, "div", 23)(8, "div", 24)(9, "div", 25)(10, "div", 9)(11, "label");
    \u0275\u0275text(12);
    \u0275\u0275pipe(13, "translate");
    \u0275\u0275elementStart(14, "span", 11);
    \u0275\u0275text(15, "*");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(16, "ng-select", 26);
    \u0275\u0275listener("change", function ApprovalWorkflowAssignmentComponent_For_26_Template_ng_select_change_16_listener() {
      const assignment_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.clearUserRoleTagValues(assignment_r2));
    });
    \u0275\u0275repeaterCreate(17, ApprovalWorkflowAssignmentComponent_For_26_For_18_Template, 2, 2, "ng-option", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275template(19, ApprovalWorkflowAssignmentComponent_For_26_div_19_Template, 10, 7, "div", 28)(20, ApprovalWorkflowAssignmentComponent_For_26_div_20_Template, 10, 7, "div", 28)(21, ApprovalWorkflowAssignmentComponent_For_26_div_21_Template, 10, 7, "div", 28);
    \u0275\u0275elementStart(22, "div", 9)(23, "label");
    \u0275\u0275text(24);
    \u0275\u0275pipe(25, "translate");
    \u0275\u0275elementStart(26, "span", 11);
    \u0275\u0275text(27, "*");
    \u0275\u0275elementEnd()();
    \u0275\u0275element(28, "input", 29);
    \u0275\u0275template(29, ApprovalWorkflowAssignmentComponent_For_26_div_29_Template, 3, 3, "div", 30);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(30, "div", 8)(31, "div", 9)(32, "label", 10);
    \u0275\u0275text(33);
    \u0275\u0275pipe(34, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(35, "ng-select", 31);
    \u0275\u0275repeaterCreate(36, ApprovalWorkflowAssignmentComponent_For_26_For_37_Template, 2, 2, "ng-option", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(38, "div", 8)(39, "div", 9)(40, "label", 10);
    \u0275\u0275text(41);
    \u0275\u0275pipe(42, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(43, "ng-select", 32);
    \u0275\u0275repeaterCreate(44, ApprovalWorkflowAssignmentComponent_For_26_For_45_Template, 2, 2, "ng-option", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(46, "div", 8)(47, "div", 9)(48, "label", 10);
    \u0275\u0275text(49);
    \u0275\u0275pipe(50, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(51, "ng-select", 33);
    \u0275\u0275repeaterCreate(52, ApprovalWorkflowAssignmentComponent_For_26_For_53_Template, 2, 2, "ng-option", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(54, "div", 8)(55, "div", 9)(56, "label", 10);
    \u0275\u0275text(57);
    \u0275\u0275pipe(58, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(59, "ng-select", 34);
    \u0275\u0275repeaterCreate(60, ApprovalWorkflowAssignmentComponent_For_26_For_61_Template, 2, 2, "ng-option", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275template(62, ApprovalWorkflowAssignmentComponent_For_26_Conditional_62_Template, 1, 0, "i", 35);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(63, "div", 36)(64, "div", 37)(65, "div", 38)(66, "label", 39);
    \u0275\u0275text(67);
    \u0275\u0275pipe(68, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(69, "i", 40);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_For_26_Template_i_click_69_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.openInfoPopUp("approve_query_information"));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(70, "div", 41);
    \u0275\u0275element(71, "ngx-monaco-editor", 42);
    \u0275\u0275elementEnd();
    \u0275\u0275template(72, ApprovalWorkflowAssignmentComponent_For_26_div_72_Template, 3, 3, "div", 30);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(73, "div", 37)(74, "div", 38)(75, "label", 43);
    \u0275\u0275text(76);
    \u0275\u0275pipe(77, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(78, "i", 40);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_For_26_Template_i_click_78_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.openInfoPopUp("reject_query_information"));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(79, "div", 41);
    \u0275\u0275element(80, "ngx-monaco-editor", 44);
    \u0275\u0275elementEnd();
    \u0275\u0275template(81, ApprovalWorkflowAssignmentComponent_For_26_div_81_Template, 3, 3, "div", 30);
    \u0275\u0275elementEnd()()()()()();
  }
  if (rf & 2) {
    let tmp_11_0;
    let tmp_13_0;
    let tmp_14_0;
    let tmp_19_0;
    let tmp_20_0;
    let tmp_21_0;
    let tmp_23_0;
    let tmp_43_0;
    let tmp_46_0;
    const assignment_r2 = ctx.$implicit;
    const i_r7 = ctx.$index;
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275property("formGroupName", i_r7);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(48, _c1, (tmp_11_0 = assignment_r2.get("accordian")) == null ? null : tmp_11_0.value));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", "Approver - " + (i_r7 + 1), " ");
    \u0275\u0275advance();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(50, _c2, (tmp_13_0 = assignment_r2.get("accordian")) == null ? null : tmp_13_0.value));
    \u0275\u0275advance(3);
    \u0275\u0275property("@slideDownUp", (tmp_14_0 = assignment_r2.get("accordian")) == null ? null : tmp_14_0.value == null ? null : tmp_14_0.value.toString());
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(13, 32, "approver_type"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275property("clearable", true)("searchable", true);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r2.approverTypes);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ((tmp_19_0 = assignment_r2.get("approver_type")) == null ? null : tmp_19_0.value) === "tag");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ((tmp_20_0 = assignment_r2.get("approver_type")) == null ? null : tmp_20_0.value) === "user_id");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ((tmp_21_0 = assignment_r2.get("approver_type")) == null ? null : tmp_21_0.value) === "role_id");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(25, 34, "approver_order"), " ");
    \u0275\u0275advance(5);
    \u0275\u0275property("ngIf", ((tmp_23_0 = assignment_r2.get("approver_order_no")) == null ? null : tmp_23_0.invalid) && (((tmp_23_0 = assignment_r2.get("approver_order_no")) == null ? null : tmp_23_0.touched) || ((tmp_23_0 = assignment_r2.get("approver_order_no")) == null ? null : tmp_23_0.dirty)));
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(34, 36, "accept_email_template"));
    \u0275\u0275advance(2);
    \u0275\u0275property("clearable", true)("searchable", true);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r2.emailTemplateList);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(42, 38, "reject_email_template"));
    \u0275\u0275advance(2);
    \u0275\u0275property("clearable", true)("searchable", true);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r2.emailTemplateList);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(50, 40, "accept_whatsapp_template"));
    \u0275\u0275advance(2);
    \u0275\u0275property("clearable", true)("searchable", true);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r2.whatsappTemplateList);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(58, 42, "reject_whatsapp_template"));
    \u0275\u0275advance(2);
    \u0275\u0275property("clearable", true)("searchable", true);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r2.whatsappTemplateList);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(62, i_r7 > 0 ? 62 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(68, 44, "approve_query_information"));
    \u0275\u0275advance(4);
    \u0275\u0275property("options", ctx_r2.editorOptions);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ((tmp_43_0 = assignment_r2.get("approve_query_information")) == null ? null : tmp_43_0.invalid) && (((tmp_43_0 = assignment_r2.get("approve_query_information")) == null ? null : tmp_43_0.touched) || ((tmp_43_0 = assignment_r2.get("approve_query_information")) == null ? null : tmp_43_0.dirty)));
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(77, 46, "reject_query_information"));
    \u0275\u0275advance(4);
    \u0275\u0275property("options", ctx_r2.editorOptions);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ((tmp_46_0 = assignment_r2.get("reject_query_information")) == null ? null : tmp_46_0.invalid) && (((tmp_46_0 = assignment_r2.get("reject_query_information")) == null ? null : tmp_46_0.touched) || ((tmp_46_0 = assignment_r2.get("reject_query_information")) == null ? null : tmp_46_0.dirty)));
  }
}
function ApprovalWorkflowAssignmentComponent_div_27_li_17_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "li")(1, "div", 70)(2, "span", 71);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const item_r19 = ctx.$implicit;
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(4, 1, item_r19));
  }
}
function ApprovalWorkflowAssignmentComponent_div_27_p_19_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 72);
    \u0275\u0275text(1, "Copied to clipboard!");
    \u0275\u0275elementEnd();
  }
}
function ApprovalWorkflowAssignmentComponent_div_27_Template(rf, ctx) {
  if (rf & 1) {
    const _r18 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 50);
    \u0275\u0275element(1, "div", 51);
    \u0275\u0275elementStart(2, "div", 52)(3, "div", 53)(4, "div", 54)(5, "div", 55)(6, "div", 56)(7, "p", 57);
    \u0275\u0275text(8);
    \u0275\u0275pipe(9, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "button", 58);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_div_27_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r18);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.closeInfoPopUp());
    });
    \u0275\u0275elementStart(11, "span", 59);
    \u0275\u0275text(12, "Close");
    \u0275\u0275elementEnd();
    \u0275\u0275element(13, "i", 60);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(14, "div", 61)(15, "div", 62)(16, "ul", 63);
    \u0275\u0275template(17, ApprovalWorkflowAssignmentComponent_div_27_li_17_Template, 5, 3, "li", 64);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "div", 65);
    \u0275\u0275template(19, ApprovalWorkflowAssignmentComponent_div_27_p_19_Template, 2, 0, "p", 66);
    \u0275\u0275elementStart(20, "div", 67)(21, "ngx-monaco-editor", 68);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_div_27_Template_ngx_monaco_editor_click_21_listener() {
      \u0275\u0275restoreView(_r18);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.copyToClipboard());
    });
    \u0275\u0275twoWayListener("ngModelChange", function ApprovalWorkflowAssignmentComponent_div_27_Template_ngx_monaco_editor_ngModelChange_21_listener($event) {
      \u0275\u0275restoreView(_r18);
      const ctx_r2 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r2.popupInformation.data, $event) || (ctx_r2.popupInformation.data = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(22, "div", 69);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_div_27_Template_div_click_22_listener() {
      \u0275\u0275restoreView(_r18);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.copyToClipboard());
    });
    \u0275\u0275elementEnd()()()()()()();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(9, 5, ctx_r2.popupInformation.header));
    \u0275\u0275advance(9);
    \u0275\u0275property("ngForOf", ctx_r2.popupInformation.comments);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx_r2.copied);
    \u0275\u0275advance(2);
    \u0275\u0275property("options", ctx_r2.popupInfoEditorOptions);
    \u0275\u0275twoWayProperty("ngModel", ctx_r2.popupInformation.data);
  }
}
function ApprovalWorkflowAssignmentComponent_app_loader_28_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "app-loader");
  }
}
var _ApprovalWorkflowAssignmentComponent = class _ApprovalWorkflowAssignmentComponent {
  constructor(fb, translate, location, router, route, commonService, gridApiService, toastr, localStorageService) {
    this.fb = fb;
    this.translate = translate;
    this.location = location;
    this.router = router;
    this.route = route;
    this.commonService = commonService;
    this.gridApiService = gridApiService;
    this.toastr = toastr;
    this.localStorageService = localStorageService;
    this.uniqueId = null;
    this.loading = false;
    this.approverTags = [];
    this.templateList = [];
    this.userId = 0;
    this.options = [];
    this.approverTypes = [
      { label: "Tag", value: "tag" },
      { label: "User", value: "user_id" },
      { label: "Role", value: "role_id" }
    ];
    this.userList = [];
    this.roleList = [];
    this.tagList = [];
    this.emailTemplateList = [];
    this.whatsappTemplateList = [];
    this.editorOptions = { theme: "vs-dark", language: "json", tabSize: 1, insertSpaces: true };
    this.isDarkTheme = true;
    this.isInfoModalOpen = false;
    this.infoContents = {
      approve_query_information: {
        header: "Approve Query Information",
        comments: [],
        data: ["select * from users limit 1", "select * from user_details limit 1"]
      },
      reject_query_information: {
        header: "Reject Query Information",
        comments: [],
        data: ["select * from users limit 1", "select * from user_details limit 1"]
      }
    };
    this.popupInformation = null;
    this.popupInfoEditorOptions = __spreadProps(__spreadValues({}, this.editorOptions), { cursorStyle: "line", readOnly: true, automaticLayout: true, minimap: { enabled: false } });
    this.copied = false;
    this.route.paramMap.subscribe((params) => {
      this.uniqueId = params.get("id");
    });
    this.form = this.fb.group({
      approvalWorkflow: this.fb.group({
        id: [null, Validators.required],
        name: [{ value: "", disabled: true }, Validators.required],
        slug: ["", Validators.required]
      }),
      approvalWorkflowAssignments: this.fb.array([])
    });
  }
  ngOnInit() {
    return __async(this, null, function* () {
      yield this.getEmailTemplateList();
      yield this.getWhatsappTemplateList();
      yield this.getApprovalWorkflowDetail();
      this.userId = this.localStorageService.getData("user_data") && JSON.parse(this.localStorageService.getData("user_data")).main.id;
    });
  }
  getApprovalWorkflowDetail() {
    return __async(this, null, function* () {
      const payload = {
        company_id: 1,
        group_by: ["approval_workflows.id", "approval_workflows.name", "approval_workflows.slug"],
        search_all: [
          {
            value: "3",
            operator: "!=",
            column_name: "approval_workflows.status_id"
          },
          {
            value: this.uniqueId,
            operator: "=",
            column_name: "approval_workflows.uuid"
          }
        ],
        includes: [
          {
            join_type: "LEFT",
            table_name: "approval_workflow_assignments",
            join_condition: "approval_workflow_assignments.approval_workflow_id = approval_workflows.id AND approval_workflow_assignments.status_id != 3"
          }
        ],
        limit_range: 1,
        print_query: true,
        start_index: 0,
        primary_table: "approval_workflows",
        select_columns: [
          ["approval_workflows.id"],
          ["approval_workflows.slug"],
          ["approval_workflows.name"],
          [
            `COALESCE(JSON_AGG(
              DISTINCT JSONB_BUILD_OBJECT(
                'id', approval_workflow_assignments.id, 
                'approver_order_no', approval_workflow_assignments.approver_order_no, 
                'approver_type', approval_workflow_assignments.approver_type,
                'approver', approval_workflow_assignments.approver,
                'approve_query_information', approval_workflow_assignments.approve_query_information,
                'reject_query_information', approval_workflow_assignments.reject_query_information,
                'approved_mail', approval_workflow_assignments.approve_mail_id,
                'reject_mail', approval_workflow_assignments.reject_mail_id,
                'approved_whatsapp', approval_workflow_assignments.approve_whatsapp_id,
                'reject_whatsapp', approval_workflow_assignments.reject_whatsapp_id
              )
          ) FILTER (WHERE approval_workflow_assignments.id IS NOT NULL), '[]')`,
            "approval_assignments"
          ]
        ]
      };
      this.commonService.getCommonList(payload).subscribe({
        next: (response) => {
          if (response.code === 200 && response.status) {
            if (response.data.records.length) {
              console.log(" response.data.records[0] : ", response.data.records[0]);
              this.form.controls["approvalWorkflow"].patchValue({
                id: response.data.records[0].id,
                slug: response.data.records[0].slug,
                name: response.data.records[0].name,
                accept_email: response.data.records[0].approved_mail,
                reject_email: response.data.records[0].reject_mail
              });
              if (response.data.records[0]?.approval_assignments.length) {
                const lineItemsArray = this.form.get("approvalWorkflowAssignments");
                response.data.records[0]?.approval_assignments.map((each, index) => {
                  lineItemsArray.push(this.fb.group({
                    id: [each.id],
                    approver_type: [each.approver_type || "tag", Validators.required],
                    approver_order_no: [each.approver_order_no, Validators.required],
                    approver: [each.approver, Validators.required],
                    approval_workflow_id: [response.data.records[0].id, Validators.required],
                    approve_query_information: [this.prettyJSON(each.approve_query_information || []), Validators.required],
                    reject_query_information: [this.prettyJSON(each.reject_query_information || []), Validators.required],
                    accordian: false,
                    user_list: [null],
                    role_list: [null],
                    tag_list: [null],
                    accept_email: each.approved_mail,
                    reject_email: each.reject_mail,
                    accept_whatsapp: each.approved_whatsapp,
                    reject_whatsapp: each.reject_whatsapp,
                    tag: [each.approver_type === "tag" ? each.approver?.split(",") : null],
                    users: [
                      each.approver_type === "user_id" ? each.approver?.split(",").map(Number).filter((n) => !isNaN(n)) : null
                    ],
                    roles: [
                      each.approver_type === "role_id" ? each.approver?.split(",").map(Number).filter((n) => !isNaN(n)) : null
                    ]
                  }));
                  if (each.approver_type === "tag") {
                    this.getTags(lineItemsArray.controls[lineItemsArray.length - 1], index, "");
                  }
                  if (each.approver_type === "user_id") {
                    this.getUsers(lineItemsArray.controls[lineItemsArray.length - 1], index, "");
                  }
                  if (each.approver_type === "role_id") {
                    this.getRoles(lineItemsArray.controls[lineItemsArray.length - 1], index, "");
                  }
                });
              } else {
                this.addApproverAssignment();
              }
              console.log("form : ", this.form);
            }
          }
        }
      });
    });
  }
  getEmailTemplateList() {
    return __async(this, null, function* () {
      const payload = {
        company_id: 1,
        group_by: ["email_templates.id", "email_templates.name"],
        search_all: [
          {
            value: "3",
            operator: "!=",
            column_name: "email_templates.status_id"
          }
        ],
        limit_range: 100,
        print_query: true,
        start_index: 0,
        primary_table: "email_templates",
        select_columns: [["email_templates.id"], ["email_templates.name"]]
      };
      this.commonService.getCommonList(payload).subscribe({
        next: (response) => {
          if (response.status) {
            this.emailTemplateList = response.data.records;
          }
        }
      });
    });
  }
  getWhatsappTemplateList() {
    return __async(this, null, function* () {
      const payload = {
        company_id: 1,
        group_by: ["whatsapp_templates.id", "whatsapp_templates.name"],
        search_all: [
          {
            value: "3",
            operator: "!=",
            column_name: "whatsapp_templates.status_id"
          }
        ],
        limit_range: 100,
        print_query: true,
        start_index: 0,
        primary_table: "whatsapp_templates",
        select_columns: [["whatsapp_templates.id"], ["whatsapp_templates.name"]]
      };
      this.commonService.getCommonList(payload).subscribe({
        next: (response) => {
          if (response.status) {
            this.whatsappTemplateList = response.data.records;
          }
        }
      });
    });
  }
  // onAcceptMailSelected(item: any) {
  //   console.log('item : ', item);
  //   const fg = this.form.controls['approvalWorkflow'] as FormGroup;
  //   fg.controls['accept_email'].setValue(item.id);
  // }
  // onRejectMailSelected(item: any) {
  //   const fg = this.form.controls['approvalWorkflow'] as FormGroup;
  //   fg.controls['reject_email'].setValue(item.id);
  // }
  get approvalWorkflow() {
    return this.form.get("approvalWorkflow")?.getRawValue();
  }
  get approvalWorkflowAssignments() {
    return this.form.get("approvalWorkflowAssignments")?.getRawValue();
  }
  getApproverAssignmentList() {
    const lineItemsArray = this.form.get("approvalWorkflowAssignments");
    return lineItemsArray?.controls?.length ? lineItemsArray.controls : [];
  }
  addApproverAssignment() {
    const lineItemsArray = this.form.get("approvalWorkflowAssignments");
    const newFormGroup = this.fb.group({
      id: [0],
      approver_type: ["tag", Validators.required],
      approver_order_no: [null, Validators.required],
      approver: [null, Validators.required],
      approval_workflow_id: [0, Validators.required],
      approve_query_information: ["[]", Validators.required],
      reject_query_information: ["[]", Validators.required],
      accordian: false,
      user_list: [null],
      role_list: [null],
      tag_list: [null],
      tag: [null],
      users: [null],
      roles: [null],
      accept_email: [null],
      reject_email: [null]
    });
    lineItemsArray.push(newFormGroup);
    this.clearUserRoleTagValues(newFormGroup);
  }
  removeApprovalWorkflowAssignment(index) {
    const lineItemsArray = this.form.get("approvalWorkflowAssignments");
    lineItemsArray.removeAt(index);
    lineItemsArray.controls.forEach((control, idx) => {
      control.patchValue({ approver_order_no: idx + 1 });
    });
  }
  clearUserRoleTagValues(formGroup, index) {
    formGroup.get("approver")?.setValue(null);
    switch (formGroup.controls["approver_type"].value) {
      case "role_id":
        this.getRoles(formGroup, index || this.approvalWorkflowAssignments.length - 1, "");
        break;
      case "user_id":
        this.getUsers(formGroup, index || this.approvalWorkflowAssignments.length - 1, "");
        break;
      default:
        this.getTags(formGroup, index || this.approvalWorkflowAssignments.length - 1, "");
    }
  }
  updateApprovers(formGroup, index) {
    switch (formGroup.controls["approver_type"].value) {
      case "role_id":
        formGroup?.patchValue({
          approver: formGroup.controls["roles"].value.join(","),
          users: null,
          tag: null
        });
        break;
      case "user_id":
        formGroup?.patchValue({
          approver: formGroup.controls["users"].value.join(","),
          roles: null,
          tag: null
        });
        break;
      default:
        formGroup?.patchValue({
          approver: formGroup.controls["tag"].value.join(","),
          users: null,
          roles: null
        });
    }
  }
  fetchMappedData(key, index) {
    let ids = [];
    this.approvalWorkflowAssignments.map((each, i) => {
      if (index !== i && each[key]?.length)
        ids = [...ids, ...each[key]];
    });
    return ids;
  }
  getUsers(formGroup, index, uname) {
    let payload = {
      company_id: 1,
      search_all: [
        {
          value: "1",
          operator: "=",
          column_name: "status_id"
        }
        // ...(mappedUsers.length > 0
        //   ? [
        //       {
        //         value: mappedUsers,
        //         operator: 'NOT IN',
        //         column_name: 'id',
        //       },
        //     ]
        //   : []),
      ],
      limit_range: 25,
      print_query: false,
      start_index: 0,
      sort_columns: [["email", "asc"]],
      primary_table: "users",
      select_columns: [
        ["id", "value"],
        ["email", "label"]
      ]
    };
    if (uname) {
      payload.search_all.push({
        value: "%" + uname || "%",
        operator: "ILIKE",
        column_name: "email"
      });
    }
    this.commonService.getCommonList(payload).subscribe({
      next: (response) => {
        if (response.code === 200 && response.status) {
          if (response.data.records.length) {
            formGroup.get("user_list")?.setValue(response.data.records);
          }
        }
      }
    });
  }
  getRoles(formGroup, index, role_name) {
    let payload = {
      company_id: 1,
      search_all: [
        {
          value: "1",
          operator: "=",
          column_name: "status_id"
        }
        // ...(mappedRoles.length > 0
        //   ? [
        //       {
        //         value: mappedRoles,
        //         operator: 'NOT IN',
        //         column_name: 'id',
        //       },
        //     ]
        //   : []),
      ],
      limit_range: 25,
      print_query: false,
      start_index: 0,
      sort_columns: [["name", "asc"]],
      primary_table: "roles",
      select_columns: [
        ["id", "value"],
        ["name", "label"]
      ]
    };
    if (role_name) {
      payload.search_all.push({
        value: "%" + role_name || "%",
        operator: "ILIKE",
        column_name: "name"
      });
    }
    this.commonService.getCommonList(payload).subscribe({
      next: (response) => {
        if (response.code === 200 && response.status) {
          if (response.data.records.length) {
            formGroup.get("role_list")?.setValue(response.data.records);
          }
        }
      }
    });
  }
  getTags(formGroup, index, tag_name) {
    let payload = {
      company_id: 1,
      search_all: [
        {
          value: "1",
          operator: "=",
          column_name: "status_id"
        }
        // ...(mappedTags.length > 0
        //   ? [
        //       {
        //         value: mappedTags,
        //         operator: 'NOT IN',
        //         column_name: 'slug',
        //       },
        //     ]
        //   : []),
      ],
      limit_range: 25,
      print_query: false,
      start_index: 0,
      sort_columns: [["name", "asc"]],
      primary_table: "approval_workflow_approver_tags",
      select_columns: [
        ["slug", "value"],
        ["name", "label"]
      ]
    };
    if (tag_name) {
      payload.search_all.push({
        value: "%" + tag_name || "%",
        operator: "ILIKE",
        column_name: "name"
      });
    }
    this.commonService.getCommonList(payload).subscribe({
      next: (response) => {
        if (response.code === 200 && response.status) {
          if (response.data.records.length) {
            formGroup.get("tag_list")?.setValue(response.data.records);
          }
        }
      }
    });
  }
  submit() {
    if (this.form.valid) {
      const payload = {
        data: {
          table2: this.approvalWorkflowAssignments.map((each) => {
            return {
              approver_order_no: each.approver_order_no,
              approval_workflow_id: each.approval_workflow_id || this.approvalWorkflow.id,
              approver_type: each.approver_type,
              approver: each.approver,
              approve_query_information: this.parseJSON(each.approve_query_information || "[]"),
              reject_query_information: this.parseJSON(each.reject_query_information || "[]"),
              created_by: true,
              updated_by: true,
              status_id: 1,
              created_at: true,
              updated_at: true,
              approve_mail_id: each.accept_email,
              reject_mail_id: each.reject_email,
              approve_whatsapp_id: each.accept_whatsapp,
              reject_whatsapp_id: each.reject_whatsapp
            };
          })
        },
        table: ["approval_workflow_assignments", "approval_workflow_assignments"],
        action: ["hard_delete", "insert"],
        conditions: {
          table1: [
            {
              approval_workflow_id: this.approvalWorkflow.id
            }
          ]
        },
        table_mapping: ["table1", "table2"]
      };
      this.loading = true;
      this.gridApiService.executeRecords(payload).subscribe({
        next: (response) => {
          this.loading = false;
          if (response.code === 200 && response.status) {
            this.toastr.success("Record updated successfully", "Success");
          }
        },
        error: (err) => {
          this.toastr.error("Failed to update record", "Error");
          this.loading = false;
        }
      });
    } else {
      this.loading = false;
      this.toastr.error("Enter all required fields", "Error");
    }
  }
  updateAccordianState(formGroup) {
    formGroup.get("accordian")?.setValue(!formGroup.get("accordian")?.value);
  }
  prepareJSON(data) {
    return JSON.stringify(JSON.parse(data));
  }
  parseJSON(data) {
    return JSON.parse(data);
  }
  prettyJSON(data) {
    return JSON.stringify(data, null, 2);
  }
  openInfoPopUp(popup) {
    this.isInfoModalOpen = true;
    this.popupInformation = __spreadProps(__spreadValues({}, this.infoContents[popup]), {
      data: JSON.stringify(this.infoContents[popup].data, null, 2)
    });
  }
  closeInfoPopUp() {
    this.isInfoModalOpen = false;
    this.popupInformation = null;
  }
  // Copy content from Monaco Editor
  copyToClipboard() {
    navigator.clipboard.writeText(this.popupInformation.data).then(() => {
      this.copied = true;
      setTimeout(() => this.copied = false, 3e3);
    }).catch((err) => console.error("Failed to copy:", err));
  }
};
_ApprovalWorkflowAssignmentComponent.\u0275fac = function ApprovalWorkflowAssignmentComponent_Factory(t) {
  return new (t || _ApprovalWorkflowAssignmentComponent)(\u0275\u0275directiveInject(FormBuilder), \u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(Location), \u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(ActivatedRoute), \u0275\u0275directiveInject(MenuMapService), \u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(LocalStorageService));
};
_ApprovalWorkflowAssignmentComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ApprovalWorkflowAssignmentComponent, selectors: [["app-approval-workflow-assignment"]], viewQuery: function ApprovalWorkflowAssignmentComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.monacoEditor = _t.first);
  }
}, standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 29, vars: 12, consts: [[1, "panel"], [1, "mb-5", "flex", "flex-col", "items-start", "justify-between", "gap-3", "lg:flex-row", "lg:items-center"], [1, "text-lg", "font-semibold", "dark:text-white-light"], [1, "align-center", "flex", "gap-3"], ["appDynamicFontSize", "body", "type", "button", 1, "btn", "btn-danger", "mr-5", "ltr:rounded-r", "rtl:rounded-l", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-secondary", "ng-tns-c3247919129-2", "text-xs", "ltr:rounded-r", "rtl:rounded-l", 3, "click"], [3, "formGroup"], ["formGroupName", "approvalWorkflow", 1, "mb-5", "flex", "flex-col", "items-start", "justify-between", "gap-3", "lg:flex-row", "lg:items-center"], [1, "min-w-200-p"], [1, "form-group"], ["for", "name"], [1, "text-danger"], ["type", "text", "formControlName", "name", "placeholder", "Approval Workflow", "required", "", 1, "form-control", "form-input", "w-full", "rounded-[4px]", "border", "border-gray-300", "py-1", "text-xs", "text-gray-600", "placeholder:text-white-dark"], ["type", "button", 1, "hover:bg-primary-dark", "dark:bg-primary-dark", "dark:focus:ring-primary-dark", "flex", "w-40", "flex-row", "items-center", "justify-center", "gap-8", "rounded-md", "bg-primary", "px-6", "py-2", "text-white", "shadow-sm", "focus:outline-none", "focus:ring-2", "focus:ring-primary", "focus:ring-offset-2", "dark:text-white", 3, "click"], ["formArrayName", "approvalWorkflowAssignments"], [1, "my-4", "space-y-2", "font-semibold", 3, "formGroupName"], ["class", "fixed inset-0 z-50 overflow-y-auto", 4, "ngIf"], [4, "ngIf"], [1, "rounded", "border", "border-[#d3d3d3]", "dark:border-[#1b2e4b]"], ["type", "button", 1, "flex", "w-full", "items-center", "p-4", "text-white-dark", "dark:bg-[#1b2e4b]", 3, "click", "ngClass"], [1, "ltr:ml-auto", "rtl:mr-auto", 3, "ngClass"], ["width", "24", "height", "24", "viewBox", "0 0 24 24", "fill", "none", "xmlns", "http://www.w3.org/2000/svg", 1, "h-4", "w-4"], ["d", "M19 9L12 15L5 9", "stroke", "currentColor", "stroke-width", "1.5", "stroke-linecap", "round", "stroke-linejoin", "round"], [1, "accordion-content"], [1, "space-y-2", "border-t", "border-[#d3d3d3]", "p-4", "text-[13px]", "dark:border-[#1b2e4b]"], [1, "grid", "grid-cols-2", "gap-3", "sm:grid-cols-1", "md:grid-cols-4"], ["bindLabel", "label", "bindValue", "value", "formControlName", "approver_type", "placeholder", "Select Approver Type", 1, "custom-multiselect", "multi-ng-select", 3, "change", "clearable", "searchable"], [3, "value"], ["class", "form-group", 4, "ngIf"], ["type", "number", "formControlName", "approver_order_no", "placeholder", "Approver Order", 1, "form-control", "form-input", "w-full", "rounded-[4px]", "border", "border-gray-300", "py-1", "text-xs", "text-gray-600", "placeholder:text-white-dark"], ["class", "invalid-feedback mt-1 text-danger", 4, "ngIf"], ["bindLabel", "label", "bindValue", "value", "formControlName", "accept_email", "placeholder", "Select Template", 1, "custom-multiselect", "multi-ng-select", 3, "clearable", "searchable"], ["bindLabel", "label", "bindValue", "value", "formControlName", "reject_email", "placeholder", "Select Template", 1, "custom-multiselect", "multi-ng-select", 3, "clearable", "searchable"], ["bindLabel", "label", "bindValue", "value", "formControlName", "accept_whatsapp", "placeholder", "Select Template", 1, "custom-multiselect", "multi-ng-select", 3, "clearable", "searchable"], ["bindLabel", "label", "bindValue", "value", "formControlName", "reject_whatsapp", "placeholder", "Select Template", 1, "custom-multiselect", "multi-ng-select", 3, "clearable", "searchable"], [1, "fa-solid", "fa-xmark", "color-red", "mt-5", "cursor-pointer", "text-xl"], [1, "grid", "gap-4", "md:grid-cols-1", "lg:grid-cols-2"], [1, "p-2"], [1, "mb-2", "flex", "items-center", "gap-2"], ["for", "approve_query_information", 1, "font-medium"], [1, "fas", "fa-circle-info", "fa-lg", "cursor-pointer", "!leading-none", 3, "click"], ["appDynamicFontSize", "body", 1, "monaco-editor-container"], ["monacoEditor", "", "id", "approve_query_information", "formControlName", "approve_query_information", 1, "monaco-editor", 3, "options"], ["for", "reject_query_information", 1, "font-medium"], ["monacoEditor", "", "id", "reject_query_information", "formControlName", "reject_query_information", 1, "monaco-editor", 3, "options"], ["bindLabel", "label", "bindValue", "value", "formControlName", "tag", "placeholder", "Select Tag", 1, "custom-multiselect", "multi-ng-select", 3, "search", "clear", "change", "clearable", "searchable", "multiple"], [1, "invalid-feedback", "mt-1", "text-danger"], ["bindLabel", "label", "bindValue", "value", "formControlName", "users", "placeholder", "Select Users", 1, "custom-multiselect", "multi-ng-select", 3, "search", "clear", "change", "multiple", "clearable", "searchable"], ["bindLabel", "label", "bindValue", "value", "formControlName", "roles", "placeholder", "Select Roles", 1, "custom-multiselect", "multi-ng-select", 3, "search", "clear", "change", "multiple", "clearable", "searchable"], [1, "fa-solid", "fa-xmark", "color-red", "mt-5", "cursor-pointer", "text-xl", 3, "click"], [1, "fixed", "inset-0", "z-50", "overflow-y-auto"], [1, "fixed", "inset-0", "bg-black/50", "transition-opacity", "dark:bg-black/70"], [1, "flex", "min-h-screen", "items-center", "justify-center", "p-2", "sm:p-4"], [1, "max-w-auto", "relative", "w-10/12", "transform", "overflow-hidden", "rounded-lg", "bg-white", "shadow-xl", "transition-all", "dark:border", "dark:border-gray-700", "dark:bg-gray-800", "sm:w-8/12"], [1, "border-b", "bg-gray-50", "px-4", "py-3", "dark:border-gray-700", "dark:bg-gray-900", "sm:px-6"], [1, "flex", "items-center", "justify-between"], [1, "flex", "gap-4"], ["appDynamicFontSize", "body", 1, "text-md", "font-bold"], [1, "close-btn", 3, "click"], [1, "sr-only"], [1, "fa-solid", "fa-xmark"], [1, "max-h-auto", "gap-5", "overflow-y-auto", "px-4", "py-4", "sm:px-6"], [1, "px-4", "sm:px-6"], [1, "flex", "list-disc", "flex-col", "gap-3"], [4, "ngFor", "ngForOf"], [1, "relative"], ["class", "absolute right-5 top-3 z-50 rounded bg-green-700 px-3 py-1 text-sm text-white hover:bg-green-600", 4, "ngIf"], [1, "monaco-editor-container", ".editor-container", "mt-3", "rounded", "border", "border-gray-300"], ["monacoEditor", "", "id", "popupInformation", 1, "monaco-editor", 3, "click", "ngModelChange", "options", "ngModel"], [1, "editor-overlay", 3, "click"], [1, "flex", "items-center", "gap-2"], ["appDynamicFontSize", "body", 1, "text-sm"], [1, "absolute", "right-5", "top-3", "z-50", "rounded", "bg-green-700", "px-3", "py-1", "text-sm", "text-white", "hover:bg-green-600"]], template: function ApprovalWorkflowAssignmentComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 1)(2, "h5", 2);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 3)(6, "button", 4);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_Template_button_click_6_listener() {
      return ctx.location.back();
    });
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "button", 5);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_Template_button_click_9_listener() {
      return ctx.submit();
    });
    \u0275\u0275text(10, "Submit");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(11, "div")(12, "form", 6)(13, "div", 7)(14, "div", 8)(15, "div", 9)(16, "label", 10);
    \u0275\u0275text(17);
    \u0275\u0275pipe(18, "translate");
    \u0275\u0275elementStart(19, "span", 11);
    \u0275\u0275text(20, "*");
    \u0275\u0275elementEnd()();
    \u0275\u0275element(21, "input", 12);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(22, "button", 13);
    \u0275\u0275listener("click", function ApprovalWorkflowAssignmentComponent_Template_button_click_22_listener() {
      return ctx.addApproverAssignment();
    });
    \u0275\u0275text(23, " Add ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(24, "div", 14);
    \u0275\u0275repeaterCreate(25, ApprovalWorkflowAssignmentComponent_For_26_Template, 82, 52, "div", 15, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275template(27, ApprovalWorkflowAssignmentComponent_div_27_Template, 23, 7, "div", 16)(28, ApprovalWorkflowAssignmentComponent_app_loader_28_Template, 1, 0, "app-loader", 17);
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(4, 6, "approval_workflow_assignment_form"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(8, 8, "back"), " ");
    \u0275\u0275advance(5);
    \u0275\u0275property("formGroup", ctx.form);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(18, 10, "approval_workflow"), " ");
    \u0275\u0275advance(8);
    \u0275\u0275repeater(ctx.getApproverAssignmentList());
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isInfoModalOpen);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.loading);
  }
}, dependencies: [
  FormlyModule,
  CommonSharedModule,
  NgClass,
  NgForOf,
  NgIf,
  \u0275NgNoValidate,
  DefaultValueAccessor,
  NumberValueAccessor,
  NgControlStatus,
  NgControlStatusGroup,
  RequiredValidator,
  NgModel,
  NgSelectComponent,
  NgOptionComponent,
  DynamicFontSizeDirective,
  TranslatePipe,
  LoaderComponent,
  FormlyBootstrapModule,
  ReactiveFormsModule,
  FormGroupDirective,
  FormControlName,
  FormGroupName,
  FormArrayName,
  FormlyConfigModule,
  MonacoEditorModule,
  EditorComponent,
  FormsModule,
  CommonModule,
  NgSelectModule
], styles: ["\n\n.grid[_ngcontent-%COMP%] {\n  display: grid;\n  gap: 1rem;\n}\n.grid-cols-1[_ngcontent-%COMP%] {\n  grid-template-columns: 1fr;\n}\n.md\\:grid-cols-2[_ngcontent-%COMP%] {\n  grid-template-columns: repeat(2, 1fr);\n}\n.email-template-assignments[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-columns: 2fr 1fr;\n  gap: 1rem;\n  align-items: start;\n}\n.email-template-main[_ngcontent-%COMP%] {\n  display: flex;\n  flex-wrap: wrap;\n  gap: 1rem;\n  align-items: center;\n}\n.email-template-group[_ngcontent-%COMP%] {\n  flex: 1;\n}\n.email-template-cc-bcc[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  gap: 0.5rem;\n}\n.min-w-200-p[_ngcontent-%COMP%] {\n  min-width: 200px;\n}\n.monaco-editor-container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 50vh;\n  resize: vertical;\n  min-height: 60vh;\n  max-height: 100vh;\n}\n.monaco-editor[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n}\n.editor-container[_ngcontent-%COMP%] {\n  position: relative;\n}\n.editor-overlay[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  overflow: auto;\n  cursor: pointer !important;\n  background: transparent;\n  pointer-events: none;\n}\n.monaco-editor[_ngcontent-%COMP%] {\n  cursor: pointer !important;\n}\n.monaco-editor[_ngcontent-%COMP%]   .view-line[_ngcontent-%COMP%] {\n  cursor: pointer !important;\n}\n/*# sourceMappingURL=approval-workflow-assignment.component.css.map */"], data: { animation: [
  trigger("slideDownUp", [
    state("true", style({ height: "*", opacity: 1 })),
    state("false", style({ height: "0px", opacity: 0 })),
    transition("false <=> true", animate("300ms ease-in-out"))
  ])
] } });
var ApprovalWorkflowAssignmentComponent = _ApprovalWorkflowAssignmentComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ApprovalWorkflowAssignmentComponent, { className: "ApprovalWorkflowAssignmentComponent", filePath: "src\\app\\@lcp-framework\\pages\\approval-workflow-assignment\\approval-workflow-assignment.component.ts", lineNumber: 48 });
})();
export {
  ApprovalWorkflowAssignmentComponent
};
//# sourceMappingURL=chunk-OP5BXFOB.js.map
