import {
  FormlyBootstrapModule,
  FormlyConfigModule,
  FormlyModule
} from "./chunk-NFRJCL7R.js";
import "./chunk-62OL73TD.js";
import "./chunk-IGGXREIH.js";
import "./chunk-X5XWBDVM.js";
import {
  MenuMapService
} from "./chunk-3FLJCSSF.js";
import {
  ToastrService
} from "./chunk-2YLAF7RI.js";
import {
  CommonSharedModule,
  DynamicFontSizeDirective,
  NgSelectModule
} from "./chunk-7NQGM4EA.js";
import {
  FormBuilder,
  FormsModule,
  ReactiveFormsModule,
  TranslatePipe,
  TranslateService
} from "./chunk-NLYGDKUR.js";
import "./chunk-ZEL7H2AL.js";
import {
  ActivatedRoute,
  LocalStorageService,
  Router
} from "./chunk-P7K2QEDI.js";
import {
  CommonModule,
  Location,
  NgClass,
  NgForOf,
  NgIf,
  ɵsetClassDebugInfo,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵdefineComponent,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementContainerEnd,
  ɵɵelementContainerStart,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵlistener,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵpureFunction5,
  ɵɵtemplate,
  ɵɵtext,
  ɵɵtextInterpolate1
} from "./chunk-GKZIWABI.js";
import {
  __async
} from "./chunk-CVWHNZRK.js";

// src/app/@lcp-framework/pages/approval-requests-tracking/approval-requests-tracking.component.ts
var _c0 = (a0, a1, a2, a3, a4) => ({ "bg-green-500": a0, "bg-yellow-400": a1, "bg-gray-400": a2, "bg-red-400": a3, "bg-purple-400": a4 });
var _c1 = (a0, a1, a2, a3, a4) => ({ "bg-green-100 text-green-800": a0, "bg-yellow-100 text-yellow-800": a1, "bg-gray-200 text-gray-800": a2, "bg-red-100 text-red-800": a3, "bg-purple-100 text-purple-800": a4 });
function ApprovalRequestsTrackingComponent_ng_container_25_div_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 20);
  }
}
function ApprovalRequestsTrackingComponent_ng_container_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "div", 12)(2, "div", 13);
    \u0275\u0275element(3, "div", 14);
    \u0275\u0275template(4, ApprovalRequestsTrackingComponent_ng_container_25_div_4_Template, 1, 0, "div", 15);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 16)(6, "div", 17)(7, "p", 18);
    \u0275\u0275text(8);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "div")(10, "span", 19);
    \u0275\u0275text(11);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(12, "p", 7);
    \u0275\u0275text(13);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "p", 7);
    \u0275\u0275text(15);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(16, "p", 7);
    \u0275\u0275text(17);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "p", 7);
    \u0275\u0275text(19);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(20, "p", 7);
    \u0275\u0275text(21);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const step_r1 = ctx.$implicit;
    const last_r2 = ctx.last;
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction5(10, _c0, step_r1.review_status === "approval_completed", step_r1.review_status === "pending", step_r1.review_status === "approval_needed", step_r1.review_status === "approval_rejected", step_r1.review_status === "void"));
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !last_r2);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("Approver ", step_r1.approver_order_no, "");
    \u0275\u0275advance(2);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction5(16, _c1, step_r1.review_status === "approval_completed", step_r1.review_status === "pending", step_r1.review_status === "approval_needed", step_r1.review_status === "approval_rejected", step_r1.review_status === "void"));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r2.reviewStatuses[step_r1.review_status], " ");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Type: ", ctx_r2.approverTypes[step_r1.approver_type], "");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Assigned At: ", (step_r1 == null ? null : step_r1.assigned_at) || "N/A", "");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Processed At: ", (step_r1 == null ? null : step_r1.processed_at) || "N/A", "");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Reviewed By: ", (step_r1 == null ? null : step_r1.reviewed_by) || "N/A", "");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Reason: ", (step_r1 == null ? null : step_r1.reason) || "N/A", "");
  }
}
var _ApprovalRequestsTrackingComponent = class _ApprovalRequestsTrackingComponent {
  constructor(fb, translate, location, router, route, toastr, localStorageService, commonService) {
    this.fb = fb;
    this.translate = translate;
    this.location = location;
    this.router = router;
    this.route = route;
    this.toastr = toastr;
    this.localStorageService = localStorageService;
    this.commonService = commonService;
    this.approverTypes = {
      user_id: "User",
      role_id: "Role",
      tag: "Tag"
    };
    this.reviewStatuses = {
      approval_completed: "Approved",
      approval_rejected: "Rejected",
      pending: "Pending",
      void: "Void",
      approval_needed: "Approval Requested"
    };
    this.approvalSteps = [];
    this.uniqueId = null;
    this.loading = false;
    this.route.paramMap.subscribe((params) => {
      this.uniqueId = params.get("uuid");
    });
  }
  ngOnInit() {
    return __async(this, null, function* () {
      yield this.getApprovalWorkflowDetail();
    });
  }
  getApprovalWorkflowDetail() {
    return __async(this, null, function* () {
      if (this.uniqueId) {
        const payload = {
          group_by: ["approval_process_job_workflows.id", "u1.email", "u2.email"],
          includes: [
            {
              join_type: "LEFT",
              table_name: "users u1",
              join_condition: "u1.id = approval_process_job_workflows.user_id"
            },
            {
              join_type: "LEFT",
              table_name: "users u2",
              join_condition: "u2.id = approval_process_job_workflows.reviewed_by"
            }
          ],
          company_id: 1,
          search_all: [
            {
              value: this.uniqueId,
              operator: "=",
              column_name: "approval_process_job_workflows.approval_process_job_id"
            },
            {
              value: "3",
              operator: "!=",
              column_name: "approval_process_job_workflows.status_id"
            }
          ],
          limit_range: 1,
          print_query: true,
          start_index: 0,
          sort_columns: [["approval_process_job_workflows.approver_order_no", "asc"]],
          primary_table: "approval_process_job_workflows",
          select_columns: [
            ["approval_process_job_workflows.id", "id"],
            ["approval_process_job_workflows.approval_process_job_name", "name"],
            ["approval_process_job_workflows.approval_process_job_description", "description"],
            ["approval_process_job_workflows.approver_order_no", "approver_order_no"],
            ["approval_process_job_workflows.approver_type", "approver_type"],
            ["approval_process_job_workflows.review_status", "review_status"],
            ["approval_process_job_workflows.reason", "reason"],
            [`TO_CHAR(approval_process_job_workflows.assigned_at, 'YYYY-MM-DD" "HH24:MI')`, "assigned_at"],
            [`TO_CHAR(approval_process_job_workflows.processed_at, 'YYYY-MM-DD" "HH24:MI')`, "processed_at"],
            ["u2.email", "reviewed_by"],
            ["u1.email", "requested_by"]
          ]
        };
        this.loading = true;
        this.commonService.getCommonList(payload).subscribe({
          next: (response) => {
            if (response.code === 200 && response.status) {
              this.loading = false;
              if (response.data.records) {
                this.approvalSteps = response.data.records;
              } else {
                const key = "failed_to_approval_request_details";
                const errorMessage = this.translate.instant(key);
                this.toastr.error(errorMessage, "Error");
              }
            } else {
              this.loading = false;
            }
          },
          error: (error) => {
            this.loading = false;
            console.error("Error fetching Approval Request details:", error);
          }
        });
      } else {
        this.loading = false;
        const key = "invalid_approval_request";
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
      }
    });
  }
};
_ApprovalRequestsTrackingComponent.\u0275fac = function ApprovalRequestsTrackingComponent_Factory(t) {
  return new (t || _ApprovalRequestsTrackingComponent)(\u0275\u0275directiveInject(FormBuilder), \u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(Location), \u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(ActivatedRoute), \u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(LocalStorageService), \u0275\u0275directiveInject(MenuMapService));
};
_ApprovalRequestsTrackingComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ApprovalRequestsTrackingComponent, selectors: [["app-approval-requests-tracking"]], standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 26, vars: 10, consts: [[1, "panel"], [1, "mb-5", "flex", "flex-col", "items-start", "justify-between", "gap-3", "lg:flex-row", "lg:items-center"], [1, "text-lg", "font-semibold", "dark:text-white-light"], [1, "align-center", "flex", "gap-3"], ["appDynamicFontSize", "body", "type", "button", 1, "btn", "btn-danger", "mr-5", "ltr:rounded-r", "rtl:rounded-l", 3, "click"], [1, "max-w", "mx-auto", "flex", "flex-col", "gap-4", "p-4"], [1, "flex", "flex-col", "gap-2"], ["appDynamicFontSize", "body", 1, "text-sm", "text-gray-600"], ["appDynamicFontSize", "body", 1, "text-base", "font-medium", "text-black"], [1, "flex", "justify-center", "p-5"], [1, "relative", "flex", "w-full", "max-w-3xl", "flex-col"], [4, "ngFor", "ngForOf"], [1, "flex"], [1, "mr-6", "flex", "flex-col", "items-center"], [1, "h-4", "w-4", "rounded-full", "border-2", "border-white", 3, "ngClass"], ["class", "my-1 w-0.5 flex-1 bg-gray-300", 4, "ngIf"], [1, "flex-1", "space-y-1"], [1, "flex", "flex-col", "gap-1", "sm:flex-row", "sm:items-center", "sm:justify-between", "sm:gap-2"], ["appDynamicFontSize", "body", 1, "text-base", "font-medium"], ["appDynamicFontSize", "body", 1, "inline-block", "rounded", "px-3", "py-1", "text-xs", "font-semibold", 3, "ngClass"], [1, "my-1", "w-0.5", "flex-1", "bg-gray-300"]], template: function ApprovalRequestsTrackingComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 1)(2, "h5", 2);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 3)(6, "button", 4);
    \u0275\u0275listener("click", function ApprovalRequestsTrackingComponent_Template_button_click_6_listener() {
      return ctx.location.back();
    });
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(9, "div", 5)(10, "div", 6)(11, "p", 7)(12, "span", 8);
    \u0275\u0275text(13, "Name : ");
    \u0275\u0275elementEnd();
    \u0275\u0275text(14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "p", 7)(16, "span", 8);
    \u0275\u0275text(17, "Description : ");
    \u0275\u0275elementEnd();
    \u0275\u0275text(18);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(19, "p", 7)(20, "span", 8);
    \u0275\u0275text(21, "Requested By : ");
    \u0275\u0275elementEnd();
    \u0275\u0275text(22);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(23, "div", 9)(24, "div", 10);
    \u0275\u0275template(25, ApprovalRequestsTrackingComponent_ng_container_25_Template, 22, 22, "ng-container", 11);
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(4, 6, "approval_request_tracker"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(8, 8, "back"), " ");
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1("", (ctx.approvalSteps[0] == null ? null : ctx.approvalSteps[0].name) || "N/A", " ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("", (ctx.approvalSteps[0] == null ? null : ctx.approvalSteps[0].description) || "N/A", " ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("", (ctx.approvalSteps[0] == null ? null : ctx.approvalSteps[0].requested_by) || "N/A", " ");
    \u0275\u0275advance(3);
    \u0275\u0275property("ngForOf", ctx.approvalSteps);
  }
}, dependencies: [
  FormlyModule,
  CommonSharedModule,
  NgClass,
  NgForOf,
  NgIf,
  DynamicFontSizeDirective,
  TranslatePipe,
  FormlyBootstrapModule,
  ReactiveFormsModule,
  FormlyConfigModule,
  FormsModule,
  CommonModule,
  NgSelectModule
] });
var ApprovalRequestsTrackingComponent = _ApprovalRequestsTrackingComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ApprovalRequestsTrackingComponent, { className: "ApprovalRequestsTrackingComponent", filePath: "src\\app\\@lcp-framework\\pages\\approval-requests-tracking\\approval-requests-tracking.component.ts", lineNumber: 33 });
})();
export {
  ApprovalRequestsTrackingComponent
};
//# sourceMappingURL=chunk-MEBLKNBT.js.map
