import {
  ToastrService
} from "./chunk-2YLAF7RI.js";
import {
  DefaultValueAccessor,
  FormBuilder,
  FormControlName,
  FormGroup,
  FormGroupDirective,
  NgControlStatus,
  NgControlStatusGroup,
  NgSelectOption,
  NumberValueAccessor,
  ReactiveFormsModule,
  SelectControlValueAccessor,
  TranslateModule,
  TranslatePipe,
  TranslateService,
  Validators,
  ɵNgSelectMultipleOption
} from "./chunk-NLYGDKUR.js";
import "./chunk-ZEL7H2AL.js";
import {
  ActivatedRoute,
  GridApiService,
  LocalStorageService,
  Router,
  environment
} from "./chunk-P7K2QEDI.js";
import {
  CommonModule,
  Location,
  NgIf,
  ɵsetClassDebugInfo,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵdefineComponent,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementContainerEnd,
  ɵɵelementContainerStart,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵlistener,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵreference,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtemplate,
  ɵɵtemplateRefExtractor,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1
} from "./chunk-GKZIWABI.js";
import "./chunk-CVWHNZRK.js";

// src/app/@lcp-framework/pages/aboutlcp/aboutlcp.component.ts
function AboutlcpComponent_ng_container_44_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "div");
    \u0275\u0275element(2, "i", 26);
    \u0275\u0275elementStart(3, "p", 27);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(5, 1, "click_or_drag_file"));
  }
}
function AboutlcpComponent_ng_template_45_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 28)(1, "span", 29);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "button", 30);
    \u0275\u0275listener("click", function AboutlcpComponent_ng_template_45_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.clearFile("pdf"));
    });
    \u0275\u0275element(4, "i", 31);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r3.fileNamePdf);
  }
}
function AboutlcpComponent_ng_container_54_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "div");
    \u0275\u0275element(2, "i", 26);
    \u0275\u0275elementStart(3, "p", 27);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(5, 1, "click_or_drag_file"));
  }
}
function AboutlcpComponent_ng_template_55_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 28)(1, "span", 29);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "button", 30);
    \u0275\u0275listener("click", function AboutlcpComponent_ng_template_55_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.clearFile("word"));
    });
    \u0275\u0275element(4, "i", 31);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r3.fileNameWord);
  }
}
var _AboutlcpComponent = class _AboutlcpComponent {
  constructor(fb, toastr, gridApiService, router, location, route, translate, localStorageService) {
    this.fb = fb;
    this.toastr = toastr;
    this.gridApiService = gridApiService;
    this.router = router;
    this.location = location;
    this.route = route;
    this.translate = translate;
    this.localStorageService = localStorageService;
    this.companyId = null;
    this.apiUrl = environment.apiUrl;
    this.fileNamePdf = "";
    this.fileNameWord = "";
    this.pdfFilePath = "";
    this.wordFilePath = "";
    this.isEditMode = false;
    this.aboutLcpId = null;
    this.update_json_schema = {
      print_query: true,
      action: ["update"],
      table: ["about_lcp"],
      table_mapping: ["table1"],
      data: {
        table1: []
      },
      conditions: {
        table1: []
      }
    };
    this.insert_json_schema = {
      print_query: true,
      action: ["insert"],
      table: ["about_lcp"],
      table_mapping: ["table1"],
      data: {
        table1: []
      },
      conditions: {}
    };
    this.form = this.fb.group({
      type: ["", [Validators.required]],
      name: ["", [Validators.required]],
      order_no: [""],
      description: [""],
      documentation_video_url: [""],
      documentation_pdf: [null],
      documentation_word: [null]
    });
  }
  ngOnInit() {
    const userData = this.localStorageService.getData("user_data");
    if (userData) {
      const parsedData = JSON.parse(userData);
      this.userId = parsedData.main?.id;
      this.companyId = parsedData.main?.company_id;
    }
    this.route.paramMap.subscribe((params) => {
      this.aboutLcpId = params.get("id");
      if (this.aboutLcpId) {
        this.isEditMode = true;
        this.loadExistingData(this.aboutLcpId);
      } else {
        this.isEditMode = false;
      }
    });
  }
  onFileChange(event, type) {
    const input = event.target;
    if (input.files && input.files.length > 0) {
      const file = input.files[0];
      const validPdfTypes = ["application/pdf"];
      const validWordTypes = [
        "application/msword",
        // .doc
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document"
        // .docx
      ];
      if (type === "pdf" && !validPdfTypes.includes(file.type) || type === "word" && !validWordTypes.includes(file.type)) {
        this.toastr.warning(this.translate.instant("invalid_file_type"), "Warning");
        input.value = "";
        return;
      }
      this.gridApiService.uploadConfigPicture(file).subscribe({
        next: (response) => {
          if (response?.body?.status) {
            const filePath = response.body.data;
            if (type === "pdf") {
              this.form.patchValue({ documentation_pdf: filePath });
              this.fileNamePdf = file.name;
              this.pdfFilePath = filePath;
            } else {
              this.form.patchValue({ documentation_word: filePath });
              this.fileNameWord = file.name;
              this.wordFilePath = filePath;
            }
          }
        },
        error: () => {
          this.toastr.error(this.translate.instant("file_upload_failed"), "Error");
        }
      });
    }
  }
  clearFile(type) {
    if (type === "pdf") {
      this.fileNamePdf = "";
      this.pdfFilePath = "";
      this.form.patchValue({ documentation_pdf: null });
    } else {
      this.fileNameWord = "";
      this.wordFilePath = "";
      this.form.patchValue({ documentation_word: null });
    }
  }
  onSubmit() {
    console.log("this.form.invalid", this.form.invalid);
    if (this.form.invalid) {
      this.markFormGroupTouched(this.form);
      return;
    }
    if (this.isEditMode && this.aboutLcpId) {
      this.update_json_schema.data["table1"] = [
        {
          uuid: this.aboutLcpId,
          // Using the id for updating the record
          type: this.form.value.type,
          name: this.form.value.name,
          order_no: this.form.value.order_no || 0,
          description: this.form.value.description || "",
          documentation_video_url: this.form.value.documentation_video_url || "",
          documentation_pdf: this.form.value.documentation_pdf || "",
          documentation_word: this.form.value.documentation_word || "",
          updated_by: true,
          updated_at: true
        }
      ];
      this.update_json_schema.conditions["table1"] = [{ uuid: this.aboutLcpId }];
      this.gridApiService.executeRecords(this.update_json_schema).subscribe((response) => {
        if (response.status && response.code === 200) {
          this.toastr.success(this.translate.instant("record_updated_successfully"));
          this.router.navigate(["/about-lcp"]);
        } else {
          this.toastr.error(this.translate.instant("record_failed_updated"), "Error");
        }
      }, (error) => {
        this.toastr.error(this.translate.instant("record_failed_updated"), "Error");
      });
    } else {
      this.insert_json_schema.data["table1"] = [
        {
          type: this.form.value.type,
          name: this.form.value.name,
          order_no: this.form.value.order_no || 0,
          description: this.form.value.description || "",
          documentation_video_url: this.form.value.documentation_video_url || "",
          documentation_pdf: this.form.value.documentation_pdf || "",
          documentation_word: this.form.value.documentation_word || "",
          created_by: true,
          created_at: true
        }
      ];
      this.gridApiService.executeRecords(this.insert_json_schema).subscribe((response) => {
        if (response.status && response.code === 200) {
          this.toastr.success(this.translate.instant("record_inserted_successfully"));
          this.router.navigate(["/about-lcp"]);
        } else {
          this.toastr.error(response.message, "Error");
        }
      }, (error) => {
        this.toastr.error(this.translate.instant("record_failed_inserted"), "Error");
      });
    }
  }
  loadExistingData(id) {
    if (!this.companyId) {
      console.error("Company ID is not available");
      return;
    }
    const payload = {
      company_id: this.companyId,
      print_query: true,
      primary_table: "about_lcp",
      start_index: 0,
      limit_range: 1,
      sort_columns: [["about_lcp.id", "asc"]],
      search_all: [
        {
          column_name: "about_lcp.uuid",
          value: id,
          operator: "="
        }
      ],
      select_columns: [["about_lcp.*"]],
      group_by: ["about_lcp.id"]
    };
    this.gridApiService.getAllList(payload).subscribe({
      next: (response) => {
        console.log(response);
        if (response.code === 200 && response.status) {
          const data = response.data.records[0];
          this.form.patchValue({
            type: data.type,
            name: data.name,
            order_no: data.order_no,
            description: data.description,
            documentation_video_url: data.documentation_video_url,
            documentation_pdf: data.documentation_pdf,
            documentation_word: data.documentation_word
          });
          this.fileNamePdf = data.documentation_pdf;
          this.fileNameWord = data.documentation_word;
        }
      },
      error: (error) => {
        const key = "error";
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
        console.error("Error fetching entity types:", error);
      }
    });
  }
  goBack() {
    this.location.back();
  }
  markFormGroupTouched(formGroup) {
    Object.values(formGroup.controls).forEach((control) => {
      control.markAsTouched();
      if (control instanceof FormGroup) {
        this.markFormGroupTouched(control);
      }
    });
  }
};
_AboutlcpComponent.\u0275fac = function AboutlcpComponent_Factory(t) {
  return new (t || _AboutlcpComponent)(\u0275\u0275directiveInject(FormBuilder), \u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(Location), \u0275\u0275directiveInject(ActivatedRoute), \u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(LocalStorageService));
};
_AboutlcpComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AboutlcpComponent, selectors: [["app-aboutlcp"]], standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 66, vars: 38, consts: [["showPdfFile", ""], ["pdfInput", ""], ["showWordFile", ""], ["wordInput", ""], [1, "rounded", "bg-white", "p-6", "shadow", 3, "formGroup"], [1, "mb-4", "text-xl", "font-semibold"], [1, "grid", "grid-cols-3", "gap-4", "mt-4"], [1, "required-mark", "mb-1", "block", "font-medium"], ["formControlName", "type", 1, "form-select", "w-full"], ["value", "", "disabled", "", "selected", ""], ["value", "lcp"], ["value", "project"], ["type", "text", "formControlName", "name", 1, "form-input", "w-full"], [1, "mb-1", "block", "font-medium"], ["type", "number", "formControlName", "order_no", 1, "form-input", "w-full"], ["rows", "3", "formControlName", "description", 1, "form-input", "w-full"], [1, "col-span-2"], ["type", "text", "formControlName", "documentation_video_url", 1, "form-input", "w-full"], [1, "grid", "grid-cols-2", "gap-4", "mt-4"], [1, "relative", "flex", "cursor-pointer", "flex-col", "items-center", "justify-center", "rounded-md", "border-2", "border-dashed", "border-gray-300", "bg-white", "px-4", "py-6", "text-center", "hover:bg-gray-50", 3, "click"], [4, "ngIf", "ngIfElse"], ["type", "file", "accept", "application/pdf", 1, "hidden", 3, "change"], ["type", "file", "accept", ".doc,.docx", 1, "hidden", 3, "change"], [1, "mt-6", "flex", "gap-4"], ["type", "button", 1, "btn", "btn-danger", 3, "click"], ["type", "button", 1, "btn", "btn-primary", 3, "click", "disabled"], [1, "fa-solid", "fa-cloud-arrow-up", "text-2xl", "text-blue-500"], [1, "mt-2", "text-sm", "text-gray-600"], [1, "flex", "w-full", "items-center", "justify-between"], [1, "truncate", "text-sm", "text-gray-700"], ["type", "button", 1, "ml-2", "text-red-500", 3, "click"], [1, "fa-solid", "fa-times-circle"]], template: function AboutlcpComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 4)(1, "h2", 5);
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 6)(6, "div")(7, "label", 7);
    \u0275\u0275text(8);
    \u0275\u0275pipe(9, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "select", 8)(11, "option", 9);
    \u0275\u0275text(12, "Select Type");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "option", 10);
    \u0275\u0275text(14, "LCP");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "option", 11);
    \u0275\u0275text(16, "Project");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(17, "div")(18, "label", 7);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(21, "input", 12);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(22, "div")(23, "label", 13);
    \u0275\u0275text(24);
    \u0275\u0275pipe(25, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(26, "input", 14);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(27, "div", 6)(28, "div")(29, "label", 13);
    \u0275\u0275text(30);
    \u0275\u0275pipe(31, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(32, "textarea", 15);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(33, "div", 16)(34, "label", 13);
    \u0275\u0275text(35);
    \u0275\u0275pipe(36, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(37, "input", 17);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(38, "div", 18)(39, "div")(40, "label", 13);
    \u0275\u0275text(41);
    \u0275\u0275pipe(42, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(43, "div", 19);
    \u0275\u0275listener("click", function AboutlcpComponent_Template_div_click_43_listener() {
      \u0275\u0275restoreView(_r1);
      const pdfInput_r2 = \u0275\u0275reference(48);
      return \u0275\u0275resetView(pdfInput_r2.click());
    });
    \u0275\u0275template(44, AboutlcpComponent_ng_container_44_Template, 6, 3, "ng-container", 20)(45, AboutlcpComponent_ng_template_45_Template, 5, 1, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementStart(47, "input", 21, 1);
    \u0275\u0275listener("change", function AboutlcpComponent_Template_input_change_47_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onFileChange($event, "pdf"));
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(49, "div")(50, "label", 13);
    \u0275\u0275text(51);
    \u0275\u0275pipe(52, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(53, "div", 19);
    \u0275\u0275listener("click", function AboutlcpComponent_Template_div_click_53_listener() {
      \u0275\u0275restoreView(_r1);
      const wordInput_r5 = \u0275\u0275reference(58);
      return \u0275\u0275resetView(wordInput_r5.click());
    });
    \u0275\u0275template(54, AboutlcpComponent_ng_container_54_Template, 6, 3, "ng-container", 20)(55, AboutlcpComponent_ng_template_55_Template, 5, 1, "ng-template", null, 2, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementStart(57, "input", 22, 3);
    \u0275\u0275listener("change", function AboutlcpComponent_Template_input_change_57_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onFileChange($event, "word"));
    });
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(59, "div", 23)(60, "button", 24);
    \u0275\u0275listener("click", function AboutlcpComponent_Template_button_click_60_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goBack());
    });
    \u0275\u0275text(61);
    \u0275\u0275pipe(62, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(63, "button", 25);
    \u0275\u0275listener("click", function AboutlcpComponent_Template_button_click_63_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onSubmit());
    });
    \u0275\u0275text(64);
    \u0275\u0275pipe(65, "translate");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const showPdfFile_r7 = \u0275\u0275reference(46);
    const showWordFile_r8 = \u0275\u0275reference(56);
    \u0275\u0275property("formGroup", ctx.form);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx.isEditMode ? \u0275\u0275pipeBind1(3, 16, "title_edit_about_lcp") : \u0275\u0275pipeBind1(4, 18, "title_add_about_lcp"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(9, 20, "type"));
    \u0275\u0275advance(11);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(20, 22, "topic"));
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(25, 24, "order_no"));
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(31, 26, "description"));
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(36, 28, "documentation_video_url"));
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(42, 30, "documentation_pdf"));
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", !ctx.fileNamePdf)("ngIfElse", showPdfFile_r7);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(52, 32, "documentation_word"));
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", !ctx.fileNameWord)("ngIfElse", showWordFile_r8);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(62, 34, "back"));
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", ctx.form.invalid);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(65, 36, "submit"));
  }
}, dependencies: [CommonModule, NgIf, ReactiveFormsModule, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, NumberValueAccessor, SelectControlValueAccessor, NgControlStatus, NgControlStatusGroup, FormGroupDirective, FormControlName, TranslateModule, TranslatePipe], styles: ["\n\n.upload-dropzone[_ngcontent-%COMP%] {\n  border: 2px dashed #cbd5e0;\n  border-radius: 6px;\n  padding: 1.5rem;\n  text-align: center;\n  background-color: #f9fafb;\n  cursor: pointer;\n  transition: background-color 0.2s ease-in-out;\n}\n.upload-dropzone[_ngcontent-%COMP%]:hover {\n  background-color: #f3f4f6;\n}\n/*# sourceMappingURL=aboutlcp.component.css.map */"] });
var AboutlcpComponent = _AboutlcpComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AboutlcpComponent, { className: "AboutlcpComponent", filePath: "src\\app\\@lcp-framework\\pages\\aboutlcp\\aboutlcp.component.ts", lineNumber: 20 });
})();
export {
  AboutlcpComponent
};
//# sourceMappingURL=chunk-U24FN4IB.js.map
