import {
  EditorComponent,
  MonacoEditorModule
} from "./chunk-62OL73TD.js";
import {
  SafeHtmlPipe
} from "./chunk-IGGXREIH.js";
import {
  NgOptionTemplateDirective,
  NgSelectComponent,
  NgSelectModule,
  takeUntilDestroyed
} from "./chunk-7NQGM4EA.js";
import {
  AbstractControl,
  CheckboxControlValueAccessor,
  DefaultValueAccessor,
  FormArray,
  FormControl,
  FormControlDirective,
  FormGroup,
  FormGroupDirective,
  NG_VALIDATORS,
  NG_VALUE_ACCESSOR,
  NgControl,
  NgControlStatus,
  NgControlStatusGroup,
  NgSelectOption,
  NumberValueAccessor,
  RadioControlValueAccessor,
  ReactiveFormsModule,
  SelectControlValueAccessor,
  SelectMultipleControlValueAccessor,
  Validators,
  ɵNgNoValidate,
  ɵNgSelectMultipleOption
} from "./chunk-NLYGDKUR.js";
import {
  GridApiService,
  LocalStorageService,
  commonConfig,
  environment
} from "./chunk-P7K2QEDI.js";
import {
  AsyncPipe,
  BehaviorSubject,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  CommonModule,
  Component,
  ComponentRef$1,
  ContentChildren,
  DOCUMENT,
  DestroyRef,
  Directive,
  DomSanitizer,
  ElementRef,
  EventEmitter,
  Inject,
  Injectable,
  InjectionToken,
  Injector,
  Input,
  InputFlags,
  NgClass,
  NgForOf,
  NgIf,
  NgModule,
  NgTemplateOutlet,
  NgZone,
  NoopNgZone,
  Observable,
  Optional,
  Output,
  PLATFORM_ID,
  Pipe,
  Renderer2,
  SecurityContext,
  Subject,
  Subscription,
  TemplateRef,
  Type,
  UpperCasePipe,
  VERSION,
  ViewChild,
  ViewChildren,
  ViewContainerRef,
  ViewEncapsulation$1,
  catchError,
  debounceTime,
  defer,
  distinctUntilChanged,
  filter,
  firstValueFrom,
  forwardRef,
  fromEvent,
  inject,
  input,
  isObservable,
  isPlatformServer,
  map,
  merge,
  mergeMap,
  of,
  setClassMetadata,
  shareReplay,
  signal,
  startWith,
  switchMap,
  take,
  tap,
  ɵsetClassDebugInfo,
  ɵɵInheritDefinitionFeature,
  ɵɵNgOnChangesFeature,
  ɵɵProvidersFeature,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵattribute,
  ɵɵclassMap,
  ɵɵclassMapInterpolate1,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵcontentQuery,
  ɵɵdefineComponent,
  ɵɵdefineDirective,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdefinePipe,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementContainer,
  ɵɵelementContainerEnd,
  ɵɵelementContainerStart,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵgetInheritedFactory,
  ɵɵinject,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵpipeBind2,
  ɵɵprojection,
  ɵɵprojectionDef,
  ɵɵproperty,
  ɵɵpropertyInterpolate,
  ɵɵpropertyInterpolate1,
  ɵɵpureFunction1,
  ɵɵpureFunction2,
  ɵɵqueryRefresh,
  ɵɵreference,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeHtml,
  ɵɵsanitizeUrl,
  ɵɵstyleProp,
  ɵɵtemplate,
  ɵɵtemplateRefExtractor,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵviewQuery
} from "./chunk-GKZIWABI.js";
import {
  __async,
  __objRest,
  __restKey,
  __spreadProps,
  __spreadValues
} from "./chunk-CVWHNZRK.js";

// node_modules/@ngx-formly/core/fesm2020/ngx-formly-core.mjs
var _c0 = ["container"];
function FormlyField_ng_template_0_Template(rf, ctx) {
}
var _c1 = ["*"];
function FormlyGroup_formly_field_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "formly-field", 1);
  }
  if (rf & 2) {
    const f_r1 = ctx.$implicit;
    \u0275\u0275property("field", f_r1);
  }
}
var _c2 = ["fieldComponent"];
function disableTreeValidityCall(form, callback) {
  const _updateTreeValidity = form._updateTreeValidity.bind(form);
  form._updateTreeValidity = () => {
  };
  callback();
  form._updateTreeValidity = _updateTreeValidity;
}
function getFieldId(formId, field, index) {
  if (field.id) {
    return field.id;
  }
  let type = field.type;
  if (!type && field.template) {
    type = "template";
  }
  if (type instanceof Type) {
    type = type.prototype.constructor.name;
  }
  return [formId, type, field.key, index].join("_");
}
function hasKey(field) {
  return !isNil(field.key) && field.key !== "" && (!Array.isArray(field.key) || field.key.length > 0);
}
function getKeyPath(field) {
  if (!hasKey(field)) {
    return [];
  }
  if (field._keyPath?.key !== field.key) {
    let path = [];
    if (typeof field.key === "string") {
      const key = field.key.indexOf("[") === -1 ? field.key : field.key.replace(/\[(\w+)\]/g, ".$1");
      path = key.indexOf(".") !== -1 ? key.split(".") : [key];
    } else if (Array.isArray(field.key)) {
      path = field.key.slice(0);
    } else {
      path = [`${field.key}`];
    }
    defineHiddenProp(field, "_keyPath", {
      key: field.key,
      path
    });
  }
  return field._keyPath.path.slice(0);
}
var FORMLY_VALIDATORS = ["required", "pattern", "minLength", "maxLength", "min", "max"];
function assignFieldValue(field, value) {
  let paths = getKeyPath(field);
  if (paths.length === 0) {
    return;
  }
  let root = field;
  while (root.parent) {
    root = root.parent;
    paths = [...getKeyPath(root), ...paths];
  }
  if (value === void 0 && field.resetOnHide) {
    const k = paths.pop();
    const m = paths.reduce((model, path) => model[path] || {}, root.model);
    delete m[k];
    return;
  }
  assignModelValue(root.model, paths, value);
}
function assignModelValue(model, paths, value) {
  for (let i = 0; i < paths.length - 1; i++) {
    const path = paths[i];
    if (!model[path] || !isObject(model[path])) {
      model[path] = /^\d+$/.test(paths[i + 1]) ? [] : {};
    }
    model = model[path];
  }
  model[paths[paths.length - 1]] = clone(value);
}
function getFieldValue(field) {
  let model = field.parent ? field.parent.model : field.model;
  for (const path of getKeyPath(field)) {
    if (!model) {
      return model;
    }
    model = model[path];
  }
  return model;
}
function reverseDeepMerge(dest, ...args) {
  args.forEach((src) => {
    for (const srcArg in src) {
      if (isNil(dest[srcArg]) || isBlankString(dest[srcArg])) {
        dest[srcArg] = clone(src[srcArg]);
      } else if (objAndSameType(dest[srcArg], src[srcArg])) {
        reverseDeepMerge(dest[srcArg], src[srcArg]);
      }
    }
  });
  return dest;
}
function isNil(value) {
  return value == null;
}
function isUndefined(value) {
  return value === void 0;
}
function isBlankString(value) {
  return value === "";
}
function isFunction(value) {
  return typeof value === "function";
}
function objAndSameType(obj1, obj2) {
  return isObject(obj1) && isObject(obj2) && Object.getPrototypeOf(obj1) === Object.getPrototypeOf(obj2) && !(Array.isArray(obj1) || Array.isArray(obj2));
}
function isObject(x) {
  return x != null && typeof x === "object";
}
function isPromise(obj) {
  return !!obj && typeof obj.then === "function";
}
function clone(value) {
  if (!isObject(value) || isObservable(value) || value instanceof TemplateRef || /* instanceof SafeHtmlImpl */
  value.changingThisBreaksApplicationSecurity || ["RegExp", "FileList", "File", "Blob"].indexOf(value.constructor.name) !== -1) {
    return value;
  }
  if (value instanceof Set) {
    return new Set(value);
  }
  if (value instanceof Map) {
    return new Map(value);
  }
  if (value instanceof Uint8Array) {
    return new Uint8Array(value);
  }
  if (value instanceof Uint16Array) {
    return new Uint16Array(value);
  }
  if (value instanceof Uint32Array) {
    return new Uint32Array(value);
  }
  if (value._isAMomentObject && isFunction(value.clone)) {
    return value.clone();
  }
  if (value instanceof AbstractControl) {
    return null;
  }
  if (value instanceof Date) {
    return new Date(value.getTime());
  }
  if (Array.isArray(value)) {
    return value.slice(0).map((v) => clone(v));
  }
  const proto = Object.getPrototypeOf(value);
  let c = Object.create(proto);
  c = Object.setPrototypeOf(c, proto);
  return Object.keys(value).reduce((newVal, prop) => {
    const propDesc = Object.getOwnPropertyDescriptor(value, prop);
    if (propDesc.get) {
      Object.defineProperty(newVal, prop, propDesc);
    } else {
      newVal[prop] = clone(value[prop]);
    }
    return newVal;
  }, c);
}
function defineHiddenProp(field, prop, defaultValue) {
  Object.defineProperty(field, prop, {
    enumerable: false,
    writable: true,
    configurable: true
  });
  field[prop] = defaultValue;
}
function observeDeep(source, paths, setFn) {
  let observers = [];
  const unsubscribe = () => {
    observers.forEach((observer2) => observer2());
    observers = [];
  };
  const observer = observe(source, paths, ({
    firstChange,
    currentValue
  }) => {
    !firstChange && setFn();
    unsubscribe();
    if (isObject(currentValue) && currentValue.constructor.name === "Object") {
      Object.keys(currentValue).forEach((prop) => {
        observers.push(observeDeep(source, [...paths, prop], setFn));
      });
    }
  });
  return () => {
    observer.unsubscribe();
    unsubscribe();
  };
}
function observe(o, paths, setFn) {
  if (!o._observers) {
    defineHiddenProp(o, "_observers", {});
  }
  let target = o;
  for (let i = 0; i < paths.length - 1; i++) {
    if (!target[paths[i]] || !isObject(target[paths[i]])) {
      target[paths[i]] = /^\d+$/.test(paths[i + 1]) ? [] : {};
    }
    target = target[paths[i]];
  }
  const key = paths[paths.length - 1];
  const prop = paths.join(".");
  if (!o._observers[prop]) {
    o._observers[prop] = {
      value: target[key],
      onChange: []
    };
  }
  const state = o._observers[prop];
  if (target[key] !== state.value) {
    state.value = target[key];
  }
  if (setFn && state.onChange.indexOf(setFn) === -1) {
    state.onChange.push(setFn);
    setFn({
      currentValue: state.value,
      firstChange: true
    });
    if (state.onChange.length >= 1 && isObject(target)) {
      const {
        enumerable
      } = Object.getOwnPropertyDescriptor(target, key) || {
        enumerable: true
      };
      Object.defineProperty(target, key, {
        enumerable,
        configurable: true,
        get: () => state.value,
        set: (currentValue) => {
          if (currentValue !== state.value) {
            const previousValue = state.value;
            state.value = currentValue;
            state.onChange.forEach((changeFn) => changeFn({
              previousValue,
              currentValue,
              firstChange: false
            }));
          }
        }
      });
    }
  }
  return {
    setValue(currentValue, emitEvent = true) {
      if (currentValue === state.value) {
        return;
      }
      const previousValue = state.value;
      state.value = currentValue;
      state.onChange.forEach((changeFn) => {
        if (changeFn !== setFn && emitEvent) {
          changeFn({
            previousValue,
            currentValue,
            firstChange: false
          });
        }
      });
    },
    unsubscribe() {
      state.onChange = state.onChange.filter((changeFn) => changeFn !== setFn);
      if (state.onChange.length === 0) {
        delete o._observers[prop];
      }
    }
  };
}
function getField(f, key) {
  key = Array.isArray(key) ? key.join(".") : key;
  if (!f.fieldGroup) {
    return void 0;
  }
  for (let i = 0, len = f.fieldGroup.length; i < len; i++) {
    const c = f.fieldGroup[i];
    const k = Array.isArray(c.key) ? c.key.join(".") : c.key;
    if (k === key) {
      return c;
    }
    if (c.fieldGroup && (isNil(k) || key.indexOf(`${k}.`) === 0)) {
      const field = getField(c, isNil(k) ? key : key.slice(k.length + 1));
      if (field) {
        return field;
      }
    }
  }
  return void 0;
}
function markFieldForCheck(field) {
  field._componentRefs?.forEach((ref) => {
    if (ref instanceof ComponentRef$1) {
      const changeDetectorRef = ref.injector.get(ChangeDetectorRef);
      changeDetectorRef.markForCheck();
    } else {
      ref.markForCheck();
    }
  });
}
function isNoopNgZone(ngZone) {
  return ngZone instanceof NoopNgZone;
}
function isHiddenField(field) {
  const isHidden = (f) => f.hide || f.expressions?.hide || f.hideExpression;
  let setDefaultValue = !field.resetOnHide || !isHidden(field);
  if (!isHidden(field) && field.resetOnHide) {
    let parent = field.parent;
    while (parent && !isHidden(parent)) {
      parent = parent.parent;
    }
    setDefaultValue = !parent || !isHidden(parent);
  }
  return !setDefaultValue;
}
var FORMLY_CONFIG = new InjectionToken("FORMLY_CONFIG");
var FormlyConfig = class {
  constructor() {
    this.types = {};
    this.validators = {};
    this.wrappers = {};
    this.messages = {};
    this.extras = {
      checkExpressionOn: "modelChange",
      lazyRender: true,
      resetFieldOnHide: true,
      renderFormlyFieldElement: true,
      showError(field) {
        return field.formControl?.invalid && (field.formControl?.touched || field.options.parentForm?.submitted || !!field.field.validation?.show);
      }
    };
    this.extensions = {};
    this.presets = {};
    this.extensionsByPriority = {};
  }
  addConfig(config) {
    if (config.types) {
      config.types.forEach((type) => this.setType(type));
    }
    if (config.validators) {
      config.validators.forEach((validator) => this.setValidator(validator));
    }
    if (config.wrappers) {
      config.wrappers.forEach((wrapper) => this.setWrapper(wrapper));
    }
    if (config.validationMessages) {
      config.validationMessages.forEach((validation) => this.addValidatorMessage(validation.name, validation.message));
    }
    if (config.extensions) {
      this.setSortedExtensions(config.extensions);
    }
    if (config.extras) {
      this.extras = __spreadValues(__spreadValues({}, this.extras), config.extras);
    }
    if (config.presets) {
      this.presets = __spreadValues(__spreadValues({}, this.presets), config.presets.reduce((acc, curr) => __spreadProps(__spreadValues({}, acc), {
        [curr.name]: curr.config
      }), {}));
    }
  }
  /**
   * Allows you to specify a custom type which you can use in your field configuration.
   * You can pass an object of options, or an array of objects of options.
   */
  setType(options) {
    if (Array.isArray(options)) {
      options.forEach((option) => this.setType(option));
    } else {
      if (!this.types[options.name]) {
        this.types[options.name] = {
          name: options.name
        };
      }
      ["component", "extends", "defaultOptions", "wrappers"].forEach((prop) => {
        if (options.hasOwnProperty(prop)) {
          this.types[options.name][prop] = options[prop];
        }
      });
    }
  }
  getType(name, throwIfNotFound = false) {
    if (name instanceof Type) {
      return {
        component: name,
        name: name.prototype.constructor.name
      };
    }
    if (!this.types[name]) {
      if (throwIfNotFound) {
        throw new Error(`[Formly Error] The type "${name}" could not be found. Please make sure that is registered through the FormlyModule declaration.`);
      }
      return null;
    }
    this.mergeExtendedType(name);
    return this.types[name];
  }
  /** @ignore */
  getMergedField(field = {}) {
    const type = this.getType(field.type);
    if (!type) {
      return;
    }
    if (type.defaultOptions) {
      reverseDeepMerge(field, type.defaultOptions);
    }
    const extendDefaults = type.extends && this.getType(type.extends).defaultOptions;
    if (extendDefaults) {
      reverseDeepMerge(field, extendDefaults);
    }
    if (field?.optionsTypes) {
      field.optionsTypes.forEach((option) => {
        const defaultOptions = this.getType(option).defaultOptions;
        if (defaultOptions) {
          reverseDeepMerge(field, defaultOptions);
        }
      });
    }
    const componentRef = this.resolveFieldTypeRef(field);
    if (componentRef?.instance?.defaultOptions) {
      reverseDeepMerge(field, componentRef.instance.defaultOptions);
    }
    if (!field.wrappers && type.wrappers) {
      field.wrappers = [...type.wrappers];
    }
  }
  /** @ignore @internal */
  resolveFieldTypeRef(field = {}) {
    const type = this.getType(field.type);
    if (!type) {
      return null;
    }
    if (!type.component || type._componentRef) {
      return type._componentRef;
    }
    const {
      _viewContainerRef,
      _injector
    } = field.options;
    if (!_viewContainerRef || !_injector) {
      return null;
    }
    const componentRef = _viewContainerRef.createComponent(type.component, {
      injector: _injector
    });
    defineHiddenProp(type, "_componentRef", componentRef);
    try {
      componentRef.destroy();
    } catch (e) {
      console.error(`An error occurred while destroying the Formly component type "${field.type}"`, e);
    }
    return type._componentRef;
  }
  setWrapper(options) {
    this.wrappers[options.name] = options;
    if (options.types) {
      options.types.forEach((type) => {
        this.setTypeWrapper(type, options.name);
      });
    }
  }
  getWrapper(name) {
    if (name instanceof Type) {
      return {
        component: name,
        name: name.prototype.constructor.name
      };
    }
    if (!this.wrappers[name]) {
      throw new Error(`[Formly Error] The wrapper "${name}" could not be found. Please make sure that is registered through the FormlyModule declaration.`);
    }
    return this.wrappers[name];
  }
  /** @ignore */
  setTypeWrapper(type, name) {
    if (!this.types[type]) {
      this.types[type] = {};
    }
    if (!this.types[type].wrappers) {
      this.types[type].wrappers = [];
    }
    if (this.types[type].wrappers.indexOf(name) === -1) {
      this.types[type].wrappers.push(name);
    }
  }
  setValidator(options) {
    this.validators[options.name] = options;
  }
  getValidator(name) {
    if (!this.validators[name]) {
      throw new Error(`[Formly Error] The validator "${name}" could not be found. Please make sure that is registered through the FormlyModule declaration.`);
    }
    return this.validators[name];
  }
  addValidatorMessage(name, message) {
    this.messages[name] = message;
    if (typeof ngDevMode === "undefined" || ngDevMode) {
      const deprecated = {
        minlength: "minLength",
        maxlength: "maxLength"
      };
      if (deprecated[name]) {
        console.warn(`Formly deprecation: passing validation messages key '${name}' is deprecated since v6.0, use '${deprecated[name]}' instead.`);
        this.messages[deprecated[name]] = message;
      }
    }
  }
  getValidatorMessage(name) {
    return this.messages[name];
  }
  setSortedExtensions(extensionOptions) {
    extensionOptions.forEach((extensionOption) => {
      const priority = extensionOption.priority ?? 1;
      this.extensionsByPriority[priority] = __spreadProps(__spreadValues({}, this.extensionsByPriority[priority]), {
        [extensionOption.name]: extensionOption.extension
      });
    });
    this.extensions = Object.keys(this.extensionsByPriority).map(Number).sort((a, b) => a - b).reduce((acc, prio) => __spreadValues(__spreadValues({}, acc), this.extensionsByPriority[prio]), {});
  }
  mergeExtendedType(name) {
    if (!this.types[name].extends) {
      return;
    }
    const extendedType = this.getType(this.types[name].extends);
    if (!this.types[name].component) {
      this.types[name].component = extendedType.component;
    }
    if (!this.types[name].wrappers) {
      this.types[name].wrappers = extendedType.wrappers;
    }
  }
};
FormlyConfig.\u0275fac = function FormlyConfig_Factory(t) {
  return new (t || FormlyConfig)();
};
FormlyConfig.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({
  token: FormlyConfig,
  factory: FormlyConfig.\u0275fac,
  providedIn: "root"
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyConfig, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], null, null);
})();
var FormlyFormBuilder = class {
  constructor(config, injector, viewContainerRef, parentForm) {
    this.config = config;
    this.injector = injector;
    this.viewContainerRef = viewContainerRef;
    this.parentForm = parentForm;
  }
  buildForm(form, fieldGroup = [], model, options) {
    this.build({
      fieldGroup,
      model,
      form,
      options
    });
  }
  build(field) {
    if (!this.config.extensions.core) {
      throw new Error("NgxFormly: missing `forRoot()` call. use `forRoot()` when registering the `FormlyModule`.");
    }
    if (!field.parent) {
      this._setOptions(field);
    }
    disableTreeValidityCall(field.form, () => {
      this._build(field);
      if (!field.parent || field.fieldArray) {
        const options = field.options;
        if (field.parent && isHiddenField(field)) {
          options._hiddenFieldsForCheck?.push(field);
        }
        options.checkExpressions?.(field, true);
        options._detectChanges?.(field);
      }
    });
  }
  _build(field) {
    if (!field) {
      return;
    }
    const extensions = Object.values(this.config.extensions);
    extensions.forEach((extension) => extension.prePopulate?.(field));
    extensions.forEach((extension) => extension.onPopulate?.(field));
    field.fieldGroup?.forEach((f) => this._build(f));
    extensions.forEach((extension) => extension.postPopulate?.(field));
  }
  _setOptions(field) {
    field.form = field.form || new FormGroup({});
    field.model = field.model || {};
    field.options = field.options || {};
    const options = field.options;
    if (!options._viewContainerRef) {
      defineHiddenProp(options, "_viewContainerRef", this.viewContainerRef);
    }
    if (!options._injector) {
      defineHiddenProp(options, "_injector", this.injector);
    }
    if (!options.build) {
      options._buildForm = () => {
        console.warn(`Formly: 'options._buildForm' is deprecated since v6.0, use 'options.build' instead.`);
        this.build(field);
      };
      options.build = (f = field) => {
        this.build(f);
        return f;
      };
    }
    if (!options.parentForm && this.parentForm) {
      defineHiddenProp(options, "parentForm", this.parentForm);
      observe(options, ["parentForm", "submitted"], ({
        firstChange
      }) => {
        if (!firstChange) {
          options.detectChanges(field);
        }
      });
    }
  }
};
FormlyFormBuilder.\u0275fac = function FormlyFormBuilder_Factory(t) {
  return new (t || FormlyFormBuilder)(\u0275\u0275inject(FormlyConfig), \u0275\u0275inject(Injector), \u0275\u0275inject(ViewContainerRef, 8), \u0275\u0275inject(FormGroupDirective, 8));
};
FormlyFormBuilder.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({
  token: FormlyFormBuilder,
  factory: FormlyFormBuilder.\u0275fac,
  providedIn: "root"
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyFormBuilder, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], function() {
    return [{
      type: FormlyConfig
    }, {
      type: Injector
    }, {
      type: ViewContainerRef,
      decorators: [{
        type: Optional
      }]
    }, {
      type: FormGroupDirective,
      decorators: [{
        type: Optional
      }]
    }];
  }, null);
})();
function unregisterControl(field, emitEvent = false) {
  const control = field.formControl;
  const fieldIndex = control._fields ? control._fields.indexOf(field) : -1;
  if (fieldIndex !== -1) {
    control._fields.splice(fieldIndex, 1);
  }
  const form = control.parent;
  if (!form) {
    return;
  }
  const opts = {
    emitEvent
  };
  if (form instanceof FormArray) {
    const key = form.controls.findIndex((c) => c === control);
    if (key !== -1) {
      form.removeAt(key, opts);
    }
  } else if (form instanceof FormGroup) {
    const paths = getKeyPath(field);
    const key = paths[paths.length - 1];
    if (form.get([key]) === control) {
      form.removeControl(key, opts);
    }
  }
  control.setParent(null);
}
function findControl(field) {
  if (field.formControl) {
    return field.formControl;
  }
  if (field.shareFormControl === false) {
    return null;
  }
  return field.form?.get(getKeyPath(field));
}
function registerControl(field, control, emitEvent = false) {
  control = control || field.formControl;
  if (!control._fields) {
    defineHiddenProp(control, "_fields", []);
  }
  if (control._fields.indexOf(field) === -1) {
    control._fields.push(field);
  }
  if (!field.formControl && control) {
    defineHiddenProp(field, "formControl", control);
    control.setValidators(null);
    control.setAsyncValidators(null);
    field.props.disabled = !!field.props.disabled;
    const disabledObserver = observe(field, ["props", "disabled"], ({
      firstChange,
      currentValue
    }) => {
      if (!firstChange) {
        currentValue ? field.formControl.disable() : field.formControl.enable();
      }
    });
    if (control instanceof FormControl) {
      control.registerOnDisabledChange(disabledObserver.setValue);
    }
  }
  if (!field.form || !hasKey(field)) {
    return;
  }
  let form = field.form;
  const paths = getKeyPath(field);
  const value = getFieldValue(field);
  if (!(isNil(control.value) && isNil(value)) && control.value !== value && control instanceof FormControl) {
    control.patchValue(value);
  }
  for (let i = 0; i < paths.length - 1; i++) {
    const path = paths[i];
    if (!form.get([path])) {
      form.setControl(path, new FormGroup({}), {
        emitEvent
      });
    }
    form = form.get([path]);
  }
  const key = paths[paths.length - 1];
  if (!field._hide && form.get([key]) !== control) {
    form.setControl(key, control, {
      emitEvent
    });
  }
}
function updateValidity(c, onlySelf = false) {
  const status = c.status;
  const value = c.value;
  c.updateValueAndValidity({
    emitEvent: false,
    onlySelf
  });
  if (status !== c.status) {
    c.statusChanges.emit(c.status);
  }
  if (value !== c.value) {
    c.valueChanges.emit(c.value);
  }
}
function clearControl(form) {
  delete form?._fields;
  form.setValidators(null);
  form.setAsyncValidators(null);
  if (form instanceof FormGroup || form instanceof FormArray) {
    Object.values(form.controls).forEach((c) => clearControl(c));
  }
}
var FormlyTemplate = class {
  constructor(ref) {
    this.ref = ref;
  }
  ngOnChanges() {
    this.name = this.name || "formly-group";
  }
};
FormlyTemplate.\u0275fac = function FormlyTemplate_Factory(t) {
  return new (t || FormlyTemplate)(\u0275\u0275directiveInject(TemplateRef));
};
FormlyTemplate.\u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
  type: FormlyTemplate,
  selectors: [["", "formlyTemplate", ""]],
  inputs: {
    name: [InputFlags.None, "formlyTemplate", "name"]
  },
  features: [\u0275\u0275NgOnChangesFeature]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyTemplate, [{
    type: Directive,
    args: [{
      selector: "[formlyTemplate]"
    }]
  }], function() {
    return [{
      type: TemplateRef
    }];
  }, {
    name: [{
      type: Input,
      args: ["formlyTemplate"]
    }]
  });
})();
var FormlyFieldTemplates = class {
};
FormlyFieldTemplates.\u0275fac = function FormlyFieldTemplates_Factory(t) {
  return new (t || FormlyFieldTemplates)();
};
FormlyFieldTemplates.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({
  token: FormlyFieldTemplates,
  factory: FormlyFieldTemplates.\u0275fac
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyFieldTemplates, [{
    type: Injectable
  }], null, null);
})();
var FormlyField = class {
  constructor(config, renderer, _elementRef, hostContainerRef, form) {
    this.config = config;
    this.renderer = renderer;
    this._elementRef = _elementRef;
    this.hostContainerRef = hostContainerRef;
    this.form = form;
    this.hostObservers = [];
    this.componentRefs = [];
    this.hooksObservers = [];
    this.detectFieldBuild = false;
    this.valueChangesUnsubscribe = () => {
    };
  }
  get containerRef() {
    return this.config.extras.renderFormlyFieldElement ? this.viewContainerRef : this.hostContainerRef;
  }
  get elementRef() {
    if (this.config.extras.renderFormlyFieldElement) {
      return this._elementRef;
    }
    if (this.componentRefs?.[0] instanceof ComponentRef$1) {
      return this.componentRefs[0].location;
    }
    return null;
  }
  ngAfterContentInit() {
    this.triggerHook("afterContentInit");
  }
  ngAfterViewInit() {
    this.triggerHook("afterViewInit");
  }
  ngDoCheck() {
    if (this.detectFieldBuild && this.field && this.field.options) {
      this.render();
    }
  }
  ngOnInit() {
    this.triggerHook("onInit");
  }
  ngOnChanges(changes) {
    this.triggerHook("onChanges", changes);
  }
  ngOnDestroy() {
    this.resetRefs(this.field);
    this.hostObservers.forEach((hostObserver) => hostObserver.unsubscribe());
    this.hooksObservers.forEach((unsubscribe) => unsubscribe());
    this.valueChangesUnsubscribe();
    this.triggerHook("onDestroy");
  }
  renderField(containerRef, f, wrappers = []) {
    if (this.containerRef === containerRef) {
      this.resetRefs(this.field);
      this.containerRef.clear();
      wrappers = this.field?.wrappers;
    }
    if (wrappers?.length > 0) {
      const [wrapper, ...wps] = wrappers;
      const {
        component
      } = this.config.getWrapper(wrapper);
      const ref = containerRef.createComponent(component);
      this.attachComponentRef(ref, f);
      observe(ref.instance, ["fieldComponent"], ({
        currentValue,
        previousValue,
        firstChange
      }) => {
        if (currentValue) {
          if (previousValue && previousValue._lContainer === currentValue._lContainer) {
            return;
          }
          const viewRef = previousValue ? previousValue.detach() : null;
          if (viewRef && !viewRef.destroyed) {
            currentValue.insert(viewRef);
          } else {
            this.renderField(currentValue, f, wps);
          }
          !firstChange && ref.changeDetectorRef.detectChanges();
        }
      });
    } else if (f?.type) {
      const inlineType = this.form?.templates?.find((ref2) => ref2.name === f.type);
      let ref;
      if (inlineType) {
        ref = containerRef.createEmbeddedView(inlineType.ref, {
          $implicit: f
        });
      } else {
        const {
          component
        } = this.config.getType(f.type, true);
        ref = containerRef.createComponent(component);
      }
      this.attachComponentRef(ref, f);
    }
  }
  triggerHook(name, changes) {
    if (name === "onInit" || name === "onChanges" && changes.field && !changes.field.firstChange) {
      this.valueChangesUnsubscribe();
      this.valueChangesUnsubscribe = this.fieldChanges(this.field);
    }
    if (this.field?.hooks?.[name]) {
      if (!changes || changes.field) {
        const r = this.field.hooks[name](this.field);
        if (isObservable(r) && ["onInit", "afterContentInit", "afterViewInit"].indexOf(name) !== -1) {
          const sub = r.subscribe();
          this.hooksObservers.push(() => sub.unsubscribe());
        }
      }
    }
    if (name === "onChanges" && changes.field) {
      this.resetRefs(changes.field.previousValue);
      this.render();
    }
  }
  attachComponentRef(ref, field) {
    this.componentRefs.push(ref);
    field._componentRefs.push(ref);
    if (ref instanceof ComponentRef$1) {
      Object.assign(ref.instance, {
        field
      });
    }
  }
  render() {
    if (!this.field) {
      return;
    }
    if (!this.field.options) {
      this.detectFieldBuild = true;
      return;
    }
    this.detectFieldBuild = false;
    this.hostObservers.forEach((hostObserver) => hostObserver.unsubscribe());
    this.hostObservers = [observe(this.field, ["hide"], ({
      firstChange,
      currentValue
    }) => {
      const containerRef = this.containerRef;
      if (this.config.extras.lazyRender === false) {
        firstChange && this.renderField(containerRef, this.field);
        if (!firstChange || firstChange && currentValue) {
          this.elementRef && this.renderer.setStyle(this.elementRef.nativeElement, "display", currentValue ? "none" : "");
        }
      } else {
        if (currentValue) {
          containerRef.clear();
          if (this.field.className) {
            this.renderer.removeAttribute(this.elementRef.nativeElement, "class");
          }
        } else {
          this.renderField(containerRef, this.field);
          if (this.field.className) {
            this.renderer.setAttribute(this.elementRef.nativeElement, "class", this.field.className);
          }
        }
      }
      !firstChange && this.field.options.detectChanges(this.field);
    }), observe(this.field, ["className"], ({
      firstChange,
      currentValue
    }) => {
      if ((!firstChange || firstChange && currentValue) && (!this.config.extras.lazyRender || this.field.hide !== true)) {
        this.elementRef && this.renderer.setAttribute(this.elementRef.nativeElement, "class", currentValue);
      }
    })];
    const isSignalRequired = +VERSION.major >= 18 && +VERSION.minor >= 1;
    if (!isSignalRequired) {
      ["touched", "pristine", "status"].forEach((prop) => this.hostObservers.push(observe(this.field, ["formControl", prop], ({
        firstChange
      }) => !firstChange && markFieldForCheck(this.field))));
    } else if (this.field.formControl) {
      const statusChanges = this.field.formControl.statusChanges.pipe(distinctUntilChanged()).subscribe(() => markFieldForCheck(this.field));
      this.hostObservers.push(statusChanges);
    }
  }
  resetRefs(field) {
    if (field) {
      if (field._localFields) {
        field._localFields = [];
      } else {
        defineHiddenProp(this.field, "_localFields", []);
      }
      if (field._componentRefs) {
        field._componentRefs = field._componentRefs.filter((ref) => this.componentRefs.indexOf(ref) === -1);
      } else {
        defineHiddenProp(this.field, "_componentRefs", []);
      }
    }
    this.componentRefs = [];
  }
  fieldChanges(field) {
    if (!field) {
      return () => {
      };
    }
    const subscribes = [observeDeep(field, ["props"], () => field.options.detectChanges(field))];
    if (field.options) {
      subscribes.push(observeDeep(field.options, ["formState"], () => field.options.detectChanges(field)));
    }
    for (const key of Object.keys(field._expressions || {})) {
      const expressionObserver = observe(field, ["_expressions", key], ({
        currentValue,
        previousValue
      }) => {
        if (previousValue?.subscription) {
          previousValue.subscription.unsubscribe();
          previousValue.subscription = null;
        }
        if (isObservable(currentValue.value$)) {
          currentValue.subscription = currentValue.value$.subscribe();
        }
      });
      subscribes.push(() => {
        if (field._expressions[key]?.subscription) {
          field._expressions[key].subscription.unsubscribe();
        }
        expressionObserver.unsubscribe();
      });
    }
    for (const path of [["focus"], ["template"], ["fieldGroupClassName"], ["validation", "show"]]) {
      const fieldObserver = observe(field, path, ({
        firstChange
      }) => !firstChange && field.options.detectChanges(field));
      subscribes.push(() => fieldObserver.unsubscribe());
    }
    if (field.formControl && !field.fieldGroup) {
      const control = field.formControl;
      let valueChanges = control.valueChanges.pipe(map((value) => {
        field.parsers?.map((parserFn) => value = parserFn(value, field));
        if (!Object.is(value, field.formControl.value)) {
          field.formControl.setValue(value);
        }
        return value;
      }), distinctUntilChanged((x, y) => {
        if (x !== y || Array.isArray(x) || isObject(x)) {
          return false;
        }
        return true;
      }));
      if (control.value !== getFieldValue(field)) {
        valueChanges = valueChanges.pipe(startWith(control.value));
      }
      const {
        updateOn,
        debounce
      } = field.modelOptions;
      if ((!updateOn || updateOn === "change") && debounce?.default > 0) {
        valueChanges = control.valueChanges.pipe(debounceTime(debounce.default));
      }
      const sub = valueChanges.subscribe((value) => {
        if (control._fields?.length > 1 && control instanceof FormControl) {
          control.patchValue(value, {
            emitEvent: false,
            onlySelf: true
          });
        }
        if (hasKey(field)) {
          assignFieldValue(field, value);
        }
        field.options.fieldChanges.next({
          value,
          field,
          type: "valueChanges"
        });
      });
      subscribes.push(() => sub.unsubscribe());
    }
    let templateFieldsSubs = [];
    observe(field, ["_localFields"], ({
      currentValue
    }) => {
      templateFieldsSubs.forEach((unsubscribe) => unsubscribe());
      templateFieldsSubs = (currentValue || []).map((f) => this.fieldChanges(f));
    });
    return () => {
      subscribes.forEach((unsubscribe) => unsubscribe());
      templateFieldsSubs.forEach((unsubscribe) => unsubscribe());
    };
  }
};
FormlyField.\u0275fac = function FormlyField_Factory(t) {
  return new (t || FormlyField)(\u0275\u0275directiveInject(FormlyConfig), \u0275\u0275directiveInject(Renderer2), \u0275\u0275directiveInject(ElementRef), \u0275\u0275directiveInject(ViewContainerRef), \u0275\u0275directiveInject(FormlyFieldTemplates, 8));
};
FormlyField.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyField,
  selectors: [["formly-field"]],
  viewQuery: function FormlyField_Query(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275viewQuery(_c0, 7, ViewContainerRef);
    }
    if (rf & 2) {
      let _t;
      \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.viewContainerRef = _t.first);
    }
  },
  inputs: {
    field: "field"
  },
  features: [\u0275\u0275NgOnChangesFeature],
  decls: 2,
  vars: 0,
  consts: [["container", ""]],
  template: function FormlyField_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyField_ng_template_0_Template, 0, 0, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    }
  },
  styles: ["[_nghost-%COMP%]:empty{display:none}"]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyField, [{
    type: Component,
    args: [{
      selector: "formly-field",
      template: "<ng-template #container></ng-template>",
      styles: [":host:empty{display:none}\n"]
    }]
  }], function() {
    return [{
      type: FormlyConfig
    }, {
      type: Renderer2
    }, {
      type: ElementRef
    }, {
      type: ViewContainerRef
    }, {
      type: FormlyFieldTemplates,
      decorators: [{
        type: Optional
      }]
    }];
  }, {
    field: [{
      type: Input
    }],
    viewContainerRef: [{
      type: ViewChild,
      args: ["container", {
        read: ViewContainerRef,
        static: true
      }]
    }]
  });
})();
var FormlyForm = class {
  constructor(builder, config, ngZone, fieldTemplates) {
    this.builder = builder;
    this.config = config;
    this.ngZone = ngZone;
    this.fieldTemplates = fieldTemplates;
    this.modelChange = new EventEmitter();
    this.field = {
      type: "formly-group"
    };
    this._modelChangeValue = {};
    this.valueChangesUnsubscribe = () => {
    };
  }
  /** The form instance which allow to track model value and validation status. */
  set form(form) {
    this.field.form = form;
  }
  get form() {
    return this.field.form;
  }
  /** The model to be represented by the form. */
  set model(model) {
    if (this.config.extras.immutable && this._modelChangeValue === model) {
      return;
    }
    this.setField({
      model
    });
  }
  get model() {
    return this.field.model;
  }
  /** The field configurations for building the form. */
  set fields(fieldGroup) {
    this.setField({
      fieldGroup
    });
  }
  get fields() {
    return this.field.fieldGroup;
  }
  /** Options for the form. */
  set options(options) {
    this.setField({
      options
    });
  }
  get options() {
    return this.field.options;
  }
  set templates(templates) {
    this.fieldTemplates.templates = templates;
  }
  ngDoCheck() {
    if (this.config.extras.checkExpressionOn === "changeDetectionCheck") {
      this.checkExpressionChange();
    }
  }
  ngOnChanges(changes) {
    if (changes.fields && this.form) {
      clearControl(this.form);
    }
    if (changes.fields || changes.form || changes.model && this._modelChangeValue !== changes.model.currentValue) {
      this.valueChangesUnsubscribe();
      this.builder.build(this.field);
      this.valueChangesUnsubscribe = this.valueChanges();
    }
  }
  ngOnDestroy() {
    this.valueChangesUnsubscribe();
  }
  checkExpressionChange() {
    this.field.options.checkExpressions?.(this.field);
  }
  valueChanges() {
    this.valueChangesUnsubscribe();
    const sub = this.field.options.fieldChanges.pipe(filter(({
      field,
      type
    }) => hasKey(field) && type === "valueChanges"), switchMap(() => isNoopNgZone(this.ngZone) ? of(null) : this.ngZone.onStable.asObservable().pipe(take(1)))).subscribe(() => this.ngZone.runGuarded(() => {
      this.checkExpressionChange();
      this.modelChange.emit(this._modelChangeValue = clone(this.model));
    }));
    return () => sub.unsubscribe();
  }
  setField(field) {
    if (this.config.extras.immutable) {
      this.field = __spreadValues(__spreadValues({}, this.field), clone(field));
    } else {
      Object.keys(field).forEach((p) => this.field[p] = field[p]);
    }
  }
};
FormlyForm.\u0275fac = function FormlyForm_Factory(t) {
  return new (t || FormlyForm)(\u0275\u0275directiveInject(FormlyFormBuilder), \u0275\u0275directiveInject(FormlyConfig), \u0275\u0275directiveInject(NgZone), \u0275\u0275directiveInject(FormlyFieldTemplates));
};
FormlyForm.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyForm,
  selectors: [["formly-form"]],
  contentQueries: function FormlyForm_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      \u0275\u0275contentQuery(dirIndex, FormlyTemplate, 4);
    }
    if (rf & 2) {
      let _t;
      \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.templates = _t);
    }
  },
  inputs: {
    form: "form",
    model: "model",
    fields: "fields",
    options: "options"
  },
  outputs: {
    modelChange: "modelChange"
  },
  features: [\u0275\u0275ProvidersFeature([FormlyFormBuilder, FormlyFieldTemplates]), \u0275\u0275NgOnChangesFeature],
  decls: 1,
  vars: 1,
  consts: [[3, "field"]],
  template: function FormlyForm_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275element(0, "formly-field", 0);
    }
    if (rf & 2) {
      \u0275\u0275property("field", ctx.field);
    }
  },
  dependencies: [FormlyField],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyForm, [{
    type: Component,
    args: [{
      selector: "formly-form",
      template: '<formly-field [field]="field"></formly-field>',
      providers: [FormlyFormBuilder, FormlyFieldTemplates],
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], function() {
    return [{
      type: FormlyFormBuilder
    }, {
      type: FormlyConfig
    }, {
      type: NgZone
    }, {
      type: FormlyFieldTemplates
    }];
  }, {
    form: [{
      type: Input
    }],
    model: [{
      type: Input
    }],
    fields: [{
      type: Input
    }],
    options: [{
      type: Input
    }],
    modelChange: [{
      type: Output
    }],
    templates: [{
      type: ContentChildren,
      args: [FormlyTemplate]
    }]
  });
})();
var FormlyAttributes = class {
  constructor(renderer, elementRef, _document) {
    this.renderer = renderer;
    this.elementRef = elementRef;
    this.uiAttributesCache = {};
    this.uiEvents = {
      listeners: [],
      events: ["click", "keyup", "keydown", "keypress", "focus", "blur", "change"],
      callback: (eventName, $event) => {
        switch (eventName) {
          case "focus":
            return this.onFocus($event);
          case "blur":
            return this.onBlur($event);
          case "change":
            return this.onChange($event);
          default:
            return this.props[eventName](this.field, $event);
        }
      }
    };
    this.document = _document;
  }
  get props() {
    return this.field.props || {};
  }
  get fieldAttrElements() {
    return this.field?.["_elementRefs"] || [];
  }
  ngOnChanges(changes) {
    if (changes.field) {
      this.field.name && this.setAttribute("name", this.field.name);
      this.uiEvents.listeners.forEach((listener) => listener());
      this.uiEvents.events.forEach((eventName) => {
        if (this.props?.[eventName] || ["focus", "blur", "change"].indexOf(eventName) !== -1) {
          this.uiEvents.listeners.push(this.renderer.listen(this.elementRef.nativeElement, eventName, (e) => this.uiEvents.callback(eventName, e)));
        }
      });
      if (this.props?.attributes) {
        observe(this.field, ["props", "attributes"], ({
          currentValue,
          previousValue
        }) => {
          if (previousValue) {
            Object.keys(previousValue).forEach((attr) => this.removeAttribute(attr));
          }
          if (currentValue) {
            Object.keys(currentValue).forEach((attr) => {
              if (currentValue[attr] != null) {
                this.setAttribute(attr, currentValue[attr]);
              }
            });
          }
        });
      }
      this.detachElementRef(changes.field.previousValue);
      this.attachElementRef(changes.field.currentValue);
      if (this.fieldAttrElements.length === 1) {
        !this.id && this.field.id && this.setAttribute("id", this.field.id);
        this.focusObserver = observe(this.field, ["focus"], ({
          currentValue
        }) => {
          this.toggleFocus(currentValue);
        });
      }
    }
    if (changes.id) {
      this.setAttribute("id", this.id);
    }
  }
  /**
   * We need to re-evaluate all the attributes on every change detection cycle, because
   * by using a HostBinding we run into certain edge cases. This means that whatever logic
   * is in here has to be super lean or we risk seriously damaging or destroying the performance.
   *
   * Formly issue: https://github.com/ngx-formly/ngx-formly/issues/1317
   * Material issue: https://github.com/angular/components/issues/14024
   */
  ngDoCheck() {
    if (!this.uiAttributes) {
      const element = this.elementRef.nativeElement;
      this.uiAttributes = [...FORMLY_VALIDATORS, "tabindex", "placeholder", "readonly", "disabled", "step"].filter((attr) => !element.hasAttribute || !element.hasAttribute(attr));
    }
    for (let i = 0; i < this.uiAttributes.length; i++) {
      const attr = this.uiAttributes[i];
      const value = this.props[attr];
      if (this.uiAttributesCache[attr] !== value && (!this.props.attributes || !this.props.attributes.hasOwnProperty(attr.toLowerCase()))) {
        this.uiAttributesCache[attr] = value;
        if (value || value === 0) {
          this.setAttribute(attr, value === true ? attr : `${value}`);
        } else {
          this.removeAttribute(attr);
        }
      }
    }
  }
  ngOnDestroy() {
    this.uiEvents.listeners.forEach((listener) => listener());
    this.detachElementRef(this.field);
    this.focusObserver?.unsubscribe();
  }
  toggleFocus(value) {
    const element = this.fieldAttrElements ? this.fieldAttrElements[0] : null;
    if (!element || !element.nativeElement.focus) {
      return;
    }
    const isFocused = !!this.document.activeElement && this.fieldAttrElements.some(({
      nativeElement
    }) => this.document.activeElement === nativeElement || nativeElement.contains(this.document.activeElement));
    if (value && !isFocused) {
      Promise.resolve().then(() => element.nativeElement.focus());
    } else if (!value && isFocused) {
      Promise.resolve().then(() => element.nativeElement.blur());
    }
  }
  onFocus($event) {
    this.focusObserver?.setValue(true);
    this.props.focus?.(this.field, $event);
  }
  onBlur($event) {
    this.focusObserver?.setValue(false);
    this.props.blur?.(this.field, $event);
  }
  // handle custom `change` event, for regular ones rely on DOM listener
  onHostChange($event) {
    if ($event instanceof Event) {
      return;
    }
    this.onChange($event);
  }
  onChange($event) {
    this.props.change?.(this.field, $event);
    this.field.formControl?.markAsDirty();
  }
  attachElementRef(f) {
    if (!f) {
      return;
    }
    if (f["_elementRefs"]?.indexOf(this.elementRef) === -1) {
      f["_elementRefs"].push(this.elementRef);
    } else {
      defineHiddenProp(f, "_elementRefs", [this.elementRef]);
    }
  }
  detachElementRef(f) {
    const index = f?.["_elementRefs"] ? this.fieldAttrElements.indexOf(this.elementRef) : -1;
    if (index !== -1) {
      f["_elementRefs"].splice(index, 1);
    }
  }
  setAttribute(attr, value) {
    this.renderer.setAttribute(this.elementRef.nativeElement, attr, value);
  }
  removeAttribute(attr) {
    this.renderer.removeAttribute(this.elementRef.nativeElement, attr);
  }
};
FormlyAttributes.\u0275fac = function FormlyAttributes_Factory(t) {
  return new (t || FormlyAttributes)(\u0275\u0275directiveInject(Renderer2), \u0275\u0275directiveInject(ElementRef), \u0275\u0275directiveInject(DOCUMENT));
};
FormlyAttributes.\u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
  type: FormlyAttributes,
  selectors: [["", "formlyAttributes", ""]],
  hostBindings: function FormlyAttributes_HostBindings(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275listener("change", function FormlyAttributes_change_HostBindingHandler($event) {
        return ctx.onHostChange($event);
      });
    }
  },
  inputs: {
    field: [InputFlags.None, "formlyAttributes", "field"],
    id: "id"
  },
  features: [\u0275\u0275NgOnChangesFeature]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyAttributes, [{
    type: Directive,
    args: [{
      selector: "[formlyAttributes]",
      host: {
        "(change)": "onHostChange($event)"
      }
    }]
  }], function() {
    return [{
      type: Renderer2
    }, {
      type: ElementRef
    }, {
      type: void 0,
      decorators: [{
        type: Inject,
        args: [DOCUMENT]
      }]
    }];
  }, {
    field: [{
      type: Input,
      args: ["formlyAttributes"]
    }],
    id: [{
      type: Input
    }]
  });
})();
var FieldType = class {
  constructor() {
    this.field = {};
  }
  set _formlyControls(controls) {
    const f = this.field;
    f._localFields = controls.map((c) => c.control._fields || []).flat().filter((f2) => f2.formControl !== this.field.formControl);
  }
  get model() {
    return this.field.model;
  }
  get form() {
    return this.field.form;
  }
  get options() {
    return this.field.options;
  }
  get key() {
    return this.field.key;
  }
  get formControl() {
    return this.field.formControl;
  }
  get props() {
    return this.field.props || {};
  }
  /** @deprecated Use `props` instead. */
  get to() {
    return this.props;
  }
  get showError() {
    return this.options.showError(this);
  }
  get id() {
    return this.field.id;
  }
  get formState() {
    return this.options?.formState || {};
  }
};
FieldType.\u0275fac = function FieldType_Factory(t) {
  return new (t || FieldType)();
};
FieldType.\u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
  type: FieldType,
  viewQuery: function FieldType_Query(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275viewQuery(NgControl, 5);
    }
    if (rf & 2) {
      let _t;
      \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx._formlyControls = _t);
    }
  },
  inputs: {
    field: "field"
  }
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FieldType, [{
    type: Directive
  }], null, {
    _formlyControls: [{
      type: ViewChildren,
      args: [NgControl]
    }],
    field: [{
      type: Input
    }]
  });
})();
var FormlyGroup = class extends FieldType {
};
FormlyGroup.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyGroup_BaseFactory;
  return function FormlyGroup_Factory(t) {
    return (\u0275FormlyGroup_BaseFactory || (\u0275FormlyGroup_BaseFactory = \u0275\u0275getInheritedFactory(FormlyGroup)))(t || FormlyGroup);
  };
})();
FormlyGroup.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyGroup,
  selectors: [["formly-group"]],
  hostVars: 2,
  hostBindings: function FormlyGroup_HostBindings(rf, ctx) {
    if (rf & 2) {
      \u0275\u0275classMap(ctx.field.fieldGroupClassName || "");
    }
  },
  features: [\u0275\u0275InheritDefinitionFeature],
  ngContentSelectors: _c1,
  decls: 2,
  vars: 1,
  consts: [[3, "field", 4, "ngFor", "ngForOf"], [3, "field"]],
  template: function FormlyGroup_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275projectionDef();
      \u0275\u0275template(0, FormlyGroup_formly_field_0_Template, 1, 1, "formly-field", 0);
      \u0275\u0275projection(1);
    }
    if (rf & 2) {
      \u0275\u0275property("ngForOf", ctx.field.fieldGroup);
    }
  },
  dependencies: [FormlyField, NgForOf],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyGroup, [{
    type: Component,
    args: [{
      selector: "formly-group",
      template: `
    <formly-field *ngFor="let f of field.fieldGroup" [field]="f"></formly-field>
    <ng-content></ng-content>
  `,
      host: {
        "[class]": 'field.fieldGroupClassName || ""'
      },
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], null, null);
})();
var FormlyValidationMessage = class {
  constructor(config) {
    this.config = config;
  }
  ngOnChanges() {
    const EXPR_VALIDATORS = FORMLY_VALIDATORS.map((v) => `templateOptions.${v}`);
    this.errorMessage$ = merge(this.field.formControl.statusChanges, !this.field.options ? of(null) : this.field.options.fieldChanges.pipe(filter(({
      field,
      type,
      property
    }) => {
      return field === this.field && type === "expressionChanges" && (property.indexOf("validation") !== -1 || EXPR_VALIDATORS.indexOf(property) !== -1);
    }))).pipe(startWith(null), switchMap(() => isObservable(this.errorMessage) ? this.errorMessage : of(this.errorMessage)));
  }
  get errorMessage() {
    const fieldForm = this.field.formControl;
    for (const error in fieldForm.errors) {
      if (fieldForm.errors.hasOwnProperty(error)) {
        let message = this.config.getValidatorMessage(error);
        if (isObject(fieldForm.errors[error])) {
          if (fieldForm.errors[error].errorPath) {
            return void 0;
          }
          if (fieldForm.errors[error].message) {
            message = fieldForm.errors[error].message;
          }
        }
        if (this.field.validation?.messages?.[error]) {
          message = this.field.validation.messages[error];
        }
        if (this.field.validators?.[error]?.message) {
          message = this.field.validators[error].message;
        }
        if (this.field.asyncValidators?.[error]?.message) {
          message = this.field.asyncValidators[error].message;
        }
        if (typeof message === "function") {
          return message(fieldForm.errors[error], this.field);
        }
        return message;
      }
    }
    return void 0;
  }
};
FormlyValidationMessage.\u0275fac = function FormlyValidationMessage_Factory(t) {
  return new (t || FormlyValidationMessage)(\u0275\u0275directiveInject(FormlyConfig));
};
FormlyValidationMessage.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyValidationMessage,
  selectors: [["formly-validation-message"]],
  inputs: {
    field: "field"
  },
  features: [\u0275\u0275NgOnChangesFeature],
  decls: 2,
  vars: 3,
  template: function FormlyValidationMessage_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275text(0);
      \u0275\u0275pipe(1, "async");
    }
    if (rf & 2) {
      \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(1, 1, ctx.errorMessage$));
    }
  },
  dependencies: [AsyncPipe],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyValidationMessage, [{
    type: Component,
    args: [{
      selector: "formly-validation-message",
      template: "{{ errorMessage$ | async }}",
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], function() {
    return [{
      type: FormlyConfig
    }];
  }, {
    field: [{
      type: Input
    }]
  });
})();
var FieldArrayType = class extends FieldType {
  onPopulate(field) {
    if (hasKey(field)) {
      const control = findControl(field);
      registerControl(field, control ? control : new FormArray([], {
        updateOn: field.modelOptions.updateOn
      }));
    }
    field.fieldGroup = field.fieldGroup || [];
    const length = Array.isArray(field.model) ? field.model.length : 0;
    if (field.fieldGroup.length > length) {
      for (let i = field.fieldGroup.length - 1; i >= length; --i) {
        unregisterControl(field.fieldGroup[i], true);
        field.fieldGroup.splice(i, 1);
      }
    }
    for (let i = field.fieldGroup.length; i < length; i++) {
      const f = __spreadValues({}, clone(typeof field.fieldArray === "function" ? field.fieldArray(field) : field.fieldArray));
      if (f.key !== null) {
        f.key = `${i}`;
      }
      field.fieldGroup.push(f);
    }
  }
  add(i, initialModel, {
    markAsDirty
  } = {
    markAsDirty: true
  }) {
    i = i == null ? this.field.fieldGroup.length : i;
    if (!this.model) {
      assignFieldValue(this.field, []);
    }
    this.model.splice(i, 0, initialModel ? clone(initialModel) : void 0);
    this.markFieldForCheck(this.field.fieldGroup[i]);
    this._build();
    markAsDirty && this.formControl.markAsDirty();
  }
  remove(i, {
    markAsDirty
  } = {
    markAsDirty: true
  }) {
    this.model.splice(i, 1);
    const field = this.field.fieldGroup[i];
    this.field.fieldGroup.splice(i, 1);
    this.field.fieldGroup.forEach((f, key) => this.updateArrayElementKey(f, `${key}`));
    unregisterControl(field, true);
    this._build();
    markAsDirty && this.formControl.markAsDirty();
  }
  _build() {
    const fields = this.field.formControl._fields ?? [this.field];
    fields.forEach((f) => this.options.build(f));
    this.options.fieldChanges.next({
      field: this.field,
      value: getFieldValue(this.field),
      type: "valueChanges"
    });
  }
  updateArrayElementKey(f, newKey) {
    if (hasKey(f)) {
      f.key = newKey;
      return;
    }
    if (!f.fieldGroup?.length) {
      return;
    }
    for (let i = 0; i < f.fieldGroup.length; i++) {
      this.updateArrayElementKey(f.fieldGroup[i], newKey);
    }
  }
  markFieldForCheck(f) {
    if (!f) {
      return;
    }
    f.fieldGroup?.forEach((c) => this.markFieldForCheck(c));
    if (f.hide === false) {
      this.options._hiddenFieldsForCheck.push(f);
    }
  }
};
FieldArrayType.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FieldArrayType_BaseFactory;
  return function FieldArrayType_Factory(t) {
    return (\u0275FieldArrayType_BaseFactory || (\u0275FieldArrayType_BaseFactory = \u0275\u0275getInheritedFactory(FieldArrayType)))(t || FieldArrayType);
  };
})();
FieldArrayType.\u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
  type: FieldArrayType,
  features: [\u0275\u0275InheritDefinitionFeature]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FieldArrayType, [{
    type: Directive
  }], null, null);
})();
var FieldWrapper = class extends FieldType {
  set _formlyControls(_) {
  }
  set _staticContent(content) {
    this.fieldComponent = content;
  }
};
FieldWrapper.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FieldWrapper_BaseFactory;
  return function FieldWrapper_Factory(t) {
    return (\u0275FieldWrapper_BaseFactory || (\u0275FieldWrapper_BaseFactory = \u0275\u0275getInheritedFactory(FieldWrapper)))(t || FieldWrapper);
  };
})();
FieldWrapper.\u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
  type: FieldWrapper,
  viewQuery: function FieldWrapper_Query(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275viewQuery(_c2, 5, ViewContainerRef);
      \u0275\u0275viewQuery(_c2, 7, ViewContainerRef);
    }
    if (rf & 2) {
      let _t;
      \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.fieldComponent = _t.first);
      \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx._staticContent = _t.first);
    }
  },
  features: [\u0275\u0275InheritDefinitionFeature]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FieldWrapper, [{
    type: Directive
  }], null, {
    fieldComponent: [{
      type: ViewChild,
      args: ["fieldComponent", {
        read: ViewContainerRef
      }]
    }],
    _staticContent: [{
      type: ViewChild,
      args: ["fieldComponent", {
        read: ViewContainerRef,
        static: true
      }]
    }]
  });
})();
var FormlyTemplateType = class extends FieldType {
  constructor(sanitizer) {
    super();
    this.sanitizer = sanitizer;
    this.innerHtml = {};
  }
  get template() {
    if (this.field && this.field.template !== this.innerHtml.template) {
      this.innerHtml = {
        template: this.field.template,
        content: this.props.safeHtml ? this.sanitizer.bypassSecurityTrustHtml(this.field.template) : this.field.template
      };
    }
    return this.innerHtml.content;
  }
};
FormlyTemplateType.\u0275fac = function FormlyTemplateType_Factory(t) {
  return new (t || FormlyTemplateType)(\u0275\u0275directiveInject(DomSanitizer));
};
FormlyTemplateType.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyTemplateType,
  selectors: [["formly-template"]],
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 1,
  vars: 1,
  consts: [[3, "innerHtml"]],
  template: function FormlyTemplateType_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275element(0, "div", 0);
    }
    if (rf & 2) {
      \u0275\u0275property("innerHtml", ctx.template, \u0275\u0275sanitizeHtml);
    }
  },
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyTemplateType, [{
    type: Component,
    args: [{
      selector: "formly-template",
      template: `<div [innerHtml]="template"></div>`,
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], function() {
    return [{
      type: DomSanitizer
    }];
  }, null);
})();
function evalStringExpression(expression, argNames) {
  try {
    return Function(...argNames, `return ${expression};`);
  } catch (error) {
    console.error(error);
  }
}
function evalExpression(expression, thisArg, argVal) {
  if (typeof expression === "function") {
    return expression.apply(thisArg, argVal);
  } else {
    return expression ? true : false;
  }
}
var FieldExpressionExtension = class {
  onPopulate(field) {
    if (field._expressions) {
      return;
    }
    defineHiddenProp(field, "_expressions", {});
    observe(field, ["hide"], ({
      currentValue,
      firstChange
    }) => {
      defineHiddenProp(field, "_hide", !!currentValue);
      if (!firstChange || firstChange && currentValue === true) {
        field.props.hidden = currentValue;
        field.options._hiddenFieldsForCheck.push(field);
      }
    });
    if (field.hideExpression) {
      observe(field, ["hideExpression"], ({
        currentValue: expr
      }) => {
        field._expressions.hide = this.parseExpressions(field, "hide", typeof expr === "boolean" ? () => expr : expr);
      });
    }
    const evalExpr = (key, expr) => {
      if (typeof expr === "string" || isFunction(expr)) {
        field._expressions[key] = this.parseExpressions(field, key, expr);
      } else if (expr instanceof Observable) {
        field._expressions[key] = {
          value$: expr.pipe(tap((v) => {
            this.evalExpr(field, key, v);
            field.options._detectChanges(field);
          }))
        };
      }
    };
    field.expressions = field.expressions || {};
    for (const key of Object.keys(field.expressions)) {
      observe(field, ["expressions", key], ({
        currentValue: expr
      }) => {
        evalExpr(key, isFunction(expr) ? (...args) => expr(field, args[3]) : expr);
      });
    }
    field.expressionProperties = field.expressionProperties || {};
    for (const key of Object.keys(field.expressionProperties)) {
      observe(field, ["expressionProperties", key], ({
        currentValue
      }) => evalExpr(key, currentValue));
    }
  }
  postPopulate(field) {
    if (field.parent) {
      return;
    }
    if (!field.options.checkExpressions) {
      let checkLocked = false;
      field.options.checkExpressions = (f, ignoreCache) => {
        if (checkLocked) {
          return;
        }
        checkLocked = true;
        const fieldChanged = this.checkExpressions(f, ignoreCache);
        const options = field.options;
        options._hiddenFieldsForCheck.sort((f2) => f2.hide ? -1 : 1).forEach((f2) => this.changeHideState(f2, f2.hide, !ignoreCache));
        options._hiddenFieldsForCheck = [];
        if (fieldChanged) {
          this.checkExpressions(field);
        }
        checkLocked = false;
      };
      field.options._checkField = (f, ignoreCache) => {
        console.warn(`Formly: 'options._checkField' is deprecated since v6.0, use 'options.checkExpressions' instead.`);
        field.options.checkExpressions(f, ignoreCache);
      };
    }
  }
  parseExpressions(field, path, expr) {
    let parentExpression;
    if (field.parent && ["hide", "props.disabled"].includes(path)) {
      const rootValue = (f) => {
        return path === "hide" ? f.hide : f.props.disabled;
      };
      parentExpression = () => {
        let root = field.parent;
        while (root.parent && !rootValue(root)) {
          root = root.parent;
        }
        return rootValue(root);
      };
    }
    expr = expr || (() => false);
    if (typeof expr === "string") {
      expr = evalStringExpression(expr, ["model", "formState", "field"]);
    }
    let currentValue;
    return {
      callback: (ignoreCache) => {
        try {
          const exprValue = evalExpression(parentExpression ? (...args) => parentExpression(field) || expr(...args) : expr, {
            field
          }, [field.model, field.options.formState, field, ignoreCache]);
          if (ignoreCache || currentValue !== exprValue && (!isObject(exprValue) || isObservable(exprValue) || JSON.stringify(exprValue) !== JSON.stringify(currentValue))) {
            currentValue = exprValue;
            this.evalExpr(field, path, exprValue);
            return true;
          }
          return false;
        } catch (error) {
          error.message = `[Formly Error] [Expression "${path}"] ${error.message}`;
          throw error;
        }
      }
    };
  }
  checkExpressions(field, ignoreCache = false) {
    if (!field) {
      return false;
    }
    let fieldChanged = false;
    if (field._expressions) {
      for (const key of Object.keys(field._expressions)) {
        field._expressions[key].callback?.(ignoreCache) && (fieldChanged = true);
      }
    }
    field.fieldGroup?.forEach((f) => this.checkExpressions(f, ignoreCache) && (fieldChanged = true));
    return fieldChanged;
  }
  changeDisabledState(field, value) {
    if (field.fieldGroup) {
      field.fieldGroup.filter((f) => !f._expressions.hasOwnProperty("props.disabled")).forEach((f) => this.changeDisabledState(f, value));
    }
    if (hasKey(field) && field.props.disabled !== value) {
      field.props.disabled = value;
    }
  }
  changeHideState(field, hide, resetOnHide) {
    if (field.fieldGroup) {
      field.fieldGroup.filter((f) => f && !f._expressions.hide).forEach((f) => this.changeHideState(f, hide, resetOnHide));
    }
    if (field.formControl && hasKey(field)) {
      defineHiddenProp(field, "_hide", !!(hide || field.hide));
      const c = field.formControl;
      if (c._fields?.length > 1) {
        updateValidity(c);
      }
      if (hide === true && (!c._fields || c._fields.every((f) => !!f._hide))) {
        unregisterControl(field, true);
        if (resetOnHide && field.resetOnHide) {
          assignFieldValue(field, void 0);
          field.formControl.reset({
            value: void 0,
            disabled: field.formControl.disabled
          });
          field.options.fieldChanges.next({
            value: void 0,
            field,
            type: "valueChanges"
          });
          if (field.fieldGroup && field.formControl instanceof FormArray) {
            field.fieldGroup.length = 0;
          }
        }
      } else if (hide === false) {
        if (field.resetOnHide && !isUndefined(field.defaultValue) && isUndefined(getFieldValue(field))) {
          assignFieldValue(field, field.defaultValue);
        }
        registerControl(field, void 0, true);
        if (field.resetOnHide && field.fieldArray && field.fieldGroup?.length !== field.model?.length) {
          field.options.build(field);
        }
      }
    }
    if (field.options.fieldChanges) {
      field.options.fieldChanges.next({
        field,
        type: "hidden",
        value: hide
      });
    }
  }
  evalExpr(field, prop, value) {
    if (prop.indexOf("model.") === 0) {
      const key = prop.replace(/^model\./, ""), parent = field.fieldGroup ? field : field.parent;
      let control = field?.key === key ? field.formControl : field.form.get(key);
      if (!control && field.get(key)) {
        control = field.get(key).formControl;
      }
      assignFieldValue({
        key,
        parent,
        model: field.model
      }, value);
      if (control && !(isNil(control.value) && isNil(value)) && control.value !== value) {
        control.patchValue(value);
      }
    } else {
      try {
        let target = field;
        const paths = this._evalExpressionPath(field, prop);
        const lastIndex = paths.length - 1;
        for (let i = 0; i < lastIndex; i++) {
          target = target[paths[i]];
        }
        target[paths[lastIndex]] = value;
      } catch (error) {
        error.message = `[Formly Error] [Expression "${prop}"] ${error.message}`;
        throw error;
      }
      if (["templateOptions.disabled", "props.disabled"].includes(prop) && hasKey(field)) {
        this.changeDisabledState(field, value);
      }
    }
    this.emitExpressionChanges(field, prop, value);
  }
  emitExpressionChanges(field, property, value) {
    if (!field.options.fieldChanges) {
      return;
    }
    field.options.fieldChanges.next({
      field,
      type: "expressionChanges",
      property,
      value
    });
  }
  _evalExpressionPath(field, prop) {
    if (field._expressions[prop] && field._expressions[prop].paths) {
      return field._expressions[prop].paths;
    }
    let paths = [];
    if (prop.indexOf("[") === -1) {
      paths = prop.split(".");
    } else {
      prop.split(/[[\]]{1,2}/).filter((p) => p).forEach((path) => {
        const arrayPath = path.match(/['|"](.*?)['|"]/);
        if (arrayPath) {
          paths.push(arrayPath[1]);
        } else {
          paths.push(...path.split(".").filter((p) => p));
        }
      });
    }
    if (field._expressions[prop]) {
      field._expressions[prop].paths = paths;
    }
    return paths;
  }
};
var FieldValidationExtension = class {
  constructor(config) {
    this.config = config;
  }
  onPopulate(field) {
    this.initFieldValidation(field, "validators");
    this.initFieldValidation(field, "asyncValidators");
  }
  initFieldValidation(field, type) {
    const validators = [];
    if (type === "validators" && !(field.hasOwnProperty("fieldGroup") && !hasKey(field))) {
      validators.push(this.getPredefinedFieldValidation(field));
    }
    if (field[type]) {
      for (const validatorName of Object.keys(field[type])) {
        validatorName === "validation" ? validators.push(...field[type].validation.map((v) => this.wrapNgValidatorFn(field, v))) : validators.push(this.wrapNgValidatorFn(field, field[type][validatorName], validatorName));
      }
    }
    defineHiddenProp(field, "_" + type, validators);
  }
  getPredefinedFieldValidation(field) {
    let VALIDATORS = [];
    FORMLY_VALIDATORS.forEach((opt) => observe(field, ["props", opt], ({
      currentValue,
      firstChange
    }) => {
      VALIDATORS = VALIDATORS.filter((o) => o !== opt);
      if (opt === "required" && currentValue != null && typeof currentValue !== "boolean") {
        console.warn(`Formly: Invalid prop 'required' of type '${typeof currentValue}', expected 'boolean' (Field:${field.key}).`);
      }
      if (currentValue != null && currentValue !== false) {
        VALIDATORS.push(opt);
      }
      if (!firstChange && field.formControl) {
        updateValidity(field.formControl);
      }
    }));
    return (control) => {
      if (VALIDATORS.length === 0) {
        return null;
      }
      return Validators.compose(VALIDATORS.map((opt) => () => {
        const value = field.props[opt];
        switch (opt) {
          case "required":
            return Validators.required(control);
          case "pattern":
            return Validators.pattern(value)(control);
          case "minLength":
            const minLengthResult = Validators.minLength(value)(control);
            const minLengthKey = this.config.getValidatorMessage("minlength") || field.validation?.messages?.minlength ? "minlength" : "minLength";
            return minLengthResult ? {
              [minLengthKey]: minLengthResult.minlength
            } : null;
          case "maxLength":
            const maxLengthResult = Validators.maxLength(value)(control);
            const maxLengthKey = this.config.getValidatorMessage("maxlength") || field.validation?.messages?.maxlength ? "maxlength" : "maxLength";
            return maxLengthResult ? {
              [maxLengthKey]: maxLengthResult.maxlength
            } : null;
          case "min":
            return Validators.min(value)(control);
          case "max":
            return Validators.max(value)(control);
          default:
            return null;
        }
      }))(control);
    };
  }
  wrapNgValidatorFn(field, validator, validatorName) {
    let validatorOption;
    if (typeof validator === "string") {
      validatorOption = clone(this.config.getValidator(validator));
    }
    if (typeof validator === "object" && validator.name) {
      validatorOption = clone(this.config.getValidator(validator.name));
      if (validator.options) {
        validatorOption.options = validator.options;
      }
    }
    if (typeof validator === "object" && validator.expression) {
      const _a = validator, {
        expression
      } = _a, options = __objRest(_a, [
        "expression"
      ]);
      validatorOption = {
        name: validatorName,
        validation: expression,
        options: Object.keys(options).length > 0 ? options : null
      };
    }
    if (typeof validator === "function") {
      validatorOption = {
        name: validatorName,
        validation: validator
      };
    }
    return (control) => {
      const errors = validatorOption.validation(control, field, validatorOption.options);
      if (isPromise(errors)) {
        return errors.then((v) => this.handleResult(field, validatorName ? !!v : v, validatorOption));
      }
      if (isObservable(errors)) {
        return errors.pipe(map((v) => this.handleResult(field, validatorName ? !!v : v, validatorOption)));
      }
      return this.handleResult(field, validatorName ? !!errors : errors, validatorOption);
    };
  }
  handleResult(field, errors, {
    name,
    options
  }) {
    if (typeof errors === "boolean") {
      errors = errors ? null : {
        [name]: options ? options : true
      };
    }
    const ctrl = field.formControl;
    ctrl?._childrenErrors?.[name]?.();
    if (isObject(errors)) {
      Object.keys(errors).forEach((name2) => {
        const errorPath = errors[name2].errorPath ? errors[name2].errorPath : options?.errorPath;
        const childCtrl = errorPath ? field.formControl.get(errorPath) : null;
        if (childCtrl) {
          const _a = errors[name2], {
            errorPath: _errorPath
          } = _a, opts = __objRest(_a, [
            "errorPath"
          ]);
          childCtrl.setErrors(__spreadProps(__spreadValues({}, childCtrl.errors || {}), {
            [name2]: opts
          }));
          !ctrl._childrenErrors && defineHiddenProp(ctrl, "_childrenErrors", {});
          ctrl._childrenErrors[name2] = () => {
            const _a2 = childCtrl.errors || {}, {
              [name2]: _toDelete
            } = _a2, childErrors = __objRest(_a2, [
              __restKey(name2)
            ]);
            childCtrl.setErrors(Object.keys(childErrors).length === 0 ? null : childErrors);
          };
        }
      });
    }
    return errors;
  }
};
var FieldFormExtension = class {
  prePopulate(field) {
    if (!this.root) {
      this.root = field;
    }
    if (field.parent) {
      Object.defineProperty(field, "form", {
        get: () => field.parent.formControl,
        configurable: true
      });
    }
  }
  onPopulate(field) {
    if (field.hasOwnProperty("fieldGroup") && !hasKey(field)) {
      defineHiddenProp(field, "formControl", field.form);
    } else {
      this.addFormControl(field);
    }
  }
  postPopulate(field) {
    if (this.root !== field) {
      return;
    }
    this.root = null;
    const markForCheck = this.setValidators(field);
    if (markForCheck && field.parent) {
      let parent = field.parent;
      while (parent) {
        if (hasKey(parent) || !parent.parent) {
          updateValidity(parent.formControl, true);
        }
        parent = parent.parent;
      }
    }
  }
  addFormControl(field) {
    let control = findControl(field);
    if (field.fieldArray) {
      return;
    }
    if (!control) {
      const controlOptions = {
        updateOn: field.modelOptions.updateOn
      };
      if (field.fieldGroup) {
        control = new FormGroup({}, controlOptions);
      } else {
        const value = hasKey(field) ? getFieldValue(field) : field.defaultValue;
        control = new FormControl({
          value,
          disabled: !!field.props.disabled
        }, __spreadProps(__spreadValues({}, controlOptions), {
          initialValueIsDefault: true
        }));
      }
    } else {
      if (control instanceof FormControl) {
        const value = hasKey(field) ? getFieldValue(field) : field.defaultValue;
        control.defaultValue = value;
      }
    }
    registerControl(field, control);
  }
  setValidators(field, disabled = false) {
    if (disabled === false && hasKey(field) && field.props?.disabled) {
      disabled = true;
    }
    let markForCheck = false;
    field.fieldGroup?.forEach((f) => f && this.setValidators(f, disabled) && (markForCheck = true));
    if (hasKey(field) || !field.parent || !hasKey(field) && !field.fieldGroup) {
      const {
        formControl: c
      } = field;
      if (c) {
        if (hasKey(field) && c instanceof FormControl) {
          if (disabled && c.enabled) {
            c.disable({
              emitEvent: false,
              onlySelf: true
            });
            markForCheck = true;
          }
          if (!disabled && c.disabled) {
            c.enable({
              emitEvent: false,
              onlySelf: true
            });
            markForCheck = true;
          }
        }
        if (null === c.validator && this.hasValidators(field, "_validators")) {
          c.setValidators(() => {
            const v = Validators.compose(this.mergeValidators(field, "_validators"));
            return v ? v(c) : null;
          });
          markForCheck = true;
        }
        if (null === c.asyncValidator && this.hasValidators(field, "_asyncValidators")) {
          c.setAsyncValidators(() => {
            const v = Validators.composeAsync(this.mergeValidators(field, "_asyncValidators"));
            return v ? v(c) : of(null);
          });
          markForCheck = true;
        }
        if (markForCheck) {
          updateValidity(c, true);
          let parent = c.parent;
          for (let i = 1; i < getKeyPath(field).length; i++) {
            if (parent) {
              updateValidity(parent, true);
              parent = parent.parent;
            }
          }
        }
      }
    }
    return markForCheck;
  }
  hasValidators(field, type) {
    const c = field.formControl;
    if (c?._fields?.length > 1 && c._fields.some((f) => f[type].length > 0)) {
      return true;
    } else if (field[type].length > 0) {
      return true;
    }
    return field.fieldGroup?.some((f) => f?.fieldGroup && !hasKey(f) && this.hasValidators(f, type));
  }
  mergeValidators(field, type) {
    const validators = [];
    const c = field.formControl;
    if (c?._fields?.length > 1) {
      c._fields.filter((f) => !f._hide).forEach((f) => validators.push(...f[type]));
    } else if (field[type]) {
      validators.push(...field[type]);
    }
    if (field.fieldGroup) {
      field.fieldGroup.filter((f) => f?.fieldGroup && !hasKey(f)).forEach((f) => validators.push(...this.mergeValidators(f, type)));
    }
    return validators;
  }
};
var CoreExtension = class {
  constructor(config) {
    this.config = config;
    this.formId = 0;
  }
  prePopulate(field) {
    const root = field.parent;
    this.initRootOptions(field);
    this.initFieldProps(field);
    if (root) {
      Object.defineProperty(field, "options", {
        get: () => root.options,
        configurable: true
      });
      Object.defineProperty(field, "model", {
        get: () => hasKey(field) && field.fieldGroup ? getFieldValue(field) : root.model,
        configurable: true
      });
    }
    Object.defineProperty(field, "get", {
      value: (key) => getField(field, key),
      configurable: true
    });
    this.getFieldComponentInstance(field).prePopulate?.(field);
  }
  onPopulate(field) {
    this.initFieldOptions(field);
    this.getFieldComponentInstance(field).onPopulate?.(field);
    if (field.fieldGroup) {
      field.fieldGroup.forEach((f, index) => {
        if (f) {
          Object.defineProperty(f, "parent", {
            get: () => field,
            configurable: true
          });
          Object.defineProperty(f, "index", {
            get: () => index,
            configurable: true
          });
        }
        this.formId++;
      });
    }
  }
  postPopulate(field) {
    this.getFieldComponentInstance(field).postPopulate?.(field);
  }
  initFieldProps(field) {
    field.props ?? (field.props = field.templateOptions);
    Object.defineProperty(field, "templateOptions", {
      get: () => field.props,
      set: (props) => field.props = props,
      configurable: true
    });
  }
  initRootOptions(field) {
    if (field.parent) {
      return;
    }
    const options = field.options;
    field.options.formState = field.options.formState || {};
    if (!options.showError) {
      options.showError = this.config.extras.showError;
    }
    if (!options.fieldChanges) {
      defineHiddenProp(options, "fieldChanges", new Subject());
    }
    if (!options._hiddenFieldsForCheck) {
      options._hiddenFieldsForCheck = [];
    }
    options._markForCheck = (f) => {
      console.warn(`Formly: 'options._markForCheck' is deprecated since v6.0, use 'options.detectChanges' instead.`);
      options.detectChanges(f);
    };
    options._detectChanges = (f) => {
      if (f._componentRefs) {
        markFieldForCheck(f);
      }
      f.fieldGroup?.forEach((f2) => f2 && options._detectChanges(f2));
    };
    options.detectChanges = (f) => {
      f.options.checkExpressions?.(f);
      options._detectChanges(f);
    };
    options.resetModel = (model) => {
      model = clone(model ?? options._initialModel);
      if (field.model) {
        Object.keys(field.model).forEach((k) => delete field.model[k]);
        Object.assign(field.model, model || {});
      }
      observe(options, ["parentForm", "submitted"]).setValue(false, false);
      options.build(field);
      field.form.reset(field.model);
    };
    options.updateInitialValue = (model) => options._initialModel = clone(model ?? field.model);
    field.options.updateInitialValue();
  }
  initFieldOptions(field) {
    reverseDeepMerge(field, {
      id: getFieldId(`formly_${this.formId}`, field, field.index),
      hooks: {},
      modelOptions: {},
      validation: {
        messages: {}
      },
      props: !field.type || !hasKey(field) ? {} : {
        label: "",
        placeholder: "",
        disabled: false
      }
    });
    if (this.config.extras.resetFieldOnHide && field.resetOnHide !== false) {
      field.resetOnHide = true;
    }
    if (field.type !== "formly-template" && (field.template || field.expressions?.template || field.expressionProperties?.template)) {
      field.type = "formly-template";
    }
    if (!field.type && field.fieldGroup) {
      field.type = "formly-group";
    }
    if (field.type) {
      this.config.getMergedField(field);
    }
    if (hasKey(field) && !isUndefined(field.defaultValue) && isUndefined(getFieldValue(field)) && !isHiddenField(field)) {
      assignFieldValue(field, field.defaultValue);
    }
    field.wrappers = field.wrappers || [];
  }
  getFieldComponentInstance(field) {
    const componentRefInstance = () => {
      let componentRef = this.config.resolveFieldTypeRef(field);
      const fieldComponentRef = field._componentRefs?.slice(-1)[0];
      if (fieldComponentRef instanceof ComponentRef$1 && fieldComponentRef?.componentType === componentRef?.componentType) {
        componentRef = fieldComponentRef;
      }
      return componentRef?.instance;
    };
    if (!field._proxyInstance) {
      defineHiddenProp(field, "_proxyInstance", new Proxy({}, {
        get: (_, prop) => componentRefInstance()?.[prop],
        set: (_, prop, value) => componentRefInstance()[prop] = value
      }));
    }
    return field._proxyInstance;
  }
};
function defaultFormlyConfig(config) {
  return {
    types: [{
      name: "formly-group",
      component: FormlyGroup
    }, {
      name: "formly-template",
      component: FormlyTemplateType
    }],
    extensions: [{
      name: "core",
      extension: new CoreExtension(config),
      priority: -250
    }, {
      name: "field-validation",
      extension: new FieldValidationExtension(config),
      priority: -200
    }, {
      name: "field-form",
      extension: new FieldFormExtension(),
      priority: -150
    }, {
      name: "field-expression",
      extension: new FieldExpressionExtension(),
      priority: -100
    }]
  };
}
var FormlyModule = class _FormlyModule {
  constructor(configService, configs = []) {
    if (!configs) {
      return;
    }
    configs.forEach((config) => configService.addConfig(config));
  }
  static forRoot(config = {}) {
    return {
      ngModule: _FormlyModule,
      providers: [{
        provide: FORMLY_CONFIG,
        multi: true,
        useFactory: defaultFormlyConfig,
        deps: [FormlyConfig]
      }, {
        provide: FORMLY_CONFIG,
        useValue: config,
        multi: true
      }, FormlyConfig, FormlyFormBuilder]
    };
  }
  static forChild(config = {}) {
    return {
      ngModule: _FormlyModule,
      providers: [{
        provide: FORMLY_CONFIG,
        multi: true,
        useFactory: defaultFormlyConfig,
        deps: [FormlyConfig]
      }, {
        provide: FORMLY_CONFIG,
        useValue: config,
        multi: true
      }, FormlyFormBuilder]
    };
  }
};
FormlyModule.\u0275fac = function FormlyModule_Factory(t) {
  return new (t || FormlyModule)(\u0275\u0275inject(FormlyConfig), \u0275\u0275inject(FORMLY_CONFIG, 8));
};
FormlyModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyModule
});
FormlyModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyTemplate, FormlyForm, FormlyField, FormlyAttributes, FormlyGroup, FormlyValidationMessage, FormlyTemplateType],
      exports: [FormlyTemplate, FormlyForm, FormlyField, FormlyAttributes, FormlyGroup, FormlyValidationMessage],
      imports: [CommonModule]
    }]
  }], function() {
    return [{
      type: FormlyConfig
    }, {
      type: void 0,
      decorators: [{
        type: Optional
      }, {
        type: Inject,
        args: [FORMLY_CONFIG]
      }]
    }];
  }, null);
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap-form-field.mjs
function FormlyWrapperFormField_ng_template_0_label_0_span_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 9);
    \u0275\u0275text(1, "*");
    \u0275\u0275elementEnd();
  }
}
function FormlyWrapperFormField_ng_template_0_label_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label", 7);
    \u0275\u0275text(1);
    \u0275\u0275template(2, FormlyWrapperFormField_ng_template_0_label_0_span_2_Template, 2, 0, "span", 8);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275attribute("for", ctx_r0.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.props.label, " ");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.props.required && ctx_r0.props.hideRequiredMarker !== true);
  }
}
function FormlyWrapperFormField_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, FormlyWrapperFormField_ng_template_0_label_0_Template, 3, 3, "label", 6);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("ngIf", ctx_r0.props.label && ctx_r0.props.hideLabel !== true);
  }
}
function FormlyWrapperFormField_ng_container_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementContainer(1, 10);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    \u0275\u0275nextContext();
    const labelTemplate_r2 = \u0275\u0275reference(1);
    \u0275\u0275advance();
    \u0275\u0275property("ngTemplateOutlet", labelTemplate_r2);
  }
}
function FormlyWrapperFormField_ng_template_4_Template(rf, ctx) {
}
function FormlyWrapperFormField_ng_container_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementContainer(1, 10);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    \u0275\u0275nextContext();
    const labelTemplate_r2 = \u0275\u0275reference(1);
    \u0275\u0275advance();
    \u0275\u0275property("ngTemplateOutlet", labelTemplate_r2);
  }
}
function FormlyWrapperFormField_div_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11);
    \u0275\u0275element(1, "formly-validation-message", 12);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275styleProp("display", "block");
    \u0275\u0275advance();
    \u0275\u0275propertyInterpolate1("id", "", ctx_r0.id, "-formly-validation-error");
    \u0275\u0275property("field", ctx_r0.field);
  }
}
function FormlyWrapperFormField_small_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "small", 13);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(ctx_r0.props.description);
  }
}
var _c02 = ["fieldTypeTemplate"];
var FormlyWrapperFormField = class extends FieldWrapper {
};
FormlyWrapperFormField.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyWrapperFormField_BaseFactory;
  return function FormlyWrapperFormField_Factory(t) {
    return (\u0275FormlyWrapperFormField_BaseFactory || (\u0275FormlyWrapperFormField_BaseFactory = \u0275\u0275getInheritedFactory(FormlyWrapperFormField)))(t || FormlyWrapperFormField);
  };
})();
FormlyWrapperFormField.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyWrapperFormField,
  selectors: [["formly-wrapper-form-field"]],
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 9,
  vars: 8,
  consts: [["labelTemplate", ""], ["fieldComponent", ""], [1, "mb-3"], [4, "ngIf"], ["class", "invalid-feedback", 3, "display", 4, "ngIf"], ["class", "form-text text-muted", 4, "ngIf"], ["class", "form-label", 4, "ngIf"], [1, "form-label"], ["aria-hidden", "true", 4, "ngIf"], ["aria-hidden", "true"], [3, "ngTemplateOutlet"], [1, "invalid-feedback"], ["role", "alert", 3, "id", "field"], [1, "form-text", "text-muted"]],
  template: function FormlyWrapperFormField_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyWrapperFormField_ng_template_0_Template, 1, 1, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
      \u0275\u0275elementStart(2, "div", 2);
      \u0275\u0275template(3, FormlyWrapperFormField_ng_container_3_Template, 2, 1, "ng-container", 3)(4, FormlyWrapperFormField_ng_template_4_Template, 0, 0, "ng-template", null, 1, \u0275\u0275templateRefExtractor)(6, FormlyWrapperFormField_ng_container_6_Template, 2, 1, "ng-container", 3)(7, FormlyWrapperFormField_div_7_Template, 2, 5, "div", 4)(8, FormlyWrapperFormField_small_8_Template, 2, 1, "small", 5);
      \u0275\u0275elementEnd();
    }
    if (rf & 2) {
      \u0275\u0275advance(2);
      \u0275\u0275classProp("form-floating", ctx.props.labelPosition === "floating")("has-error", ctx.showError);
      \u0275\u0275advance();
      \u0275\u0275property("ngIf", ctx.props.labelPosition !== "floating");
      \u0275\u0275advance(3);
      \u0275\u0275property("ngIf", ctx.props.labelPosition === "floating");
      \u0275\u0275advance();
      \u0275\u0275property("ngIf", ctx.showError);
      \u0275\u0275advance();
      \u0275\u0275property("ngIf", ctx.props.description);
    }
  },
  dependencies: [FormlyValidationMessage, NgIf, NgTemplateOutlet],
  encapsulation: 2
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyWrapperFormField, [{
    type: Component,
    args: [{
      selector: "formly-wrapper-form-field",
      template: `
    <ng-template #labelTemplate>
      <label *ngIf="props.label && props.hideLabel !== true" [attr.for]="id" class="form-label">
        {{ props.label }}
        <span *ngIf="props.required && props.hideRequiredMarker !== true" aria-hidden="true">*</span>
      </label>
    </ng-template>

    <div class="mb-3" [class.form-floating]="props.labelPosition === 'floating'" [class.has-error]="showError">
      <ng-container *ngIf="props.labelPosition !== 'floating'">
        <ng-container [ngTemplateOutlet]="labelTemplate"></ng-container>
      </ng-container>

      <ng-template #fieldComponent></ng-template>

      <ng-container *ngIf="props.labelPosition === 'floating'">
        <ng-container [ngTemplateOutlet]="labelTemplate"></ng-container>
      </ng-container>

      <div *ngIf="showError" class="invalid-feedback" [style.display]="'block'">
        <formly-validation-message
          id="{{ id }}-formly-validation-error"
          [field]="field"
          role="alert"
        ></formly-validation-message>
      </div>

      <small *ngIf="props.description" class="form-text text-muted">{{ props.description }}</small>
    </div>
  `
    }]
  }], null, null);
})();
var FormlyBootstrapFormFieldModule = class {
};
FormlyBootstrapFormFieldModule.\u0275fac = function FormlyBootstrapFormFieldModule_Factory(t) {
  return new (t || FormlyBootstrapFormFieldModule)();
};
FormlyBootstrapFormFieldModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapFormFieldModule
});
FormlyBootstrapFormFieldModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule, ReactiveFormsModule, FormlyModule.forChild({
    wrappers: [{
      name: "form-field",
      component: FormlyWrapperFormField
    }]
  })]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapFormFieldModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyWrapperFormField],
      imports: [CommonModule, ReactiveFormsModule, FormlyModule.forChild({
        wrappers: [{
          name: "form-field",
          component: FormlyWrapperFormField
        }]
      })]
    }]
  }], null, null);
})();
var FieldType2 = class extends FieldType {
  constructor(hostContainerRef) {
    super();
    this.hostContainerRef = hostContainerRef;
  }
  set content(templateRef) {
    if (templateRef && this.hostContainerRef) {
      this.hostContainerRef.createEmbeddedView(templateRef);
    }
  }
};
FieldType2.\u0275fac = function FieldType_Factory2(t) {
  return new (t || FieldType2)(\u0275\u0275directiveInject(ViewContainerRef, 8));
};
FieldType2.\u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
  type: FieldType2,
  viewQuery: function FieldType_Query2(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275viewQuery(_c02, 7);
    }
    if (rf & 2) {
      let _t;
      \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.content = _t.first);
    }
  },
  features: [\u0275\u0275InheritDefinitionFeature]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FieldType2, [{
    type: Directive
  }], function() {
    return [{
      type: ViewContainerRef,
      decorators: [{
        type: Optional
      }]
    }];
  }, {
    content: [{
      type: ViewChild,
      args: ["fieldTypeTemplate", {
        static: true
      }]
    }]
  });
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap-input.mjs
function FormlyFieldInput_ng_template_0_input_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "input", 3);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("is-invalid", ctx_r0.showError);
    \u0275\u0275property("type", ctx_r0.type)("formControl", ctx_r0.formControl)("formlyAttributes", ctx_r0.field);
    \u0275\u0275attribute("aria-describedby", ctx_r0.id + "-formly-validation-error")("aria-invalid", ctx_r0.showError);
  }
}
function FormlyFieldInput_ng_template_0_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "input", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("is-invalid", ctx_r0.showError);
    \u0275\u0275property("formControl", ctx_r0.formControl)("formlyAttributes", ctx_r0.field);
    \u0275\u0275attribute("aria-describedby", ctx_r0.id + "-formly-validation-error")("aria-invalid", ctx_r0.showError);
  }
}
function FormlyFieldInput_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, FormlyFieldInput_ng_template_0_input_0_Template, 1, 7, "input", 2)(1, FormlyFieldInput_ng_template_0_ng_template_1_Template, 1, 6, "ng-template", null, 1, \u0275\u0275templateRefExtractor);
  }
  if (rf & 2) {
    const numberTmp_r2 = \u0275\u0275reference(2);
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("ngIf", ctx_r0.type !== "number")("ngIfElse", numberTmp_r2);
  }
}
var FormlyFieldInput = class extends FieldType2 {
  get type() {
    return this.props.type || "text";
  }
};
FormlyFieldInput.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyFieldInput_BaseFactory;
  return function FormlyFieldInput_Factory(t) {
    return (\u0275FormlyFieldInput_BaseFactory || (\u0275FormlyFieldInput_BaseFactory = \u0275\u0275getInheritedFactory(FormlyFieldInput)))(t || FormlyFieldInput);
  };
})();
FormlyFieldInput.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyFieldInput,
  selectors: [["formly-field-input"]],
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 2,
  vars: 0,
  consts: [["fieldTypeTemplate", ""], ["numberTmp", ""], ["class", "form-control", 3, "type", "formControl", "formlyAttributes", "is-invalid", 4, "ngIf", "ngIfElse"], [1, "form-control", 3, "type", "formControl", "formlyAttributes"], ["type", "number", 1, "form-control", 3, "formControl", "formlyAttributes"]],
  template: function FormlyFieldInput_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyFieldInput_ng_template_0_Template, 3, 2, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    }
  },
  dependencies: [NgIf, DefaultValueAccessor, NgControlStatus, FormControlDirective, FormlyAttributes, NumberValueAccessor],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyFieldInput, [{
    type: Component,
    args: [{
      selector: "formly-field-input",
      template: `
    <ng-template #fieldTypeTemplate>
      <input
        *ngIf="type !== 'number'; else numberTmp"
        [type]="type"
        [formControl]="formControl"
        class="form-control"
        [formlyAttributes]="field"
        [class.is-invalid]="showError"
        [attr.aria-describedby]="id + '-formly-validation-error'"
        [attr.aria-invalid]="showError"
      />
      <ng-template #numberTmp>
        <input
          type="number"
          [formControl]="formControl"
          class="form-control"
          [formlyAttributes]="field"
          [class.is-invalid]="showError"
          [attr.aria-describedby]="id + '-formly-validation-error'"
          [attr.aria-invalid]="showError"
        />
      </ng-template>
    </ng-template>
  `,
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], null, null);
})();
var FormlyBootstrapInputModule = class {
};
FormlyBootstrapInputModule.\u0275fac = function FormlyBootstrapInputModule_Factory(t) {
  return new (t || FormlyBootstrapInputModule)();
};
FormlyBootstrapInputModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapInputModule
});
FormlyBootstrapInputModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlyModule.forChild({
    types: [{
      name: "input",
      component: FormlyFieldInput,
      wrappers: ["form-field"]
    }, {
      name: "string",
      extends: "input"
    }, {
      name: "number",
      extends: "input",
      defaultOptions: {
        props: {
          type: "number"
        }
      }
    }, {
      name: "integer",
      extends: "input",
      defaultOptions: {
        props: {
          type: "number"
        }
      }
    }]
  })]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapInputModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyFieldInput],
      imports: [CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlyModule.forChild({
        types: [{
          name: "input",
          component: FormlyFieldInput,
          wrappers: ["form-field"]
        }, {
          name: "string",
          extends: "input"
        }, {
          name: "number",
          extends: "input",
          defaultOptions: {
            props: {
              type: "number"
            }
          }
        }, {
          name: "integer",
          extends: "input",
          defaultOptions: {
            props: {
              type: "number"
            }
          }
        }]
      })]
    }]
  }], null, null);
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap-textarea.mjs
function FormlyFieldTextArea_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "textarea", 1);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classProp("is-invalid", ctx_r0.showError);
    \u0275\u0275property("formControl", ctx_r0.formControl)("cols", ctx_r0.props.cols)("rows", ctx_r0.props.rows)("formlyAttributes", ctx_r0.field);
    \u0275\u0275attribute("aria-describedby", ctx_r0.id + "-formly-validation-error")("aria-invalid", ctx_r0.showError);
  }
}
var FormlyFieldTextArea = class extends FieldType2 {
  constructor() {
    super(...arguments);
    this.defaultOptions = {
      props: {
        cols: 1,
        rows: 1
      }
    };
  }
};
FormlyFieldTextArea.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyFieldTextArea_BaseFactory;
  return function FormlyFieldTextArea_Factory(t) {
    return (\u0275FormlyFieldTextArea_BaseFactory || (\u0275FormlyFieldTextArea_BaseFactory = \u0275\u0275getInheritedFactory(FormlyFieldTextArea)))(t || FormlyFieldTextArea);
  };
})();
FormlyFieldTextArea.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyFieldTextArea,
  selectors: [["formly-field-textarea"]],
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 2,
  vars: 0,
  consts: [["fieldTypeTemplate", ""], [1, "form-control", 3, "formControl", "cols", "rows", "formlyAttributes"]],
  template: function FormlyFieldTextArea_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyFieldTextArea_ng_template_0_Template, 1, 8, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    }
  },
  dependencies: [DefaultValueAccessor, NgControlStatus, FormControlDirective, FormlyAttributes],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyFieldTextArea, [{
    type: Component,
    args: [{
      selector: "formly-field-textarea",
      template: `
    <ng-template #fieldTypeTemplate>
      <textarea
        [formControl]="formControl"
        [cols]="props.cols"
        [rows]="props.rows"
        class="form-control"
        [class.is-invalid]="showError"
        [formlyAttributes]="field"
        [attr.aria-describedby]="id + '-formly-validation-error'"
        [attr.aria-invalid]="showError"
      ></textarea>
    </ng-template>
  `,
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], null, null);
})();
var FormlyBootstrapTextAreaModule = class {
};
FormlyBootstrapTextAreaModule.\u0275fac = function FormlyBootstrapTextAreaModule_Factory(t) {
  return new (t || FormlyBootstrapTextAreaModule)();
};
FormlyBootstrapTextAreaModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapTextAreaModule
});
FormlyBootstrapTextAreaModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlyModule.forChild({
    types: [{
      name: "textarea",
      component: FormlyFieldTextArea,
      wrappers: ["form-field"]
    }]
  })]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapTextAreaModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyFieldTextArea],
      imports: [CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlyModule.forChild({
        types: [{
          name: "textarea",
          component: FormlyFieldTextArea,
          wrappers: ["form-field"]
        }]
      })]
    }]
  }], null, null);
})();

// node_modules/@ngx-formly/core/fesm2020/ngx-formly-core-select.mjs
var FormlySelectOptionsPipe = class {
  transform(options, field) {
    if (!(options instanceof Observable)) {
      options = this.observableOf(options, field);
    } else {
      this.dispose();
    }
    return options.pipe(map((value) => this.transformOptions(value, field)));
  }
  ngOnDestroy() {
    this.dispose();
  }
  transformOptions(options, field) {
    const to = this.transformSelectProps(field);
    const opts = [];
    const groups = {};
    options?.forEach((option) => {
      const o = this.transformOption(option, to);
      if (o.group) {
        const id = groups[o.label];
        if (id === void 0) {
          groups[o.label] = opts.push(o) - 1;
        } else {
          o.group.forEach((o2) => opts[id].group.push(o2));
        }
      } else {
        opts.push(o);
      }
    });
    return opts;
  }
  transformOption(option, props) {
    const group = props.groupProp(option);
    if (Array.isArray(group)) {
      return {
        label: props.labelProp(option),
        group: group.map((opt) => this.transformOption(opt, props))
      };
    }
    option = {
      label: props.labelProp(option),
      value: props.valueProp(option),
      disabled: !!props.disabledProp(option)
    };
    if (group) {
      return {
        label: group,
        group: [option]
      };
    }
    return option;
  }
  transformSelectProps(field) {
    const props = field?.props || field?.templateOptions || {};
    const selectPropFn = (prop) => typeof prop === "function" ? prop : (o) => o[prop];
    return {
      groupProp: selectPropFn(props.groupProp || "group"),
      labelProp: selectPropFn(props.labelProp || "label"),
      valueProp: selectPropFn(props.valueProp || "value"),
      disabledProp: selectPropFn(props.disabledProp || "disabled")
    };
  }
  dispose() {
    if (this._options) {
      this._options.complete();
      this._options = null;
    }
    if (this._subscription) {
      this._subscription.unsubscribe();
      this._subscription = null;
    }
  }
  observableOf(options, f) {
    this.dispose();
    if (f && f.options && f.options.fieldChanges) {
      this._subscription = f.options.fieldChanges.pipe(filter(({
        property,
        type,
        field
      }) => {
        return type === "expressionChanges" && (property.indexOf("templateOptions.options") === 0 || property.indexOf("props.options") === 0) && field === f && Array.isArray(field.props.options) && !!this._options;
      }), tap(() => this._options.next(f.props.options))).subscribe();
    }
    this._options = new BehaviorSubject(options);
    return this._options.asObservable();
  }
};
FormlySelectOptionsPipe.\u0275fac = function FormlySelectOptionsPipe_Factory(t) {
  return new (t || FormlySelectOptionsPipe)();
};
FormlySelectOptionsPipe.\u0275pipe = /* @__PURE__ */ \u0275\u0275definePipe({
  name: "formlySelectOptions",
  type: FormlySelectOptionsPipe,
  pure: true
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlySelectOptionsPipe, [{
    type: Pipe,
    args: [{
      name: "formlySelectOptions"
    }]
  }], null, null);
})();
var FormlySelectModule = class {
};
FormlySelectModule.\u0275fac = function FormlySelectModule_Factory(t) {
  return new (t || FormlySelectModule)();
};
FormlySelectModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlySelectModule
});
FormlySelectModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlySelectModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlySelectOptionsPipe],
      exports: [FormlySelectOptionsPipe]
    }]
  }], null, null);
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap-radio.mjs
function FormlyFieldRadio_ng_template_0_div_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 2);
    \u0275\u0275element(1, "input", 3);
    \u0275\u0275elementStart(2, "label", 4);
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const option_r1 = ctx.$implicit;
    const i_r2 = ctx.index;
    const ctx_r2 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("form-check-inline", ctx_r2.props.formCheck === "inline");
    \u0275\u0275advance();
    \u0275\u0275classProp("is-invalid", ctx_r2.showError);
    \u0275\u0275property("id", ctx_r2.id + "_" + i_r2)("name", ctx_r2.field.name || ctx_r2.id)("value", option_r1.value)("formControl", option_r1.disabled ? ctx_r2.disabledControl : ctx_r2.formControl)("formlyAttributes", ctx_r2.field);
    \u0275\u0275attribute("value", option_r1.value)("aria-describedby", ctx_r2.id + "-formly-validation-error")("aria-invalid", ctx_r2.showError);
    \u0275\u0275advance();
    \u0275\u0275property("for", ctx_r2.id + "_" + i_r2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", option_r1.label, " ");
  }
}
function FormlyFieldRadio_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, FormlyFieldRadio_ng_template_0_div_0_Template, 4, 14, "div", 1);
    \u0275\u0275pipe(1, "formlySelectOptions");
    \u0275\u0275pipe(2, "async");
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275property("ngForOf", \u0275\u0275pipeBind1(2, 4, \u0275\u0275pipeBind2(1, 1, ctx_r2.props.options, ctx_r2.field)));
  }
}
var FormlyFieldRadio = class extends FieldType2 {
  constructor() {
    super(...arguments);
    this.defaultOptions = {
      props: {
        formCheck: "default"
      }
    };
  }
  get disabledControl() {
    return new FormControl({
      value: this.formControl.value,
      disabled: true
    });
  }
};
FormlyFieldRadio.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyFieldRadio_BaseFactory;
  return function FormlyFieldRadio_Factory(t) {
    return (\u0275FormlyFieldRadio_BaseFactory || (\u0275FormlyFieldRadio_BaseFactory = \u0275\u0275getInheritedFactory(FormlyFieldRadio)))(t || FormlyFieldRadio);
  };
})();
FormlyFieldRadio.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyFieldRadio,
  selectors: [["formly-field-radio"]],
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 2,
  vars: 0,
  consts: [["fieldTypeTemplate", ""], ["class", "form-check", 3, "form-check-inline", 4, "ngFor", "ngForOf"], [1, "form-check"], ["type", "radio", 1, "form-check-input", 3, "id", "name", "value", "formControl", "formlyAttributes"], [1, "form-check-label", 3, "for"]],
  template: function FormlyFieldRadio_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyFieldRadio_ng_template_0_Template, 3, 6, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    }
  },
  dependencies: [NgForOf, RadioControlValueAccessor, DefaultValueAccessor, NgControlStatus, FormControlDirective, FormlyAttributes, AsyncPipe, FormlySelectOptionsPipe],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyFieldRadio, [{
    type: Component,
    args: [{
      selector: "formly-field-radio",
      template: `
    <ng-template #fieldTypeTemplate>
      <div
        *ngFor="let option of props.options | formlySelectOptions : field | async; let i = index"
        class="form-check"
        [class.form-check-inline]="props.formCheck === 'inline'"
      >
        <input
          type="radio"
          [id]="id + '_' + i"
          class="form-check-input"
          [name]="field.name || id"
          [class.is-invalid]="showError"
          [attr.value]="option.value"
          [value]="option.value"
          [formControl]="option.disabled ? disabledControl : formControl"
          [formlyAttributes]="field"
          [attr.aria-describedby]="id + '-formly-validation-error'"
          [attr.aria-invalid]="showError"
        />
        <label class="form-check-label" [for]="id + '_' + i">
          {{ option.label }}
        </label>
      </div>
    </ng-template>
  `,
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], null, null);
})();
var FormlyBootstrapRadioModule = class {
};
FormlyBootstrapRadioModule.\u0275fac = function FormlyBootstrapRadioModule_Factory(t) {
  return new (t || FormlyBootstrapRadioModule)();
};
FormlyBootstrapRadioModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapRadioModule
});
FormlyBootstrapRadioModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlySelectModule, FormlyModule.forChild({
    types: [{
      name: "radio",
      component: FormlyFieldRadio,
      wrappers: ["form-field"]
    }]
  })]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapRadioModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyFieldRadio],
      imports: [CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlySelectModule, FormlyModule.forChild({
        types: [{
          name: "radio",
          component: FormlyFieldRadio,
          wrappers: ["form-field"]
        }]
      })]
    }]
  }], null, null);
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap-checkbox.mjs
var _c03 = (a0, a1) => ({
  "form-check-inline": a0,
  "form-switch": a1
});
function FormlyFieldCheckbox_ng_template_0_label_2_span_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 6);
    \u0275\u0275text(1, "*");
    \u0275\u0275elementEnd();
  }
}
function FormlyFieldCheckbox_ng_template_0_label_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label", 4);
    \u0275\u0275text(1);
    \u0275\u0275template(2, FormlyFieldCheckbox_ng_template_0_label_2_span_2_Template, 2, 0, "span", 5);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("for", ctx_r0.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.props.label, " ");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.props.required && ctx_r0.props.hideRequiredMarker !== true);
  }
}
function FormlyFieldCheckbox_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 1);
    \u0275\u0275element(1, "input", 2);
    \u0275\u0275template(2, FormlyFieldCheckbox_ng_template_0_label_2_Template, 3, 3, "label", 3);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction2(11, _c03, ctx_r0.props.formCheck === "inline" || ctx_r0.props.formCheck === "inline-switch", ctx_r0.props.formCheck === "switch" || ctx_r0.props.formCheck === "inline-switch"));
    \u0275\u0275advance();
    \u0275\u0275classProp("is-invalid", ctx_r0.showError)("position-static", ctx_r0.props.formCheck === "nolabel");
    \u0275\u0275property("indeterminate", ctx_r0.props.indeterminate && ctx_r0.formControl.value == null)("formControl", ctx_r0.formControl)("formlyAttributes", ctx_r0.field);
    \u0275\u0275attribute("aria-describedby", ctx_r0.id + "-formly-validation-error")("aria-invalid", ctx_r0.showError);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.props.formCheck !== "nolabel");
  }
}
var FormlyFieldCheckbox = class extends FieldType2 {
  constructor() {
    super(...arguments);
    this.defaultOptions = {
      props: {
        indeterminate: true,
        hideLabel: true,
        formCheck: "default"
      }
    };
  }
};
FormlyFieldCheckbox.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyFieldCheckbox_BaseFactory;
  return function FormlyFieldCheckbox_Factory(t) {
    return (\u0275FormlyFieldCheckbox_BaseFactory || (\u0275FormlyFieldCheckbox_BaseFactory = \u0275\u0275getInheritedFactory(FormlyFieldCheckbox)))(t || FormlyFieldCheckbox);
  };
})();
FormlyFieldCheckbox.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyFieldCheckbox,
  selectors: [["formly-field-checkbox"]],
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 2,
  vars: 0,
  consts: [["fieldTypeTemplate", ""], [1, "form-check", 3, "ngClass"], ["type", "checkbox", 1, "form-check-input", 3, "indeterminate", "formControl", "formlyAttributes"], ["class", "form-check-label", 3, "for", 4, "ngIf"], [1, "form-check-label", 3, "for"], ["aria-hidden", "true", 4, "ngIf"], ["aria-hidden", "true"]],
  template: function FormlyFieldCheckbox_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyFieldCheckbox_ng_template_0_Template, 3, 14, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    }
  },
  dependencies: [NgClass, CheckboxControlValueAccessor, NgControlStatus, FormControlDirective, FormlyAttributes, NgIf],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyFieldCheckbox, [{
    type: Component,
    args: [{
      selector: "formly-field-checkbox",
      template: `
    <ng-template #fieldTypeTemplate>
      <div
        class="form-check"
        [ngClass]="{
          'form-check-inline': props.formCheck === 'inline' || props.formCheck === 'inline-switch',
          'form-switch': props.formCheck === 'switch' || props.formCheck === 'inline-switch'
        }"
      >
        <input
          type="checkbox"
          [class.is-invalid]="showError"
          class="form-check-input"
          [class.position-static]="props.formCheck === 'nolabel'"
          [indeterminate]="props.indeterminate && formControl.value == null"
          [formControl]="formControl"
          [formlyAttributes]="field"
          [attr.aria-describedby]="id + '-formly-validation-error'"
          [attr.aria-invalid]="showError"
        />
        <label *ngIf="props.formCheck !== 'nolabel'" [for]="id" class="form-check-label">
          {{ props.label }}
          <span *ngIf="props.required && props.hideRequiredMarker !== true" aria-hidden="true">*</span>
        </label>
      </div>
    </ng-template>
  `,
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], null, null);
})();
var FormlyBootstrapCheckboxModule = class {
};
FormlyBootstrapCheckboxModule.\u0275fac = function FormlyBootstrapCheckboxModule_Factory(t) {
  return new (t || FormlyBootstrapCheckboxModule)();
};
FormlyBootstrapCheckboxModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapCheckboxModule
});
FormlyBootstrapCheckboxModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlyModule.forChild({
    types: [{
      name: "checkbox",
      component: FormlyFieldCheckbox,
      wrappers: ["form-field"]
    }, {
      name: "boolean",
      extends: "checkbox"
    }]
  })]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapCheckboxModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyFieldCheckbox],
      imports: [CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlyModule.forChild({
        types: [{
          name: "checkbox",
          component: FormlyFieldCheckbox,
          wrappers: ["form-field"]
        }, {
          name: "boolean",
          extends: "checkbox"
        }]
      })]
    }]
  }], null, null);
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap-multicheckbox.mjs
var _c04 = (a0, a1) => ({
  "form-check-inline": a0,
  "form-switch": a1
});
function FormlyFieldMultiCheckbox_ng_template_0_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 2)(1, "input", 3);
    \u0275\u0275listener("change", function FormlyFieldMultiCheckbox_ng_template_0_div_0_Template_input_change_1_listener($event) {
      const option_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r2.onChange(option_r2.value, $event.target.checked));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(2, "label", 4);
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const option_r2 = ctx.$implicit;
    const i_r4 = ctx.index;
    const ctx_r2 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction2(12, _c04, ctx_r2.props.formCheck === "inline" || ctx_r2.props.formCheck === "inline-switch", ctx_r2.props.formCheck === "switch" || ctx_r2.props.formCheck === "inline-switch"));
    \u0275\u0275advance();
    \u0275\u0275classProp("is-invalid", ctx_r2.showError);
    \u0275\u0275property("id", ctx_r2.id + "_" + i_r4)("value", option_r2.value)("checked", ctx_r2.isChecked(option_r2))("formlyAttributes", ctx_r2.field)("disabled", ctx_r2.formControl.disabled || option_r2.disabled);
    \u0275\u0275attribute("aria-describedby", ctx_r2.id + "-formly-validation-error")("aria-invalid", ctx_r2.showError);
    \u0275\u0275advance();
    \u0275\u0275property("for", ctx_r2.id + "_" + i_r4);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", option_r2.label, " ");
  }
}
function FormlyFieldMultiCheckbox_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, FormlyFieldMultiCheckbox_ng_template_0_div_0_Template, 4, 15, "div", 1);
    \u0275\u0275pipe(1, "formlySelectOptions");
    \u0275\u0275pipe(2, "async");
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275property("ngForOf", \u0275\u0275pipeBind1(2, 4, \u0275\u0275pipeBind2(1, 1, ctx_r2.props.options, ctx_r2.field)));
  }
}
var FormlyFieldMultiCheckbox = class extends FieldType2 {
  constructor() {
    super(...arguments);
    this.defaultOptions = {
      props: {
        formCheck: "default"
        // 'default' | 'inline' | 'switch' | 'inline-switch'
      }
    };
  }
  onChange(value, checked) {
    this.formControl.markAsDirty();
    if (this.props.type === "array") {
      this.formControl.patchValue(checked ? [...this.formControl.value || [], value] : [...this.formControl.value || []].filter((o) => o !== value));
    } else {
      this.formControl.patchValue(__spreadProps(__spreadValues({}, this.formControl.value), {
        [value]: checked
      }));
    }
    this.formControl.markAsTouched();
  }
  isChecked(option) {
    const value = this.formControl.value;
    return value && (this.props.type === "array" ? value.indexOf(option.value) !== -1 : value[option.value]);
  }
};
FormlyFieldMultiCheckbox.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyFieldMultiCheckbox_BaseFactory;
  return function FormlyFieldMultiCheckbox_Factory(t) {
    return (\u0275FormlyFieldMultiCheckbox_BaseFactory || (\u0275FormlyFieldMultiCheckbox_BaseFactory = \u0275\u0275getInheritedFactory(FormlyFieldMultiCheckbox)))(t || FormlyFieldMultiCheckbox);
  };
})();
FormlyFieldMultiCheckbox.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyFieldMultiCheckbox,
  selectors: [["formly-field-multicheckbox"]],
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 2,
  vars: 0,
  consts: [["fieldTypeTemplate", ""], ["class", "form-check", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "form-check", 3, "ngClass"], ["type", "checkbox", 1, "form-check-input", 3, "change", "id", "value", "checked", "formlyAttributes", "disabled"], [1, "form-check-label", 3, "for"]],
  template: function FormlyFieldMultiCheckbox_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyFieldMultiCheckbox_ng_template_0_Template, 3, 6, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    }
  },
  dependencies: [NgForOf, NgClass, FormlyAttributes, AsyncPipe, FormlySelectOptionsPipe],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyFieldMultiCheckbox, [{
    type: Component,
    args: [{
      selector: "formly-field-multicheckbox",
      template: `
    <ng-template #fieldTypeTemplate>
      <div
        *ngFor="let option of props.options | formlySelectOptions : field | async; let i = index"
        class="form-check"
        [ngClass]="{
          'form-check-inline': props.formCheck === 'inline' || props.formCheck === 'inline-switch',
          'form-switch': props.formCheck === 'switch' || props.formCheck === 'inline-switch'
        }"
      >
        <input
          type="checkbox"
          [id]="id + '_' + i"
          class="form-check-input"
          [class.is-invalid]="showError"
          [value]="option.value"
          [checked]="isChecked(option)"
          [formlyAttributes]="field"
          [disabled]="formControl.disabled || option.disabled"
          [attr.aria-describedby]="id + '-formly-validation-error'"
          [attr.aria-invalid]="showError"
          (change)="onChange(option.value, $any($event.target).checked)"
        />
        <label class="form-check-label" [for]="id + '_' + i">
          {{ option.label }}
        </label>
      </div>
    </ng-template>
  `,
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], null, null);
})();
var FormlyBootstrapMultiCheckboxModule = class {
};
FormlyBootstrapMultiCheckboxModule.\u0275fac = function FormlyBootstrapMultiCheckboxModule_Factory(t) {
  return new (t || FormlyBootstrapMultiCheckboxModule)();
};
FormlyBootstrapMultiCheckboxModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapMultiCheckboxModule
});
FormlyBootstrapMultiCheckboxModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlySelectModule, FormlyModule.forChild({
    types: [{
      name: "multicheckbox",
      component: FormlyFieldMultiCheckbox,
      wrappers: ["form-field"]
    }]
  })]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapMultiCheckboxModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyFieldMultiCheckbox],
      imports: [CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlySelectModule, FormlyModule.forChild({
        types: [{
          name: "multicheckbox",
          component: FormlyFieldMultiCheckbox,
          wrappers: ["form-field"]
        }]
      })]
    }]
  }], null, null);
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap-select.mjs
function FormlyFieldSelect_ng_template_0_select_0_ng_container_1_ng_container_1_option_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 8);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const opt_r1 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("ngValue", opt_r1.value)("disabled", opt_r1.disabled);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", opt_r1.label, " ");
  }
}
function FormlyFieldSelect_ng_template_0_select_0_ng_container_1_ng_container_1_ng_template_2_option_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 8);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const child_r2 = ctx.$implicit;
    \u0275\u0275property("ngValue", child_r2.value)("disabled", child_r2.disabled);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", child_r2.label, " ");
  }
}
function FormlyFieldSelect_ng_template_0_select_0_ng_container_1_ng_container_1_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "optgroup", 9);
    \u0275\u0275template(1, FormlyFieldSelect_ng_template_0_select_0_ng_container_1_ng_container_1_ng_template_2_option_1_Template, 2, 3, "option", 10);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const opt_r1 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("label", opt_r1.label);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", opt_r1.group);
  }
}
function FormlyFieldSelect_ng_template_0_select_0_ng_container_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, FormlyFieldSelect_ng_template_0_select_0_ng_container_1_ng_container_1_option_1_Template, 2, 3, "option", 7)(2, FormlyFieldSelect_ng_template_0_select_0_ng_container_1_ng_container_1_ng_template_2_Template, 2, 2, "ng-template", null, 2, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const opt_r1 = ctx.$implicit;
    const optgroup_r3 = \u0275\u0275reference(3);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !opt_r1.group)("ngIfElse", optgroup_r3);
  }
}
function FormlyFieldSelect_ng_template_0_select_0_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, FormlyFieldSelect_ng_template_0_select_0_ng_container_1_ng_container_1_Template, 4, 2, "ng-container", 6);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const opts_r4 = ctx.ngIf;
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", opts_r4);
  }
}
function FormlyFieldSelect_ng_template_0_select_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "select", 4);
    \u0275\u0275template(1, FormlyFieldSelect_ng_template_0_select_0_ng_container_1_Template, 2, 1, "ng-container", 5);
    \u0275\u0275pipe(2, "formlySelectOptions");
    \u0275\u0275pipe(3, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r4 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("is-invalid", ctx_r4.showError);
    \u0275\u0275property("formControl", ctx_r4.formControl)("compareWith", ctx_r4.props.compareWith)("formlyAttributes", ctx_r4.field);
    \u0275\u0275attribute("aria-describedby", ctx_r4.id + "-formly-validation-error")("aria-invalid", ctx_r4.showError);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", \u0275\u0275pipeBind1(3, 11, \u0275\u0275pipeBind2(2, 8, ctx_r4.props.options, ctx_r4.field)));
  }
}
function FormlyFieldSelect_ng_template_0_ng_template_1_option_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 13);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r4 = \u0275\u0275nextContext(3);
    \u0275\u0275property("ngValue", void 0);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(ctx_r4.props.placeholder);
  }
}
function FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_ng_container_1_option_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 8);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const opt_r6 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("ngValue", opt_r6.value)("disabled", opt_r6.disabled);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", opt_r6.label, " ");
  }
}
function FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_ng_container_1_ng_template_2_option_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 8);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const child_r7 = ctx.$implicit;
    \u0275\u0275property("ngValue", child_r7.value)("disabled", child_r7.disabled);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", child_r7.label, " ");
  }
}
function FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_ng_container_1_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "optgroup", 9);
    \u0275\u0275template(1, FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_ng_container_1_ng_template_2_option_1_Template, 2, 3, "option", 10);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const opt_r6 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("label", opt_r6.label);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", opt_r6.group);
  }
}
function FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_ng_container_1_option_1_Template, 2, 3, "option", 7)(2, FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_ng_container_1_ng_template_2_Template, 2, 2, "ng-template", null, 2, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const opt_r6 = ctx.$implicit;
    const optgroup_r8 = \u0275\u0275reference(3);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !opt_r6.group)("ngIfElse", optgroup_r8);
  }
}
function FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_ng_container_1_Template, 4, 2, "ng-container", 6);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const opts_r9 = ctx.ngIf;
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", opts_r9);
  }
}
function FormlyFieldSelect_ng_template_0_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "select", 11);
    \u0275\u0275template(1, FormlyFieldSelect_ng_template_0_ng_template_1_option_1_Template, 2, 2, "option", 12)(2, FormlyFieldSelect_ng_template_0_ng_template_1_ng_container_2_Template, 2, 1, "ng-container", 5);
    \u0275\u0275pipe(3, "formlySelectOptions");
    \u0275\u0275pipe(4, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r4 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("is-invalid", ctx_r4.showError);
    \u0275\u0275property("formControl", ctx_r4.formControl)("compareWith", ctx_r4.props.compareWith)("formlyAttributes", ctx_r4.field);
    \u0275\u0275attribute("aria-describedby", ctx_r4.id + "-formly-validation-error")("aria-invalid", ctx_r4.showError);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r4.props.placeholder);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", \u0275\u0275pipeBind1(4, 12, \u0275\u0275pipeBind2(3, 9, ctx_r4.props.options, ctx_r4.field)));
  }
}
function FormlyFieldSelect_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, FormlyFieldSelect_ng_template_0_select_0_Template, 4, 13, "select", 3)(1, FormlyFieldSelect_ng_template_0_ng_template_1_Template, 5, 14, "ng-template", null, 1, \u0275\u0275templateRefExtractor);
  }
  if (rf & 2) {
    const singleSelect_r10 = \u0275\u0275reference(2);
    const ctx_r4 = \u0275\u0275nextContext();
    \u0275\u0275property("ngIf", ctx_r4.props.multiple)("ngIfElse", singleSelect_r10);
  }
}
var FormlyFieldSelect = class extends FieldType2 {
  constructor(ngZone, hostContainerRef) {
    super(hostContainerRef);
    this.ngZone = ngZone;
    this.defaultOptions = {
      props: {
        compareWith(o1, o2) {
          return o1 === o2;
        }
      }
    };
  }
  // workaround for https://github.com/angular/angular/issues/10010
  /**
   * TODO: Check if this is still needed
   */
  set selectAccessor(s) {
    if (!s) {
      return;
    }
    const writeValue = s.writeValue.bind(s);
    if (s._getOptionId(s.value) === null) {
      writeValue(s.value);
    }
    s.writeValue = (value) => {
      const id = s._idCounter;
      writeValue(value);
      if (value === null) {
        this.ngZone.onStable.asObservable().pipe(take(1)).subscribe(() => {
          if (id !== s._idCounter && s._getOptionId(value) === null && s._elementRef.nativeElement.selectedIndex !== -1) {
            writeValue(value);
          }
        });
      }
    };
  }
};
FormlyFieldSelect.\u0275fac = function FormlyFieldSelect_Factory(t) {
  return new (t || FormlyFieldSelect)(\u0275\u0275directiveInject(NgZone), \u0275\u0275directiveInject(ViewContainerRef));
};
FormlyFieldSelect.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyFieldSelect,
  selectors: [["formly-field-select"]],
  viewQuery: function FormlyFieldSelect_Query(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275viewQuery(SelectControlValueAccessor, 5);
    }
    if (rf & 2) {
      let _t;
      \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.selectAccessor = _t.first);
    }
  },
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 2,
  vars: 0,
  consts: [["fieldTypeTemplate", ""], ["singleSelect", ""], ["optgroup", ""], ["class", "form-select", "multiple", "", 3, "formControl", "compareWith", "is-invalid", "formlyAttributes", 4, "ngIf", "ngIfElse"], ["multiple", "", 1, "form-select", 3, "formControl", "compareWith", "formlyAttributes"], [4, "ngIf"], [4, "ngFor", "ngForOf"], [3, "ngValue", "disabled", 4, "ngIf", "ngIfElse"], [3, "ngValue", "disabled"], [3, "label"], [3, "ngValue", "disabled", 4, "ngFor", "ngForOf"], [1, "form-select", 3, "formControl", "compareWith", "formlyAttributes"], [3, "ngValue", 4, "ngIf"], [3, "ngValue"]],
  template: function FormlyFieldSelect_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyFieldSelect_ng_template_0_Template, 3, 2, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    }
  },
  dependencies: [NgIf, SelectMultipleControlValueAccessor, NgControlStatus, FormControlDirective, FormlyAttributes, NgForOf, NgSelectOption, \u0275NgSelectMultipleOption, SelectControlValueAccessor, AsyncPipe, FormlySelectOptionsPipe],
  encapsulation: 2,
  changeDetection: 0
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyFieldSelect, [{
    type: Component,
    args: [{
      selector: "formly-field-select",
      template: `
    <ng-template #fieldTypeTemplate>
      <select
        *ngIf="props.multiple; else singleSelect"
        class="form-select"
        multiple
        [formControl]="formControl"
        [compareWith]="props.compareWith"
        [class.is-invalid]="showError"
        [formlyAttributes]="field"
        [attr.aria-describedby]="id + '-formly-validation-error'"
        [attr.aria-invalid]="showError"
      >
        <ng-container *ngIf="props.options | formlySelectOptions : field | async as opts">
          <ng-container *ngFor="let opt of opts">
            <option *ngIf="!opt.group; else optgroup" [ngValue]="opt.value" [disabled]="opt.disabled">
              {{ opt.label }}
            </option>
            <ng-template #optgroup>
              <optgroup [label]="opt.label">
                <option *ngFor="let child of opt.group" [ngValue]="child.value" [disabled]="child.disabled">
                  {{ child.label }}
                </option>
              </optgroup>
            </ng-template>
          </ng-container>
        </ng-container>
      </select>

      <ng-template #singleSelect>
        <select
          class="form-select"
          [formControl]="formControl"
          [compareWith]="props.compareWith"
          [class.is-invalid]="showError"
          [formlyAttributes]="field"
          [attr.aria-describedby]="id + '-formly-validation-error'"
          [attr.aria-invalid]="showError"
        >
          <option *ngIf="props.placeholder" [ngValue]="undefined">{{ props.placeholder }}</option>
          <ng-container *ngIf="props.options | formlySelectOptions : field | async as opts">
            <ng-container *ngFor="let opt of opts">
              <option *ngIf="!opt.group; else optgroup" [ngValue]="opt.value" [disabled]="opt.disabled">
                {{ opt.label }}
              </option>
              <ng-template #optgroup>
                <optgroup [label]="opt.label">
                  <option *ngFor="let child of opt.group" [ngValue]="child.value" [disabled]="child.disabled">
                    {{ child.label }}
                  </option>
                </optgroup>
              </ng-template>
            </ng-container>
          </ng-container>
        </select>
      </ng-template>
    </ng-template>
  `,
      changeDetection: ChangeDetectionStrategy.OnPush
    }]
  }], function() {
    return [{
      type: NgZone
    }, {
      type: ViewContainerRef
    }];
  }, {
    selectAccessor: [{
      type: ViewChild,
      args: [SelectControlValueAccessor]
    }]
  });
})();
var FormlyBootstrapSelectModule = class {
};
FormlyBootstrapSelectModule.\u0275fac = function FormlyBootstrapSelectModule_Factory(t) {
  return new (t || FormlyBootstrapSelectModule)();
};
FormlyBootstrapSelectModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapSelectModule
});
FormlyBootstrapSelectModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlySelectModule, FormlyModule.forChild({
    types: [{
      name: "select",
      component: FormlyFieldSelect,
      wrappers: ["form-field"]
    }, {
      name: "enum",
      extends: "select"
    }]
  })]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapSelectModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyFieldSelect],
      imports: [CommonModule, ReactiveFormsModule, FormlyBootstrapFormFieldModule, FormlySelectModule, FormlyModule.forChild({
        types: [{
          name: "select",
          component: FormlyFieldSelect,
          wrappers: ["form-field"]
        }, {
          name: "enum",
          extends: "select"
        }]
      })]
    }]
  }], null, null);
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap-addons.mjs
var _c05 = ["fieldTypeTemplate"];
function FormlyWrapperAddons_ng_template_0_div_1_i_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 7);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275property("ngClass", ctx_r1.props.addonLeft.class);
  }
}
function FormlyWrapperAddons_ng_template_0_div_1_span_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(ctx_r1.props.addonLeft.text);
  }
}
function FormlyWrapperAddons_ng_template_0_div_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 4);
    \u0275\u0275listener("click", function FormlyWrapperAddons_ng_template_0_div_1_Template_div_click_0_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.addonLeftClick($event));
    });
    \u0275\u0275template(1, FormlyWrapperAddons_ng_template_0_div_1_i_1_Template, 1, 1, "i", 5)(2, FormlyWrapperAddons_ng_template_0_div_1_span_2_Template, 2, 1, "span", 6);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("input-group-btn", ctx_r1.props.addonLeft.onClick);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.props.addonLeft.class);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.props.addonLeft.text);
  }
}
function FormlyWrapperAddons_ng_template_0_div_4_i_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 7);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275property("ngClass", ctx_r1.props.addonRight.class);
  }
}
function FormlyWrapperAddons_ng_template_0_div_4_span_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(ctx_r1.props.addonRight.text);
  }
}
function FormlyWrapperAddons_ng_template_0_div_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 4);
    \u0275\u0275listener("click", function FormlyWrapperAddons_ng_template_0_div_4_Template_div_click_0_listener($event) {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.addonRightClick($event));
    });
    \u0275\u0275template(1, FormlyWrapperAddons_ng_template_0_div_4_i_1_Template, 1, 1, "i", 5)(2, FormlyWrapperAddons_ng_template_0_div_4_span_2_Template, 2, 1, "span", 6);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("input-group-btn", ctx_r1.props.addonRight.onClick);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.props.addonRight.class);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.props.addonRight.text);
  }
}
function FormlyWrapperAddons_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 2);
    \u0275\u0275template(1, FormlyWrapperAddons_ng_template_0_div_1_Template, 3, 4, "div", 3);
    \u0275\u0275elementContainer(2, null, 1);
    \u0275\u0275template(4, FormlyWrapperAddons_ng_template_0_div_4_Template, 3, 4, "div", 3);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("has-validation", ctx_r1.showError);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.props.addonLeft);
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", ctx_r1.props.addonRight);
  }
}
var FormlyWrapperAddons = class extends FieldWrapper {
  constructor(hostContainerRef) {
    super();
    this.hostContainerRef = hostContainerRef;
  }
  set content(templateRef) {
    if (templateRef && this.hostContainerRef) {
      this.hostContainerRef.createEmbeddedView(templateRef);
    }
  }
  addonRightClick($event) {
    this.props.addonRight.onClick?.(this.field, $event);
  }
  addonLeftClick($event) {
    this.props.addonLeft.onClick?.(this.field, $event);
  }
};
FormlyWrapperAddons.\u0275fac = function FormlyWrapperAddons_Factory(t) {
  return new (t || FormlyWrapperAddons)(\u0275\u0275directiveInject(ViewContainerRef));
};
FormlyWrapperAddons.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: FormlyWrapperAddons,
  selectors: [["formly-wrapper-addons"]],
  viewQuery: function FormlyWrapperAddons_Query(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275viewQuery(_c05, 7);
    }
    if (rf & 2) {
      let _t;
      \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.content = _t.first);
    }
  },
  features: [\u0275\u0275InheritDefinitionFeature],
  decls: 2,
  vars: 0,
  consts: [["fieldTypeTemplate", ""], ["fieldComponent", ""], [1, "input-group"], ["class", "input-group-text", 3, "input-group-btn", "click", 4, "ngIf"], [1, "input-group-text", 3, "click"], [3, "ngClass", 4, "ngIf"], [4, "ngIf"], [3, "ngClass"]],
  template: function FormlyWrapperAddons_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275template(0, FormlyWrapperAddons_ng_template_0_Template, 5, 4, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    }
  },
  dependencies: [NgIf, NgClass],
  styles: ["formly-wrapper-form-field .input-group-btn{cursor:pointer}\n"],
  encapsulation: 2
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyWrapperAddons, [{
    type: Component,
    args: [{
      selector: "formly-wrapper-addons",
      encapsulation: ViewEncapsulation$1.None,
      template: '<ng-template #fieldTypeTemplate>\n  <div class="input-group" [class.has-validation]="showError">\n    <div\n      class="input-group-text"\n      *ngIf="props.addonLeft"\n      [class.input-group-btn]="props.addonLeft.onClick"\n      (click)="addonLeftClick($event)"\n    >\n      <i [ngClass]="props.addonLeft.class" *ngIf="props.addonLeft.class"></i>\n      <span *ngIf="props.addonLeft.text">{{ props.addonLeft.text }}</span>\n    </div>\n    <ng-container #fieldComponent></ng-container>\n    <div\n      class="input-group-text"\n      *ngIf="props.addonRight"\n      [class.input-group-btn]="props.addonRight.onClick"\n      (click)="addonRightClick($event)"\n    >\n      <i [ngClass]="props.addonRight.class" *ngIf="props.addonRight.class"></i>\n      <span *ngIf="props.addonRight.text">{{ props.addonRight.text }}</span>\n    </div>\n  </div>\n</ng-template>\n',
      styles: ["formly-wrapper-form-field .input-group-btn{cursor:pointer}\n"]
    }]
  }], function() {
    return [{
      type: ViewContainerRef
    }];
  }, {
    content: [{
      type: ViewChild,
      args: ["fieldTypeTemplate", {
        static: true
      }]
    }]
  });
})();
function addonsExtension(field) {
  if (!field.props || field.wrappers && field.wrappers.indexOf("addons") !== -1) {
    return;
  }
  if (field.props.addonLeft || field.props.addonRight) {
    field.wrappers = [...field.wrappers || [], "addons"];
  }
}
var FormlyBootstrapAddonsModule = class {
};
FormlyBootstrapAddonsModule.\u0275fac = function FormlyBootstrapAddonsModule_Factory(t) {
  return new (t || FormlyBootstrapAddonsModule)();
};
FormlyBootstrapAddonsModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapAddonsModule
});
FormlyBootstrapAddonsModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[CommonModule, ReactiveFormsModule, FormlyModule.forChild({
    wrappers: [{
      name: "addons",
      component: FormlyWrapperAddons
    }],
    extensions: [{
      name: "addons",
      extension: {
        postPopulate: addonsExtension
      }
    }]
  })]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapAddonsModule, [{
    type: NgModule,
    args: [{
      declarations: [FormlyWrapperAddons],
      imports: [CommonModule, ReactiveFormsModule, FormlyModule.forChild({
        wrappers: [{
          name: "addons",
          component: FormlyWrapperAddons
        }],
        extensions: [{
          name: "addons",
          extension: {
            postPopulate: addonsExtension
          }
        }]
      })]
    }]
  }], null, null);
})();

// node_modules/@ngx-formly/bootstrap/fesm2020/ngx-formly-bootstrap.mjs
var FormlyBootstrapModule = class {
};
FormlyBootstrapModule.\u0275fac = function FormlyBootstrapModule_Factory(t) {
  return new (t || FormlyBootstrapModule)();
};
FormlyBootstrapModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyBootstrapModule
});
FormlyBootstrapModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  imports: [[FormlyBootstrapFormFieldModule, FormlyBootstrapInputModule, FormlyBootstrapTextAreaModule, FormlyBootstrapRadioModule, FormlyBootstrapCheckboxModule, FormlyBootstrapMultiCheckboxModule, FormlyBootstrapSelectModule, FormlyBootstrapAddonsModule]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyBootstrapModule, [{
    type: NgModule,
    args: [{
      imports: [FormlyBootstrapFormFieldModule, FormlyBootstrapInputModule, FormlyBootstrapTextAreaModule, FormlyBootstrapRadioModule, FormlyBootstrapCheckboxModule, FormlyBootstrapMultiCheckboxModule, FormlyBootstrapSelectModule, FormlyBootstrapAddonsModule]
    }]
  }], null, null);
})();

// src/app/@lcp-framework/pipes/split-label.pipe.ts
var _SplitLabelPipe = class _SplitLabelPipe {
  transform(value) {
    if (!value)
      return "";
    return value.split("___").join("<br>");
  }
};
_SplitLabelPipe.\u0275fac = function SplitLabelPipe_Factory(t) {
  return new (t || _SplitLabelPipe)();
};
_SplitLabelPipe.\u0275pipe = /* @__PURE__ */ \u0275\u0275definePipe({ name: "splitLabel", type: _SplitLabelPipe, pure: true });
var SplitLabelPipe = _SplitLabelPipe;

// src/app/@lcp-framework/formly/components/formly-field-select-from-db/formly-field-select-from-db.component.ts
var _c06 = (a0) => ({ "is-invalid": a0 });
function FormlyFieldSelectFromDbComponent_ng_select_2_ng_template_3_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 11);
    \u0275\u0275listener("click", function FormlyFieldSelectFromDbComponent_ng_select_2_ng_template_3_button_3_Template_button_click_0_listener($event) {
      \u0275\u0275restoreView(_r1);
      const item_r2 = \u0275\u0275nextContext().item;
      const ctx_r2 = \u0275\u0275nextContext(2);
      ctx_r2.onEditOption(item_r2);
      return \u0275\u0275resetView($event.stopPropagation());
    });
    \u0275\u0275element(1, "i", 12);
    \u0275\u0275elementEnd();
  }
}
function FormlyFieldSelectFromDbComponent_ng_select_2_ng_template_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 8);
    \u0275\u0275element(1, "span", 9);
    \u0275\u0275pipe(2, "splitLabel");
    \u0275\u0275template(3, FormlyFieldSelectFromDbComponent_ng_select_2_ng_template_3_button_3_Template, 2, 0, "button", 10);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r2 = ctx.item;
    const ctx_r2 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("innerHTML", \u0275\u0275pipeBind1(2, 2, item_r2.label), \u0275\u0275sanitizeHtml);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx_r2.to["enable_edit"]);
  }
}
function FormlyFieldSelectFromDbComponent_ng_select_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-select", 6, 0);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275template(3, FormlyFieldSelectFromDbComponent_ng_select_2_ng_template_3_Template, 4, 4, "ng-template", 7);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275propertyInterpolate("placeholder", ctx_r2.to.placeholder || "Select an option");
    \u0275\u0275property("readonly", ctx_r2.to["readonly"] || false)("formControl", ctx_r2.formControl)("formlyAttributes", ctx_r2.field)("items", \u0275\u0275pipeBind1(2, 8, ctx_r2.options$))("multiple", ctx_r2.to["multiple"] || false)("clearable", false)("ngClass", \u0275\u0275pureFunction1(10, _c06, ctx_r2.formControl.invalid && (ctx_r2.formControl.touched || ctx_r2.formControl.dirty || (ctx_r2.field.options == null ? null : ctx_r2.field.options.formState == null ? null : ctx_r2.field.options.formState.submitted))));
  }
}
function FormlyFieldSelectFromDbComponent_ng_select_3_ng_template_3_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 11);
    \u0275\u0275listener("click", function FormlyFieldSelectFromDbComponent_ng_select_3_ng_template_3_button_3_Template_button_click_0_listener($event) {
      \u0275\u0275restoreView(_r4);
      const item_r5 = \u0275\u0275nextContext().item;
      const ctx_r2 = \u0275\u0275nextContext(2);
      ctx_r2.onEditOption(item_r5);
      return \u0275\u0275resetView($event.stopPropagation());
    });
    \u0275\u0275element(1, "i", 12);
    \u0275\u0275elementEnd();
  }
}
function FormlyFieldSelectFromDbComponent_ng_select_3_ng_template_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 8);
    \u0275\u0275element(1, "span", 9);
    \u0275\u0275pipe(2, "splitLabel");
    \u0275\u0275template(3, FormlyFieldSelectFromDbComponent_ng_select_3_ng_template_3_button_3_Template, 2, 0, "button", 10);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r5 = ctx.item;
    const ctx_r2 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("innerHTML", \u0275\u0275pipeBind1(2, 2, item_r5.label), \u0275\u0275sanitizeHtml);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx_r2.to["enable_edit"]);
  }
}
function FormlyFieldSelectFromDbComponent_ng_select_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ng-select", 13, 0);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275template(3, FormlyFieldSelectFromDbComponent_ng_select_3_ng_template_3_Template, 4, 4, "ng-template", 7);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275propertyInterpolate("placeholder", ctx_r2.to.placeholder || "Select an option");
    \u0275\u0275property("formControl", ctx_r2.formControl)("formlyAttributes", ctx_r2.field)("items", \u0275\u0275pipeBind1(2, 7, ctx_r2.static_options$))("multiple", ctx_r2.to["multiple"] || false)("clearable", false)("ngClass", \u0275\u0275pureFunction1(9, _c06, ctx_r2.formControl.invalid && (ctx_r2.formControl.touched || ctx_r2.formControl.dirty || (ctx_r2.field.options == null ? null : ctx_r2.field.options.formState == null ? null : ctx_r2.field.options.formState.submitted))));
  }
}
function FormlyFieldSelectFromDbComponent_div_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 14)(1, "button", 15);
    \u0275\u0275listener("click", function FormlyFieldSelectFromDbComponent_div_4_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.openNestedFormModal(ctx_r2.getAddEditForm() || "", ctx_r2.getFieldKey(), null, null));
    });
    \u0275\u0275element(2, "i", 16);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("title", "Add new " + (ctx_r2.getAddEditForm() || ""));
  }
}
var _FormlyFieldSelectFromDbComponent = class _FormlyFieldSelectFromDbComponent extends FieldType {
  constructor(gridApiService, localStorageService) {
    super();
    this.gridApiService = gridApiService;
    this.localStorageService = localStorageService;
    this.policyData = null;
    this.user_info = null;
  }
  ngOnInit() {
    this.user_info = JSON.parse(this.localStorageService.getData("user_data"));
    if (this.user_info.main?.policies) {
      this.policyData = this.user_info.main?.policies || null;
    }
    this.initOptions();
    this.initOnchanges(this);
    this.createLabelControl();
  }
  createLabelControl() {
    const labelControlName = `${this.field.key}_label`;
    if (this.field.parent?.formControl?.get(labelControlName)) {
      const labelControl = this.field.parent?.formControl?.get(labelControlName);
      this.formControl.valueChanges?.subscribe((newValue) => {
        if (newValue == null) {
          labelControl.setValue(null);
        } else {
          this.options$?.subscribe((options) => {
            const selectedOption = options.find((option) => option.value === newValue);
            if (selectedOption) {
              labelControl.setValue(selectedOption.label);
            } else {
              labelControl.setValue(null);
            }
          });
        }
      });
    }
  }
  initOnchanges(context) {
    const refreshKeys = Array.isArray(this.props["refresh"]) ? this.props["refresh"] : [this.props["refresh"]];
    if (refreshKeys.length) {
      refreshKeys.forEach((refreshKey) => {
        if (refreshKey) {
          try {
            const getControlFunction = new Function("context", `with(context) { return ${refreshKey.replace(/this\./g, "context.")}; }`);
            const parentFormControl = getControlFunction(this);
            if (parentFormControl) {
              parentFormControl.valueChanges?.subscribe((newValue) => {
                this.initOptions();
              });
            }
          } catch (error) {
            console.error(`Error evaluating 'refresh' field string for '${refreshKey}':`, error);
          }
        }
      });
    }
  }
  initOptions() {
    const tableName = this.props["table"] || this.props["primary_table"];
    const valueColumn = this.props["valueColumn"];
    const labelColumn = this.props["labelColumn"];
    if (tableName && labelColumn && valueColumn) {
      const updatedSearchAll = this.props["search_all"] ? JSON.parse(JSON.stringify(this.props["search_all"])) : [
        {
          value: "1",
          operator: "=",
          column_name: "status_id"
        }
      ];
      const search_all = this.evaluateDynamicValues(updatedSearchAll, this);
      const limit_range = this.props["limit_range"] ? this.props["limit_range"] : 1e3;
      const print_query = this.props["print_query"] ? this.props["print_query"] : false;
      const sort_columns = this.props["sort_columns"] ? this.props["sort_columns"] : [[labelColumn, "asc"]];
      const includes = this.props["includes"] ? this.props["includes"] : [];
      const listParams = this.localStorageService.replaceUniqueId(this.localStorageService.formatPayloadWithPolicyConditions({
        company_id: 1,
        search_all,
        limit_range,
        print_query: true,
        start_index: 0,
        sort_columns,
        primary_table: tableName,
        select_columns: [
          [valueColumn, "value"],
          [labelColumn, "label"],
          ["uuid", "uuid"]
        ],
        includes
      }, this.policyData, this.field?.attached_policies || []), "$session_user_id", this.user_info.main.id);
      let hasSetFirstValue = false;
      console.log(listParams);
      this.options$ = this.gridApiService.getAllList(listParams).pipe(map((response) => {
        if (response.status && response.data?.records?.length > 0) {
          if (this.field.props && this.field.props["selectFirst"] && !hasSetFirstValue && !this.formControl.value) {
            this.formControl.setValue(response.data.records[0].value ?? null, { emitEvent: true });
            hasSetFirstValue = true;
          }
          return response.data.records.map((record) => ({
            value: record[valueColumn] || record["value"],
            label: record[labelColumn] || record["label"],
            uuid: record["uuid"] || record["uuid"]
          }));
        }
        return [];
      }));
    }
  }
  // Cast formControl to FormControl explicitly
  get formControl() {
    return this.form.get(this.field.key);
  }
  get static_options$() {
    if (Array.isArray(this.to.options)) {
      return of(this.to.options);
    }
    return this.to.options;
  }
  evaluateDynamicValues(search_all, context) {
    return search_all.map((item) => {
      if (typeof item.value === "string" && item.value.startsWith("this.")) {
        try {
          const dynamicValue = new Function("context", `with(context) { try { return ${item.value.replace(/this\./g, "context.")}; } catch (e) { return null; } }`);
          const evaluatedValue = dynamicValue(context);
          if (evaluatedValue !== void 0) {
            item.value = evaluatedValue;
          } else {
            console.log("undefined evaluatedValue", item.value);
            item.value = null;
          }
        } catch (error) {
          console.error(`Error evaluating value: ${item.value}`, error);
        }
      }
      return item;
    });
  }
  // Methods for entityName functionality
  getAddEditForm() {
    if (this.field.modal && this.field.modal.entityName) {
      return this.field.modal.entityName;
    }
    return this.field.entityName || null;
  }
  getModalConfig() {
    return this.field.modal || null;
  }
  getFieldKey() {
    if (this.field.key === void 0 || this.field.key === null) {
      return void 0;
    }
    return String(this.field.key);
  }
  openNestedFormModal(entityName, fieldKey, modalConfig, uuid) {
    const modalCfg = modalConfig ?? this.getModalConfig();
    const componentInstance = this.options?.formState?.componentInstance;
    if (componentInstance && typeof componentInstance.openNestedFormModal === "function") {
      componentInstance.openNestedFormModal(entityName, fieldKey, modalCfg, uuid, "popup_add");
    }
  }
  onEditOption(option) {
    console.log(option);
    console.log(this.to["enable_edit"]);
    if (!this.to["enable_edit"])
      return;
    const entityName = this.getAddEditForm();
    const fieldKey = this.getFieldKey();
    const modalConfig = this.getModalConfig();
    console.log(entityName);
    console.log(fieldKey);
    console.log(modalConfig);
    const componentInstance = this.options?.formState?.componentInstance;
    if (componentInstance && typeof componentInstance.openNestedFormModal === "function") {
      componentInstance.openNestedFormModal(entityName, fieldKey, modalConfig, option.uuid, "popup_edit");
    }
  }
};
_FormlyFieldSelectFromDbComponent.\u0275fac = function FormlyFieldSelectFromDbComponent_Factory(t) {
  return new (t || _FormlyFieldSelectFromDbComponent)(\u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(LocalStorageService));
};
_FormlyFieldSelectFromDbComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FormlyFieldSelectFromDbComponent, selectors: [["app-formly-field-select-from-db"]], features: [\u0275\u0275InheritDefinitionFeature], decls: 5, vars: 3, consts: [["selectRef", ""], [1, "flex", "items-center", "gap-2"], [1, "flex-1"], ["bindLabel", "label", "bindValue", "value", "class", "form-control", 3, "readonly", "formControl", "formlyAttributes", "items", "multiple", "clearable", "placeholder", "ngClass", 4, "ngIf"], ["bindLabel", "label", "bindValue", "value", "class", "form-control", 3, "formControl", "formlyAttributes", "items", "multiple", "clearable", "placeholder", "ngClass", 4, "ngIf"], ["class", "flex-none", 4, "ngIf"], ["bindLabel", "label", "bindValue", "value", 1, "form-control", 3, "readonly", "formControl", "formlyAttributes", "items", "multiple", "clearable", "placeholder", "ngClass"], ["ng-option-tmp", ""], [2, "display", "flex", "align-items", "center", "justify-content", "space-between", "width", "100%"], [3, "innerHTML"], ["type", "button", "class", "ml-2 btn btn-link p-0", "style", "margin-left: auto;", "tabindex", "-1", 3, "click", 4, "ngIf"], ["type", "button", "tabindex", "-1", 1, "ml-2", "btn", "btn-link", "p-0", 2, "margin-left", "auto", 3, "click"], [1, "fa", "fa-edit"], ["bindLabel", "label", "bindValue", "value", 1, "form-control", 3, "formControl", "formlyAttributes", "items", "multiple", "clearable", "placeholder", "ngClass"], [1, "flex-none"], ["type", "button", 1, "btn-primary", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-3", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark", 3, "click", "title"], [1, "fa-solid", "fa-plus"]], template: function FormlyFieldSelectFromDbComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 1)(1, "div", 2);
    \u0275\u0275template(2, FormlyFieldSelectFromDbComponent_ng_select_2_Template, 4, 12, "ng-select", 3)(3, FormlyFieldSelectFromDbComponent_ng_select_3_Template, 4, 11, "ng-select", 4);
    \u0275\u0275elementEnd();
    \u0275\u0275template(4, FormlyFieldSelectFromDbComponent_div_4_Template, 3, 1, "div", 5);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.to["table"]);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !ctx.to["table"]);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.getAddEditForm());
  }
}, dependencies: [NgClass, NgIf, NgSelectComponent, NgOptionTemplateDirective, NgControlStatus, FormControlDirective, FormlyAttributes, AsyncPipe, SplitLabelPipe] });
var FormlyFieldSelectFromDbComponent = _FormlyFieldSelectFromDbComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FormlyFieldSelectFromDbComponent, { className: "FormlyFieldSelectFromDbComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\formly-field-select-from-db\\formly-field-select-from-db.component.ts", lineNumber: 14 });
})();

// src/app/@lcp-framework/formly/directives/file-value-accessor.ts
var _FileValueAccessor = class _FileValueAccessor {
  constructor(renderer, el) {
    this.renderer = renderer;
    this.el = el;
    this.onChange = (_) => {
    };
    this.onTouched = () => {
    };
    this.divElement = this.renderer.createElement("div");
    this.renderer.setStyle(this.divElement, "padding", "6px");
    this.renderer.setStyle(this.divElement, "overflow", "hidden");
    this.renderer.setStyle(this.divElement, "textOverflow", "ellipsis");
    this.renderer.setStyle(this.divElement, "whiteSpace", "nowrap");
    this.renderer.setStyle(this.divElement, "display", "none");
    this.renderer.setAttribute(this.divElement, "appDynamicFontSize", "body");
    this.imgElement = this.renderer.createElement("img");
    this.renderer.setStyle(this.imgElement, "width", "60px");
    this.renderer.setStyle(this.imgElement, "height", "60px");
    this.renderer.setStyle(this.imgElement, "padding", "6px");
    this.renderer.setAttribute(this.imgElement, "alt", "formly-img");
    this.renderer.setStyle(this.imgElement, "display", "none");
    const parent = this.el.nativeElement.parentNode;
    this.renderer.appendChild(parent, this.imgElement);
    this.renderer.appendChild(parent, this.divElement);
  }
  ngOnChanges(changes) {
    if (changes["defaultImageUrl"]) {
      this.updateImagePreview(null);
    }
  }
  writeValue(value) {
    this.value = value;
    if (value && value.length > 0) {
      this.updateImagePreview(value);
    } else {
      this.updateImagePreview(null);
    }
  }
  registerOnChange(fn) {
    this.onChange = (files) => {
      fn(files);
      this.value = files;
      this.updateImagePreview(files);
    };
  }
  registerOnTouched(fn) {
    this.onTouched = fn;
  }
  updateImagePreview(files) {
    if (files && files.length > 0) {
      if (files instanceof FileList) {
        if (files[0]?.type?.includes("image")) {
          const reader = new FileReader();
          reader.onload = () => {
            this.renderer.setStyle(this.divElement, "display", "none");
            this.renderer.setAttribute(this.imgElement, "src", `${reader.result}`);
            this.renderer.setStyle(this.imgElement, "display", "block");
          };
          reader.readAsDataURL(files[0]);
        } else {
          this.renderer.setStyle(this.imgElement, "display", "none");
          this.divElement.innerHTML = `File - ${files[0].name.split("/").pop() || ""} uploaded.`;
          this.renderer.setStyle(this.divElement, "display", "block");
        }
      }
    } else if (this.defaultImageUrl?.length) {
      this.renderer.setStyle(this.divElement, "display", "none");
      this.renderer.setAttribute(this.imgElement, "src", this.defaultImageUrl);
      this.renderer.setStyle(this.imgElement, "display", "block");
    } else {
      this.renderer.setStyle(this.imgElement, "display", "none");
      this.renderer.setStyle(this.divElement, "display", "none");
    }
  }
};
_FileValueAccessor.\u0275fac = function FileValueAccessor_Factory(t) {
  return new (t || _FileValueAccessor)(\u0275\u0275directiveInject(Renderer2), \u0275\u0275directiveInject(ElementRef));
};
_FileValueAccessor.\u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({ type: _FileValueAccessor, selectors: [["input", "type", "file", 8, "formly-file"]], hostBindings: function FileValueAccessor_HostBindings(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275listener("change", function FileValueAccessor_change_HostBindingHandler($event) {
      return ctx.onChange($event.target.files);
    })("blur", function FileValueAccessor_blur_HostBindingHandler() {
      return ctx.onTouched();
    });
  }
}, inputs: { defaultImageUrl: "defaultImageUrl" }, features: [\u0275\u0275ProvidersFeature([{ provide: NG_VALUE_ACCESSOR, useExisting: _FileValueAccessor, multi: true }]), \u0275\u0275NgOnChangesFeature] });
var FileValueAccessor = _FileValueAccessor;

// src/app/@lcp-framework/formly/components/formly-field-file/formly-field-file.component.ts
function FormlyFieldFileComponent_img_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "img", 5);
    \u0275\u0275listener("click", function FormlyFieldFileComponent_img_2_Template_img_click_0_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.downloadFile());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("src", ctx_r1.defaultImageUrl, \u0275\u0275sanitizeUrl)("hidden", ctx_r1.fileSelected)("title", (ctx_r1.defaultImageUrl || "").includes("http") ? "Download the file " + ctx_r1.getFileName(true) : "");
  }
}
function FormlyFieldFileComponent_div_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 6);
    \u0275\u0275listener("click", function FormlyFieldFileComponent_div_3_Template_div_click_0_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.downloadFile());
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("title", "Download the file " + ctx_r1.defaultImageUrl.split("/").pop())("title", (ctx_r1.defaultImageUrl || "").includes("http") ? "Download the file " + ctx_r1.getFileName(true) : "");
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r1.fileMsg, " ");
  }
}
function FormlyFieldFileComponent_div_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 7);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", "Invalid file format. Please upload a valid file. Supported formats: " + ctx_r1.field.props["accept"].split(",").join(", ") + ".", " ");
  }
}
function FormlyFieldFileComponent_div_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 7);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "uppercase");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", "File size must be up to " + \u0275\u0275pipeBind1(2, 1, ctx_r1.field.props["max_size"]) + ".", " ");
  }
}
var _FormlyFieldFileComponent = class _FormlyFieldFileComponent extends FieldType {
  constructor(cdr) {
    super();
    this.cdr = cdr;
    this.defaultImageUrl = "assets/images/file-preview.svg";
    this.fileSelected = false;
    this.errorMessage = "";
    this.acceptFormat = [];
    this.mimeToExtensions = {
      "image/*": ["jpg", "jpeg", "png", "gif", "svg", "ico", "webp", "heic", "heif"],
      "application/pdf": ["pdf"],
      "application/vnd.ms-excel": ["xls"],
      // XLS format
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": ["xlsx"],
      // XLSX format
      "application/msword": ["doc"],
      // DOC format
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document": ["docx"],
      // DOCX format
      "text/csv": ["csv"],
      // CSV format
      "application/vnd.oasis.opendocument.text": ["odt"],
      // ODT format
      "image/png": ["png"],
      // PNG format
      "image/jpeg": ["jpeg"],
      // JPEG format
      "image/jpg": ["jpg"],
      // JPG format
      "image/gif": ["gif"],
      // GIF format
      "image/svg": ["svg"],
      // SVG format
      "image/heic": ["heic"],
      // HEIC format
      "image/heif": ["heif"],
      // HEIF format
      "image/svg+xml": ["svg"],
      // SVG format
      "image/ico": ["ico"],
      // ICO format
      "image/webp": ["webp"],
      // WEBP format
      "text/plain": ["txt"],
      //
      "application/vnd.ms-powerpoint": ["ppt"],
      // PPT format
      "application/vnd.openxmlformats-officedocument.presentationml.presentation": ["pptx"]
      // PPTX format
    };
    this.fileMsg = "";
    this.isImageFile = (data) => {
      return this.acceptFormat.filter((format) => format.includes(data)).length ? true : false;
    };
    this.mapMimeTypeToExtensions = (mimeType) => {
      return this.mimeToExtensions[mimeType] || [];
    };
    this.validateFileFormat = (file) => {
      if (!file || !file?.length || !this.acceptFormat.length)
        return false;
      if (typeof file !== "string") {
        const mimeType = file[0].type;
        const fileExtension = file[0].name?.split(".")?.pop()?.toLowerCase();
        for (const format of this.acceptFormat) {
          if (format === "*/*") {
            return true;
          }
          if (format.endsWith("/*")) {
            const baseType = format.split("/")[0];
            if (mimeType?.startsWith(baseType)) {
              return true;
            }
          }
          if (mimeType === format) {
            return true;
          }
          const allowedExtensions = this.mapMimeTypeToExtensions(format);
          if (allowedExtensions?.includes(fileExtension || "")) {
            return true;
          }
        }
        return false;
      }
      return true;
    };
  }
  ngOnInit() {
    this.fileNameControlKey = this.removeSuffix(this.field.key, "_file");
    this.fileNameControl = this.form.get(this.fileNameControlKey);
    this.updateDefaultImageUrl();
    this.fileNameControl?.valueChanges.subscribe(() => {
      this.updateDefaultImageUrl();
    });
    this.formControl.valueChanges.subscribe((file) => {
      this.updateDefaultImageUrl();
      if (file) {
        const isValid = this.validateFileFormat(file);
        if (isValid) {
          if (!this.formControl.hasError("invalidFileSize")) {
            this.formControl.setErrors(null);
          }
        } else {
          this.formControl.setErrors({
            invalidFileFormat: true
          });
        }
      }
    });
  }
  updateFileAccept(type) {
    if (type?.length) {
      type.split(",").map((value) => {
        let format = "";
        switch (value.trim().toLowerCase()) {
          case "image":
            format = "image/*";
            break;
          case "png":
            format = "image/png";
            break;
          case "jpeg":
            format = "image/jpeg";
            break;
          case "jpg":
            format = "image/jpg";
            break;
          case "heic":
            format = "image/heic";
            break;
          case "heif":
            format = "image/heif";
            break;
          case "gif":
            format = "image/gif";
            break;
          case "svg":
            format = "image/svg+xml, image/svg";
            break;
          case "svg+xml":
            format = "image/svg+xml, image/svg";
            break;
          case "ico":
            format = "image/ico";
            break;
          case "webp":
            format = "image/webp";
            break;
          case "powerpoint":
            format = "application/vnd.ms-powerpoint, application/vnd.openxmlformats-officedocument.presentationml.presentation";
            break;
          case "ppt":
            format = "application/vnd.ms-powerpoint";
            break;
          case "pptx":
            format = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            break;
          case "pdf":
            format = "application/pdf";
            break;
          case "excel":
            format = "application/vnd.ms-excel, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            break;
          case "xlsx":
            format = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            break;
          case "xls":
            format = "application/vnd.ms-excel";
            break;
          case "csv":
            format = "text/csv";
            break;
          case "document":
            format = "application/msword, application/vnd.openxmlformats-officedocument.wordprocessingml.document, application/vnd.oasis.opendocument.text";
            break;
          case "docx":
            format = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            break;
          case "doc":
            format = "application/msword";
            break;
          case "odt":
            format = "application/vnd.oasis.opendocument.text";
            break;
          case "text":
          case "txt":
            format = "text/plain";
            break;
          case "all":
            format = "*/*";
            break;
          default:
            format = "image/*";
        }
        if (!this.acceptFormat.includes(format))
          this.acceptFormat.push(format);
      });
    } else {
      this.acceptFormat = ["image/*"];
    }
    return this.acceptFormat.join(",");
  }
  removeSuffix(value, suffix) {
    return value.endsWith(suffix) ? value.slice(0, -suffix.length) : value;
  }
  updateDefaultImageUrl() {
    if (typeof this.fileNameControl.value === "string" && this.fileNameControl?.value?.length) {
      if (this.mimeToExtensions["image/*"].includes(this.fileNameControl?.value?.split(".").pop() || "")) {
        this.fileMsg = "";
      } else {
        this.fileMsg = this.form?.getRawValue()?.name ? this.getFileName(true) : `${this.fileNameControl?.value.split("/").pop()}`;
      }
      this.defaultImageUrl = this.getFileName();
    } else {
      if (!this.fileNameControl?.value?.length) {
        this.fileMsg = "";
      }
      this.defaultImageUrl = `assets/images/file-preview.svg`;
    }
    this.cdr.detectChanges();
  }
  convertSizeToBytes(size) {
    const units = ["b", "kb", "mb", "gb"];
    const regex = /^(\d+(?:\.\d+)?)\s*(b|kb|mb|gb)$/i;
    const match = size.trim().match(regex);
    if (match) {
      const value = parseFloat(match[1]);
      const unit = match[2];
      const exponent = units.indexOf(unit);
      return value * Math.pow(1024, exponent);
    } else {
      throw new Error('Invalid size format. Please use a format like "10MB", "5kb", etc.');
    }
  }
  onFileChange(event, maxSize = "10mb") {
    const input2 = event.target;
    const size = this.convertSizeToBytes(maxSize.toLowerCase());
    this.fileMsg = "";
    if (input2.files && input2.files[0]) {
      if (input2.files[0].size > size) {
        this.formControl.setErrors({
          invalidFileSize: true
        });
      } else {
        if (!this.formControl.hasError("invalidFileFormat")) {
          this.formControl.setErrors(null);
        }
      }
      this.fileSelected = true;
    } else {
      this.fileSelected = false;
      this.defaultImageUrl = "";
    }
  }
  downloadFile() {
    if (this.defaultImageUrl && this.defaultImageUrl?.startsWith("http")) {
      fetch(this.defaultImageUrl).then((response) => response.blob()).then((blob) => {
        const link = document.createElement("a");
        link.href = URL.createObjectURL(blob);
        link.download = this.getFileName(true);
        link.textContent = "Download File";
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        URL.revokeObjectURL(link.href);
      }).catch((error) => console.error("Download failed:", error));
    }
  }
  getFileName(download = false) {
    if (download) {
      if (this.defaultImageUrl && this.defaultImageUrl?.startsWith("http")) {
        const name = this.form?.getRawValue()?.name || "";
        if (name) {
          const extension = this.defaultImageUrl?.split("/").pop()?.split(".")[1] || "";
          return `${name}.${extension}`;
        }
        return this.defaultImageUrl?.split("/")?.pop() || "";
      }
      return "";
    } else {
      return `${environment.apiUrl}/${this.fileNameControl.value}`;
    }
  }
};
_FormlyFieldFileComponent.\u0275fac = function FormlyFieldFileComponent_Factory(t) {
  return new (t || _FormlyFieldFileComponent)(\u0275\u0275directiveInject(ChangeDetectorRef));
};
_FormlyFieldFileComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FormlyFieldFileComponent, selectors: [["app-formly-field-file"]], features: [\u0275\u0275InheritDefinitionFeature], decls: 6, vars: 7, consts: [[1, "formly-file-preview"], ["type", "file", 1, "formly-file", "form-input", "p-0", "file:border-0", "file:bg-primary/90", "file:px-4", "file:py-2", "file:font-semibold", "file:text-white", "file:hover:bg-primary", "ltr:file:mr-5", "rtl:file:ml-5", 3, "change", "accept", "formControl", "formlyAttributes"], ["alt", "formly-img", "class", "formly-img cursor-pointer", "style", "width: 60px; height: 60px; padding: 6px", 3, "src", "hidden", "title", "click", 4, "ngIf"], ["class", "cursor-pointer truncate p-2 text-blue-600", "appDynamicFontSize", "body", 3, "title", "click", 4, "ngIf"], ["class", "p-2 text-red-500", 4, "ngIf"], ["alt", "formly-img", 1, "formly-img", "cursor-pointer", 2, "width", "60px", "height", "60px", "padding", "6px", 3, "click", "src", "hidden", "title"], ["appDynamicFontSize", "body", 1, "cursor-pointer", "truncate", "p-2", "text-blue-600", 3, "click", "title"], [1, "p-2", "text-red-500"]], template: function FormlyFieldFileComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "input", 1);
    \u0275\u0275listener("change", function FormlyFieldFileComponent_Template_input_change_1_listener($event) {
      return ctx.onFileChange($event, ctx.field.props["max_size"]);
    });
    \u0275\u0275elementEnd();
    \u0275\u0275template(2, FormlyFieldFileComponent_img_2_Template, 1, 3, "img", 2)(3, FormlyFieldFileComponent_div_3_Template, 2, 3, "div", 3)(4, FormlyFieldFileComponent_div_4_Template, 2, 1, "div", 4)(5, FormlyFieldFileComponent_div_5_Template, 3, 3, "div", 4);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("accept", ctx.updateFileAccept(ctx.field.props["accept"]))("formControl", ctx.formControl)("formlyAttributes", ctx.field);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isImageFile("image") && !ctx.fileMsg.length && ctx.defaultImageUrl.length);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.fileMsg.length);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.formControl && ctx.formControl.errors && ctx.formControl.errors["invalidFileFormat"]);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.formControl && ctx.formControl.errors && ctx.formControl.errors["invalidFileSize"]);
  }
}, dependencies: [NgIf, DefaultValueAccessor, NgControlStatus, FormControlDirective, FormlyAttributes, FileValueAccessor, UpperCasePipe], styles: ["\n\n  .custom-file-container {\n  box-sizing: border-box;\n  position: relative;\n  display: block;\n}\n  .custom-file-container * {\n  box-sizing: border-box;\n}\n  .custom-file-container label {\n  color: #4361ee;\n  font-size: 16px;\n}\n  .custom-file-container .label-container {\n  align-items: center;\n  display: flex;\n  justify-content: space-between;\n  margin-bottom: 10px;\n}\n  .custom-file-container .clear-button {\n  color: #333;\n  font-size: 26px;\n  height: 26px;\n  line-height: 26px;\n  text-decoration: none;\n  transition: color 0.2s ease-in-out;\n}\n  .custom-file-container .clear-button:hover,   .dark .custom-file-container .clear-button:hover {\n  color: #777;\n}\n  .custom-file-container .custom-file {\n  box-sizing: border-box;\n  position: relative;\n  display: inline-block;\n  width: 100%;\n  height: calc(2.25rem + 4px);\n  margin-bottom: 8px;\n  margin-top: 0;\n}\n  .custom-file-container .custom-file:hover {\n  cursor: pointer;\n}\n  .custom-file-container .custom-file .custom-file-input {\n  box-sizing: border-box;\n  min-width: 14rem;\n  max-width: 100%;\n  height: calc(2.25rem + 4px);\n  margin: 0;\n  opacity: 0;\n}\n  .custom-file-container .custom-file .custom-file-input:focus ~ span {\n  outline: none;\n}\n  .custom-file-container .input-visible {\n  background-clip: padding-box;\n  background-color: #f1f2f3;\n  border-radius: 4px;\n  border: 1px solid #f1f2f3;\n  color: #333;\n  height: 40px;\n  left: 0;\n  line-height: 1.5;\n  overflow: hidden;\n  padding: 8px 12px;\n  position: absolute;\n  right: 0;\n  top: 0;\n  -webkit-user-select: none;\n  user-select: none;\n  z-index: 5;\n  font-size: 14px;\n}\n  .custom-file-container .input-visible .browse-button {\n  position: absolute;\n  top: 0;\n  right: 0;\n  z-index: 6;\n  display: block;\n  height: auto;\n  padding: 10px 16px;\n  line-height: 1.25;\n  background-color: rgba(27, 85, 226, 0.2392156863);\n  color: #4361ee;\n  border-left: 1px solid #e0e6ed;\n  box-sizing: border-box;\n}\n  .custom-file-container .image-preview {\n  background-position: center center;\n  background-repeat: no-repeat;\n  background-size: contain;\n  border-radius: 4px;\n  height: 300px;\n  overflow: auto;\n  padding: 4px;\n  transition: background 0.2s ease-in-out;\n  width: 100%;\n  margin-top: 54px;\n  margin-bottom: 40px;\n  background-color: transparent;\n}\n  .custom-file-container .image-preview-item {\n  background-position: center center;\n  background-repeat: no-repeat;\n  background-size: cover;\n  border-radius: 4px;\n  box-shadow: 0 4px 10px rgba(51, 51, 51, 0.2509803922);\n  float: left;\n  height: 180px;\n  margin: 1.858736059%;\n  position: relative;\n  transition: background 0.2s ease-in-out, opacity 0.2s ease-in-out;\n  width: 29.615861214%;\n}\n  .custom-file-container .image-preview-item-clear {\n  background: #edede8;\n  border-radius: 50%;\n  box-shadow: 0 4px 10px rgba(51, 51, 51, 0.2509803922);\n  height: 20px;\n  left: -6px;\n  margin-top: -6px;\n  position: absolute;\n  text-align: center;\n  transition: background 0.2s ease-in-out, color 0.2s ease-in-out;\n  width: 20px;\n}\n  .custom-file-container .image-preview-item-clear:hover {\n  background: #e2e2da;\n  cursor: pointer;\n}\n  .custom-file-container .image-preview-item-clear-icon {\n  color: #333;\n  display: block;\n  margin-top: 0;\n}\n  .dark .custom-file-container .clear-button {\n  color: #888ea8;\n}\n  .dark .custom-file-container .input-visible {\n  background-color: #1b2e4b;\n  border-color: #253b5c;\n  color: #888ea8;\n}\n  .dark .custom-file-container .input-visible .browse-button {\n  background-color: #4361ee;\n  border-color: #253b5c;\n  color: #fff;\n}\n  .dark .custom-file-container .image-preview-item-clear {\n  background-color: #3b3f5c;\n}\n  .dark .custom-file-container .image-preview-item-clear-icon {\n  color: #d0d2d6;\n}\n  .custom-file-container .image-preview-item-clear-icon {\n  margin-top: 0;\n}\n  .rtl .custom-file-container .input-visible .browse-button {\n  right: auto;\n  left: 0;\n  border-left: none;\n}\n  .rtl .custom-file-container .image-preview-item {\n  float: right;\n}\n  .rtl .custom-file-container .image-preview-item-clear {\n  left: auto;\n  right: -6px;\n}\n  .has-error .form-input.formly-file {\n  --tw-border-opacity: 1;\n  border-color: inherit;\n  background-color: inherit;\n  --tw-text-opacity: 1;\n  color: inherit;\n}\n  .has-error .form-input.formly-file:invalid {\n  --tw-border-opacity: 1;\n  border-color: rgb(231 81 90/var(--tw-border-opacity));\n  background-color: rgba(231, 81, 90, 0.08);\n  --tw-text-opacity: 1;\n  color: rgb(231 81 90/var(--tw-text-opacity));\n}\n/*# sourceMappingURL=formly-field-file.component.css.map */"] });
var FormlyFieldFileComponent = _FormlyFieldFileComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FormlyFieldFileComponent, { className: "FormlyFieldFileComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\formly-field-file\\formly-field-file.component.ts", lineNumber: 12 });
})();

// node_modules/@ngx-formly/core/fesm2020/ngx-formly-core-preset.mjs
var PresetSubstitutionExtension = class {
  constructor(formlyConfig) {
    this.formlyConfig = formlyConfig;
  }
  prePopulate(field) {
    if (!(typeof field.type === "string") || field.type[0] !== "#") {
      return;
    }
    const configId = new RegExp(/^#(.+)$/).exec(field.type)?.[1];
    const preset = this.formlyConfig.presets[configId];
    const _a = field, {
      type: _
    } = _a, fieldConfigWithoutType = __objRest(_a, [
      "type"
    ]);
    if (preset) {
      const merged = reverseDeepMerge(fieldConfigWithoutType, "getConfiguration" in preset ? preset.getConfiguration() : preset);
      Object.assign(field, merged);
    }
  }
};
function registerLibraryConfigReplacementExtension(formlyConfig) {
  return {
    extensions: [{
      name: "libraryConfigReplacement",
      extension: new PresetSubstitutionExtension(formlyConfig),
      priority: -300
    }]
  };
}
var FormlyPresetModule = class {
};
FormlyPresetModule.\u0275fac = function FormlyPresetModule_Factory(t) {
  return new (t || FormlyPresetModule)();
};
FormlyPresetModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: FormlyPresetModule
});
FormlyPresetModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
  providers: [{
    provide: FORMLY_CONFIG,
    useFactory: registerLibraryConfigReplacementExtension,
    deps: [FormlyConfig],
    multi: true
  }],
  imports: [[FormlyModule.forChild({})]]
});
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FormlyPresetModule, [{
    type: NgModule,
    args: [{
      imports: [FormlyModule.forChild({})],
      providers: [{
        provide: FORMLY_CONFIG,
        useFactory: registerLibraryConfigReplacementExtension,
        deps: [FormlyConfig],
        multi: true
      }]
    }]
  }], null, null);
})();

// src/app/@lcp-framework/formly/components/formly-field-repeat/formly-field-repeat.component.ts
var _c07 = (a0) => ({ "hidden": a0 });
function FormlyFieldRepeatComponent_div_1_ng_container_1_div_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11);
    \u0275\u0275element(1, "formly-field", 12);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const fg_r1 = ctx.$implicit;
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(2, _c07, fg_r1.className === "hidden"));
    \u0275\u0275advance();
    \u0275\u0275property("field", fg_r1);
  }
}
function FormlyFieldRepeatComponent_div_1_ng_container_1_button_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 13);
    \u0275\u0275listener("click", function FormlyFieldRepeatComponent_div_1_ng_container_1_button_5_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r2);
      const ctx_r2 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r2.add());
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275property("disabled", ctx_r2.isAddDisabled());
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r2.props["addText"] || "+", " ");
  }
}
function FormlyFieldRepeatComponent_div_1_ng_container_1_button_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 14);
    \u0275\u0275listener("click", function FormlyFieldRepeatComponent_div_1_ng_container_1_button_6_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r4);
      const i_r5 = \u0275\u0275nextContext(2).index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.remove(i_r5));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r2.props["removeText"] || "-", " ");
  }
}
function FormlyFieldRepeatComponent_div_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "div", 5);
    \u0275\u0275template(2, FormlyFieldRepeatComponent_div_1_ng_container_1_div_2_Template, 2, 4, "div", 6);
    \u0275\u0275elementStart(3, "div", 7)(4, "div", 8);
    \u0275\u0275template(5, FormlyFieldRepeatComponent_div_1_ng_container_1_button_5_Template, 2, 2, "button", 9)(6, FormlyFieldRepeatComponent_div_1_ng_container_1_button_6_Template, 2, 1, "button", 10);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const ctx_r5 = \u0275\u0275nextContext();
    const field_r7 = ctx_r5.$implicit;
    const i_r5 = ctx_r5.index;
    \u0275\u0275advance(2);
    \u0275\u0275property("ngForOf", field_r7.fieldGroup);
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", i_r5 === 0);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", i_r5 !== 0);
  }
}
function FormlyFieldRepeatComponent_div_1_ng_template_2_button_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 13);
    \u0275\u0275listener("click", function FormlyFieldRepeatComponent_div_1_ng_template_2_button_5_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r8);
      const ctx_r2 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r2.add());
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275property("disabled", ctx_r2.isAddDisabled());
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r2.props["addText"] || "+", " ");
  }
}
function FormlyFieldRepeatComponent_div_1_ng_template_2_button_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 14);
    \u0275\u0275listener("click", function FormlyFieldRepeatComponent_div_1_ng_template_2_button_6_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r9);
      const i_r5 = \u0275\u0275nextContext(2).index;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.remove(i_r5));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r2.props["removeText"] || "-", " ");
  }
}
function FormlyFieldRepeatComponent_div_1_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 5)(1, "div", 15);
    \u0275\u0275element(2, "formly-field", 12);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 7)(4, "div", 8);
    \u0275\u0275template(5, FormlyFieldRepeatComponent_div_1_ng_template_2_button_5_Template, 2, 2, "button", 9)(6, FormlyFieldRepeatComponent_div_1_ng_template_2_button_6_Template, 2, 1, "button", 10);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r5 = \u0275\u0275nextContext();
    const field_r7 = ctx_r5.$implicit;
    const i_r5 = ctx_r5.index;
    \u0275\u0275advance(2);
    \u0275\u0275property("field", field_r7);
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", i_r5 === 0);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", i_r5 !== 0);
  }
}
function FormlyFieldRepeatComponent_div_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 3);
    \u0275\u0275template(1, FormlyFieldRepeatComponent_div_1_ng_container_1_Template, 7, 3, "ng-container", 4)(2, FormlyFieldRepeatComponent_div_1_ng_template_2_Template, 7, 3, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const field_r7 = ctx.$implicit;
    const singleField_r10 = \u0275\u0275reference(3);
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r2.isFormGroup(field_r7))("ngIfElse", singleField_r10);
  }
}
var _FormlyFieldRepeatComponent = class _FormlyFieldRepeatComponent extends FieldArrayType {
  isAddDisabled() {
    return this.field.fieldGroup && this.field.fieldGroup.length >= (this.props["limit"] || 5) ? true : false;
  }
  isFormGroup(field) {
    return field.fieldGroup && field.fieldGroup.length > 0;
  }
  add() {
    super.add();
  }
  remove(index) {
    super.remove(index);
  }
};
_FormlyFieldRepeatComponent.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyFieldRepeatComponent_BaseFactory;
  return function FormlyFieldRepeatComponent_Factory(t) {
    return (\u0275FormlyFieldRepeatComponent_BaseFactory || (\u0275FormlyFieldRepeatComponent_BaseFactory = \u0275\u0275getInheritedFactory(_FormlyFieldRepeatComponent)))(t || _FormlyFieldRepeatComponent);
  };
})();
_FormlyFieldRepeatComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FormlyFieldRepeatComponent, selectors: [["app-formly-field-repeat"]], features: [\u0275\u0275InheritDefinitionFeature], decls: 2, vars: 1, consts: [["singleField", ""], [1, "formly-repeat"], ["class", "grid", 4, "ngFor", "ngForOf"], [1, "grid"], [4, "ngIf", "ngIfElse"], [1, "flex", "gap-4"], ["class", "flex-1", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "flex-none"], [1, "md:col-span-1", "flex", "items-center", "justify-center", "h-full"], ["type", "button", "class", "rounded-md border border-[#e0e6ed] px-4 py-2 font-semibold btn-primary", 3, "disabled", "click", 4, "ngIf"], ["type", "button", "class", "rounded-md border border-[#e0e6ed] px-4 py-2 font-semibold btn-danger", 3, "click", 4, "ngIf"], [1, "flex-1", 3, "ngClass"], [3, "field"], ["type", "button", 1, "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "btn-primary", 3, "click", "disabled"], ["type", "button", 1, "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "btn-danger", 3, "click"], [1, "flex-1"]], template: function FormlyFieldRepeatComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 1);
    \u0275\u0275template(1, FormlyFieldRepeatComponent_div_1_Template, 4, 2, "div", 2);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx.field.fieldGroup);
  }
}, dependencies: [NgClass, NgForOf, NgIf, FormlyField], styles: ["\n\n  .formly-repeat .grid:first-child .flex-none button {\n  top: 22px;\n}\n  .formly-repeat .grid:not(:first-child) label {\n  display: none;\n}\n/*# sourceMappingURL=formly-field-repeat.component.css.map */"] });
var FormlyFieldRepeatComponent = _FormlyFieldRepeatComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FormlyFieldRepeatComponent, { className: "FormlyFieldRepeatComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\formly-field-repeat\\formly-field-repeat.component.ts", lineNumber: 9 });
})();

// src/app/@lcp-framework/formly/components/formly-field-autocomplete/formly-field-autocomplete.component.ts
var _c08 = (a0) => ({ "is-invalid": a0 });
function FormlyFieldAutocompleteComponent_div_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 4)(1, "button", 5);
    \u0275\u0275listener("click", function FormlyFieldAutocompleteComponent_div_4_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.openNestedFormModal(ctx_r1.getAddEditForm() || "", ctx_r1.getFieldKey()));
    });
    \u0275\u0275element(2, "i", 6);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("title", "Add new " + (ctx_r1.getAddEditForm() || ""));
  }
}
var _FormlyFieldAutocompleteComponent = class _FormlyFieldAutocompleteComponent extends FieldType {
  constructor(gridApiService) {
    super();
    this.gridApiService = gridApiService;
    this.searchSubject = new Subject();
  }
  ngOnInit() {
    this.initializeOptions();
    this.initOnchanges(this);
    this.searchSubject.next("");
  }
  initOnchanges(context) {
    const refreshKeys = Array.isArray(this.props["refresh"]) ? this.props["refresh"] : [this.props["refresh"]];
    if (refreshKeys.length) {
      refreshKeys.forEach((refreshKey) => {
        if (refreshKey) {
          try {
            const getControlFunction = new Function("context", `with(context) { return ${refreshKey.replace(/this\./g, "context.")}; }`);
            const parentFormControl = getControlFunction(this);
            if (parentFormControl) {
              parentFormControl.valueChanges?.subscribe((newValue) => {
                this.initializeOptions();
              });
            }
          } catch (error) {
            console.error(`Error evaluating 'refresh' field string for '${refreshKey}':`, error);
          }
        }
      });
    }
  }
  initializeOptions() {
    this.options$ = this.formControl.valueChanges.pipe(
      filter(() => this.formControl.pristine),
      startWith(this.formControl.value),
      switchMap((value) => this.initializeAndSearchOptions(value)),
      catchError(() => of([]))
      // Handle errors gracefully
    );
  }
  initializeAndSearchOptions(value) {
    const initialLoad$ = this.loadOptions(value);
    return initialLoad$.pipe(switchMap(() => this.searchSubject.pipe(
      startWith(""),
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((searchTerm) => this.loadOptions(searchTerm)),
      catchError(() => of([]))
      // Handle errors gracefully
    )));
  }
  loadOptions(searchTerm) {
    const { table: tableName, valueColumn, labelColumn } = this.props;
    searchTerm = searchTerm ? searchTerm : this.formControl.value && Array.isArray(this.formControl.value) ? this.formControl.value : [this.formControl.value];
    if (!tableName || !labelColumn || !valueColumn || !searchTerm || !searchTerm.length) {
      return of([]);
    }
    const searchCriteria = this.buildSearchCriteria(searchTerm, valueColumn, labelColumn);
    let searchConditions = this.props["search_all"] ? JSON.parse(JSON.stringify(this.props["search_all"])) : [];
    searchConditions = this.evaluateDynamicValues([...searchConditions, searchCriteria], this);
    const listParams = this.buildListParams(tableName, valueColumn, labelColumn, searchConditions);
    return this.gridApiService.getAllList(listParams).pipe(
      map((response) => this.transformResponse(response, valueColumn, labelColumn)),
      catchError(() => of([]))
      // Handle errors gracefully
    );
  }
  buildSearchCriteria(searchTerm, valueColumn, labelColumn) {
    const split = valueColumn.split("::");
    let searchValue = [];
    if (typeof searchTerm !== "string") {
      searchValue = searchTerm.filter((item) => item);
    }
    return searchValue.length ? { value: searchValue, operator: "IN", column_name: split[0] } : { value: `%${searchTerm || ""}%`, operator: "ILIKE", column_name: labelColumn };
  }
  buildListParams(tableName, valueColumn, labelColumn, searchConditions) {
    return {
      company_id: 1,
      search_all: [{ value: "1", operator: "=", column_name: "status_id" }, ...searchConditions],
      limit_range: 25,
      print_query: false,
      start_index: 0,
      sort_columns: [[labelColumn, "asc"]],
      primary_table: tableName,
      select_columns: [
        [valueColumn, "value"],
        [labelColumn, "label"]
      ]
    };
  }
  transformResponse(response, valueColumn, labelColumn) {
    if (response.status && response.data?.records?.length > 0) {
      return response.data.records.map((record) => ({
        value: record[valueColumn] || record["value"],
        label: record[labelColumn] || record["label"]
      }));
    }
    return [];
  }
  get formControl() {
    return this.form.get(this.field.key);
  }
  evaluateDynamicValues(search_all, context) {
    return search_all.map((item) => {
      if (typeof item.value === "string" && item.value.startsWith("this.")) {
        try {
          const dynamicValue = new Function("context", `with(context) { try { return ${item.value.replace(/this\./g, "context.")}; } catch (e) { return null; } }`);
          const evaluatedValue = dynamicValue(context);
          if (evaluatedValue !== void 0) {
            item.value = evaluatedValue;
          } else {
            console.log("undefined evaluatedValue", item.value);
            item.value = null;
          }
        } catch (error) {
          console.error(`Error evaluating value: ${item.value}`, error);
        }
      }
      return item;
    });
  }
  // Methods for entityName functionality
  getAddEditForm() {
    return this.field.entityName || null;
  }
  getFieldKey() {
    if (this.field.key === void 0 || this.field.key === null) {
      return void 0;
    }
    return String(this.field.key);
  }
  openNestedFormModal(entityName, fieldKey) {
    console.log("Opening nested form modal:", { entityName, fieldKey });
    if (!entityName || entityName.trim() === "") {
      console.warn("No entity name provided for nested form modal");
      return;
    }
    const componentInstance = this.options?.formState?.componentInstance;
    if (componentInstance && typeof componentInstance.openNestedFormModal === "function") {
      componentInstance.openNestedFormModal(entityName, fieldKey);
    }
  }
};
_FormlyFieldAutocompleteComponent.\u0275fac = function FormlyFieldAutocompleteComponent_Factory(t) {
  return new (t || _FormlyFieldAutocompleteComponent)(\u0275\u0275directiveInject(GridApiService));
};
_FormlyFieldAutocompleteComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FormlyFieldAutocompleteComponent, selectors: [["app-formly-field-autocomplete"]], features: [\u0275\u0275InheritDefinitionFeature], decls: 5, vars: 14, consts: [[1, "flex", "items-center", "gap-2"], [1, "flex-1"], ["bindLabel", "label", "bindValue", "value", 1, "custom-multiselect", 3, "formControl", "formlyAttributes", "items", "multiple", "clearable", "searchable", "placeholder", "typeahead", "ngClass"], ["class", "flex-none", 4, "ngIf"], [1, "flex-none"], ["type", "button", 1, "btn-primary", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-3", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark", 3, "click", "title"], [1, "fa-solid", "fa-plus"]], template: function FormlyFieldAutocompleteComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 1);
    \u0275\u0275element(2, "ng-select", 2);
    \u0275\u0275pipe(3, "async");
    \u0275\u0275elementEnd();
    \u0275\u0275template(4, FormlyFieldAutocompleteComponent_div_4_Template, 3, 1, "div", 3);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275property("formControl", ctx.formControl)("formlyAttributes", ctx.field)("items", \u0275\u0275pipeBind1(3, 10, ctx.options$))("multiple", ctx.to["multiple"] || false)("clearable", true)("searchable", true)("placeholder", ctx.to.placeholder || "Select an option")("typeahead", ctx.searchSubject)("ngClass", \u0275\u0275pureFunction1(12, _c08, ctx.formControl.invalid && (ctx.formControl.touched || ctx.formControl.dirty || (ctx.field.options == null ? null : ctx.field.options.formState == null ? null : ctx.field.options.formState.submitted))));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.getAddEditForm());
  }
}, dependencies: [NgClass, NgIf, NgSelectComponent, NgControlStatus, FormControlDirective, FormlyAttributes, AsyncPipe] });
var FormlyFieldAutocompleteComponent = _FormlyFieldAutocompleteComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FormlyFieldAutocompleteComponent, { className: "FormlyFieldAutocompleteComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\formly-field-autocomplete\\formly-field-autocomplete.component.ts", lineNumber: 13 });
})();

// node_modules/ngx-quill/fesm2022/ngx-quill-config.mjs
var defaultModules = {
  toolbar: [
    ["bold", "italic", "underline", "strike"],
    // toggled buttons
    ["blockquote", "code-block"],
    [{
      header: 1
    }, {
      header: 2
    }],
    // custom button values
    [{
      list: "ordered"
    }, {
      list: "bullet"
    }],
    [{
      script: "sub"
    }, {
      script: "super"
    }],
    // superscript/subscript
    [{
      indent: "-1"
    }, {
      indent: "+1"
    }],
    // outdent/indent
    [{
      direction: "rtl"
    }],
    // text direction
    [{
      size: ["small", false, "large", "huge"]
    }],
    // custom dropdown
    [{
      header: [1, 2, 3, 4, 5, 6, false]
    }],
    [{
      color: []
    }, {
      background: []
    }],
    // dropdown with defaults from theme
    [{
      font: []
    }],
    [{
      align: []
    }],
    ["clean"],
    // remove formatting button
    ["link", "image", "video"],
    // link and image, video
    ["table"]
  ]
};
var QUILL_CONFIG_TOKEN = new InjectionToken("config", {
  providedIn: "root",
  factory: () => ({
    modules: defaultModules
  })
});
var _QuillConfigModule = class _QuillConfigModule {
  static forRoot(config) {
    return {
      ngModule: _QuillConfigModule,
      providers: [{
        provide: QUILL_CONFIG_TOKEN,
        useValue: config
      }]
    };
  }
};
_QuillConfigModule.\u0275fac = function QuillConfigModule_Factory(t) {
  return new (t || _QuillConfigModule)();
};
_QuillConfigModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: _QuillConfigModule
});
_QuillConfigModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({});
var QuillConfigModule = _QuillConfigModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(QuillConfigModule, [{
    type: NgModule
  }], null, null);
})();

// node_modules/ngx-quill/fesm2022/ngx-quill.mjs
var _c09 = [[["", "above-quill-editor-toolbar", ""]], [["", "quill-editor-toolbar", ""]], [["", "below-quill-editor-toolbar", ""]]];
var _c12 = ["[above-quill-editor-toolbar]", "[quill-editor-toolbar]", "[below-quill-editor-toolbar]"];
function QuillEditorComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 0);
  }
}
function QuillEditorComponent_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 0);
  }
}
var getFormat = (format, configFormat) => {
  const passedFormat = format || configFormat;
  return passedFormat || "html";
};
var raf$ = () => {
  return new Observable((subscriber) => {
    const rafId = requestAnimationFrame(() => {
      subscriber.next();
      subscriber.complete();
    });
    return () => cancelAnimationFrame(rafId);
  });
};
var _QuillService = class _QuillService {
  constructor(injector, config) {
    this.config = config;
    this.quill$ = defer(() => __async(this, null, function* () {
      if (!this.Quill) {
        const maybePatchedAddEventListener = this.document.addEventListener;
        this.document.addEventListener = // eslint-disable-next-line @typescript-eslint/dot-notation
        this.document["__zone_symbol__addEventListener"] || this.document.addEventListener;
        const quillImport = yield import("./chunk-AVMH4PBT.js");
        this.document.addEventListener = maybePatchedAddEventListener;
        this.Quill = // seems like esmodules have nested "default"
        quillImport.default?.default ?? quillImport.default ?? quillImport;
      }
      this.config.customOptions?.forEach((customOption) => {
        const newCustomOption = this.Quill.import(customOption.import);
        newCustomOption.whitelist = customOption.whitelist;
        this.Quill.register(newCustomOption, true, this.config.suppressGlobalRegisterWarning);
      });
      return yield this.registerCustomModules(this.Quill, this.config.customModules, this.config.suppressGlobalRegisterWarning);
    })).pipe(shareReplay({
      bufferSize: 1,
      refCount: true
    }));
    this.document = injector.get(DOCUMENT);
    if (!this.config) {
      this.config = {
        modules: defaultModules
      };
    }
  }
  getQuill() {
    return this.quill$;
  }
  /**
   * Marked as internal so it won't be available for `ngx-quill` consumers, this is only
   * internal method to be used within the library.
   *
   * @internal
   */
  registerCustomModules(Quill, customModules, suppressGlobalRegisterWarning) {
    return __async(this, null, function* () {
      if (Array.isArray(customModules)) {
        for (let {
          implementation,
          path
        } of customModules) {
          if (isObservable(implementation)) {
            implementation = yield firstValueFrom(implementation);
          }
          Quill.register(path, implementation, suppressGlobalRegisterWarning);
        }
      }
      return Quill;
    });
  }
};
_QuillService.\u0275fac = function QuillService_Factory(t) {
  return new (t || _QuillService)(\u0275\u0275inject(Injector), \u0275\u0275inject(QUILL_CONFIG_TOKEN, 8));
};
_QuillService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({
  token: _QuillService,
  factory: _QuillService.\u0275fac,
  providedIn: "root"
});
var QuillService = _QuillService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(QuillService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{
    type: Injector
  }, {
    type: void 0,
    decorators: [{
      type: Optional
    }, {
      type: Inject,
      args: [QUILL_CONFIG_TOKEN]
    }]
  }], null);
})();
var _QuillEditorBase = class _QuillEditorBase {
  constructor() {
    this.format = input(void 0);
    this.theme = input(void 0);
    this.modules = input(void 0);
    this.debug = input(false);
    this.readOnly = input(false);
    this.placeholder = input(void 0);
    this.maxLength = input(void 0);
    this.minLength = input(void 0);
    this.required = input(false);
    this.formats = input(void 0);
    this.customToolbarPosition = input("top");
    this.sanitize = input(false);
    this.beforeRender = input(void 0);
    this.styles = input(null);
    this.registry = input(void 0);
    this.bounds = input(void 0);
    this.customOptions = input([]);
    this.customModules = input([]);
    this.trackChanges = input(void 0);
    this.classes = input(void 0);
    this.trimOnValidation = input(false);
    this.linkPlaceholder = input(void 0);
    this.compareValues = input(false);
    this.filterNull = input(false);
    this.debounceTime = input(void 0);
    this.defaultEmptyValue = input(null);
    this.onEditorCreated = new EventEmitter();
    this.onEditorChanged = new EventEmitter();
    this.onContentChanged = new EventEmitter();
    this.onSelectionChanged = new EventEmitter();
    this.onFocus = new EventEmitter();
    this.onBlur = new EventEmitter();
    this.onNativeFocus = new EventEmitter();
    this.onNativeBlur = new EventEmitter();
    this.disabled = false;
    this.toolbarPosition = signal("top");
    this.subscription = null;
    this.quillSubscription = null;
    this.elementRef = inject(ElementRef);
    this.document = inject(DOCUMENT);
    this.cd = inject(ChangeDetectorRef);
    this.domSanitizer = inject(DomSanitizer);
    this.platformId = inject(PLATFORM_ID);
    this.renderer = inject(Renderer2);
    this.zone = inject(NgZone);
    this.service = inject(QuillService);
    this.destroyRef = inject(DestroyRef);
    this.valueGetter = input((quillEditor) => {
      let html = quillEditor.getSemanticHTML();
      if (this.isEmptyValue(html)) {
        html = this.defaultEmptyValue();
      }
      let modelValue = html;
      const format = getFormat(this.format(), this.service.config.format);
      if (format === "text") {
        modelValue = quillEditor.getText();
      } else if (format === "object") {
        modelValue = quillEditor.getContents();
      } else if (format === "json") {
        try {
          modelValue = JSON.stringify(quillEditor.getContents());
        } catch (e) {
          modelValue = quillEditor.getText();
        }
      }
      return modelValue;
    });
    this.valueSetter = input((quillEditor, value) => {
      const format = getFormat(this.format(), this.service.config.format);
      if (format === "html") {
        const sanitize = [true, false].includes(this.sanitize()) ? this.sanitize() : this.service.config.sanitize || false;
        if (sanitize) {
          value = this.domSanitizer.sanitize(SecurityContext.HTML, value);
        }
        return quillEditor.clipboard.convert({
          html: value
        });
      } else if (format === "json") {
        try {
          return JSON.parse(value);
        } catch (e) {
          return [{
            insert: value
          }];
        }
      }
      return value;
    });
    this.selectionChangeHandler = (range, oldRange, source) => {
      const trackChanges = this.trackChanges() || this.service.config.trackChanges;
      const shouldTriggerOnModelTouched = !range && !!this.onModelTouched && (source === "user" || trackChanges && trackChanges === "all");
      if (!this.onBlur.observed && !this.onFocus.observed && !this.onSelectionChanged.observed && !shouldTriggerOnModelTouched) {
        return;
      }
      this.zone.run(() => {
        if (range === null) {
          this.onBlur.emit({
            editor: this.quillEditor,
            source
          });
        } else if (oldRange === null) {
          this.onFocus.emit({
            editor: this.quillEditor,
            source
          });
        }
        this.onSelectionChanged.emit({
          editor: this.quillEditor,
          oldRange,
          range,
          source
        });
        if (shouldTriggerOnModelTouched) {
          this.onModelTouched();
        }
        this.cd.markForCheck();
      });
    };
    this.textChangeHandler = (delta, oldDelta, source) => {
      const text = this.quillEditor.getText();
      const content = this.quillEditor.getContents();
      let html = this.quillEditor.getSemanticHTML();
      if (this.isEmptyValue(html)) {
        html = this.defaultEmptyValue();
      }
      const trackChanges = this.trackChanges() || this.service.config.trackChanges;
      const shouldTriggerOnModelChange = (source === "user" || trackChanges && trackChanges === "all") && !!this.onModelChange;
      if (!this.onContentChanged.observed && !shouldTriggerOnModelChange) {
        return;
      }
      this.zone.run(() => {
        if (shouldTriggerOnModelChange) {
          const valueGetter = this.valueGetter();
          this.onModelChange(valueGetter(this.quillEditor));
        }
        this.onContentChanged.emit({
          content,
          delta,
          editor: this.quillEditor,
          html,
          oldDelta,
          source,
          text
        });
        this.cd.markForCheck();
      });
    };
    this.editorChangeHandler = (event, current, old, source) => {
      if (!this.onEditorChanged.observed) {
        return;
      }
      if (event === "text-change") {
        const text = this.quillEditor.getText();
        const content = this.quillEditor.getContents();
        let html = this.quillEditor.getSemanticHTML();
        if (this.isEmptyValue(html)) {
          html = this.defaultEmptyValue();
        }
        this.zone.run(() => {
          this.onEditorChanged.emit({
            content,
            delta: current,
            editor: this.quillEditor,
            event,
            html,
            oldDelta: old,
            source,
            text
          });
          this.cd.markForCheck();
        });
      } else {
        this.zone.run(() => {
          this.onEditorChanged.emit({
            editor: this.quillEditor,
            event,
            oldRange: old,
            range: current,
            source
          });
          this.cd.markForCheck();
        });
      }
    };
  }
  static normalizeClassNames(classes) {
    const classList = classes.trim().split(" ");
    return classList.reduce((prev, cur) => {
      const trimmed = cur.trim();
      if (trimmed) {
        prev.push(trimmed);
      }
      return prev;
    }, []);
  }
  ngOnInit() {
    this.toolbarPosition.set(this.customToolbarPosition());
  }
  ngAfterViewInit() {
    if (isPlatformServer(this.platformId)) {
      return;
    }
    this.quillSubscription = this.service.getQuill().pipe(mergeMap((Quill) => {
      const promises = [this.service.registerCustomModules(Quill, this.customModules())];
      const beforeRender = this.beforeRender() ?? this.service.config.beforeRender;
      if (beforeRender) {
        promises.push(beforeRender());
      }
      return Promise.all(promises).then(() => Quill);
    })).subscribe((Quill) => {
      this.editorElem = this.elementRef.nativeElement.querySelector("[quill-editor-element]");
      const toolbarElem = this.elementRef.nativeElement.querySelector("[quill-editor-toolbar]");
      const modules = Object.assign({}, this.modules() || this.service.config.modules);
      if (toolbarElem) {
        modules.toolbar = toolbarElem;
      } else if (modules.toolbar === void 0) {
        modules.toolbar = defaultModules.toolbar;
      }
      let placeholder = this.placeholder() !== void 0 ? this.placeholder() : this.service.config.placeholder;
      if (placeholder === void 0) {
        placeholder = "Insert text here ...";
      }
      const styles = this.styles();
      if (styles) {
        Object.keys(styles).forEach((key) => {
          this.renderer.setStyle(this.editorElem, key, styles[key]);
        });
      }
      if (this.classes()) {
        this.addClasses(this.classes());
      }
      this.customOptions().forEach((customOption) => {
        const newCustomOption = Quill.import(customOption.import);
        newCustomOption.whitelist = customOption.whitelist;
        Quill.register(newCustomOption, true);
      });
      let bounds = this.bounds() && this.bounds() === "self" ? this.editorElem : this.bounds();
      if (!bounds) {
        bounds = this.service.config.bounds ? this.service.config.bounds : this.document.body;
      }
      let debug = this.debug();
      if (!debug && debug !== false && this.service.config.debug) {
        debug = this.service.config.debug;
      }
      let readOnly = this.readOnly();
      if (!readOnly && this.readOnly() !== false) {
        readOnly = this.service.config.readOnly !== void 0 ? this.service.config.readOnly : false;
      }
      let defaultEmptyValue = this.defaultEmptyValue;
      if (this.service.config.hasOwnProperty("defaultEmptyValue")) {
        defaultEmptyValue = this.service.config.defaultEmptyValue;
      }
      let formats = this.formats();
      if (!formats && formats === void 0) {
        formats = this.service.config.formats ? [...this.service.config.formats] : this.service.config.formats === null ? null : void 0;
      }
      this.zone.runOutsideAngular(() => {
        this.quillEditor = new Quill(this.editorElem, {
          bounds,
          debug,
          formats,
          modules,
          placeholder,
          readOnly,
          defaultEmptyValue,
          registry: this.registry(),
          theme: this.theme() || (this.service.config.theme ? this.service.config.theme : "snow")
        });
        if (this.onNativeBlur.observed) {
          this.quillEditor.scroll.domNode.addEventListener("blur", () => this.onNativeBlur.next({
            editor: this.quillEditor,
            source: "dom"
          }));
          const toolbar = this.quillEditor.getModule("toolbar");
          toolbar.container?.addEventListener("mousedown", (e) => e.preventDefault());
        }
        if (this.onNativeFocus.observed) {
          this.quillEditor.scroll.domNode.addEventListener("focus", () => this.onNativeFocus.next({
            editor: this.quillEditor,
            source: "dom"
          }));
        }
        if (this.linkPlaceholder()) {
          const tooltip = this.quillEditor?.theme?.tooltip;
          const input2 = tooltip?.root?.querySelector("input[data-link]");
          if (input2?.dataset) {
            input2.dataset.link = this.linkPlaceholder();
          }
        }
      });
      if (this.content) {
        const format = getFormat(this.format(), this.service.config.format);
        if (format === "text") {
          this.quillEditor.setText(this.content, "silent");
        } else {
          const valueSetter = this.valueSetter();
          const newValue = valueSetter(this.quillEditor, this.content);
          this.quillEditor.setContents(newValue, "silent");
        }
        const history = this.quillEditor.getModule("history");
        history.clear();
      }
      this.setDisabledState();
      this.addQuillEventListeners();
      if (!this.onEditorCreated.observed && !this.onValidatorChanged) {
        return;
      }
      raf$().pipe(takeUntilDestroyed(this.destroyRef)).subscribe(() => {
        if (this.onValidatorChanged) {
          this.onValidatorChanged();
        }
        this.onEditorCreated.emit(this.quillEditor);
      });
    });
  }
  ngOnDestroy() {
    this.dispose();
    this.quillSubscription?.unsubscribe();
    this.quillSubscription = null;
  }
  ngOnChanges(changes) {
    if (!this.quillEditor) {
      return;
    }
    if (changes.readOnly) {
      this.quillEditor.enable(!changes.readOnly.currentValue);
    }
    if (changes.placeholder) {
      this.quillEditor.root.dataset.placeholder = changes.placeholder.currentValue;
    }
    if (changes.defaultEmptyValue) {
      this.quillEditor.root.dataset.defaultEmptyValue = changes.defaultEmptyValue.currentValue;
    }
    if (changes.styles) {
      const currentStyling = changes.styles.currentValue;
      const previousStyling = changes.styles.previousValue;
      if (previousStyling) {
        Object.keys(previousStyling).forEach((key) => {
          this.renderer.removeStyle(this.editorElem, key);
        });
      }
      if (currentStyling) {
        Object.keys(currentStyling).forEach((key) => {
          this.renderer.setStyle(this.editorElem, key, this.styles()[key]);
        });
      }
    }
    if (changes.classes) {
      const currentClasses = changes.classes.currentValue;
      const previousClasses = changes.classes.previousValue;
      if (previousClasses) {
        this.removeClasses(previousClasses);
      }
      if (currentClasses) {
        this.addClasses(currentClasses);
      }
    }
    if (changes.debounceTime) {
      this.addQuillEventListeners();
    }
  }
  addClasses(classList) {
    _QuillEditorBase.normalizeClassNames(classList).forEach((c) => {
      this.renderer.addClass(this.editorElem, c);
    });
  }
  removeClasses(classList) {
    _QuillEditorBase.normalizeClassNames(classList).forEach((c) => {
      this.renderer.removeClass(this.editorElem, c);
    });
  }
  writeValue(currentValue) {
    if (this.filterNull() && currentValue === null) {
      return;
    }
    this.content = currentValue;
    if (!this.quillEditor) {
      return;
    }
    const format = getFormat(this.format(), this.service.config.format);
    const valueSetter = this.valueSetter();
    const newValue = valueSetter(this.quillEditor, currentValue);
    if (this.compareValues()) {
      const currentEditorValue = this.quillEditor.getContents();
      if (JSON.stringify(currentEditorValue) === JSON.stringify(newValue)) {
        return;
      }
    }
    if (currentValue) {
      if (format === "text") {
        this.quillEditor.setText(currentValue);
      } else {
        this.quillEditor.setContents(newValue);
      }
      return;
    }
    this.quillEditor.setText("");
  }
  setDisabledState(isDisabled = this.disabled) {
    this.disabled = isDisabled;
    if (this.quillEditor) {
      if (isDisabled) {
        this.quillEditor.disable();
        this.renderer.setAttribute(this.elementRef.nativeElement, "disabled", "disabled");
      } else {
        if (!this.readOnly()) {
          this.quillEditor.enable();
        }
        this.renderer.removeAttribute(this.elementRef.nativeElement, "disabled");
      }
    }
  }
  registerOnChange(fn) {
    this.onModelChange = fn;
  }
  registerOnTouched(fn) {
    this.onModelTouched = fn;
  }
  registerOnValidatorChange(fn) {
    this.onValidatorChanged = fn;
  }
  validate() {
    if (!this.quillEditor) {
      return null;
    }
    const err = {};
    let valid = true;
    const text = this.quillEditor.getText();
    const textLength = this.trimOnValidation() ? text.trim().length : text.length === 1 && text.trim().length === 0 ? 0 : text.length - 1;
    const deltaOperations = this.quillEditor.getContents().ops;
    const onlyEmptyOperation = !!deltaOperations && deltaOperations.length === 1 && ["\n", ""].includes(deltaOperations[0].insert?.toString());
    if (this.minLength() && textLength && textLength < this.minLength()) {
      err.minLengthError = {
        given: textLength,
        minLength: this.minLength()
      };
      valid = false;
    }
    if (this.maxLength() && textLength > this.maxLength()) {
      err.maxLengthError = {
        given: textLength,
        maxLength: this.maxLength()
      };
      valid = false;
    }
    if (this.required() && !textLength && onlyEmptyOperation) {
      err.requiredError = {
        empty: true
      };
      valid = false;
    }
    return valid ? null : err;
  }
  addQuillEventListeners() {
    this.dispose();
    this.zone.runOutsideAngular(() => {
      this.subscription = new Subscription();
      this.subscription.add(
        // mark model as touched if editor lost focus
        fromEvent(this.quillEditor, "selection-change").subscribe(([range, oldRange, source]) => {
          this.selectionChangeHandler(range, oldRange, source);
        })
      );
      let textChange$ = fromEvent(this.quillEditor, "text-change");
      let editorChange$ = fromEvent(this.quillEditor, "editor-change");
      if (typeof this.debounceTime() === "number") {
        textChange$ = textChange$.pipe(debounceTime(this.debounceTime()));
        editorChange$ = editorChange$.pipe(debounceTime(this.debounceTime()));
      }
      this.subscription.add(
        // update model if text changes
        textChange$.subscribe(([delta, oldDelta, source]) => {
          this.textChangeHandler(delta, oldDelta, source);
        })
      );
      this.subscription.add(
        // triggered if selection or text changed
        editorChange$.subscribe(([event, current, old, source]) => {
          this.editorChangeHandler(event, current, old, source);
        })
      );
    });
  }
  dispose() {
    if (this.subscription !== null) {
      this.subscription.unsubscribe();
      this.subscription = null;
    }
  }
  isEmptyValue(html) {
    return html === "<p></p>" || html === "<div></div>" || html === "<p><br></p>" || html === "<div><br></div>";
  }
};
_QuillEditorBase.\u0275fac = function QuillEditorBase_Factory(t) {
  return new (t || _QuillEditorBase)();
};
_QuillEditorBase.\u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
  type: _QuillEditorBase,
  inputs: {
    format: [InputFlags.SignalBased, "format"],
    theme: [InputFlags.SignalBased, "theme"],
    modules: [InputFlags.SignalBased, "modules"],
    debug: [InputFlags.SignalBased, "debug"],
    readOnly: [InputFlags.SignalBased, "readOnly"],
    placeholder: [InputFlags.SignalBased, "placeholder"],
    maxLength: [InputFlags.SignalBased, "maxLength"],
    minLength: [InputFlags.SignalBased, "minLength"],
    required: [InputFlags.SignalBased, "required"],
    formats: [InputFlags.SignalBased, "formats"],
    customToolbarPosition: [InputFlags.SignalBased, "customToolbarPosition"],
    sanitize: [InputFlags.SignalBased, "sanitize"],
    beforeRender: [InputFlags.SignalBased, "beforeRender"],
    styles: [InputFlags.SignalBased, "styles"],
    registry: [InputFlags.SignalBased, "registry"],
    bounds: [InputFlags.SignalBased, "bounds"],
    customOptions: [InputFlags.SignalBased, "customOptions"],
    customModules: [InputFlags.SignalBased, "customModules"],
    trackChanges: [InputFlags.SignalBased, "trackChanges"],
    classes: [InputFlags.SignalBased, "classes"],
    trimOnValidation: [InputFlags.SignalBased, "trimOnValidation"],
    linkPlaceholder: [InputFlags.SignalBased, "linkPlaceholder"],
    compareValues: [InputFlags.SignalBased, "compareValues"],
    filterNull: [InputFlags.SignalBased, "filterNull"],
    debounceTime: [InputFlags.SignalBased, "debounceTime"],
    defaultEmptyValue: [InputFlags.SignalBased, "defaultEmptyValue"],
    valueGetter: [InputFlags.SignalBased, "valueGetter"],
    valueSetter: [InputFlags.SignalBased, "valueSetter"]
  },
  outputs: {
    onEditorCreated: "onEditorCreated",
    onEditorChanged: "onEditorChanged",
    onContentChanged: "onContentChanged",
    onSelectionChanged: "onSelectionChanged",
    onFocus: "onFocus",
    onBlur: "onBlur",
    onNativeFocus: "onNativeFocus",
    onNativeBlur: "onNativeBlur"
  },
  features: [\u0275\u0275NgOnChangesFeature]
});
var QuillEditorBase = _QuillEditorBase;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(QuillEditorBase, [{
    type: Directive
  }], null, {
    onEditorCreated: [{
      type: Output
    }],
    onEditorChanged: [{
      type: Output
    }],
    onContentChanged: [{
      type: Output
    }],
    onSelectionChanged: [{
      type: Output
    }],
    onFocus: [{
      type: Output
    }],
    onBlur: [{
      type: Output
    }],
    onNativeFocus: [{
      type: Output
    }],
    onNativeBlur: [{
      type: Output
    }]
  });
})();
var _QuillEditorComponent = class _QuillEditorComponent extends QuillEditorBase {
};
_QuillEditorComponent.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275QuillEditorComponent_BaseFactory;
  return function QuillEditorComponent_Factory(t) {
    return (\u0275QuillEditorComponent_BaseFactory || (\u0275QuillEditorComponent_BaseFactory = \u0275\u0275getInheritedFactory(_QuillEditorComponent)))(t || _QuillEditorComponent);
  };
})();
_QuillEditorComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: _QuillEditorComponent,
  selectors: [["quill-editor"]],
  standalone: true,
  features: [\u0275\u0275ProvidersFeature([{
    multi: true,
    provide: NG_VALUE_ACCESSOR,
    // eslint-disable-next-line @typescript-eslint/no-use-before-define
    useExisting: forwardRef(() => _QuillEditorComponent)
  }, {
    multi: true,
    provide: NG_VALIDATORS,
    // eslint-disable-next-line @typescript-eslint/no-use-before-define
    useExisting: forwardRef(() => _QuillEditorComponent)
  }]), \u0275\u0275InheritDefinitionFeature, \u0275\u0275StandaloneFeature],
  ngContentSelectors: _c12,
  decls: 5,
  vars: 2,
  consts: [["quill-editor-element", ""]],
  template: function QuillEditorComponent_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275projectionDef(_c09);
      \u0275\u0275template(0, QuillEditorComponent_Conditional_0_Template, 1, 0, "div", 0);
      \u0275\u0275projection(1);
      \u0275\u0275projection(2, 1);
      \u0275\u0275projection(3, 2);
      \u0275\u0275template(4, QuillEditorComponent_Conditional_4_Template, 1, 0, "div", 0);
    }
    if (rf & 2) {
      \u0275\u0275conditional(0, ctx.toolbarPosition() !== "top" ? 0 : -1);
      \u0275\u0275advance(4);
      \u0275\u0275conditional(4, ctx.toolbarPosition() === "top" ? 4 : -1);
    }
  },
  styles: ["[_nghost-%COMP%]{display:inline-block}"]
});
var QuillEditorComponent = _QuillEditorComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(QuillEditorComponent, [{
    type: Component,
    args: [{
      encapsulation: ViewEncapsulation$1.Emulated,
      providers: [{
        multi: true,
        provide: NG_VALUE_ACCESSOR,
        // eslint-disable-next-line @typescript-eslint/no-use-before-define
        useExisting: forwardRef(() => QuillEditorComponent)
      }, {
        multi: true,
        provide: NG_VALIDATORS,
        // eslint-disable-next-line @typescript-eslint/no-use-before-define
        useExisting: forwardRef(() => QuillEditorComponent)
      }],
      selector: "quill-editor",
      template: `
    @if (toolbarPosition() !== 'top') {
        <div quill-editor-element></div>
    }

    <ng-content select="[above-quill-editor-toolbar]"></ng-content>
    <ng-content select="[quill-editor-toolbar]"></ng-content>
    <ng-content select="[below-quill-editor-toolbar]"></ng-content>

    @if (toolbarPosition() === 'top') {
        <div quill-editor-element></div>
    }
  `,
      standalone: true,
      styles: [":host{display:inline-block}\n"]
    }]
  }], null, null);
})();
var _QuillViewHTMLComponent = class _QuillViewHTMLComponent {
  constructor(sanitizer, service) {
    this.sanitizer = sanitizer;
    this.service = service;
    this.content = input("");
    this.theme = input(void 0);
    this.sanitize = input(false);
    this.innerHTML = signal("");
    this.themeClass = signal("ql-snow");
  }
  ngOnChanges(changes) {
    if (changes.theme) {
      const theme = changes.theme.currentValue || (this.service.config.theme ? this.service.config.theme : "snow");
      this.themeClass.set(`ql-${theme} ngx-quill-view-html`);
    } else if (!this.theme()) {
      const theme = this.service.config.theme ? this.service.config.theme : "snow";
      this.themeClass.set(`ql-${theme} ngx-quill-view-html`);
    }
    if (changes.content) {
      const content = changes.content.currentValue;
      const sanitize = [true, false].includes(this.sanitize()) ? this.sanitize() : this.service.config.sanitize || false;
      const innerHTML = sanitize ? content : this.sanitizer.bypassSecurityTrustHtml(content);
      this.innerHTML.set(innerHTML);
    }
  }
};
_QuillViewHTMLComponent.\u0275fac = function QuillViewHTMLComponent_Factory(t) {
  return new (t || _QuillViewHTMLComponent)(\u0275\u0275directiveInject(DomSanitizer), \u0275\u0275directiveInject(QuillService));
};
_QuillViewHTMLComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: _QuillViewHTMLComponent,
  selectors: [["quill-view-html"]],
  inputs: {
    content: [InputFlags.SignalBased, "content"],
    theme: [InputFlags.SignalBased, "theme"],
    sanitize: [InputFlags.SignalBased, "sanitize"]
  },
  standalone: true,
  features: [\u0275\u0275NgOnChangesFeature, \u0275\u0275StandaloneFeature],
  decls: 2,
  vars: 2,
  consts: [[1, "ql-container", 3, "ngClass"], [1, "ql-editor", 3, "innerHTML"]],
  template: function QuillViewHTMLComponent_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275elementStart(0, "div", 0);
      \u0275\u0275element(1, "div", 1);
      \u0275\u0275elementEnd();
    }
    if (rf & 2) {
      \u0275\u0275property("ngClass", ctx.themeClass());
      \u0275\u0275advance();
      \u0275\u0275property("innerHTML", ctx.innerHTML(), \u0275\u0275sanitizeHtml);
    }
  },
  dependencies: [NgClass],
  styles: [".ql-container.ngx-quill-view-html{border:0}\n"],
  encapsulation: 2
});
var QuillViewHTMLComponent = _QuillViewHTMLComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(QuillViewHTMLComponent, [{
    type: Component,
    args: [{
      encapsulation: ViewEncapsulation$1.None,
      selector: "quill-view-html",
      template: `
  <div class="ql-container" [ngClass]="themeClass()">
    <div class="ql-editor" [innerHTML]="innerHTML()">
    </div>
  </div>
`,
      standalone: true,
      imports: [NgClass],
      styles: [".ql-container.ngx-quill-view-html{border:0}\n"]
    }]
  }], () => [{
    type: DomSanitizer
  }, {
    type: QuillService
  }], null);
})();
var _QuillViewComponent = class _QuillViewComponent {
  constructor(elementRef, renderer, zone, service, domSanitizer, platformId) {
    this.elementRef = elementRef;
    this.renderer = renderer;
    this.zone = zone;
    this.service = service;
    this.domSanitizer = domSanitizer;
    this.platformId = platformId;
    this.format = input(void 0);
    this.theme = input(void 0);
    this.modules = input(void 0);
    this.debug = input(false);
    this.formats = input(void 0);
    this.sanitize = input(false);
    this.beforeRender = input(void 0);
    this.strict = input(true);
    this.content = input();
    this.customModules = input([]);
    this.customOptions = input([]);
    this.onEditorCreated = new EventEmitter();
    this.quillSubscription = null;
    this.destroyRef = inject(DestroyRef);
    this.valueSetter = (quillEditor, value) => {
      const format = getFormat(this.format(), this.service.config.format);
      let content = value;
      if (format === "text") {
        quillEditor.setText(content);
      } else {
        if (format === "html") {
          const sanitize = [true, false].includes(this.sanitize()) ? this.sanitize() : this.service.config.sanitize || false;
          if (sanitize) {
            value = this.domSanitizer.sanitize(SecurityContext.HTML, value);
          }
          content = quillEditor.clipboard.convert({
            html: value
          });
        } else if (format === "json") {
          try {
            content = JSON.parse(value);
          } catch (e) {
            content = [{
              insert: value
            }];
          }
        }
        quillEditor.setContents(content);
      }
    };
  }
  ngOnChanges(changes) {
    if (!this.quillEditor) {
      return;
    }
    if (changes.content) {
      this.valueSetter(this.quillEditor, changes.content.currentValue);
    }
  }
  ngAfterViewInit() {
    if (isPlatformServer(this.platformId)) {
      return;
    }
    this.quillSubscription = this.service.getQuill().pipe(mergeMap((Quill) => {
      const promises = [this.service.registerCustomModules(Quill, this.customModules())];
      const beforeRender = this.beforeRender() ?? this.service.config.beforeRender;
      if (beforeRender) {
        promises.push(beforeRender());
      }
      return Promise.all(promises).then(() => Quill);
    })).subscribe((Quill) => {
      const modules = Object.assign({}, this.modules() || this.service.config.modules);
      modules.toolbar = false;
      this.customOptions().forEach((customOption) => {
        const newCustomOption = Quill.import(customOption.import);
        newCustomOption.whitelist = customOption.whitelist;
        Quill.register(newCustomOption, true);
      });
      let debug = this.debug();
      if (!debug && debug !== false && this.service.config.debug) {
        debug = this.service.config.debug;
      }
      let formats = this.formats();
      if (!formats && formats === void 0) {
        formats = this.service.config.formats ? Object.assign({}, this.service.config.formats) : this.service.config.formats === null ? null : void 0;
      }
      const theme = this.theme() || (this.service.config.theme ? this.service.config.theme : "snow");
      this.editorElem = this.elementRef.nativeElement.querySelector("[quill-view-element]");
      this.zone.runOutsideAngular(() => {
        this.quillEditor = new Quill(this.editorElem, {
          debug,
          formats,
          modules,
          readOnly: true,
          strict: this.strict(),
          theme
        });
      });
      this.renderer.addClass(this.editorElem, "ngx-quill-view");
      if (this.content()) {
        this.valueSetter(this.quillEditor, this.content());
      }
      if (!this.onEditorCreated.observed) {
        return;
      }
      raf$().pipe(takeUntilDestroyed(this.destroyRef)).subscribe(() => {
        this.onEditorCreated.emit(this.quillEditor);
      });
    });
  }
  ngOnDestroy() {
    this.quillSubscription?.unsubscribe();
    this.quillSubscription = null;
  }
};
_QuillViewComponent.\u0275fac = function QuillViewComponent_Factory(t) {
  return new (t || _QuillViewComponent)(\u0275\u0275directiveInject(ElementRef), \u0275\u0275directiveInject(Renderer2), \u0275\u0275directiveInject(NgZone), \u0275\u0275directiveInject(QuillService), \u0275\u0275directiveInject(DomSanitizer), \u0275\u0275directiveInject(PLATFORM_ID));
};
_QuillViewComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
  type: _QuillViewComponent,
  selectors: [["quill-view"]],
  inputs: {
    format: [InputFlags.SignalBased, "format"],
    theme: [InputFlags.SignalBased, "theme"],
    modules: [InputFlags.SignalBased, "modules"],
    debug: [InputFlags.SignalBased, "debug"],
    formats: [InputFlags.SignalBased, "formats"],
    sanitize: [InputFlags.SignalBased, "sanitize"],
    beforeRender: [InputFlags.SignalBased, "beforeRender"],
    strict: [InputFlags.SignalBased, "strict"],
    content: [InputFlags.SignalBased, "content"],
    customModules: [InputFlags.SignalBased, "customModules"],
    customOptions: [InputFlags.SignalBased, "customOptions"]
  },
  outputs: {
    onEditorCreated: "onEditorCreated"
  },
  standalone: true,
  features: [\u0275\u0275NgOnChangesFeature, \u0275\u0275StandaloneFeature],
  decls: 1,
  vars: 0,
  consts: [["quill-view-element", ""]],
  template: function QuillViewComponent_Template(rf, ctx) {
    if (rf & 1) {
      \u0275\u0275element(0, "div", 0);
    }
  },
  styles: [".ql-container.ngx-quill-view{border:0}\n"],
  encapsulation: 2
});
var QuillViewComponent = _QuillViewComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(QuillViewComponent, [{
    type: Component,
    args: [{
      encapsulation: ViewEncapsulation$1.None,
      selector: "quill-view",
      template: `
  <div quill-view-element></div>
`,
      standalone: true,
      styles: [".ql-container.ngx-quill-view{border:0}\n"]
    }]
  }], () => [{
    type: ElementRef
  }, {
    type: Renderer2
  }, {
    type: NgZone
  }, {
    type: QuillService
  }, {
    type: DomSanitizer
  }, {
    type: void 0,
    decorators: [{
      type: Inject,
      args: [PLATFORM_ID]
    }]
  }], {
    onEditorCreated: [{
      type: Output
    }]
  });
})();
var _QuillModule = class _QuillModule {
  static forRoot(config) {
    return {
      ngModule: _QuillModule,
      providers: [{
        provide: QUILL_CONFIG_TOKEN,
        useValue: config
      }]
    };
  }
};
_QuillModule.\u0275fac = function QuillModule_Factory(t) {
  return new (t || _QuillModule)();
};
_QuillModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
  type: _QuillModule
});
_QuillModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({});
var QuillModule = _QuillModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(QuillModule, [{
    type: NgModule,
    args: [{
      imports: [QuillEditorComponent, QuillViewComponent, QuillViewHTMLComponent],
      exports: [QuillEditorComponent, QuillViewComponent, QuillViewHTMLComponent]
    }]
  }], null, null);
})();

// src/app/@lcp-framework/formly/components/formly-rich-editor/formly-rich-editor.component.ts
var _c010 = ["quillEditor"];
var _c13 = ["htmlEditor"];
var _c22 = (a0, a1) => ({ "btn-outline-dark": a0, "btn-dark": a1 });
function FormlyRichEditorComponent_button_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 7);
    \u0275\u0275listener("click", function FormlyRichEditorComponent_button_2_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.showPreview());
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction2(2, _c22, ctx_r1.isHtmlMode, !ctx_r1.isHtmlMode));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", "PREVIEW", " ");
  }
}
function FormlyRichEditorComponent_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 7);
    \u0275\u0275listener("click", function FormlyRichEditorComponent_button_3_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.toggleHtmlEdit());
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction2(2, _c22, ctx_r1.isHtmlMode, !ctx_r1.isHtmlMode));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r1.isHtmlMode ? "BACK" : "EDIT HTML", " ");
  }
}
function FormlyRichEditorComponent_quill_editor_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "quill-editor", 8, 0);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275styleProp("height", ctx_r1.to["rows"] ? ctx_r1.to["rows"] * 24 : 200, "px");
    \u0275\u0275property("formControl", ctx_r1.formControl)("formlyAttributes", ctx_r1.field)("modules", ctx_r1.to["modules"] || ctx_r1.modules)("placeholder", ctx_r1.to["placeholder"] || "Enter text...")("readOnly", ctx_r1.to["readonly"] || false);
  }
}
function FormlyRichEditorComponent_ngx_monaco_editor_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "ngx-monaco-editor", 9, 1);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275styleProp("height", (ctx_r1.to["rows"] ? ctx_r1.to["rows"] * 24 : 200) + 50, "px");
    \u0275\u0275property("options", ctx_r1.editorOptions)("formControl", ctx_r1.formControl);
  }
}
function FormlyRichEditorComponent_div_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 10);
    \u0275\u0275element(1, "div", 11);
    \u0275\u0275elementStart(2, "div", 12)(3, "div", 13)(4, "div", 14)(5, "div", 15)(6, "div", 16)(7, "p", 17);
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(9, "button", 18);
    \u0275\u0275listener("click", function FormlyRichEditorComponent_div_6_Template_button_click_9_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.hidePreview());
    });
    \u0275\u0275elementStart(10, "span", 19);
    \u0275\u0275text(11, "Close");
    \u0275\u0275elementEnd();
    \u0275\u0275element(12, "i", 20);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(13, "div", 21);
    \u0275\u0275element(14, "div", 22);
    \u0275\u0275pipe(15, "safeHtml");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate("Preview");
    \u0275\u0275advance(6);
    \u0275\u0275property("innerHTML", \u0275\u0275pipeBind1(15, 2, ctx_r1.formControl.value), \u0275\u0275sanitizeHtml);
  }
}
var _FormlyRichEditorComponent = class _FormlyRichEditorComponent extends FieldType {
  constructor() {
    super(...arguments);
    this.isHtmlMode = false;
    this.preview = false;
    this.editorOptions = {
      language: "json",
      // Enable JSON syntax highlighting
      theme: "vs-dark",
      // or 'vs', 'hc-black'
      automaticLayout: true,
      // Auto-resize with container
      minimap: { enabled: false },
      // Disable minimap for simplicity
      scrollBeyondLastLine: false,
      fontSize: 14,
      lineNumbers: "on",
      // or 'off'
      folding: true,
      // Enable code folding
      lineDecorationsWidth: 10,
      overviewRulerBorder: false,
      scrollbar: {
        verticalScrollbarSize: 8,
        horizontalScrollbarSize: 8
      },
      // JSON-specific features
      formatOnPaste: true,
      formatOnType: true,
      suggest: {
        showWords: false
        // Disable word suggestions (focus on JSON keys)
      },
      // Validation & Hover
      hover: { enabled: true },
      validate: true
      // Enable JSON validation
    };
    this.modules = {
      toolbar: [
        ["bold", "italic", "underline"],
        // toggled buttons
        ["blockquote", "code-block"],
        [{ header: 1 }, { header: 2 }],
        // custom button values
        [{ list: "ordered" }, { list: "bullet" }],
        [{ script: "sub" }, { script: "super" }],
        // superscript/subscript
        [{ indent: "-1" }, { indent: "+1" }],
        // outdent/indent
        [{ direction: "rtl" }],
        // text direction
        [{ size: ["small", false, "large", "huge"] }],
        // custom dropdown
        [{ header: [1, 2, 3, 4, 5, 6, false] }],
        [{ color: [] }, { background: [] }],
        // dropdown with defaults from theme
        [{ font: [] }],
        [{ align: [] }],
        ["clean"],
        // remove formatting button
        ["link"]
        // link and image, video
      ]
    };
  }
  toggleHtmlEdit() {
    this.isHtmlMode = !this.isHtmlMode;
  }
  showPreview() {
    this.preview = true;
  }
  hidePreview() {
    this.preview = false;
  }
};
_FormlyRichEditorComponent.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyRichEditorComponent_BaseFactory;
  return function FormlyRichEditorComponent_Factory(t) {
    return (\u0275FormlyRichEditorComponent_BaseFactory || (\u0275FormlyRichEditorComponent_BaseFactory = \u0275\u0275getInheritedFactory(_FormlyRichEditorComponent)))(t || _FormlyRichEditorComponent);
  };
})();
_FormlyRichEditorComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FormlyRichEditorComponent, selectors: [["app-formly-rich-editor"]], viewQuery: function FormlyRichEditorComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c010, 5);
    \u0275\u0275viewQuery(_c13, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.quillEditor = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.htmlEditor = _t.first);
  }
}, features: [\u0275\u0275InheritDefinitionFeature], decls: 7, vars: 5, consts: [["quillEditor", ""], ["htmlEditor", ""], [1, "toolbar"], ["type", "button", "class", "btn btn-sm", 3, "ngClass", "click", 4, "ngIf"], [3, "formControl", "formlyAttributes", "modules", "placeholder", "readOnly", "height", 4, "ngIf"], ["class", "monaco-editor", 3, "options", "height", "formControl", 4, "ngIf"], ["class", "fixed inset-0 z-50 overflow-y-auto", 4, "ngIf"], ["type", "button", 1, "btn", "btn-sm", 3, "click", "ngClass"], [3, "formControl", "formlyAttributes", "modules", "placeholder", "readOnly"], [1, "monaco-editor", 3, "options", "formControl"], [1, "fixed", "inset-0", "z-50", "overflow-y-auto"], [1, "fixed", "inset-0", "bg-black/50", "transition-opacity", "dark:bg-black/70"], [1, "flex", "min-h-screen", "items-center", "justify-center", "p-2", "sm:p-4"], [1, "max-w-auto", "relative", "w-10/12", "transform", "overflow-hidden", "rounded-lg", "bg-white", "shadow-xl", "transition-all", "dark:border", "dark:border-gray-700", "dark:bg-gray-800", "sm:w-8/12"], [1, "border-b", "bg-gray-50", "px-4", "py-3", "dark:border-gray-700", "dark:bg-gray-900", "sm:px-6"], [1, "flex", "items-center", "justify-between"], [1, "flex", "gap-4"], ["appDynamicFontSize", "body", 1, "text-md", "font-bold"], [1, "close-btn", 3, "click"], [1, "sr-only"], [1, "fa-solid", "fa-xmark"], [1, "max-h-auto", "gap-5", "overflow-y-auto", "px-4", "py-4", "sm:px-6"], [3, "innerHTML"]], template: function FormlyRichEditorComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div")(1, "div", 2);
    \u0275\u0275template(2, FormlyRichEditorComponent_button_2_Template, 2, 5, "button", 3)(3, FormlyRichEditorComponent_button_3_Template, 2, 5, "button", 3);
    \u0275\u0275elementEnd();
    \u0275\u0275template(4, FormlyRichEditorComponent_quill_editor_4_Template, 2, 7, "quill-editor", 4)(5, FormlyRichEditorComponent_ngx_monaco_editor_5_Template, 2, 4, "ngx-monaco-editor", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275template(6, FormlyRichEditorComponent_div_6_Template, 16, 4, "div", 6);
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.to["preview"] || false);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.to["html-editor"] || false);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !ctx.isHtmlMode);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isHtmlMode);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.preview);
  }
}, dependencies: [QuillEditorComponent, EditorComponent, NgClass, NgIf, NgControlStatus, FormControlDirective, FormlyAttributes, SafeHtmlPipe], styles: ["\n\n.toolbar[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  margin-bottom: 5px;\n  gap: 5px;\n  flex-wrap: wrap;\n}\n/*# sourceMappingURL=formly-rich-editor.component.css.map */"] });
var FormlyRichEditorComponent = _FormlyRichEditorComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FormlyRichEditorComponent, { className: "FormlyRichEditorComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\formly-rich-editor\\formly-rich-editor.component.ts", lineNumber: 9 });
})();

// src/app/@lcp-framework/formly/components/formly-display-list/formly-display-list.component.ts
function FormlyDisplayListComponent_div_0_a_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 3);
    \u0275\u0275listener("click", function FormlyDisplayListComponent_div_0_a_1_Template_a_click_0_listener() {
      const item_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r2.copyContent(item_r2.label));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r2 = ctx.$implicit;
    \u0275\u0275classMapInterpolate1("px-4 py-2.5 hover:bg-[#eee] dark:hover:bg-[#eee]/10 val-", item_r2.value, "");
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(item_r2.label);
  }
}
function FormlyDisplayListComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 1);
    \u0275\u0275template(1, FormlyDisplayListComponent_div_0_a_1_Template, 2, 4, "a", 2);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r2.listDatas);
  }
}
var _FormlyDisplayListComponent = class _FormlyDisplayListComponent extends FieldType {
  constructor(gridApiService, cdr, renderer) {
    super();
    this.gridApiService = gridApiService;
    this.cdr = cdr;
    this.renderer = renderer;
    this.listDatas = [];
  }
  ngOnInit() {
    this.setData();
    this.fileNameControl = this.form.get("email_template_process_id");
    this.fileNameControl?.valueChanges.subscribe(() => {
      this.setData();
    });
  }
  setData() {
    const email_template_process_id = this.fileNameControl?.value;
    if (email_template_process_id) {
      const listParams = {
        company_id: 1,
        search_all: [
          {
            value: "1",
            operator: "=",
            column_name: "status_id"
          },
          {
            value: email_template_process_id,
            operator: "=",
            column_name: "email_template_process_tags_mapping.email_template_process_id"
          }
        ],
        limit_range: 1e3,
        print_query: true,
        start_index: 0,
        sort_columns: [["email_template_tags.slug", "asc"]],
        primary_table: "email_template_tags",
        select_columns: [
          ["email_template_tags.id", "value"],
          ["email_template_tags.slug", "label"]
        ],
        includes: [
          {
            table_name: "email_template_process_tags_mapping",
            join_type: "INNER",
            join_condition: "email_template_tags.id = email_template_process_tags_mapping.email_template_tag_id"
          }
        ]
      };
      this.gridApiService.getAllList(listParams).subscribe((response) => {
        if (response.status && response.code === 200) {
          this.listDatas = response.data.records;
          this.cdr.detectChanges();
        }
      });
    }
  }
  copyContent(content) {
    const textarea = this.renderer.createElement("textarea");
    this.renderer.setStyle(textarea, "position", "fixed");
    this.renderer.setStyle(textarea, "opacity", "0");
    textarea.value = content;
    this.renderer.appendChild(document.body, textarea);
    textarea.select();
    document.execCommand("copy");
    this.renderer.removeChild(document.body, textarea);
  }
  get formControl() {
    return this.form.get(this.field.key);
  }
};
_FormlyDisplayListComponent.\u0275fac = function FormlyDisplayListComponent_Factory(t) {
  return new (t || _FormlyDisplayListComponent)(\u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(ChangeDetectorRef), \u0275\u0275directiveInject(Renderer2));
};
_FormlyDisplayListComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FormlyDisplayListComponent, selectors: [["app-formly-display-list"]], features: [\u0275\u0275InheritDefinitionFeature], decls: 1, vars: 1, consts: [["class", "flex flex-wrap rounded-md border border-[#e0e6ed] dark:border-[#1b2e4b]", 4, "ngIf"], [1, "flex", "flex-wrap", "rounded-md", "border", "border-[#e0e6ed]", "dark:border-[#1b2e4b]"], ["title", "Click to copy", "href", "javascript:;", 3, "class", "click", 4, "ngFor", "ngForOf"], ["title", "Click to copy", "href", "javascript:;", 3, "click"]], template: function FormlyDisplayListComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, FormlyDisplayListComponent_div_0_Template, 2, 1, "div", 0);
  }
  if (rf & 2) {
    \u0275\u0275property("ngIf", (ctx.listDatas == null ? null : ctx.listDatas.length) > 0);
  }
}, dependencies: [NgForOf, NgIf] });
var FormlyDisplayListComponent = _FormlyDisplayListComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FormlyDisplayListComponent, { className: "FormlyDisplayListComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\formly-display-list\\formly-display-list.component.ts", lineNumber: 12 });
})();

// src/app/@lcp-framework/formly/components/formly-vs-code/formly-vs-code.component.ts
var _FormlyVsCodeComponent = class _FormlyVsCodeComponent extends FieldType {
  ngOnInit() {
    this.editorOptions = {
      theme: "vs-dark",
      language: "json",
      automaticLayout: true,
      formatOnType: true,
      formatOnPaste: true,
      insertSpaces: true,
      tabSize: 2
    };
    this.formControl.valueChanges.subscribe((value) => {
      if (this.editorInstance) {
        const editorValue = this.editorInstance.getValue();
        const formattedValue = this.prettyJSON(value);
        if (editorValue !== formattedValue) {
          this.editorInstance.setValue(formattedValue);
        }
      }
    });
  }
  onEditorInit(editor) {
    this.editorInstance = editor;
    const value = this.formControl?.value;
    const formatted = this.prettyJSON(value);
    this.editorInstance.setValue(formatted);
    this.editorInstance.onDidChangeModelContent(() => {
      const currentValue = this.editorInstance.getValue();
      if (this.formControl.value !== currentValue) {
        this.formControl.setValue(currentValue, { emitEvent: false });
      }
    });
  }
  prettyJSON(data) {
    try {
      return typeof data === "string" ? JSON.stringify(JSON.parse(data), null, 2) : JSON.stringify(data, null, 2);
    } catch (e) {
      return data;
    }
  }
};
_FormlyVsCodeComponent.\u0275fac = /* @__PURE__ */ (() => {
  let \u0275FormlyVsCodeComponent_BaseFactory;
  return function FormlyVsCodeComponent_Factory(t) {
    return (\u0275FormlyVsCodeComponent_BaseFactory || (\u0275FormlyVsCodeComponent_BaseFactory = \u0275\u0275getInheritedFactory(_FormlyVsCodeComponent)))(t || _FormlyVsCodeComponent);
  };
})();
_FormlyVsCodeComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FormlyVsCodeComponent, selectors: [["app-formly-vs-code"]], features: [\u0275\u0275InheritDefinitionFeature], decls: 2, vars: 2, consts: [["appDynamicFontSize", "body", 1, "monaco-editor-container"], ["monacoEditor", "", 1, "monaco-editor", 3, "onInit", "options", "formControl"]], template: function FormlyVsCodeComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "ngx-monaco-editor", 1);
    \u0275\u0275listener("onInit", function FormlyVsCodeComponent_Template_ngx_monaco_editor_onInit_1_listener($event) {
      return ctx.onEditorInit($event);
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("options", ctx.editorOptions)("formControl", ctx.formControl);
  }
}, dependencies: [EditorComponent, NgControlStatus, FormControlDirective], styles: ["\n\n.monaco-editor-container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 50vh;\n  resize: vertical;\n  min-height: 60vh;\n  max-height: 100vh;\n}\n.monaco-editor[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n}\n.editor-container[_ngcontent-%COMP%] {\n  position: relative;\n}\n.editor-overlay[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  overflow: auto;\n  cursor: pointer !important;\n  background: transparent;\n  pointer-events: none;\n}\n.monaco-editor[_ngcontent-%COMP%] {\n  cursor: pointer !important;\n}\n.monaco-editor[_ngcontent-%COMP%]   .view-line[_ngcontent-%COMP%] {\n  cursor: pointer !important;\n}\n/*# sourceMappingURL=formly-vs-code.component.css.map */"] });
var FormlyVsCodeComponent = _FormlyVsCodeComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FormlyVsCodeComponent, { className: "FormlyVsCodeComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\formly-vs-code\\formly-vs-code.component.ts", lineNumber: 10 });
})();

// src/app/@lcp-framework/formly/components/formly-repeat-table-field/formly-repeat-table-field.component.ts
var _c011 = (a0) => ({ hidden: a0 });
var _c14 = (a0) => ({ "cursor-auto text-blue-600": a0 });
function FormlyRepeatTableFieldComponent_div_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 10);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.errorMessage, " ");
  }
}
function FormlyRepeatTableFieldComponent_table_10_th_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "th", 15);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const field_r2 = ctx.$implicit;
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(2, _c011, field_r2.props && field_r2.props["hideColumn"]));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", (field_r2.props == null ? null : field_r2.props.label) || field_r2.key, " ");
  }
}
function FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275text(1);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const fieldValue_r4 = ctx.ngIf;
    const field_r5 = \u0275\u0275nextContext().$implicit;
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getSafeDisplayValue(fieldValue_r4, field_r5.props == null ? null : field_r5.props.options), " ");
  }
}
function FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "img", 23);
    \u0275\u0275listener("click", function FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_ng_container_2_Template_img_click_1_listener() {
      let tmp_9_0;
      \u0275\u0275restoreView(_r6);
      const field_r5 = \u0275\u0275nextContext().$implicit;
      const ctx_r6 = \u0275\u0275nextContext();
      const fgRow_r8 = ctx_r6.$implicit;
      const i_r9 = ctx_r6.index;
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.downloadFile(ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_9_0 = field_r5.key) !== null && tmp_9_0 !== void 0 ? tmp_9_0 : "")), i_r9));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    let tmp_8_0;
    let tmp_9_0;
    const field_r5 = \u0275\u0275nextContext().$implicit;
    const ctx_r6 = \u0275\u0275nextContext();
    const fgRow_r8 = ctx_r6.$implicit;
    const i_r9 = ctx_r6.index;
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("title", (ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_8_0 = field_r5.key) !== null && tmp_8_0 !== void 0 ? tmp_8_0 : ""), true) || "").includes("http") ? "Download the file " + ctx_r0.getFileExtension(ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_8_0 = field_r5.key) !== null && tmp_8_0 !== void 0 ? tmp_8_0 : "")), i_r9) : "")("src", ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_9_0 = field_r5.key) !== null && tmp_9_0 !== void 0 ? tmp_9_0 : "")), \u0275\u0275sanitizeUrl);
  }
}
function FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_ng_template_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 24);
    \u0275\u0275listener("click", function FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_ng_template_3_Template_div_click_0_listener() {
      let tmp_9_0;
      \u0275\u0275restoreView(_r10);
      const field_r5 = \u0275\u0275nextContext().$implicit;
      const ctx_r6 = \u0275\u0275nextContext();
      const fgRow_r8 = ctx_r6.$implicit;
      const i_r9 = ctx_r6.index;
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.downloadFile(ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_9_0 = field_r5.key) !== null && tmp_9_0 !== void 0 ? tmp_9_0 : "")), i_r9));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    let tmp_8_0;
    let tmp_9_0;
    let tmp_10_0;
    const field_r5 = \u0275\u0275nextContext().$implicit;
    const ctx_r6 = \u0275\u0275nextContext();
    const fgRow_r8 = ctx_r6.$implicit;
    const i_r9 = ctx_r6.index;
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(3, _c14, (ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_8_0 = field_r5.key) !== null && tmp_8_0 !== void 0 ? tmp_8_0 : "")) || "").includes("http")))("title", (ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_9_0 = field_r5.key) !== null && tmp_9_0 !== void 0 ? tmp_9_0 : ""), true) || "").includes("http") ? "Download the file " + ctx_r0.getFileExtension(ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_9_0 = field_r5.key) !== null && tmp_9_0 !== void 0 ? tmp_9_0 : "")), i_r9) : "");
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getFileExtension(ctx_r0.getImageSrc(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_10_0 = field_r5.key) !== null && tmp_10_0 !== void 0 ? tmp_10_0 : "")), i_r9), " ");
  }
}
function FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "td", 20);
    \u0275\u0275template(1, FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_ng_container_1_Template, 2, 1, "ng-container", 21)(2, FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_ng_container_2_Template, 2, 2, "ng-container", 22)(3, FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_ng_template_3_Template, 2, 5, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    let tmp_8_0;
    let tmp_9_0;
    const field_r5 = ctx.$implicit;
    const showUrl_r11 = \u0275\u0275reference(4);
    const fgRow_r8 = \u0275\u0275nextContext().$implicit;
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(4, _c011, field_r5.props && field_r5.props["hideColumn"]));
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", field_r5.type !== "image" && field_r5.type !== "file" && ((tmp_8_0 = fgRow_r8.get(ctx_r0.coerceKeyToString((tmp_8_0 = field_r5.key) !== null && tmp_8_0 !== void 0 ? tmp_8_0 : ""))) == null ? null : tmp_8_0.value));
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", (field_r5.type === "image" || field_r5.type === "file") && ctx_r0.isImageUrl(fgRow_r8.value, ctx_r0.coerceKeyToString((tmp_9_0 = field_r5.key) !== null && tmp_9_0 !== void 0 ? tmp_9_0 : "")))("ngIfElse", showUrl_r11);
  }
}
function FormlyRepeatTableFieldComponent_table_10_tr_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "tr");
    \u0275\u0275template(1, FormlyRepeatTableFieldComponent_table_10_tr_7_td_1_Template, 5, 6, "td", 16);
    \u0275\u0275elementStart(2, "td", 13)(3, "div", 17)(4, "i", 18);
    \u0275\u0275listener("click", function FormlyRepeatTableFieldComponent_table_10_tr_7_Template_i_click_4_listener() {
      const i_r9 = \u0275\u0275restoreView(_r3).index;
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.editRow(i_r9));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "i", 19);
    \u0275\u0275listener("click", function FormlyRepeatTableFieldComponent_table_10_tr_7_Template_i_click_5_listener() {
      const i_r9 = \u0275\u0275restoreView(_r3).index;
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.deleteRow(i_r9));
    });
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r0.getFieldGroup());
  }
}
function FormlyRepeatTableFieldComponent_table_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "table", 11)(1, "thead")(2, "tr");
    \u0275\u0275template(3, FormlyRepeatTableFieldComponent_table_10_th_3_Template, 2, 4, "th", 12);
    \u0275\u0275elementStart(4, "th", 13);
    \u0275\u0275text(5, "Actions");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(6, "tbody");
    \u0275\u0275template(7, FormlyRepeatTableFieldComponent_table_10_tr_7_Template, 6, 1, "tr", 14);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275property("ngForOf", ctx_r0.getFieldGroup());
    \u0275\u0275advance(4);
    \u0275\u0275property("ngForOf", ctx_r0.formArray.controls);
  }
}
var _FormlyRepeatTableFieldComponent = class _FormlyRepeatTableFieldComponent extends FieldArrayType {
  constructor() {
    super();
    this.currentRowIndex = null;
    this.errorMessage = "";
    this.imageExtensions = [];
    this.editForm = new FormGroup({});
  }
  isImageUrl(fieldValue, key) {
    const pathKey = this.removeSuffix(key, "_file");
    let url = "";
    if (!fieldValue[key] && fieldValue[pathKey]) {
      url = `${environment.apiUrl}/${fieldValue[pathKey]}`;
    } else {
      const ImageValue = fieldValue[key];
      if (typeof fieldValue === "string") {
        url = ImageValue;
      } else if (ImageValue instanceof FileList && ImageValue.length > 0) {
        url = ImageValue[0].name;
      } else if (ImageValue instanceof File) {
        url = ImageValue.name;
      }
    }
    if (url) {
      const extension = url.split(".").pop() || "";
      return ["jpg", "jpeg", "png", "gif", "svg", "ico", "webp"].includes(extension);
    }
    return false;
  }
  ngOnInit() {
    this.initializeDynamicForm();
    if (this.formControl instanceof FormArray) {
      this.formArray = this.formControl;
    } else {
      console.error("formControl is not an instance of FormArray. Check your form configuration.");
      return;
    }
    if (!this.formArray) {
      this.formArray = new FormArray([]);
    }
    this.editForm.valueChanges.subscribe(() => {
      this.errorMessage = "";
    });
  }
  // Helper function to get fieldArray.fieldGroup
  getFieldGroup() {
    const fieldArray = typeof this.field.fieldArray === "function" ? this.field.fieldArray(this.field) : this.field.fieldArray;
    return fieldArray?.fieldGroup || [];
  }
  // Initialize the editForm based on dynamic schema
  // initializeDynamicForm() {
  //   const group: { [key: string]: FormControl } = {};
  //   this.getFieldGroup().forEach((field: any) => {
  //     group[field.key] = new FormControl(''); // Initialize with empty values
  //   });
  //   this.editForm = new FormGroup(group); // Assign the dynamically created form group
  // }
  initializeDynamicForm() {
    const group = {};
    this.getFieldGroup().forEach((field) => {
      group[field.key] = new FormControl(field.defaultValue || "");
    });
    this.editForm = new FormGroup(group);
  }
  // Add or Update the row
  saveRow() {
    this.editForm.markAllAsTouched();
    this.editForm.updateValueAndValidity();
    if (this.editForm.invalid) {
      return;
    }
    if (this.isDisabled() && this.currentRowIndex === null) {
      this.errorMessage = `The row limit "${this.field.props["limit"]}" has been reached for adding new record`;
      return;
    }
    const uniqueFields = this.getFieldGroup().filter((field) => field.props && field.props["uniqueRow"]);
    const duplicateFields = [];
    uniqueFields.forEach((uniqueField) => {
      const fieldKey = this.coerceKeyToString(uniqueField.key ?? "");
      const currentValue = this.editForm.get(fieldKey)?.value;
      const duplicate = this.formArray.controls.some((row, index) => {
        if (index !== this.currentRowIndex) {
          return row.get(fieldKey)?.value === currentValue;
        }
        return false;
      });
      if (duplicate) {
        duplicateFields.push(uniqueField.props?.label || fieldKey);
      }
    });
    if (duplicateFields.length > 0) {
      this.errorMessage = `The "${duplicateFields.join(", ")}" fields must be unique, can't add duplicate values.`;
      return;
    }
    if (this.currentRowIndex !== null) {
      const keys = Object.keys(this.editForm.controls);
      let uniqueKey = keys.filter((key) => key.endsWith("_file"))[0];
      if (uniqueKey?.length)
        uniqueKey = uniqueKey.replace("_file", "");
      if (uniqueKey) {
        this.editForm.setValue(__spreadProps(__spreadValues({}, this.editForm.value), {
          [uniqueKey]: this.editForm.getRawValue()[`${uniqueKey}_file`] ? null : this.editForm.getRawValue()[uniqueKey]
        }));
      }
      this.formArray.at(this.currentRowIndex).setValue(this.editForm.value);
    } else {
      const newFormGroup = new FormGroup({});
      Object.keys(this.editForm.controls).forEach((key) => {
        newFormGroup.addControl(key, new FormControl(this.editForm.get(key)?.value));
      });
      this.formArray.push(newFormGroup);
    }
    if (this.field.parent && this.field.parent.model) {
      const key = this.field.key;
      this.field.parent.model[`${key}`] = this.formArray.value;
    }
    this.resetRow();
  }
  // resetRow() {
  //   this.editForm.reset();
  //   this.currentRowIndex = null;
  // }
  resetRow() {
    const defaultValues = {};
    this.getFieldGroup().forEach((field) => {
      defaultValues[field.key] = field.defaultValue || "";
    });
    this.editForm.reset(defaultValues);
    this.currentRowIndex = null;
  }
  // Edit a row in the table
  editRow(index) {
    this.currentRowIndex = index;
    const rowData = this.formArray.at(index).value;
    this.editForm.setValue(rowData);
  }
  // Delete a row in the table
  deleteRow(index) {
    this.resetRow();
    this.formArray.removeAt(index);
    if (this.field.parent && this.field.parent.model) {
      const key = this.field.key;
      this.field.parent.model[`${key}`] = this.formArray.value;
    }
  }
  coerceKeyToString(key) {
    if (Array.isArray(key)) {
      return key.join(".");
    }
    return String(key);
  }
  getSafeDisplayValue(fieldValue, options) {
    if (!options) {
      return fieldValue;
    }
    if (options instanceof Observable) {
      return options.pipe(map((opts) => {
        const option2 = opts.find((opt) => opt.value === fieldValue);
        return option2 ? option2.label : fieldValue;
      }));
    }
    const option = options.find((opt) => opt.value === fieldValue);
    return option ? option.label : fieldValue;
  }
  isDisabled() {
    return this.field.props["limit"] <= this.formArray.length;
  }
  getImageSrc(fieldValue, key, blob = false) {
    const pathKey = this.removeSuffix(key, "_file");
    if (!fieldValue[key] && fieldValue[pathKey]) {
      return `${environment.apiUrl}/${fieldValue[pathKey]}`;
    }
    const ImageValue = fieldValue[key];
    if (typeof fieldValue === "string") {
      return ImageValue;
    } else if (ImageValue instanceof FileList && ImageValue.length > 0) {
      if (ImageValue[0].type.includes("image/")) {
        if (blob)
          return ImageValue[0].toString();
        else
          return URL.createObjectURL(ImageValue[0]);
      } else
        return ImageValue[0].name;
    } else if (ImageValue instanceof File) {
      if (ImageValue.type.includes("image/")) {
        if (blob)
          return ImageValue.toString();
        else
          return URL.createObjectURL(ImageValue);
      } else
        return ImageValue.name;
    }
    return null;
  }
  removeSuffix(value, suffix) {
    return value.endsWith(suffix) ? value.slice(0, -suffix.length) : value;
  }
  downloadFile(url, index) {
    if (url && url?.startsWith("http")) {
      fetch(url).then((response) => response.blob()).then((blob) => {
        const link = document.createElement("a");
        link.href = URL.createObjectURL(blob);
        link.download = this.getFileExtension(url, index);
        link.textContent = "Download File";
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        URL.revokeObjectURL(link.href);
      }).catch((error) => console.error("Download failed:", error));
    }
  }
  getFileExtension(url, i) {
    if (url && url?.startsWith("http")) {
      const name = this.formArray?.at(i)?.getRawValue()?.name || "";
      const extension = url?.split("/").pop()?.split(".")[1] || "";
      return `${name}.${extension}`;
    }
    return "";
  }
};
_FormlyRepeatTableFieldComponent.\u0275fac = function FormlyRepeatTableFieldComponent_Factory(t) {
  return new (t || _FormlyRepeatTableFieldComponent)();
};
_FormlyRepeatTableFieldComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FormlyRepeatTableFieldComponent, selectors: [["app-formly-repeat-table-field"]], features: [\u0275\u0275InheritDefinitionFeature], decls: 11, vars: 7, consts: [["showUrl", ""], [1, "repeat-table-field", "rounded-md", "border-4", "p-5"], [1, "grid", "border-b-2", "pb-2"], [1, "space-x-4", 3, "formGroup"], [1, "repeat-table-form", "flex-grow", 3, "form", "fields"], [1, "space-x-2", "text-center"], ["type", "button", 1, "btn-primary", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", 3, "click"], ["type", "button", 1, "btn-danger", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", 3, "click"], ["class", "invalid-feedback", 4, "ngIf"], ["class", "mb-4 table-fixed", 4, "ngIf"], [1, "invalid-feedback"], [1, "mb-4", "table-fixed"], ["class", "px-3 py-2", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "px-3", "py-2"], [4, "ngFor", "ngForOf"], [1, "px-3", "py-2", 3, "ngClass"], ["class", "truncate px-3 py-2", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "flex", "gap-2"], [1, "fa-pen-to-square", "fa-regular", "h-3.5", "w-3.5", "cursor-pointer", 3, "click"], [1, "fa-regular", "fa-trash-can", "h-3.5", "w-3.5", "cursor-pointer", 3, "click"], [1, "truncate", "px-3", "py-2", 3, "ngClass"], [4, "ngIf"], [4, "ngIf", "ngIfElse"], ["alt", "Image", 1, "max-h-16", "max-w-16", "cursor-pointer", "rounded-md", 3, "click", "title", "src"], ["appDynamicFontSize", "body", 1, "cursor-pointer", "truncate", 3, "click", "ngClass", "title"]], template: function FormlyRepeatTableFieldComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 1)(1, "div", 2)(2, "form", 3);
    \u0275\u0275element(3, "formly-form", 4);
    \u0275\u0275elementStart(4, "div", 5)(5, "button", 6);
    \u0275\u0275listener("click", function FormlyRepeatTableFieldComponent_Template_button_click_5_listener() {
      return ctx.saveRow();
    });
    \u0275\u0275text(6);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "button", 7);
    \u0275\u0275listener("click", function FormlyRepeatTableFieldComponent_Template_button_click_7_listener() {
      return ctx.resetRow();
    });
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275template(9, FormlyRepeatTableFieldComponent_div_9_Template, 2, 1, "div", 8)(10, FormlyRepeatTableFieldComponent_table_10_Template, 8, 2, "table", 9);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275property("formGroup", ctx.editForm);
    \u0275\u0275advance();
    \u0275\u0275property("form", ctx.editForm)("fields", ctx.getFieldGroup());
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", ctx.currentRowIndex !== null ? "Update" : "Add", " ");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx.currentRowIndex !== null ? "Back" : "Reset", " ");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.errorMessage);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.formArray && ctx.formArray.length > 0);
  }
}, dependencies: [NgClass, NgForOf, NgIf, \u0275NgNoValidate, NgControlStatusGroup, FormGroupDirective, FormlyForm], styles: ["\n\n  formly-form.repeat-table-form > formly-field > formly-group {\n  display: flex;\n  gap: 0.5rem;\n}\n@media (max-width: 767px) {\n    formly-form.repeat-table-form > formly-field > formly-group {\n    flex-direction: column !important;\n  }\n}\n/*# sourceMappingURL=formly-repeat-table-field.component.css.map */"] });
var FormlyRepeatTableFieldComponent = _FormlyRepeatTableFieldComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FormlyRepeatTableFieldComponent, { className: "FormlyRepeatTableFieldComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\formly-repeat-table-field\\formly-repeat-table-field.component.ts", lineNumber: 13 });
})();

// src/app/@lcp-framework/formly/components/whatsapp-tags/whatsapp-tags.component.ts
function WhatsappTagsComponent_div_0_a_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 3);
    \u0275\u0275listener("click", function WhatsappTagsComponent_div_0_a_1_Template_a_click_0_listener() {
      const item_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r2.copyContent(item_r2.label));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r2 = ctx.$implicit;
    \u0275\u0275classMapInterpolate1("px-4 py-2.5 hover:bg-[#eee] dark:hover:bg-[#eee]/10 val-", item_r2.value, "");
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(item_r2.label);
  }
}
function WhatsappTagsComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 1);
    \u0275\u0275template(1, WhatsappTagsComponent_div_0_a_1_Template, 2, 4, "a", 2);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r2.listDatas);
  }
}
var _WhatsappTagsComponent = class _WhatsappTagsComponent extends FieldType {
  constructor(gridApiService, cdr, renderer) {
    super();
    this.gridApiService = gridApiService;
    this.cdr = cdr;
    this.renderer = renderer;
    this.listDatas = [];
  }
  ngOnInit() {
    this.setData();
    this.fileNameControl = this.form.get("whatsapp_template_process_id");
    this.fileNameControl?.valueChanges.subscribe(() => {
      this.setData();
    });
  }
  setData() {
    const whatsapp_template_process_id = this.fileNameControl?.value;
    if (whatsapp_template_process_id) {
      const listParams = {
        company_id: 1,
        search_all: [
          {
            value: "1",
            operator: "=",
            column_name: "status_id"
          },
          {
            value: whatsapp_template_process_id,
            operator: "=",
            column_name: "whatsapp_template_process_tags_mapping.whatsapp_template_process_id"
          }
        ],
        limit_range: 1e3,
        print_query: true,
        start_index: 0,
        sort_columns: [["whatsapp_template_tags.slug", "asc"]],
        primary_table: "whatsapp_template_tags",
        select_columns: [
          ["whatsapp_template_tags.id", "value"],
          ["whatsapp_template_tags.slug", "label"]
        ],
        includes: [
          {
            table_name: "whatsapp_template_process_tags_mapping",
            join_type: "INNER",
            join_condition: "whatsapp_template_tags.id = whatsapp_template_process_tags_mapping.whatsapp_template_tag_id"
          }
        ]
      };
      this.gridApiService.getAllList(listParams).subscribe((response) => {
        if (response.status && response.code === 200) {
          this.listDatas = response.data.records;
          this.cdr.detectChanges();
        }
      });
    }
  }
  copyContent(content) {
    const textarea = this.renderer.createElement("textarea");
    this.renderer.setStyle(textarea, "position", "fixed");
    this.renderer.setStyle(textarea, "opacity", "0");
    textarea.value = content;
    this.renderer.appendChild(document.body, textarea);
    textarea.select();
    document.execCommand("copy");
    this.renderer.removeChild(document.body, textarea);
  }
  get formControl() {
    return this.form.get(this.field.key);
  }
};
_WhatsappTagsComponent.\u0275fac = function WhatsappTagsComponent_Factory(t) {
  return new (t || _WhatsappTagsComponent)(\u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(ChangeDetectorRef), \u0275\u0275directiveInject(Renderer2));
};
_WhatsappTagsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _WhatsappTagsComponent, selectors: [["app-whatsapp-tags"]], standalone: true, features: [\u0275\u0275InheritDefinitionFeature, \u0275\u0275StandaloneFeature], decls: 1, vars: 1, consts: [["class", "flex flex-wrap rounded-md border border-[#e0e6ed] dark:border-[#1b2e4b]", 4, "ngIf"], [1, "flex", "flex-wrap", "rounded-md", "border", "border-[#e0e6ed]", "dark:border-[#1b2e4b]"], ["title", "Click to copy", "href", "javascript:;", 3, "class", "click", 4, "ngFor", "ngForOf"], ["title", "Click to copy", "href", "javascript:;", 3, "click"]], template: function WhatsappTagsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, WhatsappTagsComponent_div_0_Template, 2, 1, "div", 0);
  }
  if (rf & 2) {
    \u0275\u0275property("ngIf", (ctx.listDatas == null ? null : ctx.listDatas.length) > 0);
  }
}, dependencies: [CommonModule, NgForOf, NgIf] });
var WhatsappTagsComponent = _WhatsappTagsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(WhatsappTagsComponent, { className: "WhatsappTagsComponent", filePath: "src\\app\\@lcp-framework\\formly\\components\\whatsapp-tags\\whatsapp-tags.component.ts", lineNumber: 15 });
})();

// src/app/@lcp-framework/formly/formly-config.module.ts
function minLengthValidationMessage(error, field) {
  if (field.props)
    return `Should have at least ${field.props.minLength} characters`;
  else
    return `Should have at least 1 character`;
}
function maxLengthValidationMessage(error, field) {
  if (field.props)
    return `This value should be less than ${field.props.maxLength} characters`;
  else
    return `This value should be less than 100`;
}
function minValidationMessage(error, field) {
  if (field.props)
    return `This value should be more than ${field.props.min}`;
  else
    return `This value should be more than 1`;
}
function maxValidationMessage(error, field) {
  if (field.props)
    return `This value should be less than ${field.props.max}`;
  else
    return `This value should be less than 100`;
}
var field_types = commonConfig.field_types;
var search_conditions = commonConfig.search_conditions;
var _FormlyConfigModule = class _FormlyConfigModule {
};
_FormlyConfigModule.\u0275fac = function FormlyConfigModule_Factory(t) {
  return new (t || _FormlyConfigModule)();
};
_FormlyConfigModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _FormlyConfigModule });
_FormlyConfigModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ imports: [
  QuillModule,
  MonacoEditorModule,
  CommonModule,
  NgSelectModule,
  WhatsappTagsComponent,
  ReactiveFormsModule,
  FormlyBootstrapModule,
  FormlyPresetModule,
  FormlyModule.forRoot({
    validationMessages: [
      { name: "required", message: "This field is required" },
      { name: "minLength", message: minLengthValidationMessage },
      { name: "maxLength", message: maxLengthValidationMessage },
      { name: "min", message: minValidationMessage },
      { name: "max", message: maxValidationMessage }
    ],
    presets: [
      {
        name: "status",
        config: {
          key: "status_id",
          type: "radio",
          props: {
            label: "Status",
            required: true
          },
          expressionProperties: {
            "props.options": (model, formState) => {
              const opts = [
                { value: 1, label: "Active", class: "inline-flex" },
                { value: 2, label: "In Active", class: "inline-flex" }
              ];
              return opts;
            }
          }
        }
      },
      {
        name: "field_type",
        config: {
          key: "field_type_id",
          type: "select-from-db",
          props: {
            label: "Field Type",
            placeholder: "Please select",
            required: true,
            options: [...field_types]
          }
        }
      },
      {
        name: "search_conditions",
        config: {
          key: "search_conditions",
          type: "select-from-db",
          props: {
            label: "Search Condition",
            placeholder: "Please select",
            required: true,
            options: []
          },
          hooks: {
            onInit: (field) => {
              const fieldTypeControl = field.parent?.formControl?.get("field_type_id");
              if (fieldTypeControl) {
                fieldTypeControl.valueChanges.pipe(
                  debounceTime(300),
                  // Add debounce to avoid rapid value changes
                  map((value) => {
                    const options = value ? [...search_conditions[value]] : [];
                    return options;
                  })
                ).subscribe((options) => {
                  if (field.props) {
                    field.props.options = options;
                  }
                  if (field.formControl && field.formControl.updateValueAndValidity) {
                    field.formControl.updateValueAndValidity({ onlySelf: true, emitEvent: false });
                  }
                });
              }
            }
          }
        }
      }
    ],
    types: [
      { name: "file", component: FormlyFieldFileComponent, wrappers: ["form-field"] },
      { name: "image", component: FormlyFieldFileComponent, wrappers: ["form-field"] },
      { name: "repeat", component: FormlyFieldRepeatComponent, wrappers: ["form-field"] },
      { name: "select-from-db", component: FormlyFieldSelectFromDbComponent, wrappers: ["form-field"] },
      { name: "async-select-from-db", component: FormlyFieldAutocompleteComponent, wrappers: ["form-field"] },
      { name: "rich-editor", component: FormlyRichEditorComponent, wrappers: ["form-field"] },
      { name: "email-tags", component: FormlyDisplayListComponent, wrappers: ["form-field"] },
      { name: "whatsapp-tags", component: WhatsappTagsComponent, wrappers: ["form-field"] },
      { name: "vs-code", component: FormlyVsCodeComponent, wrappers: ["form-field"] },
      { name: "repeat-table", component: FormlyRepeatTableFieldComponent, wrappers: ["form-field"] }
    ]
  }),
  FormlyModule,
  ReactiveFormsModule,
  FormlyPresetModule,
  NgSelectModule
] });
var FormlyConfigModule = _FormlyConfigModule;

export {
  QuillModule,
  FormlyForm,
  FormlyModule,
  FormlyBootstrapModule,
  FormlyFieldSelectFromDbComponent,
  FormlyConfigModule
};
//# sourceMappingURL=chunk-NFRJCL7R.js.map
