
Object.defineProperty(exports, "__esModule", { value: true });

const {
  PrismaClientKnownRequestError,
  PrismaClientUnknownRequestError,
  PrismaClientRustPanicError,
  PrismaClientInitializationError,
  PrismaClientValidationError,
  NotFoundError,
  getPrismaClient,
  sqltag,
  empty,
  join,
  raw,
  Decimal,
  Debug,
  objectEnumValues,
  makeStrictEnum,
  Extensions,
  warnOnce,
  defineDmmfProperty,
  Public,
  getRuntime
} = require('./runtime/library.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 5.14.0
 * Query Engine version: e9771e62de70f79a5e1c604a2d7c8e2a0a874b48
 */
Prisma.prismaVersion = {
  client: "5.14.0",
  engine: "e9771e62de70f79a5e1c604a2d7c8e2a0a874b48"
}

Prisma.PrismaClientKnownRequestError = PrismaClientKnownRequestError;
Prisma.PrismaClientUnknownRequestError = PrismaClientUnknownRequestError
Prisma.PrismaClientRustPanicError = PrismaClientRustPanicError
Prisma.PrismaClientInitializationError = PrismaClientInitializationError
Prisma.PrismaClientValidationError = PrismaClientValidationError
Prisma.NotFoundError = NotFoundError
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = sqltag
Prisma.empty = empty
Prisma.join = join
Prisma.raw = raw
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = Extensions.getExtensionContext
Prisma.defineExtension = Extensions.defineExtension

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}


  const path = require('path')

/**
 * Enums
 */
exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  username: 'username',
  email: 'email',
  email_verified: 'email_verified',
  password: 'password',
  status_id: 'status_id',
  role: 'role',
  process_status: 'process_status',
  is_drafted: 'is_drafted',
  reason: 'reason',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  last_login: 'last_login',
  last_login_device: 'last_login_device'
};

exports.Prisma.UserDetailScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  code: 'code',
  first_name: 'first_name',
  last_name: 'last_name',
  designation_id: 'designation_id',
  department_id: 'department_id',
  organization_id: 'organization_id',
  profile_pic: 'profile_pic',
  dob: 'dob',
  country_code: 'country_code',
  phone_number: 'phone_number',
  gender: 'gender',
  user_time_zone: 'user_time_zone',
  address: 'address',
  culture: 'culture',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.DesignationScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.DepartmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  department_head_id: 'department_head_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.RequestLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  user_id: 'user_id',
  req_method: 'req_method',
  req_url: 'req_url',
  req_body: 'req_body',
  res_status: 'res_status',
  res_code: 'res_code',
  res_message: 'res_message',
  req_response: 'req_response',
  req_headers: 'req_headers',
  req_ip: 'req_ip',
  req_device: 'req_device',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.FinancialYearScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  code: 'code',
  is_freezed: 'is_freezed',
  start_date: 'start_date',
  end_date: 'end_date',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.DocumentSequenceScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  module_name: 'module_name',
  financial_year_id: 'financial_year_id',
  current_sequence_no: 'current_sequence_no',
  start_sequence_no: 'start_sequence_no',
  end_sequence_no: 'end_sequence_no',
  sequence_length: 'sequence_length',
  status_id: 'status_id',
  code_format: 'code_format',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.AuditLogScalarFieldEnum = {
  id: 'id',
  operation_type: 'operation_type',
  table_name: 'table_name',
  field_name: 'field_name',
  old_value: 'old_value',
  new_value: 'new_value',
  entity_id: 'entity_id',
  user_id: 'user_id',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.PermissionsScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  entity_id: 'entity_id',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.RoleScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.RolePermissionsScalarFieldEnum = {
  role_id: 'role_id',
  permission_id: 'permission_id',
  company_id: 'company_id'
};

exports.Prisma.UserRolesScalarFieldEnum = {
  user_id: 'user_id',
  role_id: 'role_id',
  company_id: 'company_id'
};

exports.Prisma.UserPermissionsScalarFieldEnum = {
  user_id: 'user_id',
  permission_id: 'permission_id',
  company_id: 'company_id'
};

exports.Prisma.OtpScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  otp: 'otp',
  purpose: 'purpose',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.LanguageScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  name_in_english: 'name_in_english',
  flag: 'flag',
  code: 'code',
  rtl: 'rtl',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.LanguageContentScalarFieldEnum = {
  id: 'id',
  language_id: 'language_id',
  key_content: 'key_content',
  values: 'values',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.MenusScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  menu_type: 'menu_type',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.MenuItemsScalarFieldEnum = {
  id: 'id',
  menu_id: 'menu_id',
  name: 'name',
  target: 'target',
  parent_id: 'parent_id',
  permission_id: 'permission_id',
  entity_id: 'entity_id',
  link_type: 'link_type',
  order_no: 'order_no',
  menu_img: 'menu_img',
  short_cut_keys: 'short_cut_keys',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.ActionTypeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  description: 'description',
  company_id: 'company_id'
};

exports.Prisma.EntityTypeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  company_id: 'company_id'
};

exports.Prisma.WizardGroupScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  status_id: 'status_id',
  created_at: 'created_at',
  company_id: 'company_id'
};

exports.Prisma.WizardTypeScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  company_id: 'company_id'
};

exports.Prisma.AboutLCPScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  type: 'type',
  name: 'name',
  description: 'description',
  order_no: 'order_no',
  documentation_video_url: 'documentation_video_url',
  documentation_pdf: 'documentation_pdf',
  documentation_word: 'documentation_word',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.MasterEntityScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  entity_name: 'entity_name',
  entity_type: 'entity_type',
  report_type: 'report_type',
  primary_table: 'primary_table',
  is_admin_module: 'is_admin_module',
  draft_mode: 'draft_mode',
  associated_tables: 'associated_tables',
  query_information: 'query_information',
  form_information: 'form_information',
  report_information: 'report_information',
  add_query_information: 'add_query_information',
  edit_query_information: 'edit_query_information',
  preset_query_information: 'preset_query_information',
  static_page_content: 'static_page_content',
  export_template_id: 'export_template_id',
  dashboard_wizard_group_id: 'dashboard_wizard_group_id',
  dashboard_wizard_type: 'dashboard_wizard_type',
  dashboard_wizard_rows: 'dashboard_wizard_rows',
  dashboard_wizard_columns: 'dashboard_wizard_columns',
  dashboard_wizard_order_no: 'dashboard_wizard_order_no',
  dashboard_wizard_options: 'dashboard_wizard_options',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.MasterEntityLineItemScalarFieldEnum = {
  id: 'id',
  master_grid_id: 'master_grid_id',
  field_name: 'field_name',
  display_name: 'display_name',
  order_no: 'order_no',
  is_grid_column: 'is_grid_column',
  is_searchable: 'is_searchable',
  clause_type: 'clause_type',
  is_sortable: 'is_sortable',
  field_type_id: 'field_type_id',
  link_type: 'link_type',
  link_action: 'link_action',
  link_mode: 'link_mode',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.FieldTypeScalarFieldEnum = {
  id: 'id',
  field_type: 'field_type',
  company_id: 'company_id',
  status_id: 'status_id',
  created_at: 'created_at'
};

exports.Prisma.MenuTypeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.EmailTemplateProcessScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateRecipientTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateProcessTagsMappingScalarFieldEnum = {
  email_template_process_id: 'email_template_process_id',
  email_template_tag_id: 'email_template_tag_id',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  subject: 'subject',
  template_body: 'template_body',
  email_template_process_id: 'email_template_process_id',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateAssignmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  email_template_process_id: 'email_template_process_id',
  template_id: 'template_id',
  recipient_type: 'recipient_type',
  email_to: 'email_to',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by'
};

exports.Prisma.EmailTemplateCcBccScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  send_type: 'send_type',
  recipient_type: 'recipient_type',
  email_to: 'email_to',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  email_template_assignment_id: 'email_template_assignment_id'
};

exports.Prisma.EmailProcessJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  email_template_process_slug: 'email_template_process_slug',
  unique_id: 'unique_id',
  user_id: 'user_id',
  prefill_data: 'prefill_data',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name',
  company_id: 'company_id',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by'
};

exports.Prisma.WhatsappProcessJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  whatsapp_template_process_slug: 'whatsapp_template_process_slug',
  unique_id: 'unique_id',
  user_id: 'user_id',
  prefill_data: 'prefill_data',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name',
  company_id: 'company_id',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by'
};

exports.Prisma.WhatsappTemplateProcessScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateRecipientTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateProcessTagsMappingScalarFieldEnum = {
  whatsapp_template_process_id: 'whatsapp_template_process_id',
  whatsapp_template_tag_id: 'whatsapp_template_tag_id',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  message: 'message',
  whatsapp_template_process_id: 'whatsapp_template_process_id',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateAssignmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  whatsapp_template_process_id: 'whatsapp_template_process_id',
  template_id: 'template_id',
  recipient_type: 'recipient_type',
  whatsapp_to: 'whatsapp_to',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by'
};

exports.Prisma.NotificationJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  process_slug: 'process_slug',
  notification_to: 'notification_to',
  notification_subject: 'notification_subject',
  notification_content: 'notification_content',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name',
  notification_cc: 'notification_cc',
  notification_bcc: 'notification_bcc',
  notification_type_id: 'notification_type_id',
  notification_status_id: 'notification_status_id',
  notification_type: 'notification_type',
  company_id: 'company_id',
  status_id: 'status_id',
  parent_id: 'parent_id',
  no_of_attempts: 'no_of_attempts',
  created_at: 'created_at',
  created_by: 'created_by',
  sent_at: 'sent_at',
  read_at: 'read_at'
};

exports.Prisma.CarouselTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.CarouselTemplateLineItemScalarFieldEnum = {
  id: 'id',
  carousel_template_id: 'carousel_template_id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  image_url: 'image_url',
  video_url: 'video_url',
  clickable_link: 'clickable_link',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ImportTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  max_row_count: 'max_row_count',
  header_row: 'header_row',
  data_start_row: 'data_start_row',
  data_end_row: 'data_end_row',
  ignore_error_rows: 'ignore_error_rows',
  is_admin_module: 'is_admin_module',
  is_send_mail: 'is_send_mail',
  email_process_slug: 'email_process_slug',
  job_type: 'job_type',
  batch_process_count: 'batch_process_count',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ImportTemplateLineItemScalarFieldEnum = {
  id: 'id',
  import_template_id: 'import_template_id',
  field_name: 'field_name',
  display_name: 'display_name',
  field_table: 'field_table',
  order_no: 'order_no',
  width: 'width',
  default_value: 'default_value',
  check_reg_exp: 'check_reg_exp',
  is_nullable: 'is_nullable',
  is_unique: 'is_unique',
  is_foreign: 'is_foreign',
  unique_query: 'unique_query',
  foreign_query: 'foreign_query',
  is_enum: 'is_enum',
  is_multiple: 'is_multiple',
  enum_values: 'enum_values',
  expression_rules: 'expression_rules',
  foreign_table: 'foreign_table',
  foreign_column: 'foreign_column',
  foreign_can_create: 'foreign_can_create',
  is_individual: 'is_individual',
  individual_column: 'individual_column',
  field_type_id: 'field_type_id',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ImportTemplateQueriesScalarFieldEnum = {
  id: 'id',
  import_template_id: 'import_template_id',
  query_string: 'query_string',
  query_name: 'query_name',
  allow_multiple: 'allow_multiple',
  is_individual: 'is_individual',
  before_lineitems: 'before_lineitems',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ImportJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  sequence_number: 'sequence_number',
  header_details: 'header_details',
  table_config: 'table_config',
  total_rows: 'total_rows',
  completed_rows: 'completed_rows',
  error_rows: 'error_rows',
  batch_process_count: 'batch_process_count',
  job_status: 'job_status',
  last_processed_row_id: 'last_processed_row_id',
  file_path: 'file_path',
  file_name: 'file_name',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ImportJobLineItemScalarFieldEnum = {
  id: 'id',
  import_job_id: 'import_job_id',
  row_object: 'row_object',
  job_status: 'job_status',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ExportTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  max_row_count: 'max_row_count',
  header_row: 'header_row',
  data_start_row: 'data_start_row',
  data_end_row: 'data_end_row',
  data_filepath: 'data_filepath',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ExportTemplateLineItemScalarFieldEnum = {
  id: 'id',
  export_template_id: 'export_template_id',
  field_name: 'field_name',
  display_name: 'display_name',
  field_table: 'field_table',
  order_no: 'order_no',
  default_value: 'default_value',
  column_name: 'column_name',
  is_individual: 'is_individual',
  individual_column: 'individual_column',
  field_type_id: 'field_type_id',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ExportTemplateQueriesScalarFieldEnum = {
  id: 'id',
  export_template_id: 'export_template_id',
  query_string: 'query_string',
  query_name: 'query_name',
  query_procedure: 'query_procedure',
  is_individual: 'is_individual',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.StatusScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  status_id: 'status_id'
};

exports.Prisma.CategoryTypesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  name: 'name',
  description: 'description',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.CategoriesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  category_id: 'category_id',
  parent_id: 'parent_id',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.ConfigurationsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  order_no: 'order_no',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_select_json: 'config_select_json',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type',
  display_config: 'display_config',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.UserConfigurationsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  order_no: 'order_no',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_select_json: 'config_select_json',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type',
  display_config: 'display_config',
  user_id: 'user_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.FileUploadLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  doc_name: 'doc_name',
  org_name: 'org_name',
  extension: 'extension',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.DataTransferQueriesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  select_query: 'select_query',
  insert_query: 'insert_query',
  transfer_type: 'transfer_type',
  job_name: 'job_name',
  destination_table: 'destination_table',
  clear_destination_table: 'clear_destination_table',
  execution_order: 'execution_order',
  command_type: 'command_type',
  status_id: 'status_id',
  created_by: 'created_by',
  created_at: 'created_at',
  company_id: 'company_id'
};

exports.Prisma.DeviceRegistrationScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  device_name: 'device_name',
  device_unique_id: 'device_unique_id',
  user_id: 'user_id',
  status_id: 'status_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.PoliciesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information',
  status_id: 'status_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.UserPoliciesScalarFieldEnum = {
  company_id: 'company_id',
  policy_id: 'policy_id',
  user_id: 'user_id'
};

exports.Prisma.RolePoliciesScalarFieldEnum = {
  company_id: 'company_id',
  policy_id: 'policy_id',
  role_id: 'role_id'
};

exports.Prisma.AppversionsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  type: 'type',
  version_type: 'version_type',
  version: 'version',
  description: 'description',
  is_frontend_changed: 'is_frontend_changed',
  is_backend_changed: 'is_backend_changed',
  is_database_changed: 'is_database_changed',
  developed_by: 'developed_by',
  status_id: 'status_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ScheduledJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  timing: 'timing',
  cron_url: 'cron_url',
  concat_base_url: 'concat_base_url',
  description: 'description',
  created_at: 'created_at',
  company_id: 'company_id',
  status_id: 'status_id'
};

exports.Prisma.ScheduledJobLogsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  scheduled_job_id: 'scheduled_job_id',
  executed_statement: 'executed_statement',
  schedule_status: 'schedule_status',
  response: 'response',
  created_at: 'created_at',
  company_id: 'company_id',
  status_id: 'status_id'
};

exports.Prisma.ApprovalWorkflowScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  slug: 'slug',
  query_information: 'query_information',
  status_id: 'status_id',
  url: 'url',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ApprovalWorkflowApproverTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ApprovalWorkflowAssignmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  approval_workflow_id: 'approval_workflow_id',
  approver_order_no: 'approver_order_no',
  approver_type: 'approver_type',
  approver: 'approver',
  approve_query_information: 'approve_query_information',
  reject_query_information: 'reject_query_information',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at',
  approve_mail_id: 'approve_mail_id',
  reject_mail_id: 'reject_mail_id',
  approve_whatsapp_id: 'approve_whatsapp_id',
  reject_whatsapp_id: 'reject_whatsapp_id'
};

exports.Prisma.ApprovalProcessJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  approval_workflow_slug: 'approval_workflow_slug',
  sequence_no: 'sequence_no',
  description: 'description',
  primary_table: 'primary_table',
  unique_id: 'unique_id',
  screen_id: 'screen_id',
  user_id: 'user_id',
  prefill_data: 'prefill_data',
  details: 'details',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.ApprovalProcessJobWorkflowScalarFieldEnum = {
  id: 'id',
  approval_workflow_assignment_id: 'approval_workflow_assignment_id',
  approval_process_job_id: 'approval_process_job_id',
  approval_workflow_slug: 'approval_workflow_slug',
  approval_process_job_name: 'approval_process_job_name',
  approval_process_job_description: 'approval_process_job_description',
  approve_query_information: 'approve_query_information',
  reject_query_information: 'reject_query_information',
  primary_table: 'primary_table',
  sequence_no: 'sequence_no',
  unique_id: 'unique_id',
  user_id: 'user_id',
  screen_id: 'screen_id',
  prefill_data: 'prefill_data',
  url: 'url',
  approver_order_no: 'approver_order_no',
  approver_type: 'approver_type',
  approver: 'approver',
  review_status: 'review_status',
  status_id: 'status_id',
  reviewed_by: 'reviewed_by',
  reason: 'reason',
  approve_mail_id: 'approve_mail_id',
  reject_mail_id: 'reject_mail_id',
  approve_whatsapp_id: 'approve_whatsapp_id',
  reject_whatsapp_id: 'reject_whatsapp_id',
  company_id: 'company_id',
  created_at: 'created_at',
  assigned_at: 'assigned_at',
  processed_at: 'processed_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at',
  details: 'details'
};

exports.Prisma.ApprovalProcessJobWorkflowUserScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  approval_process_job_workflow_id: 'approval_process_job_workflow_id',
  user_id: 'user_id',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.DelegationScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  user_id: 'user_id',
  delegated_user_id: 'delegated_user_id',
  reason: 'reason',
  start_date: 'start_date',
  end_date: 'end_date',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.SchemaChunkScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  table_name: 'table_name',
  chunk: 'chunk',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at',
  company_id: 'company_id'
};

exports.Prisma.EmbeddingVectorLogsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  user_id: 'user_id',
  cost: 'cost',
  company_id: 'company_id',
  table_name: 'table_name',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.OpenaiUsageLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  user_id: 'user_id',
  prompt: 'prompt',
  generated_sql: 'generated_sql',
  prompt_tokens: 'prompt_tokens',
  completion_tokens: 'completion_tokens',
  total_tokens: 'total_tokens',
  cost: 'cost',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.QueryExecutionLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  status_id: 'status_id',
  query: 'query',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ChildProcessScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  command: 'command',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ChildProcessLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  child_process_id: 'child_process_id',
  process_status: 'process_status',
  output: 'output',
  initiated_by: 'initiated_by',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.OrganizationsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  name: 'name',
  code: 'code',
  description: 'description',
  no_of_devices: 'no_of_devices',
  status_id: 'status_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullableJsonNullValueInput = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};

exports.Prisma.UserOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  username: 'username',
  email: 'email',
  password: 'password',
  reason: 'reason',
  last_login_device: 'last_login_device'
};

exports.Prisma.UserDetailOrderByRelevanceFieldEnum = {
  code: 'code',
  first_name: 'first_name',
  last_name: 'last_name',
  profile_pic: 'profile_pic',
  country_code: 'country_code',
  phone_number: 'phone_number',
  user_time_zone: 'user_time_zone',
  address: 'address',
  culture: 'culture'
};

exports.Prisma.DesignationOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description'
};

exports.Prisma.DepartmentOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description'
};

exports.Prisma.RequestLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  req_method: 'req_method',
  req_url: 'req_url',
  req_body: 'req_body',
  res_message: 'res_message',
  req_response: 'req_response',
  req_headers: 'req_headers',
  req_ip: 'req_ip',
  req_device: 'req_device'
};

exports.Prisma.FinancialYearOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  code: 'code'
};

exports.Prisma.DocumentSequenceOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  module_name: 'module_name',
  code_format: 'code_format'
};

exports.Prisma.AuditLogOrderByRelevanceFieldEnum = {
  operation_type: 'operation_type',
  table_name: 'table_name',
  field_name: 'field_name',
  old_value: 'old_value',
  new_value: 'new_value'
};

exports.Prisma.PermissionsOrderByRelevanceFieldEnum = {
  name: 'name',
  slug: 'slug'
};

exports.Prisma.RoleOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description'
};

exports.Prisma.OtpOrderByRelevanceFieldEnum = {
  otp: 'otp'
};

exports.Prisma.LanguageOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  name_in_english: 'name_in_english',
  flag: 'flag',
  code: 'code',
  description: 'description'
};

exports.Prisma.LanguageContentOrderByRelevanceFieldEnum = {
  key_content: 'key_content',
  values: 'values'
};

exports.Prisma.MenusOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.MenuItemsOrderByRelevanceFieldEnum = {
  name: 'name',
  target: 'target',
  menu_img: 'menu_img',
  short_cut_keys: 'short_cut_keys'
};

exports.Prisma.ActionTypeOrderByRelevanceFieldEnum = {
  name: 'name',
  description: 'description'
};

exports.Prisma.EntityTypeOrderByRelevanceFieldEnum = {
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.WizardGroupOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.WizardTypeOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description'
};

exports.Prisma.AboutLCPOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  documentation_video_url: 'documentation_video_url',
  documentation_pdf: 'documentation_pdf',
  documentation_word: 'documentation_word'
};

exports.Prisma.JsonNullValueFilter = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull,
  AnyNull: Prisma.AnyNull
};

exports.Prisma.MasterEntityOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  entity_name: 'entity_name',
  entity_type: 'entity_type',
  primary_table: 'primary_table',
  static_page_content: 'static_page_content',
  dashboard_wizard_type: 'dashboard_wizard_type'
};

exports.Prisma.MasterEntityLineItemOrderByRelevanceFieldEnum = {
  field_name: 'field_name',
  display_name: 'display_name',
  link_type: 'link_type',
  link_action: 'link_action',
  link_mode: 'link_mode'
};

exports.Prisma.FieldTypeOrderByRelevanceFieldEnum = {
  field_type: 'field_type'
};

exports.Prisma.menuTypeOrderByRelevanceFieldEnum = {
  name: 'name'
};

exports.Prisma.EmailTemplateProcessOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  query_information: 'query_information'
};

exports.Prisma.EmailTemplateTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description'
};

exports.Prisma.EmailTemplateRecipientTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information'
};

exports.Prisma.EmailTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  subject: 'subject',
  template_body: 'template_body'
};

exports.Prisma.EmailTemplateAssignmentOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  email_to: 'email_to'
};

exports.Prisma.EmailTemplateCcBccOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  email_to: 'email_to'
};

exports.Prisma.EmailProcessJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  email_template_process_slug: 'email_template_process_slug',
  unique_id: 'unique_id',
  prefill_data: 'prefill_data',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name'
};

exports.Prisma.WhatsappProcessJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  whatsapp_template_process_slug: 'whatsapp_template_process_slug',
  unique_id: 'unique_id',
  prefill_data: 'prefill_data',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name'
};

exports.Prisma.WhatsappTemplateProcessOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  query_information: 'query_information'
};

exports.Prisma.WhatsappTemplateTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description'
};

exports.Prisma.WhatsappTemplateRecipientTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information'
};

exports.Prisma.WhatsappTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  message: 'message'
};

exports.Prisma.WhatsappTemplateAssignmentOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  whatsapp_to: 'whatsapp_to'
};

exports.Prisma.NotificationJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  process_slug: 'process_slug',
  notification_to: 'notification_to',
  notification_subject: 'notification_subject',
  notification_content: 'notification_content',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name',
  notification_cc: 'notification_cc',
  notification_bcc: 'notification_bcc',
  notification_type_id: 'notification_type_id',
  notification_status_id: 'notification_status_id'
};

exports.Prisma.CarouselTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.CarouselTemplateLineItemOrderByRelevanceFieldEnum = {
  name: 'name',
  slug: 'slug',
  description: 'description',
  image_url: 'image_url',
  video_url: 'video_url',
  clickable_link: 'clickable_link'
};

exports.Prisma.ImportTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  email_process_slug: 'email_process_slug',
  job_type: 'job_type'
};

exports.Prisma.ImportTemplateLineItemOrderByRelevanceFieldEnum = {
  field_name: 'field_name',
  display_name: 'display_name',
  field_table: 'field_table',
  default_value: 'default_value',
  check_reg_exp: 'check_reg_exp',
  unique_query: 'unique_query',
  foreign_query: 'foreign_query',
  enum_values: 'enum_values',
  foreign_table: 'foreign_table',
  foreign_column: 'foreign_column',
  individual_column: 'individual_column'
};

exports.Prisma.ImportTemplateQueriesOrderByRelevanceFieldEnum = {
  query_string: 'query_string',
  query_name: 'query_name'
};

exports.Prisma.ImportJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  sequence_number: 'sequence_number',
  job_status: 'job_status',
  file_path: 'file_path',
  file_name: 'file_name'
};

exports.Prisma.ImportJobLineItemOrderByRelevanceFieldEnum = {
  job_status: 'job_status'
};

exports.Prisma.ExportTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  data_filepath: 'data_filepath'
};

exports.Prisma.ExportTemplateLineItemOrderByRelevanceFieldEnum = {
  field_name: 'field_name',
  display_name: 'display_name',
  field_table: 'field_table',
  default_value: 'default_value',
  column_name: 'column_name',
  individual_column: 'individual_column'
};

exports.Prisma.ExportTemplateQueriesOrderByRelevanceFieldEnum = {
  query_string: 'query_string',
  query_name: 'query_name',
  query_procedure: 'query_procedure'
};

exports.Prisma.StatusOrderByRelevanceFieldEnum = {
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.CategoryTypesOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  name: 'name',
  description: 'description'
};

exports.Prisma.CategoriesOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  category_id: 'category_id',
  parent_id: 'parent_id',
  name: 'name',
  description: 'description'
};

exports.Prisma.ConfigurationsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type'
};

exports.Prisma.UserConfigurationsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type'
};

exports.Prisma.FileUploadLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  doc_name: 'doc_name',
  org_name: 'org_name',
  extension: 'extension',
  description: 'description'
};

exports.Prisma.DataTransferQueriesOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  select_query: 'select_query',
  insert_query: 'insert_query',
  transfer_type: 'transfer_type',
  job_name: 'job_name',
  destination_table: 'destination_table',
  command_type: 'command_type'
};

exports.Prisma.DeviceRegistrationOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  device_name: 'device_name',
  device_unique_id: 'device_unique_id'
};

exports.Prisma.PoliciesOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description'
};

exports.Prisma.AppversionsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  type: 'type',
  version_type: 'version_type',
  version: 'version',
  description: 'description',
  developed_by: 'developed_by'
};

exports.Prisma.ScheduledJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  timing: 'timing',
  cron_url: 'cron_url',
  description: 'description'
};

exports.Prisma.ScheduledJobLogsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  executed_statement: 'executed_statement',
  schedule_status: 'schedule_status',
  response: 'response'
};

exports.Prisma.ApprovalWorkflowOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  slug: 'slug',
  query_information: 'query_information',
  url: 'url'
};

exports.Prisma.ApprovalWorkflowApproverTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information'
};

exports.Prisma.ApprovalWorkflowAssignmentOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  approver: 'approver',
  approve_query_information: 'approve_query_information',
  reject_query_information: 'reject_query_information'
};

exports.Prisma.ApprovalProcessJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  approval_workflow_slug: 'approval_workflow_slug',
  sequence_no: 'sequence_no',
  description: 'description',
  primary_table: 'primary_table',
  screen_id: 'screen_id',
  prefill_data: 'prefill_data',
  details: 'details'
};

exports.Prisma.ApprovalProcessJobWorkflowOrderByRelevanceFieldEnum = {
  approval_process_job_id: 'approval_process_job_id',
  approval_workflow_slug: 'approval_workflow_slug',
  approval_process_job_name: 'approval_process_job_name',
  approval_process_job_description: 'approval_process_job_description',
  approve_query_information: 'approve_query_information',
  reject_query_information: 'reject_query_information',
  primary_table: 'primary_table',
  sequence_no: 'sequence_no',
  screen_id: 'screen_id',
  prefill_data: 'prefill_data',
  url: 'url',
  approver: 'approver',
  reason: 'reason',
  details: 'details'
};

exports.Prisma.ApprovalProcessJobWorkflowUserOrderByRelevanceFieldEnum = {
  uuid: 'uuid'
};

exports.Prisma.DelegationOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  reason: 'reason'
};

exports.Prisma.SchemaChunkOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  table_name: 'table_name',
  chunk: 'chunk'
};

exports.Prisma.EmbeddingVectorLogsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  table_name: 'table_name'
};

exports.Prisma.OpenaiUsageLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  prompt: 'prompt',
  generated_sql: 'generated_sql'
};

exports.Prisma.QueryExecutionLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  query: 'query'
};

exports.Prisma.ChildProcessOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  command: 'command'
};

exports.Prisma.ChildProcessLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  process_status: 'process_status',
  output: 'output'
};

exports.Prisma.OrganizationsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  code: 'code',
  description: 'description'
};
exports.UserRole = exports.$Enums.UserRole = {
  super_admin: 'super_admin',
  company_admin: 'company_admin',
  admin: 'admin',
  user: 'user'
};

exports.ProcessStatus = exports.$Enums.ProcessStatus = {
  under_approval: 'under_approval',
  approved: 'approved',
  rejected: 'rejected',
  submitted: 'submitted',
  created: 'created',
  not_appear: 'not_appear'
};

exports.Gender = exports.$Enums.Gender = {
  male: 'male',
  female: 'female',
  others: 'others'
};

exports.OtpPurpose = exports.$Enums.OtpPurpose = {
  login: 'login',
  password_reset: 'password_reset',
  verify_email: 'verify_email',
  others: 'others'
};

exports.aboutType = exports.$Enums.aboutType = {
  lcp: 'lcp',
  project: 'project'
};

exports.ReportType = exports.$Enums.ReportType = {
  lcp: 'lcp',
  powerbi: 'powerbi'
};

exports.ClauseType = exports.$Enums.ClauseType = {
  where: 'where',
  having: 'having'
};

exports.RecipientType = exports.$Enums.RecipientType = {
  tag: 'tag',
  user_id: 'user_id',
  custom: 'custom'
};

exports.sendMailType = exports.$Enums.sendMailType = {
  cc: 'cc',
  bcc: 'bcc'
};

exports.NotificationType = exports.$Enums.NotificationType = {
  email: 'email',
  whatsapp: 'whatsapp'
};

exports.ApproverType = exports.$Enums.ApproverType = {
  tag: 'tag',
  user_id: 'user_id',
  role_id: 'role_id'
};

exports.ApprovalStatus = exports.$Enums.ApprovalStatus = {
  pending: 'pending',
  approval_needed: 'approval_needed',
  approval_completed: 'approval_completed',
  approval_rejected: 'approval_rejected',
  void: 'void'
};

exports.Prisma.ModelName = {
  User: 'User',
  UserDetail: 'UserDetail',
  Designation: 'Designation',
  Department: 'Department',
  RequestLog: 'RequestLog',
  FinancialYear: 'FinancialYear',
  DocumentSequence: 'DocumentSequence',
  AuditLog: 'AuditLog',
  Permissions: 'Permissions',
  Role: 'Role',
  RolePermissions: 'RolePermissions',
  UserRoles: 'UserRoles',
  UserPermissions: 'UserPermissions',
  Otp: 'Otp',
  Language: 'Language',
  LanguageContent: 'LanguageContent',
  Menus: 'Menus',
  MenuItems: 'MenuItems',
  ActionType: 'ActionType',
  EntityType: 'EntityType',
  WizardGroup: 'WizardGroup',
  WizardType: 'WizardType',
  AboutLCP: 'AboutLCP',
  MasterEntity: 'MasterEntity',
  MasterEntityLineItem: 'MasterEntityLineItem',
  FieldType: 'FieldType',
  menuType: 'menuType',
  EmailTemplateProcess: 'EmailTemplateProcess',
  EmailTemplateTag: 'EmailTemplateTag',
  EmailTemplateRecipientTag: 'EmailTemplateRecipientTag',
  EmailTemplateProcessTagsMapping: 'EmailTemplateProcessTagsMapping',
  EmailTemplate: 'EmailTemplate',
  EmailTemplateAssignment: 'EmailTemplateAssignment',
  EmailTemplateCcBcc: 'EmailTemplateCcBcc',
  EmailProcessJob: 'EmailProcessJob',
  WhatsappProcessJob: 'WhatsappProcessJob',
  WhatsappTemplateProcess: 'WhatsappTemplateProcess',
  WhatsappTemplateTag: 'WhatsappTemplateTag',
  WhatsappTemplateRecipientTag: 'WhatsappTemplateRecipientTag',
  WhatsappTemplateProcessTagsMapping: 'WhatsappTemplateProcessTagsMapping',
  WhatsappTemplate: 'WhatsappTemplate',
  WhatsappTemplateAssignment: 'WhatsappTemplateAssignment',
  NotificationJob: 'NotificationJob',
  CarouselTemplate: 'CarouselTemplate',
  CarouselTemplateLineItem: 'CarouselTemplateLineItem',
  ImportTemplate: 'ImportTemplate',
  ImportTemplateLineItem: 'ImportTemplateLineItem',
  ImportTemplateQueries: 'ImportTemplateQueries',
  ImportJob: 'ImportJob',
  ImportJobLineItem: 'ImportJobLineItem',
  ExportTemplate: 'ExportTemplate',
  ExportTemplateLineItem: 'ExportTemplateLineItem',
  ExportTemplateQueries: 'ExportTemplateQueries',
  Status: 'Status',
  CategoryTypes: 'CategoryTypes',
  Categories: 'Categories',
  Configurations: 'Configurations',
  UserConfigurations: 'UserConfigurations',
  FileUploadLog: 'FileUploadLog',
  DataTransferQueries: 'DataTransferQueries',
  DeviceRegistration: 'DeviceRegistration',
  Policies: 'Policies',
  UserPolicies: 'UserPolicies',
  RolePolicies: 'RolePolicies',
  Appversions: 'Appversions',
  ScheduledJob: 'ScheduledJob',
  ScheduledJobLogs: 'ScheduledJobLogs',
  ApprovalWorkflow: 'ApprovalWorkflow',
  ApprovalWorkflowApproverTag: 'ApprovalWorkflowApproverTag',
  ApprovalWorkflowAssignment: 'ApprovalWorkflowAssignment',
  ApprovalProcessJob: 'ApprovalProcessJob',
  ApprovalProcessJobWorkflow: 'ApprovalProcessJobWorkflow',
  ApprovalProcessJobWorkflowUser: 'ApprovalProcessJobWorkflowUser',
  Delegation: 'Delegation',
  SchemaChunk: 'SchemaChunk',
  EmbeddingVectorLogs: 'EmbeddingVectorLogs',
  OpenaiUsageLog: 'OpenaiUsageLog',
  QueryExecutionLog: 'QueryExecutionLog',
  ChildProcess: 'ChildProcess',
  ChildProcessLog: 'ChildProcessLog',
  Organizations: 'Organizations'
};
/**
 * Create the Client
 */
const config = {
  "generator": {
    "name": "client",
    "provider": {
      "fromEnvVar": null,
      "value": "prisma-client-js"
    },
    "output": {
      "value": "/var/www/html/cs-collect-it-api/node_modules/@prisma/pg/client",
      "fromEnvVar": null
    },
    "config": {
      "engineType": "library"
    },
    "binaryTargets": [
      {
        "fromEnvVar": null,
        "value": "debian-openssl-3.0.x",
        "native": true
      }
    ],
    "previewFeatures": [
      "fullTextIndex",
      "fullTextSearch",
      "postgresqlExtensions"
    ],
    "isCustomOutput": true
  },
  "relativeEnvPaths": {
    "rootEnvPath": null
  },
  "relativePath": "../../../../prisma/pg",
  "clientVersion": "5.14.0",
  "engineVersion": "e9771e62de70f79a5e1c604a2d7c8e2a0a874b48",
  "datasourceNames": [
    "db"
  ],
  "activeProvider": "postgresql",
  "inlineDatasources": {
    "db": {
      "url": {
        "fromEnvVar": "DATABASE_URL",
        "value": null
      }
    }
  },
  "inlineSchema": "generator client {\n  provider        = \"prisma-client-js\"\n  previewFeatures = [\"fullTextSearch\", \"fullTextIndex\", \"postgresqlExtensions\"]\n  output          = \"../../node_modules/@prisma/pg/client\"\n}\n\n// datasource\ndatasource db {\n  provider   = \"postgresql\"\n  url        = env(\"DATABASE_URL\")\n  extensions = [vector]\n  //url      = \"postgresql://postgres:postgres@localhost:5432/lcp_framework\"\n}\n\nenum UserRole {\n  super_admin\n  company_admin\n  admin\n  user\n}\n\nenum Gender {\n  male\n  female\n  others\n}\n\nenum OtpPurpose {\n  login\n  password_reset\n  verify_email\n  others\n}\n\nenum RecipientType {\n  tag // RecipientTag slug\n  user_id // User id\n  custom // Any email address \n}\n\nenum ApproverType {\n  tag // RecipientTag slug\n  user_id // User id\n  role_id // Role id\n}\n\nenum NotifyType {\n  email\n  push\n}\n\nenum ClauseType {\n  where\n  having\n}\n\nenum sendMailType {\n  cc\n  bcc\n}\n\nenum ReportType {\n  lcp\n  powerbi\n}\n\nenum aboutType {\n  lcp\n  project\n}\n\nenum ApprovalStatus {\n  pending // 0 - Default\n  // approval_not_needed // 1\n  approval_needed // 1\n  approval_completed // 2\n  approval_rejected // 3\n  void // 4\n}\n\nenum ProcessStatus {\n  under_approval\n  approved\n  rejected\n  submitted\n  created\n  not_appear\n}\n\nenum NotificationType {\n  email\n  whatsapp\n}\n\n// prisma/schema.prisma\nmodel User {\n  id                Int           @id @default(autoincrement())\n  uuid              String        @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  username          String        @db.VarChar(100)\n  email             String        @db.VarChar(100)\n  email_verified    Boolean       @default(false)\n  password          String?       @db.VarChar(255)\n  status_id         Int           @default(1)\n  status            Status        @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  role              UserRole      @default(user)\n  process_status    ProcessStatus @default(submitted)\n  is_drafted        Boolean       @default(false)\n  reason            String?\n  company_id        Int\n  created_by        Int?\n  updated_by        Int?\n  deleted_by        Int?\n  created_at        DateTime      @default(now()) @db.Timestamptz\n  updated_at        DateTime      @default(now()) @updatedAt @db.Timestamptz\n  deleted_at        DateTime?     @db.Timestamptz\n  last_login        DateTime?     @db.Timestamptz\n  last_login_device String?       @db.VarChar(100)\n\n  // relationships\n  user_detail  UserDetail?\n  request_logs RequestLog[]\n  roles        UserRoles[]\n  permissions  UserPermissions[]\n  otps         Otp[]\n  created      User?             @relation(\"CreatedUser\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated      User?             @relation(\"UpdatedUser\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted      User?             @relation(\"DeletedUser\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  created_users        User[]       @relation(\"CreatedUser\")\n  updated_users        User[]       @relation(\"UpdatedUser\")\n  deleted_users        User[]       @relation(\"DeletedUser\")\n  created_user_details UserDetail[] @relation(\"CreatedUserDetail\")\n  updated_user_details UserDetail[] @relation(\"UpdatedUserDetail\")\n  deleted_user_details UserDetail[] @relation(\"DeletedUserDetail\")\n  created_roles        Role[]       @relation(\"CreatedRole\")\n  updated_roles        Role[]       @relation(\"UpdatedRole\")\n  deleted_roles        Role[]       @relation(\"DeletedRole\")\n  created_languages    Language[]   @relation(\"CreatedLanguage\")\n  updated_languages    Language[]   @relation(\"UpdatedLanguage\")\n  deleted_languages    Language[]   @relation(\"DeletedLanguage\")\n  created_menus        Menus[]      @relation(\"CreatedMenus\")\n  updated_menus        Menus[]      @relation(\"UpdatedMenus\")\n  deleted_menus        Menus[]      @relation(\"DeletedMenus\")\n  created_menu_items   MenuItems[]  @relation(\"CreatedMenuItems\")\n  updated_menu_items   MenuItems[]  @relation(\"UpdatedMenuItems\")\n  deleted_menu_items   MenuItems[]  @relation(\"DeletedMenuItems\")\n\n  created_email_templates            EmailTemplate[]              @relation(\"CreatedEmailTemplate\")\n  updated_email_templates            EmailTemplate[]              @relation(\"UpdatedEmailTemplate\")\n  deleted_email_templates            EmailTemplate[]              @relation(\"DeletedEmailTemplate\")\n  created_email_template_assignments EmailTemplateAssignment[]    @relation(\"CreatedEmailTemplateAssignment\")\n  created_email_process_jobs         EmailProcessJob[]            @relation(\"CreatedEmailProcessJob\")\n  created_whatsapp_process_jobs      WhatsappProcessJob[]         @relation(\"CreatedWhatsappProcessJob\")\n  created_notification_job           NotificationJob[]            @relation(\"CreatedNotificationJob\")\n  created_import_templates           ImportTemplate[]             @relation(\"CreatedImportTemplate\")\n  updated_import_templates           ImportTemplate[]             @relation(\"UpdatedImportTemplate\")\n  deleted_import_templates           ImportTemplate[]             @relation(\"DeletedImportTemplate\")\n  created_carousel_templates         CarouselTemplate[]           @relation(\"CreatedCarouselTemplate\")\n  updated_carousel_templates         CarouselTemplate[]           @relation(\"UpdatedCarouselTemplate\")\n  deleted_carousel_templates         CarouselTemplate[]           @relation(\"DeletedCarouselTemplate\")\n  created_whatsapp_templates         WhatsappTemplate[]           @relation(\"CreatedWhatsappTemplate\")\n  updated_whatsapp_templates         WhatsappTemplate[]           @relation(\"UpdatedWhatsappTemplate\")\n  deleted_whatsapp_templates         WhatsappTemplate[]           @relation(\"DeletedWhatsappTemplate\")\n  whatsapp_template_assignment       WhatsappTemplateAssignment[] @relation(\"CreatedwhatsappTemplateAssignment\")\n\n  created_export_templates ExportTemplate[] @relation(\"CreatedExportTemplate\")\n  updated_export_templates ExportTemplate[] @relation(\"UpdatedExportTemplate\")\n  deleted_export_templates ExportTemplate[] @relation(\"DeletedExportTemplate\")\n\n  created_departments    Department[]    @relation(\"CreatedDepartment\")\n  head_departments       Department[]    @relation(\"DepartmentHead\")\n  updated_departments    Department[]    @relation(\"UpdatedDepartment\")\n  deleted_departments    Department[]    @relation(\"DeletedDepartment\")\n  created_designations   Designation[]   @relation(\"CreatedDesignation\")\n  updated_designations   Designation[]   @relation(\"UpdatedDesignation\")\n  deleted_designations   Designation[]   @relation(\"DeletedDesignation\")\n  audit_logs             AuditLog[]\n  created_category_types CategoryTypes[] @relation(\"CreatedCategoryTypes\")\n  updated_category_types CategoryTypes[] @relation(\"UpdatedCategoryTypes\")\n  deleted_category_types CategoryTypes[] @relation(\"DeletedCategoryTypes\")\n  created_categories     Categories[]    @relation(\"CreatedCategories\")\n  updated_categories     Categories[]    @relation(\"UpdatedCategories\")\n  deleted_categories     Categories[]    @relation(\"DeletedCategories\")\n\n  created_configurations Configurations[] @relation(\"CreatedConfigurations\")\n  updated_configurations Configurations[] @relation(\"UpdatedConfigurations\")\n  deleted_configurations Configurations[] @relation(\"DeletedConfigurations\")\n\n  created_user_configurations UserConfigurations[] @relation(\"CreatedUserConfigurations\")\n  updated_user_configurations UserConfigurations[] @relation(\"UpdatedUserConfigurations\")\n  deleted_user_configurations UserConfigurations[] @relation(\"DeletedUserConfigurations\")\n\n  created_fin_years           FinancialYear[]      @relation(\"CreatedFinYear\")\n  updated_fin_years           FinancialYear[]      @relation(\"UpdatedFinYear\")\n  deleted_fin_years           FinancialYear[]      @relation(\"DeletedFinYear\")\n  created_doc_sequences       DocumentSequence[]   @relation(\"CreatedDocumentSequence\")\n  updated_doc_sequences       DocumentSequence[]   @relation(\"UpdatedDocumentSequence\")\n  deleted_doc_sequences       DocumentSequence[]   @relation(\"DeletedDocumentSequence\")\n  created_device_registration DeviceRegistration[] @relation(\"CreatedDeviceRegistration\")\n  updated_device_registration DeviceRegistration[] @relation(\"UpdatedDeviceRegistration\")\n  deleted_device_registration DeviceRegistration[] @relation(\"DeletedDeviceRegistration\")\n  DeviceRegistration          DeviceRegistration[]\n  created_import_job          ImportJob[]          @relation(\"CreatedImportJob\")\n  updated_import_job          ImportJob[]          @relation(\"UpdatedImportJob\")\n  deleted_import_job          ImportJob[]          @relation(\"DeletedImportJob\")\n\n  created_organizations Organizations[] @relation(\"CreatedOrganization\")\n  updated_organizations Organizations[] @relation(\"UpdatedOrganization\")\n  deleted_organizations Organizations[] @relation(\"DeletedOrganization\")\n\n  user_policy    UserPolicies[]\n  created_policy Policies[]     @relation(\"CreatedPolicy\")\n  updated_policy Policies[]     @relation(\"UpdatedPolicy\")\n  deleted_policy Policies[]     @relation(\"DeletedPolicy\")\n\n  created_app_versions Appversions[] @relation(\"Created_app_versions\")\n  updated_app_versions Appversions[] @relation(\"Updated_app_versions\")\n  deleted_app_versions Appversions[] @relation(\"Deleted_app_versions\")\n\n  ChildProcessLog ChildProcessLog[] @relation(\"Initiator\")\n\n  @@unique([company_id, uuid])\n  @@unique([company_id, email, role])\n  @@unique([company_id, username])\n  @@unique([company_id, id]) // Ensure uniqueness for the combination\n  @@map(\"users\")\n}\n\nmodel UserDetail {\n  id              Int       @id @default(autoincrement())\n  user_id         Int\n  code            String    @db.VarChar(100)\n  first_name      String    @db.VarChar(100)\n  last_name       String?   @db.VarChar(100)\n  designation_id  Int?\n  department_id   Int?\n  organization_id Int?\n  profile_pic     String?   @db.VarChar(255)\n  dob             DateTime? @db.Date\n  country_code    String?   @db.VarChar(100)\n  phone_number    String?   @db.VarChar(100)\n  gender          Gender    @default(male)\n  user_time_zone  String?   @db.VarChar(100)\n  address         String?   @db.VarChar(255)\n  culture         String?   @db.VarChar(100)\n  company_id      Int\n  created_by      Int?\n  updated_by      Int?\n  deleted_by      Int?\n  created_at      DateTime  @default(now()) @db.Timestamptz\n  updated_at      DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at      DateTime? @db.Timestamptz\n\n  // relationships\n  designation Designation? @relation(\"UserDesignation\", fields: [company_id, designation_id], references: [company_id, id], onDelete: Cascade)\n  department  Department?  @relation(\"UserDepartment\", fields: [company_id, department_id], references: [company_id, id], onDelete: Cascade)\n\n  organizations Organizations? @relation(\"UserOrganization\", fields: [company_id, organization_id], references: [company_id, id], onDelete: Cascade)\n\n  user    User  @relation(fields: [company_id, user_id], references: [company_id, id], onDelete: Cascade)\n  created User? @relation(\"CreatedUserDetail\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated User? @relation(\"UpdatedUserDetail\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted User? @relation(\"DeletedUserDetail\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, user_id]) // Ensure uniqueness for the combination\n  @@unique([company_id, code])\n  @@map(\"user_details\")\n}\n\nmodel Designation {\n  id          Int       @id @default(autoincrement())\n  uuid        String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  code        String    @db.VarChar(100)\n  name        String    @db.VarChar(100)\n  description String?   @db.Text\n  status_id   Int       @default(1)\n  status      Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id  Int\n  created_by  Int?\n  updated_by  Int?\n  deleted_by  Int?\n  created_at  DateTime  @default(now()) @db.Timestamptz\n  updated_at  DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at  DateTime? @db.Timestamptz\n\n  // relationships\n  users   UserDetail[] @relation(\"UserDesignation\")\n  created User?        @relation(\"CreatedDesignation\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated User?        @relation(\"UpdatedDesignation\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted User?        @relation(\"DeletedDesignation\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, code])\n  @@map(\"designations\")\n}\n\nmodel Department {\n  id                 Int       @id @default(autoincrement())\n  uuid               String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  code               String    @db.VarChar(100)\n  name               String    @db.VarChar(100)\n  description        String?   @db.Text\n  status_id          Int       @default(1)\n  status             Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  department_head_id Int?\n  company_id         Int\n  created_by         Int?\n  updated_by         Int?\n  deleted_by         Int?\n  created_at         DateTime  @default(now()) @db.Timestamptz\n  updated_at         DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at         DateTime? @db.Timestamptz\n\n  // relationships\n  users           UserDetail[] @relation(\"UserDepartment\")\n  department_head User?        @relation(\"DepartmentHead\", fields: [company_id, department_head_id], references: [company_id, id], onDelete: Cascade)\n  created         User?        @relation(\"CreatedDepartment\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated         User?        @relation(\"UpdatedDepartment\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted         User?        @relation(\"DeletedDepartment\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, code])\n  @@map(\"departments\")\n}\n\nmodel RequestLog {\n  id           BigInt    @id @default(autoincrement())\n  uuid         String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  user_id      Int?\n  req_method   String?   @db.VarChar(100)\n  req_url      String?   @db.VarChar(255)\n  req_body     String?   @db.Text\n  res_status   Boolean   @default(false)\n  res_code     Int       @default(500)\n  res_message  String?   @db.Text\n  req_response String?   @db.Text\n  req_headers  String?   @db.Text\n  req_ip       String?   @db.VarChar(255)\n  req_device   String?   @db.VarChar(255)\n  status_id    Int       @default(1)\n  status       Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id   Int\n  created_at   DateTime  @default(now()) @db.Timestamptz\n  updated_at   DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at   DateTime? @db.Timestamptz\n\n  // relationships\n  user User? @relation(fields: [company_id, user_id], references: [company_id, id], onDelete: Cascade)\n\n  @@index([company_id])\n  @@map(\"request_logs\")\n}\n\nmodel FinancialYear {\n  id         Int       @id @default(autoincrement())\n  uuid       String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name       String    @db.VarChar(100)\n  code       String    @db.VarChar(100)\n  is_freezed Boolean   @default(false)\n  start_date DateTime  @db.Timestamptz\n  end_date   DateTime  @db.Timestamptz\n  status_id  Int       @default(1)\n  status     Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id Int\n  created_by Int?\n  updated_by Int?\n  deleted_by Int?\n  created_at DateTime  @default(now()) @db.Timestamptz\n  updated_at DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at DateTime? @db.Timestamptz\n\n  // relationships\n  document_sequence DocumentSequence[] @relation(\"DocumentSequenceFinancialYear\")\n  created           User?              @relation(\"CreatedFinYear\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated           User?              @relation(\"UpdatedFinYear\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted           User?              @relation(\"DeletedFinYear\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, code])\n  @@map(\"financial_years\")\n}\n\nmodel DocumentSequence {\n  id                  Int       @id @default(autoincrement())\n  uuid                String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  module_name         String    @db.VarChar(100)\n  financial_year_id   Int?\n  current_sequence_no Int       @default(0)\n  start_sequence_no   Int       @default(0)\n  end_sequence_no     Int       @default(0)\n  sequence_length     Int       @default(9)\n  status_id           Int       @default(1)\n  code_format         String?   @db.VarChar(100)\n  status              Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id          Int\n  created_by          Int?\n  updated_by          Int?\n  deleted_by          Int?\n  created_at          DateTime  @default(now()) @db.Timestamptz\n  updated_at          DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at          DateTime? @db.Timestamptz\n\n  finanicial_year FinancialYear? @relation(\"DocumentSequenceFinancialYear\", fields: [company_id, financial_year_id], references: [company_id, id], onDelete: Cascade)\n  created         User?          @relation(\"CreatedDocumentSequence\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated         User?          @relation(\"UpdatedDocumentSequence\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted         User?          @relation(\"DeletedDocumentSequence\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, financial_year_id, module_name])\n  @@map(\"document_sequences\")\n}\n\nmodel AuditLog {\n  id             Int      @id @default(autoincrement())\n  operation_type String   @db.VarChar(10)\n  table_name     String   @db.VarChar(100)\n  field_name     String   @db.VarChar(100)\n  old_value      String?  @db.Text\n  new_value      String?  @db.Text\n  entity_id      Int\n  user_id        Int?\n  status_id      Int      @default(1)\n  status         Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id     Int?\n  created_at     DateTime @default(now()) @db.Timestamptz\n\n  user User? @relation(fields: [user_id], references: [id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@map(\"audit_logs\")\n}\n\nmodel Permissions {\n  id         Int      @id @default(autoincrement())\n  name       String   @db.VarChar(100)\n  slug       String   @db.VarChar(100)\n  entity_id  Int?\n  order_no   Decimal  @default(0) @db.Decimal(4, 2)\n  status_id  Int      @default(1)\n  status     Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id Int\n  created_at DateTime @default(now()) @db.Timestamptz\n\n  // Many-to-many relationship with Role\n  entity MasterEntity?     @relation(fields: [company_id, entity_id], references: [company_id, id])\n  roles  RolePermissions[]\n  users  UserPermissions[]\n  menus  MenuItems[]\n\n  // Add an index to the order_no field\n  @@unique([company_id, slug])\n  @@unique([company_id, id])\n  @@index([company_id, order_no])\n  @@map(\"permissions\")\n}\n\nmodel Role {\n  id          Int       @id @default(autoincrement())\n  uuid        String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name        String    @db.VarChar(100)\n  description String?   @db.Text\n  status_id   Int       @default(1)\n  status      Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id  Int\n  created_by  Int?\n  updated_by  Int?\n  deleted_by  Int?\n  created_at  DateTime  @default(now()) @db.Timestamptz\n  updated_at  DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at  DateTime? @db.Timestamptz\n\n  // Many-to-many relationship with Permissions\n  permissions RolePermissions[]\n  users       UserRoles[]\n  role_policy RolePolicies[]\n\n  // relationships\n  created User? @relation(\"CreatedRole\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated User? @relation(\"UpdatedRole\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted User? @relation(\"DeletedRole\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, name])\n  @@map(\"roles\")\n}\n\nmodel RolePermissions {\n  role          Role        @relation(fields: [company_id, role_id], references: [company_id, id], onDelete: Cascade)\n  role_id       Int\n  permission    Permissions @relation(fields: [company_id, permission_id], references: [company_id, id], onDelete: Cascade)\n  permission_id Int\n  company_id    Int\n\n  @@id([company_id, role_id, permission_id])\n  @@map(\"role_permissions\")\n}\n\nmodel UserRoles {\n  user       User @relation(fields: [company_id, user_id], references: [company_id, id], onDelete: Cascade)\n  user_id    Int\n  role       Role @relation(fields: [company_id, role_id], references: [company_id, id], onDelete: Cascade)\n  role_id    Int\n  company_id Int\n\n  @@id([company_id, user_id, role_id])\n  @@map(\"user_roles\")\n}\n\nmodel UserPermissions {\n  user          User        @relation(fields: [company_id, user_id], references: [company_id, id], onDelete: Cascade)\n  user_id       Int\n  permission    Permissions @relation(fields: [company_id, permission_id], references: [company_id, id], onDelete: Cascade)\n  permission_id Int\n  company_id    Int\n\n  @@id([company_id, user_id, permission_id])\n  @@map(\"user_permissions\")\n}\n\nmodel Otp {\n  id         Int        @id @default(autoincrement())\n  user_id    Int\n  otp        String     @db.VarChar(8)\n  purpose    OtpPurpose\n  company_id Int\n  created_at DateTime   @default(now()) @db.Timestamptz\n\n  user User @relation(fields: [company_id, user_id], references: [company_id, id], onDelete: Cascade)\n\n  @@index([company_id, user_id, purpose])\n  @@map(\"otps\")\n}\n\nmodel Language {\n  id              Int       @id @default(autoincrement())\n  uuid            String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name            String    @db.VarChar(100)\n  name_in_english String?   @db.VarChar(100)\n  flag            String?   @db.VarChar(10)\n  code            String?   @db.VarChar(10)\n  rtl             Boolean   @default(false)\n  description     String    @db.Text\n  status_id       Int       @default(1)\n  status          Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id      Int\n  created_by      Int?\n  updated_by      Int?\n  deleted_by      Int?\n  created_at      DateTime  @default(now()) @db.Timestamptz\n  updated_at      DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at      DateTime? @db.Timestamptz\n\n  // relationships\n  translations LanguageContent[] @relation(\"LanguageTrans\")\n  created      User?             @relation(\"CreatedLanguage\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated      User?             @relation(\"UpdatedLanguage\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted      User?             @relation(\"DeletedLanguage\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, code])\n  @@map(\"languages\")\n}\n\nmodel LanguageContent {\n  id          Int      @id @default(autoincrement())\n  language_id Int      @default(1)\n  key_content String   @db.VarChar(100)\n  values      String   @db.VarChar(100)\n  status_id   Int      @default(1)\n  status      Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id  Int\n  created_at  DateTime @default(now()) @db.Timestamptz\n\n  // relationships\n  language Language? @relation(\"LanguageTrans\", fields: [company_id, language_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@map(\"language_contents\")\n}\n\nmodel Menus {\n  id          Int       @id @default(autoincrement())\n  uuid        String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name        String    @db.VarChar(100)\n  slug        String?   @db.VarChar(255)\n  description String?   @db.VarChar(100)\n  menu_type   Int\n  status_id   Int       @default(1)\n  status      Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id  Int\n  created_by  Int?\n  updated_by  Int?\n  deleted_by  Int?\n  created_at  DateTime  @default(now()) @db.Timestamptz\n  updated_at  DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at  DateTime? @db.Timestamptz\n\n  menuitems MenuItems[]\n\n  created User? @relation(\"CreatedMenus\", fields: [company_id, created_by], references: [company_id, id])\n  updated User? @relation(\"UpdatedMenus\", fields: [company_id, updated_by], references: [company_id, id])\n  deleted User? @relation(\"DeletedMenus\", fields: [company_id, deleted_by], references: [company_id, id])\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@map(\"menu\")\n}\n\nmodel MenuItems {\n  id             Int       @id @default(autoincrement())\n  menu_id        Int\n  name           String    @db.VarChar(100)\n  target         String?   @db.VarChar(255)\n  parent_id      Int?\n  permission_id  Int?\n  entity_id      Int?\n  link_type      Int?\n  order_no       Decimal   @default(0) @db.Decimal(4, 2)\n  menu_img       String?   @db.VarChar(255)\n  short_cut_keys String?   @db.VarChar(255)\n  status_id      Int       @default(1)\n  status         Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id     Int\n  created_by     Int?\n  updated_by     Int?\n  deleted_by     Int?\n  created_at     DateTime  @default(now()) @db.Timestamptz\n  updated_at     DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at     DateTime? @db.Timestamptz\n\n  // relationships\n  menus      Menus?        @relation(fields: [company_id, menu_id], references: [company_id, id])\n  entity     MasterEntity? @relation(fields: [company_id, entity_id], references: [company_id, id])\n  permission Permissions?  @relation(fields: [company_id, permission_id], references: [company_id, id], onDelete: Cascade)\n  parent     MenuItems?    @relation(\"ChildMenuItemss\", fields: [company_id, parent_id], references: [company_id, id])\n  children   MenuItems[]   @relation(\"ChildMenuItemss\")\n  created    User?         @relation(\"CreatedMenuItems\", fields: [company_id, created_by], references: [company_id, id])\n  updated    User?         @relation(\"UpdatedMenuItems\", fields: [company_id, updated_by], references: [company_id, id])\n  deleted    User?         @relation(\"DeletedMenuItems\", fields: [company_id, deleted_by], references: [company_id, id])\n\n  @@unique([company_id, id])\n  @@unique([company_id, menu_id, name])\n  @@map(\"menu_items\")\n}\n\nmodel ActionType {\n  id          Int    @id @default(autoincrement())\n  name        String @db.VarChar(100)\n  description String @db.VarChar(255)\n  company_id  Int\n\n  @@unique([company_id, id])\n  @@map(\"action_types\")\n}\n\nmodel EntityType {\n  id          Int    @id @default(autoincrement())\n  name        String @db.VarChar(100)\n  slug        String @db.VarChar(100)\n  description String @db.VarChar(255)\n  company_id  Int\n\n  @@unique([company_id, id])\n  @@map(\"entity_types\")\n}\n\nmodel WizardGroup {\n  id          Int      @id @default(autoincrement())\n  uuid        String   @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name        String   @db.VarChar(100)\n  slug        String?  @db.VarChar(100)\n  description String?  @db.VarChar(100)\n  status_id   Int      @default(1)\n  created_at  DateTime @default(now()) @db.Timestamptz\n  company_id  Int\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"wizard_group\")\n}\n\nmodel WizardType {\n  id          Int     @id @default(autoincrement())\n  uuid        String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name        String  @db.VarChar(100)\n  description String? @db.VarChar(100)\n\n  company_id Int\n\n  @@unique([company_id, id])\n  @@unique([company_id, name])\n  @@map(\"wizard_types\")\n}\n\nmodel AboutLCP {\n  id                      Int       @id @default(autoincrement())\n  uuid                    String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  type                    aboutType @default(lcp)\n  name                    String    @db.VarChar(255)\n  description             String?   @db.Text\n  order_no                Decimal?  @default(0) @db.Decimal(4, 2)\n  documentation_video_url String?   @db.Text\n  documentation_pdf       String?   @db.Text\n  documentation_word      String?   @db.Text\n  status_id               Int       @default(1)\n  status                  Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id              Int\n  created_by              Int\n  created_at              DateTime  @default(now()) @db.Timestamptz\n  updated_by              Int?\n  updated_at              DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by              Int?\n  deleted_at              DateTime? @db.Timestamptz\n\n  @@unique([company_id, id])\n  @@map(\"about_lcp\")\n}\n\nmodel MasterEntity {\n  id                        Int        @id @default(autoincrement())\n  uuid                      String     @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name                      String     @db.VarChar(100)\n  entity_name               String     @db.VarChar(100)\n  entity_type               String     @db.VarChar(100)\n  report_type               ReportType @default(lcp)\n  primary_table             String?    @db.VarChar(100)\n  is_admin_module           Boolean    @default(false)\n  draft_mode                Boolean    @default(false) // draft mode option for screen wise save draft option\n  associated_tables         Json?      @db.JsonB\n  query_information         Json?      @db.JsonB\n  form_information          Json?      @db.JsonB\n  report_information        Json?      @db.JsonB\n  add_query_information     Json?      @db.JsonB\n  edit_query_information    Json?      @db.JsonB\n  preset_query_information  Json?      @db.JsonB\n  static_page_content       String?    @db.Text\n  export_template_id        Int?\n  dashboard_wizard_group_id Int?\n  dashboard_wizard_type     String?    @db.VarChar(100)\n  dashboard_wizard_rows     Int?\n  dashboard_wizard_columns  Int?\n  dashboard_wizard_order_no Decimal?   @default(0) @db.Decimal(4, 2)\n  dashboard_wizard_options  Json?      @db.JsonB\n  status_id                 Int        @default(1)\n  status                    Status     @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id                Int\n  created_at                DateTime   @default(now()) @db.Timestamptz\n  deleted_at                DateTime?  @db.Timestamptz\n\n  permissions Permissions[]\n  line_items  MasterEntityLineItem[]\n  menus       MenuItems[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, entity_name])\n  @@map(\"master_entities\")\n}\n\nmodel MasterEntityLineItem {\n  id             Int        @id @default(autoincrement())\n  master_grid_id Int\n  field_name     String     @db.VarChar(255)\n  display_name   String     @db.VarChar(100)\n  order_no       Decimal    @default(0) @db.Decimal(4, 2)\n  is_grid_column Boolean    @default(true)\n  is_searchable  Boolean    @default(true)\n  clause_type    ClauseType @default(where)\n  is_sortable    Boolean    @default(true)\n  field_type_id  Int\n  link_type      String     @default(\"none\") @db.VarChar(100)\n  link_action    String?    @db.VarChar(100)\n  link_mode      String     @default(\"none\") @db.VarChar(100)\n  status_id      Int        @default(1)\n  status         Status     @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id     Int\n  created_at     DateTime   @default(now()) @db.Timestamptz\n\n  master_grid MasterEntity @relation(fields: [company_id, master_grid_id], references: [company_id, id], onDelete: Cascade)\n  field_type  FieldType?   @relation(fields: [company_id, field_type_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, master_grid_id, field_name, display_name])\n  @@map(\"master_entity_line_items\")\n}\n\nmodel FieldType {\n  id         Int      @id @default(autoincrement())\n  field_type String   @db.VarChar(100)\n  company_id Int\n  status_id  Int      @default(1)\n  status     Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at DateTime @default(now()) @db.Timestamptz\n\n  master_grid_lineitem   MasterEntityLineItem[]\n  importTemplateLineItem ImportTemplateLineItem[]\n  exportTemplateLineItem ExportTemplateLineItem[]\n\n  @@unique([company_id, id])\n  @@map(\"field_types\")\n}\n\nmodel menuType {\n  id         Int      @id @default(autoincrement())\n  name       String?  @db.VarChar(100)\n  status_id  Int      @default(1)\n  status     Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id Int\n  created_at DateTime @default(now()) @db.Timestamptz\n\n  @@unique([company_id, id])\n  @@map(\"menu_types\")\n}\n\nmodel EmailTemplateProcess {\n  id                         Int                               @id @default(autoincrement())\n  uuid                       String                            @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name                       String                            @db.VarChar(100)\n  slug                       String                            @db.VarChar(100)\n  query_information          String?                           @db.Text\n  status_id                  Int                               @default(1)\n  status                     Status                            @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id                 Int\n  email_template_groups      EmailTemplateProcessTagsMapping[]\n  email_templates            EmailTemplate[]\n  email_template_assignments EmailTemplateAssignment[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@unique([id, company_id])\n  @@map(\"email_template_process\")\n}\n\nmodel EmailTemplateTag {\n  id                    Int                               @id @default(autoincrement())\n  uuid                  String                            @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  slug                  String                            @db.VarChar(100)\n  name                  String?                           @db.VarChar(100)\n  description           String?                           @db.Text\n  status_id             Int                               @default(1)\n  status                Status                            @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id            Int\n  email_template_groups EmailTemplateProcessTagsMapping[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"email_template_tags\")\n}\n\nmodel EmailTemplateRecipientTag {\n  id                Int     @id @default(autoincrement())\n  uuid              String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  slug              String  @db.VarChar(100)\n  name              String? @db.VarChar(100)\n  description       String? @db.Text\n  query_information String? @db.Text\n  status_id         Int     @default(1)\n  status            Status  @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id        Int\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"email_template_recipient_tags\")\n}\n\nmodel EmailTemplateProcessTagsMapping {\n  email_template_process_id Int\n  email_template_tag_id     Int\n  company_id                Int\n  email_template_process    EmailTemplateProcess @relation(fields: [email_template_process_id, company_id], references: [id, company_id])\n  email_template_tag        EmailTemplateTag     @relation(fields: [email_template_tag_id, company_id], references: [id, company_id])\n\n  @@id([email_template_process_id, email_template_tag_id, company_id])\n  @@map(\"email_template_process_tags_mapping\")\n}\n\nmodel EmailTemplate {\n  id                         Int                       @id @default(autoincrement())\n  uuid                       String                    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  slug                       String                    @db.VarChar(100)\n  name                       String                    @db.VarChar(100)\n  subject                    String                    @db.VarChar(255)\n  template_body              String                    @db.Text\n  email_template_process_id  Int\n  status_id                  Int                       @default(1)\n  status                     Status                    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at                 DateTime                  @default(now()) @map(\"created_at\") @db.Timestamptz\n  created_by                 Int?\n  updated_at                 DateTime                  @default(now()) @updatedAt @map(\"updated_at\") @db.Timestamptz\n  updated_by                 Int?\n  deleted_at                 DateTime?                 @map(\"deleted_at\") @db.Timestamptz\n  deleted_by                 Int?\n  company_id                 Int\n  email_template_process     EmailTemplateProcess      @relation(fields: [email_template_process_id, company_id], references: [id, company_id])\n  email_template_assignments EmailTemplateAssignment[] @relation(\"EmailTemplateAssignment\")\n  created                    User?                     @relation(\"CreatedEmailTemplate\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated                    User?                     @relation(\"UpdatedEmailTemplate\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted                    User?                     @relation(\"DeletedEmailTemplate\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  approval_workflow_assignments_approve ApprovalWorkflowAssignment[] @relation(\"ApproveAssignmentMail\")\n  approval_workflow_assignments_reject  ApprovalWorkflowAssignment[] @relation(\"RejectAssignmentMail\")\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"email_templates\")\n}\n\nmodel EmailTemplateAssignment {\n  id                        Int                  @id @default(autoincrement())\n  uuid                      String               @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  email_template_process_id Int\n  template_id               Int\n  recipient_type            RecipientType        @default(tag)\n  email_to                  String?              @db.VarChar(100) // slug of EmailTemplateRecipientTag\n  company_id                Int\n  created_at                DateTime             @default(now()) @map(\"created_at\") @db.Timestamptz\n  created_by                Int\n  email_template_process    EmailTemplateProcess @relation(fields: [email_template_process_id, company_id], references: [id, company_id])\n  email_template            EmailTemplate        @relation(\"EmailTemplateAssignment\", fields: [template_id, company_id], references: [id, company_id])\n  created                   User                 @relation(\"CreatedEmailTemplateAssignment\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  email_template_cc_bcc     EmailTemplateCcBcc[]\n\n  @@unique([id])\n  @@map(\"email_template_assignments\")\n}\n\nmodel EmailTemplateCcBcc {\n  id                           Int                     @id @default(autoincrement())\n  uuid                         String                  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  send_type                    sendMailType            @default(cc)\n  recipient_type               RecipientType           @default(tag)\n  email_to                     String?                 @db.VarChar(100)\n  company_id                   Int\n  created_at                   DateTime                @default(now()) @map(\"created_at\") @db.Timestamptz\n  created_by                   Int\n  email_template_assignment_id Int\n  email_template_assignment    EmailTemplateAssignment @relation(fields: [email_template_assignment_id], references: [id], onDelete: Cascade)\n\n  @@map(\"email_template_cc_bcc\")\n}\n\nmodel EmailProcessJob {\n  id                          Int      @id @default(autoincrement())\n  uuid                        String   @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  email_template_process_slug String   @db.VarChar(100)\n  unique_id                   String   @db.VarChar(100)\n  user_id                     Int //String   @db.VarChar(100)\n  prefill_data                String?  @db.Text\n  attachments_path            String?  @db.Text\n  attachments_name            String?  @db.Text\n  company_id                  Int\n  status_id                   Int      @default(1)\n  status                      Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at                  DateTime @default(now()) @map(\"created_at\") @db.Timestamptz\n  created_by                  Int?\n  created                     User?    @relation(\"CreatedEmailProcessJob\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n\n  @@map(\"email_process_jobs\")\n}\n\nmodel WhatsappProcessJob {\n  id                             Int      @id @default(autoincrement())\n  uuid                           String   @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  whatsapp_template_process_slug String   @db.VarChar(100)\n  unique_id                      String   @db.VarChar(100)\n  user_id                        Int //String   @db.VarChar(100)\n  prefill_data                   String?  @db.Text\n  attachments_path               String?  @db.Text\n  attachments_name               String?  @db.Text\n  company_id                     Int\n  status_id                      Int      @default(1)\n  status                         Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at                     DateTime @default(now()) @map(\"created_at\") @db.Timestamptz\n  created_by                     Int?\n  created                        User?    @relation(\"CreatedWhatsappProcessJob\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n\n  @@map(\"whatsapp_process_jobs\")\n}\n\nmodel WhatsappTemplateProcess {\n  id                            Int                                  @id @default(autoincrement())\n  uuid                          String                               @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name                          String                               @db.VarChar(100)\n  slug                          String                               @db.VarChar(100)\n  query_information             String?                              @db.Text\n  status_id                     Int                                  @default(1)\n  status                        Status                               @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id                    Int\n  whatsapp_template_groups      WhatsappTemplateProcessTagsMapping[]\n  whatsapp_templates            WhatsappTemplate[]\n  whatsapp_template_assignments WhatsappTemplateAssignment[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@unique([id, company_id])\n  @@map(\"whatsapp_template_process\")\n}\n\nmodel WhatsappTemplateTag {\n  id                       Int                                  @id @default(autoincrement())\n  uuid                     String                               @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  slug                     String                               @db.VarChar(100)\n  name                     String?                              @db.VarChar(100)\n  description              String?                              @db.Text\n  status_id                Int                                  @default(1)\n  status                   Status                               @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id               Int\n  whatsapp_template_groups WhatsappTemplateProcessTagsMapping[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"whatsapp_template_tags\")\n}\n\nmodel WhatsappTemplateRecipientTag {\n  id                Int     @id @default(autoincrement())\n  uuid              String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  slug              String  @db.VarChar(100)\n  name              String? @db.VarChar(100)\n  description       String? @db.Text\n  query_information String? @db.Text\n  status_id         Int     @default(1)\n  status            Status  @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id        Int\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"whatsapp_template_recipient_tags\")\n}\n\nmodel WhatsappTemplateProcessTagsMapping {\n  whatsapp_template_process_id Int\n  whatsapp_template_tag_id     Int\n  company_id                   Int\n  whatsapp_template_process    WhatsappTemplateProcess @relation(fields: [whatsapp_template_process_id, company_id], references: [id, company_id])\n  whatsapp_template_tag        WhatsappTemplateTag     @relation(fields: [whatsapp_template_tag_id, company_id], references: [id, company_id])\n\n  @@id([whatsapp_template_process_id, whatsapp_template_tag_id, company_id])\n  @@map(\"whatsapp_template_process_tags_mapping\")\n}\n\nmodel WhatsappTemplate {\n  id                            Int                          @id @default(autoincrement())\n  uuid                          String                       @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  slug                          String                       @db.VarChar(100)\n  name                          String                       @db.VarChar(100)\n  message                       String                       @db.Text\n  whatsapp_template_process_id  Int\n  status_id                     Int                          @default(1)\n  status                        Status                       @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at                    DateTime                     @default(now()) @map(\"created_at\") @db.Timestamptz\n  created_by                    Int?\n  updated_at                    DateTime                     @default(now()) @updatedAt @map(\"updated_at\") @db.Timestamptz\n  updated_by                    Int?\n  deleted_at                    DateTime?                    @map(\"deleted_at\") @db.Timestamptz\n  deleted_by                    Int?\n  company_id                    Int\n  whatsapp_template_process     WhatsappTemplateProcess      @relation(fields: [whatsapp_template_process_id, company_id], references: [id, company_id])\n  whatsapp_template_assignments WhatsappTemplateAssignment[] @relation(\"WhatsappTemplateAssignment\")\n  created                       User?                        @relation(\"CreatedWhatsappTemplate\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated                       User?                        @relation(\"UpdatedWhatsappTemplate\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted                       User?                        @relation(\"DeletedWhatsappTemplate\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  // approval_workflow_assignments_approve ApprovalWorkflowAssignment[] @relation(\"ApproveAssignmentMail\")\n  // approval_workflow_assignments_reject  ApprovalWorkflowAssignment[] @relation(\"RejectAssignmentMail\")\n\n  approval_workflow_assignments_approve ApprovalWorkflowAssignment[] @relation(\"ApproveAssignmentWhatsapp\")\n  approval_workflow_assignments_reject  ApprovalWorkflowAssignment[] @relation(\"RejectAssignmentWhatsapp\")\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"whatsapp_templates\")\n}\n\nmodel WhatsappTemplateAssignment {\n  id                           Int                     @id @default(autoincrement())\n  uuid                         String                  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  whatsapp_template_process_id Int\n  template_id                  Int\n  recipient_type               RecipientType           @default(tag)\n  whatsapp_to                  String?                 @db.VarChar(100) // slug of whatsappTemplateRecipientTag\n  company_id                   Int\n  created_at                   DateTime                @default(now()) @map(\"created_at\") @db.Timestamptz\n  created_by                   Int\n  whatsapp_template_process    WhatsappTemplateProcess @relation(fields: [whatsapp_template_process_id, company_id], references: [id, company_id])\n  whatsapp_template            WhatsappTemplate        @relation(\"WhatsappTemplateAssignment\", fields: [template_id, company_id], references: [id, company_id])\n  created                      User                    @relation(\"CreatedwhatsappTemplateAssignment\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([id])\n  @@map(\"whatsapp_template_assignments\")\n}\n\nmodel NotificationJob {\n  id                     Int              @id @default(autoincrement())\n  uuid                   String           @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  process_slug           String           @db.VarChar(100)\n  //notify_type    NotifyType @default(email)\n  notification_to        String?          @db.Text\n  notification_subject   String?          @db.VarChar(100)\n  notification_content   String?          @db.Text\n  attachments_path       String?          @db.Text\n  attachments_name       String?          @db.Text\n  notification_cc        String?          @db.VarChar(100)\n  notification_bcc       String?          @db.VarChar(100)\n  notification_type_id   String           @db.VarChar(10)\n  notification_status_id String           @db.VarChar(10)\n  notification_type      NotificationType @default(email)\n  //is_unread      Boolean    @default(true)\n  company_id             Int\n  status_id              Int              @default(1)\n  parent_id              Int              @default(0)\n  no_of_attempts         Int              @default(0)\n  status                 Status           @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at             DateTime         @default(now()) @map(\"created_at\") @db.Timestamptz\n  created_by             Int?\n  sent_at                DateTime?        @map(\"sent_at\") @db.Timestamptz\n  read_at                DateTime?        @map(\"read_at\") @db.Timestamptz\n  created                User?            @relation(\"CreatedNotificationJob\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n\n  @@map(\"notification_jobs\")\n}\n\nmodel CarouselTemplate {\n  id          Int       @id @default(autoincrement())\n  uuid        String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name        String    @db.VarChar(100)\n  slug        String    @db.VarChar(100)\n  description String?   @db.VarChar(100)\n  status_id   Int       @default(1)\n  status      Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id  Int\n  created_by  Int?\n  created_at  DateTime  @default(now()) @db.Timestamptz\n  updated_by  Int?\n  updated_at  DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by  Int?\n  deleted_at  DateTime? @db.Timestamptz\n\n  created    User?                      @relation(\"CreatedCarouselTemplate\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated    User?                      @relation(\"UpdatedCarouselTemplate\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted    User?                      @relation(\"DeletedCarouselTemplate\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n  line_items CarouselTemplateLineItem[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"carousel_templates\")\n}\n\nmodel CarouselTemplateLineItem {\n  id                   Int     @id @default(autoincrement())\n  carousel_template_id Int\n  name                 String  @db.Text\n  slug                 String  @db.VarChar(100)\n  description          String? @db.Text\n  image_url            String? @db.Text\n  video_url            String? @db.Text\n  clickable_link       String? @db.Text\n  order_no             Decimal @default(0) @db.Decimal(4, 2)\n\n  status_id  Int      @default(1)\n  status     Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id Int\n  created_at DateTime @default(now()) @db.Timestamptz\n\n  carousel_template CarouselTemplate @relation(fields: [company_id, carousel_template_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, carousel_template_id, slug])\n  @@map(\"carousel_template_line_items\")\n}\n\nmodel ImportTemplate {\n  id                  Int       @id @default(autoincrement())\n  uuid                String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name                String    @db.VarChar(100)\n  slug                String    @db.VarChar(100)\n  description         String?   @db.VarChar(100)\n  max_row_count       Int       @default(500)\n  header_row          Int       @default(0)\n  data_start_row      Int       @default(0)\n  data_end_row        Int       @default(0)\n  ignore_error_rows   Boolean   @default(false)\n  is_admin_module     Boolean   @default(false)\n  is_send_mail        Boolean   @default(false)\n  email_process_slug  String?   @db.VarChar(255)\n  job_type            String?   @default(\"direct\")\n  batch_process_count Int?      @default(50)\n  status_id           Int       @default(1)\n  status              Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id          Int\n  created_by          Int?\n  created_at          DateTime  @default(now()) @db.Timestamptz\n  updated_by          Int?\n  updated_at          DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by          Int?\n  deleted_at          DateTime? @db.Timestamptz\n\n  created    User?                    @relation(\"CreatedImportTemplate\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated    User?                    @relation(\"UpdatedImportTemplate\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted    User?                    @relation(\"DeletedImportTemplate\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n  line_items ImportTemplateLineItem[]\n  queries    ImportTemplateQueries[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"import_templates\")\n}\n\nmodel ImportTemplateLineItem {\n  id                 Int      @id @default(autoincrement())\n  import_template_id Int\n  field_name         String   @db.VarChar(255)\n  display_name       String   @db.VarChar(100)\n  field_table        String   @db.VarChar(100)\n  order_no           Decimal  @default(0) @db.Decimal(4, 2)\n  width              Int?     @default(0)\n  default_value      String?  @db.VarChar(100)\n  check_reg_exp      String?  @db.VarChar(255)\n  is_nullable        Boolean  @default(true)\n  is_unique          Boolean  @default(false)\n  is_foreign         Boolean  @default(false)\n  unique_query       String?  @db.Text\n  foreign_query      String?  @db.Text\n  is_enum            Boolean  @default(false)\n  is_multiple        Boolean  @default(false)\n  enum_values        String?  @db.VarChar(100)\n  expression_rules   Json?    @db.JsonB\n  foreign_table      String?  @db.VarChar(100)\n  foreign_column     String?  @db.VarChar(100)\n  foreign_can_create Boolean  @default(false)\n  is_individual      Boolean  @default(false)\n  individual_column  String?  @db.VarChar(20)\n  field_type_id      Int?\n  status_id          Int      @default(1)\n  status             Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id         Int\n  created_at         DateTime @default(now()) @db.Timestamptz\n\n  import_template ImportTemplate @relation(fields: [company_id, import_template_id], references: [company_id, id], onDelete: Cascade)\n  field_type      FieldType?     @relation(fields: [company_id, field_type_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, import_template_id, field_table, field_name])\n  @@unique([company_id, import_template_id, display_name])\n  @@map(\"import_template_line_items\")\n}\n\nmodel ImportTemplateQueries {\n  id                 Int      @id @default(autoincrement())\n  import_template_id Int\n  query_string       String?  @db.Text\n  query_name         String   @db.VarChar(255)\n  allow_multiple     Boolean  @default(false)\n  is_individual      Boolean  @default(false)\n  before_lineitems   Boolean  @default(true)\n  order_no           Decimal  @default(0) @db.Decimal(4, 2)\n  status_id          Int      @default(1)\n  status             Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id         Int\n  created_at         DateTime @default(now()) @db.Timestamptz\n\n  import_template ImportTemplate @relation(fields: [company_id, import_template_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  //@@unique([company_id, import_template_id])\n  @@map(\"import_template_queries\")\n}\n\nmodel ImportJob {\n  id              Int     @id @default(autoincrement())\n  uuid            String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name            String  @db.VarChar(100)\n  description     String? @db.VarChar(100)\n  sequence_number String? @db.VarChar(255)\n\n  header_details Json? @db.JsonB\n  table_config   Json? @db.JsonB\n\n  total_rows            Int     @default(0)\n  completed_rows        Int     @default(0)\n  error_rows            Int     @default(0)\n  batch_process_count   Int?    @default(50) // Batch allocation for row object item process example: 50, 100 \n  //row_object     Json?   @db.JsonB\n  job_status            String? @default(\"created\") // created, in-progress, completed\n  last_processed_row_id Int?    @default(0)\n  file_path             String? @db.Text\n  file_name             String? @db.Text\n\n  status_id  Int       @default(1)\n  status     Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id Int\n  created_by Int?\n  created_at DateTime  @default(now()) @db.Timestamptz\n  updated_by Int?\n  updated_at DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by Int?\n  deleted_at DateTime? @db.Timestamptz\n\n  created User? @relation(\"CreatedImportJob\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated User? @relation(\"UpdatedImportJob\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted User? @relation(\"DeletedImportJob\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  line_items ImportJobLineItem[]\n\n  @@unique([company_id, id])\n  @@map(\"import_jobs\")\n}\n\nmodel ImportJobLineItem {\n  id            Int      @id @default(autoincrement())\n  import_job_id Int\n  row_object    Json?    @db.JsonB //990 [{id:\"\",insert_update_status:\"failure\",insert_update_status_message:\"this caused\"}]\n  //row_object_config    Json?    @db.JsonB\n  //row_object_validated Json?    @db.JsonB\n  job_status    String?  @default(\"created\") // created, processed\n  status_id     Int      @default(1)\n  status        Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id    Int\n  created_at    DateTime @default(now()) @db.Timestamptz\n\n  import_job ImportJob @relation(fields: [company_id, import_job_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@map(\"import_job_line_items\")\n}\n\nmodel ExportTemplate {\n  id             Int       @id @default(autoincrement())\n  uuid           String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name           String    @db.VarChar(100)\n  slug           String    @db.VarChar(100)\n  description    String?   @db.VarChar(100)\n  max_row_count  Int       @default(500)\n  header_row     Int       @default(0)\n  data_start_row Int       @default(0)\n  data_end_row   Int       @default(0)\n  data_filepath  String    @db.Text\n  status_id      Int       @default(1)\n  status         Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id     Int\n  created_by     Int?\n  created_at     DateTime  @default(now()) @db.Timestamptz\n  updated_by     Int?\n  updated_at     DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by     Int?\n  deleted_at     DateTime? @db.Timestamptz\n\n  created    User?                    @relation(\"CreatedExportTemplate\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated    User?                    @relation(\"UpdatedExportTemplate\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted    User?                    @relation(\"DeletedExportTemplate\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n  line_items ExportTemplateLineItem[]\n  queries    ExportTemplateQueries[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"export_templates\")\n}\n\nmodel ExportTemplateLineItem {\n  id                 Int     @id @default(autoincrement())\n  export_template_id Int\n  field_name         String  @db.VarChar(255)\n  display_name       String  @db.VarChar(100)\n  field_table        String  @db.VarChar(100)\n  order_no           Decimal @default(0) @db.Decimal(4, 2)\n\n  default_value String? @db.VarChar(100)\n  column_name   String? @db.VarChar(255)\n\n  is_individual     Boolean  @default(false)\n  individual_column String?  @db.VarChar(20)\n  field_type_id     Int?\n  status_id         Int      @default(1)\n  status            Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id        Int\n  created_at        DateTime @default(now()) @db.Timestamptz\n\n  export_template ExportTemplate @relation(fields: [company_id, export_template_id], references: [company_id, id], onDelete: Cascade)\n  field_type      FieldType?     @relation(fields: [company_id, field_type_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, export_template_id, field_table, field_name])\n  @@unique([company_id, export_template_id, display_name])\n  @@map(\"export_template_line_items\")\n}\n\nmodel ExportTemplateQueries {\n  id                 Int     @id @default(autoincrement())\n  export_template_id Int\n  query_string       String? @db.Text\n  query_name         String  @db.VarChar(255)\n\n  query_procedure String   @default(\"procedure\")\n  is_individual   Boolean  @default(false)\n  order_no        Decimal  @default(0) @db.Decimal(4, 2)\n  status_id       Int      @default(1)\n  status          Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id      Int\n  created_at      DateTime @default(now()) @db.Timestamptz\n\n  export_template ExportTemplate @relation(fields: [company_id, export_template_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  //@@unique([company_id, export_template_id])\n  @@map(\"export_template_queries\")\n}\n\nmodel Status {\n  id          Int     @id @default(autoincrement())\n  name        String  @db.VarChar(100)\n  slug        String  @db.VarChar(100)\n  description String? @db.Text\n  status_id   Int?    @default(1)\n\n  status                       Status?                     @relation(\"MyStatus\", fields: [status_id], references: [id], onDelete: Cascade)\n  status_list                  Status[]                    @relation(\"MyStatus\")\n  users                        User[]\n  request_logs                 RequestLog[]\n  permissions                  Permissions[]\n  roles                        Role[]\n  languages                    Language[]\n  language_contents            LanguageContent[]\n  menuitems                    MenuItems[]\n  menus                        Menus[]\n  master_grids                 MasterEntity[]\n  master_grid_line_items       MasterEntityLineItem[]\n  field_types                  FieldType[]\n  menu_types                   menuType[]\n  email_template_processes     EmailTemplateProcess[]\n  email_template_tags          EmailTemplateTag[]\n  email_template_receiver_tags EmailTemplateRecipientTag[]\n  email_templates              EmailTemplate[]\n  email_process_jobs           EmailProcessJob[]\n  notification_job             NotificationJob[]\n  import_templates             ImportTemplate[]\n  import_template_line_items   ImportTemplateLineItem[]\n  import_template_queries      ImportTemplateQueries[]\n\n  export_templates           ExportTemplate[]\n  export_template_line_items ExportTemplateLineItem[]\n  export_template_queries    ExportTemplateQueries[]\n\n  designations                        Designation[]\n  departments                         Department[]\n  audit_logs                          AuditLog[]\n  financial_years                     FinancialYear[]\n  document_sequences                  DocumentSequence[]\n  file_upload_logs                    FileUploadLog[]\n  device_registration                 DeviceRegistration[]\n  import_job                          ImportJob[]\n  import_job_line_items               ImportJobLineItem[]\n  policies                            Policies[]\n  app_versions                        Appversions[]\n  approval_workflows                  ApprovalWorkflow[]\n  approval_process_job_workflows      ApprovalProcessJobWorkflow[]\n  approval_workflow_approver_tags     ApprovalWorkflowApproverTag[]\n  approval_workflow_assignments       ApprovalWorkflowAssignment[]\n  approval_process_job                ApprovalProcessJob[]\n  approval_process_job_workflow_users ApprovalProcessJobWorkflowUser[]\n  delegations                         Delegation[]\n  about_lcp                           AboutLCP[]\n  schema_chunks                       SchemaChunk[]\n  openai_usage_logs                   OpenaiUsageLog[]\n  embedding_vector_logs               EmbeddingVectorLogs[]\n  query_execution_log                 QueryExecutionLog[]\n\n  child_processes              ChildProcess[]\n  child_process_logs           ChildProcessLog[]\n  carousel_templates           CarouselTemplate[]\n  carousel_template_line_items CarouselTemplateLineItem[]\n  scheduled_job_logs           ScheduledJobLogs[]\n  scheduled_jobs               ScheduledJob[]\n\n  whatsapp_template_process       WhatsappTemplateProcess[]\n  whatsapp_template_tag           WhatsappTemplateTag[]\n  whatsapp_template_recipient_tag WhatsappTemplateRecipientTag[]\n  whatsapp_template               WhatsappTemplate[]\n  whatsapp_process_jobs           WhatsappProcessJob[]\n  app_categories                  Categories[]\n\n  organizations Organizations[]\n\n  @@unique([id])\n  @@unique([slug])\n  @@map(\"statuses\")\n}\n\nmodel CategoryTypes {\n  id               Int     @id @default(autoincrement())\n  uuid             String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  category_type_id String  @unique @db.VarChar(10)\n  name             String  @db.VarChar(100)\n  description      String? @db.VarChar(255)\n\n  company_id Int\n  created_by Int?\n  updated_by Int?\n  deleted_by Int?\n  created_at DateTime  @default(now()) @db.Timestamptz\n  updated_at DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at DateTime? @db.Timestamptz\n\n  // relationships\n\n  created_category_types User? @relation(\"CreatedCategoryTypes\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated_category_types User? @relation(\"UpdatedCategoryTypes\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted_category_types User? @relation(\"DeletedCategoryTypes\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  categories Categories[]\n\n  @@unique([company_id, category_type_id])\n  @@unique([company_id, id])\n  @@unique([company_id, name])\n  @@map(\"app_category_types\")\n}\n\nmodel Categories {\n  id               Int     @id @default(autoincrement())\n  uuid             String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  category_type_id String  @db.VarChar(10)\n  category_id      String  @unique @db.VarChar(255)\n  parent_id        String? @db.VarChar(10)\n  name             String  @db.VarChar(100)\n  description      String? @db.VarChar(255)\n  status_id        Int     @default(1)\n  status           Status  @relation(fields: [status_id], references: [id], onDelete: Cascade)\n\n  company_id Int\n  created_by Int?\n  updated_by Int?\n  deleted_by Int?\n  created_at DateTime  @default(now()) @db.Timestamptz\n  updated_at DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at DateTime? @db.Timestamptz\n\n  // Self-referencing relation using cat_id\n  parent             Categories?   @relation(\"SubCategories\", fields: [parent_id], references: [category_id])\n  subcategories      Categories[]  @relation(\"SubCategories\")\n  // relationships\n  category_type      CategoryTypes @relation(fields: [category_type_id, company_id], references: [category_type_id, company_id])\n  created_categories User?         @relation(\"CreatedCategories\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated_categories User?         @relation(\"UpdatedCategories\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted_categories User?         @relation(\"DeletedCategories\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  configurations      Configurations[]\n  user_configurations UserConfigurations[]\n\n  @@unique([company_id, category_id])\n  @@unique([company_id, id])\n  @@unique([company_id, category_id, name])\n  @@map(\"app_categories\")\n}\n\nmodel Configurations {\n  id                 Int     @id @default(autoincrement())\n  uuid               String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  order_no           Decimal @default(0) @db.Decimal(4, 2)\n  config_key         String  @db.VarChar(100)\n  category_id        String  @db.VarChar(255)\n  config_value       String? @db.VarChar(255)\n  config_select_json Json?   @db.JsonB\n  config_file_value  String? @db.Text\n  config_value_type  String  @db.VarChar(100)\n  config_field_type  String  @db.VarChar(100)\n  display_config     Boolean @default(true)\n\n  company_id Int\n  created_by Int?\n  updated_by Int?\n  deleted_by Int?\n  created_at DateTime  @default(now()) @db.Timestamptz\n  updated_at DateTime? @default(now()) @updatedAt @db.Timestamptz\n  deleted_at DateTime? @db.Timestamptz\n\n  // relationships\n  category Categories @relation(fields: [category_id, company_id], references: [category_id, company_id])\n\n  created_configurations User? @relation(\"CreatedConfigurations\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated_configurations User? @relation(\"UpdatedConfigurations\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted_configurations User? @relation(\"DeletedConfigurations\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, config_key])\n  @@map(\"app_configurations\")\n}\n\nmodel UserConfigurations {\n  id                 Int     @id @default(autoincrement())\n  uuid               String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  order_no           Decimal @default(0) @db.Decimal(4, 2)\n  config_key         String  @db.VarChar(100)\n  category_id        String  @db.VarChar(255)\n  config_value       String? @db.VarChar(255)\n  config_select_json Json?   @db.JsonB\n  config_file_value  String? @db.Text\n  config_value_type  String  @db.VarChar(100)\n  config_field_type  String  @db.VarChar(100)\n  display_config     Boolean @default(true)\n  user_id            Int\n\n  company_id Int\n  created_by Int?\n  updated_by Int?\n  deleted_by Int?\n  created_at DateTime  @default(now()) @db.Timestamptz\n  updated_at DateTime? @default(now()) @updatedAt @db.Timestamptz\n  deleted_at DateTime? @db.Timestamptz\n\n  // relationships\n  category Categories @relation(fields: [category_id, company_id], references: [category_id, company_id])\n\n  created_user_configurations User? @relation(\"CreatedUserConfigurations\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated_user_configurations User? @relation(\"UpdatedUserConfigurations\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted_user_configurations User? @relation(\"DeletedUserConfigurations\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, config_key, user_id])\n  @@map(\"app_user_configurations\")\n}\n\nmodel FileUploadLog {\n  id          Int      @id @default(autoincrement())\n  uuid        String   @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  doc_name    String?  @db.VarChar(255)\n  org_name    String?  @db.VarChar(255)\n  extension   String?  @db.VarChar(100)\n  description String?  @db.VarChar(100)\n  status_id   Int      @default(1)\n  status      Status   @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id  Int\n  created_at  DateTime @default(now()) @db.Timestamptz\n\n  @@unique([company_id, id])\n  @@map(\"file_upload_logs\")\n}\n\nmodel DataTransferQueries {\n  id                      Int       @id @default(autoincrement())\n  uuid                    String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  select_query            String\n  insert_query            String\n  transfer_type           String\n  job_name                String\n  destination_table       String\n  clear_destination_table Boolean\n  execution_order         Int\n  command_type            String\n  status_id               Int       @default(1)\n  created_by              Int?\n  created_at              DateTime? @default(now())\n\n  company_id Int\n\n  @@unique([company_id, id])\n  @@map(\"data_transfer_queries\")\n}\n\nmodel DeviceRegistration {\n  id               Int       @id @default(autoincrement())\n  uuid             String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  company_id       Int\n  device_name      String    @db.VarChar(255)\n  device_unique_id String    @db.VarChar(255)\n  user_id          Int\n  status           Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  status_id        Int       @default(1)\n  created_by       Int\n  created_at       DateTime  @default(now()) @db.Timestamptz\n  updated_by       Int?\n  updated_at       DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by       Int?\n  deleted_at       DateTime? @db.Timestamptz\n\n  created_device_registration User  @relation(\"CreatedDeviceRegistration\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated_device_registration User? @relation(\"UpdatedDeviceRegistration\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted_device_registration User? @relation(\"DeletedDeviceRegistration\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  user User @relation(fields: [company_id, user_id], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@map(\"device_registration\")\n}\n\nmodel Policies {\n  id                Int       @id @default(autoincrement())\n  uuid              String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  company_id        Int\n  slug              String    @db.VarChar(225)\n  name              String    @db.VarChar(255)\n  description       String    @db.Text\n  query_information Json?     @db.JsonB\n  status            Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  status_id         Int       @default(1)\n  created_by        Int\n  created_at        DateTime  @default(now()) @db.Timestamptz\n  updated_by        Int?\n  updated_at        DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by        Int?\n  deleted_at        DateTime? @db.Timestamptz\n\n  user_policy    UserPolicies[]\n  role_policy    RolePolicies[]\n  created_policy User           @relation(\"CreatedPolicy\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated_policy User?          @relation(\"UpdatedPolicy\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted_policy User?          @relation(\"DeletedPolicy\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, name])\n  @@unique([company_id, slug])\n  @@map(\"policies\")\n}\n\nmodel UserPolicies {\n  company_id Int\n  policy     Policies @relation(fields: [company_id, policy_id], references: [company_id, id], onDelete: Cascade)\n  policy_id  Int\n  user       User     @relation(fields: [company_id, user_id], references: [company_id, id], onDelete: Cascade)\n  user_id    Int\n\n  @@unique([company_id, policy_id, user_id])\n  @@map(\"user_policies\")\n}\n\nmodel RolePolicies {\n  company_id Int\n  policy     Policies @relation(fields: [company_id, policy_id], references: [company_id, id], onDelete: Cascade)\n  policy_id  Int\n  role       Role     @relation(fields: [company_id, role_id], references: [company_id, id], onDelete: Cascade)\n  role_id    Int\n\n  @@unique([company_id, policy_id, role_id])\n  @@map(\"role_policies\")\n}\n\nmodel Appversions {\n  id                  Int       @id @default(autoincrement())\n  uuid                String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  company_id          Int\n  type                String    @db.VarChar(50)\n  version_type        String    @db.VarChar(225)\n  version             String    @db.VarChar(255)\n  description         String    @db.Text\n  is_frontend_changed Boolean   @default(false)\n  is_backend_changed  Boolean   @default(false)\n  is_database_changed Boolean   @default(false)\n  developed_by        String?   @db.VarChar(255)\n  status              Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  status_id           Int       @default(1)\n  created_by          Int\n  created_at          DateTime  @default(now()) @db.Timestamptz\n  updated_by          Int?\n  updated_at          DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by          Int?\n  deleted_at          DateTime? @db.Timestamptz\n\n  created_app_versions User  @relation(\"Created_app_versions\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated_app_versions User? @relation(\"Updated_app_versions\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted_app_versions User? @relation(\"Deleted_app_versions\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@map(\"app_versions\")\n}\n\nmodel ScheduledJob {\n  id              Int     @id @default(autoincrement())\n  uuid            String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  timing          String  @default(\"* * * * *\") @db.VarChar(100)\n  cron_url        String? @db.Text\n  concat_base_url Boolean @default(true)\n  description     String?\n\n  created_at DateTime @default(now()) @db.Timestamptz\n  company_id Int      @default(1)\n  status_id  Int      @default(1)\n\n  status Status @relation(fields: [status_id], references: [id], onDelete: Cascade)\n\n  scheduled_job_logs ScheduledJobLogs[]\n\n  @@map(\"scheduled_jobs\")\n}\n\nmodel ScheduledJobLogs {\n  id                 Int      @id @default(autoincrement())\n  uuid               String   @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  scheduled_job_id   Int\n  executed_statement String?\n  schedule_status    String?\n  response           String?  @db.Text\n  created_at         DateTime @default(now()) @db.Timestamptz\n  company_id         Int      @default(1)\n  status_id          Int      @default(1)\n\n  status Status @relation(fields: [status_id], references: [id], onDelete: Cascade)\n\n  scheduled_job ScheduledJob @relation(fields: [scheduled_job_id], references: [id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@map(\"scheduled_job_logs\")\n}\n\nmodel ApprovalWorkflow {\n  id                Int       @id @default(autoincrement())\n  uuid              String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name              String    @db.VarChar(100)\n  description       String?   @db.Text\n  slug              String    @db.VarChar(100)\n  query_information String?   @db.Text\n  status_id         Int       @default(1)\n  url               String?   @db.Text\n  status            Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id        Int\n  created_by        Int\n  created_at        DateTime  @default(now()) @db.Timestamptz\n  updated_by        Int?\n  updated_at        DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by        Int?\n  deleted_at        DateTime? @db.Timestamptz\n\n  approval_workflow_assignments ApprovalWorkflowAssignment[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"approval_workflows\")\n}\n\nmodel ApprovalWorkflowApproverTag {\n  id                Int       @id @default(autoincrement())\n  uuid              String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  slug              String    @db.VarChar(100)\n  name              String?   @db.VarChar(100)\n  description       String?   @db.Text\n  query_information String?   @db.Text\n  status_id         Int       @default(1)\n  status            Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id        Int\n  created_by        Int\n  created_at        DateTime  @default(now()) @db.Timestamptz\n  updated_by        Int?\n  updated_at        DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by        Int?\n  deleted_at        DateTime? @db.Timestamptz\n\n  @@unique([company_id, id])\n  @@unique([company_id, slug])\n  @@map(\"approval_workflow_approver_tags\")\n}\n\nmodel ApprovalWorkflowAssignment {\n  id                        Int              @id @default(autoincrement())\n  uuid                      String           @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  approval_workflow_id      Int\n  approval_workflow         ApprovalWorkflow @relation(fields: [company_id, approval_workflow_id], references: [company_id, id], onDelete: Cascade)\n  approver_order_no         Decimal          @default(0) @db.Decimal(4, 2)\n  approver_type             ApproverType     @default(tag)\n  approver                  String?          @db.VarChar(255) // comma separated values\n  approve_query_information String[]\n  reject_query_information  String[]\n  status_id                 Int              @default(1)\n  status                    Status           @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id                Int\n  created_by                Int\n  created_at                DateTime         @default(now()) @db.Timestamptz\n  updated_by                Int?\n  updated_at                DateTime         @default(now()) @updatedAt @db.Timestamptz\n  deleted_by                Int?\n  deleted_at                DateTime?        @db.Timestamptz\n\n  approve_mail_id Int?\n  approve_mail    EmailTemplate? @relation(\"ApproveAssignmentMail\", fields: [approve_mail_id], references: [id], onDelete: Cascade, map: \"approve_mail_fkey\")\n  reject_mail_id  Int?\n  reject_mail     EmailTemplate? @relation(\"RejectAssignmentMail\", fields: [reject_mail_id], references: [id], onDelete: Cascade, map: \"reject_mail_fkey\")\n\n  approve_whatsapp_id Int?\n  approve_whatsapp    WhatsappTemplate? @relation(\"ApproveAssignmentWhatsapp\", fields: [approve_whatsapp_id], references: [id], onDelete: Cascade, map: \"approve_whatsapp_fkey\")\n  reject_whatsapp_id  Int?\n  reject_whatsapp     WhatsappTemplate? @relation(\"RejectAssignmentWhatsapp\", fields: [reject_whatsapp_id], references: [id], onDelete: Cascade, map: \"reject_whatsapp_fkey\")\n\n  // approval_process_job_workflows ApprovalProcessJobWorkflow[]\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, approval_workflow_id, approver_order_no])\n  @@map(\"approval_workflow_assignments\")\n}\n\nmodel ApprovalProcessJob {\n  id                     Int     @id @default(autoincrement())\n  uuid                   String  @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  approval_workflow_slug String  @db.VarChar(100)\n  sequence_no            String  @db.VarChar(100)\n  description            String? @db.VarChar(100)\n  primary_table          String? @db.VarChar(100)\n  unique_id              Int?\n  screen_id              String\n  user_id                Int?\n  prefill_data           String? @db.Text\n  details                String?\n  status_id              Int     @default(1)\n  status                 Status  @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id             Int\n\n  // approval_process_job_workflows ApprovalProcessJobWorkflow[]\n  @@unique([company_id, uuid])\n  @@unique([company_id, id])\n  @@map(\"approval_process_jobs\")\n}\n\nmodel ApprovalProcessJobWorkflow {\n  id                                  Int                              @id @default(autoincrement())\n  approval_workflow_assignment_id     Int\n  // approval_workflow_assignment    ApprovalWorkflowAssignment @relation(fields: [company_id, approval_workflow_assignment_id], references: [company_id, id])\n  approval_process_job_id             String\n  // approval_process_job            ApprovalProcessJob         @relation(fields: [company_id, approval_process_job_id], references: [company_id, id])\n  approval_workflow_slug              String                           @db.VarChar(100)\n  approval_process_job_name           String?                          @db.VarChar(100)\n  approval_process_job_description    String?                          @db.Text\n  approve_query_information           String[]\n  reject_query_information            String[]\n  primary_table                       String?                          @db.VarChar(100)\n  sequence_no                         String                           @db.VarChar(100)\n  unique_id                           Int?\n  user_id                             Int?\n  screen_id                           String\n  prefill_data                        String?                          @db.Text\n  url                                 String?                          @db.Text\n  approver_order_no                   Decimal                          @default(0) @db.Decimal(4, 2)\n  approver_type                       ApproverType                     @default(tag)\n  approver                            String?                          @db.VarChar(255) // comma separated values\n  review_status                       ApprovalStatus                   @default(pending)\n  status_id                           Int                              @default(1)\n  reviewed_by                         Int?\n  reason                              String?                          @db.Text\n  status                              Status                           @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  approve_mail_id                     Int?\n  reject_mail_id                      Int?\n  approve_whatsapp_id                 Int?\n  reject_whatsapp_id                  Int?\n  company_id                          Int\n  created_at                          DateTime                         @default(now()) @db.Timestamptz\n  assigned_at                         DateTime?                        @db.Timestamptz\n  processed_at                        DateTime?                        @db.Timestamptz\n  deleted_by                          Int?\n  deleted_at                          DateTime?                        @db.Timestamptz\n  details                             String?\n  approval_process_job_workflow_users ApprovalProcessJobWorkflowUser[]\n\n  @@unique([company_id, id])\n  @@map(\"approval_process_job_workflows\")\n}\n\nmodel ApprovalProcessJobWorkflowUser {\n  id                               Int                        @id @default(autoincrement())\n  uuid                             String                     @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  approval_process_job_workflow_id Int\n  approval_process_job_workflow    ApprovalProcessJobWorkflow @relation(fields: [company_id, approval_process_job_workflow_id], references: [company_id, id], onDelete: Cascade)\n  user_id                          Int?\n  status_id                        Int                        @default(1)\n  status                           Status                     @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id                       Int\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@map(\"approval_process_job_workflow_users\")\n}\n\nmodel Delegation {\n  id                Int       @id @default(autoincrement())\n  uuid              String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  user_id           Int\n  delegated_user_id Int\n  reason            String?\n  start_date        DateTime  @db.Timestamptz\n  end_date          DateTime  @db.Timestamptz\n  status_id         Int       @default(1)\n  status            Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id        Int\n  created_by        Int\n  created_at        DateTime  @default(now()) @db.Timestamptz\n  updated_by        Int?\n  updated_at        DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by        Int?\n  deleted_at        DateTime? @db.Timestamptz\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@map(\"delegations\")\n}\n\nmodel SchemaChunk {\n  id         Int                          @id @default(autoincrement())\n  uuid       String                       @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  table_name String                       @unique\n  chunk      String\n  embedding  Unsupported(\"vector(1536)\")?\n  status_id  Int                          @default(1)\n  status     Status                       @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at DateTime                     @default(now()) @db.Timestamptz\n  created_by Int\n  updated_by Int?\n  updated_at DateTime                     @default(now()) @updatedAt @db.Timestamptz\n  deleted_by Int?\n  deleted_at DateTime?                    @db.Timestamptz\n  company_id Int\n\n  @@map(\"schema_chunks\") // storing float[] as bytes\n}\n\nmodel EmbeddingVectorLogs {\n  id         Int       @id @default(autoincrement())\n  uuid       String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  user_id    Int?\n  cost       Decimal   @db.Decimal(10, 6)\n  company_id Int\n  table_name String\n  status_id  Int       @default(1)\n  status     Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at DateTime  @default(now()) @db.Timestamptz\n  created_by Int\n  updated_by Int?\n  updated_at DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by Int?\n  deleted_at DateTime? @db.Timestamptz\n\n  @@map(\"embedding_vector_logs\")\n}\n\nmodel OpenaiUsageLog {\n  id                Int       @id @default(autoincrement())\n  uuid              String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  user_id           Int?\n  prompt            String    @db.Text\n  generated_sql     String    @db.Text\n  prompt_tokens     Int\n  completion_tokens Int\n  total_tokens      Int\n  cost              Decimal   @db.Decimal(10, 6)\n  status_id         Int       @default(1)\n  company_id        Int\n  status            Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_at        DateTime  @default(now()) @db.Timestamptz\n  created_by        Int\n  updated_by        Int?\n  updated_at        DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by        Int?\n  deleted_at        DateTime? @db.Timestamptz\n\n  @@map(\"openai_usage_logs\")\n}\n\nmodel QueryExecutionLog {\n  id         Int       @id @default(autoincrement())\n  uuid       String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  company_id Int\n  status_id  Int       @default(1)\n  status     Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  query      String\n  created_at DateTime  @default(now()) @db.Timestamptz\n  created_by Int\n  updated_by Int?\n  updated_at DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by Int?\n  deleted_at DateTime? @db.Timestamptz\n\n  @@map(\"query_execution_logs\")\n}\n\nmodel ChildProcess {\n  id          Int       @id @default(autoincrement())\n  uuid        String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  name        String\n  slug        String    @db.VarChar(100)\n  description String?\n  command     String    @db.Text\n  status_id   Int       @default(1)\n  status      Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id  Int\n  created_by  Int\n  created_at  DateTime  @default(now()) @db.Timestamptz\n  updated_by  Int?\n  updated_at  DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by  Int?\n  deleted_at  DateTime? @db.Timestamptz\n\n  child_process_logs ChildProcessLog[] @relation(\"child_process\")\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, slug])\n  @@map(\"child_processes\")\n}\n\nmodel ChildProcessLog {\n  id               Int       @id @default(autoincrement())\n  uuid             String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  child_process_id Int\n  process_status   String?\n  output           String    @db.Text\n  initiated_by     Int\n  status_id        Int       @default(1)\n  status           Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  company_id       Int\n  created_by       Int\n  created_at       DateTime  @default(now()) @db.Timestamptz\n  updated_by       Int?\n  updated_at       DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_by       Int?\n  deleted_at       DateTime? @db.Timestamptz\n\n  child_process ChildProcess @relation(\"child_process\", fields: [company_id, child_process_id], references: [company_id, id], onDelete: Cascade)\n  initiator     User         @relation(\"Initiator\", fields: [company_id, initiated_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@map(\"child_process_logs\")\n}\n\nmodel Organizations {\n  id            Int       @id @default(autoincrement())\n  uuid          String    @default(dbgenerated(\"uuid_generate_v4()\")) @db.Uuid\n  company_id    Int\n  name          String\n  code          String    @db.VarChar(100)\n  description   String?   @db.Text\n  no_of_devices Int       @default(0)\n  status_id     Int       @default(1)\n  status        Status    @relation(fields: [status_id], references: [id], onDelete: Cascade)\n  created_by    Int?\n  updated_by    Int?\n  deleted_by    Int?\n  created_at    DateTime  @default(now()) @db.Timestamptz\n  updated_at    DateTime  @default(now()) @updatedAt @db.Timestamptz\n  deleted_at    DateTime? @db.Timestamptz\n\n  users UserDetail[] @relation(\"UserOrganization\")\n\n  created User? @relation(\"CreatedOrganization\", fields: [company_id, created_by], references: [company_id, id], onDelete: Cascade)\n  updated User? @relation(\"UpdatedOrganization\", fields: [company_id, updated_by], references: [company_id, id], onDelete: Cascade)\n  deleted User? @relation(\"DeletedOrganization\", fields: [company_id, deleted_by], references: [company_id, id], onDelete: Cascade)\n\n  @@unique([company_id, id])\n  @@unique([company_id, uuid])\n  @@unique([company_id, code])\n  @@map(\"organizations\")\n}\n",
  "inlineSchemaHash": "f0cf065c29c043178090a55ad9db013fc4f4803f94e463a9c18a655e1d64daef",
  "copyEngine": true
}

const fs = require('fs')

config.dirname = __dirname
if (!fs.existsSync(path.join(__dirname, 'schema.prisma'))) {
  const alternativePaths = [
    "node_modules/@prisma/pg/client",
    "@prisma/pg/client",
  ]
  
  const alternativePath = alternativePaths.find((altPath) => {
    return fs.existsSync(path.join(process.cwd(), altPath, 'schema.prisma'))
  }) ?? alternativePaths[0]

  config.dirname = path.join(process.cwd(), alternativePath)
  config.isBundled = true
}

config.runtimeDataModel = JSON.parse("{\"models\":{\"User\":{\"dbName\":\"users\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"username\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_verified\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"password\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"StatusToUser\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"role\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"UserRole\",\"default\":\"user\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"process_status\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"ProcessStatus\",\"default\":\"submitted\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_drafted\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reason\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"last_login\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"last_login_device\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_detail\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserDetail\",\"relationName\":\"UserToUserDetail\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"request_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"RequestLog\",\"relationName\":\"RequestLogToUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"roles\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserRoles\",\"relationName\":\"UserToUserRoles\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permissions\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserPermissions\",\"relationName\":\"UserToUserPermissions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"otps\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Otp\",\"relationName\":\"OtpToUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedUser\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedUser\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedUser\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_user_details\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserDetail\",\"relationName\":\"CreatedUserDetail\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_user_details\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserDetail\",\"relationName\":\"UpdatedUserDetail\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_user_details\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserDetail\",\"relationName\":\"DeletedUserDetail\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_roles\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Role\",\"relationName\":\"CreatedRole\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_roles\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Role\",\"relationName\":\"UpdatedRole\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_roles\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Role\",\"relationName\":\"DeletedRole\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_languages\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Language\",\"relationName\":\"CreatedLanguage\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_languages\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Language\",\"relationName\":\"UpdatedLanguage\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_languages\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Language\",\"relationName\":\"DeletedLanguage\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_menus\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Menus\",\"relationName\":\"CreatedMenus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_menus\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Menus\",\"relationName\":\"UpdatedMenus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_menus\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Menus\",\"relationName\":\"DeletedMenus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_menu_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"CreatedMenuItems\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_menu_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"UpdatedMenuItems\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_menu_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"DeletedMenuItems\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_email_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplate\",\"relationName\":\"CreatedEmailTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_email_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplate\",\"relationName\":\"UpdatedEmailTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_email_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplate\",\"relationName\":\"DeletedEmailTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_email_template_assignments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateAssignment\",\"relationName\":\"CreatedEmailTemplateAssignment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_email_process_jobs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailProcessJob\",\"relationName\":\"CreatedEmailProcessJob\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_whatsapp_process_jobs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappProcessJob\",\"relationName\":\"CreatedWhatsappProcessJob\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_notification_job\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"NotificationJob\",\"relationName\":\"CreatedNotificationJob\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_import_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplate\",\"relationName\":\"CreatedImportTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_import_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplate\",\"relationName\":\"UpdatedImportTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_import_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplate\",\"relationName\":\"DeletedImportTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_carousel_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CarouselTemplate\",\"relationName\":\"CreatedCarouselTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_carousel_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CarouselTemplate\",\"relationName\":\"UpdatedCarouselTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_carousel_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CarouselTemplate\",\"relationName\":\"DeletedCarouselTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_whatsapp_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplate\",\"relationName\":\"CreatedWhatsappTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_whatsapp_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplate\",\"relationName\":\"UpdatedWhatsappTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_whatsapp_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplate\",\"relationName\":\"DeletedWhatsappTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_assignment\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateAssignment\",\"relationName\":\"CreatedwhatsappTemplateAssignment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_export_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplate\",\"relationName\":\"CreatedExportTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_export_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplate\",\"relationName\":\"UpdatedExportTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_export_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplate\",\"relationName\":\"DeletedExportTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_departments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Department\",\"relationName\":\"CreatedDepartment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"head_departments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Department\",\"relationName\":\"DepartmentHead\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_departments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Department\",\"relationName\":\"UpdatedDepartment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_departments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Department\",\"relationName\":\"DeletedDepartment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_designations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Designation\",\"relationName\":\"CreatedDesignation\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_designations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Designation\",\"relationName\":\"UpdatedDesignation\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_designations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Designation\",\"relationName\":\"DeletedDesignation\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"audit_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"AuditLog\",\"relationName\":\"AuditLogToUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_category_types\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CategoryTypes\",\"relationName\":\"CreatedCategoryTypes\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_category_types\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CategoryTypes\",\"relationName\":\"UpdatedCategoryTypes\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_category_types\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CategoryTypes\",\"relationName\":\"DeletedCategoryTypes\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_categories\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"CreatedCategories\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_categories\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"UpdatedCategories\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_categories\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"DeletedCategories\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_configurations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Configurations\",\"relationName\":\"CreatedConfigurations\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_configurations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Configurations\",\"relationName\":\"UpdatedConfigurations\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_configurations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Configurations\",\"relationName\":\"DeletedConfigurations\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_user_configurations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserConfigurations\",\"relationName\":\"CreatedUserConfigurations\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_user_configurations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserConfigurations\",\"relationName\":\"UpdatedUserConfigurations\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_user_configurations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserConfigurations\",\"relationName\":\"DeletedUserConfigurations\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_fin_years\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FinancialYear\",\"relationName\":\"CreatedFinYear\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_fin_years\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FinancialYear\",\"relationName\":\"UpdatedFinYear\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_fin_years\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FinancialYear\",\"relationName\":\"DeletedFinYear\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_doc_sequences\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DocumentSequence\",\"relationName\":\"CreatedDocumentSequence\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_doc_sequences\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DocumentSequence\",\"relationName\":\"UpdatedDocumentSequence\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_doc_sequences\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DocumentSequence\",\"relationName\":\"DeletedDocumentSequence\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_device_registration\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DeviceRegistration\",\"relationName\":\"CreatedDeviceRegistration\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_device_registration\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DeviceRegistration\",\"relationName\":\"UpdatedDeviceRegistration\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_device_registration\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DeviceRegistration\",\"relationName\":\"DeletedDeviceRegistration\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"DeviceRegistration\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DeviceRegistration\",\"relationName\":\"DeviceRegistrationToUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_import_job\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportJob\",\"relationName\":\"CreatedImportJob\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_import_job\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportJob\",\"relationName\":\"UpdatedImportJob\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_import_job\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportJob\",\"relationName\":\"DeletedImportJob\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_organizations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Organizations\",\"relationName\":\"CreatedOrganization\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_organizations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Organizations\",\"relationName\":\"UpdatedOrganization\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_organizations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Organizations\",\"relationName\":\"DeletedOrganization\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_policy\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserPolicies\",\"relationName\":\"UserToUserPolicies\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_policy\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Policies\",\"relationName\":\"CreatedPolicy\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_policy\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Policies\",\"relationName\":\"UpdatedPolicy\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_policy\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Policies\",\"relationName\":\"DeletedPolicy\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_app_versions\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Appversions\",\"relationName\":\"Created_app_versions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_app_versions\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Appversions\",\"relationName\":\"Updated_app_versions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_app_versions\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Appversions\",\"relationName\":\"Deleted_app_versions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"ChildProcessLog\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ChildProcessLog\",\"relationName\":\"Initiator\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"uuid\"],[\"company_id\",\"email\",\"role\"],[\"company_id\",\"username\"],[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"email\",\"role\"]},{\"name\":null,\"fields\":[\"company_id\",\"username\"]},{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"UserDetail\":{\"dbName\":\"user_details\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"first_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"last_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"designation_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"department_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"organization_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"profile_pic\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"dob\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"country_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"phone_number\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"gender\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Gender\",\"default\":\"male\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_time_zone\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"address\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"culture\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"designation\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Designation\",\"relationName\":\"UserDesignation\",\"relationFromFields\":[\"company_id\",\"designation_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"department\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Department\",\"relationName\":\"UserDepartment\",\"relationFromFields\":[\"company_id\",\"department_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"organizations\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Organizations\",\"relationName\":\"UserOrganization\",\"relationFromFields\":[\"company_id\",\"organization_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UserToUserDetail\",\"relationFromFields\":[\"company_id\",\"user_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedUserDetail\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedUserDetail\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedUserDetail\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"user_id\"],[\"company_id\",\"code\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"user_id\"]},{\"name\":null,\"fields\":[\"company_id\",\"code\"]}],\"isGenerated\":false},\"Designation\":{\"dbName\":\"designations\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"DesignationToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserDetail\",\"relationName\":\"UserDesignation\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedDesignation\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedDesignation\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedDesignation\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"code\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"code\"]}],\"isGenerated\":false},\"Department\":{\"dbName\":\"departments\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"DepartmentToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"department_head_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserDetail\",\"relationName\":\"UserDepartment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"department_head\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DepartmentHead\",\"relationFromFields\":[\"company_id\",\"department_head_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedDepartment\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedDepartment\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedDepartment\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"code\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"code\"]}],\"isGenerated\":false},\"RequestLog\":{\"dbName\":\"request_logs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"BigInt\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"req_method\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"req_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"req_body\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"res_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"res_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":500,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"res_message\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"req_response\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"req_headers\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"req_ip\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"req_device\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"RequestLogToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"RequestLogToUser\",\"relationFromFields\":[\"company_id\",\"user_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"FinancialYear\":{\"dbName\":\"financial_years\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_freezed\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"start_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"end_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"FinancialYearToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"document_sequence\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DocumentSequence\",\"relationName\":\"DocumentSequenceFinancialYear\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedFinYear\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedFinYear\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedFinYear\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"code\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"code\"]}],\"isGenerated\":false},\"DocumentSequence\":{\"dbName\":\"document_sequences\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"module_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"financial_year_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"current_sequence_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"start_sequence_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"end_sequence_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"sequence_length\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":9,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"code_format\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"DocumentSequenceToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"finanicial_year\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FinancialYear\",\"relationName\":\"DocumentSequenceFinancialYear\",\"relationFromFields\":[\"company_id\",\"financial_year_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedDocumentSequence\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedDocumentSequence\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedDocumentSequence\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"financial_year_id\",\"module_name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"financial_year_id\",\"module_name\"]}],\"isGenerated\":false},\"AuditLog\":{\"dbName\":\"audit_logs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"operation_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"table_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"old_value\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"new_value\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"entity_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"AuditLogToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"AuditLogToUser\",\"relationFromFields\":[\"user_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"Permissions\":{\"dbName\":\"permissions\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"entity_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"PermissionsToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"entity\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MasterEntity\",\"relationName\":\"MasterEntityToPermissions\",\"relationFromFields\":[\"company_id\",\"entity_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"roles\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"RolePermissions\",\"relationName\":\"PermissionsToRolePermissions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserPermissions\",\"relationName\":\"PermissionsToUserPermissions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menus\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"MenuItemsToPermissions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"slug\"],[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"slug\"]},{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"Role\":{\"dbName\":\"roles\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"RoleToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permissions\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"RolePermissions\",\"relationName\":\"RoleToRolePermissions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserRoles\",\"relationName\":\"RoleToUserRoles\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"role_policy\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"RolePolicies\",\"relationName\":\"RoleToRolePolicies\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedRole\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedRole\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedRole\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"name\"]}],\"isGenerated\":false},\"RolePermissions\":{\"dbName\":\"role_permissions\",\"fields\":[{\"name\":\"role\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Role\",\"relationName\":\"RoleToRolePermissions\",\"relationFromFields\":[\"company_id\",\"role_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"role_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permission\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Permissions\",\"relationName\":\"PermissionsToRolePermissions\",\"relationFromFields\":[\"company_id\",\"permission_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permission_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":{\"name\":null,\"fields\":[\"company_id\",\"role_id\",\"permission_id\"]},\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"UserRoles\":{\"dbName\":\"user_roles\",\"fields\":[{\"name\":\"user\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UserToUserRoles\",\"relationFromFields\":[\"company_id\",\"user_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"role\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Role\",\"relationName\":\"RoleToUserRoles\",\"relationFromFields\":[\"company_id\",\"role_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"role_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":{\"name\":null,\"fields\":[\"company_id\",\"user_id\",\"role_id\"]},\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"UserPermissions\":{\"dbName\":\"user_permissions\",\"fields\":[{\"name\":\"user\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UserToUserPermissions\",\"relationFromFields\":[\"company_id\",\"user_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permission\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Permissions\",\"relationName\":\"PermissionsToUserPermissions\",\"relationFromFields\":[\"company_id\",\"permission_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permission_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":{\"name\":null,\"fields\":[\"company_id\",\"user_id\",\"permission_id\"]},\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"Otp\":{\"dbName\":\"otps\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"otp\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"purpose\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"OtpPurpose\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"OtpToUser\",\"relationFromFields\":[\"company_id\",\"user_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"Language\":{\"dbName\":\"languages\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name_in_english\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"flag\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"rtl\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"LanguageToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"translations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"LanguageContent\",\"relationName\":\"LanguageTrans\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedLanguage\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedLanguage\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedLanguage\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"code\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"code\"]}],\"isGenerated\":false},\"LanguageContent\":{\"dbName\":\"language_contents\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"language_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"key_content\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"values\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"LanguageContentToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"language\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Language\",\"relationName\":\"LanguageTrans\",\"relationFromFields\":[\"company_id\",\"language_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"Menus\":{\"dbName\":\"menu\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menu_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"MenusToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menuitems\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"MenuItemsToMenus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedMenus\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedMenus\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedMenus\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]}],\"isGenerated\":false},\"MenuItems\":{\"dbName\":\"menu_items\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menu_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"target\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"parent_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permission_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"entity_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"link_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menu_img\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"short_cut_keys\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"MenuItemsToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menus\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Menus\",\"relationName\":\"MenuItemsToMenus\",\"relationFromFields\":[\"company_id\",\"menu_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"entity\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MasterEntity\",\"relationName\":\"MasterEntityToMenuItems\",\"relationFromFields\":[\"company_id\",\"entity_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permission\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Permissions\",\"relationName\":\"MenuItemsToPermissions\",\"relationFromFields\":[\"company_id\",\"permission_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"parent\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"ChildMenuItemss\",\"relationFromFields\":[\"company_id\",\"parent_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"children\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"ChildMenuItemss\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedMenuItems\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedMenuItems\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedMenuItems\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"menu_id\",\"name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"menu_id\",\"name\"]}],\"isGenerated\":false},\"ActionType\":{\"dbName\":\"action_types\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"EntityType\":{\"dbName\":\"entity_types\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"WizardGroup\":{\"dbName\":\"wizard_group\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"WizardType\":{\"dbName\":\"wizard_types\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"name\"]}],\"isGenerated\":false},\"AboutLCP\":{\"dbName\":\"about_lcp\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"aboutType\",\"default\":\"lcp\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"documentation_video_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"documentation_pdf\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"documentation_word\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"AboutLCPToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"MasterEntity\":{\"dbName\":\"master_entities\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"entity_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"entity_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"report_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"ReportType\",\"default\":\"lcp\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"primary_table\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_admin_module\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"draft_mode\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"associated_tables\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"form_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"report_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"add_query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"edit_query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"preset_query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"static_page_content\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"export_template_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"dashboard_wizard_group_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"dashboard_wizard_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"dashboard_wizard_rows\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"dashboard_wizard_columns\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"dashboard_wizard_order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"dashboard_wizard_options\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"MasterEntityToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permissions\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Permissions\",\"relationName\":\"MasterEntityToPermissions\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MasterEntityLineItem\",\"relationName\":\"MasterEntityToMasterEntityLineItem\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menus\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"MasterEntityToMenuItems\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"entity_name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"entity_name\"]}],\"isGenerated\":false},\"MasterEntityLineItem\":{\"dbName\":\"master_entity_line_items\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"master_grid_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"display_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_grid_column\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":true,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_searchable\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":true,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"clause_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"ClauseType\",\"default\":\"where\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_sortable\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":true,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_type_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"link_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":\"none\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"link_action\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"link_mode\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":\"none\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"MasterEntityLineItemToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"master_grid\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MasterEntity\",\"relationName\":\"MasterEntityToMasterEntityLineItem\",\"relationFromFields\":[\"company_id\",\"master_grid_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_type\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FieldType\",\"relationName\":\"FieldTypeToMasterEntityLineItem\",\"relationFromFields\":[\"company_id\",\"field_type_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"master_grid_id\",\"field_name\",\"display_name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"master_grid_id\",\"field_name\",\"display_name\"]}],\"isGenerated\":false},\"FieldType\":{\"dbName\":\"field_types\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"FieldTypeToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"master_grid_lineitem\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MasterEntityLineItem\",\"relationName\":\"FieldTypeToMasterEntityLineItem\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"importTemplateLineItem\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplateLineItem\",\"relationName\":\"FieldTypeToImportTemplateLineItem\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"exportTemplateLineItem\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplateLineItem\",\"relationName\":\"ExportTemplateLineItemToFieldType\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"menuType\":{\"dbName\":\"menu_types\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"StatusTomenuType\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"EmailTemplateProcess\":{\"dbName\":\"email_template_process\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"EmailTemplateProcessToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_groups\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateProcessTagsMapping\",\"relationName\":\"EmailTemplateProcessToEmailTemplateProcessTagsMapping\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplate\",\"relationName\":\"EmailTemplateToEmailTemplateProcess\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_assignments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateAssignment\",\"relationName\":\"EmailTemplateAssignmentToEmailTemplateProcess\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"],[\"id\",\"company_id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]},{\"name\":null,\"fields\":[\"id\",\"company_id\"]}],\"isGenerated\":false},\"EmailTemplateTag\":{\"dbName\":\"email_template_tags\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"EmailTemplateTagToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_groups\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateProcessTagsMapping\",\"relationName\":\"EmailTemplateProcessTagsMappingToEmailTemplateTag\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"EmailTemplateRecipientTag\":{\"dbName\":\"email_template_recipient_tags\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"EmailTemplateRecipientTagToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"EmailTemplateProcessTagsMapping\":{\"dbName\":\"email_template_process_tags_mapping\",\"fields\":[{\"name\":\"email_template_process_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_tag_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_process\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateProcess\",\"relationName\":\"EmailTemplateProcessToEmailTemplateProcessTagsMapping\",\"relationFromFields\":[\"email_template_process_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_tag\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateTag\",\"relationName\":\"EmailTemplateProcessTagsMappingToEmailTemplateTag\",\"relationFromFields\":[\"email_template_tag_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":{\"name\":null,\"fields\":[\"email_template_process_id\",\"email_template_tag_id\",\"company_id\"]},\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"EmailTemplate\":{\"dbName\":\"email_templates\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"subject\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"template_body\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_process_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"EmailTemplateToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"dbName\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"dbName\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"dbName\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_process\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateProcess\",\"relationName\":\"EmailTemplateToEmailTemplateProcess\",\"relationFromFields\":[\"email_template_process_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_assignments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateAssignment\",\"relationName\":\"EmailTemplateAssignment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedEmailTemplate\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedEmailTemplate\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedEmailTemplate\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_assignments_approve\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflowAssignment\",\"relationName\":\"ApproveAssignmentMail\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_assignments_reject\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflowAssignment\",\"relationName\":\"RejectAssignmentMail\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"EmailTemplateAssignment\":{\"dbName\":\"email_template_assignments\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_process_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"template_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"recipient_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"RecipientType\",\"default\":\"tag\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_to\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"dbName\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_process\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateProcess\",\"relationName\":\"EmailTemplateAssignmentToEmailTemplateProcess\",\"relationFromFields\":[\"email_template_process_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplate\",\"relationName\":\"EmailTemplateAssignment\",\"relationFromFields\":[\"template_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedEmailTemplateAssignment\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_cc_bcc\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateCcBcc\",\"relationName\":\"EmailTemplateAssignmentToEmailTemplateCcBcc\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"id\"]}],\"isGenerated\":false},\"EmailTemplateCcBcc\":{\"dbName\":\"email_template_cc_bcc\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"send_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"sendMailType\",\"default\":\"cc\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"recipient_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"RecipientType\",\"default\":\"tag\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_to\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"dbName\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_assignment_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_assignment\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateAssignment\",\"relationName\":\"EmailTemplateAssignmentToEmailTemplateCcBcc\",\"relationFromFields\":[\"email_template_assignment_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"EmailProcessJob\":{\"dbName\":\"email_process_jobs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_process_slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"unique_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"prefill_data\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"attachments_path\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"attachments_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"EmailProcessJobToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"dbName\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedEmailProcessJob\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"WhatsappProcessJob\":{\"dbName\":\"whatsapp_process_jobs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_process_slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"unique_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"prefill_data\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"attachments_path\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"attachments_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"StatusToWhatsappProcessJob\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"dbName\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedWhatsappProcessJob\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"WhatsappTemplateProcess\":{\"dbName\":\"whatsapp_template_process\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"StatusToWhatsappTemplateProcess\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_groups\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateProcessTagsMapping\",\"relationName\":\"WhatsappTemplateProcessToWhatsappTemplateProcessTagsMapping\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplate\",\"relationName\":\"WhatsappTemplateToWhatsappTemplateProcess\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_assignments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateAssignment\",\"relationName\":\"WhatsappTemplateAssignmentToWhatsappTemplateProcess\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"],[\"id\",\"company_id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]},{\"name\":null,\"fields\":[\"id\",\"company_id\"]}],\"isGenerated\":false},\"WhatsappTemplateTag\":{\"dbName\":\"whatsapp_template_tags\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"StatusToWhatsappTemplateTag\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_groups\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateProcessTagsMapping\",\"relationName\":\"WhatsappTemplateProcessTagsMappingToWhatsappTemplateTag\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"WhatsappTemplateRecipientTag\":{\"dbName\":\"whatsapp_template_recipient_tags\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"StatusToWhatsappTemplateRecipientTag\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"WhatsappTemplateProcessTagsMapping\":{\"dbName\":\"whatsapp_template_process_tags_mapping\",\"fields\":[{\"name\":\"whatsapp_template_process_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_tag_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_process\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateProcess\",\"relationName\":\"WhatsappTemplateProcessToWhatsappTemplateProcessTagsMapping\",\"relationFromFields\":[\"whatsapp_template_process_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_tag\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateTag\",\"relationName\":\"WhatsappTemplateProcessTagsMappingToWhatsappTemplateTag\",\"relationFromFields\":[\"whatsapp_template_tag_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":{\"name\":null,\"fields\":[\"whatsapp_template_process_id\",\"whatsapp_template_tag_id\",\"company_id\"]},\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"WhatsappTemplate\":{\"dbName\":\"whatsapp_templates\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"message\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_process_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"StatusToWhatsappTemplate\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"dbName\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"dbName\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"dbName\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_process\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateProcess\",\"relationName\":\"WhatsappTemplateToWhatsappTemplateProcess\",\"relationFromFields\":[\"whatsapp_template_process_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_assignments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateAssignment\",\"relationName\":\"WhatsappTemplateAssignment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedWhatsappTemplate\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedWhatsappTemplate\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedWhatsappTemplate\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_assignments_approve\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflowAssignment\",\"relationName\":\"ApproveAssignmentWhatsapp\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_assignments_reject\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflowAssignment\",\"relationName\":\"RejectAssignmentWhatsapp\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"WhatsappTemplateAssignment\":{\"dbName\":\"whatsapp_template_assignments\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_process_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"template_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"recipient_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"RecipientType\",\"default\":\"tag\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_to\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"dbName\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_process\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateProcess\",\"relationName\":\"WhatsappTemplateAssignmentToWhatsappTemplateProcess\",\"relationFromFields\":[\"whatsapp_template_process_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplate\",\"relationName\":\"WhatsappTemplateAssignment\",\"relationFromFields\":[\"template_id\",\"company_id\"],\"relationToFields\":[\"id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedwhatsappTemplateAssignment\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"id\"]}],\"isGenerated\":false},\"NotificationJob\":{\"dbName\":\"notification_jobs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"process_slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_to\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_subject\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_content\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"attachments_path\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"attachments_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_cc\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_bcc\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_type_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"NotificationType\",\"default\":\"email\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"parent_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"no_of_attempts\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"NotificationJobToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"dbName\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"sent_at\",\"dbName\":\"sent_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"read_at\",\"dbName\":\"read_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedNotificationJob\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"CarouselTemplate\":{\"dbName\":\"carousel_templates\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"CarouselTemplateToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedCarouselTemplate\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedCarouselTemplate\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedCarouselTemplate\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CarouselTemplateLineItem\",\"relationName\":\"CarouselTemplateToCarouselTemplateLineItem\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"CarouselTemplateLineItem\":{\"dbName\":\"carousel_template_line_items\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"carousel_template_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"image_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"video_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"clickable_link\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"CarouselTemplateLineItemToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"carousel_template\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CarouselTemplate\",\"relationName\":\"CarouselTemplateToCarouselTemplateLineItem\",\"relationFromFields\":[\"company_id\",\"carousel_template_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"carousel_template_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"carousel_template_id\",\"slug\"]}],\"isGenerated\":false},\"ImportTemplate\":{\"dbName\":\"import_templates\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"max_row_count\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":500,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"header_row\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"data_start_row\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"data_end_row\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"ignore_error_rows\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_admin_module\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_send_mail\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_process_slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"job_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":\"direct\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"batch_process_count\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":50,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ImportTemplateToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedImportTemplate\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedImportTemplate\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedImportTemplate\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplateLineItem\",\"relationName\":\"ImportTemplateToImportTemplateLineItem\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"queries\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplateQueries\",\"relationName\":\"ImportTemplateToImportTemplateQueries\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"ImportTemplateLineItem\":{\"dbName\":\"import_template_line_items\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_template_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"display_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_table\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"width\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"default_value\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"check_reg_exp\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_nullable\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":true,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_unique\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_foreign\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"unique_query\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"foreign_query\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_enum\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_multiple\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"enum_values\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"expression_rules\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"foreign_table\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"foreign_column\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"foreign_can_create\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_individual\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"individual_column\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_type_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ImportTemplateLineItemToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_template\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplate\",\"relationName\":\"ImportTemplateToImportTemplateLineItem\",\"relationFromFields\":[\"company_id\",\"import_template_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_type\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FieldType\",\"relationName\":\"FieldTypeToImportTemplateLineItem\",\"relationFromFields\":[\"company_id\",\"field_type_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"import_template_id\",\"field_table\",\"field_name\"],[\"company_id\",\"import_template_id\",\"display_name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"import_template_id\",\"field_table\",\"field_name\"]},{\"name\":null,\"fields\":[\"company_id\",\"import_template_id\",\"display_name\"]}],\"isGenerated\":false},\"ImportTemplateQueries\":{\"dbName\":\"import_template_queries\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_template_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_string\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"allow_multiple\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_individual\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"before_lineitems\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":true,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ImportTemplateQueriesToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_template\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplate\",\"relationName\":\"ImportTemplateToImportTemplateQueries\",\"relationFromFields\":[\"company_id\",\"import_template_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"ImportJob\":{\"dbName\":\"import_jobs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"sequence_number\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"header_details\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"table_config\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"total_rows\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"completed_rows\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"error_rows\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"batch_process_count\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":50,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"job_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":\"created\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"last_processed_row_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"file_path\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"file_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ImportJobToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedImportJob\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedImportJob\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedImportJob\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportJobLineItem\",\"relationName\":\"ImportJobToImportJobLineItem\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"ImportJobLineItem\":{\"dbName\":\"import_job_line_items\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_job_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"row_object\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"job_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":\"created\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ImportJobLineItemToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_job\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportJob\",\"relationName\":\"ImportJobToImportJobLineItem\",\"relationFromFields\":[\"company_id\",\"import_job_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"ExportTemplate\":{\"dbName\":\"export_templates\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"max_row_count\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":500,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"header_row\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"data_start_row\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"data_end_row\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"data_filepath\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ExportTemplateToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedExportTemplate\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedExportTemplate\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedExportTemplate\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplateLineItem\",\"relationName\":\"ExportTemplateToExportTemplateLineItem\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"queries\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplateQueries\",\"relationName\":\"ExportTemplateToExportTemplateQueries\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"ExportTemplateLineItem\":{\"dbName\":\"export_template_line_items\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"export_template_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"display_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_table\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"default_value\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"column_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_individual\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"individual_column\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_type_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ExportTemplateLineItemToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"export_template\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplate\",\"relationName\":\"ExportTemplateToExportTemplateLineItem\",\"relationFromFields\":[\"company_id\",\"export_template_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_type\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FieldType\",\"relationName\":\"ExportTemplateLineItemToFieldType\",\"relationFromFields\":[\"company_id\",\"field_type_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"export_template_id\",\"field_table\",\"field_name\"],[\"company_id\",\"export_template_id\",\"display_name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"export_template_id\",\"field_table\",\"field_name\"]},{\"name\":null,\"fields\":[\"company_id\",\"export_template_id\",\"display_name\"]}],\"isGenerated\":false},\"ExportTemplateQueries\":{\"dbName\":\"export_template_queries\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"export_template_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_string\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_procedure\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":\"procedure\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_individual\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ExportTemplateQueriesToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"export_template\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplate\",\"relationName\":\"ExportTemplateToExportTemplateQueries\",\"relationFromFields\":[\"company_id\",\"export_template_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"Status\":{\"dbName\":\"statuses\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"MyStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_list\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"MyStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"StatusToUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"request_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"RequestLog\",\"relationName\":\"RequestLogToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"permissions\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Permissions\",\"relationName\":\"PermissionsToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"roles\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Role\",\"relationName\":\"RoleToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"languages\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Language\",\"relationName\":\"LanguageToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"language_contents\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"LanguageContent\",\"relationName\":\"LanguageContentToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menuitems\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MenuItems\",\"relationName\":\"MenuItemsToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menus\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Menus\",\"relationName\":\"MenusToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"master_grids\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MasterEntity\",\"relationName\":\"MasterEntityToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"master_grid_line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"MasterEntityLineItem\",\"relationName\":\"MasterEntityLineItemToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"field_types\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FieldType\",\"relationName\":\"FieldTypeToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"menu_types\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"menuType\",\"relationName\":\"StatusTomenuType\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_processes\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateProcess\",\"relationName\":\"EmailTemplateProcessToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_tags\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateTag\",\"relationName\":\"EmailTemplateTagToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_template_receiver_tags\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplateRecipientTag\",\"relationName\":\"EmailTemplateRecipientTagToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplate\",\"relationName\":\"EmailTemplateToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email_process_jobs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailProcessJob\",\"relationName\":\"EmailProcessJobToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"notification_job\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"NotificationJob\",\"relationName\":\"NotificationJobToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplate\",\"relationName\":\"ImportTemplateToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_template_line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplateLineItem\",\"relationName\":\"ImportTemplateLineItemToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_template_queries\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportTemplateQueries\",\"relationName\":\"ImportTemplateQueriesToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"export_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplate\",\"relationName\":\"ExportTemplateToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"export_template_line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplateLineItem\",\"relationName\":\"ExportTemplateLineItemToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"export_template_queries\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ExportTemplateQueries\",\"relationName\":\"ExportTemplateQueriesToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"designations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Designation\",\"relationName\":\"DesignationToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"departments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Department\",\"relationName\":\"DepartmentToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"audit_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"AuditLog\",\"relationName\":\"AuditLogToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"financial_years\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FinancialYear\",\"relationName\":\"FinancialYearToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"document_sequences\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DocumentSequence\",\"relationName\":\"DocumentSequenceToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"file_upload_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"FileUploadLog\",\"relationName\":\"FileUploadLogToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"device_registration\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DeviceRegistration\",\"relationName\":\"DeviceRegistrationToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_job\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportJob\",\"relationName\":\"ImportJobToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"import_job_line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ImportJobLineItem\",\"relationName\":\"ImportJobLineItemToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"policies\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Policies\",\"relationName\":\"PoliciesToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"app_versions\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Appversions\",\"relationName\":\"AppversionsToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflows\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflow\",\"relationName\":\"ApprovalWorkflowToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job_workflows\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalProcessJobWorkflow\",\"relationName\":\"ApprovalProcessJobWorkflowToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_approver_tags\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflowApproverTag\",\"relationName\":\"ApprovalWorkflowApproverTagToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_assignments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflowAssignment\",\"relationName\":\"ApprovalWorkflowAssignmentToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalProcessJob\",\"relationName\":\"ApprovalProcessJobToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job_workflow_users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalProcessJobWorkflowUser\",\"relationName\":\"ApprovalProcessJobWorkflowUserToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"delegations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Delegation\",\"relationName\":\"DelegationToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"about_lcp\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"AboutLCP\",\"relationName\":\"AboutLCPToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"schema_chunks\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaChunk\",\"relationName\":\"SchemaChunkToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"openai_usage_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"OpenaiUsageLog\",\"relationName\":\"OpenaiUsageLogToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"embedding_vector_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmbeddingVectorLogs\",\"relationName\":\"EmbeddingVectorLogsToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_execution_log\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"QueryExecutionLog\",\"relationName\":\"QueryExecutionLogToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"child_processes\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ChildProcess\",\"relationName\":\"ChildProcessToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"child_process_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ChildProcessLog\",\"relationName\":\"ChildProcessLogToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"carousel_templates\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CarouselTemplate\",\"relationName\":\"CarouselTemplateToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"carousel_template_line_items\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CarouselTemplateLineItem\",\"relationName\":\"CarouselTemplateLineItemToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"scheduled_job_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ScheduledJobLogs\",\"relationName\":\"ScheduledJobLogsToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"scheduled_jobs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ScheduledJob\",\"relationName\":\"ScheduledJobToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_process\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateProcess\",\"relationName\":\"StatusToWhatsappTemplateProcess\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_tag\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateTag\",\"relationName\":\"StatusToWhatsappTemplateTag\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template_recipient_tag\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplateRecipientTag\",\"relationName\":\"StatusToWhatsappTemplateRecipientTag\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_template\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplate\",\"relationName\":\"StatusToWhatsappTemplate\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"whatsapp_process_jobs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappProcessJob\",\"relationName\":\"StatusToWhatsappProcessJob\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"app_categories\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"CategoriesToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"organizations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Organizations\",\"relationName\":\"OrganizationsToStatus\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"id\"],[\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"id\"]},{\"name\":null,\"fields\":[\"slug\"]}],\"isGenerated\":false},\"CategoryTypes\":{\"dbName\":\"app_category_types\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"category_type_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_category_types\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedCategoryTypes\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_category_types\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedCategoryTypes\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_category_types\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedCategoryTypes\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"categories\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"CategoriesToCategoryTypes\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"category_type_id\"],[\"company_id\",\"id\"],[\"company_id\",\"name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"category_type_id\"]},{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"name\"]}],\"isGenerated\":false},\"Categories\":{\"dbName\":\"app_categories\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"category_type_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"category_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"parent_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"CategoriesToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"parent\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"SubCategories\",\"relationFromFields\":[\"parent_id\"],\"relationToFields\":[\"category_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"subcategories\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"SubCategories\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"category_type\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CategoryTypes\",\"relationName\":\"CategoriesToCategoryTypes\",\"relationFromFields\":[\"category_type_id\",\"company_id\"],\"relationToFields\":[\"category_type_id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_categories\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedCategories\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_categories\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedCategories\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_categories\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedCategories\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"configurations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Configurations\",\"relationName\":\"CategoriesToConfigurations\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_configurations\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserConfigurations\",\"relationName\":\"CategoriesToUserConfigurations\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"category_id\"],[\"company_id\",\"id\"],[\"company_id\",\"category_id\",\"name\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"category_id\"]},{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"category_id\",\"name\"]}],\"isGenerated\":false},\"Configurations\":{\"dbName\":\"app_configurations\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_key\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"category_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_value\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_select_json\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_file_value\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_value_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_field_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"display_config\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":true,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"category\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"CategoriesToConfigurations\",\"relationFromFields\":[\"category_id\",\"company_id\"],\"relationToFields\":[\"category_id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_configurations\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedConfigurations\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_configurations\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedConfigurations\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_configurations\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedConfigurations\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"config_key\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"config_key\"]}],\"isGenerated\":false},\"UserConfigurations\":{\"dbName\":\"app_user_configurations\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_key\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"category_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_value\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_select_json\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_file_value\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_value_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"config_field_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"display_config\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":true,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"category\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Categories\",\"relationName\":\"CategoriesToUserConfigurations\",\"relationFromFields\":[\"category_id\",\"company_id\"],\"relationToFields\":[\"category_id\",\"company_id\"],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_user_configurations\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedUserConfigurations\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_user_configurations\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedUserConfigurations\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_user_configurations\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedUserConfigurations\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"config_key\",\"user_id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"config_key\",\"user_id\"]}],\"isGenerated\":false},\"FileUploadLog\":{\"dbName\":\"file_upload_logs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"doc_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"org_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"extension\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"FileUploadLogToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"DataTransferQueries\":{\"dbName\":\"data_transfer_queries\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"select_query\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"insert_query\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"transfer_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"job_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"destination_table\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"clear_destination_table\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Boolean\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"execution_order\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"command_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"DeviceRegistration\":{\"dbName\":\"device_registration\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"device_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"device_unique_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"DeviceRegistrationToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_device_registration\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedDeviceRegistration\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_device_registration\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedDeviceRegistration\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_device_registration\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedDeviceRegistration\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeviceRegistrationToUser\",\"relationFromFields\":[\"company_id\",\"user_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]}],\"isGenerated\":false},\"Policies\":{\"dbName\":\"policies\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"PoliciesToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_policy\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserPolicies\",\"relationName\":\"PoliciesToUserPolicies\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"role_policy\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"RolePolicies\",\"relationName\":\"PoliciesToRolePolicies\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_policy\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedPolicy\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_policy\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedPolicy\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_policy\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedPolicy\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"name\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"name\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"UserPolicies\":{\"dbName\":\"user_policies\",\"fields\":[{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"policy\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Policies\",\"relationName\":\"PoliciesToUserPolicies\",\"relationFromFields\":[\"company_id\",\"policy_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"policy_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UserToUserPolicies\",\"relationFromFields\":[\"company_id\",\"user_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"policy_id\",\"user_id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"policy_id\",\"user_id\"]}],\"isGenerated\":false},\"RolePolicies\":{\"dbName\":\"role_policies\",\"fields\":[{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"policy\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Policies\",\"relationName\":\"PoliciesToRolePolicies\",\"relationFromFields\":[\"company_id\",\"policy_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"policy_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"role\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Role\",\"relationName\":\"RoleToRolePolicies\",\"relationFromFields\":[\"company_id\",\"role_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"role_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"policy_id\",\"role_id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"policy_id\",\"role_id\"]}],\"isGenerated\":false},\"Appversions\":{\"dbName\":\"app_versions\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"version_type\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"version\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_frontend_changed\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_backend_changed\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_database_changed\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":false,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"developed_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"AppversionsToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_app_versions\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"Created_app_versions\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_app_versions\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"Updated_app_versions\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_app_versions\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"Deleted_app_versions\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]}],\"isGenerated\":false},\"ScheduledJob\":{\"dbName\":\"scheduled_jobs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"timing\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":\"* * * * *\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"cron_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"concat_base_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Boolean\",\"default\":true,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ScheduledJobToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"scheduled_job_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ScheduledJobLogs\",\"relationName\":\"ScheduledJobToScheduledJobLogs\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"ScheduledJobLogs\":{\"dbName\":\"scheduled_job_logs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"scheduled_job_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"executed_statement\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"schedule_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"response\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ScheduledJobLogsToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"scheduled_job\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ScheduledJob\",\"relationName\":\"ScheduledJobToScheduledJobLogs\",\"relationFromFields\":[\"scheduled_job_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"ApprovalWorkflow\":{\"dbName\":\"approval_workflows\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ApprovalWorkflowToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_assignments\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflowAssignment\",\"relationName\":\"ApprovalWorkflowToApprovalWorkflowAssignment\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"ApprovalWorkflowApproverTag\":{\"dbName\":\"approval_workflow_approver_tags\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query_information\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ApprovalWorkflowApproverTagToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"ApprovalWorkflowAssignment\":{\"dbName\":\"approval_workflow_assignments\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalWorkflow\",\"relationName\":\"ApprovalWorkflowToApprovalWorkflowAssignment\",\"relationFromFields\":[\"company_id\",\"approval_workflow_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approver_order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approver_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"ApproverType\",\"default\":\"tag\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approver\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approve_query_information\",\"kind\":\"scalar\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reject_query_information\",\"kind\":\"scalar\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ApprovalWorkflowAssignmentToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approve_mail_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approve_mail\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplate\",\"relationName\":\"ApproveAssignmentMail\",\"relationFromFields\":[\"approve_mail_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reject_mail_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reject_mail\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"EmailTemplate\",\"relationName\":\"RejectAssignmentMail\",\"relationFromFields\":[\"reject_mail_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approve_whatsapp_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approve_whatsapp\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplate\",\"relationName\":\"ApproveAssignmentWhatsapp\",\"relationFromFields\":[\"approve_whatsapp_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reject_whatsapp_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reject_whatsapp\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"WhatsappTemplate\",\"relationName\":\"RejectAssignmentWhatsapp\",\"relationFromFields\":[\"reject_whatsapp_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"approval_workflow_id\",\"approver_order_no\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"approval_workflow_id\",\"approver_order_no\"]}],\"isGenerated\":false},\"ApprovalProcessJob\":{\"dbName\":\"approval_process_jobs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"sequence_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"primary_table\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"unique_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"screen_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"prefill_data\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"details\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ApprovalProcessJobToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"uuid\"],[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"ApprovalProcessJobWorkflow\":{\"dbName\":\"approval_process_job_workflows\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_assignment_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_workflow_slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job_description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approve_query_information\",\"kind\":\"scalar\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reject_query_information\",\"kind\":\"scalar\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"primary_table\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"sequence_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"unique_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"screen_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"prefill_data\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approver_order_no\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Decimal\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approver_type\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"ApproverType\",\"default\":\"tag\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approver\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"review_status\",\"kind\":\"enum\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"ApprovalStatus\",\"default\":\"pending\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reviewed_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reason\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ApprovalProcessJobWorkflowToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approve_mail_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reject_mail_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approve_whatsapp_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reject_whatsapp_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"assigned_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"processed_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"details\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job_workflow_users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalProcessJobWorkflowUser\",\"relationName\":\"ApprovalProcessJobWorkflowToApprovalProcessJobWorkflowUser\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]}],\"isGenerated\":false},\"ApprovalProcessJobWorkflowUser\":{\"dbName\":\"approval_process_job_workflow_users\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job_workflow_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"approval_process_job_workflow\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ApprovalProcessJobWorkflow\",\"relationName\":\"ApprovalProcessJobWorkflowToApprovalProcessJobWorkflowUser\",\"relationFromFields\":[\"company_id\",\"approval_process_job_workflow_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ApprovalProcessJobWorkflowUserToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]}],\"isGenerated\":false},\"Delegation\":{\"dbName\":\"delegations\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"delegated_user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"reason\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"start_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"end_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"DelegationToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]}],\"isGenerated\":false},\"SchemaChunk\":{\"dbName\":\"schema_chunks\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"table_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"chunk\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"SchemaChunkToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"EmbeddingVectorLogs\":{\"dbName\":\"embedding_vector_logs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"cost\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Decimal\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"table_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"EmbeddingVectorLogsToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"OpenaiUsageLog\":{\"dbName\":\"openai_usage_logs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"prompt\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"generated_sql\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"prompt_tokens\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"completion_tokens\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"total_tokens\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"cost\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Decimal\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"OpenaiUsageLogToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"QueryExecutionLog\":{\"dbName\":\"query_execution_logs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"QueryExecutionLogToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"query\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"ChildProcess\":{\"dbName\":\"child_processes\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"slug\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"command\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ChildProcessToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"child_process_logs\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ChildProcessLog\",\"relationName\":\"child_process\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"slug\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"slug\"]}],\"isGenerated\":false},\"ChildProcessLog\":{\"dbName\":\"child_process_logs\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"child_process_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"process_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"output\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"initiated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"ChildProcessLogToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"child_process\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"ChildProcess\",\"relationName\":\"child_process\",\"relationFromFields\":[\"company_id\",\"child_process_id\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"initiator\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"Initiator\",\"relationFromFields\":[\"company_id\",\"initiated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]}],\"isGenerated\":false},\"Organizations\":{\"dbName\":\"organizations\",\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":{\"name\":\"autoincrement\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"default\":{\"name\":\"dbgenerated\",\"args\":[\"uuid_generate_v4()\"]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"company_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"description\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"no_of_devices\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":0,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":true,\"type\":\"Int\",\"default\":1,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Status\",\"relationName\":\"OrganizationsToStatus\",\"relationFromFields\":[\"status_id\"],\"relationToFields\":[\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted_by\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":true,\"hasDefaultValue\":false,\"type\":\"Int\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"DateTime\",\"default\":{\"name\":\"now\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":true},{\"name\":\"deleted_at\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"users\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"UserDetail\",\"relationName\":\"UserOrganization\",\"relationFromFields\":[],\"relationToFields\":[],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"CreatedOrganization\",\"relationFromFields\":[\"company_id\",\"created_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"UpdatedOrganization\",\"relationFromFields\":[\"company_id\",\"updated_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"deleted\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"User\",\"relationName\":\"DeletedOrganization\",\"relationFromFields\":[\"company_id\",\"deleted_by\"],\"relationToFields\":[\"company_id\",\"id\"],\"relationOnDelete\":\"Cascade\",\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"company_id\",\"id\"],[\"company_id\",\"uuid\"],[\"company_id\",\"code\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"company_id\",\"id\"]},{\"name\":null,\"fields\":[\"company_id\",\"uuid\"]},{\"name\":null,\"fields\":[\"company_id\",\"code\"]}],\"isGenerated\":false}},\"enums\":{\"UserRole\":{\"values\":[{\"name\":\"super_admin\",\"dbName\":null},{\"name\":\"company_admin\",\"dbName\":null},{\"name\":\"admin\",\"dbName\":null},{\"name\":\"user\",\"dbName\":null}],\"dbName\":null},\"Gender\":{\"values\":[{\"name\":\"male\",\"dbName\":null},{\"name\":\"female\",\"dbName\":null},{\"name\":\"others\",\"dbName\":null}],\"dbName\":null},\"OtpPurpose\":{\"values\":[{\"name\":\"login\",\"dbName\":null},{\"name\":\"password_reset\",\"dbName\":null},{\"name\":\"verify_email\",\"dbName\":null},{\"name\":\"others\",\"dbName\":null}],\"dbName\":null},\"RecipientType\":{\"values\":[{\"name\":\"tag\",\"dbName\":null},{\"name\":\"user_id\",\"dbName\":null},{\"name\":\"custom\",\"dbName\":null}],\"dbName\":null},\"ApproverType\":{\"values\":[{\"name\":\"tag\",\"dbName\":null},{\"name\":\"user_id\",\"dbName\":null},{\"name\":\"role_id\",\"dbName\":null}],\"dbName\":null},\"NotifyType\":{\"values\":[{\"name\":\"email\",\"dbName\":null},{\"name\":\"push\",\"dbName\":null}],\"dbName\":null},\"ClauseType\":{\"values\":[{\"name\":\"where\",\"dbName\":null},{\"name\":\"having\",\"dbName\":null}],\"dbName\":null},\"sendMailType\":{\"values\":[{\"name\":\"cc\",\"dbName\":null},{\"name\":\"bcc\",\"dbName\":null}],\"dbName\":null},\"ReportType\":{\"values\":[{\"name\":\"lcp\",\"dbName\":null},{\"name\":\"powerbi\",\"dbName\":null}],\"dbName\":null},\"aboutType\":{\"values\":[{\"name\":\"lcp\",\"dbName\":null},{\"name\":\"project\",\"dbName\":null}],\"dbName\":null},\"ApprovalStatus\":{\"values\":[{\"name\":\"pending\",\"dbName\":null},{\"name\":\"approval_needed\",\"dbName\":null},{\"name\":\"approval_completed\",\"dbName\":null},{\"name\":\"approval_rejected\",\"dbName\":null},{\"name\":\"void\",\"dbName\":null}],\"dbName\":null},\"ProcessStatus\":{\"values\":[{\"name\":\"under_approval\",\"dbName\":null},{\"name\":\"approved\",\"dbName\":null},{\"name\":\"rejected\",\"dbName\":null},{\"name\":\"submitted\",\"dbName\":null},{\"name\":\"created\",\"dbName\":null},{\"name\":\"not_appear\",\"dbName\":null}],\"dbName\":null},\"NotificationType\":{\"values\":[{\"name\":\"email\",\"dbName\":null},{\"name\":\"whatsapp\",\"dbName\":null}],\"dbName\":null}},\"types\":{}}")
defineDmmfProperty(exports.Prisma, config.runtimeDataModel)
config.engineWasm = undefined


const { warnEnvConflicts } = require('./runtime/library.js')

warnEnvConflicts({
    rootEnvPath: config.relativeEnvPaths.rootEnvPath && path.resolve(config.dirname, config.relativeEnvPaths.rootEnvPath),
    schemaEnvPath: config.relativeEnvPaths.schemaEnvPath && path.resolve(config.dirname, config.relativeEnvPaths.schemaEnvPath)
})

const PrismaClient = getPrismaClient(config)
exports.PrismaClient = PrismaClient
Object.assign(exports, Prisma)

// file annotations for bundling tools to include these files
path.join(__dirname, "libquery_engine-debian-openssl-3.0.x.so.node");
path.join(process.cwd(), "node_modules/@prisma/pg/client/libquery_engine-debian-openssl-3.0.x.so.node")
// file annotations for bundling tools to include these files
path.join(__dirname, "schema.prisma");
path.join(process.cwd(), "node_modules/@prisma/pg/client/schema.prisma")
