
/**
 * Client
**/

import * as runtime from './runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model User
 * 
 */
export type User = $Result.DefaultSelection<Prisma.$UserPayload>
/**
 * Model UserDetail
 * 
 */
export type UserDetail = $Result.DefaultSelection<Prisma.$UserDetailPayload>
/**
 * Model Designation
 * 
 */
export type Designation = $Result.DefaultSelection<Prisma.$DesignationPayload>
/**
 * Model Department
 * 
 */
export type Department = $Result.DefaultSelection<Prisma.$DepartmentPayload>
/**
 * Model RequestLog
 * 
 */
export type RequestLog = $Result.DefaultSelection<Prisma.$RequestLogPayload>
/**
 * Model FinancialYear
 * 
 */
export type FinancialYear = $Result.DefaultSelection<Prisma.$FinancialYearPayload>
/**
 * Model DocumentSequence
 * 
 */
export type DocumentSequence = $Result.DefaultSelection<Prisma.$DocumentSequencePayload>
/**
 * Model AuditLog
 * 
 */
export type AuditLog = $Result.DefaultSelection<Prisma.$AuditLogPayload>
/**
 * Model Permissions
 * 
 */
export type Permissions = $Result.DefaultSelection<Prisma.$PermissionsPayload>
/**
 * Model Role
 * 
 */
export type Role = $Result.DefaultSelection<Prisma.$RolePayload>
/**
 * Model RolePermissions
 * 
 */
export type RolePermissions = $Result.DefaultSelection<Prisma.$RolePermissionsPayload>
/**
 * Model UserRoles
 * 
 */
export type UserRoles = $Result.DefaultSelection<Prisma.$UserRolesPayload>
/**
 * Model UserPermissions
 * 
 */
export type UserPermissions = $Result.DefaultSelection<Prisma.$UserPermissionsPayload>
/**
 * Model Otp
 * 
 */
export type Otp = $Result.DefaultSelection<Prisma.$OtpPayload>
/**
 * Model Language
 * 
 */
export type Language = $Result.DefaultSelection<Prisma.$LanguagePayload>
/**
 * Model LanguageContent
 * 
 */
export type LanguageContent = $Result.DefaultSelection<Prisma.$LanguageContentPayload>
/**
 * Model Menus
 * 
 */
export type Menus = $Result.DefaultSelection<Prisma.$MenusPayload>
/**
 * Model MenuItems
 * 
 */
export type MenuItems = $Result.DefaultSelection<Prisma.$MenuItemsPayload>
/**
 * Model ActionType
 * 
 */
export type ActionType = $Result.DefaultSelection<Prisma.$ActionTypePayload>
/**
 * Model EntityType
 * 
 */
export type EntityType = $Result.DefaultSelection<Prisma.$EntityTypePayload>
/**
 * Model WizardGroup
 * 
 */
export type WizardGroup = $Result.DefaultSelection<Prisma.$WizardGroupPayload>
/**
 * Model WizardType
 * 
 */
export type WizardType = $Result.DefaultSelection<Prisma.$WizardTypePayload>
/**
 * Model AboutLCP
 * 
 */
export type AboutLCP = $Result.DefaultSelection<Prisma.$AboutLCPPayload>
/**
 * Model MasterEntity
 * 
 */
export type MasterEntity = $Result.DefaultSelection<Prisma.$MasterEntityPayload>
/**
 * Model MasterEntityLineItem
 * 
 */
export type MasterEntityLineItem = $Result.DefaultSelection<Prisma.$MasterEntityLineItemPayload>
/**
 * Model FieldType
 * 
 */
export type FieldType = $Result.DefaultSelection<Prisma.$FieldTypePayload>
/**
 * Model menuType
 * 
 */
export type menuType = $Result.DefaultSelection<Prisma.$menuTypePayload>
/**
 * Model EmailTemplateProcess
 * 
 */
export type EmailTemplateProcess = $Result.DefaultSelection<Prisma.$EmailTemplateProcessPayload>
/**
 * Model EmailTemplateTag
 * 
 */
export type EmailTemplateTag = $Result.DefaultSelection<Prisma.$EmailTemplateTagPayload>
/**
 * Model EmailTemplateRecipientTag
 * 
 */
export type EmailTemplateRecipientTag = $Result.DefaultSelection<Prisma.$EmailTemplateRecipientTagPayload>
/**
 * Model EmailTemplateProcessTagsMapping
 * 
 */
export type EmailTemplateProcessTagsMapping = $Result.DefaultSelection<Prisma.$EmailTemplateProcessTagsMappingPayload>
/**
 * Model EmailTemplate
 * 
 */
export type EmailTemplate = $Result.DefaultSelection<Prisma.$EmailTemplatePayload>
/**
 * Model EmailTemplateAssignment
 * 
 */
export type EmailTemplateAssignment = $Result.DefaultSelection<Prisma.$EmailTemplateAssignmentPayload>
/**
 * Model EmailTemplateCcBcc
 * 
 */
export type EmailTemplateCcBcc = $Result.DefaultSelection<Prisma.$EmailTemplateCcBccPayload>
/**
 * Model EmailProcessJob
 * 
 */
export type EmailProcessJob = $Result.DefaultSelection<Prisma.$EmailProcessJobPayload>
/**
 * Model WhatsappProcessJob
 * 
 */
export type WhatsappProcessJob = $Result.DefaultSelection<Prisma.$WhatsappProcessJobPayload>
/**
 * Model WhatsappTemplateProcess
 * 
 */
export type WhatsappTemplateProcess = $Result.DefaultSelection<Prisma.$WhatsappTemplateProcessPayload>
/**
 * Model WhatsappTemplateTag
 * 
 */
export type WhatsappTemplateTag = $Result.DefaultSelection<Prisma.$WhatsappTemplateTagPayload>
/**
 * Model WhatsappTemplateRecipientTag
 * 
 */
export type WhatsappTemplateRecipientTag = $Result.DefaultSelection<Prisma.$WhatsappTemplateRecipientTagPayload>
/**
 * Model WhatsappTemplateProcessTagsMapping
 * 
 */
export type WhatsappTemplateProcessTagsMapping = $Result.DefaultSelection<Prisma.$WhatsappTemplateProcessTagsMappingPayload>
/**
 * Model WhatsappTemplate
 * 
 */
export type WhatsappTemplate = $Result.DefaultSelection<Prisma.$WhatsappTemplatePayload>
/**
 * Model WhatsappTemplateAssignment
 * 
 */
export type WhatsappTemplateAssignment = $Result.DefaultSelection<Prisma.$WhatsappTemplateAssignmentPayload>
/**
 * Model NotificationJob
 * 
 */
export type NotificationJob = $Result.DefaultSelection<Prisma.$NotificationJobPayload>
/**
 * Model CarouselTemplate
 * 
 */
export type CarouselTemplate = $Result.DefaultSelection<Prisma.$CarouselTemplatePayload>
/**
 * Model CarouselTemplateLineItem
 * 
 */
export type CarouselTemplateLineItem = $Result.DefaultSelection<Prisma.$CarouselTemplateLineItemPayload>
/**
 * Model ImportTemplate
 * 
 */
export type ImportTemplate = $Result.DefaultSelection<Prisma.$ImportTemplatePayload>
/**
 * Model ImportTemplateLineItem
 * 
 */
export type ImportTemplateLineItem = $Result.DefaultSelection<Prisma.$ImportTemplateLineItemPayload>
/**
 * Model ImportTemplateQueries
 * 
 */
export type ImportTemplateQueries = $Result.DefaultSelection<Prisma.$ImportTemplateQueriesPayload>
/**
 * Model ImportJob
 * 
 */
export type ImportJob = $Result.DefaultSelection<Prisma.$ImportJobPayload>
/**
 * Model ImportJobLineItem
 * 
 */
export type ImportJobLineItem = $Result.DefaultSelection<Prisma.$ImportJobLineItemPayload>
/**
 * Model ExportTemplate
 * 
 */
export type ExportTemplate = $Result.DefaultSelection<Prisma.$ExportTemplatePayload>
/**
 * Model ExportTemplateLineItem
 * 
 */
export type ExportTemplateLineItem = $Result.DefaultSelection<Prisma.$ExportTemplateLineItemPayload>
/**
 * Model ExportTemplateQueries
 * 
 */
export type ExportTemplateQueries = $Result.DefaultSelection<Prisma.$ExportTemplateQueriesPayload>
/**
 * Model Status
 * 
 */
export type Status = $Result.DefaultSelection<Prisma.$StatusPayload>
/**
 * Model CategoryTypes
 * 
 */
export type CategoryTypes = $Result.DefaultSelection<Prisma.$CategoryTypesPayload>
/**
 * Model Categories
 * 
 */
export type Categories = $Result.DefaultSelection<Prisma.$CategoriesPayload>
/**
 * Model Configurations
 * 
 */
export type Configurations = $Result.DefaultSelection<Prisma.$ConfigurationsPayload>
/**
 * Model UserConfigurations
 * 
 */
export type UserConfigurations = $Result.DefaultSelection<Prisma.$UserConfigurationsPayload>
/**
 * Model FileUploadLog
 * 
 */
export type FileUploadLog = $Result.DefaultSelection<Prisma.$FileUploadLogPayload>
/**
 * Model DataTransferQueries
 * 
 */
export type DataTransferQueries = $Result.DefaultSelection<Prisma.$DataTransferQueriesPayload>
/**
 * Model DeviceRegistration
 * 
 */
export type DeviceRegistration = $Result.DefaultSelection<Prisma.$DeviceRegistrationPayload>
/**
 * Model Policies
 * 
 */
export type Policies = $Result.DefaultSelection<Prisma.$PoliciesPayload>
/**
 * Model UserPolicies
 * 
 */
export type UserPolicies = $Result.DefaultSelection<Prisma.$UserPoliciesPayload>
/**
 * Model RolePolicies
 * 
 */
export type RolePolicies = $Result.DefaultSelection<Prisma.$RolePoliciesPayload>
/**
 * Model Appversions
 * 
 */
export type Appversions = $Result.DefaultSelection<Prisma.$AppversionsPayload>
/**
 * Model ScheduledJob
 * 
 */
export type ScheduledJob = $Result.DefaultSelection<Prisma.$ScheduledJobPayload>
/**
 * Model ScheduledJobLogs
 * 
 */
export type ScheduledJobLogs = $Result.DefaultSelection<Prisma.$ScheduledJobLogsPayload>
/**
 * Model ApprovalWorkflow
 * 
 */
export type ApprovalWorkflow = $Result.DefaultSelection<Prisma.$ApprovalWorkflowPayload>
/**
 * Model ApprovalWorkflowApproverTag
 * 
 */
export type ApprovalWorkflowApproverTag = $Result.DefaultSelection<Prisma.$ApprovalWorkflowApproverTagPayload>
/**
 * Model ApprovalWorkflowAssignment
 * 
 */
export type ApprovalWorkflowAssignment = $Result.DefaultSelection<Prisma.$ApprovalWorkflowAssignmentPayload>
/**
 * Model ApprovalProcessJob
 * 
 */
export type ApprovalProcessJob = $Result.DefaultSelection<Prisma.$ApprovalProcessJobPayload>
/**
 * Model ApprovalProcessJobWorkflow
 * 
 */
export type ApprovalProcessJobWorkflow = $Result.DefaultSelection<Prisma.$ApprovalProcessJobWorkflowPayload>
/**
 * Model ApprovalProcessJobWorkflowUser
 * 
 */
export type ApprovalProcessJobWorkflowUser = $Result.DefaultSelection<Prisma.$ApprovalProcessJobWorkflowUserPayload>
/**
 * Model Delegation
 * 
 */
export type Delegation = $Result.DefaultSelection<Prisma.$DelegationPayload>
/**
 * Model SchemaChunk
 * 
 */
export type SchemaChunk = $Result.DefaultSelection<Prisma.$SchemaChunkPayload>
/**
 * Model EmbeddingVectorLogs
 * 
 */
export type EmbeddingVectorLogs = $Result.DefaultSelection<Prisma.$EmbeddingVectorLogsPayload>
/**
 * Model OpenaiUsageLog
 * 
 */
export type OpenaiUsageLog = $Result.DefaultSelection<Prisma.$OpenaiUsageLogPayload>
/**
 * Model QueryExecutionLog
 * 
 */
export type QueryExecutionLog = $Result.DefaultSelection<Prisma.$QueryExecutionLogPayload>
/**
 * Model ChildProcess
 * 
 */
export type ChildProcess = $Result.DefaultSelection<Prisma.$ChildProcessPayload>
/**
 * Model ChildProcessLog
 * 
 */
export type ChildProcessLog = $Result.DefaultSelection<Prisma.$ChildProcessLogPayload>
/**
 * Model Organizations
 * 
 */
export type Organizations = $Result.DefaultSelection<Prisma.$OrganizationsPayload>

/**
 * Enums
 */
export namespace $Enums {
  export const UserRole: {
  super_admin: 'super_admin',
  company_admin: 'company_admin',
  admin: 'admin',
  user: 'user'
};

export type UserRole = (typeof UserRole)[keyof typeof UserRole]


export const ProcessStatus: {
  under_approval: 'under_approval',
  approved: 'approved',
  rejected: 'rejected',
  submitted: 'submitted',
  created: 'created',
  not_appear: 'not_appear'
};

export type ProcessStatus = (typeof ProcessStatus)[keyof typeof ProcessStatus]


export const Gender: {
  male: 'male',
  female: 'female',
  others: 'others'
};

export type Gender = (typeof Gender)[keyof typeof Gender]


export const OtpPurpose: {
  login: 'login',
  password_reset: 'password_reset',
  verify_email: 'verify_email',
  others: 'others'
};

export type OtpPurpose = (typeof OtpPurpose)[keyof typeof OtpPurpose]


export const aboutType: {
  lcp: 'lcp',
  project: 'project'
};

export type aboutType = (typeof aboutType)[keyof typeof aboutType]


export const ReportType: {
  lcp: 'lcp',
  powerbi: 'powerbi'
};

export type ReportType = (typeof ReportType)[keyof typeof ReportType]


export const ClauseType: {
  where: 'where',
  having: 'having'
};

export type ClauseType = (typeof ClauseType)[keyof typeof ClauseType]


export const RecipientType: {
  tag: 'tag',
  user_id: 'user_id',
  custom: 'custom'
};

export type RecipientType = (typeof RecipientType)[keyof typeof RecipientType]


export const sendMailType: {
  cc: 'cc',
  bcc: 'bcc'
};

export type sendMailType = (typeof sendMailType)[keyof typeof sendMailType]


export const NotificationType: {
  email: 'email',
  whatsapp: 'whatsapp'
};

export type NotificationType = (typeof NotificationType)[keyof typeof NotificationType]


export const ApproverType: {
  tag: 'tag',
  user_id: 'user_id',
  role_id: 'role_id'
};

export type ApproverType = (typeof ApproverType)[keyof typeof ApproverType]


export const ApprovalStatus: {
  pending: 'pending',
  approval_needed: 'approval_needed',
  approval_completed: 'approval_completed',
  approval_rejected: 'approval_rejected',
  void: 'void'
};

export type ApprovalStatus = (typeof ApprovalStatus)[keyof typeof ApprovalStatus]

}

export type UserRole = $Enums.UserRole

export const UserRole: typeof $Enums.UserRole

export type ProcessStatus = $Enums.ProcessStatus

export const ProcessStatus: typeof $Enums.ProcessStatus

export type Gender = $Enums.Gender

export const Gender: typeof $Enums.Gender

export type OtpPurpose = $Enums.OtpPurpose

export const OtpPurpose: typeof $Enums.OtpPurpose

export type aboutType = $Enums.aboutType

export const aboutType: typeof $Enums.aboutType

export type ReportType = $Enums.ReportType

export const ReportType: typeof $Enums.ReportType

export type ClauseType = $Enums.ClauseType

export const ClauseType: typeof $Enums.ClauseType

export type RecipientType = $Enums.RecipientType

export const RecipientType: typeof $Enums.RecipientType

export type sendMailType = $Enums.sendMailType

export const sendMailType: typeof $Enums.sendMailType

export type NotificationType = $Enums.NotificationType

export const NotificationType: typeof $Enums.NotificationType

export type ApproverType = $Enums.ApproverType

export const ApproverType: typeof $Enums.ApproverType

export type ApprovalStatus = $Enums.ApprovalStatus

export const ApprovalStatus: typeof $Enums.ApprovalStatus

/**
 * ##  Prisma Client ʲˢ
 * 
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Users
 * const users = await prisma.user.findMany()
 * ```
 *
 * 
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  T extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof T ? T['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<T['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   * 
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Users
   * const users = await prisma.user.findMany()
   * ```
   *
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<T, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<'extends', Prisma.TypeMapCb, ExtArgs>

      /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<ExtArgs>;

  /**
   * `prisma.userDetail`: Exposes CRUD operations for the **UserDetail** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserDetails
    * const userDetails = await prisma.userDetail.findMany()
    * ```
    */
  get userDetail(): Prisma.UserDetailDelegate<ExtArgs>;

  /**
   * `prisma.designation`: Exposes CRUD operations for the **Designation** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Designations
    * const designations = await prisma.designation.findMany()
    * ```
    */
  get designation(): Prisma.DesignationDelegate<ExtArgs>;

  /**
   * `prisma.department`: Exposes CRUD operations for the **Department** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Departments
    * const departments = await prisma.department.findMany()
    * ```
    */
  get department(): Prisma.DepartmentDelegate<ExtArgs>;

  /**
   * `prisma.requestLog`: Exposes CRUD operations for the **RequestLog** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more RequestLogs
    * const requestLogs = await prisma.requestLog.findMany()
    * ```
    */
  get requestLog(): Prisma.RequestLogDelegate<ExtArgs>;

  /**
   * `prisma.financialYear`: Exposes CRUD operations for the **FinancialYear** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more FinancialYears
    * const financialYears = await prisma.financialYear.findMany()
    * ```
    */
  get financialYear(): Prisma.FinancialYearDelegate<ExtArgs>;

  /**
   * `prisma.documentSequence`: Exposes CRUD operations for the **DocumentSequence** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more DocumentSequences
    * const documentSequences = await prisma.documentSequence.findMany()
    * ```
    */
  get documentSequence(): Prisma.DocumentSequenceDelegate<ExtArgs>;

  /**
   * `prisma.auditLog`: Exposes CRUD operations for the **AuditLog** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more AuditLogs
    * const auditLogs = await prisma.auditLog.findMany()
    * ```
    */
  get auditLog(): Prisma.AuditLogDelegate<ExtArgs>;

  /**
   * `prisma.permissions`: Exposes CRUD operations for the **Permissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Permissions
    * const permissions = await prisma.permissions.findMany()
    * ```
    */
  get permissions(): Prisma.PermissionsDelegate<ExtArgs>;

  /**
   * `prisma.role`: Exposes CRUD operations for the **Role** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Roles
    * const roles = await prisma.role.findMany()
    * ```
    */
  get role(): Prisma.RoleDelegate<ExtArgs>;

  /**
   * `prisma.rolePermissions`: Exposes CRUD operations for the **RolePermissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more RolePermissions
    * const rolePermissions = await prisma.rolePermissions.findMany()
    * ```
    */
  get rolePermissions(): Prisma.RolePermissionsDelegate<ExtArgs>;

  /**
   * `prisma.userRoles`: Exposes CRUD operations for the **UserRoles** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserRoles
    * const userRoles = await prisma.userRoles.findMany()
    * ```
    */
  get userRoles(): Prisma.UserRolesDelegate<ExtArgs>;

  /**
   * `prisma.userPermissions`: Exposes CRUD operations for the **UserPermissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserPermissions
    * const userPermissions = await prisma.userPermissions.findMany()
    * ```
    */
  get userPermissions(): Prisma.UserPermissionsDelegate<ExtArgs>;

  /**
   * `prisma.otp`: Exposes CRUD operations for the **Otp** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Otps
    * const otps = await prisma.otp.findMany()
    * ```
    */
  get otp(): Prisma.OtpDelegate<ExtArgs>;

  /**
   * `prisma.language`: Exposes CRUD operations for the **Language** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Languages
    * const languages = await prisma.language.findMany()
    * ```
    */
  get language(): Prisma.LanguageDelegate<ExtArgs>;

  /**
   * `prisma.languageContent`: Exposes CRUD operations for the **LanguageContent** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more LanguageContents
    * const languageContents = await prisma.languageContent.findMany()
    * ```
    */
  get languageContent(): Prisma.LanguageContentDelegate<ExtArgs>;

  /**
   * `prisma.menus`: Exposes CRUD operations for the **Menus** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Menus
    * const menus = await prisma.menus.findMany()
    * ```
    */
  get menus(): Prisma.MenusDelegate<ExtArgs>;

  /**
   * `prisma.menuItems`: Exposes CRUD operations for the **MenuItems** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MenuItems
    * const menuItems = await prisma.menuItems.findMany()
    * ```
    */
  get menuItems(): Prisma.MenuItemsDelegate<ExtArgs>;

  /**
   * `prisma.actionType`: Exposes CRUD operations for the **ActionType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ActionTypes
    * const actionTypes = await prisma.actionType.findMany()
    * ```
    */
  get actionType(): Prisma.ActionTypeDelegate<ExtArgs>;

  /**
   * `prisma.entityType`: Exposes CRUD operations for the **EntityType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EntityTypes
    * const entityTypes = await prisma.entityType.findMany()
    * ```
    */
  get entityType(): Prisma.EntityTypeDelegate<ExtArgs>;

  /**
   * `prisma.wizardGroup`: Exposes CRUD operations for the **WizardGroup** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WizardGroups
    * const wizardGroups = await prisma.wizardGroup.findMany()
    * ```
    */
  get wizardGroup(): Prisma.WizardGroupDelegate<ExtArgs>;

  /**
   * `prisma.wizardType`: Exposes CRUD operations for the **WizardType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WizardTypes
    * const wizardTypes = await prisma.wizardType.findMany()
    * ```
    */
  get wizardType(): Prisma.WizardTypeDelegate<ExtArgs>;

  /**
   * `prisma.aboutLCP`: Exposes CRUD operations for the **AboutLCP** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more AboutLCPS
    * const aboutLCPS = await prisma.aboutLCP.findMany()
    * ```
    */
  get aboutLCP(): Prisma.AboutLCPDelegate<ExtArgs>;

  /**
   * `prisma.masterEntity`: Exposes CRUD operations for the **MasterEntity** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MasterEntities
    * const masterEntities = await prisma.masterEntity.findMany()
    * ```
    */
  get masterEntity(): Prisma.MasterEntityDelegate<ExtArgs>;

  /**
   * `prisma.masterEntityLineItem`: Exposes CRUD operations for the **MasterEntityLineItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MasterEntityLineItems
    * const masterEntityLineItems = await prisma.masterEntityLineItem.findMany()
    * ```
    */
  get masterEntityLineItem(): Prisma.MasterEntityLineItemDelegate<ExtArgs>;

  /**
   * `prisma.fieldType`: Exposes CRUD operations for the **FieldType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more FieldTypes
    * const fieldTypes = await prisma.fieldType.findMany()
    * ```
    */
  get fieldType(): Prisma.FieldTypeDelegate<ExtArgs>;

  /**
   * `prisma.menuType`: Exposes CRUD operations for the **menuType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MenuTypes
    * const menuTypes = await prisma.menuType.findMany()
    * ```
    */
  get menuType(): Prisma.menuTypeDelegate<ExtArgs>;

  /**
   * `prisma.emailTemplateProcess`: Exposes CRUD operations for the **EmailTemplateProcess** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmailTemplateProcesses
    * const emailTemplateProcesses = await prisma.emailTemplateProcess.findMany()
    * ```
    */
  get emailTemplateProcess(): Prisma.EmailTemplateProcessDelegate<ExtArgs>;

  /**
   * `prisma.emailTemplateTag`: Exposes CRUD operations for the **EmailTemplateTag** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmailTemplateTags
    * const emailTemplateTags = await prisma.emailTemplateTag.findMany()
    * ```
    */
  get emailTemplateTag(): Prisma.EmailTemplateTagDelegate<ExtArgs>;

  /**
   * `prisma.emailTemplateRecipientTag`: Exposes CRUD operations for the **EmailTemplateRecipientTag** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmailTemplateRecipientTags
    * const emailTemplateRecipientTags = await prisma.emailTemplateRecipientTag.findMany()
    * ```
    */
  get emailTemplateRecipientTag(): Prisma.EmailTemplateRecipientTagDelegate<ExtArgs>;

  /**
   * `prisma.emailTemplateProcessTagsMapping`: Exposes CRUD operations for the **EmailTemplateProcessTagsMapping** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmailTemplateProcessTagsMappings
    * const emailTemplateProcessTagsMappings = await prisma.emailTemplateProcessTagsMapping.findMany()
    * ```
    */
  get emailTemplateProcessTagsMapping(): Prisma.EmailTemplateProcessTagsMappingDelegate<ExtArgs>;

  /**
   * `prisma.emailTemplate`: Exposes CRUD operations for the **EmailTemplate** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmailTemplates
    * const emailTemplates = await prisma.emailTemplate.findMany()
    * ```
    */
  get emailTemplate(): Prisma.EmailTemplateDelegate<ExtArgs>;

  /**
   * `prisma.emailTemplateAssignment`: Exposes CRUD operations for the **EmailTemplateAssignment** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmailTemplateAssignments
    * const emailTemplateAssignments = await prisma.emailTemplateAssignment.findMany()
    * ```
    */
  get emailTemplateAssignment(): Prisma.EmailTemplateAssignmentDelegate<ExtArgs>;

  /**
   * `prisma.emailTemplateCcBcc`: Exposes CRUD operations for the **EmailTemplateCcBcc** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmailTemplateCcBccs
    * const emailTemplateCcBccs = await prisma.emailTemplateCcBcc.findMany()
    * ```
    */
  get emailTemplateCcBcc(): Prisma.EmailTemplateCcBccDelegate<ExtArgs>;

  /**
   * `prisma.emailProcessJob`: Exposes CRUD operations for the **EmailProcessJob** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmailProcessJobs
    * const emailProcessJobs = await prisma.emailProcessJob.findMany()
    * ```
    */
  get emailProcessJob(): Prisma.EmailProcessJobDelegate<ExtArgs>;

  /**
   * `prisma.whatsappProcessJob`: Exposes CRUD operations for the **WhatsappProcessJob** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WhatsappProcessJobs
    * const whatsappProcessJobs = await prisma.whatsappProcessJob.findMany()
    * ```
    */
  get whatsappProcessJob(): Prisma.WhatsappProcessJobDelegate<ExtArgs>;

  /**
   * `prisma.whatsappTemplateProcess`: Exposes CRUD operations for the **WhatsappTemplateProcess** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WhatsappTemplateProcesses
    * const whatsappTemplateProcesses = await prisma.whatsappTemplateProcess.findMany()
    * ```
    */
  get whatsappTemplateProcess(): Prisma.WhatsappTemplateProcessDelegate<ExtArgs>;

  /**
   * `prisma.whatsappTemplateTag`: Exposes CRUD operations for the **WhatsappTemplateTag** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WhatsappTemplateTags
    * const whatsappTemplateTags = await prisma.whatsappTemplateTag.findMany()
    * ```
    */
  get whatsappTemplateTag(): Prisma.WhatsappTemplateTagDelegate<ExtArgs>;

  /**
   * `prisma.whatsappTemplateRecipientTag`: Exposes CRUD operations for the **WhatsappTemplateRecipientTag** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WhatsappTemplateRecipientTags
    * const whatsappTemplateRecipientTags = await prisma.whatsappTemplateRecipientTag.findMany()
    * ```
    */
  get whatsappTemplateRecipientTag(): Prisma.WhatsappTemplateRecipientTagDelegate<ExtArgs>;

  /**
   * `prisma.whatsappTemplateProcessTagsMapping`: Exposes CRUD operations for the **WhatsappTemplateProcessTagsMapping** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WhatsappTemplateProcessTagsMappings
    * const whatsappTemplateProcessTagsMappings = await prisma.whatsappTemplateProcessTagsMapping.findMany()
    * ```
    */
  get whatsappTemplateProcessTagsMapping(): Prisma.WhatsappTemplateProcessTagsMappingDelegate<ExtArgs>;

  /**
   * `prisma.whatsappTemplate`: Exposes CRUD operations for the **WhatsappTemplate** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WhatsappTemplates
    * const whatsappTemplates = await prisma.whatsappTemplate.findMany()
    * ```
    */
  get whatsappTemplate(): Prisma.WhatsappTemplateDelegate<ExtArgs>;

  /**
   * `prisma.whatsappTemplateAssignment`: Exposes CRUD operations for the **WhatsappTemplateAssignment** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WhatsappTemplateAssignments
    * const whatsappTemplateAssignments = await prisma.whatsappTemplateAssignment.findMany()
    * ```
    */
  get whatsappTemplateAssignment(): Prisma.WhatsappTemplateAssignmentDelegate<ExtArgs>;

  /**
   * `prisma.notificationJob`: Exposes CRUD operations for the **NotificationJob** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more NotificationJobs
    * const notificationJobs = await prisma.notificationJob.findMany()
    * ```
    */
  get notificationJob(): Prisma.NotificationJobDelegate<ExtArgs>;

  /**
   * `prisma.carouselTemplate`: Exposes CRUD operations for the **CarouselTemplate** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more CarouselTemplates
    * const carouselTemplates = await prisma.carouselTemplate.findMany()
    * ```
    */
  get carouselTemplate(): Prisma.CarouselTemplateDelegate<ExtArgs>;

  /**
   * `prisma.carouselTemplateLineItem`: Exposes CRUD operations for the **CarouselTemplateLineItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more CarouselTemplateLineItems
    * const carouselTemplateLineItems = await prisma.carouselTemplateLineItem.findMany()
    * ```
    */
  get carouselTemplateLineItem(): Prisma.CarouselTemplateLineItemDelegate<ExtArgs>;

  /**
   * `prisma.importTemplate`: Exposes CRUD operations for the **ImportTemplate** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ImportTemplates
    * const importTemplates = await prisma.importTemplate.findMany()
    * ```
    */
  get importTemplate(): Prisma.ImportTemplateDelegate<ExtArgs>;

  /**
   * `prisma.importTemplateLineItem`: Exposes CRUD operations for the **ImportTemplateLineItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ImportTemplateLineItems
    * const importTemplateLineItems = await prisma.importTemplateLineItem.findMany()
    * ```
    */
  get importTemplateLineItem(): Prisma.ImportTemplateLineItemDelegate<ExtArgs>;

  /**
   * `prisma.importTemplateQueries`: Exposes CRUD operations for the **ImportTemplateQueries** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ImportTemplateQueries
    * const importTemplateQueries = await prisma.importTemplateQueries.findMany()
    * ```
    */
  get importTemplateQueries(): Prisma.ImportTemplateQueriesDelegate<ExtArgs>;

  /**
   * `prisma.importJob`: Exposes CRUD operations for the **ImportJob** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ImportJobs
    * const importJobs = await prisma.importJob.findMany()
    * ```
    */
  get importJob(): Prisma.ImportJobDelegate<ExtArgs>;

  /**
   * `prisma.importJobLineItem`: Exposes CRUD operations for the **ImportJobLineItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ImportJobLineItems
    * const importJobLineItems = await prisma.importJobLineItem.findMany()
    * ```
    */
  get importJobLineItem(): Prisma.ImportJobLineItemDelegate<ExtArgs>;

  /**
   * `prisma.exportTemplate`: Exposes CRUD operations for the **ExportTemplate** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ExportTemplates
    * const exportTemplates = await prisma.exportTemplate.findMany()
    * ```
    */
  get exportTemplate(): Prisma.ExportTemplateDelegate<ExtArgs>;

  /**
   * `prisma.exportTemplateLineItem`: Exposes CRUD operations for the **ExportTemplateLineItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ExportTemplateLineItems
    * const exportTemplateLineItems = await prisma.exportTemplateLineItem.findMany()
    * ```
    */
  get exportTemplateLineItem(): Prisma.ExportTemplateLineItemDelegate<ExtArgs>;

  /**
   * `prisma.exportTemplateQueries`: Exposes CRUD operations for the **ExportTemplateQueries** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ExportTemplateQueries
    * const exportTemplateQueries = await prisma.exportTemplateQueries.findMany()
    * ```
    */
  get exportTemplateQueries(): Prisma.ExportTemplateQueriesDelegate<ExtArgs>;

  /**
   * `prisma.status`: Exposes CRUD operations for the **Status** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Statuses
    * const statuses = await prisma.status.findMany()
    * ```
    */
  get status(): Prisma.StatusDelegate<ExtArgs>;

  /**
   * `prisma.categoryTypes`: Exposes CRUD operations for the **CategoryTypes** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more CategoryTypes
    * const categoryTypes = await prisma.categoryTypes.findMany()
    * ```
    */
  get categoryTypes(): Prisma.CategoryTypesDelegate<ExtArgs>;

  /**
   * `prisma.categories`: Exposes CRUD operations for the **Categories** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Categories
    * const categories = await prisma.categories.findMany()
    * ```
    */
  get categories(): Prisma.CategoriesDelegate<ExtArgs>;

  /**
   * `prisma.configurations`: Exposes CRUD operations for the **Configurations** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Configurations
    * const configurations = await prisma.configurations.findMany()
    * ```
    */
  get configurations(): Prisma.ConfigurationsDelegate<ExtArgs>;

  /**
   * `prisma.userConfigurations`: Exposes CRUD operations for the **UserConfigurations** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserConfigurations
    * const userConfigurations = await prisma.userConfigurations.findMany()
    * ```
    */
  get userConfigurations(): Prisma.UserConfigurationsDelegate<ExtArgs>;

  /**
   * `prisma.fileUploadLog`: Exposes CRUD operations for the **FileUploadLog** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more FileUploadLogs
    * const fileUploadLogs = await prisma.fileUploadLog.findMany()
    * ```
    */
  get fileUploadLog(): Prisma.FileUploadLogDelegate<ExtArgs>;

  /**
   * `prisma.dataTransferQueries`: Exposes CRUD operations for the **DataTransferQueries** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more DataTransferQueries
    * const dataTransferQueries = await prisma.dataTransferQueries.findMany()
    * ```
    */
  get dataTransferQueries(): Prisma.DataTransferQueriesDelegate<ExtArgs>;

  /**
   * `prisma.deviceRegistration`: Exposes CRUD operations for the **DeviceRegistration** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more DeviceRegistrations
    * const deviceRegistrations = await prisma.deviceRegistration.findMany()
    * ```
    */
  get deviceRegistration(): Prisma.DeviceRegistrationDelegate<ExtArgs>;

  /**
   * `prisma.policies`: Exposes CRUD operations for the **Policies** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Policies
    * const policies = await prisma.policies.findMany()
    * ```
    */
  get policies(): Prisma.PoliciesDelegate<ExtArgs>;

  /**
   * `prisma.userPolicies`: Exposes CRUD operations for the **UserPolicies** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserPolicies
    * const userPolicies = await prisma.userPolicies.findMany()
    * ```
    */
  get userPolicies(): Prisma.UserPoliciesDelegate<ExtArgs>;

  /**
   * `prisma.rolePolicies`: Exposes CRUD operations for the **RolePolicies** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more RolePolicies
    * const rolePolicies = await prisma.rolePolicies.findMany()
    * ```
    */
  get rolePolicies(): Prisma.RolePoliciesDelegate<ExtArgs>;

  /**
   * `prisma.appversions`: Exposes CRUD operations for the **Appversions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Appversions
    * const appversions = await prisma.appversions.findMany()
    * ```
    */
  get appversions(): Prisma.AppversionsDelegate<ExtArgs>;

  /**
   * `prisma.scheduledJob`: Exposes CRUD operations for the **ScheduledJob** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ScheduledJobs
    * const scheduledJobs = await prisma.scheduledJob.findMany()
    * ```
    */
  get scheduledJob(): Prisma.ScheduledJobDelegate<ExtArgs>;

  /**
   * `prisma.scheduledJobLogs`: Exposes CRUD operations for the **ScheduledJobLogs** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ScheduledJobLogs
    * const scheduledJobLogs = await prisma.scheduledJobLogs.findMany()
    * ```
    */
  get scheduledJobLogs(): Prisma.ScheduledJobLogsDelegate<ExtArgs>;

  /**
   * `prisma.approvalWorkflow`: Exposes CRUD operations for the **ApprovalWorkflow** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ApprovalWorkflows
    * const approvalWorkflows = await prisma.approvalWorkflow.findMany()
    * ```
    */
  get approvalWorkflow(): Prisma.ApprovalWorkflowDelegate<ExtArgs>;

  /**
   * `prisma.approvalWorkflowApproverTag`: Exposes CRUD operations for the **ApprovalWorkflowApproverTag** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ApprovalWorkflowApproverTags
    * const approvalWorkflowApproverTags = await prisma.approvalWorkflowApproverTag.findMany()
    * ```
    */
  get approvalWorkflowApproverTag(): Prisma.ApprovalWorkflowApproverTagDelegate<ExtArgs>;

  /**
   * `prisma.approvalWorkflowAssignment`: Exposes CRUD operations for the **ApprovalWorkflowAssignment** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ApprovalWorkflowAssignments
    * const approvalWorkflowAssignments = await prisma.approvalWorkflowAssignment.findMany()
    * ```
    */
  get approvalWorkflowAssignment(): Prisma.ApprovalWorkflowAssignmentDelegate<ExtArgs>;

  /**
   * `prisma.approvalProcessJob`: Exposes CRUD operations for the **ApprovalProcessJob** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ApprovalProcessJobs
    * const approvalProcessJobs = await prisma.approvalProcessJob.findMany()
    * ```
    */
  get approvalProcessJob(): Prisma.ApprovalProcessJobDelegate<ExtArgs>;

  /**
   * `prisma.approvalProcessJobWorkflow`: Exposes CRUD operations for the **ApprovalProcessJobWorkflow** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ApprovalProcessJobWorkflows
    * const approvalProcessJobWorkflows = await prisma.approvalProcessJobWorkflow.findMany()
    * ```
    */
  get approvalProcessJobWorkflow(): Prisma.ApprovalProcessJobWorkflowDelegate<ExtArgs>;

  /**
   * `prisma.approvalProcessJobWorkflowUser`: Exposes CRUD operations for the **ApprovalProcessJobWorkflowUser** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ApprovalProcessJobWorkflowUsers
    * const approvalProcessJobWorkflowUsers = await prisma.approvalProcessJobWorkflowUser.findMany()
    * ```
    */
  get approvalProcessJobWorkflowUser(): Prisma.ApprovalProcessJobWorkflowUserDelegate<ExtArgs>;

  /**
   * `prisma.delegation`: Exposes CRUD operations for the **Delegation** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Delegations
    * const delegations = await prisma.delegation.findMany()
    * ```
    */
  get delegation(): Prisma.DelegationDelegate<ExtArgs>;

  /**
   * `prisma.schemaChunk`: Exposes CRUD operations for the **SchemaChunk** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more SchemaChunks
    * const schemaChunks = await prisma.schemaChunk.findMany()
    * ```
    */
  get schemaChunk(): Prisma.SchemaChunkDelegate<ExtArgs>;

  /**
   * `prisma.embeddingVectorLogs`: Exposes CRUD operations for the **EmbeddingVectorLogs** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more EmbeddingVectorLogs
    * const embeddingVectorLogs = await prisma.embeddingVectorLogs.findMany()
    * ```
    */
  get embeddingVectorLogs(): Prisma.EmbeddingVectorLogsDelegate<ExtArgs>;

  /**
   * `prisma.openaiUsageLog`: Exposes CRUD operations for the **OpenaiUsageLog** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more OpenaiUsageLogs
    * const openaiUsageLogs = await prisma.openaiUsageLog.findMany()
    * ```
    */
  get openaiUsageLog(): Prisma.OpenaiUsageLogDelegate<ExtArgs>;

  /**
   * `prisma.queryExecutionLog`: Exposes CRUD operations for the **QueryExecutionLog** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more QueryExecutionLogs
    * const queryExecutionLogs = await prisma.queryExecutionLog.findMany()
    * ```
    */
  get queryExecutionLog(): Prisma.QueryExecutionLogDelegate<ExtArgs>;

  /**
   * `prisma.childProcess`: Exposes CRUD operations for the **ChildProcess** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ChildProcesses
    * const childProcesses = await prisma.childProcess.findMany()
    * ```
    */
  get childProcess(): Prisma.ChildProcessDelegate<ExtArgs>;

  /**
   * `prisma.childProcessLog`: Exposes CRUD operations for the **ChildProcessLog** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ChildProcessLogs
    * const childProcessLogs = await prisma.childProcessLog.findMany()
    * ```
    */
  get childProcessLog(): Prisma.ChildProcessLogDelegate<ExtArgs>;

  /**
   * `prisma.organizations`: Exposes CRUD operations for the **Organizations** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Organizations
    * const organizations = await prisma.organizations.findMany()
    * ```
    */
  get organizations(): Prisma.OrganizationsDelegate<ExtArgs>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError
  export import NotFoundError = runtime.NotFoundError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql

  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics 
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 5.14.0
   * Query Engine version: e9771e62de70f79a5e1c604a2d7c8e2a0a874b48
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion 

  /**
   * Utility Types
   */

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches a JSON object.
   * This type can be useful to enforce some input to be JSON-compatible or as a super-type to be extended from. 
   */
  export type JsonObject = {[Key in string]?: JsonValue}

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches a JSON array.
   */
  export interface JsonArray extends Array<JsonValue> {}

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches any valid JSON value.
   */
  export type JsonValue = string | number | boolean | JsonObject | JsonArray | null

  /**
   * Matches a JSON object.
   * Unlike `JsonObject`, this type allows undefined and read-only properties.
   */
  export type InputJsonObject = {readonly [Key in string]?: InputJsonValue | null}

  /**
   * Matches a JSON array.
   * Unlike `JsonArray`, readonly arrays are assignable to this type.
   */
  export interface InputJsonArray extends ReadonlyArray<InputJsonValue | null> {}

  /**
   * Matches any valid value that can be used as an input for operations like
   * create and update as the value of a JSON field. Unlike `JsonValue`, this
   * type allows read-only arrays and read-only object properties and disallows
   * `null` at the top level.
   *
   * `null` cannot be used as the value of a JSON field because its meaning
   * would be ambiguous. Use `Prisma.JsonNull` to store the JSON null value or
   * `Prisma.DbNull` to clear the JSON value and set the field to the database
   * NULL value instead.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-by-null-values
   */
  export type InputJsonValue = string | number | boolean | InputJsonObject | InputJsonArray | { toJSON(): unknown }

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    User: 'User',
    UserDetail: 'UserDetail',
    Designation: 'Designation',
    Department: 'Department',
    RequestLog: 'RequestLog',
    FinancialYear: 'FinancialYear',
    DocumentSequence: 'DocumentSequence',
    AuditLog: 'AuditLog',
    Permissions: 'Permissions',
    Role: 'Role',
    RolePermissions: 'RolePermissions',
    UserRoles: 'UserRoles',
    UserPermissions: 'UserPermissions',
    Otp: 'Otp',
    Language: 'Language',
    LanguageContent: 'LanguageContent',
    Menus: 'Menus',
    MenuItems: 'MenuItems',
    ActionType: 'ActionType',
    EntityType: 'EntityType',
    WizardGroup: 'WizardGroup',
    WizardType: 'WizardType',
    AboutLCP: 'AboutLCP',
    MasterEntity: 'MasterEntity',
    MasterEntityLineItem: 'MasterEntityLineItem',
    FieldType: 'FieldType',
    menuType: 'menuType',
    EmailTemplateProcess: 'EmailTemplateProcess',
    EmailTemplateTag: 'EmailTemplateTag',
    EmailTemplateRecipientTag: 'EmailTemplateRecipientTag',
    EmailTemplateProcessTagsMapping: 'EmailTemplateProcessTagsMapping',
    EmailTemplate: 'EmailTemplate',
    EmailTemplateAssignment: 'EmailTemplateAssignment',
    EmailTemplateCcBcc: 'EmailTemplateCcBcc',
    EmailProcessJob: 'EmailProcessJob',
    WhatsappProcessJob: 'WhatsappProcessJob',
    WhatsappTemplateProcess: 'WhatsappTemplateProcess',
    WhatsappTemplateTag: 'WhatsappTemplateTag',
    WhatsappTemplateRecipientTag: 'WhatsappTemplateRecipientTag',
    WhatsappTemplateProcessTagsMapping: 'WhatsappTemplateProcessTagsMapping',
    WhatsappTemplate: 'WhatsappTemplate',
    WhatsappTemplateAssignment: 'WhatsappTemplateAssignment',
    NotificationJob: 'NotificationJob',
    CarouselTemplate: 'CarouselTemplate',
    CarouselTemplateLineItem: 'CarouselTemplateLineItem',
    ImportTemplate: 'ImportTemplate',
    ImportTemplateLineItem: 'ImportTemplateLineItem',
    ImportTemplateQueries: 'ImportTemplateQueries',
    ImportJob: 'ImportJob',
    ImportJobLineItem: 'ImportJobLineItem',
    ExportTemplate: 'ExportTemplate',
    ExportTemplateLineItem: 'ExportTemplateLineItem',
    ExportTemplateQueries: 'ExportTemplateQueries',
    Status: 'Status',
    CategoryTypes: 'CategoryTypes',
    Categories: 'Categories',
    Configurations: 'Configurations',
    UserConfigurations: 'UserConfigurations',
    FileUploadLog: 'FileUploadLog',
    DataTransferQueries: 'DataTransferQueries',
    DeviceRegistration: 'DeviceRegistration',
    Policies: 'Policies',
    UserPolicies: 'UserPolicies',
    RolePolicies: 'RolePolicies',
    Appversions: 'Appversions',
    ScheduledJob: 'ScheduledJob',
    ScheduledJobLogs: 'ScheduledJobLogs',
    ApprovalWorkflow: 'ApprovalWorkflow',
    ApprovalWorkflowApproverTag: 'ApprovalWorkflowApproverTag',
    ApprovalWorkflowAssignment: 'ApprovalWorkflowAssignment',
    ApprovalProcessJob: 'ApprovalProcessJob',
    ApprovalProcessJobWorkflow: 'ApprovalProcessJobWorkflow',
    ApprovalProcessJobWorkflowUser: 'ApprovalProcessJobWorkflowUser',
    Delegation: 'Delegation',
    SchemaChunk: 'SchemaChunk',
    EmbeddingVectorLogs: 'EmbeddingVectorLogs',
    OpenaiUsageLog: 'OpenaiUsageLog',
    QueryExecutionLog: 'QueryExecutionLog',
    ChildProcess: 'ChildProcess',
    ChildProcessLog: 'ChildProcessLog',
    Organizations: 'Organizations'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }


  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs}, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    meta: {
      modelProps: 'user' | 'userDetail' | 'designation' | 'department' | 'requestLog' | 'financialYear' | 'documentSequence' | 'auditLog' | 'permissions' | 'role' | 'rolePermissions' | 'userRoles' | 'userPermissions' | 'otp' | 'language' | 'languageContent' | 'menus' | 'menuItems' | 'actionType' | 'entityType' | 'wizardGroup' | 'wizardType' | 'aboutLCP' | 'masterEntity' | 'masterEntityLineItem' | 'fieldType' | 'menuType' | 'emailTemplateProcess' | 'emailTemplateTag' | 'emailTemplateRecipientTag' | 'emailTemplateProcessTagsMapping' | 'emailTemplate' | 'emailTemplateAssignment' | 'emailTemplateCcBcc' | 'emailProcessJob' | 'whatsappProcessJob' | 'whatsappTemplateProcess' | 'whatsappTemplateTag' | 'whatsappTemplateRecipientTag' | 'whatsappTemplateProcessTagsMapping' | 'whatsappTemplate' | 'whatsappTemplateAssignment' | 'notificationJob' | 'carouselTemplate' | 'carouselTemplateLineItem' | 'importTemplate' | 'importTemplateLineItem' | 'importTemplateQueries' | 'importJob' | 'importJobLineItem' | 'exportTemplate' | 'exportTemplateLineItem' | 'exportTemplateQueries' | 'status' | 'categoryTypes' | 'categories' | 'configurations' | 'userConfigurations' | 'fileUploadLog' | 'dataTransferQueries' | 'deviceRegistration' | 'policies' | 'userPolicies' | 'rolePolicies' | 'appversions' | 'scheduledJob' | 'scheduledJobLogs' | 'approvalWorkflow' | 'approvalWorkflowApproverTag' | 'approvalWorkflowAssignment' | 'approvalProcessJob' | 'approvalProcessJobWorkflow' | 'approvalProcessJobWorkflowUser' | 'delegation' | 'schemaChunk' | 'embeddingVectorLogs' | 'openaiUsageLog' | 'queryExecutionLog' | 'childProcess' | 'childProcessLog' | 'organizations'
      txIsolationLevel: Prisma.TransactionIsolationLevel
    },
    model: {
      User: {
        payload: Prisma.$UserPayload<ExtArgs>
        fields: Prisma.UserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findFirst: {
            args: Prisma.UserFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findMany: {
            args: Prisma.UserFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          create: {
            args: Prisma.UserCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          createMany: {
            args: Prisma.UserCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          delete: {
            args: Prisma.UserDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          update: {
            args: Prisma.UserUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          deleteMany: {
            args: Prisma.UserDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.UserGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserCountArgs<ExtArgs>,
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      UserDetail: {
        payload: Prisma.$UserDetailPayload<ExtArgs>
        fields: Prisma.UserDetailFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserDetailFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserDetailFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          findFirst: {
            args: Prisma.UserDetailFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserDetailFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          findMany: {
            args: Prisma.UserDetailFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>[]
          }
          create: {
            args: Prisma.UserDetailCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          createMany: {
            args: Prisma.UserDetailCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserDetailCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>[]
          }
          delete: {
            args: Prisma.UserDetailDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          update: {
            args: Prisma.UserDetailUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          deleteMany: {
            args: Prisma.UserDetailDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserDetailUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserDetailUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          aggregate: {
            args: Prisma.UserDetailAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUserDetail>
          }
          groupBy: {
            args: Prisma.UserDetailGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserDetailGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserDetailCountArgs<ExtArgs>,
            result: $Utils.Optional<UserDetailCountAggregateOutputType> | number
          }
        }
      }
      Designation: {
        payload: Prisma.$DesignationPayload<ExtArgs>
        fields: Prisma.DesignationFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DesignationFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DesignationFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          findFirst: {
            args: Prisma.DesignationFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DesignationFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          findMany: {
            args: Prisma.DesignationFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>[]
          }
          create: {
            args: Prisma.DesignationCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          createMany: {
            args: Prisma.DesignationCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.DesignationCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>[]
          }
          delete: {
            args: Prisma.DesignationDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          update: {
            args: Prisma.DesignationUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          deleteMany: {
            args: Prisma.DesignationDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.DesignationUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.DesignationUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          aggregate: {
            args: Prisma.DesignationAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateDesignation>
          }
          groupBy: {
            args: Prisma.DesignationGroupByArgs<ExtArgs>,
            result: $Utils.Optional<DesignationGroupByOutputType>[]
          }
          count: {
            args: Prisma.DesignationCountArgs<ExtArgs>,
            result: $Utils.Optional<DesignationCountAggregateOutputType> | number
          }
        }
      }
      Department: {
        payload: Prisma.$DepartmentPayload<ExtArgs>
        fields: Prisma.DepartmentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DepartmentFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DepartmentFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          findFirst: {
            args: Prisma.DepartmentFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DepartmentFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          findMany: {
            args: Prisma.DepartmentFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>[]
          }
          create: {
            args: Prisma.DepartmentCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          createMany: {
            args: Prisma.DepartmentCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.DepartmentCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>[]
          }
          delete: {
            args: Prisma.DepartmentDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          update: {
            args: Prisma.DepartmentUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          deleteMany: {
            args: Prisma.DepartmentDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.DepartmentUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.DepartmentUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          aggregate: {
            args: Prisma.DepartmentAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateDepartment>
          }
          groupBy: {
            args: Prisma.DepartmentGroupByArgs<ExtArgs>,
            result: $Utils.Optional<DepartmentGroupByOutputType>[]
          }
          count: {
            args: Prisma.DepartmentCountArgs<ExtArgs>,
            result: $Utils.Optional<DepartmentCountAggregateOutputType> | number
          }
        }
      }
      RequestLog: {
        payload: Prisma.$RequestLogPayload<ExtArgs>
        fields: Prisma.RequestLogFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RequestLogFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RequestLogFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload>
          }
          findFirst: {
            args: Prisma.RequestLogFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RequestLogFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload>
          }
          findMany: {
            args: Prisma.RequestLogFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload>[]
          }
          create: {
            args: Prisma.RequestLogCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload>
          }
          createMany: {
            args: Prisma.RequestLogCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RequestLogCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload>[]
          }
          delete: {
            args: Prisma.RequestLogDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload>
          }
          update: {
            args: Prisma.RequestLogUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload>
          }
          deleteMany: {
            args: Prisma.RequestLogDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.RequestLogUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.RequestLogUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RequestLogPayload>
          }
          aggregate: {
            args: Prisma.RequestLogAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateRequestLog>
          }
          groupBy: {
            args: Prisma.RequestLogGroupByArgs<ExtArgs>,
            result: $Utils.Optional<RequestLogGroupByOutputType>[]
          }
          count: {
            args: Prisma.RequestLogCountArgs<ExtArgs>,
            result: $Utils.Optional<RequestLogCountAggregateOutputType> | number
          }
        }
      }
      FinancialYear: {
        payload: Prisma.$FinancialYearPayload<ExtArgs>
        fields: Prisma.FinancialYearFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FinancialYearFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FinancialYearFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload>
          }
          findFirst: {
            args: Prisma.FinancialYearFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FinancialYearFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload>
          }
          findMany: {
            args: Prisma.FinancialYearFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload>[]
          }
          create: {
            args: Prisma.FinancialYearCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload>
          }
          createMany: {
            args: Prisma.FinancialYearCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.FinancialYearCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload>[]
          }
          delete: {
            args: Prisma.FinancialYearDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload>
          }
          update: {
            args: Prisma.FinancialYearUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload>
          }
          deleteMany: {
            args: Prisma.FinancialYearDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.FinancialYearUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.FinancialYearUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FinancialYearPayload>
          }
          aggregate: {
            args: Prisma.FinancialYearAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateFinancialYear>
          }
          groupBy: {
            args: Prisma.FinancialYearGroupByArgs<ExtArgs>,
            result: $Utils.Optional<FinancialYearGroupByOutputType>[]
          }
          count: {
            args: Prisma.FinancialYearCountArgs<ExtArgs>,
            result: $Utils.Optional<FinancialYearCountAggregateOutputType> | number
          }
        }
      }
      DocumentSequence: {
        payload: Prisma.$DocumentSequencePayload<ExtArgs>
        fields: Prisma.DocumentSequenceFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DocumentSequenceFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DocumentSequenceFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload>
          }
          findFirst: {
            args: Prisma.DocumentSequenceFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DocumentSequenceFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload>
          }
          findMany: {
            args: Prisma.DocumentSequenceFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload>[]
          }
          create: {
            args: Prisma.DocumentSequenceCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload>
          }
          createMany: {
            args: Prisma.DocumentSequenceCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.DocumentSequenceCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload>[]
          }
          delete: {
            args: Prisma.DocumentSequenceDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload>
          }
          update: {
            args: Prisma.DocumentSequenceUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload>
          }
          deleteMany: {
            args: Prisma.DocumentSequenceDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.DocumentSequenceUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.DocumentSequenceUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DocumentSequencePayload>
          }
          aggregate: {
            args: Prisma.DocumentSequenceAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateDocumentSequence>
          }
          groupBy: {
            args: Prisma.DocumentSequenceGroupByArgs<ExtArgs>,
            result: $Utils.Optional<DocumentSequenceGroupByOutputType>[]
          }
          count: {
            args: Prisma.DocumentSequenceCountArgs<ExtArgs>,
            result: $Utils.Optional<DocumentSequenceCountAggregateOutputType> | number
          }
        }
      }
      AuditLog: {
        payload: Prisma.$AuditLogPayload<ExtArgs>
        fields: Prisma.AuditLogFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AuditLogFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AuditLogFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload>
          }
          findFirst: {
            args: Prisma.AuditLogFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AuditLogFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload>
          }
          findMany: {
            args: Prisma.AuditLogFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload>[]
          }
          create: {
            args: Prisma.AuditLogCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload>
          }
          createMany: {
            args: Prisma.AuditLogCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.AuditLogCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload>[]
          }
          delete: {
            args: Prisma.AuditLogDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload>
          }
          update: {
            args: Prisma.AuditLogUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload>
          }
          deleteMany: {
            args: Prisma.AuditLogDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.AuditLogUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.AuditLogUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AuditLogPayload>
          }
          aggregate: {
            args: Prisma.AuditLogAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateAuditLog>
          }
          groupBy: {
            args: Prisma.AuditLogGroupByArgs<ExtArgs>,
            result: $Utils.Optional<AuditLogGroupByOutputType>[]
          }
          count: {
            args: Prisma.AuditLogCountArgs<ExtArgs>,
            result: $Utils.Optional<AuditLogCountAggregateOutputType> | number
          }
        }
      }
      Permissions: {
        payload: Prisma.$PermissionsPayload<ExtArgs>
        fields: Prisma.PermissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.PermissionsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.PermissionsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          findFirst: {
            args: Prisma.PermissionsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.PermissionsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          findMany: {
            args: Prisma.PermissionsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>[]
          }
          create: {
            args: Prisma.PermissionsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          createMany: {
            args: Prisma.PermissionsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.PermissionsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>[]
          }
          delete: {
            args: Prisma.PermissionsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          update: {
            args: Prisma.PermissionsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          deleteMany: {
            args: Prisma.PermissionsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.PermissionsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.PermissionsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          aggregate: {
            args: Prisma.PermissionsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregatePermissions>
          }
          groupBy: {
            args: Prisma.PermissionsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<PermissionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.PermissionsCountArgs<ExtArgs>,
            result: $Utils.Optional<PermissionsCountAggregateOutputType> | number
          }
        }
      }
      Role: {
        payload: Prisma.$RolePayload<ExtArgs>
        fields: Prisma.RoleFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RoleFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RoleFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          findFirst: {
            args: Prisma.RoleFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RoleFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          findMany: {
            args: Prisma.RoleFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>[]
          }
          create: {
            args: Prisma.RoleCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          createMany: {
            args: Prisma.RoleCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RoleCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>[]
          }
          delete: {
            args: Prisma.RoleDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          update: {
            args: Prisma.RoleUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          deleteMany: {
            args: Prisma.RoleDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.RoleUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.RoleUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          aggregate: {
            args: Prisma.RoleAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateRole>
          }
          groupBy: {
            args: Prisma.RoleGroupByArgs<ExtArgs>,
            result: $Utils.Optional<RoleGroupByOutputType>[]
          }
          count: {
            args: Prisma.RoleCountArgs<ExtArgs>,
            result: $Utils.Optional<RoleCountAggregateOutputType> | number
          }
        }
      }
      RolePermissions: {
        payload: Prisma.$RolePermissionsPayload<ExtArgs>
        fields: Prisma.RolePermissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RolePermissionsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RolePermissionsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          findFirst: {
            args: Prisma.RolePermissionsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RolePermissionsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          findMany: {
            args: Prisma.RolePermissionsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>[]
          }
          create: {
            args: Prisma.RolePermissionsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          createMany: {
            args: Prisma.RolePermissionsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RolePermissionsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>[]
          }
          delete: {
            args: Prisma.RolePermissionsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          update: {
            args: Prisma.RolePermissionsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          deleteMany: {
            args: Prisma.RolePermissionsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.RolePermissionsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.RolePermissionsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          aggregate: {
            args: Prisma.RolePermissionsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateRolePermissions>
          }
          groupBy: {
            args: Prisma.RolePermissionsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<RolePermissionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.RolePermissionsCountArgs<ExtArgs>,
            result: $Utils.Optional<RolePermissionsCountAggregateOutputType> | number
          }
        }
      }
      UserRoles: {
        payload: Prisma.$UserRolesPayload<ExtArgs>
        fields: Prisma.UserRolesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserRolesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserRolesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          findFirst: {
            args: Prisma.UserRolesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserRolesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          findMany: {
            args: Prisma.UserRolesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>[]
          }
          create: {
            args: Prisma.UserRolesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          createMany: {
            args: Prisma.UserRolesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserRolesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>[]
          }
          delete: {
            args: Prisma.UserRolesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          update: {
            args: Prisma.UserRolesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          deleteMany: {
            args: Prisma.UserRolesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserRolesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserRolesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          aggregate: {
            args: Prisma.UserRolesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUserRoles>
          }
          groupBy: {
            args: Prisma.UserRolesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserRolesGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserRolesCountArgs<ExtArgs>,
            result: $Utils.Optional<UserRolesCountAggregateOutputType> | number
          }
        }
      }
      UserPermissions: {
        payload: Prisma.$UserPermissionsPayload<ExtArgs>
        fields: Prisma.UserPermissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserPermissionsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserPermissionsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          findFirst: {
            args: Prisma.UserPermissionsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserPermissionsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          findMany: {
            args: Prisma.UserPermissionsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>[]
          }
          create: {
            args: Prisma.UserPermissionsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          createMany: {
            args: Prisma.UserPermissionsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserPermissionsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>[]
          }
          delete: {
            args: Prisma.UserPermissionsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          update: {
            args: Prisma.UserPermissionsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          deleteMany: {
            args: Prisma.UserPermissionsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserPermissionsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserPermissionsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          aggregate: {
            args: Prisma.UserPermissionsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUserPermissions>
          }
          groupBy: {
            args: Prisma.UserPermissionsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserPermissionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserPermissionsCountArgs<ExtArgs>,
            result: $Utils.Optional<UserPermissionsCountAggregateOutputType> | number
          }
        }
      }
      Otp: {
        payload: Prisma.$OtpPayload<ExtArgs>
        fields: Prisma.OtpFieldRefs
        operations: {
          findUnique: {
            args: Prisma.OtpFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.OtpFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload>
          }
          findFirst: {
            args: Prisma.OtpFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.OtpFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload>
          }
          findMany: {
            args: Prisma.OtpFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload>[]
          }
          create: {
            args: Prisma.OtpCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload>
          }
          createMany: {
            args: Prisma.OtpCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.OtpCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload>[]
          }
          delete: {
            args: Prisma.OtpDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload>
          }
          update: {
            args: Prisma.OtpUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload>
          }
          deleteMany: {
            args: Prisma.OtpDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.OtpUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.OtpUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OtpPayload>
          }
          aggregate: {
            args: Prisma.OtpAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateOtp>
          }
          groupBy: {
            args: Prisma.OtpGroupByArgs<ExtArgs>,
            result: $Utils.Optional<OtpGroupByOutputType>[]
          }
          count: {
            args: Prisma.OtpCountArgs<ExtArgs>,
            result: $Utils.Optional<OtpCountAggregateOutputType> | number
          }
        }
      }
      Language: {
        payload: Prisma.$LanguagePayload<ExtArgs>
        fields: Prisma.LanguageFieldRefs
        operations: {
          findUnique: {
            args: Prisma.LanguageFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.LanguageFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          findFirst: {
            args: Prisma.LanguageFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.LanguageFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          findMany: {
            args: Prisma.LanguageFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>[]
          }
          create: {
            args: Prisma.LanguageCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          createMany: {
            args: Prisma.LanguageCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.LanguageCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>[]
          }
          delete: {
            args: Prisma.LanguageDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          update: {
            args: Prisma.LanguageUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          deleteMany: {
            args: Prisma.LanguageDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.LanguageUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.LanguageUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          aggregate: {
            args: Prisma.LanguageAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateLanguage>
          }
          groupBy: {
            args: Prisma.LanguageGroupByArgs<ExtArgs>,
            result: $Utils.Optional<LanguageGroupByOutputType>[]
          }
          count: {
            args: Prisma.LanguageCountArgs<ExtArgs>,
            result: $Utils.Optional<LanguageCountAggregateOutputType> | number
          }
        }
      }
      LanguageContent: {
        payload: Prisma.$LanguageContentPayload<ExtArgs>
        fields: Prisma.LanguageContentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.LanguageContentFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.LanguageContentFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          findFirst: {
            args: Prisma.LanguageContentFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.LanguageContentFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          findMany: {
            args: Prisma.LanguageContentFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>[]
          }
          create: {
            args: Prisma.LanguageContentCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          createMany: {
            args: Prisma.LanguageContentCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.LanguageContentCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>[]
          }
          delete: {
            args: Prisma.LanguageContentDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          update: {
            args: Prisma.LanguageContentUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          deleteMany: {
            args: Prisma.LanguageContentDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.LanguageContentUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.LanguageContentUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          aggregate: {
            args: Prisma.LanguageContentAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateLanguageContent>
          }
          groupBy: {
            args: Prisma.LanguageContentGroupByArgs<ExtArgs>,
            result: $Utils.Optional<LanguageContentGroupByOutputType>[]
          }
          count: {
            args: Prisma.LanguageContentCountArgs<ExtArgs>,
            result: $Utils.Optional<LanguageContentCountAggregateOutputType> | number
          }
        }
      }
      Menus: {
        payload: Prisma.$MenusPayload<ExtArgs>
        fields: Prisma.MenusFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MenusFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MenusFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          findFirst: {
            args: Prisma.MenusFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MenusFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          findMany: {
            args: Prisma.MenusFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>[]
          }
          create: {
            args: Prisma.MenusCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          createMany: {
            args: Prisma.MenusCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.MenusCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>[]
          }
          delete: {
            args: Prisma.MenusDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          update: {
            args: Prisma.MenusUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          deleteMany: {
            args: Prisma.MenusDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.MenusUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.MenusUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          aggregate: {
            args: Prisma.MenusAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMenus>
          }
          groupBy: {
            args: Prisma.MenusGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MenusGroupByOutputType>[]
          }
          count: {
            args: Prisma.MenusCountArgs<ExtArgs>,
            result: $Utils.Optional<MenusCountAggregateOutputType> | number
          }
        }
      }
      MenuItems: {
        payload: Prisma.$MenuItemsPayload<ExtArgs>
        fields: Prisma.MenuItemsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MenuItemsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MenuItemsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          findFirst: {
            args: Prisma.MenuItemsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MenuItemsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          findMany: {
            args: Prisma.MenuItemsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>[]
          }
          create: {
            args: Prisma.MenuItemsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          createMany: {
            args: Prisma.MenuItemsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.MenuItemsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>[]
          }
          delete: {
            args: Prisma.MenuItemsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          update: {
            args: Prisma.MenuItemsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          deleteMany: {
            args: Prisma.MenuItemsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.MenuItemsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.MenuItemsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          aggregate: {
            args: Prisma.MenuItemsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMenuItems>
          }
          groupBy: {
            args: Prisma.MenuItemsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MenuItemsGroupByOutputType>[]
          }
          count: {
            args: Prisma.MenuItemsCountArgs<ExtArgs>,
            result: $Utils.Optional<MenuItemsCountAggregateOutputType> | number
          }
        }
      }
      ActionType: {
        payload: Prisma.$ActionTypePayload<ExtArgs>
        fields: Prisma.ActionTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ActionTypeFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ActionTypeFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload>
          }
          findFirst: {
            args: Prisma.ActionTypeFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ActionTypeFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload>
          }
          findMany: {
            args: Prisma.ActionTypeFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload>[]
          }
          create: {
            args: Prisma.ActionTypeCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload>
          }
          createMany: {
            args: Prisma.ActionTypeCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ActionTypeCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload>[]
          }
          delete: {
            args: Prisma.ActionTypeDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload>
          }
          update: {
            args: Prisma.ActionTypeUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload>
          }
          deleteMany: {
            args: Prisma.ActionTypeDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ActionTypeUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ActionTypeUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ActionTypePayload>
          }
          aggregate: {
            args: Prisma.ActionTypeAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateActionType>
          }
          groupBy: {
            args: Prisma.ActionTypeGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ActionTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.ActionTypeCountArgs<ExtArgs>,
            result: $Utils.Optional<ActionTypeCountAggregateOutputType> | number
          }
        }
      }
      EntityType: {
        payload: Prisma.$EntityTypePayload<ExtArgs>
        fields: Prisma.EntityTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EntityTypeFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EntityTypeFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload>
          }
          findFirst: {
            args: Prisma.EntityTypeFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EntityTypeFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload>
          }
          findMany: {
            args: Prisma.EntityTypeFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload>[]
          }
          create: {
            args: Prisma.EntityTypeCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload>
          }
          createMany: {
            args: Prisma.EntityTypeCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EntityTypeCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload>[]
          }
          delete: {
            args: Prisma.EntityTypeDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload>
          }
          update: {
            args: Prisma.EntityTypeUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload>
          }
          deleteMany: {
            args: Prisma.EntityTypeDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EntityTypeUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EntityTypeUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EntityTypePayload>
          }
          aggregate: {
            args: Prisma.EntityTypeAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEntityType>
          }
          groupBy: {
            args: Prisma.EntityTypeGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EntityTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.EntityTypeCountArgs<ExtArgs>,
            result: $Utils.Optional<EntityTypeCountAggregateOutputType> | number
          }
        }
      }
      WizardGroup: {
        payload: Prisma.$WizardGroupPayload<ExtArgs>
        fields: Prisma.WizardGroupFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WizardGroupFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WizardGroupFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          findFirst: {
            args: Prisma.WizardGroupFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WizardGroupFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          findMany: {
            args: Prisma.WizardGroupFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>[]
          }
          create: {
            args: Prisma.WizardGroupCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          createMany: {
            args: Prisma.WizardGroupCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WizardGroupCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>[]
          }
          delete: {
            args: Prisma.WizardGroupDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          update: {
            args: Prisma.WizardGroupUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          deleteMany: {
            args: Prisma.WizardGroupDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WizardGroupUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WizardGroupUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          aggregate: {
            args: Prisma.WizardGroupAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWizardGroup>
          }
          groupBy: {
            args: Prisma.WizardGroupGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WizardGroupGroupByOutputType>[]
          }
          count: {
            args: Prisma.WizardGroupCountArgs<ExtArgs>,
            result: $Utils.Optional<WizardGroupCountAggregateOutputType> | number
          }
        }
      }
      WizardType: {
        payload: Prisma.$WizardTypePayload<ExtArgs>
        fields: Prisma.WizardTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WizardTypeFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WizardTypeFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          findFirst: {
            args: Prisma.WizardTypeFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WizardTypeFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          findMany: {
            args: Prisma.WizardTypeFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>[]
          }
          create: {
            args: Prisma.WizardTypeCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          createMany: {
            args: Prisma.WizardTypeCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WizardTypeCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>[]
          }
          delete: {
            args: Prisma.WizardTypeDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          update: {
            args: Prisma.WizardTypeUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          deleteMany: {
            args: Prisma.WizardTypeDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WizardTypeUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WizardTypeUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          aggregate: {
            args: Prisma.WizardTypeAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWizardType>
          }
          groupBy: {
            args: Prisma.WizardTypeGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WizardTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.WizardTypeCountArgs<ExtArgs>,
            result: $Utils.Optional<WizardTypeCountAggregateOutputType> | number
          }
        }
      }
      AboutLCP: {
        payload: Prisma.$AboutLCPPayload<ExtArgs>
        fields: Prisma.AboutLCPFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AboutLCPFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AboutLCPFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload>
          }
          findFirst: {
            args: Prisma.AboutLCPFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AboutLCPFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload>
          }
          findMany: {
            args: Prisma.AboutLCPFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload>[]
          }
          create: {
            args: Prisma.AboutLCPCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload>
          }
          createMany: {
            args: Prisma.AboutLCPCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.AboutLCPCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload>[]
          }
          delete: {
            args: Prisma.AboutLCPDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload>
          }
          update: {
            args: Prisma.AboutLCPUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload>
          }
          deleteMany: {
            args: Prisma.AboutLCPDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.AboutLCPUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.AboutLCPUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AboutLCPPayload>
          }
          aggregate: {
            args: Prisma.AboutLCPAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateAboutLCP>
          }
          groupBy: {
            args: Prisma.AboutLCPGroupByArgs<ExtArgs>,
            result: $Utils.Optional<AboutLCPGroupByOutputType>[]
          }
          count: {
            args: Prisma.AboutLCPCountArgs<ExtArgs>,
            result: $Utils.Optional<AboutLCPCountAggregateOutputType> | number
          }
        }
      }
      MasterEntity: {
        payload: Prisma.$MasterEntityPayload<ExtArgs>
        fields: Prisma.MasterEntityFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MasterEntityFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MasterEntityFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          findFirst: {
            args: Prisma.MasterEntityFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MasterEntityFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          findMany: {
            args: Prisma.MasterEntityFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>[]
          }
          create: {
            args: Prisma.MasterEntityCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          createMany: {
            args: Prisma.MasterEntityCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.MasterEntityCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>[]
          }
          delete: {
            args: Prisma.MasterEntityDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          update: {
            args: Prisma.MasterEntityUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          deleteMany: {
            args: Prisma.MasterEntityDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.MasterEntityUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.MasterEntityUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          aggregate: {
            args: Prisma.MasterEntityAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMasterEntity>
          }
          groupBy: {
            args: Prisma.MasterEntityGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MasterEntityGroupByOutputType>[]
          }
          count: {
            args: Prisma.MasterEntityCountArgs<ExtArgs>,
            result: $Utils.Optional<MasterEntityCountAggregateOutputType> | number
          }
        }
      }
      MasterEntityLineItem: {
        payload: Prisma.$MasterEntityLineItemPayload<ExtArgs>
        fields: Prisma.MasterEntityLineItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MasterEntityLineItemFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MasterEntityLineItemFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          findFirst: {
            args: Prisma.MasterEntityLineItemFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MasterEntityLineItemFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          findMany: {
            args: Prisma.MasterEntityLineItemFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>[]
          }
          create: {
            args: Prisma.MasterEntityLineItemCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          createMany: {
            args: Prisma.MasterEntityLineItemCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.MasterEntityLineItemCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>[]
          }
          delete: {
            args: Prisma.MasterEntityLineItemDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          update: {
            args: Prisma.MasterEntityLineItemUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          deleteMany: {
            args: Prisma.MasterEntityLineItemDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.MasterEntityLineItemUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.MasterEntityLineItemUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          aggregate: {
            args: Prisma.MasterEntityLineItemAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMasterEntityLineItem>
          }
          groupBy: {
            args: Prisma.MasterEntityLineItemGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MasterEntityLineItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.MasterEntityLineItemCountArgs<ExtArgs>,
            result: $Utils.Optional<MasterEntityLineItemCountAggregateOutputType> | number
          }
        }
      }
      FieldType: {
        payload: Prisma.$FieldTypePayload<ExtArgs>
        fields: Prisma.FieldTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FieldTypeFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FieldTypeFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          findFirst: {
            args: Prisma.FieldTypeFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FieldTypeFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          findMany: {
            args: Prisma.FieldTypeFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>[]
          }
          create: {
            args: Prisma.FieldTypeCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          createMany: {
            args: Prisma.FieldTypeCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.FieldTypeCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>[]
          }
          delete: {
            args: Prisma.FieldTypeDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          update: {
            args: Prisma.FieldTypeUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          deleteMany: {
            args: Prisma.FieldTypeDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.FieldTypeUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.FieldTypeUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          aggregate: {
            args: Prisma.FieldTypeAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateFieldType>
          }
          groupBy: {
            args: Prisma.FieldTypeGroupByArgs<ExtArgs>,
            result: $Utils.Optional<FieldTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.FieldTypeCountArgs<ExtArgs>,
            result: $Utils.Optional<FieldTypeCountAggregateOutputType> | number
          }
        }
      }
      menuType: {
        payload: Prisma.$menuTypePayload<ExtArgs>
        fields: Prisma.menuTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.menuTypeFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.menuTypeFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          findFirst: {
            args: Prisma.menuTypeFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.menuTypeFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          findMany: {
            args: Prisma.menuTypeFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>[]
          }
          create: {
            args: Prisma.menuTypeCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          createMany: {
            args: Prisma.menuTypeCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.menuTypeCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>[]
          }
          delete: {
            args: Prisma.menuTypeDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          update: {
            args: Prisma.menuTypeUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          deleteMany: {
            args: Prisma.menuTypeDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.menuTypeUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.menuTypeUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          aggregate: {
            args: Prisma.MenuTypeAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMenuType>
          }
          groupBy: {
            args: Prisma.menuTypeGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MenuTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.menuTypeCountArgs<ExtArgs>,
            result: $Utils.Optional<MenuTypeCountAggregateOutputType> | number
          }
        }
      }
      EmailTemplateProcess: {
        payload: Prisma.$EmailTemplateProcessPayload<ExtArgs>
        fields: Prisma.EmailTemplateProcessFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmailTemplateProcessFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmailTemplateProcessFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload>
          }
          findFirst: {
            args: Prisma.EmailTemplateProcessFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmailTemplateProcessFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload>
          }
          findMany: {
            args: Prisma.EmailTemplateProcessFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload>[]
          }
          create: {
            args: Prisma.EmailTemplateProcessCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload>
          }
          createMany: {
            args: Prisma.EmailTemplateProcessCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmailTemplateProcessCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload>[]
          }
          delete: {
            args: Prisma.EmailTemplateProcessDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload>
          }
          update: {
            args: Prisma.EmailTemplateProcessUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload>
          }
          deleteMany: {
            args: Prisma.EmailTemplateProcessDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmailTemplateProcessUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmailTemplateProcessUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessPayload>
          }
          aggregate: {
            args: Prisma.EmailTemplateProcessAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmailTemplateProcess>
          }
          groupBy: {
            args: Prisma.EmailTemplateProcessGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateProcessGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmailTemplateProcessCountArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateProcessCountAggregateOutputType> | number
          }
        }
      }
      EmailTemplateTag: {
        payload: Prisma.$EmailTemplateTagPayload<ExtArgs>
        fields: Prisma.EmailTemplateTagFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmailTemplateTagFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmailTemplateTagFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload>
          }
          findFirst: {
            args: Prisma.EmailTemplateTagFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmailTemplateTagFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload>
          }
          findMany: {
            args: Prisma.EmailTemplateTagFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload>[]
          }
          create: {
            args: Prisma.EmailTemplateTagCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload>
          }
          createMany: {
            args: Prisma.EmailTemplateTagCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmailTemplateTagCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload>[]
          }
          delete: {
            args: Prisma.EmailTemplateTagDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload>
          }
          update: {
            args: Prisma.EmailTemplateTagUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload>
          }
          deleteMany: {
            args: Prisma.EmailTemplateTagDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmailTemplateTagUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmailTemplateTagUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateTagPayload>
          }
          aggregate: {
            args: Prisma.EmailTemplateTagAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmailTemplateTag>
          }
          groupBy: {
            args: Prisma.EmailTemplateTagGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateTagGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmailTemplateTagCountArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateTagCountAggregateOutputType> | number
          }
        }
      }
      EmailTemplateRecipientTag: {
        payload: Prisma.$EmailTemplateRecipientTagPayload<ExtArgs>
        fields: Prisma.EmailTemplateRecipientTagFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmailTemplateRecipientTagFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmailTemplateRecipientTagFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload>
          }
          findFirst: {
            args: Prisma.EmailTemplateRecipientTagFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmailTemplateRecipientTagFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload>
          }
          findMany: {
            args: Prisma.EmailTemplateRecipientTagFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload>[]
          }
          create: {
            args: Prisma.EmailTemplateRecipientTagCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload>
          }
          createMany: {
            args: Prisma.EmailTemplateRecipientTagCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmailTemplateRecipientTagCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload>[]
          }
          delete: {
            args: Prisma.EmailTemplateRecipientTagDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload>
          }
          update: {
            args: Prisma.EmailTemplateRecipientTagUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload>
          }
          deleteMany: {
            args: Prisma.EmailTemplateRecipientTagDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmailTemplateRecipientTagUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmailTemplateRecipientTagUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateRecipientTagPayload>
          }
          aggregate: {
            args: Prisma.EmailTemplateRecipientTagAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmailTemplateRecipientTag>
          }
          groupBy: {
            args: Prisma.EmailTemplateRecipientTagGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateRecipientTagGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmailTemplateRecipientTagCountArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateRecipientTagCountAggregateOutputType> | number
          }
        }
      }
      EmailTemplateProcessTagsMapping: {
        payload: Prisma.$EmailTemplateProcessTagsMappingPayload<ExtArgs>
        fields: Prisma.EmailTemplateProcessTagsMappingFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmailTemplateProcessTagsMappingFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmailTemplateProcessTagsMappingFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload>
          }
          findFirst: {
            args: Prisma.EmailTemplateProcessTagsMappingFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmailTemplateProcessTagsMappingFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload>
          }
          findMany: {
            args: Prisma.EmailTemplateProcessTagsMappingFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload>[]
          }
          create: {
            args: Prisma.EmailTemplateProcessTagsMappingCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload>
          }
          createMany: {
            args: Prisma.EmailTemplateProcessTagsMappingCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmailTemplateProcessTagsMappingCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload>[]
          }
          delete: {
            args: Prisma.EmailTemplateProcessTagsMappingDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload>
          }
          update: {
            args: Prisma.EmailTemplateProcessTagsMappingUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload>
          }
          deleteMany: {
            args: Prisma.EmailTemplateProcessTagsMappingDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmailTemplateProcessTagsMappingUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmailTemplateProcessTagsMappingUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateProcessTagsMappingPayload>
          }
          aggregate: {
            args: Prisma.EmailTemplateProcessTagsMappingAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmailTemplateProcessTagsMapping>
          }
          groupBy: {
            args: Prisma.EmailTemplateProcessTagsMappingGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateProcessTagsMappingGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmailTemplateProcessTagsMappingCountArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateProcessTagsMappingCountAggregateOutputType> | number
          }
        }
      }
      EmailTemplate: {
        payload: Prisma.$EmailTemplatePayload<ExtArgs>
        fields: Prisma.EmailTemplateFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmailTemplateFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmailTemplateFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload>
          }
          findFirst: {
            args: Prisma.EmailTemplateFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmailTemplateFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload>
          }
          findMany: {
            args: Prisma.EmailTemplateFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload>[]
          }
          create: {
            args: Prisma.EmailTemplateCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload>
          }
          createMany: {
            args: Prisma.EmailTemplateCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmailTemplateCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload>[]
          }
          delete: {
            args: Prisma.EmailTemplateDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload>
          }
          update: {
            args: Prisma.EmailTemplateUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload>
          }
          deleteMany: {
            args: Prisma.EmailTemplateDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmailTemplateUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmailTemplateUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplatePayload>
          }
          aggregate: {
            args: Prisma.EmailTemplateAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmailTemplate>
          }
          groupBy: {
            args: Prisma.EmailTemplateGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmailTemplateCountArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateCountAggregateOutputType> | number
          }
        }
      }
      EmailTemplateAssignment: {
        payload: Prisma.$EmailTemplateAssignmentPayload<ExtArgs>
        fields: Prisma.EmailTemplateAssignmentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmailTemplateAssignmentFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmailTemplateAssignmentFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload>
          }
          findFirst: {
            args: Prisma.EmailTemplateAssignmentFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmailTemplateAssignmentFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload>
          }
          findMany: {
            args: Prisma.EmailTemplateAssignmentFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload>[]
          }
          create: {
            args: Prisma.EmailTemplateAssignmentCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload>
          }
          createMany: {
            args: Prisma.EmailTemplateAssignmentCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmailTemplateAssignmentCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload>[]
          }
          delete: {
            args: Prisma.EmailTemplateAssignmentDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload>
          }
          update: {
            args: Prisma.EmailTemplateAssignmentUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload>
          }
          deleteMany: {
            args: Prisma.EmailTemplateAssignmentDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmailTemplateAssignmentUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmailTemplateAssignmentUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateAssignmentPayload>
          }
          aggregate: {
            args: Prisma.EmailTemplateAssignmentAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmailTemplateAssignment>
          }
          groupBy: {
            args: Prisma.EmailTemplateAssignmentGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateAssignmentGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmailTemplateAssignmentCountArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateAssignmentCountAggregateOutputType> | number
          }
        }
      }
      EmailTemplateCcBcc: {
        payload: Prisma.$EmailTemplateCcBccPayload<ExtArgs>
        fields: Prisma.EmailTemplateCcBccFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmailTemplateCcBccFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmailTemplateCcBccFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload>
          }
          findFirst: {
            args: Prisma.EmailTemplateCcBccFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmailTemplateCcBccFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload>
          }
          findMany: {
            args: Prisma.EmailTemplateCcBccFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload>[]
          }
          create: {
            args: Prisma.EmailTemplateCcBccCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload>
          }
          createMany: {
            args: Prisma.EmailTemplateCcBccCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmailTemplateCcBccCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload>[]
          }
          delete: {
            args: Prisma.EmailTemplateCcBccDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload>
          }
          update: {
            args: Prisma.EmailTemplateCcBccUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload>
          }
          deleteMany: {
            args: Prisma.EmailTemplateCcBccDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmailTemplateCcBccUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmailTemplateCcBccUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailTemplateCcBccPayload>
          }
          aggregate: {
            args: Prisma.EmailTemplateCcBccAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmailTemplateCcBcc>
          }
          groupBy: {
            args: Prisma.EmailTemplateCcBccGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateCcBccGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmailTemplateCcBccCountArgs<ExtArgs>,
            result: $Utils.Optional<EmailTemplateCcBccCountAggregateOutputType> | number
          }
        }
      }
      EmailProcessJob: {
        payload: Prisma.$EmailProcessJobPayload<ExtArgs>
        fields: Prisma.EmailProcessJobFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmailProcessJobFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmailProcessJobFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload>
          }
          findFirst: {
            args: Prisma.EmailProcessJobFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmailProcessJobFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload>
          }
          findMany: {
            args: Prisma.EmailProcessJobFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload>[]
          }
          create: {
            args: Prisma.EmailProcessJobCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload>
          }
          createMany: {
            args: Prisma.EmailProcessJobCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmailProcessJobCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload>[]
          }
          delete: {
            args: Prisma.EmailProcessJobDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload>
          }
          update: {
            args: Prisma.EmailProcessJobUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload>
          }
          deleteMany: {
            args: Prisma.EmailProcessJobDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmailProcessJobUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmailProcessJobUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmailProcessJobPayload>
          }
          aggregate: {
            args: Prisma.EmailProcessJobAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmailProcessJob>
          }
          groupBy: {
            args: Prisma.EmailProcessJobGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmailProcessJobGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmailProcessJobCountArgs<ExtArgs>,
            result: $Utils.Optional<EmailProcessJobCountAggregateOutputType> | number
          }
        }
      }
      WhatsappProcessJob: {
        payload: Prisma.$WhatsappProcessJobPayload<ExtArgs>
        fields: Prisma.WhatsappProcessJobFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WhatsappProcessJobFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WhatsappProcessJobFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload>
          }
          findFirst: {
            args: Prisma.WhatsappProcessJobFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WhatsappProcessJobFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload>
          }
          findMany: {
            args: Prisma.WhatsappProcessJobFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload>[]
          }
          create: {
            args: Prisma.WhatsappProcessJobCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload>
          }
          createMany: {
            args: Prisma.WhatsappProcessJobCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WhatsappProcessJobCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload>[]
          }
          delete: {
            args: Prisma.WhatsappProcessJobDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload>
          }
          update: {
            args: Prisma.WhatsappProcessJobUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload>
          }
          deleteMany: {
            args: Prisma.WhatsappProcessJobDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WhatsappProcessJobUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WhatsappProcessJobUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappProcessJobPayload>
          }
          aggregate: {
            args: Prisma.WhatsappProcessJobAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWhatsappProcessJob>
          }
          groupBy: {
            args: Prisma.WhatsappProcessJobGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappProcessJobGroupByOutputType>[]
          }
          count: {
            args: Prisma.WhatsappProcessJobCountArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappProcessJobCountAggregateOutputType> | number
          }
        }
      }
      WhatsappTemplateProcess: {
        payload: Prisma.$WhatsappTemplateProcessPayload<ExtArgs>
        fields: Prisma.WhatsappTemplateProcessFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WhatsappTemplateProcessFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WhatsappTemplateProcessFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload>
          }
          findFirst: {
            args: Prisma.WhatsappTemplateProcessFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WhatsappTemplateProcessFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload>
          }
          findMany: {
            args: Prisma.WhatsappTemplateProcessFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload>[]
          }
          create: {
            args: Prisma.WhatsappTemplateProcessCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload>
          }
          createMany: {
            args: Prisma.WhatsappTemplateProcessCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WhatsappTemplateProcessCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload>[]
          }
          delete: {
            args: Prisma.WhatsappTemplateProcessDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload>
          }
          update: {
            args: Prisma.WhatsappTemplateProcessUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload>
          }
          deleteMany: {
            args: Prisma.WhatsappTemplateProcessDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WhatsappTemplateProcessUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WhatsappTemplateProcessUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessPayload>
          }
          aggregate: {
            args: Prisma.WhatsappTemplateProcessAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWhatsappTemplateProcess>
          }
          groupBy: {
            args: Prisma.WhatsappTemplateProcessGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateProcessGroupByOutputType>[]
          }
          count: {
            args: Prisma.WhatsappTemplateProcessCountArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateProcessCountAggregateOutputType> | number
          }
        }
      }
      WhatsappTemplateTag: {
        payload: Prisma.$WhatsappTemplateTagPayload<ExtArgs>
        fields: Prisma.WhatsappTemplateTagFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WhatsappTemplateTagFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WhatsappTemplateTagFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload>
          }
          findFirst: {
            args: Prisma.WhatsappTemplateTagFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WhatsappTemplateTagFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload>
          }
          findMany: {
            args: Prisma.WhatsappTemplateTagFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload>[]
          }
          create: {
            args: Prisma.WhatsappTemplateTagCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload>
          }
          createMany: {
            args: Prisma.WhatsappTemplateTagCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WhatsappTemplateTagCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload>[]
          }
          delete: {
            args: Prisma.WhatsappTemplateTagDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload>
          }
          update: {
            args: Prisma.WhatsappTemplateTagUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload>
          }
          deleteMany: {
            args: Prisma.WhatsappTemplateTagDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WhatsappTemplateTagUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WhatsappTemplateTagUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateTagPayload>
          }
          aggregate: {
            args: Prisma.WhatsappTemplateTagAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWhatsappTemplateTag>
          }
          groupBy: {
            args: Prisma.WhatsappTemplateTagGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateTagGroupByOutputType>[]
          }
          count: {
            args: Prisma.WhatsappTemplateTagCountArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateTagCountAggregateOutputType> | number
          }
        }
      }
      WhatsappTemplateRecipientTag: {
        payload: Prisma.$WhatsappTemplateRecipientTagPayload<ExtArgs>
        fields: Prisma.WhatsappTemplateRecipientTagFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WhatsappTemplateRecipientTagFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WhatsappTemplateRecipientTagFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload>
          }
          findFirst: {
            args: Prisma.WhatsappTemplateRecipientTagFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WhatsappTemplateRecipientTagFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload>
          }
          findMany: {
            args: Prisma.WhatsappTemplateRecipientTagFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload>[]
          }
          create: {
            args: Prisma.WhatsappTemplateRecipientTagCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload>
          }
          createMany: {
            args: Prisma.WhatsappTemplateRecipientTagCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WhatsappTemplateRecipientTagCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload>[]
          }
          delete: {
            args: Prisma.WhatsappTemplateRecipientTagDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload>
          }
          update: {
            args: Prisma.WhatsappTemplateRecipientTagUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload>
          }
          deleteMany: {
            args: Prisma.WhatsappTemplateRecipientTagDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WhatsappTemplateRecipientTagUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WhatsappTemplateRecipientTagUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateRecipientTagPayload>
          }
          aggregate: {
            args: Prisma.WhatsappTemplateRecipientTagAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWhatsappTemplateRecipientTag>
          }
          groupBy: {
            args: Prisma.WhatsappTemplateRecipientTagGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateRecipientTagGroupByOutputType>[]
          }
          count: {
            args: Prisma.WhatsappTemplateRecipientTagCountArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateRecipientTagCountAggregateOutputType> | number
          }
        }
      }
      WhatsappTemplateProcessTagsMapping: {
        payload: Prisma.$WhatsappTemplateProcessTagsMappingPayload<ExtArgs>
        fields: Prisma.WhatsappTemplateProcessTagsMappingFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WhatsappTemplateProcessTagsMappingFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WhatsappTemplateProcessTagsMappingFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload>
          }
          findFirst: {
            args: Prisma.WhatsappTemplateProcessTagsMappingFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WhatsappTemplateProcessTagsMappingFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload>
          }
          findMany: {
            args: Prisma.WhatsappTemplateProcessTagsMappingFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload>[]
          }
          create: {
            args: Prisma.WhatsappTemplateProcessTagsMappingCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload>
          }
          createMany: {
            args: Prisma.WhatsappTemplateProcessTagsMappingCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WhatsappTemplateProcessTagsMappingCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload>[]
          }
          delete: {
            args: Prisma.WhatsappTemplateProcessTagsMappingDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload>
          }
          update: {
            args: Prisma.WhatsappTemplateProcessTagsMappingUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload>
          }
          deleteMany: {
            args: Prisma.WhatsappTemplateProcessTagsMappingDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WhatsappTemplateProcessTagsMappingUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WhatsappTemplateProcessTagsMappingUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateProcessTagsMappingPayload>
          }
          aggregate: {
            args: Prisma.WhatsappTemplateProcessTagsMappingAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWhatsappTemplateProcessTagsMapping>
          }
          groupBy: {
            args: Prisma.WhatsappTemplateProcessTagsMappingGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateProcessTagsMappingGroupByOutputType>[]
          }
          count: {
            args: Prisma.WhatsappTemplateProcessTagsMappingCountArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateProcessTagsMappingCountAggregateOutputType> | number
          }
        }
      }
      WhatsappTemplate: {
        payload: Prisma.$WhatsappTemplatePayload<ExtArgs>
        fields: Prisma.WhatsappTemplateFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WhatsappTemplateFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WhatsappTemplateFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload>
          }
          findFirst: {
            args: Prisma.WhatsappTemplateFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WhatsappTemplateFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload>
          }
          findMany: {
            args: Prisma.WhatsappTemplateFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload>[]
          }
          create: {
            args: Prisma.WhatsappTemplateCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload>
          }
          createMany: {
            args: Prisma.WhatsappTemplateCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WhatsappTemplateCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload>[]
          }
          delete: {
            args: Prisma.WhatsappTemplateDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload>
          }
          update: {
            args: Prisma.WhatsappTemplateUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload>
          }
          deleteMany: {
            args: Prisma.WhatsappTemplateDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WhatsappTemplateUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WhatsappTemplateUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplatePayload>
          }
          aggregate: {
            args: Prisma.WhatsappTemplateAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWhatsappTemplate>
          }
          groupBy: {
            args: Prisma.WhatsappTemplateGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateGroupByOutputType>[]
          }
          count: {
            args: Prisma.WhatsappTemplateCountArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateCountAggregateOutputType> | number
          }
        }
      }
      WhatsappTemplateAssignment: {
        payload: Prisma.$WhatsappTemplateAssignmentPayload<ExtArgs>
        fields: Prisma.WhatsappTemplateAssignmentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WhatsappTemplateAssignmentFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WhatsappTemplateAssignmentFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload>
          }
          findFirst: {
            args: Prisma.WhatsappTemplateAssignmentFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WhatsappTemplateAssignmentFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload>
          }
          findMany: {
            args: Prisma.WhatsappTemplateAssignmentFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload>[]
          }
          create: {
            args: Prisma.WhatsappTemplateAssignmentCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload>
          }
          createMany: {
            args: Prisma.WhatsappTemplateAssignmentCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WhatsappTemplateAssignmentCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload>[]
          }
          delete: {
            args: Prisma.WhatsappTemplateAssignmentDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload>
          }
          update: {
            args: Prisma.WhatsappTemplateAssignmentUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload>
          }
          deleteMany: {
            args: Prisma.WhatsappTemplateAssignmentDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WhatsappTemplateAssignmentUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WhatsappTemplateAssignmentUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WhatsappTemplateAssignmentPayload>
          }
          aggregate: {
            args: Prisma.WhatsappTemplateAssignmentAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWhatsappTemplateAssignment>
          }
          groupBy: {
            args: Prisma.WhatsappTemplateAssignmentGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateAssignmentGroupByOutputType>[]
          }
          count: {
            args: Prisma.WhatsappTemplateAssignmentCountArgs<ExtArgs>,
            result: $Utils.Optional<WhatsappTemplateAssignmentCountAggregateOutputType> | number
          }
        }
      }
      NotificationJob: {
        payload: Prisma.$NotificationJobPayload<ExtArgs>
        fields: Prisma.NotificationJobFieldRefs
        operations: {
          findUnique: {
            args: Prisma.NotificationJobFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.NotificationJobFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload>
          }
          findFirst: {
            args: Prisma.NotificationJobFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.NotificationJobFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload>
          }
          findMany: {
            args: Prisma.NotificationJobFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload>[]
          }
          create: {
            args: Prisma.NotificationJobCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload>
          }
          createMany: {
            args: Prisma.NotificationJobCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.NotificationJobCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload>[]
          }
          delete: {
            args: Prisma.NotificationJobDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload>
          }
          update: {
            args: Prisma.NotificationJobUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload>
          }
          deleteMany: {
            args: Prisma.NotificationJobDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.NotificationJobUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.NotificationJobUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$NotificationJobPayload>
          }
          aggregate: {
            args: Prisma.NotificationJobAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateNotificationJob>
          }
          groupBy: {
            args: Prisma.NotificationJobGroupByArgs<ExtArgs>,
            result: $Utils.Optional<NotificationJobGroupByOutputType>[]
          }
          count: {
            args: Prisma.NotificationJobCountArgs<ExtArgs>,
            result: $Utils.Optional<NotificationJobCountAggregateOutputType> | number
          }
        }
      }
      CarouselTemplate: {
        payload: Prisma.$CarouselTemplatePayload<ExtArgs>
        fields: Prisma.CarouselTemplateFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CarouselTemplateFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CarouselTemplateFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload>
          }
          findFirst: {
            args: Prisma.CarouselTemplateFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CarouselTemplateFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload>
          }
          findMany: {
            args: Prisma.CarouselTemplateFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload>[]
          }
          create: {
            args: Prisma.CarouselTemplateCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload>
          }
          createMany: {
            args: Prisma.CarouselTemplateCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.CarouselTemplateCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload>[]
          }
          delete: {
            args: Prisma.CarouselTemplateDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload>
          }
          update: {
            args: Prisma.CarouselTemplateUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload>
          }
          deleteMany: {
            args: Prisma.CarouselTemplateDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.CarouselTemplateUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.CarouselTemplateUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplatePayload>
          }
          aggregate: {
            args: Prisma.CarouselTemplateAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateCarouselTemplate>
          }
          groupBy: {
            args: Prisma.CarouselTemplateGroupByArgs<ExtArgs>,
            result: $Utils.Optional<CarouselTemplateGroupByOutputType>[]
          }
          count: {
            args: Prisma.CarouselTemplateCountArgs<ExtArgs>,
            result: $Utils.Optional<CarouselTemplateCountAggregateOutputType> | number
          }
        }
      }
      CarouselTemplateLineItem: {
        payload: Prisma.$CarouselTemplateLineItemPayload<ExtArgs>
        fields: Prisma.CarouselTemplateLineItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CarouselTemplateLineItemFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CarouselTemplateLineItemFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload>
          }
          findFirst: {
            args: Prisma.CarouselTemplateLineItemFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CarouselTemplateLineItemFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload>
          }
          findMany: {
            args: Prisma.CarouselTemplateLineItemFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload>[]
          }
          create: {
            args: Prisma.CarouselTemplateLineItemCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload>
          }
          createMany: {
            args: Prisma.CarouselTemplateLineItemCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.CarouselTemplateLineItemCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload>[]
          }
          delete: {
            args: Prisma.CarouselTemplateLineItemDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload>
          }
          update: {
            args: Prisma.CarouselTemplateLineItemUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload>
          }
          deleteMany: {
            args: Prisma.CarouselTemplateLineItemDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.CarouselTemplateLineItemUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.CarouselTemplateLineItemUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CarouselTemplateLineItemPayload>
          }
          aggregate: {
            args: Prisma.CarouselTemplateLineItemAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateCarouselTemplateLineItem>
          }
          groupBy: {
            args: Prisma.CarouselTemplateLineItemGroupByArgs<ExtArgs>,
            result: $Utils.Optional<CarouselTemplateLineItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.CarouselTemplateLineItemCountArgs<ExtArgs>,
            result: $Utils.Optional<CarouselTemplateLineItemCountAggregateOutputType> | number
          }
        }
      }
      ImportTemplate: {
        payload: Prisma.$ImportTemplatePayload<ExtArgs>
        fields: Prisma.ImportTemplateFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ImportTemplateFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ImportTemplateFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload>
          }
          findFirst: {
            args: Prisma.ImportTemplateFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ImportTemplateFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload>
          }
          findMany: {
            args: Prisma.ImportTemplateFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload>[]
          }
          create: {
            args: Prisma.ImportTemplateCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload>
          }
          createMany: {
            args: Prisma.ImportTemplateCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ImportTemplateCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload>[]
          }
          delete: {
            args: Prisma.ImportTemplateDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload>
          }
          update: {
            args: Prisma.ImportTemplateUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload>
          }
          deleteMany: {
            args: Prisma.ImportTemplateDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ImportTemplateUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ImportTemplateUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplatePayload>
          }
          aggregate: {
            args: Prisma.ImportTemplateAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateImportTemplate>
          }
          groupBy: {
            args: Prisma.ImportTemplateGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ImportTemplateGroupByOutputType>[]
          }
          count: {
            args: Prisma.ImportTemplateCountArgs<ExtArgs>,
            result: $Utils.Optional<ImportTemplateCountAggregateOutputType> | number
          }
        }
      }
      ImportTemplateLineItem: {
        payload: Prisma.$ImportTemplateLineItemPayload<ExtArgs>
        fields: Prisma.ImportTemplateLineItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ImportTemplateLineItemFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ImportTemplateLineItemFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload>
          }
          findFirst: {
            args: Prisma.ImportTemplateLineItemFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ImportTemplateLineItemFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload>
          }
          findMany: {
            args: Prisma.ImportTemplateLineItemFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload>[]
          }
          create: {
            args: Prisma.ImportTemplateLineItemCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload>
          }
          createMany: {
            args: Prisma.ImportTemplateLineItemCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ImportTemplateLineItemCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload>[]
          }
          delete: {
            args: Prisma.ImportTemplateLineItemDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload>
          }
          update: {
            args: Prisma.ImportTemplateLineItemUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload>
          }
          deleteMany: {
            args: Prisma.ImportTemplateLineItemDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ImportTemplateLineItemUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ImportTemplateLineItemUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateLineItemPayload>
          }
          aggregate: {
            args: Prisma.ImportTemplateLineItemAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateImportTemplateLineItem>
          }
          groupBy: {
            args: Prisma.ImportTemplateLineItemGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ImportTemplateLineItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.ImportTemplateLineItemCountArgs<ExtArgs>,
            result: $Utils.Optional<ImportTemplateLineItemCountAggregateOutputType> | number
          }
        }
      }
      ImportTemplateQueries: {
        payload: Prisma.$ImportTemplateQueriesPayload<ExtArgs>
        fields: Prisma.ImportTemplateQueriesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ImportTemplateQueriesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ImportTemplateQueriesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload>
          }
          findFirst: {
            args: Prisma.ImportTemplateQueriesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ImportTemplateQueriesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload>
          }
          findMany: {
            args: Prisma.ImportTemplateQueriesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload>[]
          }
          create: {
            args: Prisma.ImportTemplateQueriesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload>
          }
          createMany: {
            args: Prisma.ImportTemplateQueriesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ImportTemplateQueriesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload>[]
          }
          delete: {
            args: Prisma.ImportTemplateQueriesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload>
          }
          update: {
            args: Prisma.ImportTemplateQueriesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload>
          }
          deleteMany: {
            args: Prisma.ImportTemplateQueriesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ImportTemplateQueriesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ImportTemplateQueriesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportTemplateQueriesPayload>
          }
          aggregate: {
            args: Prisma.ImportTemplateQueriesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateImportTemplateQueries>
          }
          groupBy: {
            args: Prisma.ImportTemplateQueriesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ImportTemplateQueriesGroupByOutputType>[]
          }
          count: {
            args: Prisma.ImportTemplateQueriesCountArgs<ExtArgs>,
            result: $Utils.Optional<ImportTemplateQueriesCountAggregateOutputType> | number
          }
        }
      }
      ImportJob: {
        payload: Prisma.$ImportJobPayload<ExtArgs>
        fields: Prisma.ImportJobFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ImportJobFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ImportJobFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload>
          }
          findFirst: {
            args: Prisma.ImportJobFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ImportJobFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload>
          }
          findMany: {
            args: Prisma.ImportJobFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload>[]
          }
          create: {
            args: Prisma.ImportJobCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload>
          }
          createMany: {
            args: Prisma.ImportJobCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ImportJobCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload>[]
          }
          delete: {
            args: Prisma.ImportJobDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload>
          }
          update: {
            args: Prisma.ImportJobUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload>
          }
          deleteMany: {
            args: Prisma.ImportJobDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ImportJobUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ImportJobUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobPayload>
          }
          aggregate: {
            args: Prisma.ImportJobAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateImportJob>
          }
          groupBy: {
            args: Prisma.ImportJobGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ImportJobGroupByOutputType>[]
          }
          count: {
            args: Prisma.ImportJobCountArgs<ExtArgs>,
            result: $Utils.Optional<ImportJobCountAggregateOutputType> | number
          }
        }
      }
      ImportJobLineItem: {
        payload: Prisma.$ImportJobLineItemPayload<ExtArgs>
        fields: Prisma.ImportJobLineItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ImportJobLineItemFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ImportJobLineItemFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload>
          }
          findFirst: {
            args: Prisma.ImportJobLineItemFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ImportJobLineItemFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload>
          }
          findMany: {
            args: Prisma.ImportJobLineItemFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload>[]
          }
          create: {
            args: Prisma.ImportJobLineItemCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload>
          }
          createMany: {
            args: Prisma.ImportJobLineItemCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ImportJobLineItemCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload>[]
          }
          delete: {
            args: Prisma.ImportJobLineItemDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload>
          }
          update: {
            args: Prisma.ImportJobLineItemUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload>
          }
          deleteMany: {
            args: Prisma.ImportJobLineItemDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ImportJobLineItemUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ImportJobLineItemUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ImportJobLineItemPayload>
          }
          aggregate: {
            args: Prisma.ImportJobLineItemAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateImportJobLineItem>
          }
          groupBy: {
            args: Prisma.ImportJobLineItemGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ImportJobLineItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.ImportJobLineItemCountArgs<ExtArgs>,
            result: $Utils.Optional<ImportJobLineItemCountAggregateOutputType> | number
          }
        }
      }
      ExportTemplate: {
        payload: Prisma.$ExportTemplatePayload<ExtArgs>
        fields: Prisma.ExportTemplateFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ExportTemplateFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ExportTemplateFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload>
          }
          findFirst: {
            args: Prisma.ExportTemplateFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ExportTemplateFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload>
          }
          findMany: {
            args: Prisma.ExportTemplateFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload>[]
          }
          create: {
            args: Prisma.ExportTemplateCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload>
          }
          createMany: {
            args: Prisma.ExportTemplateCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ExportTemplateCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload>[]
          }
          delete: {
            args: Prisma.ExportTemplateDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload>
          }
          update: {
            args: Prisma.ExportTemplateUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload>
          }
          deleteMany: {
            args: Prisma.ExportTemplateDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ExportTemplateUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ExportTemplateUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplatePayload>
          }
          aggregate: {
            args: Prisma.ExportTemplateAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateExportTemplate>
          }
          groupBy: {
            args: Prisma.ExportTemplateGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ExportTemplateGroupByOutputType>[]
          }
          count: {
            args: Prisma.ExportTemplateCountArgs<ExtArgs>,
            result: $Utils.Optional<ExportTemplateCountAggregateOutputType> | number
          }
        }
      }
      ExportTemplateLineItem: {
        payload: Prisma.$ExportTemplateLineItemPayload<ExtArgs>
        fields: Prisma.ExportTemplateLineItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ExportTemplateLineItemFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ExportTemplateLineItemFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload>
          }
          findFirst: {
            args: Prisma.ExportTemplateLineItemFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ExportTemplateLineItemFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload>
          }
          findMany: {
            args: Prisma.ExportTemplateLineItemFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload>[]
          }
          create: {
            args: Prisma.ExportTemplateLineItemCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload>
          }
          createMany: {
            args: Prisma.ExportTemplateLineItemCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ExportTemplateLineItemCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload>[]
          }
          delete: {
            args: Prisma.ExportTemplateLineItemDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload>
          }
          update: {
            args: Prisma.ExportTemplateLineItemUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload>
          }
          deleteMany: {
            args: Prisma.ExportTemplateLineItemDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ExportTemplateLineItemUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ExportTemplateLineItemUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateLineItemPayload>
          }
          aggregate: {
            args: Prisma.ExportTemplateLineItemAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateExportTemplateLineItem>
          }
          groupBy: {
            args: Prisma.ExportTemplateLineItemGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ExportTemplateLineItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.ExportTemplateLineItemCountArgs<ExtArgs>,
            result: $Utils.Optional<ExportTemplateLineItemCountAggregateOutputType> | number
          }
        }
      }
      ExportTemplateQueries: {
        payload: Prisma.$ExportTemplateQueriesPayload<ExtArgs>
        fields: Prisma.ExportTemplateQueriesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ExportTemplateQueriesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ExportTemplateQueriesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload>
          }
          findFirst: {
            args: Prisma.ExportTemplateQueriesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ExportTemplateQueriesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload>
          }
          findMany: {
            args: Prisma.ExportTemplateQueriesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload>[]
          }
          create: {
            args: Prisma.ExportTemplateQueriesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload>
          }
          createMany: {
            args: Prisma.ExportTemplateQueriesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ExportTemplateQueriesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload>[]
          }
          delete: {
            args: Prisma.ExportTemplateQueriesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload>
          }
          update: {
            args: Prisma.ExportTemplateQueriesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload>
          }
          deleteMany: {
            args: Prisma.ExportTemplateQueriesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ExportTemplateQueriesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ExportTemplateQueriesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ExportTemplateQueriesPayload>
          }
          aggregate: {
            args: Prisma.ExportTemplateQueriesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateExportTemplateQueries>
          }
          groupBy: {
            args: Prisma.ExportTemplateQueriesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ExportTemplateQueriesGroupByOutputType>[]
          }
          count: {
            args: Prisma.ExportTemplateQueriesCountArgs<ExtArgs>,
            result: $Utils.Optional<ExportTemplateQueriesCountAggregateOutputType> | number
          }
        }
      }
      Status: {
        payload: Prisma.$StatusPayload<ExtArgs>
        fields: Prisma.StatusFieldRefs
        operations: {
          findUnique: {
            args: Prisma.StatusFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.StatusFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          findFirst: {
            args: Prisma.StatusFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.StatusFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          findMany: {
            args: Prisma.StatusFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>[]
          }
          create: {
            args: Prisma.StatusCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          createMany: {
            args: Prisma.StatusCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.StatusCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>[]
          }
          delete: {
            args: Prisma.StatusDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          update: {
            args: Prisma.StatusUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          deleteMany: {
            args: Prisma.StatusDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.StatusUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.StatusUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          aggregate: {
            args: Prisma.StatusAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateStatus>
          }
          groupBy: {
            args: Prisma.StatusGroupByArgs<ExtArgs>,
            result: $Utils.Optional<StatusGroupByOutputType>[]
          }
          count: {
            args: Prisma.StatusCountArgs<ExtArgs>,
            result: $Utils.Optional<StatusCountAggregateOutputType> | number
          }
        }
      }
      CategoryTypes: {
        payload: Prisma.$CategoryTypesPayload<ExtArgs>
        fields: Prisma.CategoryTypesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CategoryTypesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CategoryTypesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          findFirst: {
            args: Prisma.CategoryTypesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CategoryTypesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          findMany: {
            args: Prisma.CategoryTypesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>[]
          }
          create: {
            args: Prisma.CategoryTypesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          createMany: {
            args: Prisma.CategoryTypesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.CategoryTypesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>[]
          }
          delete: {
            args: Prisma.CategoryTypesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          update: {
            args: Prisma.CategoryTypesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          deleteMany: {
            args: Prisma.CategoryTypesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.CategoryTypesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.CategoryTypesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          aggregate: {
            args: Prisma.CategoryTypesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateCategoryTypes>
          }
          groupBy: {
            args: Prisma.CategoryTypesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<CategoryTypesGroupByOutputType>[]
          }
          count: {
            args: Prisma.CategoryTypesCountArgs<ExtArgs>,
            result: $Utils.Optional<CategoryTypesCountAggregateOutputType> | number
          }
        }
      }
      Categories: {
        payload: Prisma.$CategoriesPayload<ExtArgs>
        fields: Prisma.CategoriesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CategoriesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CategoriesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          findFirst: {
            args: Prisma.CategoriesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CategoriesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          findMany: {
            args: Prisma.CategoriesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>[]
          }
          create: {
            args: Prisma.CategoriesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          createMany: {
            args: Prisma.CategoriesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.CategoriesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>[]
          }
          delete: {
            args: Prisma.CategoriesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          update: {
            args: Prisma.CategoriesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          deleteMany: {
            args: Prisma.CategoriesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.CategoriesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.CategoriesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          aggregate: {
            args: Prisma.CategoriesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateCategories>
          }
          groupBy: {
            args: Prisma.CategoriesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<CategoriesGroupByOutputType>[]
          }
          count: {
            args: Prisma.CategoriesCountArgs<ExtArgs>,
            result: $Utils.Optional<CategoriesCountAggregateOutputType> | number
          }
        }
      }
      Configurations: {
        payload: Prisma.$ConfigurationsPayload<ExtArgs>
        fields: Prisma.ConfigurationsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ConfigurationsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ConfigurationsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          findFirst: {
            args: Prisma.ConfigurationsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ConfigurationsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          findMany: {
            args: Prisma.ConfigurationsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>[]
          }
          create: {
            args: Prisma.ConfigurationsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          createMany: {
            args: Prisma.ConfigurationsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ConfigurationsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>[]
          }
          delete: {
            args: Prisma.ConfigurationsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          update: {
            args: Prisma.ConfigurationsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          deleteMany: {
            args: Prisma.ConfigurationsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ConfigurationsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ConfigurationsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          aggregate: {
            args: Prisma.ConfigurationsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateConfigurations>
          }
          groupBy: {
            args: Prisma.ConfigurationsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ConfigurationsGroupByOutputType>[]
          }
          count: {
            args: Prisma.ConfigurationsCountArgs<ExtArgs>,
            result: $Utils.Optional<ConfigurationsCountAggregateOutputType> | number
          }
        }
      }
      UserConfigurations: {
        payload: Prisma.$UserConfigurationsPayload<ExtArgs>
        fields: Prisma.UserConfigurationsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserConfigurationsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserConfigurationsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload>
          }
          findFirst: {
            args: Prisma.UserConfigurationsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserConfigurationsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload>
          }
          findMany: {
            args: Prisma.UserConfigurationsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload>[]
          }
          create: {
            args: Prisma.UserConfigurationsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload>
          }
          createMany: {
            args: Prisma.UserConfigurationsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserConfigurationsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload>[]
          }
          delete: {
            args: Prisma.UserConfigurationsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload>
          }
          update: {
            args: Prisma.UserConfigurationsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload>
          }
          deleteMany: {
            args: Prisma.UserConfigurationsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserConfigurationsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserConfigurationsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserConfigurationsPayload>
          }
          aggregate: {
            args: Prisma.UserConfigurationsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUserConfigurations>
          }
          groupBy: {
            args: Prisma.UserConfigurationsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserConfigurationsGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserConfigurationsCountArgs<ExtArgs>,
            result: $Utils.Optional<UserConfigurationsCountAggregateOutputType> | number
          }
        }
      }
      FileUploadLog: {
        payload: Prisma.$FileUploadLogPayload<ExtArgs>
        fields: Prisma.FileUploadLogFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FileUploadLogFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FileUploadLogFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload>
          }
          findFirst: {
            args: Prisma.FileUploadLogFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FileUploadLogFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload>
          }
          findMany: {
            args: Prisma.FileUploadLogFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload>[]
          }
          create: {
            args: Prisma.FileUploadLogCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload>
          }
          createMany: {
            args: Prisma.FileUploadLogCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.FileUploadLogCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload>[]
          }
          delete: {
            args: Prisma.FileUploadLogDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload>
          }
          update: {
            args: Prisma.FileUploadLogUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload>
          }
          deleteMany: {
            args: Prisma.FileUploadLogDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.FileUploadLogUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.FileUploadLogUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FileUploadLogPayload>
          }
          aggregate: {
            args: Prisma.FileUploadLogAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateFileUploadLog>
          }
          groupBy: {
            args: Prisma.FileUploadLogGroupByArgs<ExtArgs>,
            result: $Utils.Optional<FileUploadLogGroupByOutputType>[]
          }
          count: {
            args: Prisma.FileUploadLogCountArgs<ExtArgs>,
            result: $Utils.Optional<FileUploadLogCountAggregateOutputType> | number
          }
        }
      }
      DataTransferQueries: {
        payload: Prisma.$DataTransferQueriesPayload<ExtArgs>
        fields: Prisma.DataTransferQueriesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DataTransferQueriesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DataTransferQueriesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload>
          }
          findFirst: {
            args: Prisma.DataTransferQueriesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DataTransferQueriesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload>
          }
          findMany: {
            args: Prisma.DataTransferQueriesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload>[]
          }
          create: {
            args: Prisma.DataTransferQueriesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload>
          }
          createMany: {
            args: Prisma.DataTransferQueriesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.DataTransferQueriesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload>[]
          }
          delete: {
            args: Prisma.DataTransferQueriesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload>
          }
          update: {
            args: Prisma.DataTransferQueriesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload>
          }
          deleteMany: {
            args: Prisma.DataTransferQueriesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.DataTransferQueriesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.DataTransferQueriesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DataTransferQueriesPayload>
          }
          aggregate: {
            args: Prisma.DataTransferQueriesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateDataTransferQueries>
          }
          groupBy: {
            args: Prisma.DataTransferQueriesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<DataTransferQueriesGroupByOutputType>[]
          }
          count: {
            args: Prisma.DataTransferQueriesCountArgs<ExtArgs>,
            result: $Utils.Optional<DataTransferQueriesCountAggregateOutputType> | number
          }
        }
      }
      DeviceRegistration: {
        payload: Prisma.$DeviceRegistrationPayload<ExtArgs>
        fields: Prisma.DeviceRegistrationFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DeviceRegistrationFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DeviceRegistrationFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload>
          }
          findFirst: {
            args: Prisma.DeviceRegistrationFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DeviceRegistrationFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload>
          }
          findMany: {
            args: Prisma.DeviceRegistrationFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload>[]
          }
          create: {
            args: Prisma.DeviceRegistrationCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload>
          }
          createMany: {
            args: Prisma.DeviceRegistrationCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.DeviceRegistrationCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload>[]
          }
          delete: {
            args: Prisma.DeviceRegistrationDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload>
          }
          update: {
            args: Prisma.DeviceRegistrationUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload>
          }
          deleteMany: {
            args: Prisma.DeviceRegistrationDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.DeviceRegistrationUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.DeviceRegistrationUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DeviceRegistrationPayload>
          }
          aggregate: {
            args: Prisma.DeviceRegistrationAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateDeviceRegistration>
          }
          groupBy: {
            args: Prisma.DeviceRegistrationGroupByArgs<ExtArgs>,
            result: $Utils.Optional<DeviceRegistrationGroupByOutputType>[]
          }
          count: {
            args: Prisma.DeviceRegistrationCountArgs<ExtArgs>,
            result: $Utils.Optional<DeviceRegistrationCountAggregateOutputType> | number
          }
        }
      }
      Policies: {
        payload: Prisma.$PoliciesPayload<ExtArgs>
        fields: Prisma.PoliciesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.PoliciesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.PoliciesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload>
          }
          findFirst: {
            args: Prisma.PoliciesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.PoliciesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload>
          }
          findMany: {
            args: Prisma.PoliciesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload>[]
          }
          create: {
            args: Prisma.PoliciesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload>
          }
          createMany: {
            args: Prisma.PoliciesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.PoliciesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload>[]
          }
          delete: {
            args: Prisma.PoliciesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload>
          }
          update: {
            args: Prisma.PoliciesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload>
          }
          deleteMany: {
            args: Prisma.PoliciesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.PoliciesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.PoliciesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PoliciesPayload>
          }
          aggregate: {
            args: Prisma.PoliciesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregatePolicies>
          }
          groupBy: {
            args: Prisma.PoliciesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<PoliciesGroupByOutputType>[]
          }
          count: {
            args: Prisma.PoliciesCountArgs<ExtArgs>,
            result: $Utils.Optional<PoliciesCountAggregateOutputType> | number
          }
        }
      }
      UserPolicies: {
        payload: Prisma.$UserPoliciesPayload<ExtArgs>
        fields: Prisma.UserPoliciesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserPoliciesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserPoliciesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload>
          }
          findFirst: {
            args: Prisma.UserPoliciesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserPoliciesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload>
          }
          findMany: {
            args: Prisma.UserPoliciesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload>[]
          }
          create: {
            args: Prisma.UserPoliciesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload>
          }
          createMany: {
            args: Prisma.UserPoliciesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserPoliciesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload>[]
          }
          delete: {
            args: Prisma.UserPoliciesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload>
          }
          update: {
            args: Prisma.UserPoliciesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload>
          }
          deleteMany: {
            args: Prisma.UserPoliciesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserPoliciesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserPoliciesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPoliciesPayload>
          }
          aggregate: {
            args: Prisma.UserPoliciesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUserPolicies>
          }
          groupBy: {
            args: Prisma.UserPoliciesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserPoliciesGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserPoliciesCountArgs<ExtArgs>,
            result: $Utils.Optional<UserPoliciesCountAggregateOutputType> | number
          }
        }
      }
      RolePolicies: {
        payload: Prisma.$RolePoliciesPayload<ExtArgs>
        fields: Prisma.RolePoliciesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RolePoliciesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RolePoliciesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload>
          }
          findFirst: {
            args: Prisma.RolePoliciesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RolePoliciesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload>
          }
          findMany: {
            args: Prisma.RolePoliciesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload>[]
          }
          create: {
            args: Prisma.RolePoliciesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload>
          }
          createMany: {
            args: Prisma.RolePoliciesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RolePoliciesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload>[]
          }
          delete: {
            args: Prisma.RolePoliciesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload>
          }
          update: {
            args: Prisma.RolePoliciesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload>
          }
          deleteMany: {
            args: Prisma.RolePoliciesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.RolePoliciesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.RolePoliciesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePoliciesPayload>
          }
          aggregate: {
            args: Prisma.RolePoliciesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateRolePolicies>
          }
          groupBy: {
            args: Prisma.RolePoliciesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<RolePoliciesGroupByOutputType>[]
          }
          count: {
            args: Prisma.RolePoliciesCountArgs<ExtArgs>,
            result: $Utils.Optional<RolePoliciesCountAggregateOutputType> | number
          }
        }
      }
      Appversions: {
        payload: Prisma.$AppversionsPayload<ExtArgs>
        fields: Prisma.AppversionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AppversionsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AppversionsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload>
          }
          findFirst: {
            args: Prisma.AppversionsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AppversionsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload>
          }
          findMany: {
            args: Prisma.AppversionsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload>[]
          }
          create: {
            args: Prisma.AppversionsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload>
          }
          createMany: {
            args: Prisma.AppversionsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.AppversionsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload>[]
          }
          delete: {
            args: Prisma.AppversionsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload>
          }
          update: {
            args: Prisma.AppversionsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload>
          }
          deleteMany: {
            args: Prisma.AppversionsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.AppversionsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.AppversionsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$AppversionsPayload>
          }
          aggregate: {
            args: Prisma.AppversionsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateAppversions>
          }
          groupBy: {
            args: Prisma.AppversionsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<AppversionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.AppversionsCountArgs<ExtArgs>,
            result: $Utils.Optional<AppversionsCountAggregateOutputType> | number
          }
        }
      }
      ScheduledJob: {
        payload: Prisma.$ScheduledJobPayload<ExtArgs>
        fields: Prisma.ScheduledJobFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ScheduledJobFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ScheduledJobFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload>
          }
          findFirst: {
            args: Prisma.ScheduledJobFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ScheduledJobFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload>
          }
          findMany: {
            args: Prisma.ScheduledJobFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload>[]
          }
          create: {
            args: Prisma.ScheduledJobCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload>
          }
          createMany: {
            args: Prisma.ScheduledJobCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ScheduledJobCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload>[]
          }
          delete: {
            args: Prisma.ScheduledJobDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload>
          }
          update: {
            args: Prisma.ScheduledJobUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload>
          }
          deleteMany: {
            args: Prisma.ScheduledJobDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ScheduledJobUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ScheduledJobUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobPayload>
          }
          aggregate: {
            args: Prisma.ScheduledJobAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateScheduledJob>
          }
          groupBy: {
            args: Prisma.ScheduledJobGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ScheduledJobGroupByOutputType>[]
          }
          count: {
            args: Prisma.ScheduledJobCountArgs<ExtArgs>,
            result: $Utils.Optional<ScheduledJobCountAggregateOutputType> | number
          }
        }
      }
      ScheduledJobLogs: {
        payload: Prisma.$ScheduledJobLogsPayload<ExtArgs>
        fields: Prisma.ScheduledJobLogsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ScheduledJobLogsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ScheduledJobLogsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload>
          }
          findFirst: {
            args: Prisma.ScheduledJobLogsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ScheduledJobLogsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload>
          }
          findMany: {
            args: Prisma.ScheduledJobLogsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload>[]
          }
          create: {
            args: Prisma.ScheduledJobLogsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload>
          }
          createMany: {
            args: Prisma.ScheduledJobLogsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ScheduledJobLogsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload>[]
          }
          delete: {
            args: Prisma.ScheduledJobLogsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload>
          }
          update: {
            args: Prisma.ScheduledJobLogsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload>
          }
          deleteMany: {
            args: Prisma.ScheduledJobLogsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ScheduledJobLogsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ScheduledJobLogsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ScheduledJobLogsPayload>
          }
          aggregate: {
            args: Prisma.ScheduledJobLogsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateScheduledJobLogs>
          }
          groupBy: {
            args: Prisma.ScheduledJobLogsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ScheduledJobLogsGroupByOutputType>[]
          }
          count: {
            args: Prisma.ScheduledJobLogsCountArgs<ExtArgs>,
            result: $Utils.Optional<ScheduledJobLogsCountAggregateOutputType> | number
          }
        }
      }
      ApprovalWorkflow: {
        payload: Prisma.$ApprovalWorkflowPayload<ExtArgs>
        fields: Prisma.ApprovalWorkflowFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ApprovalWorkflowFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ApprovalWorkflowFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload>
          }
          findFirst: {
            args: Prisma.ApprovalWorkflowFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ApprovalWorkflowFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload>
          }
          findMany: {
            args: Prisma.ApprovalWorkflowFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload>[]
          }
          create: {
            args: Prisma.ApprovalWorkflowCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload>
          }
          createMany: {
            args: Prisma.ApprovalWorkflowCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ApprovalWorkflowCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload>[]
          }
          delete: {
            args: Prisma.ApprovalWorkflowDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload>
          }
          update: {
            args: Prisma.ApprovalWorkflowUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload>
          }
          deleteMany: {
            args: Prisma.ApprovalWorkflowDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ApprovalWorkflowUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ApprovalWorkflowUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowPayload>
          }
          aggregate: {
            args: Prisma.ApprovalWorkflowAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateApprovalWorkflow>
          }
          groupBy: {
            args: Prisma.ApprovalWorkflowGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalWorkflowGroupByOutputType>[]
          }
          count: {
            args: Prisma.ApprovalWorkflowCountArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalWorkflowCountAggregateOutputType> | number
          }
        }
      }
      ApprovalWorkflowApproverTag: {
        payload: Prisma.$ApprovalWorkflowApproverTagPayload<ExtArgs>
        fields: Prisma.ApprovalWorkflowApproverTagFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ApprovalWorkflowApproverTagFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ApprovalWorkflowApproverTagFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload>
          }
          findFirst: {
            args: Prisma.ApprovalWorkflowApproverTagFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ApprovalWorkflowApproverTagFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload>
          }
          findMany: {
            args: Prisma.ApprovalWorkflowApproverTagFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload>[]
          }
          create: {
            args: Prisma.ApprovalWorkflowApproverTagCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload>
          }
          createMany: {
            args: Prisma.ApprovalWorkflowApproverTagCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ApprovalWorkflowApproverTagCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload>[]
          }
          delete: {
            args: Prisma.ApprovalWorkflowApproverTagDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload>
          }
          update: {
            args: Prisma.ApprovalWorkflowApproverTagUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload>
          }
          deleteMany: {
            args: Prisma.ApprovalWorkflowApproverTagDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ApprovalWorkflowApproverTagUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ApprovalWorkflowApproverTagUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowApproverTagPayload>
          }
          aggregate: {
            args: Prisma.ApprovalWorkflowApproverTagAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateApprovalWorkflowApproverTag>
          }
          groupBy: {
            args: Prisma.ApprovalWorkflowApproverTagGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalWorkflowApproverTagGroupByOutputType>[]
          }
          count: {
            args: Prisma.ApprovalWorkflowApproverTagCountArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalWorkflowApproverTagCountAggregateOutputType> | number
          }
        }
      }
      ApprovalWorkflowAssignment: {
        payload: Prisma.$ApprovalWorkflowAssignmentPayload<ExtArgs>
        fields: Prisma.ApprovalWorkflowAssignmentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ApprovalWorkflowAssignmentFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ApprovalWorkflowAssignmentFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload>
          }
          findFirst: {
            args: Prisma.ApprovalWorkflowAssignmentFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ApprovalWorkflowAssignmentFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload>
          }
          findMany: {
            args: Prisma.ApprovalWorkflowAssignmentFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload>[]
          }
          create: {
            args: Prisma.ApprovalWorkflowAssignmentCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload>
          }
          createMany: {
            args: Prisma.ApprovalWorkflowAssignmentCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ApprovalWorkflowAssignmentCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload>[]
          }
          delete: {
            args: Prisma.ApprovalWorkflowAssignmentDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload>
          }
          update: {
            args: Prisma.ApprovalWorkflowAssignmentUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload>
          }
          deleteMany: {
            args: Prisma.ApprovalWorkflowAssignmentDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ApprovalWorkflowAssignmentUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ApprovalWorkflowAssignmentUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalWorkflowAssignmentPayload>
          }
          aggregate: {
            args: Prisma.ApprovalWorkflowAssignmentAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateApprovalWorkflowAssignment>
          }
          groupBy: {
            args: Prisma.ApprovalWorkflowAssignmentGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalWorkflowAssignmentGroupByOutputType>[]
          }
          count: {
            args: Prisma.ApprovalWorkflowAssignmentCountArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalWorkflowAssignmentCountAggregateOutputType> | number
          }
        }
      }
      ApprovalProcessJob: {
        payload: Prisma.$ApprovalProcessJobPayload<ExtArgs>
        fields: Prisma.ApprovalProcessJobFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ApprovalProcessJobFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ApprovalProcessJobFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload>
          }
          findFirst: {
            args: Prisma.ApprovalProcessJobFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ApprovalProcessJobFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload>
          }
          findMany: {
            args: Prisma.ApprovalProcessJobFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload>[]
          }
          create: {
            args: Prisma.ApprovalProcessJobCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload>
          }
          createMany: {
            args: Prisma.ApprovalProcessJobCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ApprovalProcessJobCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload>[]
          }
          delete: {
            args: Prisma.ApprovalProcessJobDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload>
          }
          update: {
            args: Prisma.ApprovalProcessJobUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload>
          }
          deleteMany: {
            args: Prisma.ApprovalProcessJobDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ApprovalProcessJobUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ApprovalProcessJobUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobPayload>
          }
          aggregate: {
            args: Prisma.ApprovalProcessJobAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateApprovalProcessJob>
          }
          groupBy: {
            args: Prisma.ApprovalProcessJobGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalProcessJobGroupByOutputType>[]
          }
          count: {
            args: Prisma.ApprovalProcessJobCountArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalProcessJobCountAggregateOutputType> | number
          }
        }
      }
      ApprovalProcessJobWorkflow: {
        payload: Prisma.$ApprovalProcessJobWorkflowPayload<ExtArgs>
        fields: Prisma.ApprovalProcessJobWorkflowFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ApprovalProcessJobWorkflowFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ApprovalProcessJobWorkflowFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload>
          }
          findFirst: {
            args: Prisma.ApprovalProcessJobWorkflowFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ApprovalProcessJobWorkflowFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload>
          }
          findMany: {
            args: Prisma.ApprovalProcessJobWorkflowFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload>[]
          }
          create: {
            args: Prisma.ApprovalProcessJobWorkflowCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload>
          }
          createMany: {
            args: Prisma.ApprovalProcessJobWorkflowCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ApprovalProcessJobWorkflowCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload>[]
          }
          delete: {
            args: Prisma.ApprovalProcessJobWorkflowDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload>
          }
          update: {
            args: Prisma.ApprovalProcessJobWorkflowUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload>
          }
          deleteMany: {
            args: Prisma.ApprovalProcessJobWorkflowDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ApprovalProcessJobWorkflowUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ApprovalProcessJobWorkflowUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowPayload>
          }
          aggregate: {
            args: Prisma.ApprovalProcessJobWorkflowAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateApprovalProcessJobWorkflow>
          }
          groupBy: {
            args: Prisma.ApprovalProcessJobWorkflowGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalProcessJobWorkflowGroupByOutputType>[]
          }
          count: {
            args: Prisma.ApprovalProcessJobWorkflowCountArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalProcessJobWorkflowCountAggregateOutputType> | number
          }
        }
      }
      ApprovalProcessJobWorkflowUser: {
        payload: Prisma.$ApprovalProcessJobWorkflowUserPayload<ExtArgs>
        fields: Prisma.ApprovalProcessJobWorkflowUserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ApprovalProcessJobWorkflowUserFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ApprovalProcessJobWorkflowUserFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload>
          }
          findFirst: {
            args: Prisma.ApprovalProcessJobWorkflowUserFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ApprovalProcessJobWorkflowUserFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload>
          }
          findMany: {
            args: Prisma.ApprovalProcessJobWorkflowUserFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload>[]
          }
          create: {
            args: Prisma.ApprovalProcessJobWorkflowUserCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload>
          }
          createMany: {
            args: Prisma.ApprovalProcessJobWorkflowUserCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ApprovalProcessJobWorkflowUserCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload>[]
          }
          delete: {
            args: Prisma.ApprovalProcessJobWorkflowUserDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload>
          }
          update: {
            args: Prisma.ApprovalProcessJobWorkflowUserUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload>
          }
          deleteMany: {
            args: Prisma.ApprovalProcessJobWorkflowUserDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ApprovalProcessJobWorkflowUserUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ApprovalProcessJobWorkflowUserUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ApprovalProcessJobWorkflowUserPayload>
          }
          aggregate: {
            args: Prisma.ApprovalProcessJobWorkflowUserAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateApprovalProcessJobWorkflowUser>
          }
          groupBy: {
            args: Prisma.ApprovalProcessJobWorkflowUserGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalProcessJobWorkflowUserGroupByOutputType>[]
          }
          count: {
            args: Prisma.ApprovalProcessJobWorkflowUserCountArgs<ExtArgs>,
            result: $Utils.Optional<ApprovalProcessJobWorkflowUserCountAggregateOutputType> | number
          }
        }
      }
      Delegation: {
        payload: Prisma.$DelegationPayload<ExtArgs>
        fields: Prisma.DelegationFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DelegationFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DelegationFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload>
          }
          findFirst: {
            args: Prisma.DelegationFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DelegationFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload>
          }
          findMany: {
            args: Prisma.DelegationFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload>[]
          }
          create: {
            args: Prisma.DelegationCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload>
          }
          createMany: {
            args: Prisma.DelegationCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.DelegationCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload>[]
          }
          delete: {
            args: Prisma.DelegationDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload>
          }
          update: {
            args: Prisma.DelegationUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload>
          }
          deleteMany: {
            args: Prisma.DelegationDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.DelegationUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.DelegationUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DelegationPayload>
          }
          aggregate: {
            args: Prisma.DelegationAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateDelegation>
          }
          groupBy: {
            args: Prisma.DelegationGroupByArgs<ExtArgs>,
            result: $Utils.Optional<DelegationGroupByOutputType>[]
          }
          count: {
            args: Prisma.DelegationCountArgs<ExtArgs>,
            result: $Utils.Optional<DelegationCountAggregateOutputType> | number
          }
        }
      }
      SchemaChunk: {
        payload: Prisma.$SchemaChunkPayload<ExtArgs>
        fields: Prisma.SchemaChunkFieldRefs
        operations: {
          findUnique: {
            args: Prisma.SchemaChunkFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.SchemaChunkFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload>
          }
          findFirst: {
            args: Prisma.SchemaChunkFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.SchemaChunkFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload>
          }
          findMany: {
            args: Prisma.SchemaChunkFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload>[]
          }
          create: {
            args: Prisma.SchemaChunkCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload>
          }
          createMany: {
            args: Prisma.SchemaChunkCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.SchemaChunkCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload>[]
          }
          delete: {
            args: Prisma.SchemaChunkDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload>
          }
          update: {
            args: Prisma.SchemaChunkUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload>
          }
          deleteMany: {
            args: Prisma.SchemaChunkDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.SchemaChunkUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.SchemaChunkUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SchemaChunkPayload>
          }
          aggregate: {
            args: Prisma.SchemaChunkAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateSchemaChunk>
          }
          groupBy: {
            args: Prisma.SchemaChunkGroupByArgs<ExtArgs>,
            result: $Utils.Optional<SchemaChunkGroupByOutputType>[]
          }
          count: {
            args: Prisma.SchemaChunkCountArgs<ExtArgs>,
            result: $Utils.Optional<SchemaChunkCountAggregateOutputType> | number
          }
        }
      }
      EmbeddingVectorLogs: {
        payload: Prisma.$EmbeddingVectorLogsPayload<ExtArgs>
        fields: Prisma.EmbeddingVectorLogsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EmbeddingVectorLogsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EmbeddingVectorLogsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload>
          }
          findFirst: {
            args: Prisma.EmbeddingVectorLogsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EmbeddingVectorLogsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload>
          }
          findMany: {
            args: Prisma.EmbeddingVectorLogsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload>[]
          }
          create: {
            args: Prisma.EmbeddingVectorLogsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload>
          }
          createMany: {
            args: Prisma.EmbeddingVectorLogsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.EmbeddingVectorLogsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload>[]
          }
          delete: {
            args: Prisma.EmbeddingVectorLogsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload>
          }
          update: {
            args: Prisma.EmbeddingVectorLogsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload>
          }
          deleteMany: {
            args: Prisma.EmbeddingVectorLogsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.EmbeddingVectorLogsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.EmbeddingVectorLogsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$EmbeddingVectorLogsPayload>
          }
          aggregate: {
            args: Prisma.EmbeddingVectorLogsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateEmbeddingVectorLogs>
          }
          groupBy: {
            args: Prisma.EmbeddingVectorLogsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<EmbeddingVectorLogsGroupByOutputType>[]
          }
          count: {
            args: Prisma.EmbeddingVectorLogsCountArgs<ExtArgs>,
            result: $Utils.Optional<EmbeddingVectorLogsCountAggregateOutputType> | number
          }
        }
      }
      OpenaiUsageLog: {
        payload: Prisma.$OpenaiUsageLogPayload<ExtArgs>
        fields: Prisma.OpenaiUsageLogFieldRefs
        operations: {
          findUnique: {
            args: Prisma.OpenaiUsageLogFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.OpenaiUsageLogFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload>
          }
          findFirst: {
            args: Prisma.OpenaiUsageLogFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.OpenaiUsageLogFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload>
          }
          findMany: {
            args: Prisma.OpenaiUsageLogFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload>[]
          }
          create: {
            args: Prisma.OpenaiUsageLogCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload>
          }
          createMany: {
            args: Prisma.OpenaiUsageLogCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.OpenaiUsageLogCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload>[]
          }
          delete: {
            args: Prisma.OpenaiUsageLogDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload>
          }
          update: {
            args: Prisma.OpenaiUsageLogUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload>
          }
          deleteMany: {
            args: Prisma.OpenaiUsageLogDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.OpenaiUsageLogUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.OpenaiUsageLogUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OpenaiUsageLogPayload>
          }
          aggregate: {
            args: Prisma.OpenaiUsageLogAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateOpenaiUsageLog>
          }
          groupBy: {
            args: Prisma.OpenaiUsageLogGroupByArgs<ExtArgs>,
            result: $Utils.Optional<OpenaiUsageLogGroupByOutputType>[]
          }
          count: {
            args: Prisma.OpenaiUsageLogCountArgs<ExtArgs>,
            result: $Utils.Optional<OpenaiUsageLogCountAggregateOutputType> | number
          }
        }
      }
      QueryExecutionLog: {
        payload: Prisma.$QueryExecutionLogPayload<ExtArgs>
        fields: Prisma.QueryExecutionLogFieldRefs
        operations: {
          findUnique: {
            args: Prisma.QueryExecutionLogFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.QueryExecutionLogFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload>
          }
          findFirst: {
            args: Prisma.QueryExecutionLogFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.QueryExecutionLogFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload>
          }
          findMany: {
            args: Prisma.QueryExecutionLogFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload>[]
          }
          create: {
            args: Prisma.QueryExecutionLogCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload>
          }
          createMany: {
            args: Prisma.QueryExecutionLogCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.QueryExecutionLogCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload>[]
          }
          delete: {
            args: Prisma.QueryExecutionLogDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload>
          }
          update: {
            args: Prisma.QueryExecutionLogUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload>
          }
          deleteMany: {
            args: Prisma.QueryExecutionLogDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.QueryExecutionLogUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.QueryExecutionLogUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$QueryExecutionLogPayload>
          }
          aggregate: {
            args: Prisma.QueryExecutionLogAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateQueryExecutionLog>
          }
          groupBy: {
            args: Prisma.QueryExecutionLogGroupByArgs<ExtArgs>,
            result: $Utils.Optional<QueryExecutionLogGroupByOutputType>[]
          }
          count: {
            args: Prisma.QueryExecutionLogCountArgs<ExtArgs>,
            result: $Utils.Optional<QueryExecutionLogCountAggregateOutputType> | number
          }
        }
      }
      ChildProcess: {
        payload: Prisma.$ChildProcessPayload<ExtArgs>
        fields: Prisma.ChildProcessFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ChildProcessFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ChildProcessFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload>
          }
          findFirst: {
            args: Prisma.ChildProcessFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ChildProcessFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload>
          }
          findMany: {
            args: Prisma.ChildProcessFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload>[]
          }
          create: {
            args: Prisma.ChildProcessCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload>
          }
          createMany: {
            args: Prisma.ChildProcessCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ChildProcessCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload>[]
          }
          delete: {
            args: Prisma.ChildProcessDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload>
          }
          update: {
            args: Prisma.ChildProcessUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload>
          }
          deleteMany: {
            args: Prisma.ChildProcessDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ChildProcessUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ChildProcessUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessPayload>
          }
          aggregate: {
            args: Prisma.ChildProcessAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateChildProcess>
          }
          groupBy: {
            args: Prisma.ChildProcessGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ChildProcessGroupByOutputType>[]
          }
          count: {
            args: Prisma.ChildProcessCountArgs<ExtArgs>,
            result: $Utils.Optional<ChildProcessCountAggregateOutputType> | number
          }
        }
      }
      ChildProcessLog: {
        payload: Prisma.$ChildProcessLogPayload<ExtArgs>
        fields: Prisma.ChildProcessLogFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ChildProcessLogFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ChildProcessLogFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload>
          }
          findFirst: {
            args: Prisma.ChildProcessLogFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ChildProcessLogFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload>
          }
          findMany: {
            args: Prisma.ChildProcessLogFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload>[]
          }
          create: {
            args: Prisma.ChildProcessLogCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload>
          }
          createMany: {
            args: Prisma.ChildProcessLogCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ChildProcessLogCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload>[]
          }
          delete: {
            args: Prisma.ChildProcessLogDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload>
          }
          update: {
            args: Prisma.ChildProcessLogUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload>
          }
          deleteMany: {
            args: Prisma.ChildProcessLogDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ChildProcessLogUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ChildProcessLogUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ChildProcessLogPayload>
          }
          aggregate: {
            args: Prisma.ChildProcessLogAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateChildProcessLog>
          }
          groupBy: {
            args: Prisma.ChildProcessLogGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ChildProcessLogGroupByOutputType>[]
          }
          count: {
            args: Prisma.ChildProcessLogCountArgs<ExtArgs>,
            result: $Utils.Optional<ChildProcessLogCountAggregateOutputType> | number
          }
        }
      }
      Organizations: {
        payload: Prisma.$OrganizationsPayload<ExtArgs>
        fields: Prisma.OrganizationsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.OrganizationsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.OrganizationsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload>
          }
          findFirst: {
            args: Prisma.OrganizationsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.OrganizationsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload>
          }
          findMany: {
            args: Prisma.OrganizationsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload>[]
          }
          create: {
            args: Prisma.OrganizationsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload>
          }
          createMany: {
            args: Prisma.OrganizationsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.OrganizationsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload>[]
          }
          delete: {
            args: Prisma.OrganizationsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload>
          }
          update: {
            args: Prisma.OrganizationsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload>
          }
          deleteMany: {
            args: Prisma.OrganizationsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.OrganizationsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.OrganizationsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$OrganizationsPayload>
          }
          aggregate: {
            args: Prisma.OrganizationsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateOrganizations>
          }
          groupBy: {
            args: Prisma.OrganizationsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<OrganizationsGroupByOutputType>[]
          }
          count: {
            args: Prisma.OrganizationsCountArgs<ExtArgs>,
            result: $Utils.Optional<OrganizationsCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<'define', Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    request_logs: number
    roles: number
    permissions: number
    otps: number
    created_users: number
    updated_users: number
    deleted_users: number
    created_user_details: number
    updated_user_details: number
    deleted_user_details: number
    created_roles: number
    updated_roles: number
    deleted_roles: number
    created_languages: number
    updated_languages: number
    deleted_languages: number
    created_menus: number
    updated_menus: number
    deleted_menus: number
    created_menu_items: number
    updated_menu_items: number
    deleted_menu_items: number
    created_email_templates: number
    updated_email_templates: number
    deleted_email_templates: number
    created_email_template_assignments: number
    created_email_process_jobs: number
    created_whatsapp_process_jobs: number
    created_notification_job: number
    created_import_templates: number
    updated_import_templates: number
    deleted_import_templates: number
    created_carousel_templates: number
    updated_carousel_templates: number
    deleted_carousel_templates: number
    created_whatsapp_templates: number
    updated_whatsapp_templates: number
    deleted_whatsapp_templates: number
    whatsapp_template_assignment: number
    created_export_templates: number
    updated_export_templates: number
    deleted_export_templates: number
    created_departments: number
    head_departments: number
    updated_departments: number
    deleted_departments: number
    created_designations: number
    updated_designations: number
    deleted_designations: number
    audit_logs: number
    created_category_types: number
    updated_category_types: number
    deleted_category_types: number
    created_categories: number
    updated_categories: number
    deleted_categories: number
    created_configurations: number
    updated_configurations: number
    deleted_configurations: number
    created_user_configurations: number
    updated_user_configurations: number
    deleted_user_configurations: number
    created_fin_years: number
    updated_fin_years: number
    deleted_fin_years: number
    created_doc_sequences: number
    updated_doc_sequences: number
    deleted_doc_sequences: number
    created_device_registration: number
    updated_device_registration: number
    deleted_device_registration: number
    DeviceRegistration: number
    created_import_job: number
    updated_import_job: number
    deleted_import_job: number
    created_organizations: number
    updated_organizations: number
    deleted_organizations: number
    user_policy: number
    created_policy: number
    updated_policy: number
    deleted_policy: number
    created_app_versions: number
    updated_app_versions: number
    deleted_app_versions: number
    ChildProcessLog: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    request_logs?: boolean | UserCountOutputTypeCountRequest_logsArgs
    roles?: boolean | UserCountOutputTypeCountRolesArgs
    permissions?: boolean | UserCountOutputTypeCountPermissionsArgs
    otps?: boolean | UserCountOutputTypeCountOtpsArgs
    created_users?: boolean | UserCountOutputTypeCountCreated_usersArgs
    updated_users?: boolean | UserCountOutputTypeCountUpdated_usersArgs
    deleted_users?: boolean | UserCountOutputTypeCountDeleted_usersArgs
    created_user_details?: boolean | UserCountOutputTypeCountCreated_user_detailsArgs
    updated_user_details?: boolean | UserCountOutputTypeCountUpdated_user_detailsArgs
    deleted_user_details?: boolean | UserCountOutputTypeCountDeleted_user_detailsArgs
    created_roles?: boolean | UserCountOutputTypeCountCreated_rolesArgs
    updated_roles?: boolean | UserCountOutputTypeCountUpdated_rolesArgs
    deleted_roles?: boolean | UserCountOutputTypeCountDeleted_rolesArgs
    created_languages?: boolean | UserCountOutputTypeCountCreated_languagesArgs
    updated_languages?: boolean | UserCountOutputTypeCountUpdated_languagesArgs
    deleted_languages?: boolean | UserCountOutputTypeCountDeleted_languagesArgs
    created_menus?: boolean | UserCountOutputTypeCountCreated_menusArgs
    updated_menus?: boolean | UserCountOutputTypeCountUpdated_menusArgs
    deleted_menus?: boolean | UserCountOutputTypeCountDeleted_menusArgs
    created_menu_items?: boolean | UserCountOutputTypeCountCreated_menu_itemsArgs
    updated_menu_items?: boolean | UserCountOutputTypeCountUpdated_menu_itemsArgs
    deleted_menu_items?: boolean | UserCountOutputTypeCountDeleted_menu_itemsArgs
    created_email_templates?: boolean | UserCountOutputTypeCountCreated_email_templatesArgs
    updated_email_templates?: boolean | UserCountOutputTypeCountUpdated_email_templatesArgs
    deleted_email_templates?: boolean | UserCountOutputTypeCountDeleted_email_templatesArgs
    created_email_template_assignments?: boolean | UserCountOutputTypeCountCreated_email_template_assignmentsArgs
    created_email_process_jobs?: boolean | UserCountOutputTypeCountCreated_email_process_jobsArgs
    created_whatsapp_process_jobs?: boolean | UserCountOutputTypeCountCreated_whatsapp_process_jobsArgs
    created_notification_job?: boolean | UserCountOutputTypeCountCreated_notification_jobArgs
    created_import_templates?: boolean | UserCountOutputTypeCountCreated_import_templatesArgs
    updated_import_templates?: boolean | UserCountOutputTypeCountUpdated_import_templatesArgs
    deleted_import_templates?: boolean | UserCountOutputTypeCountDeleted_import_templatesArgs
    created_carousel_templates?: boolean | UserCountOutputTypeCountCreated_carousel_templatesArgs
    updated_carousel_templates?: boolean | UserCountOutputTypeCountUpdated_carousel_templatesArgs
    deleted_carousel_templates?: boolean | UserCountOutputTypeCountDeleted_carousel_templatesArgs
    created_whatsapp_templates?: boolean | UserCountOutputTypeCountCreated_whatsapp_templatesArgs
    updated_whatsapp_templates?: boolean | UserCountOutputTypeCountUpdated_whatsapp_templatesArgs
    deleted_whatsapp_templates?: boolean | UserCountOutputTypeCountDeleted_whatsapp_templatesArgs
    whatsapp_template_assignment?: boolean | UserCountOutputTypeCountWhatsapp_template_assignmentArgs
    created_export_templates?: boolean | UserCountOutputTypeCountCreated_export_templatesArgs
    updated_export_templates?: boolean | UserCountOutputTypeCountUpdated_export_templatesArgs
    deleted_export_templates?: boolean | UserCountOutputTypeCountDeleted_export_templatesArgs
    created_departments?: boolean | UserCountOutputTypeCountCreated_departmentsArgs
    head_departments?: boolean | UserCountOutputTypeCountHead_departmentsArgs
    updated_departments?: boolean | UserCountOutputTypeCountUpdated_departmentsArgs
    deleted_departments?: boolean | UserCountOutputTypeCountDeleted_departmentsArgs
    created_designations?: boolean | UserCountOutputTypeCountCreated_designationsArgs
    updated_designations?: boolean | UserCountOutputTypeCountUpdated_designationsArgs
    deleted_designations?: boolean | UserCountOutputTypeCountDeleted_designationsArgs
    audit_logs?: boolean | UserCountOutputTypeCountAudit_logsArgs
    created_category_types?: boolean | UserCountOutputTypeCountCreated_category_typesArgs
    updated_category_types?: boolean | UserCountOutputTypeCountUpdated_category_typesArgs
    deleted_category_types?: boolean | UserCountOutputTypeCountDeleted_category_typesArgs
    created_categories?: boolean | UserCountOutputTypeCountCreated_categoriesArgs
    updated_categories?: boolean | UserCountOutputTypeCountUpdated_categoriesArgs
    deleted_categories?: boolean | UserCountOutputTypeCountDeleted_categoriesArgs
    created_configurations?: boolean | UserCountOutputTypeCountCreated_configurationsArgs
    updated_configurations?: boolean | UserCountOutputTypeCountUpdated_configurationsArgs
    deleted_configurations?: boolean | UserCountOutputTypeCountDeleted_configurationsArgs
    created_user_configurations?: boolean | UserCountOutputTypeCountCreated_user_configurationsArgs
    updated_user_configurations?: boolean | UserCountOutputTypeCountUpdated_user_configurationsArgs
    deleted_user_configurations?: boolean | UserCountOutputTypeCountDeleted_user_configurationsArgs
    created_fin_years?: boolean | UserCountOutputTypeCountCreated_fin_yearsArgs
    updated_fin_years?: boolean | UserCountOutputTypeCountUpdated_fin_yearsArgs
    deleted_fin_years?: boolean | UserCountOutputTypeCountDeleted_fin_yearsArgs
    created_doc_sequences?: boolean | UserCountOutputTypeCountCreated_doc_sequencesArgs
    updated_doc_sequences?: boolean | UserCountOutputTypeCountUpdated_doc_sequencesArgs
    deleted_doc_sequences?: boolean | UserCountOutputTypeCountDeleted_doc_sequencesArgs
    created_device_registration?: boolean | UserCountOutputTypeCountCreated_device_registrationArgs
    updated_device_registration?: boolean | UserCountOutputTypeCountUpdated_device_registrationArgs
    deleted_device_registration?: boolean | UserCountOutputTypeCountDeleted_device_registrationArgs
    DeviceRegistration?: boolean | UserCountOutputTypeCountDeviceRegistrationArgs
    created_import_job?: boolean | UserCountOutputTypeCountCreated_import_jobArgs
    updated_import_job?: boolean | UserCountOutputTypeCountUpdated_import_jobArgs
    deleted_import_job?: boolean | UserCountOutputTypeCountDeleted_import_jobArgs
    created_organizations?: boolean | UserCountOutputTypeCountCreated_organizationsArgs
    updated_organizations?: boolean | UserCountOutputTypeCountUpdated_organizationsArgs
    deleted_organizations?: boolean | UserCountOutputTypeCountDeleted_organizationsArgs
    user_policy?: boolean | UserCountOutputTypeCountUser_policyArgs
    created_policy?: boolean | UserCountOutputTypeCountCreated_policyArgs
    updated_policy?: boolean | UserCountOutputTypeCountUpdated_policyArgs
    deleted_policy?: boolean | UserCountOutputTypeCountDeleted_policyArgs
    created_app_versions?: boolean | UserCountOutputTypeCountCreated_app_versionsArgs
    updated_app_versions?: boolean | UserCountOutputTypeCountUpdated_app_versionsArgs
    deleted_app_versions?: boolean | UserCountOutputTypeCountDeleted_app_versionsArgs
    ChildProcessLog?: boolean | UserCountOutputTypeCountChildProcessLogArgs
  }

  // Custom InputTypes
  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountRequest_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RequestLogWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRolesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountPermissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPermissionsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountOtpsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: OtpWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_menusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenusWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_menusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenusWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_menusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenusWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_menu_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_menu_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_menu_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_email_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_email_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_email_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_email_template_assignmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateAssignmentWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_email_process_jobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailProcessJobWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_whatsapp_process_jobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappProcessJobWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_notification_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: NotificationJobWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_import_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_import_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_import_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_carousel_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CarouselTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_carousel_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CarouselTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_carousel_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CarouselTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_whatsapp_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_whatsapp_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_whatsapp_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountWhatsapp_template_assignmentArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateAssignmentWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_export_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_export_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_export_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountHead_departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_designationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DesignationWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_designationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DesignationWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_designationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DesignationWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAudit_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuditLogWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_category_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoryTypesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_category_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoryTypesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_category_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoryTypesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ConfigurationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ConfigurationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ConfigurationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_user_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserConfigurationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_user_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserConfigurationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_user_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserConfigurationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_fin_yearsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FinancialYearWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_fin_yearsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FinancialYearWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_fin_yearsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FinancialYearWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_doc_sequencesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentSequenceWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_doc_sequencesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentSequenceWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_doc_sequencesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentSequenceWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_device_registrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DeviceRegistrationWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_device_registrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DeviceRegistrationWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_device_registrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DeviceRegistrationWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeviceRegistrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DeviceRegistrationWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_import_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportJobWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_import_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportJobWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_import_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportJobWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_organizationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: OrganizationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_organizationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: OrganizationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_organizationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: OrganizationsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUser_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPoliciesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PoliciesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PoliciesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PoliciesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_app_versionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AppversionsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_app_versionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AppversionsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_app_versionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AppversionsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountChildProcessLogArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ChildProcessLogWhereInput
  }


  /**
   * Count Type DesignationCountOutputType
   */

  export type DesignationCountOutputType = {
    users: number
  }

  export type DesignationCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    users?: boolean | DesignationCountOutputTypeCountUsersArgs
  }

  // Custom InputTypes
  /**
   * DesignationCountOutputType without action
   */
  export type DesignationCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DesignationCountOutputType
     */
    select?: DesignationCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * DesignationCountOutputType without action
   */
  export type DesignationCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }


  /**
   * Count Type DepartmentCountOutputType
   */

  export type DepartmentCountOutputType = {
    users: number
  }

  export type DepartmentCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    users?: boolean | DepartmentCountOutputTypeCountUsersArgs
  }

  // Custom InputTypes
  /**
   * DepartmentCountOutputType without action
   */
  export type DepartmentCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DepartmentCountOutputType
     */
    select?: DepartmentCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * DepartmentCountOutputType without action
   */
  export type DepartmentCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }


  /**
   * Count Type FinancialYearCountOutputType
   */

  export type FinancialYearCountOutputType = {
    document_sequence: number
  }

  export type FinancialYearCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    document_sequence?: boolean | FinancialYearCountOutputTypeCountDocument_sequenceArgs
  }

  // Custom InputTypes
  /**
   * FinancialYearCountOutputType without action
   */
  export type FinancialYearCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYearCountOutputType
     */
    select?: FinancialYearCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * FinancialYearCountOutputType without action
   */
  export type FinancialYearCountOutputTypeCountDocument_sequenceArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentSequenceWhereInput
  }


  /**
   * Count Type PermissionsCountOutputType
   */

  export type PermissionsCountOutputType = {
    roles: number
    users: number
    menus: number
  }

  export type PermissionsCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    roles?: boolean | PermissionsCountOutputTypeCountRolesArgs
    users?: boolean | PermissionsCountOutputTypeCountUsersArgs
    menus?: boolean | PermissionsCountOutputTypeCountMenusArgs
  }

  // Custom InputTypes
  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PermissionsCountOutputType
     */
    select?: PermissionsCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RolePermissionsWhereInput
  }

  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPermissionsWhereInput
  }

  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeCountMenusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }


  /**
   * Count Type RoleCountOutputType
   */

  export type RoleCountOutputType = {
    permissions: number
    users: number
    role_policy: number
  }

  export type RoleCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    permissions?: boolean | RoleCountOutputTypeCountPermissionsArgs
    users?: boolean | RoleCountOutputTypeCountUsersArgs
    role_policy?: boolean | RoleCountOutputTypeCountRole_policyArgs
  }

  // Custom InputTypes
  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RoleCountOutputType
     */
    select?: RoleCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeCountPermissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RolePermissionsWhereInput
  }

  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRolesWhereInput
  }

  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeCountRole_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RolePoliciesWhereInput
  }


  /**
   * Count Type LanguageCountOutputType
   */

  export type LanguageCountOutputType = {
    translations: number
  }

  export type LanguageCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    translations?: boolean | LanguageCountOutputTypeCountTranslationsArgs
  }

  // Custom InputTypes
  /**
   * LanguageCountOutputType without action
   */
  export type LanguageCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the LanguageCountOutputType
     */
    select?: LanguageCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * LanguageCountOutputType without action
   */
  export type LanguageCountOutputTypeCountTranslationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageContentWhereInput
  }


  /**
   * Count Type MenusCountOutputType
   */

  export type MenusCountOutputType = {
    menuitems: number
  }

  export type MenusCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    menuitems?: boolean | MenusCountOutputTypeCountMenuitemsArgs
  }

  // Custom InputTypes
  /**
   * MenusCountOutputType without action
   */
  export type MenusCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenusCountOutputType
     */
    select?: MenusCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * MenusCountOutputType without action
   */
  export type MenusCountOutputTypeCountMenuitemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }


  /**
   * Count Type MenuItemsCountOutputType
   */

  export type MenuItemsCountOutputType = {
    children: number
  }

  export type MenuItemsCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    children?: boolean | MenuItemsCountOutputTypeCountChildrenArgs
  }

  // Custom InputTypes
  /**
   * MenuItemsCountOutputType without action
   */
  export type MenuItemsCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItemsCountOutputType
     */
    select?: MenuItemsCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * MenuItemsCountOutputType without action
   */
  export type MenuItemsCountOutputTypeCountChildrenArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }


  /**
   * Count Type MasterEntityCountOutputType
   */

  export type MasterEntityCountOutputType = {
    permissions: number
    line_items: number
    menus: number
  }

  export type MasterEntityCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    permissions?: boolean | MasterEntityCountOutputTypeCountPermissionsArgs
    line_items?: boolean | MasterEntityCountOutputTypeCountLine_itemsArgs
    menus?: boolean | MasterEntityCountOutputTypeCountMenusArgs
  }

  // Custom InputTypes
  /**
   * MasterEntityCountOutputType without action
   */
  export type MasterEntityCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityCountOutputType
     */
    select?: MasterEntityCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * MasterEntityCountOutputType without action
   */
  export type MasterEntityCountOutputTypeCountPermissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PermissionsWhereInput
  }

  /**
   * MasterEntityCountOutputType without action
   */
  export type MasterEntityCountOutputTypeCountLine_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityLineItemWhereInput
  }

  /**
   * MasterEntityCountOutputType without action
   */
  export type MasterEntityCountOutputTypeCountMenusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }


  /**
   * Count Type FieldTypeCountOutputType
   */

  export type FieldTypeCountOutputType = {
    master_grid_lineitem: number
    importTemplateLineItem: number
    exportTemplateLineItem: number
  }

  export type FieldTypeCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    master_grid_lineitem?: boolean | FieldTypeCountOutputTypeCountMaster_grid_lineitemArgs
    importTemplateLineItem?: boolean | FieldTypeCountOutputTypeCountImportTemplateLineItemArgs
    exportTemplateLineItem?: boolean | FieldTypeCountOutputTypeCountExportTemplateLineItemArgs
  }

  // Custom InputTypes
  /**
   * FieldTypeCountOutputType without action
   */
  export type FieldTypeCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldTypeCountOutputType
     */
    select?: FieldTypeCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * FieldTypeCountOutputType without action
   */
  export type FieldTypeCountOutputTypeCountMaster_grid_lineitemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityLineItemWhereInput
  }

  /**
   * FieldTypeCountOutputType without action
   */
  export type FieldTypeCountOutputTypeCountImportTemplateLineItemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateLineItemWhereInput
  }

  /**
   * FieldTypeCountOutputType without action
   */
  export type FieldTypeCountOutputTypeCountExportTemplateLineItemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateLineItemWhereInput
  }


  /**
   * Count Type EmailTemplateProcessCountOutputType
   */

  export type EmailTemplateProcessCountOutputType = {
    email_template_groups: number
    email_templates: number
    email_template_assignments: number
  }

  export type EmailTemplateProcessCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    email_template_groups?: boolean | EmailTemplateProcessCountOutputTypeCountEmail_template_groupsArgs
    email_templates?: boolean | EmailTemplateProcessCountOutputTypeCountEmail_templatesArgs
    email_template_assignments?: boolean | EmailTemplateProcessCountOutputTypeCountEmail_template_assignmentsArgs
  }

  // Custom InputTypes
  /**
   * EmailTemplateProcessCountOutputType without action
   */
  export type EmailTemplateProcessCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailTemplateProcessCountOutputType
     */
    select?: EmailTemplateProcessCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * EmailTemplateProcessCountOutputType without action
   */
  export type EmailTemplateProcessCountOutputTypeCountEmail_template_groupsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateProcessTagsMappingWhereInput
  }

  /**
   * EmailTemplateProcessCountOutputType without action
   */
  export type EmailTemplateProcessCountOutputTypeCountEmail_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateWhereInput
  }

  /**
   * EmailTemplateProcessCountOutputType without action
   */
  export type EmailTemplateProcessCountOutputTypeCountEmail_template_assignmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateAssignmentWhereInput
  }


  /**
   * Count Type EmailTemplateTagCountOutputType
   */

  export type EmailTemplateTagCountOutputType = {
    email_template_groups: number
  }

  export type EmailTemplateTagCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    email_template_groups?: boolean | EmailTemplateTagCountOutputTypeCountEmail_template_groupsArgs
  }

  // Custom InputTypes
  /**
   * EmailTemplateTagCountOutputType without action
   */
  export type EmailTemplateTagCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailTemplateTagCountOutputType
     */
    select?: EmailTemplateTagCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * EmailTemplateTagCountOutputType without action
   */
  export type EmailTemplateTagCountOutputTypeCountEmail_template_groupsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateProcessTagsMappingWhereInput
  }


  /**
   * Count Type EmailTemplateCountOutputType
   */

  export type EmailTemplateCountOutputType = {
    email_template_assignments: number
    approval_workflow_assignments_approve: number
    approval_workflow_assignments_reject: number
  }

  export type EmailTemplateCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    email_template_assignments?: boolean | EmailTemplateCountOutputTypeCountEmail_template_assignmentsArgs
    approval_workflow_assignments_approve?: boolean | EmailTemplateCountOutputTypeCountApproval_workflow_assignments_approveArgs
    approval_workflow_assignments_reject?: boolean | EmailTemplateCountOutputTypeCountApproval_workflow_assignments_rejectArgs
  }

  // Custom InputTypes
  /**
   * EmailTemplateCountOutputType without action
   */
  export type EmailTemplateCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailTemplateCountOutputType
     */
    select?: EmailTemplateCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * EmailTemplateCountOutputType without action
   */
  export type EmailTemplateCountOutputTypeCountEmail_template_assignmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateAssignmentWhereInput
  }

  /**
   * EmailTemplateCountOutputType without action
   */
  export type EmailTemplateCountOutputTypeCountApproval_workflow_assignments_approveArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalWorkflowAssignmentWhereInput
  }

  /**
   * EmailTemplateCountOutputType without action
   */
  export type EmailTemplateCountOutputTypeCountApproval_workflow_assignments_rejectArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalWorkflowAssignmentWhereInput
  }


  /**
   * Count Type EmailTemplateAssignmentCountOutputType
   */

  export type EmailTemplateAssignmentCountOutputType = {
    email_template_cc_bcc: number
  }

  export type EmailTemplateAssignmentCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    email_template_cc_bcc?: boolean | EmailTemplateAssignmentCountOutputTypeCountEmail_template_cc_bccArgs
  }

  // Custom InputTypes
  /**
   * EmailTemplateAssignmentCountOutputType without action
   */
  export type EmailTemplateAssignmentCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailTemplateAssignmentCountOutputType
     */
    select?: EmailTemplateAssignmentCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * EmailTemplateAssignmentCountOutputType without action
   */
  export type EmailTemplateAssignmentCountOutputTypeCountEmail_template_cc_bccArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateCcBccWhereInput
  }


  /**
   * Count Type WhatsappTemplateProcessCountOutputType
   */

  export type WhatsappTemplateProcessCountOutputType = {
    whatsapp_template_groups: number
    whatsapp_templates: number
    whatsapp_template_assignments: number
  }

  export type WhatsappTemplateProcessCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    whatsapp_template_groups?: boolean | WhatsappTemplateProcessCountOutputTypeCountWhatsapp_template_groupsArgs
    whatsapp_templates?: boolean | WhatsappTemplateProcessCountOutputTypeCountWhatsapp_templatesArgs
    whatsapp_template_assignments?: boolean | WhatsappTemplateProcessCountOutputTypeCountWhatsapp_template_assignmentsArgs
  }

  // Custom InputTypes
  /**
   * WhatsappTemplateProcessCountOutputType without action
   */
  export type WhatsappTemplateProcessCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WhatsappTemplateProcessCountOutputType
     */
    select?: WhatsappTemplateProcessCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * WhatsappTemplateProcessCountOutputType without action
   */
  export type WhatsappTemplateProcessCountOutputTypeCountWhatsapp_template_groupsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateProcessTagsMappingWhereInput
  }

  /**
   * WhatsappTemplateProcessCountOutputType without action
   */
  export type WhatsappTemplateProcessCountOutputTypeCountWhatsapp_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateWhereInput
  }

  /**
   * WhatsappTemplateProcessCountOutputType without action
   */
  export type WhatsappTemplateProcessCountOutputTypeCountWhatsapp_template_assignmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateAssignmentWhereInput
  }


  /**
   * Count Type WhatsappTemplateTagCountOutputType
   */

  export type WhatsappTemplateTagCountOutputType = {
    whatsapp_template_groups: number
  }

  export type WhatsappTemplateTagCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    whatsapp_template_groups?: boolean | WhatsappTemplateTagCountOutputTypeCountWhatsapp_template_groupsArgs
  }

  // Custom InputTypes
  /**
   * WhatsappTemplateTagCountOutputType without action
   */
  export type WhatsappTemplateTagCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WhatsappTemplateTagCountOutputType
     */
    select?: WhatsappTemplateTagCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * WhatsappTemplateTagCountOutputType without action
   */
  export type WhatsappTemplateTagCountOutputTypeCountWhatsapp_template_groupsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateProcessTagsMappingWhereInput
  }


  /**
   * Count Type WhatsappTemplateCountOutputType
   */

  export type WhatsappTemplateCountOutputType = {
    whatsapp_template_assignments: number
    approval_workflow_assignments_approve: number
    approval_workflow_assignments_reject: number
  }

  export type WhatsappTemplateCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    whatsapp_template_assignments?: boolean | WhatsappTemplateCountOutputTypeCountWhatsapp_template_assignmentsArgs
    approval_workflow_assignments_approve?: boolean | WhatsappTemplateCountOutputTypeCountApproval_workflow_assignments_approveArgs
    approval_workflow_assignments_reject?: boolean | WhatsappTemplateCountOutputTypeCountApproval_workflow_assignments_rejectArgs
  }

  // Custom InputTypes
  /**
   * WhatsappTemplateCountOutputType without action
   */
  export type WhatsappTemplateCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WhatsappTemplateCountOutputType
     */
    select?: WhatsappTemplateCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * WhatsappTemplateCountOutputType without action
   */
  export type WhatsappTemplateCountOutputTypeCountWhatsapp_template_assignmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateAssignmentWhereInput
  }

  /**
   * WhatsappTemplateCountOutputType without action
   */
  export type WhatsappTemplateCountOutputTypeCountApproval_workflow_assignments_approveArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalWorkflowAssignmentWhereInput
  }

  /**
   * WhatsappTemplateCountOutputType without action
   */
  export type WhatsappTemplateCountOutputTypeCountApproval_workflow_assignments_rejectArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalWorkflowAssignmentWhereInput
  }


  /**
   * Count Type CarouselTemplateCountOutputType
   */

  export type CarouselTemplateCountOutputType = {
    line_items: number
  }

  export type CarouselTemplateCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    line_items?: boolean | CarouselTemplateCountOutputTypeCountLine_itemsArgs
  }

  // Custom InputTypes
  /**
   * CarouselTemplateCountOutputType without action
   */
  export type CarouselTemplateCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CarouselTemplateCountOutputType
     */
    select?: CarouselTemplateCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CarouselTemplateCountOutputType without action
   */
  export type CarouselTemplateCountOutputTypeCountLine_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CarouselTemplateLineItemWhereInput
  }


  /**
   * Count Type ImportTemplateCountOutputType
   */

  export type ImportTemplateCountOutputType = {
    line_items: number
    queries: number
  }

  export type ImportTemplateCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    line_items?: boolean | ImportTemplateCountOutputTypeCountLine_itemsArgs
    queries?: boolean | ImportTemplateCountOutputTypeCountQueriesArgs
  }

  // Custom InputTypes
  /**
   * ImportTemplateCountOutputType without action
   */
  export type ImportTemplateCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ImportTemplateCountOutputType
     */
    select?: ImportTemplateCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ImportTemplateCountOutputType without action
   */
  export type ImportTemplateCountOutputTypeCountLine_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateLineItemWhereInput
  }

  /**
   * ImportTemplateCountOutputType without action
   */
  export type ImportTemplateCountOutputTypeCountQueriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateQueriesWhereInput
  }


  /**
   * Count Type ImportJobCountOutputType
   */

  export type ImportJobCountOutputType = {
    line_items: number
  }

  export type ImportJobCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    line_items?: boolean | ImportJobCountOutputTypeCountLine_itemsArgs
  }

  // Custom InputTypes
  /**
   * ImportJobCountOutputType without action
   */
  export type ImportJobCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ImportJobCountOutputType
     */
    select?: ImportJobCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ImportJobCountOutputType without action
   */
  export type ImportJobCountOutputTypeCountLine_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportJobLineItemWhereInput
  }


  /**
   * Count Type ExportTemplateCountOutputType
   */

  export type ExportTemplateCountOutputType = {
    line_items: number
    queries: number
  }

  export type ExportTemplateCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    line_items?: boolean | ExportTemplateCountOutputTypeCountLine_itemsArgs
    queries?: boolean | ExportTemplateCountOutputTypeCountQueriesArgs
  }

  // Custom InputTypes
  /**
   * ExportTemplateCountOutputType without action
   */
  export type ExportTemplateCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ExportTemplateCountOutputType
     */
    select?: ExportTemplateCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ExportTemplateCountOutputType without action
   */
  export type ExportTemplateCountOutputTypeCountLine_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateLineItemWhereInput
  }

  /**
   * ExportTemplateCountOutputType without action
   */
  export type ExportTemplateCountOutputTypeCountQueriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateQueriesWhereInput
  }


  /**
   * Count Type StatusCountOutputType
   */

  export type StatusCountOutputType = {
    status_list: number
    users: number
    request_logs: number
    permissions: number
    roles: number
    languages: number
    language_contents: number
    menuitems: number
    menus: number
    master_grids: number
    master_grid_line_items: number
    field_types: number
    menu_types: number
    email_template_processes: number
    email_template_tags: number
    email_template_receiver_tags: number
    email_templates: number
    email_process_jobs: number
    notification_job: number
    import_templates: number
    import_template_line_items: number
    import_template_queries: number
    export_templates: number
    export_template_line_items: number
    export_template_queries: number
    designations: number
    departments: number
    audit_logs: number
    financial_years: number
    document_sequences: number
    file_upload_logs: number
    device_registration: number
    import_job: number
    import_job_line_items: number
    policies: number
    app_versions: number
    approval_workflows: number
    approval_process_job_workflows: number
    approval_workflow_approver_tags: number
    approval_workflow_assignments: number
    approval_process_job: number
    approval_process_job_workflow_users: number
    delegations: number
    about_lcp: number
    schema_chunks: number
    openai_usage_logs: number
    embedding_vector_logs: number
    query_execution_log: number
    child_processes: number
    child_process_logs: number
    carousel_templates: number
    carousel_template_line_items: number
    scheduled_job_logs: number
    scheduled_jobs: number
    whatsapp_template_process: number
    whatsapp_template_tag: number
    whatsapp_template_recipient_tag: number
    whatsapp_template: number
    whatsapp_process_jobs: number
    app_categories: number
    organizations: number
  }

  export type StatusCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status_list?: boolean | StatusCountOutputTypeCountStatus_listArgs
    users?: boolean | StatusCountOutputTypeCountUsersArgs
    request_logs?: boolean | StatusCountOutputTypeCountRequest_logsArgs
    permissions?: boolean | StatusCountOutputTypeCountPermissionsArgs
    roles?: boolean | StatusCountOutputTypeCountRolesArgs
    languages?: boolean | StatusCountOutputTypeCountLanguagesArgs
    language_contents?: boolean | StatusCountOutputTypeCountLanguage_contentsArgs
    menuitems?: boolean | StatusCountOutputTypeCountMenuitemsArgs
    menus?: boolean | StatusCountOutputTypeCountMenusArgs
    master_grids?: boolean | StatusCountOutputTypeCountMaster_gridsArgs
    master_grid_line_items?: boolean | StatusCountOutputTypeCountMaster_grid_line_itemsArgs
    field_types?: boolean | StatusCountOutputTypeCountField_typesArgs
    menu_types?: boolean | StatusCountOutputTypeCountMenu_typesArgs
    email_template_processes?: boolean | StatusCountOutputTypeCountEmail_template_processesArgs
    email_template_tags?: boolean | StatusCountOutputTypeCountEmail_template_tagsArgs
    email_template_receiver_tags?: boolean | StatusCountOutputTypeCountEmail_template_receiver_tagsArgs
    email_templates?: boolean | StatusCountOutputTypeCountEmail_templatesArgs
    email_process_jobs?: boolean | StatusCountOutputTypeCountEmail_process_jobsArgs
    notification_job?: boolean | StatusCountOutputTypeCountNotification_jobArgs
    import_templates?: boolean | StatusCountOutputTypeCountImport_templatesArgs
    import_template_line_items?: boolean | StatusCountOutputTypeCountImport_template_line_itemsArgs
    import_template_queries?: boolean | StatusCountOutputTypeCountImport_template_queriesArgs
    export_templates?: boolean | StatusCountOutputTypeCountExport_templatesArgs
    export_template_line_items?: boolean | StatusCountOutputTypeCountExport_template_line_itemsArgs
    export_template_queries?: boolean | StatusCountOutputTypeCountExport_template_queriesArgs
    designations?: boolean | StatusCountOutputTypeCountDesignationsArgs
    departments?: boolean | StatusCountOutputTypeCountDepartmentsArgs
    audit_logs?: boolean | StatusCountOutputTypeCountAudit_logsArgs
    financial_years?: boolean | StatusCountOutputTypeCountFinancial_yearsArgs
    document_sequences?: boolean | StatusCountOutputTypeCountDocument_sequencesArgs
    file_upload_logs?: boolean | StatusCountOutputTypeCountFile_upload_logsArgs
    device_registration?: boolean | StatusCountOutputTypeCountDevice_registrationArgs
    import_job?: boolean | StatusCountOutputTypeCountImport_jobArgs
    import_job_line_items?: boolean | StatusCountOutputTypeCountImport_job_line_itemsArgs
    policies?: boolean | StatusCountOutputTypeCountPoliciesArgs
    app_versions?: boolean | StatusCountOutputTypeCountApp_versionsArgs
    approval_workflows?: boolean | StatusCountOutputTypeCountApproval_workflowsArgs
    approval_process_job_workflows?: boolean | StatusCountOutputTypeCountApproval_process_job_workflowsArgs
    approval_workflow_approver_tags?: boolean | StatusCountOutputTypeCountApproval_workflow_approver_tagsArgs
    approval_workflow_assignments?: boolean | StatusCountOutputTypeCountApproval_workflow_assignmentsArgs
    approval_process_job?: boolean | StatusCountOutputTypeCountApproval_process_jobArgs
    approval_process_job_workflow_users?: boolean | StatusCountOutputTypeCountApproval_process_job_workflow_usersArgs
    delegations?: boolean | StatusCountOutputTypeCountDelegationsArgs
    about_lcp?: boolean | StatusCountOutputTypeCountAbout_lcpArgs
    schema_chunks?: boolean | StatusCountOutputTypeCountSchema_chunksArgs
    openai_usage_logs?: boolean | StatusCountOutputTypeCountOpenai_usage_logsArgs
    embedding_vector_logs?: boolean | StatusCountOutputTypeCountEmbedding_vector_logsArgs
    query_execution_log?: boolean | StatusCountOutputTypeCountQuery_execution_logArgs
    child_processes?: boolean | StatusCountOutputTypeCountChild_processesArgs
    child_process_logs?: boolean | StatusCountOutputTypeCountChild_process_logsArgs
    carousel_templates?: boolean | StatusCountOutputTypeCountCarousel_templatesArgs
    carousel_template_line_items?: boolean | StatusCountOutputTypeCountCarousel_template_line_itemsArgs
    scheduled_job_logs?: boolean | StatusCountOutputTypeCountScheduled_job_logsArgs
    scheduled_jobs?: boolean | StatusCountOutputTypeCountScheduled_jobsArgs
    whatsapp_template_process?: boolean | StatusCountOutputTypeCountWhatsapp_template_processArgs
    whatsapp_template_tag?: boolean | StatusCountOutputTypeCountWhatsapp_template_tagArgs
    whatsapp_template_recipient_tag?: boolean | StatusCountOutputTypeCountWhatsapp_template_recipient_tagArgs
    whatsapp_template?: boolean | StatusCountOutputTypeCountWhatsapp_templateArgs
    whatsapp_process_jobs?: boolean | StatusCountOutputTypeCountWhatsapp_process_jobsArgs
    app_categories?: boolean | StatusCountOutputTypeCountApp_categoriesArgs
    organizations?: boolean | StatusCountOutputTypeCountOrganizationsArgs
  }

  // Custom InputTypes
  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StatusCountOutputType
     */
    select?: StatusCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountStatus_listArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: StatusWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountRequest_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RequestLogWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountPermissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PermissionsWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountLanguagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountLanguage_contentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageContentWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMenuitemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMenusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenusWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMaster_gridsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMaster_grid_line_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityLineItemWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountField_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FieldTypeWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMenu_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: menuTypeWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountEmail_template_processesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateProcessWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountEmail_template_tagsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateTagWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountEmail_template_receiver_tagsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateRecipientTagWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountEmail_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailTemplateWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountEmail_process_jobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmailProcessJobWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountNotification_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: NotificationJobWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountImport_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountImport_template_line_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateLineItemWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountImport_template_queriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportTemplateQueriesWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountExport_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountExport_template_line_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateLineItemWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountExport_template_queriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ExportTemplateQueriesWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountDesignationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DesignationWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountDepartmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountAudit_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuditLogWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountFinancial_yearsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FinancialYearWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountDocument_sequencesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentSequenceWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountFile_upload_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FileUploadLogWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountDevice_registrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DeviceRegistrationWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountImport_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportJobWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountImport_job_line_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ImportJobLineItemWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountPoliciesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PoliciesWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountApp_versionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AppversionsWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountApproval_workflowsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalWorkflowWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountApproval_process_job_workflowsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalProcessJobWorkflowWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountApproval_workflow_approver_tagsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalWorkflowApproverTagWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountApproval_workflow_assignmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalWorkflowAssignmentWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountApproval_process_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalProcessJobWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountApproval_process_job_workflow_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalProcessJobWorkflowUserWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountDelegationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DelegationWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountAbout_lcpArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AboutLCPWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountSchema_chunksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: SchemaChunkWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountOpenai_usage_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: OpenaiUsageLogWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountEmbedding_vector_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: EmbeddingVectorLogsWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountQuery_execution_logArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: QueryExecutionLogWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountChild_processesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ChildProcessWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountChild_process_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ChildProcessLogWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountCarousel_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CarouselTemplateWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountCarousel_template_line_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CarouselTemplateLineItemWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountScheduled_job_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ScheduledJobLogsWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountScheduled_jobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ScheduledJobWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountWhatsapp_template_processArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateProcessWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountWhatsapp_template_tagArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateTagWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountWhatsapp_template_recipient_tagArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateRecipientTagWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountWhatsapp_templateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappTemplateWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountWhatsapp_process_jobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WhatsappProcessJobWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountApp_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountOrganizationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: OrganizationsWhereInput
  }


  /**
   * Count Type CategoryTypesCountOutputType
   */

  export type CategoryTypesCountOutputType = {
    categories: number
  }

  export type CategoryTypesCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    categories?: boolean | CategoryTypesCountOutputTypeCountCategoriesArgs
  }

  // Custom InputTypes
  /**
   * CategoryTypesCountOutputType without action
   */
  export type CategoryTypesCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypesCountOutputType
     */
    select?: CategoryTypesCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CategoryTypesCountOutputType without action
   */
  export type CategoryTypesCountOutputTypeCountCategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
  }


  /**
   * Count Type CategoriesCountOutputType
   */

  export type CategoriesCountOutputType = {
    subcategories: number
    configurations: number
    user_configurations: number
  }

  export type CategoriesCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    subcategories?: boolean | CategoriesCountOutputTypeCountSubcategoriesArgs
    configurations?: boolean | CategoriesCountOutputTypeCountConfigurationsArgs
    user_configurations?: boolean | CategoriesCountOutputTypeCountUser_configurationsArgs
  }

  // Custom InputTypes
  /**
   * CategoriesCountOutputType without action
   */
  export type CategoriesCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoriesCountOutputType
     */
    select?: CategoriesCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CategoriesCountOutputType without action
   */
  export type CategoriesCountOutputTypeCountSubcategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
  }

  /**
   * CategoriesCountOutputType without action
   */
  export type CategoriesCountOutputTypeCountConfigurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ConfigurationsWhereInput
  }

  /**
   * CategoriesCountOutputType without action
   */
  export type CategoriesCountOutputTypeCountUser_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserConfigurationsWhereInput
  }


  /**
   * Count Type PoliciesCountOutputType
   */

  export type PoliciesCountOutputType = {
    user_policy: number
    role_policy: number
  }

  export type PoliciesCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user_policy?: boolean | PoliciesCountOutputTypeCountUser_policyArgs
    role_policy?: boolean | PoliciesCountOutputTypeCountRole_policyArgs
  }

  // Custom InputTypes
  /**
   * PoliciesCountOutputType without action
   */
  export type PoliciesCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PoliciesCountOutputType
     */
    select?: PoliciesCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * PoliciesCountOutputType without action
   */
  export type PoliciesCountOutputTypeCountUser_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPoliciesWhereInput
  }

  /**
   * PoliciesCountOutputType without action
   */
  export type PoliciesCountOutputTypeCountRole_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RolePoliciesWhereInput
  }


  /**
   * Count Type ScheduledJobCountOutputType
   */

  export type ScheduledJobCountOutputType = {
    scheduled_job_logs: number
  }

  export type ScheduledJobCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    scheduled_job_logs?: boolean | ScheduledJobCountOutputTypeCountScheduled_job_logsArgs
  }

  // Custom InputTypes
  /**
   * ScheduledJobCountOutputType without action
   */
  export type ScheduledJobCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ScheduledJobCountOutputType
     */
    select?: ScheduledJobCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ScheduledJobCountOutputType without action
   */
  export type ScheduledJobCountOutputTypeCountScheduled_job_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ScheduledJobLogsWhereInput
  }


  /**
   * Count Type ApprovalWorkflowCountOutputType
   */

  export type ApprovalWorkflowCountOutputType = {
    approval_workflow_assignments: number
  }

  export type ApprovalWorkflowCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    approval_workflow_assignments?: boolean | ApprovalWorkflowCountOutputTypeCountApproval_workflow_assignmentsArgs
  }

  // Custom InputTypes
  /**
   * ApprovalWorkflowCountOutputType without action
   */
  export type ApprovalWorkflowCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ApprovalWorkflowCountOutputType
     */
    select?: ApprovalWorkflowCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ApprovalWorkflowCountOutputType without action
   */
  export type ApprovalWorkflowCountOutputTypeCountApproval_workflow_assignmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalWorkflowAssignmentWhereInput
  }


  /**
   * Count Type ApprovalProcessJobWorkflowCountOutputType
   */

  export type ApprovalProcessJobWorkflowCountOutputType = {
    approval_process_job_workflow_users: number
  }

  export type ApprovalProcessJobWorkflowCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    approval_process_job_workflow_users?: boolean | ApprovalProcessJobWorkflowCountOutputTypeCountApproval_process_job_workflow_usersArgs
  }

  // Custom InputTypes
  /**
   * ApprovalProcessJobWorkflowCountOutputType without action
   */
  export type ApprovalProcessJobWorkflowCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ApprovalProcessJobWorkflowCountOutputType
     */
    select?: ApprovalProcessJobWorkflowCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ApprovalProcessJobWorkflowCountOutputType without action
   */
  export type ApprovalProcessJobWorkflowCountOutputTypeCountApproval_process_job_workflow_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ApprovalProcessJobWorkflowUserWhereInput
  }


  /**
   * Count Type ChildProcessCountOutputType
   */

  export type ChildProcessCountOutputType = {
    child_process_logs: number
  }

  export type ChildProcessCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    child_process_logs?: boolean | ChildProcessCountOutputTypeCountChild_process_logsArgs
  }

  // Custom InputTypes
  /**
   * ChildProcessCountOutputType without action
   */
  export type ChildProcessCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ChildProcessCountOutputType
     */
    select?: ChildProcessCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ChildProcessCountOutputType without action
   */
  export type ChildProcessCountOutputTypeCountChild_process_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ChildProcessLogWhereInput
  }


  /**
   * Count Type OrganizationsCountOutputType
   */

  export type OrganizationsCountOutputType = {
    users: number
  }

  export type OrganizationsCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    users?: boolean | OrganizationsCountOutputTypeCountUsersArgs
  }

  // Custom InputTypes
  /**
   * OrganizationsCountOutputType without action
   */
  export type OrganizationsCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the OrganizationsCountOutputType
     */
    select?: OrganizationsCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * OrganizationsCountOutputType without action
   */
  export type OrganizationsCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }


  /**
   * Models
   */

  /**
   * Model User
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type UserSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type UserMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    username: string | null
    email: string | null
    email_verified: boolean | null
    password: string | null
    status_id: number | null
    role: $Enums.UserRole | null
    process_status: $Enums.ProcessStatus | null
    is_drafted: boolean | null
    reason: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    last_login: Date | null
    last_login_device: string | null
  }

  export type UserMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    username: string | null
    email: string | null
    email_verified: boolean | null
    password: string | null
    status_id: number | null
    role: $Enums.UserRole | null
    process_status: $Enums.ProcessStatus | null
    is_drafted: boolean | null
    reason: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    last_login: Date | null
    last_login_device: string | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    uuid: number
    username: number
    email: number
    email_verified: number
    password: number
    status_id: number
    role: number
    process_status: number
    is_drafted: number
    reason: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    last_login: number
    last_login_device: number
    _all: number
  }


  export type UserAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type UserSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type UserMinAggregateInputType = {
    id?: true
    uuid?: true
    username?: true
    email?: true
    email_verified?: true
    password?: true
    status_id?: true
    role?: true
    process_status?: true
    is_drafted?: true
    reason?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    last_login?: true
    last_login_device?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    uuid?: true
    username?: true
    email?: true
    email_verified?: true
    password?: true
    status_id?: true
    role?: true
    process_status?: true
    is_drafted?: true
    reason?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    last_login?: true
    last_login_device?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    uuid?: true
    username?: true
    email?: true
    email_verified?: true
    password?: true
    status_id?: true
    role?: true
    process_status?: true
    is_drafted?: true
    reason?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    last_login?: true
    last_login_device?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationAndSearchRelevanceInput | UserOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
    orderBy?: UserOrderByWithAggregationInput | UserOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _avg?: UserAvgAggregateInputType
    _sum?: UserSumAggregateInputType
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    id: number
    uuid: string
    username: string
    email: string
    email_verified: boolean
    password: string | null
    status_id: number
    role: $Enums.UserRole
    process_status: $Enums.ProcessStatus
    is_drafted: boolean
    reason: string | null
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    last_login: Date | null
    last_login_device: string | null
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    username?: boolean
    email?: boolean
    email_verified?: boolean
    password?: boolean
    status_id?: boolean
    role?: boolean
    process_status?: boolean
    is_drafted?: boolean
    reason?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    last_login?: boolean
    last_login_device?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    user_detail?: boolean | User$user_detailArgs<ExtArgs>
    request_logs?: boolean | User$request_logsArgs<ExtArgs>
    roles?: boolean | User$rolesArgs<ExtArgs>
    permissions?: boolean | User$permissionsArgs<ExtArgs>
    otps?: boolean | User$otpsArgs<ExtArgs>
    created?: boolean | User$createdArgs<ExtArgs>
    updated?: boolean | User$updatedArgs<ExtArgs>
    deleted?: boolean | User$deletedArgs<ExtArgs>
    created_users?: boolean | User$created_usersArgs<ExtArgs>
    updated_users?: boolean | User$updated_usersArgs<ExtArgs>
    deleted_users?: boolean | User$deleted_usersArgs<ExtArgs>
    created_user_details?: boolean | User$created_user_detailsArgs<ExtArgs>
    updated_user_details?: boolean | User$updated_user_detailsArgs<ExtArgs>
    deleted_user_details?: boolean | User$deleted_user_detailsArgs<ExtArgs>
    created_roles?: boolean | User$created_rolesArgs<ExtArgs>
    updated_roles?: boolean | User$updated_rolesArgs<ExtArgs>
    deleted_roles?: boolean | User$deleted_rolesArgs<ExtArgs>
    created_languages?: boolean | User$created_languagesArgs<ExtArgs>
    updated_languages?: boolean | User$updated_languagesArgs<ExtArgs>
    deleted_languages?: boolean | User$deleted_languagesArgs<ExtArgs>
    created_menus?: boolean | User$created_menusArgs<ExtArgs>
    updated_menus?: boolean | User$updated_menusArgs<ExtArgs>
    deleted_menus?: boolean | User$deleted_menusArgs<ExtArgs>
    created_menu_items?: boolean | User$created_menu_itemsArgs<ExtArgs>
    updated_menu_items?: boolean | User$updated_menu_itemsArgs<ExtArgs>
    deleted_menu_items?: boolean | User$deleted_menu_itemsArgs<ExtArgs>
    created_email_templates?: boolean | User$created_email_templatesArgs<ExtArgs>
    updated_email_templates?: boolean | User$updated_email_templatesArgs<ExtArgs>
    deleted_email_templates?: boolean | User$deleted_email_templatesArgs<ExtArgs>
    created_email_template_assignments?: boolean | User$created_email_template_assignmentsArgs<ExtArgs>
    created_email_process_jobs?: boolean | User$created_email_process_jobsArgs<ExtArgs>
    created_whatsapp_process_jobs?: boolean | User$created_whatsapp_process_jobsArgs<ExtArgs>
    created_notification_job?: boolean | User$created_notification_jobArgs<ExtArgs>
    created_import_templates?: boolean | User$created_import_templatesArgs<ExtArgs>
    updated_import_templates?: boolean | User$updated_import_templatesArgs<ExtArgs>
    deleted_import_templates?: boolean | User$deleted_import_templatesArgs<ExtArgs>
    created_carousel_templates?: boolean | User$created_carousel_templatesArgs<ExtArgs>
    updated_carousel_templates?: boolean | User$updated_carousel_templatesArgs<ExtArgs>
    deleted_carousel_templates?: boolean | User$deleted_carousel_templatesArgs<ExtArgs>
    created_whatsapp_templates?: boolean | User$created_whatsapp_templatesArgs<ExtArgs>
    updated_whatsapp_templates?: boolean | User$updated_whatsapp_templatesArgs<ExtArgs>
    deleted_whatsapp_templates?: boolean | User$deleted_whatsapp_templatesArgs<ExtArgs>
    whatsapp_template_assignment?: boolean | User$whatsapp_template_assignmentArgs<ExtArgs>
    created_export_templates?: boolean | User$created_export_templatesArgs<ExtArgs>
    updated_export_templates?: boolean | User$updated_export_templatesArgs<ExtArgs>
    deleted_export_templates?: boolean | User$deleted_export_templatesArgs<ExtArgs>
    created_departments?: boolean | User$created_departmentsArgs<ExtArgs>
    head_departments?: boolean | User$head_departmentsArgs<ExtArgs>
    updated_departments?: boolean | User$updated_departmentsArgs<ExtArgs>
    deleted_departments?: boolean | User$deleted_departmentsArgs<ExtArgs>
    created_designations?: boolean | User$created_designationsArgs<ExtArgs>
    updated_designations?: boolean | User$updated_designationsArgs<ExtArgs>
    deleted_designations?: boolean | User$deleted_designationsArgs<ExtArgs>
    audit_logs?: boolean | User$audit_logsArgs<ExtArgs>
    created_category_types?: boolean | User$created_category_typesArgs<ExtArgs>
    updated_category_types?: boolean | User$updated_category_typesArgs<ExtArgs>
    deleted_category_types?: boolean | User$deleted_category_typesArgs<ExtArgs>
    created_categories?: boolean | User$created_categoriesArgs<ExtArgs>
    updated_categories?: boolean | User$updated_categoriesArgs<ExtArgs>
    deleted_categories?: boolean | User$deleted_categoriesArgs<ExtArgs>
    created_configurations?: boolean | User$created_configurationsArgs<ExtArgs>
    updated_configurations?: boolean | User$updated_configurationsArgs<ExtArgs>
    deleted_configurations?: boolean | User$deleted_configurationsArgs<ExtArgs>
    created_user_configurations?: boolean | User$created_user_configurationsArgs<ExtArgs>
    updated_user_configurations?: boolean | User$updated_user_configurationsArgs<ExtArgs>
    deleted_user_configurations?: boolean | User$deleted_user_configurationsArgs<ExtArgs>
    created_fin_years?: boolean | User$created_fin_yearsArgs<ExtArgs>
    updated_fin_years?: boolean | User$updated_fin_yearsArgs<ExtArgs>
    deleted_fin_years?: boolean | User$deleted_fin_yearsArgs<ExtArgs>
    created_doc_sequences?: boolean | User$created_doc_sequencesArgs<ExtArgs>
    updated_doc_sequences?: boolean | User$updated_doc_sequencesArgs<ExtArgs>
    deleted_doc_sequences?: boolean | User$deleted_doc_sequencesArgs<ExtArgs>
    created_device_registration?: boolean | User$created_device_registrationArgs<ExtArgs>
    updated_device_registration?: boolean | User$updated_device_registrationArgs<ExtArgs>
    deleted_device_registration?: boolean | User$deleted_device_registrationArgs<ExtArgs>
    DeviceRegistration?: boolean | User$DeviceRegistrationArgs<ExtArgs>
    created_import_job?: boolean | User$created_import_jobArgs<ExtArgs>
    updated_import_job?: boolean | User$updated_import_jobArgs<ExtArgs>
    deleted_import_job?: boolean | User$deleted_import_jobArgs<ExtArgs>
    created_organizations?: boolean | User$created_organizationsArgs<ExtArgs>
    updated_organizations?: boolean | User$updated_organizationsArgs<ExtArgs>
    deleted_organizations?: boolean | User$deleted_organizationsArgs<ExtArgs>
    user_policy?: boolean | User$user_policyArgs<ExtArgs>
    created_policy?: boolean | User$created_policyArgs<ExtArgs>
    updated_policy?: boolean | User$updated_policyArgs<ExtArgs>
    deleted_policy?: boolean | User$deleted_policyArgs<ExtArgs>
    created_app_versions?: boolean | User$created_app_versionsArgs<ExtArgs>
    updated_app_versions?: boolean | User$updated_app_versionsArgs<ExtArgs>
    deleted_app_versions?: boolean | User$deleted_app_versionsArgs<ExtArgs>
    ChildProcessLog?: boolean | User$ChildProcessLogArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>

  export type UserSelectScalar = {
    id?: boolean
    uuid?: boolean
    username?: boolean
    email?: boolean
    email_verified?: boolean
    password?: boolean
    status_id?: boolean
    role?: boolean
    process_status?: boolean
    is_drafted?: boolean
    reason?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    last_login?: boolean
    last_login_device?: boolean
  }


  export type UserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    user_detail?: boolean | User$user_detailArgs<ExtArgs>
    request_logs?: boolean | User$request_logsArgs<ExtArgs>
    roles?: boolean | User$rolesArgs<ExtArgs>
    permissions?: boolean | User$permissionsArgs<ExtArgs>
    otps?: boolean | User$otpsArgs<ExtArgs>
    created?: boolean | User$createdArgs<ExtArgs>
    updated?: boolean | User$updatedArgs<ExtArgs>
    deleted?: boolean | User$deletedArgs<ExtArgs>
    created_users?: boolean | User$created_usersArgs<ExtArgs>
    updated_users?: boolean | User$updated_usersArgs<ExtArgs>
    deleted_users?: boolean | User$deleted_usersArgs<ExtArgs>
    created_user_details?: boolean | User$created_user_detailsArgs<ExtArgs>
    updated_user_details?: boolean | User$updated_user_detailsArgs<ExtArgs>
    deleted_user_details?: boolean | User$deleted_user_detailsArgs<ExtArgs>
    created_roles?: boolean | User$created_rolesArgs<ExtArgs>
    updated_roles?: boolean | User$updated_rolesArgs<ExtArgs>
    deleted_roles?: boolean | User$deleted_rolesArgs<ExtArgs>
    created_languages?: boolean | User$created_languagesArgs<ExtArgs>
    updated_languages?: boolean | User$updated_languagesArgs<ExtArgs>
    deleted_languages?: boolean | User$deleted_languagesArgs<ExtArgs>
    created_menus?: boolean | User$created_menusArgs<ExtArgs>
    updated_menus?: boolean | User$updated_menusArgs<ExtArgs>
    deleted_menus?: boolean | User$deleted_menusArgs<ExtArgs>
    created_menu_items?: boolean | User$created_menu_itemsArgs<ExtArgs>
    updated_menu_items?: boolean | User$updated_menu_itemsArgs<ExtArgs>
    deleted_menu_items?: boolean | User$deleted_menu_itemsArgs<ExtArgs>
    created_email_templates?: boolean | User$created_email_templatesArgs<ExtArgs>
    updated_email_templates?: boolean | User$updated_email_templatesArgs<ExtArgs>
    deleted_email_templates?: boolean | User$deleted_email_templatesArgs<ExtArgs>
    created_email_template_assignments?: boolean | User$created_email_template_assignmentsArgs<ExtArgs>
    created_email_process_jobs?: boolean | User$created_email_process_jobsArgs<ExtArgs>
    created_whatsapp_process_jobs?: boolean | User$created_whatsapp_process_jobsArgs<ExtArgs>
    created_notification_job?: boolean | User$created_notification_jobArgs<ExtArgs>
    created_import_templates?: boolean | User$created_import_templatesArgs<ExtArgs>
    updated_import_templates?: boolean | User$updated_import_templatesArgs<ExtArgs>
    deleted_import_templates?: boolean | User$deleted_import_templatesArgs<ExtArgs>
    created_carousel_templates?: boolean | User$created_carousel_templatesArgs<ExtArgs>
    updated_carousel_templates?: boolean | User$updated_carousel_templatesArgs<ExtArgs>
    deleted_carousel_templates?: boolean | User$deleted_carousel_templatesArgs<ExtArgs>
    created_whatsapp_templates?: boolean | User$created_whatsapp_templatesArgs<ExtArgs>
    updated_whatsapp_templates?: boolean | User$updated_whatsapp_templatesArgs<ExtArgs>
    deleted_whatsapp_templates?: boolean | User$deleted_whatsapp_templatesArgs<ExtArgs>
    whatsapp_template_assignment?: boolean | User$whatsapp_template_assignmentArgs<ExtArgs>
    created_export_templates?: boolean | User$created_export_templatesArgs<ExtArgs>
    updated_export_templates?: boolean | User$updated_export_templatesArgs<ExtArgs>
    deleted_export_templates?: boolean | User$deleted_export_templatesArgs<ExtArgs>
    created_departments?: boolean | User$created_departmentsArgs<ExtArgs>
    head_departments?: boolean | User$head_departmentsArgs<ExtArgs>
    updated_departments?: boolean | User$updated_departmentsArgs<ExtArgs>
    deleted_departments?: boolean | User$deleted_departmentsArgs<ExtArgs>
    created_designations?: boolean | User$created_designationsArgs<ExtArgs>
    updated_designations?: boolean | User$updated_designationsArgs<ExtArgs>
    deleted_designations?: boolean | User$deleted_designationsArgs<ExtArgs>
    audit_logs?: boolean | User$audit_logsArgs<ExtArgs>
    created_category_types?: boolean | User$created_category_typesArgs<ExtArgs>
    updated_category_types?: boolean | User$updated_category_typesArgs<ExtArgs>
    deleted_category_types?: boolean | User$deleted_category_typesArgs<ExtArgs>
    created_categories?: boolean | User$created_categoriesArgs<ExtArgs>
    updated_categories?: boolean | User$updated_categoriesArgs<ExtArgs>
    deleted_categories?: boolean | User$deleted_categoriesArgs<ExtArgs>
    created_configurations?: boolean | User$created_configurationsArgs<ExtArgs>
    updated_configurations?: boolean | User$updated_configurationsArgs<ExtArgs>
    deleted_configurations?: boolean | User$deleted_configurationsArgs<ExtArgs>
    created_user_configurations?: boolean | User$created_user_configurationsArgs<ExtArgs>
    updated_user_configurations?: boolean | User$updated_user_configurationsArgs<ExtArgs>
    deleted_user_configurations?: boolean | User$deleted_user_configurationsArgs<ExtArgs>
    created_fin_years?: boolean | User$created_fin_yearsArgs<ExtArgs>
    updated_fin_years?: boolean | User$updated_fin_yearsArgs<ExtArgs>
    deleted_fin_years?: boolean | User$deleted_fin_yearsArgs<ExtArgs>
    created_doc_sequences?: boolean | User$created_doc_sequencesArgs<ExtArgs>
    updated_doc_sequences?: boolean | User$updated_doc_sequencesArgs<ExtArgs>
    deleted_doc_sequences?: boolean | User$deleted_doc_sequencesArgs<ExtArgs>
    created_device_registration?: boolean | User$created_device_registrationArgs<ExtArgs>
    updated_device_registration?: boolean | User$updated_device_registrationArgs<ExtArgs>
    deleted_device_registration?: boolean | User$deleted_device_registrationArgs<ExtArgs>
    DeviceRegistration?: boolean | User$DeviceRegistrationArgs<ExtArgs>
    created_import_job?: boolean | User$created_import_jobArgs<ExtArgs>
    updated_import_job?: boolean | User$updated_import_jobArgs<ExtArgs>
    deleted_import_job?: boolean | User$deleted_import_jobArgs<ExtArgs>
    created_organizations?: boolean | User$created_organizationsArgs<ExtArgs>
    updated_organizations?: boolean | User$updated_organizationsArgs<ExtArgs>
    deleted_organizations?: boolean | User$deleted_organizationsArgs<ExtArgs>
    user_policy?: boolean | User$user_policyArgs<ExtArgs>
    created_policy?: boolean | User$created_policyArgs<ExtArgs>
    updated_policy?: boolean | User$updated_policyArgs<ExtArgs>
    deleted_policy?: boolean | User$deleted_policyArgs<ExtArgs>
    created_app_versions?: boolean | User$created_app_versionsArgs<ExtArgs>
    updated_app_versions?: boolean | User$updated_app_versionsArgs<ExtArgs>
    deleted_app_versions?: boolean | User$deleted_app_versionsArgs<ExtArgs>
    ChildProcessLog?: boolean | User$ChildProcessLogArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $UserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "User"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      user_detail: Prisma.$UserDetailPayload<ExtArgs> | null
      request_logs: Prisma.$RequestLogPayload<ExtArgs>[]
      roles: Prisma.$UserRolesPayload<ExtArgs>[]
      permissions: Prisma.$UserPermissionsPayload<ExtArgs>[]
      otps: Prisma.$OtpPayload<ExtArgs>[]
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
      created_users: Prisma.$UserPayload<ExtArgs>[]
      updated_users: Prisma.$UserPayload<ExtArgs>[]
      deleted_users: Prisma.$UserPayload<ExtArgs>[]
      created_user_details: Prisma.$UserDetailPayload<ExtArgs>[]
      updated_user_details: Prisma.$UserDetailPayload<ExtArgs>[]
      deleted_user_details: Prisma.$UserDetailPayload<ExtArgs>[]
      created_roles: Prisma.$RolePayload<ExtArgs>[]
      updated_roles: Prisma.$RolePayload<ExtArgs>[]
      deleted_roles: Prisma.$RolePayload<ExtArgs>[]
      created_languages: Prisma.$LanguagePayload<ExtArgs>[]
      updated_languages: Prisma.$LanguagePayload<ExtArgs>[]
      deleted_languages: Prisma.$LanguagePayload<ExtArgs>[]
      created_menus: Prisma.$MenusPayload<ExtArgs>[]
      updated_menus: Prisma.$MenusPayload<ExtArgs>[]
      deleted_menus: Prisma.$MenusPayload<ExtArgs>[]
      created_menu_items: Prisma.$MenuItemsPayload<ExtArgs>[]
      updated_menu_items: Prisma.$MenuItemsPayload<ExtArgs>[]
      deleted_menu_items: Prisma.$MenuItemsPayload<ExtArgs>[]
      created_email_templates: Prisma.$EmailTemplatePayload<ExtArgs>[]
      updated_email_templates: Prisma.$EmailTemplatePayload<ExtArgs>[]
      deleted_email_templates: Prisma.$EmailTemplatePayload<ExtArgs>[]
      created_email_template_assignments: Prisma.$EmailTemplateAssignmentPayload<ExtArgs>[]
      created_email_process_jobs: Prisma.$EmailProcessJobPayload<ExtArgs>[]
      created_whatsapp_process_jobs: Prisma.$WhatsappProcessJobPayload<ExtArgs>[]
      created_notification_job: Prisma.$NotificationJobPayload<ExtArgs>[]
      created_import_templates: Prisma.$ImportTemplatePayload<ExtArgs>[]
      updated_import_templates: Prisma.$ImportTemplatePayload<ExtArgs>[]
      deleted_import_templates: Prisma.$ImportTemplatePayload<ExtArgs>[]
      created_carousel_templates: Prisma.$CarouselTemplatePayload<ExtArgs>[]
      updated_carousel_templates: Prisma.$CarouselTemplatePayload<ExtArgs>[]
      deleted_carousel_templates: Prisma.$CarouselTemplatePayload<ExtArgs>[]
      created_whatsapp_templates: Prisma.$WhatsappTemplatePayload<ExtArgs>[]
      updated_whatsapp_templates: Prisma.$WhatsappTemplatePayload<ExtArgs>[]
      deleted_whatsapp_templates: Prisma.$WhatsappTemplatePayload<ExtArgs>[]
      whatsapp_template_assignment: Prisma.$WhatsappTemplateAssignmentPayload<ExtArgs>[]
      created_export_templates: Prisma.$ExportTemplatePayload<ExtArgs>[]
      updated_export_templates: Prisma.$ExportTemplatePayload<ExtArgs>[]
      deleted_export_templates: Prisma.$ExportTemplatePayload<ExtArgs>[]
      created_departments: Prisma.$DepartmentPayload<ExtArgs>[]
      head_departments: Prisma.$DepartmentPayload<ExtArgs>[]
      updated_departments: Prisma.$DepartmentPayload<ExtArgs>[]
      deleted_departments: Prisma.$DepartmentPayload<ExtArgs>[]
      created_designations: Prisma.$DesignationPayload<ExtArgs>[]
      updated_designations: Prisma.$DesignationPayload<ExtArgs>[]
      deleted_designations: Prisma.$DesignationPayload<ExtArgs>[]
      audit_logs: Prisma.$AuditLogPayload<ExtArgs>[]
      created_category_types: Prisma.$CategoryTypesPayload<ExtArgs>[]
      updated_category_types: Prisma.$CategoryTypesPayload<ExtArgs>[]
      deleted_category_types: Prisma.$CategoryTypesPayload<ExtArgs>[]
      created_categories: Prisma.$CategoriesPayload<ExtArgs>[]
      updated_categories: Prisma.$CategoriesPayload<ExtArgs>[]
      deleted_categories: Prisma.$CategoriesPayload<ExtArgs>[]
      created_configurations: Prisma.$ConfigurationsPayload<ExtArgs>[]
      updated_configurations: Prisma.$ConfigurationsPayload<ExtArgs>[]
      deleted_configurations: Prisma.$ConfigurationsPayload<ExtArgs>[]
      created_user_configurations: Prisma.$UserConfigurationsPayload<ExtArgs>[]
      updated_user_configurations: Prisma.$UserConfigurationsPayload<ExtArgs>[]
      deleted_user_configurations: Prisma.$UserConfigurationsPayload<ExtArgs>[]
      created_fin_years: Prisma.$FinancialYearPayload<ExtArgs>[]
      updated_fin_years: Prisma.$FinancialYearPayload<ExtArgs>[]
      deleted_fin_years: Prisma.$FinancialYearPayload<ExtArgs>[]
      created_doc_sequences: Prisma.$DocumentSequencePayload<ExtArgs>[]
      updated_doc_sequences: Prisma.$DocumentSequencePayload<ExtArgs>[]
      deleted_doc_sequences: Prisma.$DocumentSequencePayload<ExtArgs>[]
      created_device_registration: Prisma.$DeviceRegistrationPayload<ExtArgs>[]
      updated_device_registration: Prisma.$DeviceRegistrationPayload<ExtArgs>[]
      deleted_device_registration: Prisma.$DeviceRegistrationPayload<ExtArgs>[]
      DeviceRegistration: Prisma.$DeviceRegistrationPayload<ExtArgs>[]
      created_import_job: Prisma.$ImportJobPayload<ExtArgs>[]
      updated_import_job: Prisma.$ImportJobPayload<ExtArgs>[]
      deleted_import_job: Prisma.$ImportJobPayload<ExtArgs>[]
      created_organizations: Prisma.$OrganizationsPayload<ExtArgs>[]
      updated_organizations: Prisma.$OrganizationsPayload<ExtArgs>[]
      deleted_organizations: Prisma.$OrganizationsPayload<ExtArgs>[]
      user_policy: Prisma.$UserPoliciesPayload<ExtArgs>[]
      created_policy: Prisma.$PoliciesPayload<ExtArgs>[]
      updated_policy: Prisma.$PoliciesPayload<ExtArgs>[]
      deleted_policy: Prisma.$PoliciesPayload<ExtArgs>[]
      created_app_versions: Prisma.$AppversionsPayload<ExtArgs>[]
      updated_app_versions: Prisma.$AppversionsPayload<ExtArgs>[]
      deleted_app_versions: Prisma.$AppversionsPayload<ExtArgs>[]
      ChildProcessLog: Prisma.$ChildProcessLogPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      username: string
      email: string
      email_verified: boolean
      password: string | null
      status_id: number
      role: $Enums.UserRole
      process_status: $Enums.ProcessStatus
      is_drafted: boolean
      reason: string | null
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      last_login: Date | null
      last_login_device: string | null
    }, ExtArgs["result"]["user"]>
    composites: {}
  }


  type UserGetPayload<S extends boolean | null | undefined | UserDefaultArgs> = $Result.GetResult<Prisma.$UserPayload, S>

  type UserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['User'], meta: { name: 'User' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserFindUniqueArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one User that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindFirstArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends UserFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
    **/
    create<T extends UserCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserCreateArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Users.
     * @param {UserCreateManyArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends UserCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Users and returns the data saved in the database.
     * @param {UserCreateManyAndReturnArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Users and only return the `id`
     * const userWithIdOnly = await prisma.user.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends UserCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, UserCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
    **/
    delete<T extends UserDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserDeleteArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpdateArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
    **/
    upsert<T extends UserUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpsertArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the User model
   */
  readonly fields: UserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    user_detail<T extends User$user_detailArgs<ExtArgs> = {}>(args?: Subset<T, User$user_detailArgs<ExtArgs>>): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    request_logs<T extends User$request_logsArgs<ExtArgs> = {}>(args?: Subset<T, User$request_logsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'findMany'> | Null>;

    roles<T extends User$rolesArgs<ExtArgs> = {}>(args?: Subset<T, User$rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findMany'> | Null>;

    permissions<T extends User$permissionsArgs<ExtArgs> = {}>(args?: Subset<T, User$permissionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    otps<T extends User$otpsArgs<ExtArgs> = {}>(args?: Subset<T, User$otpsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$OtpPayload<ExtArgs>, T, 'findMany'> | Null>;

    created<T extends User$createdArgs<ExtArgs> = {}>(args?: Subset<T, User$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends User$updatedArgs<ExtArgs> = {}>(args?: Subset<T, User$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends User$deletedArgs<ExtArgs> = {}>(args?: Subset<T, User$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    created_users<T extends User$created_usersArgs<ExtArgs> = {}>(args?: Subset<T, User$created_usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_users<T extends User$updated_usersArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_users<T extends User$deleted_usersArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_user_details<T extends User$created_user_detailsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_user_detailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_user_details<T extends User$updated_user_detailsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_user_detailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_user_details<T extends User$deleted_user_detailsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_user_detailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_roles<T extends User$created_rolesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_roles<T extends User$updated_rolesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_roles<T extends User$deleted_rolesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findMany'> | Null>;

    created_languages<T extends User$created_languagesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_languagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_languages<T extends User$updated_languagesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_languagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_languages<T extends User$deleted_languagesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_languagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findMany'> | Null>;

    created_menus<T extends User$created_menusArgs<ExtArgs> = {}>(args?: Subset<T, User$created_menusArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_menus<T extends User$updated_menusArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_menusArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_menus<T extends User$deleted_menusArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_menusArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_menu_items<T extends User$created_menu_itemsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_menu_itemsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_menu_items<T extends User$updated_menu_itemsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_menu_itemsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_menu_items<T extends User$deleted_menu_itemsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_menu_itemsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_email_templates<T extends User$created_email_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_email_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$EmailTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_email_templates<T extends User$updated_email_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_email_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$EmailTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_email_templates<T extends User$deleted_email_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_email_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$EmailTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    created_email_template_assignments<T extends User$created_email_template_assignmentsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_email_template_assignmentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$EmailTemplateAssignmentPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_email_process_jobs<T extends User$created_email_process_jobsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_email_process_jobsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$EmailProcessJobPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_whatsapp_process_jobs<T extends User$created_whatsapp_process_jobsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_whatsapp_process_jobsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WhatsappProcessJobPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_notification_job<T extends User$created_notification_jobArgs<ExtArgs> = {}>(args?: Subset<T, User$created_notification_jobArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$NotificationJobPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_import_templates<T extends User$created_import_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_import_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ImportTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_import_templates<T extends User$updated_import_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_import_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ImportTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_import_templates<T extends User$deleted_import_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_import_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ImportTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    created_carousel_templates<T extends User$created_carousel_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_carousel_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CarouselTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_carousel_templates<T extends User$updated_carousel_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_carousel_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CarouselTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_carousel_templates<T extends User$deleted_carousel_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_carousel_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CarouselTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    created_whatsapp_templates<T extends User$created_whatsapp_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_whatsapp_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WhatsappTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_whatsapp_templates<T extends User$updated_whatsapp_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_whatsapp_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WhatsappTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_whatsapp_templates<T extends User$deleted_whatsapp_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_whatsapp_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WhatsappTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    whatsapp_template_assignment<T extends User$whatsapp_template_assignmentArgs<ExtArgs> = {}>(args?: Subset<T, User$whatsapp_template_assignmentArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WhatsappTemplateAssignmentPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_export_templates<T extends User$created_export_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_export_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ExportTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_export_templates<T extends User$updated_export_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_export_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ExportTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_export_templates<T extends User$deleted_export_templatesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_export_templatesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ExportTemplatePayload<ExtArgs>, T, 'findMany'> | Null>;

    created_departments<T extends User$created_departmentsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_departmentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findMany'> | Null>;

    head_departments<T extends User$head_departmentsArgs<ExtArgs> = {}>(args?: Subset<T, User$head_departmentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_departments<T extends User$updated_departmentsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_departmentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_departments<T extends User$deleted_departmentsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_departmentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_designations<T extends User$created_designationsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_designationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_designations<T extends User$updated_designationsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_designationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_designations<T extends User$deleted_designationsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_designationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findMany'> | Null>;

    audit_logs<T extends User$audit_logsArgs<ExtArgs> = {}>(args?: Subset<T, User$audit_logsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_category_types<T extends User$created_category_typesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_category_typesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_category_types<T extends User$updated_category_typesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_category_typesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_category_types<T extends User$deleted_category_typesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_category_typesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_categories<T extends User$created_categoriesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_categoriesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_categories<T extends User$updated_categoriesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_categoriesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_categories<T extends User$deleted_categoriesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_categoriesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_configurations<T extends User$created_configurationsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_configurationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_configurations<T extends User$updated_configurationsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_configurationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_configurations<T extends User$deleted_configurationsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_configurationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_user_configurations<T extends User$created_user_configurationsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_user_configurationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserConfigurationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_user_configurations<T extends User$updated_user_configurationsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_user_configurationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserConfigurationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_user_configurations<T extends User$deleted_user_configurationsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_user_configurationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserConfigurationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_fin_years<T extends User$created_fin_yearsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_fin_yearsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_fin_years<T extends User$updated_fin_yearsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_fin_yearsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_fin_years<T extends User$deleted_fin_yearsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_fin_yearsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_doc_sequences<T extends User$created_doc_sequencesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_doc_sequencesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_doc_sequences<T extends User$updated_doc_sequencesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_doc_sequencesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_doc_sequences<T extends User$deleted_doc_sequencesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_doc_sequencesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findMany'> | Null>;

    created_device_registration<T extends User$created_device_registrationArgs<ExtArgs> = {}>(args?: Subset<T, User$created_device_registrationArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DeviceRegistrationPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_device_registration<T extends User$updated_device_registrationArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_device_registrationArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DeviceRegistrationPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_device_registration<T extends User$deleted_device_registrationArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_device_registrationArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DeviceRegistrationPayload<ExtArgs>, T, 'findMany'> | Null>;

    DeviceRegistration<T extends User$DeviceRegistrationArgs<ExtArgs> = {}>(args?: Subset<T, User$DeviceRegistrationArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DeviceRegistrationPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_import_job<T extends User$created_import_jobArgs<ExtArgs> = {}>(args?: Subset<T, User$created_import_jobArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ImportJobPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_import_job<T extends User$updated_import_jobArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_import_jobArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ImportJobPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_import_job<T extends User$deleted_import_jobArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_import_jobArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ImportJobPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_organizations<T extends User$created_organizationsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_organizationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$OrganizationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_organizations<T extends User$updated_organizationsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_organizationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$OrganizationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_organizations<T extends User$deleted_organizationsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_organizationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$OrganizationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    user_policy<T extends User$user_policyArgs<ExtArgs> = {}>(args?: Subset<T, User$user_policyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPoliciesPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_policy<T extends User$created_policyArgs<ExtArgs> = {}>(args?: Subset<T, User$created_policyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PoliciesPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_policy<T extends User$updated_policyArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_policyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PoliciesPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_policy<T extends User$deleted_policyArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_policyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PoliciesPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_app_versions<T extends User$created_app_versionsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_app_versionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AppversionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_app_versions<T extends User$updated_app_versionsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_app_versionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AppversionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_app_versions<T extends User$deleted_app_versionsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_app_versionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AppversionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    ChildProcessLog<T extends User$ChildProcessLogArgs<ExtArgs> = {}>(args?: Subset<T, User$ChildProcessLogArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ChildProcessLogPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the User model
   */ 
  interface UserFieldRefs {
    readonly id: FieldRef<"User", 'Int'>
    readonly uuid: FieldRef<"User", 'String'>
    readonly username: FieldRef<"User", 'String'>
    readonly email: FieldRef<"User", 'String'>
    readonly email_verified: FieldRef<"User", 'Boolean'>
    readonly password: FieldRef<"User", 'String'>
    readonly status_id: FieldRef<"User", 'Int'>
    readonly role: FieldRef<"User", 'UserRole'>
    readonly process_status: FieldRef<"User", 'ProcessStatus'>
    readonly is_drafted: FieldRef<"User", 'Boolean'>
    readonly reason: FieldRef<"User", 'String'>
    readonly company_id: FieldRef<"User", 'Int'>
    readonly created_by: FieldRef<"User", 'Int'>
    readonly updated_by: FieldRef<"User", 'Int'>
    readonly deleted_by: FieldRef<"User", 'Int'>
    readonly created_at: FieldRef<"User", 'DateTime'>
    readonly updated_at: FieldRef<"User", 'DateTime'>
    readonly deleted_at: FieldRef<"User", 'DateTime'>
    readonly last_login: FieldRef<"User", 'DateTime'>
    readonly last_login_device: FieldRef<"User", 'String'>
  }
    

  // Custom InputTypes
  /**
   * User findUnique
   */
  export type UserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findFirst
   */
  export type UserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationAndSearchRelevanceInput | UserOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationAndSearchRelevanceInput | UserOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findMany
   */
  export type UserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationAndSearchRelevanceInput | UserOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User create
   */
  export type UserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }

  /**
   * User createMany
   */
  export type UserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User createManyAndReturn
   */
  export type UserCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User update
   */
  export type UserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User updateMany
   */
  export type UserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
  }

  /**
   * User upsert
   */
  export type UserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }

  /**
   * User delete
   */
  export type UserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
  }

  /**
   * User.user_detail
   */
  export type User$user_detailArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
  }

  /**
   * User.request_logs
   */
  export type User$request_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    where?: RequestLogWhereInput
    orderBy?: RequestLogOrderByWithRelationAndSearchRelevanceInput | RequestLogOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: RequestLogWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RequestLogScalarFieldEnum | RequestLogScalarFieldEnum[]
  }

  /**
   * User.roles
   */
  export type User$rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    where?: UserRolesWhereInput
    orderBy?: UserRolesOrderByWithRelationAndSearchRelevanceInput | UserRolesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserRolesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * User.permissions
   */
  export type User$permissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    where?: UserPermissionsWhereInput
    orderBy?: UserPermissionsOrderByWithRelationAndSearchRelevanceInput | UserPermissionsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserPermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * User.otps
   */
  export type User$otpsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Otp
     */
    select?: OtpSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: OtpInclude<ExtArgs> | null
    where?: OtpWhereInput
    orderBy?: OtpOrderByWithRelationAndSearchRelevanceInput | OtpOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: OtpWhereUniqueInput
    take?: number
    skip?: number
    distinct?: OtpScalarFieldEnum | OtpScalarFieldEnum[]
  }

  /**
   * User.created
   */
  export type User$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * User.updated
   */
  export type User$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * User.deleted
   */
  export type User$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * User.created_users
   */
  export type User$created_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationAndSearchRelevanceInput | UserOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User.updated_users
   */
  export type User$updated_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationAndSearchRelevanceInput | UserOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User.deleted_users
   */
  export type User$deleted_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationAndSearchRelevanceInput | UserOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User.created_user_details
   */
  export type User$created_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * User.updated_user_details
   */
  export type User$updated_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * User.deleted_user_details
   */
  export type User$deleted_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * User.created_roles
   */
  export type User$created_rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithRelationAndSearchRelevanceInput | RoleOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: RoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * User.updated_roles
   */
  export type User$updated_rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithRelationAndSearchRelevanceInput | RoleOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: RoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * User.deleted_roles
   */
  export type User$deleted_rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithRelationAndSearchRelevanceInput | RoleOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: RoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * User.created_languages
   */
  export type User$created_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    where?: LanguageWhereInput
    orderBy?: LanguageOrderByWithRelationAndSearchRelevanceInput | LanguageOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: LanguageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * User.updated_languages
   */
  export type User$updated_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    where?: LanguageWhereInput
    orderBy?: LanguageOrderByWithRelationAndSearchRelevanceInput | LanguageOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: LanguageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * User.deleted_languages
   */
  export type User$deleted_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    where?: LanguageWhereInput
    orderBy?: LanguageOrderByWithRelationAndSearchRelevanceInput | LanguageOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: LanguageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * User.created_menus
   */
  export type User$created_menusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    where?: MenusWhereInput
    orderBy?: MenusOrderByWithRelationAndSearchRelevanceInput | MenusOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: MenusWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenusScalarFieldEnum | MenusScalarFieldEnum[]
  }

  /**
   * User.updated_menus
   */
  export type User$updated_menusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    where?: MenusWhereInput
    orderBy?: MenusOrderByWithRelationAndSearchRelevanceInput | MenusOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: MenusWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenusScalarFieldEnum | MenusScalarFieldEnum[]
  }

  /**
   * User.deleted_menus
   */
  export type User$deleted_menusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    where?: MenusWhereInput
    orderBy?: MenusOrderByWithRelationAndSearchRelevanceInput | MenusOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: MenusWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenusScalarFieldEnum | MenusScalarFieldEnum[]
  }

  /**
   * User.created_menu_items
   */
  export type User$created_menu_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    where?: MenuItemsWhereInput
    orderBy?: MenuItemsOrderByWithRelationAndSearchRelevanceInput | MenuItemsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: MenuItemsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenuItemsScalarFieldEnum | MenuItemsScalarFieldEnum[]
  }

  /**
   * User.updated_menu_items
   */
  export type User$updated_menu_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    where?: MenuItemsWhereInput
    orderBy?: MenuItemsOrderByWithRelationAndSearchRelevanceInput | MenuItemsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: MenuItemsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenuItemsScalarFieldEnum | MenuItemsScalarFieldEnum[]
  }

  /**
   * User.deleted_menu_items
   */
  export type User$deleted_menu_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    where?: MenuItemsWhereInput
    orderBy?: MenuItemsOrderByWithRelationAndSearchRelevanceInput | MenuItemsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: MenuItemsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenuItemsScalarFieldEnum | MenuItemsScalarFieldEnum[]
  }

  /**
   * User.created_email_templates
   */
  export type User$created_email_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailTemplate
     */
    select?: EmailTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: EmailTemplateInclude<ExtArgs> | null
    where?: EmailTemplateWhereInput
    orderBy?: EmailTemplateOrderByWithRelationAndSearchRelevanceInput | EmailTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: EmailTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: EmailTemplateScalarFieldEnum | EmailTemplateScalarFieldEnum[]
  }

  /**
   * User.updated_email_templates
   */
  export type User$updated_email_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailTemplate
     */
    select?: EmailTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: EmailTemplateInclude<ExtArgs> | null
    where?: EmailTemplateWhereInput
    orderBy?: EmailTemplateOrderByWithRelationAndSearchRelevanceInput | EmailTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: EmailTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: EmailTemplateScalarFieldEnum | EmailTemplateScalarFieldEnum[]
  }

  /**
   * User.deleted_email_templates
   */
  export type User$deleted_email_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailTemplate
     */
    select?: EmailTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: EmailTemplateInclude<ExtArgs> | null
    where?: EmailTemplateWhereInput
    orderBy?: EmailTemplateOrderByWithRelationAndSearchRelevanceInput | EmailTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: EmailTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: EmailTemplateScalarFieldEnum | EmailTemplateScalarFieldEnum[]
  }

  /**
   * User.created_email_template_assignments
   */
  export type User$created_email_template_assignmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailTemplateAssignment
     */
    select?: EmailTemplateAssignmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: EmailTemplateAssignmentInclude<ExtArgs> | null
    where?: EmailTemplateAssignmentWhereInput
    orderBy?: EmailTemplateAssignmentOrderByWithRelationAndSearchRelevanceInput | EmailTemplateAssignmentOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: EmailTemplateAssignmentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: EmailTemplateAssignmentScalarFieldEnum | EmailTemplateAssignmentScalarFieldEnum[]
  }

  /**
   * User.created_email_process_jobs
   */
  export type User$created_email_process_jobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EmailProcessJob
     */
    select?: EmailProcessJobSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: EmailProcessJobInclude<ExtArgs> | null
    where?: EmailProcessJobWhereInput
    orderBy?: EmailProcessJobOrderByWithRelationAndSearchRelevanceInput | EmailProcessJobOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: EmailProcessJobWhereUniqueInput
    take?: number
    skip?: number
    distinct?: EmailProcessJobScalarFieldEnum | EmailProcessJobScalarFieldEnum[]
  }

  /**
   * User.created_whatsapp_process_jobs
   */
  export type User$created_whatsapp_process_jobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WhatsappProcessJob
     */
    select?: WhatsappProcessJobSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: WhatsappProcessJobInclude<ExtArgs> | null
    where?: WhatsappProcessJobWhereInput
    orderBy?: WhatsappProcessJobOrderByWithRelationAndSearchRelevanceInput | WhatsappProcessJobOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: WhatsappProcessJobWhereUniqueInput
    take?: number
    skip?: number
    distinct?: WhatsappProcessJobScalarFieldEnum | WhatsappProcessJobScalarFieldEnum[]
  }

  /**
   * User.created_notification_job
   */
  export type User$created_notification_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the NotificationJob
     */
    select?: NotificationJobSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: NotificationJobInclude<ExtArgs> | null
    where?: NotificationJobWhereInput
    orderBy?: NotificationJobOrderByWithRelationAndSearchRelevanceInput | NotificationJobOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: NotificationJobWhereUniqueInput
    take?: number
    skip?: number
    distinct?: NotificationJobScalarFieldEnum | NotificationJobScalarFieldEnum[]
  }

  /**
   * User.created_import_templates
   */
  export type User$created_import_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ImportTemplate
     */
    select?: ImportTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ImportTemplateInclude<ExtArgs> | null
    where?: ImportTemplateWhereInput
    orderBy?: ImportTemplateOrderByWithRelationAndSearchRelevanceInput | ImportTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ImportTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ImportTemplateScalarFieldEnum | ImportTemplateScalarFieldEnum[]
  }

  /**
   * User.updated_import_templates
   */
  export type User$updated_import_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ImportTemplate
     */
    select?: ImportTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ImportTemplateInclude<ExtArgs> | null
    where?: ImportTemplateWhereInput
    orderBy?: ImportTemplateOrderByWithRelationAndSearchRelevanceInput | ImportTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ImportTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ImportTemplateScalarFieldEnum | ImportTemplateScalarFieldEnum[]
  }

  /**
   * User.deleted_import_templates
   */
  export type User$deleted_import_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ImportTemplate
     */
    select?: ImportTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ImportTemplateInclude<ExtArgs> | null
    where?: ImportTemplateWhereInput
    orderBy?: ImportTemplateOrderByWithRelationAndSearchRelevanceInput | ImportTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ImportTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ImportTemplateScalarFieldEnum | ImportTemplateScalarFieldEnum[]
  }

  /**
   * User.created_carousel_templates
   */
  export type User$created_carousel_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CarouselTemplate
     */
    select?: CarouselTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CarouselTemplateInclude<ExtArgs> | null
    where?: CarouselTemplateWhereInput
    orderBy?: CarouselTemplateOrderByWithRelationAndSearchRelevanceInput | CarouselTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CarouselTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CarouselTemplateScalarFieldEnum | CarouselTemplateScalarFieldEnum[]
  }

  /**
   * User.updated_carousel_templates
   */
  export type User$updated_carousel_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CarouselTemplate
     */
    select?: CarouselTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CarouselTemplateInclude<ExtArgs> | null
    where?: CarouselTemplateWhereInput
    orderBy?: CarouselTemplateOrderByWithRelationAndSearchRelevanceInput | CarouselTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CarouselTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CarouselTemplateScalarFieldEnum | CarouselTemplateScalarFieldEnum[]
  }

  /**
   * User.deleted_carousel_templates
   */
  export type User$deleted_carousel_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CarouselTemplate
     */
    select?: CarouselTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CarouselTemplateInclude<ExtArgs> | null
    where?: CarouselTemplateWhereInput
    orderBy?: CarouselTemplateOrderByWithRelationAndSearchRelevanceInput | CarouselTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CarouselTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CarouselTemplateScalarFieldEnum | CarouselTemplateScalarFieldEnum[]
  }

  /**
   * User.created_whatsapp_templates
   */
  export type User$created_whatsapp_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WhatsappTemplate
     */
    select?: WhatsappTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: WhatsappTemplateInclude<ExtArgs> | null
    where?: WhatsappTemplateWhereInput
    orderBy?: WhatsappTemplateOrderByWithRelationAndSearchRelevanceInput | WhatsappTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: WhatsappTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: WhatsappTemplateScalarFieldEnum | WhatsappTemplateScalarFieldEnum[]
  }

  /**
   * User.updated_whatsapp_templates
   */
  export type User$updated_whatsapp_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WhatsappTemplate
     */
    select?: WhatsappTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: WhatsappTemplateInclude<ExtArgs> | null
    where?: WhatsappTemplateWhereInput
    orderBy?: WhatsappTemplateOrderByWithRelationAndSearchRelevanceInput | WhatsappTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: WhatsappTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: WhatsappTemplateScalarFieldEnum | WhatsappTemplateScalarFieldEnum[]
  }

  /**
   * User.deleted_whatsapp_templates
   */
  export type User$deleted_whatsapp_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WhatsappTemplate
     */
    select?: WhatsappTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: WhatsappTemplateInclude<ExtArgs> | null
    where?: WhatsappTemplateWhereInput
    orderBy?: WhatsappTemplateOrderByWithRelationAndSearchRelevanceInput | WhatsappTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: WhatsappTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: WhatsappTemplateScalarFieldEnum | WhatsappTemplateScalarFieldEnum[]
  }

  /**
   * User.whatsapp_template_assignment
   */
  export type User$whatsapp_template_assignmentArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WhatsappTemplateAssignment
     */
    select?: WhatsappTemplateAssignmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: WhatsappTemplateAssignmentInclude<ExtArgs> | null
    where?: WhatsappTemplateAssignmentWhereInput
    orderBy?: WhatsappTemplateAssignmentOrderByWithRelationAndSearchRelevanceInput | WhatsappTemplateAssignmentOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: WhatsappTemplateAssignmentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: WhatsappTemplateAssignmentScalarFieldEnum | WhatsappTemplateAssignmentScalarFieldEnum[]
  }

  /**
   * User.created_export_templates
   */
  export type User$created_export_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ExportTemplate
     */
    select?: ExportTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ExportTemplateInclude<ExtArgs> | null
    where?: ExportTemplateWhereInput
    orderBy?: ExportTemplateOrderByWithRelationAndSearchRelevanceInput | ExportTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ExportTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ExportTemplateScalarFieldEnum | ExportTemplateScalarFieldEnum[]
  }

  /**
   * User.updated_export_templates
   */
  export type User$updated_export_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ExportTemplate
     */
    select?: ExportTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ExportTemplateInclude<ExtArgs> | null
    where?: ExportTemplateWhereInput
    orderBy?: ExportTemplateOrderByWithRelationAndSearchRelevanceInput | ExportTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ExportTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ExportTemplateScalarFieldEnum | ExportTemplateScalarFieldEnum[]
  }

  /**
   * User.deleted_export_templates
   */
  export type User$deleted_export_templatesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ExportTemplate
     */
    select?: ExportTemplateSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ExportTemplateInclude<ExtArgs> | null
    where?: ExportTemplateWhereInput
    orderBy?: ExportTemplateOrderByWithRelationAndSearchRelevanceInput | ExportTemplateOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ExportTemplateWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ExportTemplateScalarFieldEnum | ExportTemplateScalarFieldEnum[]
  }

  /**
   * User.created_departments
   */
  export type User$created_departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithRelationAndSearchRelevanceInput | DepartmentOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DepartmentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * User.head_departments
   */
  export type User$head_departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithRelationAndSearchRelevanceInput | DepartmentOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DepartmentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * User.updated_departments
   */
  export type User$updated_departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithRelationAndSearchRelevanceInput | DepartmentOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DepartmentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * User.deleted_departments
   */
  export type User$deleted_departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithRelationAndSearchRelevanceInput | DepartmentOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DepartmentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * User.created_designations
   */
  export type User$created_designationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    where?: DesignationWhereInput
    orderBy?: DesignationOrderByWithRelationAndSearchRelevanceInput | DesignationOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DesignationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * User.updated_designations
   */
  export type User$updated_designationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    where?: DesignationWhereInput
    orderBy?: DesignationOrderByWithRelationAndSearchRelevanceInput | DesignationOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DesignationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * User.deleted_designations
   */
  export type User$deleted_designationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    where?: DesignationWhereInput
    orderBy?: DesignationOrderByWithRelationAndSearchRelevanceInput | DesignationOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DesignationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * User.audit_logs
   */
  export type User$audit_logsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    where?: AuditLogWhereInput
    orderBy?: AuditLogOrderByWithRelationAndSearchRelevanceInput | AuditLogOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: AuditLogWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AuditLogScalarFieldEnum | AuditLogScalarFieldEnum[]
  }

  /**
   * User.created_category_types
   */
  export type User$created_category_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    where?: CategoryTypesWhereInput
    orderBy?: CategoryTypesOrderByWithRelationAndSearchRelevanceInput | CategoryTypesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CategoryTypesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CategoryTypesScalarFieldEnum | CategoryTypesScalarFieldEnum[]
  }

  /**
   * User.updated_category_types
   */
  export type User$updated_category_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    where?: CategoryTypesWhereInput
    orderBy?: CategoryTypesOrderByWithRelationAndSearchRelevanceInput | CategoryTypesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CategoryTypesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CategoryTypesScalarFieldEnum | CategoryTypesScalarFieldEnum[]
  }

  /**
   * User.deleted_category_types
   */
  export type User$deleted_category_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    where?: CategoryTypesWhereInput
    orderBy?: CategoryTypesOrderByWithRelationAndSearchRelevanceInput | CategoryTypesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CategoryTypesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CategoryTypesScalarFieldEnum | CategoryTypesScalarFieldEnum[]
  }

  /**
   * User.created_categories
   */
  export type User$created_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    where?: CategoriesWhereInput
    orderBy?: CategoriesOrderByWithRelationAndSearchRelevanceInput | CategoriesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CategoriesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CategoriesScalarFieldEnum | CategoriesScalarFieldEnum[]
  }

  /**
   * User.updated_categories
   */
  export type User$updated_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    where?: CategoriesWhereInput
    orderBy?: CategoriesOrderByWithRelationAndSearchRelevanceInput | CategoriesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CategoriesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CategoriesScalarFieldEnum | CategoriesScalarFieldEnum[]
  }

  /**
   * User.deleted_categories
   */
  export type User$deleted_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    where?: CategoriesWhereInput
    orderBy?: CategoriesOrderByWithRelationAndSearchRelevanceInput | CategoriesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: CategoriesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CategoriesScalarFieldEnum | CategoriesScalarFieldEnum[]
  }

  /**
   * User.created_configurations
   */
  export type User$created_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    where?: ConfigurationsWhereInput
    orderBy?: ConfigurationsOrderByWithRelationAndSearchRelevanceInput | ConfigurationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ConfigurationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ConfigurationsScalarFieldEnum | ConfigurationsScalarFieldEnum[]
  }

  /**
   * User.updated_configurations
   */
  export type User$updated_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    where?: ConfigurationsWhereInput
    orderBy?: ConfigurationsOrderByWithRelationAndSearchRelevanceInput | ConfigurationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ConfigurationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ConfigurationsScalarFieldEnum | ConfigurationsScalarFieldEnum[]
  }

  /**
   * User.deleted_configurations
   */
  export type User$deleted_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    where?: ConfigurationsWhereInput
    orderBy?: ConfigurationsOrderByWithRelationAndSearchRelevanceInput | ConfigurationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ConfigurationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ConfigurationsScalarFieldEnum | ConfigurationsScalarFieldEnum[]
  }

  /**
   * User.created_user_configurations
   */
  export type User$created_user_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserConfigurations
     */
    select?: UserConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserConfigurationsInclude<ExtArgs> | null
    where?: UserConfigurationsWhereInput
    orderBy?: UserConfigurationsOrderByWithRelationAndSearchRelevanceInput | UserConfigurationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserConfigurationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserConfigurationsScalarFieldEnum | UserConfigurationsScalarFieldEnum[]
  }

  /**
   * User.updated_user_configurations
   */
  export type User$updated_user_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserConfigurations
     */
    select?: UserConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserConfigurationsInclude<ExtArgs> | null
    where?: UserConfigurationsWhereInput
    orderBy?: UserConfigurationsOrderByWithRelationAndSearchRelevanceInput | UserConfigurationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserConfigurationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserConfigurationsScalarFieldEnum | UserConfigurationsScalarFieldEnum[]
  }

  /**
   * User.deleted_user_configurations
   */
  export type User$deleted_user_configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserConfigurations
     */
    select?: UserConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserConfigurationsInclude<ExtArgs> | null
    where?: UserConfigurationsWhereInput
    orderBy?: UserConfigurationsOrderByWithRelationAndSearchRelevanceInput | UserConfigurationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserConfigurationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserConfigurationsScalarFieldEnum | UserConfigurationsScalarFieldEnum[]
  }

  /**
   * User.created_fin_years
   */
  export type User$created_fin_yearsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    where?: FinancialYearWhereInput
    orderBy?: FinancialYearOrderByWithRelationAndSearchRelevanceInput | FinancialYearOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: FinancialYearWhereUniqueInput
    take?: number
    skip?: number
    distinct?: FinancialYearScalarFieldEnum | FinancialYearScalarFieldEnum[]
  }

  /**
   * User.updated_fin_years
   */
  export type User$updated_fin_yearsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    where?: FinancialYearWhereInput
    orderBy?: FinancialYearOrderByWithRelationAndSearchRelevanceInput | FinancialYearOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: FinancialYearWhereUniqueInput
    take?: number
    skip?: number
    distinct?: FinancialYearScalarFieldEnum | FinancialYearScalarFieldEnum[]
  }

  /**
   * User.deleted_fin_years
   */
  export type User$deleted_fin_yearsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    where?: FinancialYearWhereInput
    orderBy?: FinancialYearOrderByWithRelationAndSearchRelevanceInput | FinancialYearOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: FinancialYearWhereUniqueInput
    take?: number
    skip?: number
    distinct?: FinancialYearScalarFieldEnum | FinancialYearScalarFieldEnum[]
  }

  /**
   * User.created_doc_sequences
   */
  export type User$created_doc_sequencesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    where?: DocumentSequenceWhereInput
    orderBy?: DocumentSequenceOrderByWithRelationAndSearchRelevanceInput | DocumentSequenceOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DocumentSequenceWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DocumentSequenceScalarFieldEnum | DocumentSequenceScalarFieldEnum[]
  }

  /**
   * User.updated_doc_sequences
   */
  export type User$updated_doc_sequencesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    where?: DocumentSequenceWhereInput
    orderBy?: DocumentSequenceOrderByWithRelationAndSearchRelevanceInput | DocumentSequenceOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DocumentSequenceWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DocumentSequenceScalarFieldEnum | DocumentSequenceScalarFieldEnum[]
  }

  /**
   * User.deleted_doc_sequences
   */
  export type User$deleted_doc_sequencesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    where?: DocumentSequenceWhereInput
    orderBy?: DocumentSequenceOrderByWithRelationAndSearchRelevanceInput | DocumentSequenceOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DocumentSequenceWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DocumentSequenceScalarFieldEnum | DocumentSequenceScalarFieldEnum[]
  }

  /**
   * User.created_device_registration
   */
  export type User$created_device_registrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DeviceRegistration
     */
    select?: DeviceRegistrationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DeviceRegistrationInclude<ExtArgs> | null
    where?: DeviceRegistrationWhereInput
    orderBy?: DeviceRegistrationOrderByWithRelationAndSearchRelevanceInput | DeviceRegistrationOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DeviceRegistrationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DeviceRegistrationScalarFieldEnum | DeviceRegistrationScalarFieldEnum[]
  }

  /**
   * User.updated_device_registration
   */
  export type User$updated_device_registrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DeviceRegistration
     */
    select?: DeviceRegistrationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DeviceRegistrationInclude<ExtArgs> | null
    where?: DeviceRegistrationWhereInput
    orderBy?: DeviceRegistrationOrderByWithRelationAndSearchRelevanceInput | DeviceRegistrationOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DeviceRegistrationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DeviceRegistrationScalarFieldEnum | DeviceRegistrationScalarFieldEnum[]
  }

  /**
   * User.deleted_device_registration
   */
  export type User$deleted_device_registrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DeviceRegistration
     */
    select?: DeviceRegistrationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DeviceRegistrationInclude<ExtArgs> | null
    where?: DeviceRegistrationWhereInput
    orderBy?: DeviceRegistrationOrderByWithRelationAndSearchRelevanceInput | DeviceRegistrationOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DeviceRegistrationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DeviceRegistrationScalarFieldEnum | DeviceRegistrationScalarFieldEnum[]
  }

  /**
   * User.DeviceRegistration
   */
  export type User$DeviceRegistrationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DeviceRegistration
     */
    select?: DeviceRegistrationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DeviceRegistrationInclude<ExtArgs> | null
    where?: DeviceRegistrationWhereInput
    orderBy?: DeviceRegistrationOrderByWithRelationAndSearchRelevanceInput | DeviceRegistrationOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DeviceRegistrationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DeviceRegistrationScalarFieldEnum | DeviceRegistrationScalarFieldEnum[]
  }

  /**
   * User.created_import_job
   */
  export type User$created_import_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ImportJob
     */
    select?: ImportJobSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ImportJobInclude<ExtArgs> | null
    where?: ImportJobWhereInput
    orderBy?: ImportJobOrderByWithRelationAndSearchRelevanceInput | ImportJobOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ImportJobWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ImportJobScalarFieldEnum | ImportJobScalarFieldEnum[]
  }

  /**
   * User.updated_import_job
   */
  export type User$updated_import_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ImportJob
     */
    select?: ImportJobSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ImportJobInclude<ExtArgs> | null
    where?: ImportJobWhereInput
    orderBy?: ImportJobOrderByWithRelationAndSearchRelevanceInput | ImportJobOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ImportJobWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ImportJobScalarFieldEnum | ImportJobScalarFieldEnum[]
  }

  /**
   * User.deleted_import_job
   */
  export type User$deleted_import_jobArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ImportJob
     */
    select?: ImportJobSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ImportJobInclude<ExtArgs> | null
    where?: ImportJobWhereInput
    orderBy?: ImportJobOrderByWithRelationAndSearchRelevanceInput | ImportJobOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ImportJobWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ImportJobScalarFieldEnum | ImportJobScalarFieldEnum[]
  }

  /**
   * User.created_organizations
   */
  export type User$created_organizationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Organizations
     */
    select?: OrganizationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: OrganizationsInclude<ExtArgs> | null
    where?: OrganizationsWhereInput
    orderBy?: OrganizationsOrderByWithRelationAndSearchRelevanceInput | OrganizationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: OrganizationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: OrganizationsScalarFieldEnum | OrganizationsScalarFieldEnum[]
  }

  /**
   * User.updated_organizations
   */
  export type User$updated_organizationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Organizations
     */
    select?: OrganizationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: OrganizationsInclude<ExtArgs> | null
    where?: OrganizationsWhereInput
    orderBy?: OrganizationsOrderByWithRelationAndSearchRelevanceInput | OrganizationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: OrganizationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: OrganizationsScalarFieldEnum | OrganizationsScalarFieldEnum[]
  }

  /**
   * User.deleted_organizations
   */
  export type User$deleted_organizationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Organizations
     */
    select?: OrganizationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: OrganizationsInclude<ExtArgs> | null
    where?: OrganizationsWhereInput
    orderBy?: OrganizationsOrderByWithRelationAndSearchRelevanceInput | OrganizationsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: OrganizationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: OrganizationsScalarFieldEnum | OrganizationsScalarFieldEnum[]
  }

  /**
   * User.user_policy
   */
  export type User$user_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPolicies
     */
    select?: UserPoliciesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPoliciesInclude<ExtArgs> | null
    where?: UserPoliciesWhereInput
    orderBy?: UserPoliciesOrderByWithRelationAndSearchRelevanceInput | UserPoliciesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserPoliciesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPoliciesScalarFieldEnum | UserPoliciesScalarFieldEnum[]
  }

  /**
   * User.created_policy
   */
  export type User$created_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Policies
     */
    select?: PoliciesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PoliciesInclude<ExtArgs> | null
    where?: PoliciesWhereInput
    orderBy?: PoliciesOrderByWithRelationAndSearchRelevanceInput | PoliciesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: PoliciesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: PoliciesScalarFieldEnum | PoliciesScalarFieldEnum[]
  }

  /**
   * User.updated_policy
   */
  export type User$updated_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Policies
     */
    select?: PoliciesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PoliciesInclude<ExtArgs> | null
    where?: PoliciesWhereInput
    orderBy?: PoliciesOrderByWithRelationAndSearchRelevanceInput | PoliciesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: PoliciesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: PoliciesScalarFieldEnum | PoliciesScalarFieldEnum[]
  }

  /**
   * User.deleted_policy
   */
  export type User$deleted_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Policies
     */
    select?: PoliciesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PoliciesInclude<ExtArgs> | null
    where?: PoliciesWhereInput
    orderBy?: PoliciesOrderByWithRelationAndSearchRelevanceInput | PoliciesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: PoliciesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: PoliciesScalarFieldEnum | PoliciesScalarFieldEnum[]
  }

  /**
   * User.created_app_versions
   */
  export type User$created_app_versionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Appversions
     */
    select?: AppversionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AppversionsInclude<ExtArgs> | null
    where?: AppversionsWhereInput
    orderBy?: AppversionsOrderByWithRelationAndSearchRelevanceInput | AppversionsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: AppversionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AppversionsScalarFieldEnum | AppversionsScalarFieldEnum[]
  }

  /**
   * User.updated_app_versions
   */
  export type User$updated_app_versionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Appversions
     */
    select?: AppversionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AppversionsInclude<ExtArgs> | null
    where?: AppversionsWhereInput
    orderBy?: AppversionsOrderByWithRelationAndSearchRelevanceInput | AppversionsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: AppversionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AppversionsScalarFieldEnum | AppversionsScalarFieldEnum[]
  }

  /**
   * User.deleted_app_versions
   */
  export type User$deleted_app_versionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Appversions
     */
    select?: AppversionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AppversionsInclude<ExtArgs> | null
    where?: AppversionsWhereInput
    orderBy?: AppversionsOrderByWithRelationAndSearchRelevanceInput | AppversionsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: AppversionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AppversionsScalarFieldEnum | AppversionsScalarFieldEnum[]
  }

  /**
   * User.ChildProcessLog
   */
  export type User$ChildProcessLogArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ChildProcessLog
     */
    select?: ChildProcessLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ChildProcessLogInclude<ExtArgs> | null
    where?: ChildProcessLogWhereInput
    orderBy?: ChildProcessLogOrderByWithRelationAndSearchRelevanceInput | ChildProcessLogOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: ChildProcessLogWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ChildProcessLogScalarFieldEnum | ChildProcessLogScalarFieldEnum[]
  }

  /**
   * User without action
   */
  export type UserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
  }


  /**
   * Model UserDetail
   */

  export type AggregateUserDetail = {
    _count: UserDetailCountAggregateOutputType | null
    _avg: UserDetailAvgAggregateOutputType | null
    _sum: UserDetailSumAggregateOutputType | null
    _min: UserDetailMinAggregateOutputType | null
    _max: UserDetailMaxAggregateOutputType | null
  }

  export type UserDetailAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    designation_id: number | null
    department_id: number | null
    organization_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type UserDetailSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    designation_id: number | null
    department_id: number | null
    organization_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type UserDetailMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    code: string | null
    first_name: string | null
    last_name: string | null
    designation_id: number | null
    department_id: number | null
    organization_id: number | null
    profile_pic: string | null
    dob: Date | null
    country_code: string | null
    phone_number: string | null
    gender: $Enums.Gender | null
    user_time_zone: string | null
    address: string | null
    culture: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type UserDetailMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    code: string | null
    first_name: string | null
    last_name: string | null
    designation_id: number | null
    department_id: number | null
    organization_id: number | null
    profile_pic: string | null
    dob: Date | null
    country_code: string | null
    phone_number: string | null
    gender: $Enums.Gender | null
    user_time_zone: string | null
    address: string | null
    culture: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type UserDetailCountAggregateOutputType = {
    id: number
    user_id: number
    code: number
    first_name: number
    last_name: number
    designation_id: number
    department_id: number
    organization_id: number
    profile_pic: number
    dob: number
    country_code: number
    phone_number: number
    gender: number
    user_time_zone: number
    address: number
    culture: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type UserDetailAvgAggregateInputType = {
    id?: true
    user_id?: true
    designation_id?: true
    department_id?: true
    organization_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type UserDetailSumAggregateInputType = {
    id?: true
    user_id?: true
    designation_id?: true
    department_id?: true
    organization_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type UserDetailMinAggregateInputType = {
    id?: true
    user_id?: true
    code?: true
    first_name?: true
    last_name?: true
    designation_id?: true
    department_id?: true
    organization_id?: true
    profile_pic?: true
    dob?: true
    country_code?: true
    phone_number?: true
    gender?: true
    user_time_zone?: true
    address?: true
    culture?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type UserDetailMaxAggregateInputType = {
    id?: true
    user_id?: true
    code?: true
    first_name?: true
    last_name?: true
    designation_id?: true
    department_id?: true
    organization_id?: true
    profile_pic?: true
    dob?: true
    country_code?: true
    phone_number?: true
    gender?: true
    user_time_zone?: true
    address?: true
    culture?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type UserDetailCountAggregateInputType = {
    id?: true
    user_id?: true
    code?: true
    first_name?: true
    last_name?: true
    designation_id?: true
    department_id?: true
    organization_id?: true
    profile_pic?: true
    dob?: true
    country_code?: true
    phone_number?: true
    gender?: true
    user_time_zone?: true
    address?: true
    culture?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type UserDetailAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserDetail to aggregate.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserDetails
    **/
    _count?: true | UserDetailCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserDetailAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserDetailSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserDetailMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserDetailMaxAggregateInputType
  }

  export type GetUserDetailAggregateType<T extends UserDetailAggregateArgs> = {
        [P in keyof T & keyof AggregateUserDetail]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserDetail[P]>
      : GetScalarType<T[P], AggregateUserDetail[P]>
  }




  export type UserDetailGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithAggregationInput | UserDetailOrderByWithAggregationInput[]
    by: UserDetailScalarFieldEnum[] | UserDetailScalarFieldEnum
    having?: UserDetailScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserDetailCountAggregateInputType | true
    _avg?: UserDetailAvgAggregateInputType
    _sum?: UserDetailSumAggregateInputType
    _min?: UserDetailMinAggregateInputType
    _max?: UserDetailMaxAggregateInputType
  }

  export type UserDetailGroupByOutputType = {
    id: number
    user_id: number
    code: string
    first_name: string
    last_name: string | null
    designation_id: number | null
    department_id: number | null
    organization_id: number | null
    profile_pic: string | null
    dob: Date | null
    country_code: string | null
    phone_number: string | null
    gender: $Enums.Gender
    user_time_zone: string | null
    address: string | null
    culture: string | null
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: UserDetailCountAggregateOutputType | null
    _avg: UserDetailAvgAggregateOutputType | null
    _sum: UserDetailSumAggregateOutputType | null
    _min: UserDetailMinAggregateOutputType | null
    _max: UserDetailMaxAggregateOutputType | null
  }

  type GetUserDetailGroupByPayload<T extends UserDetailGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserDetailGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserDetailGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserDetailGroupByOutputType[P]>
            : GetScalarType<T[P], UserDetailGroupByOutputType[P]>
        }
      >
    >


  export type UserDetailSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    code?: boolean
    first_name?: boolean
    last_name?: boolean
    designation_id?: boolean
    department_id?: boolean
    organization_id?: boolean
    profile_pic?: boolean
    dob?: boolean
    country_code?: boolean
    phone_number?: boolean
    gender?: boolean
    user_time_zone?: boolean
    address?: boolean
    culture?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    designation?: boolean | UserDetail$designationArgs<ExtArgs>
    department?: boolean | UserDetail$departmentArgs<ExtArgs>
    organizations?: boolean | UserDetail$organizationsArgs<ExtArgs>
    user?: boolean | UserDefaultArgs<ExtArgs>
    created?: boolean | UserDetail$createdArgs<ExtArgs>
    updated?: boolean | UserDetail$updatedArgs<ExtArgs>
    deleted?: boolean | UserDetail$deletedArgs<ExtArgs>
  }, ExtArgs["result"]["userDetail"]>

  export type UserDetailSelectScalar = {
    id?: boolean
    user_id?: boolean
    code?: boolean
    first_name?: boolean
    last_name?: boolean
    designation_id?: boolean
    department_id?: boolean
    organization_id?: boolean
    profile_pic?: boolean
    dob?: boolean
    country_code?: boolean
    phone_number?: boolean
    gender?: boolean
    user_time_zone?: boolean
    address?: boolean
    culture?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }


  export type UserDetailInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    designation?: boolean | UserDetail$designationArgs<ExtArgs>
    department?: boolean | UserDetail$departmentArgs<ExtArgs>
    organizations?: boolean | UserDetail$organizationsArgs<ExtArgs>
    user?: boolean | UserDefaultArgs<ExtArgs>
    created?: boolean | UserDetail$createdArgs<ExtArgs>
    updated?: boolean | UserDetail$updatedArgs<ExtArgs>
    deleted?: boolean | UserDetail$deletedArgs<ExtArgs>
  }


  export type $UserDetailPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserDetail"
    objects: {
      designation: Prisma.$DesignationPayload<ExtArgs> | null
      department: Prisma.$DepartmentPayload<ExtArgs> | null
      organizations: Prisma.$OrganizationsPayload<ExtArgs> | null
      user: Prisma.$UserPayload<ExtArgs>
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      code: string
      first_name: string
      last_name: string | null
      designation_id: number | null
      department_id: number | null
      organization_id: number | null
      profile_pic: string | null
      dob: Date | null
      country_code: string | null
      phone_number: string | null
      gender: $Enums.Gender
      user_time_zone: string | null
      address: string | null
      culture: string | null
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["userDetail"]>
    composites: {}
  }


  type UserDetailGetPayload<S extends boolean | null | undefined | UserDetailDefaultArgs> = $Result.GetResult<Prisma.$UserDetailPayload, S>

  type UserDetailCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserDetailFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserDetailCountAggregateInputType | true
    }

  export interface UserDetailDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserDetail'], meta: { name: 'UserDetail' } }
    /**
     * Find zero or one UserDetail that matches the filter.
     * @param {UserDetailFindUniqueArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserDetailFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailFindUniqueArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one UserDetail that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserDetailFindUniqueOrThrowArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserDetailFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first UserDetail that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindFirstArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserDetailFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailFindFirstArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first UserDetail that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindFirstOrThrowArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserDetailFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more UserDetails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserDetails
     * const userDetails = await prisma.userDetail.findMany()
     * 
     * // Get first 10 UserDetails
     * const userDetails = await prisma.userDetail.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userDetailWithIdOnly = await prisma.userDetail.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends UserDetailFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a UserDetail.
     * @param {UserDetailCreateArgs} args - Arguments to create a UserDetail.
     * @example
     * // Create one UserDetail
     * const UserDetail = await prisma.userDetail.create({
     *   data: {
     *     // ... data to create a UserDetail
     *   }
     * })
     * 
    **/
    create<T extends UserDetailCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailCreateArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many UserDetails.
     * @param {UserDetailCreateManyArgs} args - Arguments to create many UserDetails.
     * @example
     * // Create many UserDetails
     * const userDetail = await prisma.userDetail.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends UserDetailCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserDetails and returns the data saved in the database.
     * @param {UserDetailCreateManyAndReturnArgs} args - Arguments to create many UserDetails.
     * @example
     * // Create many UserDetails
     * const userDetail = await prisma.userDetail.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserDetails and only return the `id`
     * const userDetailWithIdOnly = await prisma.userDetail.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends UserDetailCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a UserDetail.
     * @param {UserDetailDeleteArgs} args - Arguments to delete one UserDetail.
     * @example
     * // Delete one UserDetail
     * const UserDetail = await prisma.userDetail.delete({
     *   where: {
     *     // ... filter to delete one UserDetail
     *   }
     * })
     * 
    **/
    delete<T extends UserDetailDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailDeleteArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one UserDetail.
     * @param {UserDetailUpdateArgs} args - Arguments to update one UserDetail.
     * @example
     * // Update one UserDetail
     * const userDetail = await prisma.userDetail.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserDetailUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailUpdateArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more UserDetails.
     * @param {UserDetailDeleteManyArgs} args - Arguments to filter UserDetails to delete.
     * @example
     * // Delete a few UserDetails
     * const { count } = await prisma.userDetail.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserDetailDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserDetails
     * const userDetail = await prisma.userDetail.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserDetailUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserDetail.
     * @param {UserDetailUpsertArgs} args - Arguments to update or create a UserDetail.
     * @example
     * // Update or create a UserDetail
     * const userDetail = await prisma.userDetail.upsert({
     *   create: {
     *     // ... data to create a UserDetail
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserDetail we want to update
     *   }
     * })
    **/
    upsert<T extends UserDetailUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailUpsertArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailCountArgs} args - Arguments to filter UserDetails to count.
     * @example
     * // Count the number of UserDetails
     * const count = await prisma.userDetail.count({
     *   where: {
     *     // ... the filter for the UserDetails we want to count
     *   }
     * })
    **/
    count<T extends UserDetailCountArgs>(
      args?: Subset<T, UserDetailCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserDetailCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserDetail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserDetailAggregateArgs>(args: Subset<T, UserDetailAggregateArgs>): Prisma.PrismaPromise<GetUserDetailAggregateType<T>>

    /**
     * Group by UserDetail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserDetailGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserDetailGroupByArgs['orderBy'] }
        : { orderBy?: UserDetailGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserDetailGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserDetailGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserDetail model
   */
  readonly fields: UserDetailFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserDetail.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserDetailClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    designation<T extends UserDetail$designationArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$designationArgs<ExtArgs>>): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    department<T extends UserDetail$departmentArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$departmentArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    organizations<T extends UserDetail$organizationsArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$organizationsArgs<ExtArgs>>): Prisma__OrganizationsClient<$Result.GetResult<Prisma.$OrganizationsPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    created<T extends UserDetail$createdArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends UserDetail$updatedArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends UserDetail$deletedArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the UserDetail model
   */ 
  interface UserDetailFieldRefs {
    readonly id: FieldRef<"UserDetail", 'Int'>
    readonly user_id: FieldRef<"UserDetail", 'Int'>
    readonly code: FieldRef<"UserDetail", 'String'>
    readonly first_name: FieldRef<"UserDetail", 'String'>
    readonly last_name: FieldRef<"UserDetail", 'String'>
    readonly designation_id: FieldRef<"UserDetail", 'Int'>
    readonly department_id: FieldRef<"UserDetail", 'Int'>
    readonly organization_id: FieldRef<"UserDetail", 'Int'>
    readonly profile_pic: FieldRef<"UserDetail", 'String'>
    readonly dob: FieldRef<"UserDetail", 'DateTime'>
    readonly country_code: FieldRef<"UserDetail", 'String'>
    readonly phone_number: FieldRef<"UserDetail", 'String'>
    readonly gender: FieldRef<"UserDetail", 'Gender'>
    readonly user_time_zone: FieldRef<"UserDetail", 'String'>
    readonly address: FieldRef<"UserDetail", 'String'>
    readonly culture: FieldRef<"UserDetail", 'String'>
    readonly company_id: FieldRef<"UserDetail", 'Int'>
    readonly created_by: FieldRef<"UserDetail", 'Int'>
    readonly updated_by: FieldRef<"UserDetail", 'Int'>
    readonly deleted_by: FieldRef<"UserDetail", 'Int'>
    readonly created_at: FieldRef<"UserDetail", 'DateTime'>
    readonly updated_at: FieldRef<"UserDetail", 'DateTime'>
    readonly deleted_at: FieldRef<"UserDetail", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * UserDetail findUnique
   */
  export type UserDetailFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail findUniqueOrThrow
   */
  export type UserDetailFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail findFirst
   */
  export type UserDetailFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserDetails.
     */
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * UserDetail findFirstOrThrow
   */
  export type UserDetailFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserDetails.
     */
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * UserDetail findMany
   */
  export type UserDetailFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetails to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * UserDetail create
   */
  export type UserDetailCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * The data needed to create a UserDetail.
     */
    data: XOR<UserDetailCreateInput, UserDetailUncheckedCreateInput>
  }

  /**
   * UserDetail createMany
   */
  export type UserDetailCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserDetails.
     */
    data: UserDetailCreateManyInput | UserDetailCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserDetail createManyAndReturn
   */
  export type UserDetailCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * The data used to create many UserDetails.
     */
    data: UserDetailCreateManyInput | UserDetailCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserDetail update
   */
  export type UserDetailUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * The data needed to update a UserDetail.
     */
    data: XOR<UserDetailUpdateInput, UserDetailUncheckedUpdateInput>
    /**
     * Choose, which UserDetail to update.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail updateMany
   */
  export type UserDetailUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserDetails.
     */
    data: XOR<UserDetailUpdateManyMutationInput, UserDetailUncheckedUpdateManyInput>
    /**
     * Filter which UserDetails to update
     */
    where?: UserDetailWhereInput
  }

  /**
   * UserDetail upsert
   */
  export type UserDetailUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * The filter to search for the UserDetail to update in case it exists.
     */
    where: UserDetailWhereUniqueInput
    /**
     * In case the UserDetail found by the `where` argument doesn't exist, create a new UserDetail with this data.
     */
    create: XOR<UserDetailCreateInput, UserDetailUncheckedCreateInput>
    /**
     * In case the UserDetail was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserDetailUpdateInput, UserDetailUncheckedUpdateInput>
  }

  /**
   * UserDetail delete
   */
  export type UserDetailDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter which UserDetail to delete.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail deleteMany
   */
  export type UserDetailDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserDetails to delete
     */
    where?: UserDetailWhereInput
  }

  /**
   * UserDetail.designation
   */
  export type UserDetail$designationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    where?: DesignationWhereInput
  }

  /**
   * UserDetail.department
   */
  export type UserDetail$departmentArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    where?: DepartmentWhereInput
  }

  /**
   * UserDetail.organizations
   */
  export type UserDetail$organizationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Organizations
     */
    select?: OrganizationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: OrganizationsInclude<ExtArgs> | null
    where?: OrganizationsWhereInput
  }

  /**
   * UserDetail.created
   */
  export type UserDetail$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * UserDetail.updated
   */
  export type UserDetail$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * UserDetail.deleted
   */
  export type UserDetail$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * UserDetail without action
   */
  export type UserDetailDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
  }


  /**
   * Model Designation
   */

  export type AggregateDesignation = {
    _count: DesignationCountAggregateOutputType | null
    _avg: DesignationAvgAggregateOutputType | null
    _sum: DesignationSumAggregateOutputType | null
    _min: DesignationMinAggregateOutputType | null
    _max: DesignationMaxAggregateOutputType | null
  }

  export type DesignationAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type DesignationSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type DesignationMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    code: string | null
    name: string | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type DesignationMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    code: string | null
    name: string | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type DesignationCountAggregateOutputType = {
    id: number
    uuid: number
    code: number
    name: number
    description: number
    status_id: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type DesignationAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type DesignationSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type DesignationMinAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type DesignationMaxAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type DesignationCountAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type DesignationAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Designation to aggregate.
     */
    where?: DesignationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Designations to fetch.
     */
    orderBy?: DesignationOrderByWithRelationAndSearchRelevanceInput | DesignationOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: DesignationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Designations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Designations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Designations
    **/
    _count?: true | DesignationCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: DesignationAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: DesignationSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: DesignationMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: DesignationMaxAggregateInputType
  }

  export type GetDesignationAggregateType<T extends DesignationAggregateArgs> = {
        [P in keyof T & keyof AggregateDesignation]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDesignation[P]>
      : GetScalarType<T[P], AggregateDesignation[P]>
  }




  export type DesignationGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DesignationWhereInput
    orderBy?: DesignationOrderByWithAggregationInput | DesignationOrderByWithAggregationInput[]
    by: DesignationScalarFieldEnum[] | DesignationScalarFieldEnum
    having?: DesignationScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: DesignationCountAggregateInputType | true
    _avg?: DesignationAvgAggregateInputType
    _sum?: DesignationSumAggregateInputType
    _min?: DesignationMinAggregateInputType
    _max?: DesignationMaxAggregateInputType
  }

  export type DesignationGroupByOutputType = {
    id: number
    uuid: string
    code: string
    name: string
    description: string | null
    status_id: number
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: DesignationCountAggregateOutputType | null
    _avg: DesignationAvgAggregateOutputType | null
    _sum: DesignationSumAggregateOutputType | null
    _min: DesignationMinAggregateOutputType | null
    _max: DesignationMaxAggregateOutputType | null
  }

  type GetDesignationGroupByPayload<T extends DesignationGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<DesignationGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof DesignationGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], DesignationGroupByOutputType[P]>
            : GetScalarType<T[P], DesignationGroupByOutputType[P]>
        }
      >
    >


  export type DesignationSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    code?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    users?: boolean | Designation$usersArgs<ExtArgs>
    created?: boolean | Designation$createdArgs<ExtArgs>
    updated?: boolean | Designation$updatedArgs<ExtArgs>
    deleted?: boolean | Designation$deletedArgs<ExtArgs>
    _count?: boolean | DesignationCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["designation"]>

  export type DesignationSelectScalar = {
    id?: boolean
    uuid?: boolean
    code?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }


  export type DesignationInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    users?: boolean | Designation$usersArgs<ExtArgs>
    created?: boolean | Designation$createdArgs<ExtArgs>
    updated?: boolean | Designation$updatedArgs<ExtArgs>
    deleted?: boolean | Designation$deletedArgs<ExtArgs>
    _count?: boolean | DesignationCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $DesignationPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Designation"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      users: Prisma.$UserDetailPayload<ExtArgs>[]
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      code: string
      name: string
      description: string | null
      status_id: number
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["designation"]>
    composites: {}
  }


  type DesignationGetPayload<S extends boolean | null | undefined | DesignationDefaultArgs> = $Result.GetResult<Prisma.$DesignationPayload, S>

  type DesignationCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<DesignationFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: DesignationCountAggregateInputType | true
    }

  export interface DesignationDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Designation'], meta: { name: 'Designation' } }
    /**
     * Find zero or one Designation that matches the filter.
     * @param {DesignationFindUniqueArgs} args - Arguments to find a Designation
     * @example
     * // Get one Designation
     * const designation = await prisma.designation.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends DesignationFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationFindUniqueArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Designation that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {DesignationFindUniqueOrThrowArgs} args - Arguments to find a Designation
     * @example
     * // Get one Designation
     * const designation = await prisma.designation.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends DesignationFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Designation that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationFindFirstArgs} args - Arguments to find a Designation
     * @example
     * // Get one Designation
     * const designation = await prisma.designation.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends DesignationFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationFindFirstArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Designation that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationFindFirstOrThrowArgs} args - Arguments to find a Designation
     * @example
     * // Get one Designation
     * const designation = await prisma.designation.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends DesignationFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Designations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Designations
     * const designations = await prisma.designation.findMany()
     * 
     * // Get first 10 Designations
     * const designations = await prisma.designation.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const designationWithIdOnly = await prisma.designation.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends DesignationFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Designation.
     * @param {DesignationCreateArgs} args - Arguments to create a Designation.
     * @example
     * // Create one Designation
     * const Designation = await prisma.designation.create({
     *   data: {
     *     // ... data to create a Designation
     *   }
     * })
     * 
    **/
    create<T extends DesignationCreateArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationCreateArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Designations.
     * @param {DesignationCreateManyArgs} args - Arguments to create many Designations.
     * @example
     * // Create many Designations
     * const designation = await prisma.designation.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends DesignationCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Designations and returns the data saved in the database.
     * @param {DesignationCreateManyAndReturnArgs} args - Arguments to create many Designations.
     * @example
     * // Create many Designations
     * const designation = await prisma.designation.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Designations and only return the `id`
     * const designationWithIdOnly = await prisma.designation.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends DesignationCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Designation.
     * @param {DesignationDeleteArgs} args - Arguments to delete one Designation.
     * @example
     * // Delete one Designation
     * const Designation = await prisma.designation.delete({
     *   where: {
     *     // ... filter to delete one Designation
     *   }
     * })
     * 
    **/
    delete<T extends DesignationDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationDeleteArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Designation.
     * @param {DesignationUpdateArgs} args - Arguments to update one Designation.
     * @example
     * // Update one Designation
     * const designation = await prisma.designation.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends DesignationUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationUpdateArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Designations.
     * @param {DesignationDeleteManyArgs} args - Arguments to filter Designations to delete.
     * @example
     * // Delete a few Designations
     * const { count } = await prisma.designation.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends DesignationDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Designations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Designations
     * const designation = await prisma.designation.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends DesignationUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Designation.
     * @param {DesignationUpsertArgs} args - Arguments to update or create a Designation.
     * @example
     * // Update or create a Designation
     * const designation = await prisma.designation.upsert({
     *   create: {
     *     // ... data to create a Designation
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Designation we want to update
     *   }
     * })
    **/
    upsert<T extends DesignationUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationUpsertArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Designations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationCountArgs} args - Arguments to filter Designations to count.
     * @example
     * // Count the number of Designations
     * const count = await prisma.designation.count({
     *   where: {
     *     // ... the filter for the Designations we want to count
     *   }
     * })
    **/
    count<T extends DesignationCountArgs>(
      args?: Subset<T, DesignationCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], DesignationCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Designation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends DesignationAggregateArgs>(args: Subset<T, DesignationAggregateArgs>): Prisma.PrismaPromise<GetDesignationAggregateType<T>>

    /**
     * Group by Designation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends DesignationGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: DesignationGroupByArgs['orderBy'] }
        : { orderBy?: DesignationGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, DesignationGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDesignationGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Designation model
   */
  readonly fields: DesignationFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Designation.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__DesignationClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    users<T extends Designation$usersArgs<ExtArgs> = {}>(args?: Subset<T, Designation$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    created<T extends Designation$createdArgs<ExtArgs> = {}>(args?: Subset<T, Designation$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends Designation$updatedArgs<ExtArgs> = {}>(args?: Subset<T, Designation$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends Designation$deletedArgs<ExtArgs> = {}>(args?: Subset<T, Designation$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Designation model
   */ 
  interface DesignationFieldRefs {
    readonly id: FieldRef<"Designation", 'Int'>
    readonly uuid: FieldRef<"Designation", 'String'>
    readonly code: FieldRef<"Designation", 'String'>
    readonly name: FieldRef<"Designation", 'String'>
    readonly description: FieldRef<"Designation", 'String'>
    readonly status_id: FieldRef<"Designation", 'Int'>
    readonly company_id: FieldRef<"Designation", 'Int'>
    readonly created_by: FieldRef<"Designation", 'Int'>
    readonly updated_by: FieldRef<"Designation", 'Int'>
    readonly deleted_by: FieldRef<"Designation", 'Int'>
    readonly created_at: FieldRef<"Designation", 'DateTime'>
    readonly updated_at: FieldRef<"Designation", 'DateTime'>
    readonly deleted_at: FieldRef<"Designation", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Designation findUnique
   */
  export type DesignationFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designation to fetch.
     */
    where: DesignationWhereUniqueInput
  }

  /**
   * Designation findUniqueOrThrow
   */
  export type DesignationFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designation to fetch.
     */
    where: DesignationWhereUniqueInput
  }

  /**
   * Designation findFirst
   */
  export type DesignationFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designation to fetch.
     */
    where?: DesignationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Designations to fetch.
     */
    orderBy?: DesignationOrderByWithRelationAndSearchRelevanceInput | DesignationOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Designations.
     */
    cursor?: DesignationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Designations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Designations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Designations.
     */
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * Designation findFirstOrThrow
   */
  export type DesignationFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designation to fetch.
     */
    where?: DesignationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Designations to fetch.
     */
    orderBy?: DesignationOrderByWithRelationAndSearchRelevanceInput | DesignationOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Designations.
     */
    cursor?: DesignationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Designations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Designations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Designations.
     */
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * Designation findMany
   */
  export type DesignationFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designations to fetch.
     */
    where?: DesignationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Designations to fetch.
     */
    orderBy?: DesignationOrderByWithRelationAndSearchRelevanceInput | DesignationOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Designations.
     */
    cursor?: DesignationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Designations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Designations.
     */
    skip?: number
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * Designation create
   */
  export type DesignationCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * The data needed to create a Designation.
     */
    data: XOR<DesignationCreateInput, DesignationUncheckedCreateInput>
  }

  /**
   * Designation createMany
   */
  export type DesignationCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Designations.
     */
    data: DesignationCreateManyInput | DesignationCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Designation createManyAndReturn
   */
  export type DesignationCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * The data used to create many Designations.
     */
    data: DesignationCreateManyInput | DesignationCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Designation update
   */
  export type DesignationUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * The data needed to update a Designation.
     */
    data: XOR<DesignationUpdateInput, DesignationUncheckedUpdateInput>
    /**
     * Choose, which Designation to update.
     */
    where: DesignationWhereUniqueInput
  }

  /**
   * Designation updateMany
   */
  export type DesignationUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Designations.
     */
    data: XOR<DesignationUpdateManyMutationInput, DesignationUncheckedUpdateManyInput>
    /**
     * Filter which Designations to update
     */
    where?: DesignationWhereInput
  }

  /**
   * Designation upsert
   */
  export type DesignationUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * The filter to search for the Designation to update in case it exists.
     */
    where: DesignationWhereUniqueInput
    /**
     * In case the Designation found by the `where` argument doesn't exist, create a new Designation with this data.
     */
    create: XOR<DesignationCreateInput, DesignationUncheckedCreateInput>
    /**
     * In case the Designation was found with the provided `where` argument, update it with this data.
     */
    update: XOR<DesignationUpdateInput, DesignationUncheckedUpdateInput>
  }

  /**
   * Designation delete
   */
  export type DesignationDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter which Designation to delete.
     */
    where: DesignationWhereUniqueInput
  }

  /**
   * Designation deleteMany
   */
  export type DesignationDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Designations to delete
     */
    where?: DesignationWhereInput
  }

  /**
   * Designation.users
   */
  export type Designation$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * Designation.created
   */
  export type Designation$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Designation.updated
   */
  export type Designation$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Designation.deleted
   */
  export type Designation$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Designation without action
   */
  export type DesignationDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
  }


  /**
   * Model Department
   */

  export type AggregateDepartment = {
    _count: DepartmentCountAggregateOutputType | null
    _avg: DepartmentAvgAggregateOutputType | null
    _sum: DepartmentSumAggregateOutputType | null
    _min: DepartmentMinAggregateOutputType | null
    _max: DepartmentMaxAggregateOutputType | null
  }

  export type DepartmentAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    department_head_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type DepartmentSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    department_head_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type DepartmentMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    code: string | null
    name: string | null
    description: string | null
    status_id: number | null
    department_head_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type DepartmentMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    code: string | null
    name: string | null
    description: string | null
    status_id: number | null
    department_head_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type DepartmentCountAggregateOutputType = {
    id: number
    uuid: number
    code: number
    name: number
    description: number
    status_id: number
    department_head_id: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type DepartmentAvgAggregateInputType = {
    id?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type DepartmentSumAggregateInputType = {
    id?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type DepartmentMinAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type DepartmentMaxAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type DepartmentCountAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type DepartmentAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Department to aggregate.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationAndSearchRelevanceInput | DepartmentOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Departments
    **/
    _count?: true | DepartmentCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: DepartmentAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: DepartmentSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: DepartmentMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: DepartmentMaxAggregateInputType
  }

  export type GetDepartmentAggregateType<T extends DepartmentAggregateArgs> = {
        [P in keyof T & keyof AggregateDepartment]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDepartment[P]>
      : GetScalarType<T[P], AggregateDepartment[P]>
  }




  export type DepartmentGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithAggregationInput | DepartmentOrderByWithAggregationInput[]
    by: DepartmentScalarFieldEnum[] | DepartmentScalarFieldEnum
    having?: DepartmentScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: DepartmentCountAggregateInputType | true
    _avg?: DepartmentAvgAggregateInputType
    _sum?: DepartmentSumAggregateInputType
    _min?: DepartmentMinAggregateInputType
    _max?: DepartmentMaxAggregateInputType
  }

  export type DepartmentGroupByOutputType = {
    id: number
    uuid: string
    code: string
    name: string
    description: string | null
    status_id: number
    department_head_id: number | null
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: DepartmentCountAggregateOutputType | null
    _avg: DepartmentAvgAggregateOutputType | null
    _sum: DepartmentSumAggregateOutputType | null
    _min: DepartmentMinAggregateOutputType | null
    _max: DepartmentMaxAggregateOutputType | null
  }

  type GetDepartmentGroupByPayload<T extends DepartmentGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<DepartmentGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof DepartmentGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], DepartmentGroupByOutputType[P]>
            : GetScalarType<T[P], DepartmentGroupByOutputType[P]>
        }
      >
    >


  export type DepartmentSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    code?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    department_head_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    users?: boolean | Department$usersArgs<ExtArgs>
    department_head?: boolean | Department$department_headArgs<ExtArgs>
    created?: boolean | Department$createdArgs<ExtArgs>
    updated?: boolean | Department$updatedArgs<ExtArgs>
    deleted?: boolean | Department$deletedArgs<ExtArgs>
    _count?: boolean | DepartmentCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["department"]>

  export type DepartmentSelectScalar = {
    id?: boolean
    uuid?: boolean
    code?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    department_head_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }


  export type DepartmentInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    users?: boolean | Department$usersArgs<ExtArgs>
    department_head?: boolean | Department$department_headArgs<ExtArgs>
    created?: boolean | Department$createdArgs<ExtArgs>
    updated?: boolean | Department$updatedArgs<ExtArgs>
    deleted?: boolean | Department$deletedArgs<ExtArgs>
    _count?: boolean | DepartmentCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $DepartmentPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Department"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      users: Prisma.$UserDetailPayload<ExtArgs>[]
      department_head: Prisma.$UserPayload<ExtArgs> | null
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      code: string
      name: string
      description: string | null
      status_id: number
      department_head_id: number | null
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["department"]>
    composites: {}
  }


  type DepartmentGetPayload<S extends boolean | null | undefined | DepartmentDefaultArgs> = $Result.GetResult<Prisma.$DepartmentPayload, S>

  type DepartmentCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<DepartmentFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: DepartmentCountAggregateInputType | true
    }

  export interface DepartmentDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Department'], meta: { name: 'Department' } }
    /**
     * Find zero or one Department that matches the filter.
     * @param {DepartmentFindUniqueArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends DepartmentFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentFindUniqueArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Department that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {DepartmentFindUniqueOrThrowArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends DepartmentFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Department that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindFirstArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends DepartmentFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentFindFirstArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Department that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindFirstOrThrowArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends DepartmentFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Departments that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Departments
     * const departments = await prisma.department.findMany()
     * 
     * // Get first 10 Departments
     * const departments = await prisma.department.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const departmentWithIdOnly = await prisma.department.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends DepartmentFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Department.
     * @param {DepartmentCreateArgs} args - Arguments to create a Department.
     * @example
     * // Create one Department
     * const Department = await prisma.department.create({
     *   data: {
     *     // ... data to create a Department
     *   }
     * })
     * 
    **/
    create<T extends DepartmentCreateArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentCreateArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Departments.
     * @param {DepartmentCreateManyArgs} args - Arguments to create many Departments.
     * @example
     * // Create many Departments
     * const department = await prisma.department.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends DepartmentCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Departments and returns the data saved in the database.
     * @param {DepartmentCreateManyAndReturnArgs} args - Arguments to create many Departments.
     * @example
     * // Create many Departments
     * const department = await prisma.department.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Departments and only return the `id`
     * const departmentWithIdOnly = await prisma.department.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends DepartmentCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Department.
     * @param {DepartmentDeleteArgs} args - Arguments to delete one Department.
     * @example
     * // Delete one Department
     * const Department = await prisma.department.delete({
     *   where: {
     *     // ... filter to delete one Department
     *   }
     * })
     * 
    **/
    delete<T extends DepartmentDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentDeleteArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Department.
     * @param {DepartmentUpdateArgs} args - Arguments to update one Department.
     * @example
     * // Update one Department
     * const department = await prisma.department.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends DepartmentUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentUpdateArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Departments.
     * @param {DepartmentDeleteManyArgs} args - Arguments to filter Departments to delete.
     * @example
     * // Delete a few Departments
     * const { count } = await prisma.department.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends DepartmentDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Departments.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Departments
     * const department = await prisma.department.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends DepartmentUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Department.
     * @param {DepartmentUpsertArgs} args - Arguments to update or create a Department.
     * @example
     * // Update or create a Department
     * const department = await prisma.department.upsert({
     *   create: {
     *     // ... data to create a Department
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Department we want to update
     *   }
     * })
    **/
    upsert<T extends DepartmentUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentUpsertArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Departments.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentCountArgs} args - Arguments to filter Departments to count.
     * @example
     * // Count the number of Departments
     * const count = await prisma.department.count({
     *   where: {
     *     // ... the filter for the Departments we want to count
     *   }
     * })
    **/
    count<T extends DepartmentCountArgs>(
      args?: Subset<T, DepartmentCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], DepartmentCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Department.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends DepartmentAggregateArgs>(args: Subset<T, DepartmentAggregateArgs>): Prisma.PrismaPromise<GetDepartmentAggregateType<T>>

    /**
     * Group by Department.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends DepartmentGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: DepartmentGroupByArgs['orderBy'] }
        : { orderBy?: DepartmentGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, DepartmentGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDepartmentGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Department model
   */
  readonly fields: DepartmentFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Department.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__DepartmentClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    users<T extends Department$usersArgs<ExtArgs> = {}>(args?: Subset<T, Department$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    department_head<T extends Department$department_headArgs<ExtArgs> = {}>(args?: Subset<T, Department$department_headArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    created<T extends Department$createdArgs<ExtArgs> = {}>(args?: Subset<T, Department$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends Department$updatedArgs<ExtArgs> = {}>(args?: Subset<T, Department$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends Department$deletedArgs<ExtArgs> = {}>(args?: Subset<T, Department$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Department model
   */ 
  interface DepartmentFieldRefs {
    readonly id: FieldRef<"Department", 'Int'>
    readonly uuid: FieldRef<"Department", 'String'>
    readonly code: FieldRef<"Department", 'String'>
    readonly name: FieldRef<"Department", 'String'>
    readonly description: FieldRef<"Department", 'String'>
    readonly status_id: FieldRef<"Department", 'Int'>
    readonly department_head_id: FieldRef<"Department", 'Int'>
    readonly company_id: FieldRef<"Department", 'Int'>
    readonly created_by: FieldRef<"Department", 'Int'>
    readonly updated_by: FieldRef<"Department", 'Int'>
    readonly deleted_by: FieldRef<"Department", 'Int'>
    readonly created_at: FieldRef<"Department", 'DateTime'>
    readonly updated_at: FieldRef<"Department", 'DateTime'>
    readonly deleted_at: FieldRef<"Department", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Department findUnique
   */
  export type DepartmentFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department findUniqueOrThrow
   */
  export type DepartmentFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department findFirst
   */
  export type DepartmentFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationAndSearchRelevanceInput | DepartmentOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Departments.
     */
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department findFirstOrThrow
   */
  export type DepartmentFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationAndSearchRelevanceInput | DepartmentOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Departments.
     */
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department findMany
   */
  export type DepartmentFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Departments to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationAndSearchRelevanceInput | DepartmentOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department create
   */
  export type DepartmentCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The data needed to create a Department.
     */
    data: XOR<DepartmentCreateInput, DepartmentUncheckedCreateInput>
  }

  /**
   * Department createMany
   */
  export type DepartmentCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Departments.
     */
    data: DepartmentCreateManyInput | DepartmentCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Department createManyAndReturn
   */
  export type DepartmentCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The data used to create many Departments.
     */
    data: DepartmentCreateManyInput | DepartmentCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Department update
   */
  export type DepartmentUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The data needed to update a Department.
     */
    data: XOR<DepartmentUpdateInput, DepartmentUncheckedUpdateInput>
    /**
     * Choose, which Department to update.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department updateMany
   */
  export type DepartmentUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Departments.
     */
    data: XOR<DepartmentUpdateManyMutationInput, DepartmentUncheckedUpdateManyInput>
    /**
     * Filter which Departments to update
     */
    where?: DepartmentWhereInput
  }

  /**
   * Department upsert
   */
  export type DepartmentUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The filter to search for the Department to update in case it exists.
     */
    where: DepartmentWhereUniqueInput
    /**
     * In case the Department found by the `where` argument doesn't exist, create a new Department with this data.
     */
    create: XOR<DepartmentCreateInput, DepartmentUncheckedCreateInput>
    /**
     * In case the Department was found with the provided `where` argument, update it with this data.
     */
    update: XOR<DepartmentUpdateInput, DepartmentUncheckedUpdateInput>
  }

  /**
   * Department delete
   */
  export type DepartmentDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter which Department to delete.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department deleteMany
   */
  export type DepartmentDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Departments to delete
     */
    where?: DepartmentWhereInput
  }

  /**
   * Department.users
   */
  export type Department$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationAndSearchRelevanceInput | UserDetailOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * Department.department_head
   */
  export type Department$department_headArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Department.created
   */
  export type Department$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Department.updated
   */
  export type Department$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Department.deleted
   */
  export type Department$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Department without action
   */
  export type DepartmentDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
  }


  /**
   * Model RequestLog
   */

  export type AggregateRequestLog = {
    _count: RequestLogCountAggregateOutputType | null
    _avg: RequestLogAvgAggregateOutputType | null
    _sum: RequestLogSumAggregateOutputType | null
    _min: RequestLogMinAggregateOutputType | null
    _max: RequestLogMaxAggregateOutputType | null
  }

  export type RequestLogAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    res_code: number | null
    status_id: number | null
    company_id: number | null
  }

  export type RequestLogSumAggregateOutputType = {
    id: bigint | null
    user_id: number | null
    res_code: number | null
    status_id: number | null
    company_id: number | null
  }

  export type RequestLogMinAggregateOutputType = {
    id: bigint | null
    uuid: string | null
    user_id: number | null
    req_method: string | null
    req_url: string | null
    req_body: string | null
    res_status: boolean | null
    res_code: number | null
    res_message: string | null
    req_response: string | null
    req_headers: string | null
    req_ip: string | null
    req_device: string | null
    status_id: number | null
    company_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type RequestLogMaxAggregateOutputType = {
    id: bigint | null
    uuid: string | null
    user_id: number | null
    req_method: string | null
    req_url: string | null
    req_body: string | null
    res_status: boolean | null
    res_code: number | null
    res_message: string | null
    req_response: string | null
    req_headers: string | null
    req_ip: string | null
    req_device: string | null
    status_id: number | null
    company_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type RequestLogCountAggregateOutputType = {
    id: number
    uuid: number
    user_id: number
    req_method: number
    req_url: number
    req_body: number
    res_status: number
    res_code: number
    res_message: number
    req_response: number
    req_headers: number
    req_ip: number
    req_device: number
    status_id: number
    company_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type RequestLogAvgAggregateInputType = {
    id?: true
    user_id?: true
    res_code?: true
    status_id?: true
    company_id?: true
  }

  export type RequestLogSumAggregateInputType = {
    id?: true
    user_id?: true
    res_code?: true
    status_id?: true
    company_id?: true
  }

  export type RequestLogMinAggregateInputType = {
    id?: true
    uuid?: true
    user_id?: true
    req_method?: true
    req_url?: true
    req_body?: true
    res_status?: true
    res_code?: true
    res_message?: true
    req_response?: true
    req_headers?: true
    req_ip?: true
    req_device?: true
    status_id?: true
    company_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type RequestLogMaxAggregateInputType = {
    id?: true
    uuid?: true
    user_id?: true
    req_method?: true
    req_url?: true
    req_body?: true
    res_status?: true
    res_code?: true
    res_message?: true
    req_response?: true
    req_headers?: true
    req_ip?: true
    req_device?: true
    status_id?: true
    company_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type RequestLogCountAggregateInputType = {
    id?: true
    uuid?: true
    user_id?: true
    req_method?: true
    req_url?: true
    req_body?: true
    res_status?: true
    res_code?: true
    res_message?: true
    req_response?: true
    req_headers?: true
    req_ip?: true
    req_device?: true
    status_id?: true
    company_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type RequestLogAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RequestLog to aggregate.
     */
    where?: RequestLogWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RequestLogs to fetch.
     */
    orderBy?: RequestLogOrderByWithRelationAndSearchRelevanceInput | RequestLogOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RequestLogWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RequestLogs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RequestLogs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned RequestLogs
    **/
    _count?: true | RequestLogCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RequestLogAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RequestLogSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RequestLogMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RequestLogMaxAggregateInputType
  }

  export type GetRequestLogAggregateType<T extends RequestLogAggregateArgs> = {
        [P in keyof T & keyof AggregateRequestLog]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRequestLog[P]>
      : GetScalarType<T[P], AggregateRequestLog[P]>
  }




  export type RequestLogGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RequestLogWhereInput
    orderBy?: RequestLogOrderByWithAggregationInput | RequestLogOrderByWithAggregationInput[]
    by: RequestLogScalarFieldEnum[] | RequestLogScalarFieldEnum
    having?: RequestLogScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RequestLogCountAggregateInputType | true
    _avg?: RequestLogAvgAggregateInputType
    _sum?: RequestLogSumAggregateInputType
    _min?: RequestLogMinAggregateInputType
    _max?: RequestLogMaxAggregateInputType
  }

  export type RequestLogGroupByOutputType = {
    id: bigint
    uuid: string
    user_id: number | null
    req_method: string | null
    req_url: string | null
    req_body: string | null
    res_status: boolean
    res_code: number
    res_message: string | null
    req_response: string | null
    req_headers: string | null
    req_ip: string | null
    req_device: string | null
    status_id: number
    company_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: RequestLogCountAggregateOutputType | null
    _avg: RequestLogAvgAggregateOutputType | null
    _sum: RequestLogSumAggregateOutputType | null
    _min: RequestLogMinAggregateOutputType | null
    _max: RequestLogMaxAggregateOutputType | null
  }

  type GetRequestLogGroupByPayload<T extends RequestLogGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RequestLogGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RequestLogGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RequestLogGroupByOutputType[P]>
            : GetScalarType<T[P], RequestLogGroupByOutputType[P]>
        }
      >
    >


  export type RequestLogSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    user_id?: boolean
    req_method?: boolean
    req_url?: boolean
    req_body?: boolean
    res_status?: boolean
    res_code?: boolean
    res_message?: boolean
    req_response?: boolean
    req_headers?: boolean
    req_ip?: boolean
    req_device?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    user?: boolean | RequestLog$userArgs<ExtArgs>
  }, ExtArgs["result"]["requestLog"]>

  export type RequestLogSelectScalar = {
    id?: boolean
    uuid?: boolean
    user_id?: boolean
    req_method?: boolean
    req_url?: boolean
    req_body?: boolean
    res_status?: boolean
    res_code?: boolean
    res_message?: boolean
    req_response?: boolean
    req_headers?: boolean
    req_ip?: boolean
    req_device?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }


  export type RequestLogInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    user?: boolean | RequestLog$userArgs<ExtArgs>
  }


  export type $RequestLogPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "RequestLog"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      user: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: bigint
      uuid: string
      user_id: number | null
      req_method: string | null
      req_url: string | null
      req_body: string | null
      res_status: boolean
      res_code: number
      res_message: string | null
      req_response: string | null
      req_headers: string | null
      req_ip: string | null
      req_device: string | null
      status_id: number
      company_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["requestLog"]>
    composites: {}
  }


  type RequestLogGetPayload<S extends boolean | null | undefined | RequestLogDefaultArgs> = $Result.GetResult<Prisma.$RequestLogPayload, S>

  type RequestLogCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<RequestLogFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: RequestLogCountAggregateInputType | true
    }

  export interface RequestLogDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['RequestLog'], meta: { name: 'RequestLog' } }
    /**
     * Find zero or one RequestLog that matches the filter.
     * @param {RequestLogFindUniqueArgs} args - Arguments to find a RequestLog
     * @example
     * // Get one RequestLog
     * const requestLog = await prisma.requestLog.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends RequestLogFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, RequestLogFindUniqueArgs<ExtArgs>>
    ): Prisma__RequestLogClient<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one RequestLog that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {RequestLogFindUniqueOrThrowArgs} args - Arguments to find a RequestLog
     * @example
     * // Get one RequestLog
     * const requestLog = await prisma.requestLog.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends RequestLogFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RequestLogFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__RequestLogClient<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first RequestLog that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RequestLogFindFirstArgs} args - Arguments to find a RequestLog
     * @example
     * // Get one RequestLog
     * const requestLog = await prisma.requestLog.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends RequestLogFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, RequestLogFindFirstArgs<ExtArgs>>
    ): Prisma__RequestLogClient<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first RequestLog that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RequestLogFindFirstOrThrowArgs} args - Arguments to find a RequestLog
     * @example
     * // Get one RequestLog
     * const requestLog = await prisma.requestLog.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends RequestLogFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RequestLogFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__RequestLogClient<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more RequestLogs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RequestLogFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all RequestLogs
     * const requestLogs = await prisma.requestLog.findMany()
     * 
     * // Get first 10 RequestLogs
     * const requestLogs = await prisma.requestLog.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const requestLogWithIdOnly = await prisma.requestLog.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends RequestLogFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RequestLogFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a RequestLog.
     * @param {RequestLogCreateArgs} args - Arguments to create a RequestLog.
     * @example
     * // Create one RequestLog
     * const RequestLog = await prisma.requestLog.create({
     *   data: {
     *     // ... data to create a RequestLog
     *   }
     * })
     * 
    **/
    create<T extends RequestLogCreateArgs<ExtArgs>>(
      args: SelectSubset<T, RequestLogCreateArgs<ExtArgs>>
    ): Prisma__RequestLogClient<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many RequestLogs.
     * @param {RequestLogCreateManyArgs} args - Arguments to create many RequestLogs.
     * @example
     * // Create many RequestLogs
     * const requestLog = await prisma.requestLog.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends RequestLogCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RequestLogCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many RequestLogs and returns the data saved in the database.
     * @param {RequestLogCreateManyAndReturnArgs} args - Arguments to create many RequestLogs.
     * @example
     * // Create many RequestLogs
     * const requestLog = await prisma.requestLog.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many RequestLogs and only return the `id`
     * const requestLogWithIdOnly = await prisma.requestLog.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends RequestLogCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, RequestLogCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a RequestLog.
     * @param {RequestLogDeleteArgs} args - Arguments to delete one RequestLog.
     * @example
     * // Delete one RequestLog
     * const RequestLog = await prisma.requestLog.delete({
     *   where: {
     *     // ... filter to delete one RequestLog
     *   }
     * })
     * 
    **/
    delete<T extends RequestLogDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, RequestLogDeleteArgs<ExtArgs>>
    ): Prisma__RequestLogClient<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one RequestLog.
     * @param {RequestLogUpdateArgs} args - Arguments to update one RequestLog.
     * @example
     * // Update one RequestLog
     * const requestLog = await prisma.requestLog.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends RequestLogUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, RequestLogUpdateArgs<ExtArgs>>
    ): Prisma__RequestLogClient<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more RequestLogs.
     * @param {RequestLogDeleteManyArgs} args - Arguments to filter RequestLogs to delete.
     * @example
     * // Delete a few RequestLogs
     * const { count } = await prisma.requestLog.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends RequestLogDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RequestLogDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more RequestLogs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RequestLogUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many RequestLogs
     * const requestLog = await prisma.requestLog.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends RequestLogUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, RequestLogUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one RequestLog.
     * @param {RequestLogUpsertArgs} args - Arguments to update or create a RequestLog.
     * @example
     * // Update or create a RequestLog
     * const requestLog = await prisma.requestLog.upsert({
     *   create: {
     *     // ... data to create a RequestLog
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the RequestLog we want to update
     *   }
     * })
    **/
    upsert<T extends RequestLogUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, RequestLogUpsertArgs<ExtArgs>>
    ): Prisma__RequestLogClient<$Result.GetResult<Prisma.$RequestLogPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of RequestLogs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RequestLogCountArgs} args - Arguments to filter RequestLogs to count.
     * @example
     * // Count the number of RequestLogs
     * const count = await prisma.requestLog.count({
     *   where: {
     *     // ... the filter for the RequestLogs we want to count
     *   }
     * })
    **/
    count<T extends RequestLogCountArgs>(
      args?: Subset<T, RequestLogCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RequestLogCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a RequestLog.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RequestLogAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RequestLogAggregateArgs>(args: Subset<T, RequestLogAggregateArgs>): Prisma.PrismaPromise<GetRequestLogAggregateType<T>>

    /**
     * Group by RequestLog.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RequestLogGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RequestLogGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RequestLogGroupByArgs['orderBy'] }
        : { orderBy?: RequestLogGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RequestLogGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRequestLogGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the RequestLog model
   */
  readonly fields: RequestLogFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for RequestLog.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RequestLogClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    user<T extends RequestLog$userArgs<ExtArgs> = {}>(args?: Subset<T, RequestLog$userArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the RequestLog model
   */ 
  interface RequestLogFieldRefs {
    readonly id: FieldRef<"RequestLog", 'BigInt'>
    readonly uuid: FieldRef<"RequestLog", 'String'>
    readonly user_id: FieldRef<"RequestLog", 'Int'>
    readonly req_method: FieldRef<"RequestLog", 'String'>
    readonly req_url: FieldRef<"RequestLog", 'String'>
    readonly req_body: FieldRef<"RequestLog", 'String'>
    readonly res_status: FieldRef<"RequestLog", 'Boolean'>
    readonly res_code: FieldRef<"RequestLog", 'Int'>
    readonly res_message: FieldRef<"RequestLog", 'String'>
    readonly req_response: FieldRef<"RequestLog", 'String'>
    readonly req_headers: FieldRef<"RequestLog", 'String'>
    readonly req_ip: FieldRef<"RequestLog", 'String'>
    readonly req_device: FieldRef<"RequestLog", 'String'>
    readonly status_id: FieldRef<"RequestLog", 'Int'>
    readonly company_id: FieldRef<"RequestLog", 'Int'>
    readonly created_at: FieldRef<"RequestLog", 'DateTime'>
    readonly updated_at: FieldRef<"RequestLog", 'DateTime'>
    readonly deleted_at: FieldRef<"RequestLog", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * RequestLog findUnique
   */
  export type RequestLogFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * Filter, which RequestLog to fetch.
     */
    where: RequestLogWhereUniqueInput
  }

  /**
   * RequestLog findUniqueOrThrow
   */
  export type RequestLogFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * Filter, which RequestLog to fetch.
     */
    where: RequestLogWhereUniqueInput
  }

  /**
   * RequestLog findFirst
   */
  export type RequestLogFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * Filter, which RequestLog to fetch.
     */
    where?: RequestLogWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RequestLogs to fetch.
     */
    orderBy?: RequestLogOrderByWithRelationAndSearchRelevanceInput | RequestLogOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RequestLogs.
     */
    cursor?: RequestLogWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RequestLogs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RequestLogs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RequestLogs.
     */
    distinct?: RequestLogScalarFieldEnum | RequestLogScalarFieldEnum[]
  }

  /**
   * RequestLog findFirstOrThrow
   */
  export type RequestLogFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * Filter, which RequestLog to fetch.
     */
    where?: RequestLogWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RequestLogs to fetch.
     */
    orderBy?: RequestLogOrderByWithRelationAndSearchRelevanceInput | RequestLogOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RequestLogs.
     */
    cursor?: RequestLogWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RequestLogs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RequestLogs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RequestLogs.
     */
    distinct?: RequestLogScalarFieldEnum | RequestLogScalarFieldEnum[]
  }

  /**
   * RequestLog findMany
   */
  export type RequestLogFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * Filter, which RequestLogs to fetch.
     */
    where?: RequestLogWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RequestLogs to fetch.
     */
    orderBy?: RequestLogOrderByWithRelationAndSearchRelevanceInput | RequestLogOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing RequestLogs.
     */
    cursor?: RequestLogWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RequestLogs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RequestLogs.
     */
    skip?: number
    distinct?: RequestLogScalarFieldEnum | RequestLogScalarFieldEnum[]
  }

  /**
   * RequestLog create
   */
  export type RequestLogCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * The data needed to create a RequestLog.
     */
    data: XOR<RequestLogCreateInput, RequestLogUncheckedCreateInput>
  }

  /**
   * RequestLog createMany
   */
  export type RequestLogCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many RequestLogs.
     */
    data: RequestLogCreateManyInput | RequestLogCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * RequestLog createManyAndReturn
   */
  export type RequestLogCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * The data used to create many RequestLogs.
     */
    data: RequestLogCreateManyInput | RequestLogCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * RequestLog update
   */
  export type RequestLogUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * The data needed to update a RequestLog.
     */
    data: XOR<RequestLogUpdateInput, RequestLogUncheckedUpdateInput>
    /**
     * Choose, which RequestLog to update.
     */
    where: RequestLogWhereUniqueInput
  }

  /**
   * RequestLog updateMany
   */
  export type RequestLogUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update RequestLogs.
     */
    data: XOR<RequestLogUpdateManyMutationInput, RequestLogUncheckedUpdateManyInput>
    /**
     * Filter which RequestLogs to update
     */
    where?: RequestLogWhereInput
  }

  /**
   * RequestLog upsert
   */
  export type RequestLogUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * The filter to search for the RequestLog to update in case it exists.
     */
    where: RequestLogWhereUniqueInput
    /**
     * In case the RequestLog found by the `where` argument doesn't exist, create a new RequestLog with this data.
     */
    create: XOR<RequestLogCreateInput, RequestLogUncheckedCreateInput>
    /**
     * In case the RequestLog was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RequestLogUpdateInput, RequestLogUncheckedUpdateInput>
  }

  /**
   * RequestLog delete
   */
  export type RequestLogDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
    /**
     * Filter which RequestLog to delete.
     */
    where: RequestLogWhereUniqueInput
  }

  /**
   * RequestLog deleteMany
   */
  export type RequestLogDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RequestLogs to delete
     */
    where?: RequestLogWhereInput
  }

  /**
   * RequestLog.user
   */
  export type RequestLog$userArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * RequestLog without action
   */
  export type RequestLogDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RequestLog
     */
    select?: RequestLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RequestLogInclude<ExtArgs> | null
  }


  /**
   * Model FinancialYear
   */

  export type AggregateFinancialYear = {
    _count: FinancialYearCountAggregateOutputType | null
    _avg: FinancialYearAvgAggregateOutputType | null
    _sum: FinancialYearSumAggregateOutputType | null
    _min: FinancialYearMinAggregateOutputType | null
    _max: FinancialYearMaxAggregateOutputType | null
  }

  export type FinancialYearAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type FinancialYearSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type FinancialYearMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    code: string | null
    is_freezed: boolean | null
    start_date: Date | null
    end_date: Date | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type FinancialYearMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    code: string | null
    is_freezed: boolean | null
    start_date: Date | null
    end_date: Date | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type FinancialYearCountAggregateOutputType = {
    id: number
    uuid: number
    name: number
    code: number
    is_freezed: number
    start_date: number
    end_date: number
    status_id: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type FinancialYearAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type FinancialYearSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type FinancialYearMinAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    code?: true
    is_freezed?: true
    start_date?: true
    end_date?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type FinancialYearMaxAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    code?: true
    is_freezed?: true
    start_date?: true
    end_date?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type FinancialYearCountAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    code?: true
    is_freezed?: true
    start_date?: true
    end_date?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type FinancialYearAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which FinancialYear to aggregate.
     */
    where?: FinancialYearWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FinancialYears to fetch.
     */
    orderBy?: FinancialYearOrderByWithRelationAndSearchRelevanceInput | FinancialYearOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: FinancialYearWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FinancialYears from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FinancialYears.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned FinancialYears
    **/
    _count?: true | FinancialYearCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: FinancialYearAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: FinancialYearSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: FinancialYearMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: FinancialYearMaxAggregateInputType
  }

  export type GetFinancialYearAggregateType<T extends FinancialYearAggregateArgs> = {
        [P in keyof T & keyof AggregateFinancialYear]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateFinancialYear[P]>
      : GetScalarType<T[P], AggregateFinancialYear[P]>
  }




  export type FinancialYearGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FinancialYearWhereInput
    orderBy?: FinancialYearOrderByWithAggregationInput | FinancialYearOrderByWithAggregationInput[]
    by: FinancialYearScalarFieldEnum[] | FinancialYearScalarFieldEnum
    having?: FinancialYearScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: FinancialYearCountAggregateInputType | true
    _avg?: FinancialYearAvgAggregateInputType
    _sum?: FinancialYearSumAggregateInputType
    _min?: FinancialYearMinAggregateInputType
    _max?: FinancialYearMaxAggregateInputType
  }

  export type FinancialYearGroupByOutputType = {
    id: number
    uuid: string
    name: string
    code: string
    is_freezed: boolean
    start_date: Date
    end_date: Date
    status_id: number
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: FinancialYearCountAggregateOutputType | null
    _avg: FinancialYearAvgAggregateOutputType | null
    _sum: FinancialYearSumAggregateOutputType | null
    _min: FinancialYearMinAggregateOutputType | null
    _max: FinancialYearMaxAggregateOutputType | null
  }

  type GetFinancialYearGroupByPayload<T extends FinancialYearGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<FinancialYearGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof FinancialYearGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], FinancialYearGroupByOutputType[P]>
            : GetScalarType<T[P], FinancialYearGroupByOutputType[P]>
        }
      >
    >


  export type FinancialYearSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    name?: boolean
    code?: boolean
    is_freezed?: boolean
    start_date?: boolean
    end_date?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    document_sequence?: boolean | FinancialYear$document_sequenceArgs<ExtArgs>
    created?: boolean | FinancialYear$createdArgs<ExtArgs>
    updated?: boolean | FinancialYear$updatedArgs<ExtArgs>
    deleted?: boolean | FinancialYear$deletedArgs<ExtArgs>
    _count?: boolean | FinancialYearCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["financialYear"]>

  export type FinancialYearSelectScalar = {
    id?: boolean
    uuid?: boolean
    name?: boolean
    code?: boolean
    is_freezed?: boolean
    start_date?: boolean
    end_date?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }


  export type FinancialYearInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    document_sequence?: boolean | FinancialYear$document_sequenceArgs<ExtArgs>
    created?: boolean | FinancialYear$createdArgs<ExtArgs>
    updated?: boolean | FinancialYear$updatedArgs<ExtArgs>
    deleted?: boolean | FinancialYear$deletedArgs<ExtArgs>
    _count?: boolean | FinancialYearCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $FinancialYearPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "FinancialYear"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      document_sequence: Prisma.$DocumentSequencePayload<ExtArgs>[]
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      name: string
      code: string
      is_freezed: boolean
      start_date: Date
      end_date: Date
      status_id: number
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["financialYear"]>
    composites: {}
  }


  type FinancialYearGetPayload<S extends boolean | null | undefined | FinancialYearDefaultArgs> = $Result.GetResult<Prisma.$FinancialYearPayload, S>

  type FinancialYearCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<FinancialYearFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: FinancialYearCountAggregateInputType | true
    }

  export interface FinancialYearDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['FinancialYear'], meta: { name: 'FinancialYear' } }
    /**
     * Find zero or one FinancialYear that matches the filter.
     * @param {FinancialYearFindUniqueArgs} args - Arguments to find a FinancialYear
     * @example
     * // Get one FinancialYear
     * const financialYear = await prisma.financialYear.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends FinancialYearFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, FinancialYearFindUniqueArgs<ExtArgs>>
    ): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one FinancialYear that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {FinancialYearFindUniqueOrThrowArgs} args - Arguments to find a FinancialYear
     * @example
     * // Get one FinancialYear
     * const financialYear = await prisma.financialYear.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends FinancialYearFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, FinancialYearFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first FinancialYear that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FinancialYearFindFirstArgs} args - Arguments to find a FinancialYear
     * @example
     * // Get one FinancialYear
     * const financialYear = await prisma.financialYear.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends FinancialYearFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, FinancialYearFindFirstArgs<ExtArgs>>
    ): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first FinancialYear that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FinancialYearFindFirstOrThrowArgs} args - Arguments to find a FinancialYear
     * @example
     * // Get one FinancialYear
     * const financialYear = await prisma.financialYear.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends FinancialYearFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, FinancialYearFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more FinancialYears that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FinancialYearFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all FinancialYears
     * const financialYears = await prisma.financialYear.findMany()
     * 
     * // Get first 10 FinancialYears
     * const financialYears = await prisma.financialYear.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const financialYearWithIdOnly = await prisma.financialYear.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends FinancialYearFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, FinancialYearFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a FinancialYear.
     * @param {FinancialYearCreateArgs} args - Arguments to create a FinancialYear.
     * @example
     * // Create one FinancialYear
     * const FinancialYear = await prisma.financialYear.create({
     *   data: {
     *     // ... data to create a FinancialYear
     *   }
     * })
     * 
    **/
    create<T extends FinancialYearCreateArgs<ExtArgs>>(
      args: SelectSubset<T, FinancialYearCreateArgs<ExtArgs>>
    ): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many FinancialYears.
     * @param {FinancialYearCreateManyArgs} args - Arguments to create many FinancialYears.
     * @example
     * // Create many FinancialYears
     * const financialYear = await prisma.financialYear.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends FinancialYearCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, FinancialYearCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many FinancialYears and returns the data saved in the database.
     * @param {FinancialYearCreateManyAndReturnArgs} args - Arguments to create many FinancialYears.
     * @example
     * // Create many FinancialYears
     * const financialYear = await prisma.financialYear.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many FinancialYears and only return the `id`
     * const financialYearWithIdOnly = await prisma.financialYear.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends FinancialYearCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, FinancialYearCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a FinancialYear.
     * @param {FinancialYearDeleteArgs} args - Arguments to delete one FinancialYear.
     * @example
     * // Delete one FinancialYear
     * const FinancialYear = await prisma.financialYear.delete({
     *   where: {
     *     // ... filter to delete one FinancialYear
     *   }
     * })
     * 
    **/
    delete<T extends FinancialYearDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, FinancialYearDeleteArgs<ExtArgs>>
    ): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one FinancialYear.
     * @param {FinancialYearUpdateArgs} args - Arguments to update one FinancialYear.
     * @example
     * // Update one FinancialYear
     * const financialYear = await prisma.financialYear.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends FinancialYearUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, FinancialYearUpdateArgs<ExtArgs>>
    ): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more FinancialYears.
     * @param {FinancialYearDeleteManyArgs} args - Arguments to filter FinancialYears to delete.
     * @example
     * // Delete a few FinancialYears
     * const { count } = await prisma.financialYear.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends FinancialYearDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, FinancialYearDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more FinancialYears.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FinancialYearUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many FinancialYears
     * const financialYear = await prisma.financialYear.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends FinancialYearUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, FinancialYearUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one FinancialYear.
     * @param {FinancialYearUpsertArgs} args - Arguments to update or create a FinancialYear.
     * @example
     * // Update or create a FinancialYear
     * const financialYear = await prisma.financialYear.upsert({
     *   create: {
     *     // ... data to create a FinancialYear
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the FinancialYear we want to update
     *   }
     * })
    **/
    upsert<T extends FinancialYearUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, FinancialYearUpsertArgs<ExtArgs>>
    ): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of FinancialYears.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FinancialYearCountArgs} args - Arguments to filter FinancialYears to count.
     * @example
     * // Count the number of FinancialYears
     * const count = await prisma.financialYear.count({
     *   where: {
     *     // ... the filter for the FinancialYears we want to count
     *   }
     * })
    **/
    count<T extends FinancialYearCountArgs>(
      args?: Subset<T, FinancialYearCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], FinancialYearCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a FinancialYear.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FinancialYearAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends FinancialYearAggregateArgs>(args: Subset<T, FinancialYearAggregateArgs>): Prisma.PrismaPromise<GetFinancialYearAggregateType<T>>

    /**
     * Group by FinancialYear.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FinancialYearGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends FinancialYearGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: FinancialYearGroupByArgs['orderBy'] }
        : { orderBy?: FinancialYearGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, FinancialYearGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetFinancialYearGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the FinancialYear model
   */
  readonly fields: FinancialYearFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for FinancialYear.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__FinancialYearClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    document_sequence<T extends FinancialYear$document_sequenceArgs<ExtArgs> = {}>(args?: Subset<T, FinancialYear$document_sequenceArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findMany'> | Null>;

    created<T extends FinancialYear$createdArgs<ExtArgs> = {}>(args?: Subset<T, FinancialYear$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends FinancialYear$updatedArgs<ExtArgs> = {}>(args?: Subset<T, FinancialYear$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends FinancialYear$deletedArgs<ExtArgs> = {}>(args?: Subset<T, FinancialYear$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the FinancialYear model
   */ 
  interface FinancialYearFieldRefs {
    readonly id: FieldRef<"FinancialYear", 'Int'>
    readonly uuid: FieldRef<"FinancialYear", 'String'>
    readonly name: FieldRef<"FinancialYear", 'String'>
    readonly code: FieldRef<"FinancialYear", 'String'>
    readonly is_freezed: FieldRef<"FinancialYear", 'Boolean'>
    readonly start_date: FieldRef<"FinancialYear", 'DateTime'>
    readonly end_date: FieldRef<"FinancialYear", 'DateTime'>
    readonly status_id: FieldRef<"FinancialYear", 'Int'>
    readonly company_id: FieldRef<"FinancialYear", 'Int'>
    readonly created_by: FieldRef<"FinancialYear", 'Int'>
    readonly updated_by: FieldRef<"FinancialYear", 'Int'>
    readonly deleted_by: FieldRef<"FinancialYear", 'Int'>
    readonly created_at: FieldRef<"FinancialYear", 'DateTime'>
    readonly updated_at: FieldRef<"FinancialYear", 'DateTime'>
    readonly deleted_at: FieldRef<"FinancialYear", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * FinancialYear findUnique
   */
  export type FinancialYearFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * Filter, which FinancialYear to fetch.
     */
    where: FinancialYearWhereUniqueInput
  }

  /**
   * FinancialYear findUniqueOrThrow
   */
  export type FinancialYearFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * Filter, which FinancialYear to fetch.
     */
    where: FinancialYearWhereUniqueInput
  }

  /**
   * FinancialYear findFirst
   */
  export type FinancialYearFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * Filter, which FinancialYear to fetch.
     */
    where?: FinancialYearWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FinancialYears to fetch.
     */
    orderBy?: FinancialYearOrderByWithRelationAndSearchRelevanceInput | FinancialYearOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for FinancialYears.
     */
    cursor?: FinancialYearWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FinancialYears from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FinancialYears.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of FinancialYears.
     */
    distinct?: FinancialYearScalarFieldEnum | FinancialYearScalarFieldEnum[]
  }

  /**
   * FinancialYear findFirstOrThrow
   */
  export type FinancialYearFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * Filter, which FinancialYear to fetch.
     */
    where?: FinancialYearWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FinancialYears to fetch.
     */
    orderBy?: FinancialYearOrderByWithRelationAndSearchRelevanceInput | FinancialYearOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for FinancialYears.
     */
    cursor?: FinancialYearWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FinancialYears from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FinancialYears.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of FinancialYears.
     */
    distinct?: FinancialYearScalarFieldEnum | FinancialYearScalarFieldEnum[]
  }

  /**
   * FinancialYear findMany
   */
  export type FinancialYearFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * Filter, which FinancialYears to fetch.
     */
    where?: FinancialYearWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FinancialYears to fetch.
     */
    orderBy?: FinancialYearOrderByWithRelationAndSearchRelevanceInput | FinancialYearOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing FinancialYears.
     */
    cursor?: FinancialYearWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FinancialYears from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FinancialYears.
     */
    skip?: number
    distinct?: FinancialYearScalarFieldEnum | FinancialYearScalarFieldEnum[]
  }

  /**
   * FinancialYear create
   */
  export type FinancialYearCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * The data needed to create a FinancialYear.
     */
    data: XOR<FinancialYearCreateInput, FinancialYearUncheckedCreateInput>
  }

  /**
   * FinancialYear createMany
   */
  export type FinancialYearCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many FinancialYears.
     */
    data: FinancialYearCreateManyInput | FinancialYearCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * FinancialYear createManyAndReturn
   */
  export type FinancialYearCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * The data used to create many FinancialYears.
     */
    data: FinancialYearCreateManyInput | FinancialYearCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * FinancialYear update
   */
  export type FinancialYearUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * The data needed to update a FinancialYear.
     */
    data: XOR<FinancialYearUpdateInput, FinancialYearUncheckedUpdateInput>
    /**
     * Choose, which FinancialYear to update.
     */
    where: FinancialYearWhereUniqueInput
  }

  /**
   * FinancialYear updateMany
   */
  export type FinancialYearUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update FinancialYears.
     */
    data: XOR<FinancialYearUpdateManyMutationInput, FinancialYearUncheckedUpdateManyInput>
    /**
     * Filter which FinancialYears to update
     */
    where?: FinancialYearWhereInput
  }

  /**
   * FinancialYear upsert
   */
  export type FinancialYearUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * The filter to search for the FinancialYear to update in case it exists.
     */
    where: FinancialYearWhereUniqueInput
    /**
     * In case the FinancialYear found by the `where` argument doesn't exist, create a new FinancialYear with this data.
     */
    create: XOR<FinancialYearCreateInput, FinancialYearUncheckedCreateInput>
    /**
     * In case the FinancialYear was found with the provided `where` argument, update it with this data.
     */
    update: XOR<FinancialYearUpdateInput, FinancialYearUncheckedUpdateInput>
  }

  /**
   * FinancialYear delete
   */
  export type FinancialYearDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    /**
     * Filter which FinancialYear to delete.
     */
    where: FinancialYearWhereUniqueInput
  }

  /**
   * FinancialYear deleteMany
   */
  export type FinancialYearDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which FinancialYears to delete
     */
    where?: FinancialYearWhereInput
  }

  /**
   * FinancialYear.document_sequence
   */
  export type FinancialYear$document_sequenceArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    where?: DocumentSequenceWhereInput
    orderBy?: DocumentSequenceOrderByWithRelationAndSearchRelevanceInput | DocumentSequenceOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: DocumentSequenceWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DocumentSequenceScalarFieldEnum | DocumentSequenceScalarFieldEnum[]
  }

  /**
   * FinancialYear.created
   */
  export type FinancialYear$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * FinancialYear.updated
   */
  export type FinancialYear$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * FinancialYear.deleted
   */
  export type FinancialYear$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * FinancialYear without action
   */
  export type FinancialYearDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
  }


  /**
   * Model DocumentSequence
   */

  export type AggregateDocumentSequence = {
    _count: DocumentSequenceCountAggregateOutputType | null
    _avg: DocumentSequenceAvgAggregateOutputType | null
    _sum: DocumentSequenceSumAggregateOutputType | null
    _min: DocumentSequenceMinAggregateOutputType | null
    _max: DocumentSequenceMaxAggregateOutputType | null
  }

  export type DocumentSequenceAvgAggregateOutputType = {
    id: number | null
    financial_year_id: number | null
    current_sequence_no: number | null
    start_sequence_no: number | null
    end_sequence_no: number | null
    sequence_length: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type DocumentSequenceSumAggregateOutputType = {
    id: number | null
    financial_year_id: number | null
    current_sequence_no: number | null
    start_sequence_no: number | null
    end_sequence_no: number | null
    sequence_length: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type DocumentSequenceMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    module_name: string | null
    financial_year_id: number | null
    current_sequence_no: number | null
    start_sequence_no: number | null
    end_sequence_no: number | null
    sequence_length: number | null
    status_id: number | null
    code_format: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type DocumentSequenceMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    module_name: string | null
    financial_year_id: number | null
    current_sequence_no: number | null
    start_sequence_no: number | null
    end_sequence_no: number | null
    sequence_length: number | null
    status_id: number | null
    code_format: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type DocumentSequenceCountAggregateOutputType = {
    id: number
    uuid: number
    module_name: number
    financial_year_id: number
    current_sequence_no: number
    start_sequence_no: number
    end_sequence_no: number
    sequence_length: number
    status_id: number
    code_format: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type DocumentSequenceAvgAggregateInputType = {
    id?: true
    financial_year_id?: true
    current_sequence_no?: true
    start_sequence_no?: true
    end_sequence_no?: true
    sequence_length?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type DocumentSequenceSumAggregateInputType = {
    id?: true
    financial_year_id?: true
    current_sequence_no?: true
    start_sequence_no?: true
    end_sequence_no?: true
    sequence_length?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type DocumentSequenceMinAggregateInputType = {
    id?: true
    uuid?: true
    module_name?: true
    financial_year_id?: true
    current_sequence_no?: true
    start_sequence_no?: true
    end_sequence_no?: true
    sequence_length?: true
    status_id?: true
    code_format?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type DocumentSequenceMaxAggregateInputType = {
    id?: true
    uuid?: true
    module_name?: true
    financial_year_id?: true
    current_sequence_no?: true
    start_sequence_no?: true
    end_sequence_no?: true
    sequence_length?: true
    status_id?: true
    code_format?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type DocumentSequenceCountAggregateInputType = {
    id?: true
    uuid?: true
    module_name?: true
    financial_year_id?: true
    current_sequence_no?: true
    start_sequence_no?: true
    end_sequence_no?: true
    sequence_length?: true
    status_id?: true
    code_format?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type DocumentSequenceAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which DocumentSequence to aggregate.
     */
    where?: DocumentSequenceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of DocumentSequences to fetch.
     */
    orderBy?: DocumentSequenceOrderByWithRelationAndSearchRelevanceInput | DocumentSequenceOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: DocumentSequenceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` DocumentSequences from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` DocumentSequences.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned DocumentSequences
    **/
    _count?: true | DocumentSequenceCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: DocumentSequenceAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: DocumentSequenceSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: DocumentSequenceMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: DocumentSequenceMaxAggregateInputType
  }

  export type GetDocumentSequenceAggregateType<T extends DocumentSequenceAggregateArgs> = {
        [P in keyof T & keyof AggregateDocumentSequence]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDocumentSequence[P]>
      : GetScalarType<T[P], AggregateDocumentSequence[P]>
  }




  export type DocumentSequenceGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentSequenceWhereInput
    orderBy?: DocumentSequenceOrderByWithAggregationInput | DocumentSequenceOrderByWithAggregationInput[]
    by: DocumentSequenceScalarFieldEnum[] | DocumentSequenceScalarFieldEnum
    having?: DocumentSequenceScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: DocumentSequenceCountAggregateInputType | true
    _avg?: DocumentSequenceAvgAggregateInputType
    _sum?: DocumentSequenceSumAggregateInputType
    _min?: DocumentSequenceMinAggregateInputType
    _max?: DocumentSequenceMaxAggregateInputType
  }

  export type DocumentSequenceGroupByOutputType = {
    id: number
    uuid: string
    module_name: string
    financial_year_id: number | null
    current_sequence_no: number
    start_sequence_no: number
    end_sequence_no: number
    sequence_length: number
    status_id: number
    code_format: string | null
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: DocumentSequenceCountAggregateOutputType | null
    _avg: DocumentSequenceAvgAggregateOutputType | null
    _sum: DocumentSequenceSumAggregateOutputType | null
    _min: DocumentSequenceMinAggregateOutputType | null
    _max: DocumentSequenceMaxAggregateOutputType | null
  }

  type GetDocumentSequenceGroupByPayload<T extends DocumentSequenceGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<DocumentSequenceGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof DocumentSequenceGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], DocumentSequenceGroupByOutputType[P]>
            : GetScalarType<T[P], DocumentSequenceGroupByOutputType[P]>
        }
      >
    >


  export type DocumentSequenceSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    module_name?: boolean
    financial_year_id?: boolean
    current_sequence_no?: boolean
    start_sequence_no?: boolean
    end_sequence_no?: boolean
    sequence_length?: boolean
    status_id?: boolean
    code_format?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    finanicial_year?: boolean | DocumentSequence$finanicial_yearArgs<ExtArgs>
    created?: boolean | DocumentSequence$createdArgs<ExtArgs>
    updated?: boolean | DocumentSequence$updatedArgs<ExtArgs>
    deleted?: boolean | DocumentSequence$deletedArgs<ExtArgs>
  }, ExtArgs["result"]["documentSequence"]>

  export type DocumentSequenceSelectScalar = {
    id?: boolean
    uuid?: boolean
    module_name?: boolean
    financial_year_id?: boolean
    current_sequence_no?: boolean
    start_sequence_no?: boolean
    end_sequence_no?: boolean
    sequence_length?: boolean
    status_id?: boolean
    code_format?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }


  export type DocumentSequenceInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    finanicial_year?: boolean | DocumentSequence$finanicial_yearArgs<ExtArgs>
    created?: boolean | DocumentSequence$createdArgs<ExtArgs>
    updated?: boolean | DocumentSequence$updatedArgs<ExtArgs>
    deleted?: boolean | DocumentSequence$deletedArgs<ExtArgs>
  }


  export type $DocumentSequencePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "DocumentSequence"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      finanicial_year: Prisma.$FinancialYearPayload<ExtArgs> | null
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      module_name: string
      financial_year_id: number | null
      current_sequence_no: number
      start_sequence_no: number
      end_sequence_no: number
      sequence_length: number
      status_id: number
      code_format: string | null
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["documentSequence"]>
    composites: {}
  }


  type DocumentSequenceGetPayload<S extends boolean | null | undefined | DocumentSequenceDefaultArgs> = $Result.GetResult<Prisma.$DocumentSequencePayload, S>

  type DocumentSequenceCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<DocumentSequenceFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: DocumentSequenceCountAggregateInputType | true
    }

  export interface DocumentSequenceDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['DocumentSequence'], meta: { name: 'DocumentSequence' } }
    /**
     * Find zero or one DocumentSequence that matches the filter.
     * @param {DocumentSequenceFindUniqueArgs} args - Arguments to find a DocumentSequence
     * @example
     * // Get one DocumentSequence
     * const documentSequence = await prisma.documentSequence.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends DocumentSequenceFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, DocumentSequenceFindUniqueArgs<ExtArgs>>
    ): Prisma__DocumentSequenceClient<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one DocumentSequence that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {DocumentSequenceFindUniqueOrThrowArgs} args - Arguments to find a DocumentSequence
     * @example
     * // Get one DocumentSequence
     * const documentSequence = await prisma.documentSequence.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends DocumentSequenceFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DocumentSequenceFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__DocumentSequenceClient<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first DocumentSequence that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentSequenceFindFirstArgs} args - Arguments to find a DocumentSequence
     * @example
     * // Get one DocumentSequence
     * const documentSequence = await prisma.documentSequence.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends DocumentSequenceFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, DocumentSequenceFindFirstArgs<ExtArgs>>
    ): Prisma__DocumentSequenceClient<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first DocumentSequence that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentSequenceFindFirstOrThrowArgs} args - Arguments to find a DocumentSequence
     * @example
     * // Get one DocumentSequence
     * const documentSequence = await prisma.documentSequence.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends DocumentSequenceFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DocumentSequenceFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__DocumentSequenceClient<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more DocumentSequences that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentSequenceFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all DocumentSequences
     * const documentSequences = await prisma.documentSequence.findMany()
     * 
     * // Get first 10 DocumentSequences
     * const documentSequences = await prisma.documentSequence.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const documentSequenceWithIdOnly = await prisma.documentSequence.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends DocumentSequenceFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DocumentSequenceFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a DocumentSequence.
     * @param {DocumentSequenceCreateArgs} args - Arguments to create a DocumentSequence.
     * @example
     * // Create one DocumentSequence
     * const DocumentSequence = await prisma.documentSequence.create({
     *   data: {
     *     // ... data to create a DocumentSequence
     *   }
     * })
     * 
    **/
    create<T extends DocumentSequenceCreateArgs<ExtArgs>>(
      args: SelectSubset<T, DocumentSequenceCreateArgs<ExtArgs>>
    ): Prisma__DocumentSequenceClient<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many DocumentSequences.
     * @param {DocumentSequenceCreateManyArgs} args - Arguments to create many DocumentSequences.
     * @example
     * // Create many DocumentSequences
     * const documentSequence = await prisma.documentSequence.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends DocumentSequenceCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DocumentSequenceCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many DocumentSequences and returns the data saved in the database.
     * @param {DocumentSequenceCreateManyAndReturnArgs} args - Arguments to create many DocumentSequences.
     * @example
     * // Create many DocumentSequences
     * const documentSequence = await prisma.documentSequence.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many DocumentSequences and only return the `id`
     * const documentSequenceWithIdOnly = await prisma.documentSequence.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends DocumentSequenceCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, DocumentSequenceCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a DocumentSequence.
     * @param {DocumentSequenceDeleteArgs} args - Arguments to delete one DocumentSequence.
     * @example
     * // Delete one DocumentSequence
     * const DocumentSequence = await prisma.documentSequence.delete({
     *   where: {
     *     // ... filter to delete one DocumentSequence
     *   }
     * })
     * 
    **/
    delete<T extends DocumentSequenceDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, DocumentSequenceDeleteArgs<ExtArgs>>
    ): Prisma__DocumentSequenceClient<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one DocumentSequence.
     * @param {DocumentSequenceUpdateArgs} args - Arguments to update one DocumentSequence.
     * @example
     * // Update one DocumentSequence
     * const documentSequence = await prisma.documentSequence.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends DocumentSequenceUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, DocumentSequenceUpdateArgs<ExtArgs>>
    ): Prisma__DocumentSequenceClient<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more DocumentSequences.
     * @param {DocumentSequenceDeleteManyArgs} args - Arguments to filter DocumentSequences to delete.
     * @example
     * // Delete a few DocumentSequences
     * const { count } = await prisma.documentSequence.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends DocumentSequenceDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DocumentSequenceDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more DocumentSequences.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentSequenceUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many DocumentSequences
     * const documentSequence = await prisma.documentSequence.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends DocumentSequenceUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, DocumentSequenceUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one DocumentSequence.
     * @param {DocumentSequenceUpsertArgs} args - Arguments to update or create a DocumentSequence.
     * @example
     * // Update or create a DocumentSequence
     * const documentSequence = await prisma.documentSequence.upsert({
     *   create: {
     *     // ... data to create a DocumentSequence
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the DocumentSequence we want to update
     *   }
     * })
    **/
    upsert<T extends DocumentSequenceUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, DocumentSequenceUpsertArgs<ExtArgs>>
    ): Prisma__DocumentSequenceClient<$Result.GetResult<Prisma.$DocumentSequencePayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of DocumentSequences.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentSequenceCountArgs} args - Arguments to filter DocumentSequences to count.
     * @example
     * // Count the number of DocumentSequences
     * const count = await prisma.documentSequence.count({
     *   where: {
     *     // ... the filter for the DocumentSequences we want to count
     *   }
     * })
    **/
    count<T extends DocumentSequenceCountArgs>(
      args?: Subset<T, DocumentSequenceCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], DocumentSequenceCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a DocumentSequence.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentSequenceAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends DocumentSequenceAggregateArgs>(args: Subset<T, DocumentSequenceAggregateArgs>): Prisma.PrismaPromise<GetDocumentSequenceAggregateType<T>>

    /**
     * Group by DocumentSequence.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentSequenceGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends DocumentSequenceGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: DocumentSequenceGroupByArgs['orderBy'] }
        : { orderBy?: DocumentSequenceGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, DocumentSequenceGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDocumentSequenceGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the DocumentSequence model
   */
  readonly fields: DocumentSequenceFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for DocumentSequence.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__DocumentSequenceClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    finanicial_year<T extends DocumentSequence$finanicial_yearArgs<ExtArgs> = {}>(args?: Subset<T, DocumentSequence$finanicial_yearArgs<ExtArgs>>): Prisma__FinancialYearClient<$Result.GetResult<Prisma.$FinancialYearPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    created<T extends DocumentSequence$createdArgs<ExtArgs> = {}>(args?: Subset<T, DocumentSequence$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends DocumentSequence$updatedArgs<ExtArgs> = {}>(args?: Subset<T, DocumentSequence$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends DocumentSequence$deletedArgs<ExtArgs> = {}>(args?: Subset<T, DocumentSequence$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the DocumentSequence model
   */ 
  interface DocumentSequenceFieldRefs {
    readonly id: FieldRef<"DocumentSequence", 'Int'>
    readonly uuid: FieldRef<"DocumentSequence", 'String'>
    readonly module_name: FieldRef<"DocumentSequence", 'String'>
    readonly financial_year_id: FieldRef<"DocumentSequence", 'Int'>
    readonly current_sequence_no: FieldRef<"DocumentSequence", 'Int'>
    readonly start_sequence_no: FieldRef<"DocumentSequence", 'Int'>
    readonly end_sequence_no: FieldRef<"DocumentSequence", 'Int'>
    readonly sequence_length: FieldRef<"DocumentSequence", 'Int'>
    readonly status_id: FieldRef<"DocumentSequence", 'Int'>
    readonly code_format: FieldRef<"DocumentSequence", 'String'>
    readonly company_id: FieldRef<"DocumentSequence", 'Int'>
    readonly created_by: FieldRef<"DocumentSequence", 'Int'>
    readonly updated_by: FieldRef<"DocumentSequence", 'Int'>
    readonly deleted_by: FieldRef<"DocumentSequence", 'Int'>
    readonly created_at: FieldRef<"DocumentSequence", 'DateTime'>
    readonly updated_at: FieldRef<"DocumentSequence", 'DateTime'>
    readonly deleted_at: FieldRef<"DocumentSequence", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * DocumentSequence findUnique
   */
  export type DocumentSequenceFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * Filter, which DocumentSequence to fetch.
     */
    where: DocumentSequenceWhereUniqueInput
  }

  /**
   * DocumentSequence findUniqueOrThrow
   */
  export type DocumentSequenceFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * Filter, which DocumentSequence to fetch.
     */
    where: DocumentSequenceWhereUniqueInput
  }

  /**
   * DocumentSequence findFirst
   */
  export type DocumentSequenceFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * Filter, which DocumentSequence to fetch.
     */
    where?: DocumentSequenceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of DocumentSequences to fetch.
     */
    orderBy?: DocumentSequenceOrderByWithRelationAndSearchRelevanceInput | DocumentSequenceOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for DocumentSequences.
     */
    cursor?: DocumentSequenceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` DocumentSequences from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` DocumentSequences.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of DocumentSequences.
     */
    distinct?: DocumentSequenceScalarFieldEnum | DocumentSequenceScalarFieldEnum[]
  }

  /**
   * DocumentSequence findFirstOrThrow
   */
  export type DocumentSequenceFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * Filter, which DocumentSequence to fetch.
     */
    where?: DocumentSequenceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of DocumentSequences to fetch.
     */
    orderBy?: DocumentSequenceOrderByWithRelationAndSearchRelevanceInput | DocumentSequenceOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for DocumentSequences.
     */
    cursor?: DocumentSequenceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` DocumentSequences from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` DocumentSequences.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of DocumentSequences.
     */
    distinct?: DocumentSequenceScalarFieldEnum | DocumentSequenceScalarFieldEnum[]
  }

  /**
   * DocumentSequence findMany
   */
  export type DocumentSequenceFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * Filter, which DocumentSequences to fetch.
     */
    where?: DocumentSequenceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of DocumentSequences to fetch.
     */
    orderBy?: DocumentSequenceOrderByWithRelationAndSearchRelevanceInput | DocumentSequenceOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing DocumentSequences.
     */
    cursor?: DocumentSequenceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` DocumentSequences from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` DocumentSequences.
     */
    skip?: number
    distinct?: DocumentSequenceScalarFieldEnum | DocumentSequenceScalarFieldEnum[]
  }

  /**
   * DocumentSequence create
   */
  export type DocumentSequenceCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * The data needed to create a DocumentSequence.
     */
    data: XOR<DocumentSequenceCreateInput, DocumentSequenceUncheckedCreateInput>
  }

  /**
   * DocumentSequence createMany
   */
  export type DocumentSequenceCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many DocumentSequences.
     */
    data: DocumentSequenceCreateManyInput | DocumentSequenceCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * DocumentSequence createManyAndReturn
   */
  export type DocumentSequenceCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * The data used to create many DocumentSequences.
     */
    data: DocumentSequenceCreateManyInput | DocumentSequenceCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * DocumentSequence update
   */
  export type DocumentSequenceUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * The data needed to update a DocumentSequence.
     */
    data: XOR<DocumentSequenceUpdateInput, DocumentSequenceUncheckedUpdateInput>
    /**
     * Choose, which DocumentSequence to update.
     */
    where: DocumentSequenceWhereUniqueInput
  }

  /**
   * DocumentSequence updateMany
   */
  export type DocumentSequenceUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update DocumentSequences.
     */
    data: XOR<DocumentSequenceUpdateManyMutationInput, DocumentSequenceUncheckedUpdateManyInput>
    /**
     * Filter which DocumentSequences to update
     */
    where?: DocumentSequenceWhereInput
  }

  /**
   * DocumentSequence upsert
   */
  export type DocumentSequenceUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * The filter to search for the DocumentSequence to update in case it exists.
     */
    where: DocumentSequenceWhereUniqueInput
    /**
     * In case the DocumentSequence found by the `where` argument doesn't exist, create a new DocumentSequence with this data.
     */
    create: XOR<DocumentSequenceCreateInput, DocumentSequenceUncheckedCreateInput>
    /**
     * In case the DocumentSequence was found with the provided `where` argument, update it with this data.
     */
    update: XOR<DocumentSequenceUpdateInput, DocumentSequenceUncheckedUpdateInput>
  }

  /**
   * DocumentSequence delete
   */
  export type DocumentSequenceDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
    /**
     * Filter which DocumentSequence to delete.
     */
    where: DocumentSequenceWhereUniqueInput
  }

  /**
   * DocumentSequence deleteMany
   */
  export type DocumentSequenceDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which DocumentSequences to delete
     */
    where?: DocumentSequenceWhereInput
  }

  /**
   * DocumentSequence.finanicial_year
   */
  export type DocumentSequence$finanicial_yearArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FinancialYear
     */
    select?: FinancialYearSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FinancialYearInclude<ExtArgs> | null
    where?: FinancialYearWhereInput
  }

  /**
   * DocumentSequence.created
   */
  export type DocumentSequence$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * DocumentSequence.updated
   */
  export type DocumentSequence$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * DocumentSequence.deleted
   */
  export type DocumentSequence$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * DocumentSequence without action
   */
  export type DocumentSequenceDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentSequence
     */
    select?: DocumentSequenceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentSequenceInclude<ExtArgs> | null
  }


  /**
   * Model AuditLog
   */

  export type AggregateAuditLog = {
    _count: AuditLogCountAggregateOutputType | null
    _avg: AuditLogAvgAggregateOutputType | null
    _sum: AuditLogSumAggregateOutputType | null
    _min: AuditLogMinAggregateOutputType | null
    _max: AuditLogMaxAggregateOutputType | null
  }

  export type AuditLogAvgAggregateOutputType = {
    id: number | null
    entity_id: number | null
    user_id: number | null
    status_id: number | null
    company_id: number | null
  }

  export type AuditLogSumAggregateOutputType = {
    id: number | null
    entity_id: number | null
    user_id: number | null
    status_id: number | null
    company_id: number | null
  }

  export type AuditLogMinAggregateOutputType = {
    id: number | null
    operation_type: string | null
    table_name: string | null
    field_name: string | null
    old_value: string | null
    new_value: string | null
    entity_id: number | null
    user_id: number | null
    status_id: number | null
    company_id: number | null
    created_at: Date | null
  }

  export type AuditLogMaxAggregateOutputType = {
    id: number | null
    operation_type: string | null
    table_name: string | null
    field_name: string | null
    old_value: string | null
    new_value: string | null
    entity_id: number | null
    user_id: number | null
    status_id: number | null
    company_id: number | null
    created_at: Date | null
  }

  export type AuditLogCountAggregateOutputType = {
    id: number
    operation_type: number
    table_name: number
    field_name: number
    old_value: number
    new_value: number
    entity_id: number
    user_id: number
    status_id: number
    company_id: number
    created_at: number
    _all: number
  }


  export type AuditLogAvgAggregateInputType = {
    id?: true
    entity_id?: true
    user_id?: true
    status_id?: true
    company_id?: true
  }

  export type AuditLogSumAggregateInputType = {
    id?: true
    entity_id?: true
    user_id?: true
    status_id?: true
    company_id?: true
  }

  export type AuditLogMinAggregateInputType = {
    id?: true
    operation_type?: true
    table_name?: true
    field_name?: true
    old_value?: true
    new_value?: true
    entity_id?: true
    user_id?: true
    status_id?: true
    company_id?: true
    created_at?: true
  }

  export type AuditLogMaxAggregateInputType = {
    id?: true
    operation_type?: true
    table_name?: true
    field_name?: true
    old_value?: true
    new_value?: true
    entity_id?: true
    user_id?: true
    status_id?: true
    company_id?: true
    created_at?: true
  }

  export type AuditLogCountAggregateInputType = {
    id?: true
    operation_type?: true
    table_name?: true
    field_name?: true
    old_value?: true
    new_value?: true
    entity_id?: true
    user_id?: true
    status_id?: true
    company_id?: true
    created_at?: true
    _all?: true
  }

  export type AuditLogAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AuditLog to aggregate.
     */
    where?: AuditLogWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditLogs to fetch.
     */
    orderBy?: AuditLogOrderByWithRelationAndSearchRelevanceInput | AuditLogOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: AuditLogWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditLogs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditLogs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned AuditLogs
    **/
    _count?: true | AuditLogCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AuditLogAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AuditLogSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AuditLogMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AuditLogMaxAggregateInputType
  }

  export type GetAuditLogAggregateType<T extends AuditLogAggregateArgs> = {
        [P in keyof T & keyof AggregateAuditLog]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAuditLog[P]>
      : GetScalarType<T[P], AggregateAuditLog[P]>
  }




  export type AuditLogGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuditLogWhereInput
    orderBy?: AuditLogOrderByWithAggregationInput | AuditLogOrderByWithAggregationInput[]
    by: AuditLogScalarFieldEnum[] | AuditLogScalarFieldEnum
    having?: AuditLogScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AuditLogCountAggregateInputType | true
    _avg?: AuditLogAvgAggregateInputType
    _sum?: AuditLogSumAggregateInputType
    _min?: AuditLogMinAggregateInputType
    _max?: AuditLogMaxAggregateInputType
  }

  export type AuditLogGroupByOutputType = {
    id: number
    operation_type: string
    table_name: string
    field_name: string
    old_value: string | null
    new_value: string | null
    entity_id: number
    user_id: number | null
    status_id: number
    company_id: number | null
    created_at: Date
    _count: AuditLogCountAggregateOutputType | null
    _avg: AuditLogAvgAggregateOutputType | null
    _sum: AuditLogSumAggregateOutputType | null
    _min: AuditLogMinAggregateOutputType | null
    _max: AuditLogMaxAggregateOutputType | null
  }

  type GetAuditLogGroupByPayload<T extends AuditLogGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AuditLogGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AuditLogGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AuditLogGroupByOutputType[P]>
            : GetScalarType<T[P], AuditLogGroupByOutputType[P]>
        }
      >
    >


  export type AuditLogSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    operation_type?: boolean
    table_name?: boolean
    field_name?: boolean
    old_value?: boolean
    new_value?: boolean
    entity_id?: boolean
    user_id?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    user?: boolean | AuditLog$userArgs<ExtArgs>
  }, ExtArgs["result"]["auditLog"]>

  export type AuditLogSelectScalar = {
    id?: boolean
    operation_type?: boolean
    table_name?: boolean
    field_name?: boolean
    old_value?: boolean
    new_value?: boolean
    entity_id?: boolean
    user_id?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
  }


  export type AuditLogInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    user?: boolean | AuditLog$userArgs<ExtArgs>
  }


  export type $AuditLogPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "AuditLog"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      user: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      operation_type: string
      table_name: string
      field_name: string
      old_value: string | null
      new_value: string | null
      entity_id: number
      user_id: number | null
      status_id: number
      company_id: number | null
      created_at: Date
    }, ExtArgs["result"]["auditLog"]>
    composites: {}
  }


  type AuditLogGetPayload<S extends boolean | null | undefined | AuditLogDefaultArgs> = $Result.GetResult<Prisma.$AuditLogPayload, S>

  type AuditLogCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<AuditLogFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: AuditLogCountAggregateInputType | true
    }

  export interface AuditLogDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['AuditLog'], meta: { name: 'AuditLog' } }
    /**
     * Find zero or one AuditLog that matches the filter.
     * @param {AuditLogFindUniqueArgs} args - Arguments to find a AuditLog
     * @example
     * // Get one AuditLog
     * const auditLog = await prisma.auditLog.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends AuditLogFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, AuditLogFindUniqueArgs<ExtArgs>>
    ): Prisma__AuditLogClient<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one AuditLog that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {AuditLogFindUniqueOrThrowArgs} args - Arguments to find a AuditLog
     * @example
     * // Get one AuditLog
     * const auditLog = await prisma.auditLog.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends AuditLogFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, AuditLogFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__AuditLogClient<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first AuditLog that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditLogFindFirstArgs} args - Arguments to find a AuditLog
     * @example
     * // Get one AuditLog
     * const auditLog = await prisma.auditLog.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends AuditLogFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, AuditLogFindFirstArgs<ExtArgs>>
    ): Prisma__AuditLogClient<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first AuditLog that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditLogFindFirstOrThrowArgs} args - Arguments to find a AuditLog
     * @example
     * // Get one AuditLog
     * const auditLog = await prisma.auditLog.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends AuditLogFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, AuditLogFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__AuditLogClient<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more AuditLogs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditLogFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all AuditLogs
     * const auditLogs = await prisma.auditLog.findMany()
     * 
     * // Get first 10 AuditLogs
     * const auditLogs = await prisma.auditLog.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const auditLogWithIdOnly = await prisma.auditLog.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends AuditLogFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, AuditLogFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a AuditLog.
     * @param {AuditLogCreateArgs} args - Arguments to create a AuditLog.
     * @example
     * // Create one AuditLog
     * const AuditLog = await prisma.auditLog.create({
     *   data: {
     *     // ... data to create a AuditLog
     *   }
     * })
     * 
    **/
    create<T extends AuditLogCreateArgs<ExtArgs>>(
      args: SelectSubset<T, AuditLogCreateArgs<ExtArgs>>
    ): Prisma__AuditLogClient<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many AuditLogs.
     * @param {AuditLogCreateManyArgs} args - Arguments to create many AuditLogs.
     * @example
     * // Create many AuditLogs
     * const auditLog = await prisma.auditLog.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends AuditLogCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, AuditLogCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many AuditLogs and returns the data saved in the database.
     * @param {AuditLogCreateManyAndReturnArgs} args - Arguments to create many AuditLogs.
     * @example
     * // Create many AuditLogs
     * const auditLog = await prisma.auditLog.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many AuditLogs and only return the `id`
     * const auditLogWithIdOnly = await prisma.auditLog.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends AuditLogCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, AuditLogCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a AuditLog.
     * @param {AuditLogDeleteArgs} args - Arguments to delete one AuditLog.
     * @example
     * // Delete one AuditLog
     * const AuditLog = await prisma.auditLog.delete({
     *   where: {
     *     // ... filter to delete one AuditLog
     *   }
     * })
     * 
    **/
    delete<T extends AuditLogDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, AuditLogDeleteArgs<ExtArgs>>
    ): Prisma__AuditLogClient<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one AuditLog.
     * @param {AuditLogUpdateArgs} args - Arguments to update one AuditLog.
     * @example
     * // Update one AuditLog
     * const auditLog = await prisma.auditLog.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends AuditLogUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, AuditLogUpdateArgs<ExtArgs>>
    ): Prisma__AuditLogClient<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more AuditLogs.
     * @param {AuditLogDeleteManyArgs} args - Arguments to filter AuditLogs to delete.
     * @example
     * // Delete a few AuditLogs
     * const { count } = await prisma.auditLog.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends AuditLogDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, AuditLogDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more AuditLogs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditLogUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many AuditLogs
     * const auditLog = await prisma.auditLog.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends AuditLogUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, AuditLogUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one AuditLog.
     * @param {AuditLogUpsertArgs} args - Arguments to update or create a AuditLog.
     * @example
     * // Update or create a AuditLog
     * const auditLog = await prisma.auditLog.upsert({
     *   create: {
     *     // ... data to create a AuditLog
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the AuditLog we want to update
     *   }
     * })
    **/
    upsert<T extends AuditLogUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, AuditLogUpsertArgs<ExtArgs>>
    ): Prisma__AuditLogClient<$Result.GetResult<Prisma.$AuditLogPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of AuditLogs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditLogCountArgs} args - Arguments to filter AuditLogs to count.
     * @example
     * // Count the number of AuditLogs
     * const count = await prisma.auditLog.count({
     *   where: {
     *     // ... the filter for the AuditLogs we want to count
     *   }
     * })
    **/
    count<T extends AuditLogCountArgs>(
      args?: Subset<T, AuditLogCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AuditLogCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a AuditLog.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditLogAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AuditLogAggregateArgs>(args: Subset<T, AuditLogAggregateArgs>): Prisma.PrismaPromise<GetAuditLogAggregateType<T>>

    /**
     * Group by AuditLog.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditLogGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends AuditLogGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: AuditLogGroupByArgs['orderBy'] }
        : { orderBy?: AuditLogGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, AuditLogGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAuditLogGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the AuditLog model
   */
  readonly fields: AuditLogFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for AuditLog.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__AuditLogClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    user<T extends AuditLog$userArgs<ExtArgs> = {}>(args?: Subset<T, AuditLog$userArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the AuditLog model
   */ 
  interface AuditLogFieldRefs {
    readonly id: FieldRef<"AuditLog", 'Int'>
    readonly operation_type: FieldRef<"AuditLog", 'String'>
    readonly table_name: FieldRef<"AuditLog", 'String'>
    readonly field_name: FieldRef<"AuditLog", 'String'>
    readonly old_value: FieldRef<"AuditLog", 'String'>
    readonly new_value: FieldRef<"AuditLog", 'String'>
    readonly entity_id: FieldRef<"AuditLog", 'Int'>
    readonly user_id: FieldRef<"AuditLog", 'Int'>
    readonly status_id: FieldRef<"AuditLog", 'Int'>
    readonly company_id: FieldRef<"AuditLog", 'Int'>
    readonly created_at: FieldRef<"AuditLog", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * AuditLog findUnique
   */
  export type AuditLogFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * Filter, which AuditLog to fetch.
     */
    where: AuditLogWhereUniqueInput
  }

  /**
   * AuditLog findUniqueOrThrow
   */
  export type AuditLogFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * Filter, which AuditLog to fetch.
     */
    where: AuditLogWhereUniqueInput
  }

  /**
   * AuditLog findFirst
   */
  export type AuditLogFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * Filter, which AuditLog to fetch.
     */
    where?: AuditLogWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditLogs to fetch.
     */
    orderBy?: AuditLogOrderByWithRelationAndSearchRelevanceInput | AuditLogOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AuditLogs.
     */
    cursor?: AuditLogWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditLogs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditLogs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AuditLogs.
     */
    distinct?: AuditLogScalarFieldEnum | AuditLogScalarFieldEnum[]
  }

  /**
   * AuditLog findFirstOrThrow
   */
  export type AuditLogFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * Filter, which AuditLog to fetch.
     */
    where?: AuditLogWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditLogs to fetch.
     */
    orderBy?: AuditLogOrderByWithRelationAndSearchRelevanceInput | AuditLogOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AuditLogs.
     */
    cursor?: AuditLogWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditLogs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditLogs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AuditLogs.
     */
    distinct?: AuditLogScalarFieldEnum | AuditLogScalarFieldEnum[]
  }

  /**
   * AuditLog findMany
   */
  export type AuditLogFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * Filter, which AuditLogs to fetch.
     */
    where?: AuditLogWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditLogs to fetch.
     */
    orderBy?: AuditLogOrderByWithRelationAndSearchRelevanceInput | AuditLogOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing AuditLogs.
     */
    cursor?: AuditLogWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditLogs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditLogs.
     */
    skip?: number
    distinct?: AuditLogScalarFieldEnum | AuditLogScalarFieldEnum[]
  }

  /**
   * AuditLog create
   */
  export type AuditLogCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * The data needed to create a AuditLog.
     */
    data: XOR<AuditLogCreateInput, AuditLogUncheckedCreateInput>
  }

  /**
   * AuditLog createMany
   */
  export type AuditLogCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many AuditLogs.
     */
    data: AuditLogCreateManyInput | AuditLogCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * AuditLog createManyAndReturn
   */
  export type AuditLogCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * The data used to create many AuditLogs.
     */
    data: AuditLogCreateManyInput | AuditLogCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * AuditLog update
   */
  export type AuditLogUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * The data needed to update a AuditLog.
     */
    data: XOR<AuditLogUpdateInput, AuditLogUncheckedUpdateInput>
    /**
     * Choose, which AuditLog to update.
     */
    where: AuditLogWhereUniqueInput
  }

  /**
   * AuditLog updateMany
   */
  export type AuditLogUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update AuditLogs.
     */
    data: XOR<AuditLogUpdateManyMutationInput, AuditLogUncheckedUpdateManyInput>
    /**
     * Filter which AuditLogs to update
     */
    where?: AuditLogWhereInput
  }

  /**
   * AuditLog upsert
   */
  export type AuditLogUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * The filter to search for the AuditLog to update in case it exists.
     */
    where: AuditLogWhereUniqueInput
    /**
     * In case the AuditLog found by the `where` argument doesn't exist, create a new AuditLog with this data.
     */
    create: XOR<AuditLogCreateInput, AuditLogUncheckedCreateInput>
    /**
     * In case the AuditLog was found with the provided `where` argument, update it with this data.
     */
    update: XOR<AuditLogUpdateInput, AuditLogUncheckedUpdateInput>
  }

  /**
   * AuditLog delete
   */
  export type AuditLogDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
    /**
     * Filter which AuditLog to delete.
     */
    where: AuditLogWhereUniqueInput
  }

  /**
   * AuditLog deleteMany
   */
  export type AuditLogDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AuditLogs to delete
     */
    where?: AuditLogWhereInput
  }

  /**
   * AuditLog.user
   */
  export type AuditLog$userArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * AuditLog without action
   */
  export type AuditLogDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditLog
     */
    select?: AuditLogSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditLogInclude<ExtArgs> | null
  }


  /**
   * Model Permissions
   */

  export type AggregatePermissions = {
    _count: PermissionsCountAggregateOutputType | null
    _avg: PermissionsAvgAggregateOutputType | null
    _sum: PermissionsSumAggregateOutputType | null
    _min: PermissionsMinAggregateOutputType | null
    _max: PermissionsMaxAggregateOutputType | null
  }

  export type PermissionsAvgAggregateOutputType = {
    id: number | null
    entity_id: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
  }

  export type PermissionsSumAggregateOutputType = {
    id: number | null
    entity_id: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
  }

  export type PermissionsMinAggregateOutputType = {
    id: number | null
    name: string | null
    slug: string | null
    entity_id: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    created_at: Date | null
  }

  export type PermissionsMaxAggregateOutputType = {
    id: number | null
    name: string | null
    slug: string | null
    entity_id: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    created_at: Date | null
  }

  export type PermissionsCountAggregateOutputType = {
    id: number
    name: number
    slug: number
    entity_id: number
    order_no: number
    status_id: number
    company_id: number
    created_at: number
    _all: number
  }


  export type PermissionsAvgAggregateInputType = {
    id?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
  }

  export type PermissionsSumAggregateInputType = {
    id?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
  }

  export type PermissionsMinAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
    created_at?: true
  }

  export type PermissionsMaxAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
    created_at?: true
  }

  export type PermissionsCountAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
    created_at?: true
    _all?: true
  }

  export type PermissionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Permissions to aggregate.
     */
    where?: PermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: PermissionsOrderByWithRelationAndSearchRelevanceInput | PermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: PermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Permissions
    **/
    _count?: true | PermissionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: PermissionsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: PermissionsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: PermissionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: PermissionsMaxAggregateInputType
  }

  export type GetPermissionsAggregateType<T extends PermissionsAggregateArgs> = {
        [P in keyof T & keyof AggregatePermissions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePermissions[P]>
      : GetScalarType<T[P], AggregatePermissions[P]>
  }




  export type PermissionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PermissionsWhereInput
    orderBy?: PermissionsOrderByWithAggregationInput | PermissionsOrderByWithAggregationInput[]
    by: PermissionsScalarFieldEnum[] | PermissionsScalarFieldEnum
    having?: PermissionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: PermissionsCountAggregateInputType | true
    _avg?: PermissionsAvgAggregateInputType
    _sum?: PermissionsSumAggregateInputType
    _min?: PermissionsMinAggregateInputType
    _max?: PermissionsMaxAggregateInputType
  }

  export type PermissionsGroupByOutputType = {
    id: number
    name: string
    slug: string
    entity_id: number | null
    order_no: Decimal
    status_id: number
    company_id: number
    created_at: Date
    _count: PermissionsCountAggregateOutputType | null
    _avg: PermissionsAvgAggregateOutputType | null
    _sum: PermissionsSumAggregateOutputType | null
    _min: PermissionsMinAggregateOutputType | null
    _max: PermissionsMaxAggregateOutputType | null
  }

  type GetPermissionsGroupByPayload<T extends PermissionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<PermissionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof PermissionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], PermissionsGroupByOutputType[P]>
            : GetScalarType<T[P], PermissionsGroupByOutputType[P]>
        }
      >
    >


  export type PermissionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    slug?: boolean
    entity_id?: boolean
    order_no?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    entity?: boolean | Permissions$entityArgs<ExtArgs>
    roles?: boolean | Permissions$rolesArgs<ExtArgs>
    users?: boolean | Permissions$usersArgs<ExtArgs>
    menus?: boolean | Permissions$menusArgs<ExtArgs>
    _count?: boolean | PermissionsCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["permissions"]>

  export type PermissionsSelectScalar = {
    id?: boolean
    name?: boolean
    slug?: boolean
    entity_id?: boolean
    order_no?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
  }


  export type PermissionsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    entity?: boolean | Permissions$entityArgs<ExtArgs>
    roles?: boolean | Permissions$rolesArgs<ExtArgs>
    users?: boolean | Permissions$usersArgs<ExtArgs>
    menus?: boolean | Permissions$menusArgs<ExtArgs>
    _count?: boolean | PermissionsCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $PermissionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Permissions"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      entity: Prisma.$MasterEntityPayload<ExtArgs> | null
      roles: Prisma.$RolePermissionsPayload<ExtArgs>[]
      users: Prisma.$UserPermissionsPayload<ExtArgs>[]
      menus: Prisma.$MenuItemsPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      slug: string
      entity_id: number | null
      order_no: Prisma.Decimal
      status_id: number
      company_id: number
      created_at: Date
    }, ExtArgs["result"]["permissions"]>
    composites: {}
  }


  type PermissionsGetPayload<S extends boolean | null | undefined | PermissionsDefaultArgs> = $Result.GetResult<Prisma.$PermissionsPayload, S>

  type PermissionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<PermissionsFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: PermissionsCountAggregateInputType | true
    }

  export interface PermissionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Permissions'], meta: { name: 'Permissions' } }
    /**
     * Find zero or one Permissions that matches the filter.
     * @param {PermissionsFindUniqueArgs} args - Arguments to find a Permissions
     * @example
     * // Get one Permissions
     * const permissions = await prisma.permissions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends PermissionsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsFindUniqueArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Permissions that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {PermissionsFindUniqueOrThrowArgs} args - Arguments to find a Permissions
     * @example
     * // Get one Permissions
     * const permissions = await prisma.permissions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends PermissionsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsFindFirstArgs} args - Arguments to find a Permissions
     * @example
     * // Get one Permissions
     * const permissions = await prisma.permissions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends PermissionsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsFindFirstArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Permissions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsFindFirstOrThrowArgs} args - Arguments to find a Permissions
     * @example
     * // Get one Permissions
     * const permissions = await prisma.permissions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends PermissionsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Permissions
     * const permissions = await prisma.permissions.findMany()
     * 
     * // Get first 10 Permissions
     * const permissions = await prisma.permissions.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const permissionsWithIdOnly = await prisma.permissions.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends PermissionsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Permissions.
     * @param {PermissionsCreateArgs} args - Arguments to create a Permissions.
     * @example
     * // Create one Permissions
     * const Permissions = await prisma.permissions.create({
     *   data: {
     *     // ... data to create a Permissions
     *   }
     * })
     * 
    **/
    create<T extends PermissionsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsCreateArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Permissions.
     * @param {PermissionsCreateManyArgs} args - Arguments to create many Permissions.
     * @example
     * // Create many Permissions
     * const permissions = await prisma.permissions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends PermissionsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Permissions and returns the data saved in the database.
     * @param {PermissionsCreateManyAndReturnArgs} args - Arguments to create many Permissions.
     * @example
     * // Create many Permissions
     * const permissions = await prisma.permissions.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Permissions and only return the `id`
     * const permissionsWithIdOnly = await prisma.permissions.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends PermissionsCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Permissions.
     * @param {PermissionsDeleteArgs} args - Arguments to delete one Permissions.
     * @example
     * // Delete one Permissions
     * const Permissions = await prisma.permissions.delete({
     *   where: {
     *     // ... filter to delete one Permissions
     *   }
     * })
     * 
    **/
    delete<T extends PermissionsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsDeleteArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Permissions.
     * @param {PermissionsUpdateArgs} args - Arguments to update one Permissions.
     * @example
     * // Update one Permissions
     * const permissions = await prisma.permissions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends PermissionsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsUpdateArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Permissions.
     * @param {PermissionsDeleteManyArgs} args - Arguments to filter Permissions to delete.
     * @example
     * // Delete a few Permissions
     * const { count } = await prisma.permissions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends PermissionsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Permissions
     * const permissions = await prisma.permissions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends PermissionsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Permissions.
     * @param {PermissionsUpsertArgs} args - Arguments to update or create a Permissions.
     * @example
     * // Update or create a Permissions
     * const permissions = await prisma.permissions.upsert({
     *   create: {
     *     // ... data to create a Permissions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Permissions we want to update
     *   }
     * })
    **/
    upsert<T extends PermissionsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsUpsertArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsCountArgs} args - Arguments to filter Permissions to count.
     * @example
     * // Count the number of Permissions
     * const count = await prisma.permissions.count({
     *   where: {
     *     // ... the filter for the Permissions we want to count
     *   }
     * })
    **/
    count<T extends PermissionsCountArgs>(
      args?: Subset<T, PermissionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], PermissionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends PermissionsAggregateArgs>(args: Subset<T, PermissionsAggregateArgs>): Prisma.PrismaPromise<GetPermissionsAggregateType<T>>

    /**
     * Group by Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends PermissionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: PermissionsGroupByArgs['orderBy'] }
        : { orderBy?: PermissionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, PermissionsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPermissionsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Permissions model
   */
  readonly fields: PermissionsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Permissions.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__PermissionsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    entity<T extends Permissions$entityArgs<ExtArgs> = {}>(args?: Subset<T, Permissions$entityArgs<ExtArgs>>): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    roles<T extends Permissions$rolesArgs<ExtArgs> = {}>(args?: Subset<T, Permissions$rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    users<T extends Permissions$usersArgs<ExtArgs> = {}>(args?: Subset<T, Permissions$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    menus<T extends Permissions$menusArgs<ExtArgs> = {}>(args?: Subset<T, Permissions$menusArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Permissions model
   */ 
  interface PermissionsFieldRefs {
    readonly id: FieldRef<"Permissions", 'Int'>
    readonly name: FieldRef<"Permissions", 'String'>
    readonly slug: FieldRef<"Permissions", 'String'>
    readonly entity_id: FieldRef<"Permissions", 'Int'>
    readonly order_no: FieldRef<"Permissions", 'Decimal'>
    readonly status_id: FieldRef<"Permissions", 'Int'>
    readonly company_id: FieldRef<"Permissions", 'Int'>
    readonly created_at: FieldRef<"Permissions", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Permissions findUnique
   */
  export type PermissionsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where: PermissionsWhereUniqueInput
  }

  /**
   * Permissions findUniqueOrThrow
   */
  export type PermissionsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where: PermissionsWhereUniqueInput
  }

  /**
   * Permissions findFirst
   */
  export type PermissionsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where?: PermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: PermissionsOrderByWithRelationAndSearchRelevanceInput | PermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Permissions.
     */
    cursor?: PermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Permissions.
     */
    distinct?: PermissionsScalarFieldEnum | PermissionsScalarFieldEnum[]
  }

  /**
   * Permissions findFirstOrThrow
   */
  export type PermissionsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where?: PermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: PermissionsOrderByWithRelationAndSearchRelevanceInput | PermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Permissions.
     */
    cursor?: PermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Permissions.
     */
    distinct?: PermissionsScalarFieldEnum | PermissionsScalarFieldEnum[]
  }

  /**
   * Permissions findMany
   */
  export type PermissionsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where?: PermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: PermissionsOrderByWithRelationAndSearchRelevanceInput | PermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Permissions.
     */
    cursor?: PermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    distinct?: PermissionsScalarFieldEnum | PermissionsScalarFieldEnum[]
  }

  /**
   * Permissions create
   */
  export type PermissionsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * The data needed to create a Permissions.
     */
    data: XOR<PermissionsCreateInput, PermissionsUncheckedCreateInput>
  }

  /**
   * Permissions createMany
   */
  export type PermissionsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Permissions.
     */
    data: PermissionsCreateManyInput | PermissionsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Permissions createManyAndReturn
   */
  export type PermissionsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * The data used to create many Permissions.
     */
    data: PermissionsCreateManyInput | PermissionsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Permissions update
   */
  export type PermissionsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * The data needed to update a Permissions.
     */
    data: XOR<PermissionsUpdateInput, PermissionsUncheckedUpdateInput>
    /**
     * Choose, which Permissions to update.
     */
    where: PermissionsWhereUniqueInput
  }

  /**
   * Permissions updateMany
   */
  export type PermissionsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Permissions.
     */
    data: XOR<PermissionsUpdateManyMutationInput, PermissionsUncheckedUpdateManyInput>
    /**
     * Filter which Permissions to update
     */
    where?: PermissionsWhereInput
  }

  /**
   * Permissions upsert
   */
  export type PermissionsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * The filter to search for the Permissions to update in case it exists.
     */
    where: PermissionsWhereUniqueInput
    /**
     * In case the Permissions found by the `where` argument doesn't exist, create a new Permissions with this data.
     */
    create: XOR<PermissionsCreateInput, PermissionsUncheckedCreateInput>
    /**
     * In case the Permissions was found with the provided `where` argument, update it with this data.
     */
    update: XOR<PermissionsUpdateInput, PermissionsUncheckedUpdateInput>
  }

  /**
   * Permissions delete
   */
  export type PermissionsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter which Permissions to delete.
     */
    where: PermissionsWhereUniqueInput
  }

  /**
   * Permissions deleteMany
   */
  export type PermissionsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Permissions to delete
     */
    where?: PermissionsWhereInput
  }

  /**
   * Permissions.entity
   */
  export type Permissions$entityArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    where?: MasterEntityWhereInput
  }

  /**
   * Permissions.roles
   */
  export type Permissions$rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    where?: RolePermissionsWhereInput
    orderBy?: RolePermissionsOrderByWithRelationAndSearchRelevanceInput | RolePermissionsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: RolePermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * Permissions.users
   */
  export type Permissions$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    where?: UserPermissionsWhereInput
    orderBy?: UserPermissionsOrderByWithRelationAndSearchRelevanceInput | UserPermissionsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserPermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * Permissions.menus
   */
  export type Permissions$menusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    where?: MenuItemsWhereInput
    orderBy?: MenuItemsOrderByWithRelationAndSearchRelevanceInput | MenuItemsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: MenuItemsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenuItemsScalarFieldEnum | MenuItemsScalarFieldEnum[]
  }

  /**
   * Permissions without action
   */
  export type PermissionsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
  }


  /**
   * Model Role
   */

  export type AggregateRole = {
    _count: RoleCountAggregateOutputType | null
    _avg: RoleAvgAggregateOutputType | null
    _sum: RoleSumAggregateOutputType | null
    _min: RoleMinAggregateOutputType | null
    _max: RoleMaxAggregateOutputType | null
  }

  export type RoleAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type RoleSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type RoleMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type RoleMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type RoleCountAggregateOutputType = {
    id: number
    uuid: number
    name: number
    description: number
    status_id: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type RoleAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type RoleSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type RoleMinAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type RoleMaxAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type RoleCountAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type RoleAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Role to aggregate.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationAndSearchRelevanceInput | RoleOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Roles
    **/
    _count?: true | RoleCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RoleAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RoleSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RoleMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RoleMaxAggregateInputType
  }

  export type GetRoleAggregateType<T extends RoleAggregateArgs> = {
        [P in keyof T & keyof AggregateRole]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRole[P]>
      : GetScalarType<T[P], AggregateRole[P]>
  }




  export type RoleGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithAggregationInput | RoleOrderByWithAggregationInput[]
    by: RoleScalarFieldEnum[] | RoleScalarFieldEnum
    having?: RoleScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RoleCountAggregateInputType | true
    _avg?: RoleAvgAggregateInputType
    _sum?: RoleSumAggregateInputType
    _min?: RoleMinAggregateInputType
    _max?: RoleMaxAggregateInputType
  }

  export type RoleGroupByOutputType = {
    id: number
    uuid: string
    name: string
    description: string | null
    status_id: number
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: RoleCountAggregateOutputType | null
    _avg: RoleAvgAggregateOutputType | null
    _sum: RoleSumAggregateOutputType | null
    _min: RoleMinAggregateOutputType | null
    _max: RoleMaxAggregateOutputType | null
  }

  type GetRoleGroupByPayload<T extends RoleGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RoleGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RoleGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RoleGroupByOutputType[P]>
            : GetScalarType<T[P], RoleGroupByOutputType[P]>
        }
      >
    >


  export type RoleSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    permissions?: boolean | Role$permissionsArgs<ExtArgs>
    users?: boolean | Role$usersArgs<ExtArgs>
    role_policy?: boolean | Role$role_policyArgs<ExtArgs>
    created?: boolean | Role$createdArgs<ExtArgs>
    updated?: boolean | Role$updatedArgs<ExtArgs>
    deleted?: boolean | Role$deletedArgs<ExtArgs>
    _count?: boolean | RoleCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["role"]>

  export type RoleSelectScalar = {
    id?: boolean
    uuid?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }


  export type RoleInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    permissions?: boolean | Role$permissionsArgs<ExtArgs>
    users?: boolean | Role$usersArgs<ExtArgs>
    role_policy?: boolean | Role$role_policyArgs<ExtArgs>
    created?: boolean | Role$createdArgs<ExtArgs>
    updated?: boolean | Role$updatedArgs<ExtArgs>
    deleted?: boolean | Role$deletedArgs<ExtArgs>
    _count?: boolean | RoleCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $RolePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Role"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      permissions: Prisma.$RolePermissionsPayload<ExtArgs>[]
      users: Prisma.$UserRolesPayload<ExtArgs>[]
      role_policy: Prisma.$RolePoliciesPayload<ExtArgs>[]
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      name: string
      description: string | null
      status_id: number
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["role"]>
    composites: {}
  }


  type RoleGetPayload<S extends boolean | null | undefined | RoleDefaultArgs> = $Result.GetResult<Prisma.$RolePayload, S>

  type RoleCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<RoleFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: RoleCountAggregateInputType | true
    }

  export interface RoleDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Role'], meta: { name: 'Role' } }
    /**
     * Find zero or one Role that matches the filter.
     * @param {RoleFindUniqueArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends RoleFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, RoleFindUniqueArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Role that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {RoleFindUniqueOrThrowArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends RoleFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Role that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindFirstArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends RoleFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleFindFirstArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Role that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindFirstOrThrowArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends RoleFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Roles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Roles
     * const roles = await prisma.role.findMany()
     * 
     * // Get first 10 Roles
     * const roles = await prisma.role.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const roleWithIdOnly = await prisma.role.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends RoleFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Role.
     * @param {RoleCreateArgs} args - Arguments to create a Role.
     * @example
     * // Create one Role
     * const Role = await prisma.role.create({
     *   data: {
     *     // ... data to create a Role
     *   }
     * })
     * 
    **/
    create<T extends RoleCreateArgs<ExtArgs>>(
      args: SelectSubset<T, RoleCreateArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Roles.
     * @param {RoleCreateManyArgs} args - Arguments to create many Roles.
     * @example
     * // Create many Roles
     * const role = await prisma.role.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends RoleCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Roles and returns the data saved in the database.
     * @param {RoleCreateManyAndReturnArgs} args - Arguments to create many Roles.
     * @example
     * // Create many Roles
     * const role = await prisma.role.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Roles and only return the `id`
     * const roleWithIdOnly = await prisma.role.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends RoleCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Role.
     * @param {RoleDeleteArgs} args - Arguments to delete one Role.
     * @example
     * // Delete one Role
     * const Role = await prisma.role.delete({
     *   where: {
     *     // ... filter to delete one Role
     *   }
     * })
     * 
    **/
    delete<T extends RoleDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, RoleDeleteArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Role.
     * @param {RoleUpdateArgs} args - Arguments to update one Role.
     * @example
     * // Update one Role
     * const role = await prisma.role.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends RoleUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, RoleUpdateArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Roles.
     * @param {RoleDeleteManyArgs} args - Arguments to filter Roles to delete.
     * @example
     * // Delete a few Roles
     * const { count } = await prisma.role.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends RoleDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Roles
     * const role = await prisma.role.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends RoleUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, RoleUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Role.
     * @param {RoleUpsertArgs} args - Arguments to update or create a Role.
     * @example
     * // Update or create a Role
     * const role = await prisma.role.upsert({
     *   create: {
     *     // ... data to create a Role
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Role we want to update
     *   }
     * })
    **/
    upsert<T extends RoleUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, RoleUpsertArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleCountArgs} args - Arguments to filter Roles to count.
     * @example
     * // Count the number of Roles
     * const count = await prisma.role.count({
     *   where: {
     *     // ... the filter for the Roles we want to count
     *   }
     * })
    **/
    count<T extends RoleCountArgs>(
      args?: Subset<T, RoleCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RoleCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Role.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RoleAggregateArgs>(args: Subset<T, RoleAggregateArgs>): Prisma.PrismaPromise<GetRoleAggregateType<T>>

    /**
     * Group by Role.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RoleGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RoleGroupByArgs['orderBy'] }
        : { orderBy?: RoleGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RoleGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRoleGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Role model
   */
  readonly fields: RoleFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Role.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RoleClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    permissions<T extends Role$permissionsArgs<ExtArgs> = {}>(args?: Subset<T, Role$permissionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    users<T extends Role$usersArgs<ExtArgs> = {}>(args?: Subset<T, Role$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findMany'> | Null>;

    role_policy<T extends Role$role_policyArgs<ExtArgs> = {}>(args?: Subset<T, Role$role_policyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePoliciesPayload<ExtArgs>, T, 'findMany'> | Null>;

    created<T extends Role$createdArgs<ExtArgs> = {}>(args?: Subset<T, Role$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends Role$updatedArgs<ExtArgs> = {}>(args?: Subset<T, Role$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends Role$deletedArgs<ExtArgs> = {}>(args?: Subset<T, Role$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Role model
   */ 
  interface RoleFieldRefs {
    readonly id: FieldRef<"Role", 'Int'>
    readonly uuid: FieldRef<"Role", 'String'>
    readonly name: FieldRef<"Role", 'String'>
    readonly description: FieldRef<"Role", 'String'>
    readonly status_id: FieldRef<"Role", 'Int'>
    readonly company_id: FieldRef<"Role", 'Int'>
    readonly created_by: FieldRef<"Role", 'Int'>
    readonly updated_by: FieldRef<"Role", 'Int'>
    readonly deleted_by: FieldRef<"Role", 'Int'>
    readonly created_at: FieldRef<"Role", 'DateTime'>
    readonly updated_at: FieldRef<"Role", 'DateTime'>
    readonly deleted_at: FieldRef<"Role", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Role findUnique
   */
  export type RoleFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role findUniqueOrThrow
   */
  export type RoleFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role findFirst
   */
  export type RoleFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationAndSearchRelevanceInput | RoleOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Roles.
     */
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role findFirstOrThrow
   */
  export type RoleFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationAndSearchRelevanceInput | RoleOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Roles.
     */
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role findMany
   */
  export type RoleFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Roles to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationAndSearchRelevanceInput | RoleOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role create
   */
  export type RoleCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The data needed to create a Role.
     */
    data: XOR<RoleCreateInput, RoleUncheckedCreateInput>
  }

  /**
   * Role createMany
   */
  export type RoleCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Roles.
     */
    data: RoleCreateManyInput | RoleCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Role createManyAndReturn
   */
  export type RoleCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The data used to create many Roles.
     */
    data: RoleCreateManyInput | RoleCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Role update
   */
  export type RoleUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The data needed to update a Role.
     */
    data: XOR<RoleUpdateInput, RoleUncheckedUpdateInput>
    /**
     * Choose, which Role to update.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role updateMany
   */
  export type RoleUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Roles.
     */
    data: XOR<RoleUpdateManyMutationInput, RoleUncheckedUpdateManyInput>
    /**
     * Filter which Roles to update
     */
    where?: RoleWhereInput
  }

  /**
   * Role upsert
   */
  export type RoleUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The filter to search for the Role to update in case it exists.
     */
    where: RoleWhereUniqueInput
    /**
     * In case the Role found by the `where` argument doesn't exist, create a new Role with this data.
     */
    create: XOR<RoleCreateInput, RoleUncheckedCreateInput>
    /**
     * In case the Role was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RoleUpdateInput, RoleUncheckedUpdateInput>
  }

  /**
   * Role delete
   */
  export type RoleDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter which Role to delete.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role deleteMany
   */
  export type RoleDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Roles to delete
     */
    where?: RoleWhereInput
  }

  /**
   * Role.permissions
   */
  export type Role$permissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    where?: RolePermissionsWhereInput
    orderBy?: RolePermissionsOrderByWithRelationAndSearchRelevanceInput | RolePermissionsOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: RolePermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * Role.users
   */
  export type Role$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    where?: UserRolesWhereInput
    orderBy?: UserRolesOrderByWithRelationAndSearchRelevanceInput | UserRolesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: UserRolesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * Role.role_policy
   */
  export type Role$role_policyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePolicies
     */
    select?: RolePoliciesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePoliciesInclude<ExtArgs> | null
    where?: RolePoliciesWhereInput
    orderBy?: RolePoliciesOrderByWithRelationAndSearchRelevanceInput | RolePoliciesOrderByWithRelationAndSearchRelevanceInput[]
    cursor?: RolePoliciesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RolePoliciesScalarFieldEnum | RolePoliciesScalarFieldEnum[]
  }

  /**
   * Role.created
   */
  export type Role$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Role.updated
   */
  export type Role$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Role.deleted
   */
  export type Role$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Role without action
   */
  export type RoleDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
  }


  /**
   * Model RolePermissions
   */

  export type AggregateRolePermissions = {
    _count: RolePermissionsCountAggregateOutputType | null
    _avg: RolePermissionsAvgAggregateOutputType | null
    _sum: RolePermissionsSumAggregateOutputType | null
    _min: RolePermissionsMinAggregateOutputType | null
    _max: RolePermissionsMaxAggregateOutputType | null
  }

  export type RolePermissionsAvgAggregateOutputType = {
    role_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type RolePermissionsSumAggregateOutputType = {
    role_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type RolePermissionsMinAggregateOutputType = {
    role_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type RolePermissionsMaxAggregateOutputType = {
    role_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type RolePermissionsCountAggregateOutputType = {
    role_id: number
    permission_id: number
    company_id: number
    _all: number
  }


  export type RolePermissionsAvgAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
  }

  export type RolePermissionsSumAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
  }

  export type RolePermissionsMinAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
  }

  export type RolePermissionsMaxAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
  }

  export type RolePermissionsCountAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
    _all?: true
  }

  export type RolePermissionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RolePermissions to aggregate.
     */
    where?: RolePermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RolePermissions to fetch.
     */
    orderBy?: RolePermissionsOrderByWithRelationAndSearchRelevanceInput | RolePermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RolePermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RolePermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RolePermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned RolePermissions
    **/
    _count?: true | RolePermissionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RolePermissionsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RolePermissionsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RolePermissionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RolePermissionsMaxAggregateInputType
  }

  export type GetRolePermissionsAggregateType<T extends RolePermissionsAggregateArgs> = {
        [P in keyof T & keyof AggregateRolePermissions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRolePermissions[P]>
      : GetScalarType<T[P], AggregateRolePermissions[P]>
  }




  export type RolePermissionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RolePermissionsWhereInput
    orderBy?: RolePermissionsOrderByWithAggregationInput | RolePermissionsOrderByWithAggregationInput[]
    by: RolePermissionsScalarFieldEnum[] | RolePermissionsScalarFieldEnum
    having?: RolePermissionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RolePermissionsCountAggregateInputType | true
    _avg?: RolePermissionsAvgAggregateInputType
    _sum?: RolePermissionsSumAggregateInputType
    _min?: RolePermissionsMinAggregateInputType
    _max?: RolePermissionsMaxAggregateInputType
  }

  export type RolePermissionsGroupByOutputType = {
    role_id: number
    permission_id: number
    company_id: number
    _count: RolePermissionsCountAggregateOutputType | null
    _avg: RolePermissionsAvgAggregateOutputType | null
    _sum: RolePermissionsSumAggregateOutputType | null
    _min: RolePermissionsMinAggregateOutputType | null
    _max: RolePermissionsMaxAggregateOutputType | null
  }

  type GetRolePermissionsGroupByPayload<T extends RolePermissionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RolePermissionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RolePermissionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RolePermissionsGroupByOutputType[P]>
            : GetScalarType<T[P], RolePermissionsGroupByOutputType[P]>
        }
      >
    >


  export type RolePermissionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    role_id?: boolean
    permission_id?: boolean
    company_id?: boolean
    role?: boolean | RoleDefaultArgs<ExtArgs>
    permission?: boolean | PermissionsDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["rolePermissions"]>

  export type RolePermissionsSelectScalar = {
    role_id?: boolean
    permission_id?: boolean
    company_id?: boolean
  }


  export type RolePermissionsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    role?: boolean | RoleDefaultArgs<ExtArgs>
    permission?: boolean | PermissionsDefaultArgs<ExtArgs>
  }


  export type $RolePermissionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "RolePermissions"
    objects: {
      role: Prisma.$RolePayload<ExtArgs>
      permission: Prisma.$PermissionsPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      role_id: number
      permission_id: number
      company_id: number
    }, ExtArgs["result"]["rolePermissions"]>
    composites: {}
  }


  type RolePermissionsGetPayload<S extends boolean | null | undefined | RolePermissionsDefaultArgs> = $Result.GetResult<Prisma.$RolePermissionsPayload, S>

  type RolePermissionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<RolePermissionsFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: RolePermissionsCountAggregateInputType | true
    }

  export interface RolePermissionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['RolePermissions'], meta: { name: 'RolePermissions' } }
    /**
     * Find zero or one RolePermissions that matches the filter.
     * @param {RolePermissionsFindUniqueArgs} args - Arguments to find a RolePermissions
     * @example
     * // Get one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends RolePermissionsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsFindUniqueArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one RolePermissions that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {RolePermissionsFindUniqueOrThrowArgs} args - Arguments to find a RolePermissions
     * @example
     * // Get one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends RolePermissionsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first RolePermissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsFindFirstArgs} args - Arguments to find a RolePermissions
     * @example
     * // Get one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends RolePermissionsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsFindFirstArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first RolePermissions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsFindFirstOrThrowArgs} args - Arguments to find a RolePermissions
     * @example
     * // Get one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends RolePermissionsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more RolePermissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findMany()
     * 
     * // Get first 10 RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findMany({ take: 10 })
     * 
     * // Only select the `role_id`
     * const rolePermissionsWithRole_idOnly = await prisma.rolePermissions.findMany({ select: { role_id: true } })
     * 
    **/
    findMany<T extends RolePermissionsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a RolePermissions.
     * @param {RolePermissionsCreateArgs} args - Arguments to create a RolePermissions.
     * @example
     * // Create one RolePermissions
     * const RolePermissions = await prisma.rolePermissions.create({
     *   data: {
     *     // ... data to create a RolePermissions
     *   }
     * })
     * 
    **/
    create<T extends RolePermissionsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsCreateArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many RolePermissions.
     * @param {RolePermissionsCreateManyArgs} args - Arguments to create many RolePermissions.
     * @example
     * // Create many RolePermissions
     * const rolePermissions = await prisma.rolePermissions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends RolePermissionsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many RolePermissions and returns the data saved in the database.
     * @param {RolePermissionsCreateManyAndReturnArgs} args - Arguments to create many RolePermissions.
     * @example
     * // Create many RolePermissions
     * const rolePermissions = await prisma.rolePermissions.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many RolePermissions and only return the `role_id`
     * const rolePermissionsWithRole_idOnly = await prisma.rolePermissions.createManyAndReturn({ 
     *   select: { role_id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends RolePermissionsCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a RolePermissions.
     * @param {RolePermissionsDeleteArgs} args - Arguments to delete one RolePermissions.
     * @example
     * // Delete one RolePermissions
     * const RolePermissions = await prisma.rolePermissions.delete({
     *   where: {
     *     // ... filter to delete one RolePermissions
     *   }
     * })
     * 
    **/
    delete<T extends RolePermissionsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsDeleteArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one RolePermissions.
     * @param {RolePermissionsUpdateArgs} args - Arguments to update one RolePermissions.
     * @example
     * // Update one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends RolePermissionsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsUpdateArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more RolePermissions.
     * @param {RolePermissionsDeleteManyArgs} args - Arguments to filter RolePermissions to delete.
     * @example
     * // Delete a few RolePermissions
     * const { count } = await prisma.rolePermissions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends RolePermissionsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more RolePermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many RolePermissions
     * const rolePermissions = await prisma.rolePermissions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends RolePermissionsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one RolePermissions.
     * @param {RolePermissionsUpsertArgs} args - Arguments to update or create a RolePermissions.
     * @example
     * // Update or create a RolePermissions
     * const rolePermissions = await prisma.rolePermissions.upsert({
     *   create: {
     *     // ... data to create a RolePermissions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the RolePermissions we want to update
     *   }
     * })
    **/
    upsert<T extends RolePermissionsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsUpsertArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of RolePermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsCountArgs} args - Arguments to filter RolePermissions to count.
     * @example
     * // Count the number of RolePermissions
     * const count = await prisma.rolePermissions.count({
     *   where: {
     *     // ... the filter for the RolePermissions we want to count
     *   }
     * })
    **/
    count<T extends RolePermissionsCountArgs>(
      args?: Subset<T, RolePermissionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RolePermissionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a RolePermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RolePermissionsAggregateArgs>(args: Subset<T, RolePermissionsAggregateArgs>): Prisma.PrismaPromise<GetRolePermissionsAggregateType<T>>

    /**
     * Group by RolePermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RolePermissionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RolePermissionsGroupByArgs['orderBy'] }
        : { orderBy?: RolePermissionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RolePermissionsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRolePermissionsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the RolePermissions model
   */
  readonly fields: RolePermissionsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for RolePermissions.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RolePermissionsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    role<T extends RoleDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RoleDefaultArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    permission<T extends PermissionsDefaultArgs<ExtArgs> = {}>(args?: Subset<T, PermissionsDefaultArgs<ExtArgs>>): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the RolePermissions model
   */ 
  interface RolePermissionsFieldRefs {
    readonly role_id: FieldRef<"RolePermissions", 'Int'>
    readonly permission_id: FieldRef<"RolePermissions", 'Int'>
    readonly company_id: FieldRef<"RolePermissions", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * RolePermissions findUnique
   */
  export type RolePermissionsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where: RolePermissionsWhereUniqueInput
  }

  /**
   * RolePermissions findUniqueOrThrow
   */
  export type RolePermissionsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where: RolePermissionsWhereUniqueInput
  }

  /**
   * RolePermissions findFirst
   */
  export type RolePermissionsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where?: RolePermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RolePermissions to fetch.
     */
    orderBy?: RolePermissionsOrderByWithRelationAndSearchRelevanceInput | RolePermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RolePermissions.
     */
    cursor?: RolePermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RolePermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RolePermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RolePermissions.
     */
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * RolePermissions findFirstOrThrow
   */
  export type RolePermissionsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where?: RolePermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RolePermissions to fetch.
     */
    orderBy?: RolePermissionsOrderByWithRelationAndSearchRelevanceInput | RolePermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RolePermissions.
     */
    cursor?: RolePermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RolePermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RolePermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RolePermissions.
     */
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * RolePermissions findMany
   */
  export type RolePermissionsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where?: RolePermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RolePermissions to fetch.
     */
    orderBy?: RolePermissionsOrderByWithRelationAndSearchRelevanceInput | RolePermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing RolePermissions.
     */
    cursor?: RolePermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RolePermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RolePermissions.
     */
    skip?: number
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * RolePermissions create
   */
  export type RolePermissionsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * The data needed to create a RolePermissions.
     */
    data: XOR<RolePermissionsCreateInput, RolePermissionsUncheckedCreateInput>
  }

  /**
   * RolePermissions createMany
   */
  export type RolePermissionsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many RolePermissions.
     */
    data: RolePermissionsCreateManyInput | RolePermissionsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * RolePermissions createManyAndReturn
   */
  export type RolePermissionsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * The data used to create many RolePermissions.
     */
    data: RolePermissionsCreateManyInput | RolePermissionsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * RolePermissions update
   */
  export type RolePermissionsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * The data needed to update a RolePermissions.
     */
    data: XOR<RolePermissionsUpdateInput, RolePermissionsUncheckedUpdateInput>
    /**
     * Choose, which RolePermissions to update.
     */
    where: RolePermissionsWhereUniqueInput
  }

  /**
   * RolePermissions updateMany
   */
  export type RolePermissionsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update RolePermissions.
     */
    data: XOR<RolePermissionsUpdateManyMutationInput, RolePermissionsUncheckedUpdateManyInput>
    /**
     * Filter which RolePermissions to update
     */
    where?: RolePermissionsWhereInput
  }

  /**
   * RolePermissions upsert
   */
  export type RolePermissionsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * The filter to search for the RolePermissions to update in case it exists.
     */
    where: RolePermissionsWhereUniqueInput
    /**
     * In case the RolePermissions found by the `where` argument doesn't exist, create a new RolePermissions with this data.
     */
    create: XOR<RolePermissionsCreateInput, RolePermissionsUncheckedCreateInput>
    /**
     * In case the RolePermissions was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RolePermissionsUpdateInput, RolePermissionsUncheckedUpdateInput>
  }

  /**
   * RolePermissions delete
   */
  export type RolePermissionsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter which RolePermissions to delete.
     */
    where: RolePermissionsWhereUniqueInput
  }

  /**
   * RolePermissions deleteMany
   */
  export type RolePermissionsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RolePermissions to delete
     */
    where?: RolePermissionsWhereInput
  }

  /**
   * RolePermissions without action
   */
  export type RolePermissionsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
  }


  /**
   * Model UserRoles
   */

  export type AggregateUserRoles = {
    _count: UserRolesCountAggregateOutputType | null
    _avg: UserRolesAvgAggregateOutputType | null
    _sum: UserRolesSumAggregateOutputType | null
    _min: UserRolesMinAggregateOutputType | null
    _max: UserRolesMaxAggregateOutputType | null
  }

  export type UserRolesAvgAggregateOutputType = {
    user_id: number | null
    role_id: number | null
    company_id: number | null
  }

  export type UserRolesSumAggregateOutputType = {
    user_id: number | null
    role_id: number | null
    company_id: number | null
  }

  export type UserRolesMinAggregateOutputType = {
    user_id: number | null
    role_id: number | null
    company_id: number | null
  }

  export type UserRolesMaxAggregateOutputType = {
    user_id: number | null
    role_id: number | null
    company_id: number | null
  }

  export type UserRolesCountAggregateOutputType = {
    user_id: number
    role_id: number
    company_id: number
    _all: number
  }


  export type UserRolesAvgAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
  }

  export type UserRolesSumAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
  }

  export type UserRolesMinAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
  }

  export type UserRolesMaxAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
  }

  export type UserRolesCountAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
    _all?: true
  }

  export type UserRolesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserRoles to aggregate.
     */
    where?: UserRolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRolesOrderByWithRelationAndSearchRelevanceInput | UserRolesOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserRolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserRoles
    **/
    _count?: true | UserRolesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserRolesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserRolesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserRolesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserRolesMaxAggregateInputType
  }

  export type GetUserRolesAggregateType<T extends UserRolesAggregateArgs> = {
        [P in keyof T & keyof AggregateUserRoles]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserRoles[P]>
      : GetScalarType<T[P], AggregateUserRoles[P]>
  }




  export type UserRolesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRolesWhereInput
    orderBy?: UserRolesOrderByWithAggregationInput | UserRolesOrderByWithAggregationInput[]
    by: UserRolesScalarFieldEnum[] | UserRolesScalarFieldEnum
    having?: UserRolesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserRolesCountAggregateInputType | true
    _avg?: UserRolesAvgAggregateInputType
    _sum?: UserRolesSumAggregateInputType
    _min?: UserRolesMinAggregateInputType
    _max?: UserRolesMaxAggregateInputType
  }

  export type UserRolesGroupByOutputType = {
    user_id: number
    role_id: number
    company_id: number
    _count: UserRolesCountAggregateOutputType | null
    _avg: UserRolesAvgAggregateOutputType | null
    _sum: UserRolesSumAggregateOutputType | null
    _min: UserRolesMinAggregateOutputType | null
    _max: UserRolesMaxAggregateOutputType | null
  }

  type GetUserRolesGroupByPayload<T extends UserRolesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserRolesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserRolesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserRolesGroupByOutputType[P]>
            : GetScalarType<T[P], UserRolesGroupByOutputType[P]>
        }
      >
    >


  export type UserRolesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    user_id?: boolean
    role_id?: boolean
    company_id?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userRoles"]>

  export type UserRolesSelectScalar = {
    user_id?: boolean
    role_id?: boolean
    company_id?: boolean
  }


  export type UserRolesInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }


  export type $UserRolesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserRoles"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      role: Prisma.$RolePayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      user_id: number
      role_id: number
      company_id: number
    }, ExtArgs["result"]["userRoles"]>
    composites: {}
  }


  type UserRolesGetPayload<S extends boolean | null | undefined | UserRolesDefaultArgs> = $Result.GetResult<Prisma.$UserRolesPayload, S>

  type UserRolesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserRolesFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserRolesCountAggregateInputType | true
    }

  export interface UserRolesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserRoles'], meta: { name: 'UserRoles' } }
    /**
     * Find zero or one UserRoles that matches the filter.
     * @param {UserRolesFindUniqueArgs} args - Arguments to find a UserRoles
     * @example
     * // Get one UserRoles
     * const userRoles = await prisma.userRoles.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserRolesFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesFindUniqueArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one UserRoles that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserRolesFindUniqueOrThrowArgs} args - Arguments to find a UserRoles
     * @example
     * // Get one UserRoles
     * const userRoles = await prisma.userRoles.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserRolesFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first UserRoles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesFindFirstArgs} args - Arguments to find a UserRoles
     * @example
     * // Get one UserRoles
     * const userRoles = await prisma.userRoles.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserRolesFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesFindFirstArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first UserRoles that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesFindFirstOrThrowArgs} args - Arguments to find a UserRoles
     * @example
     * // Get one UserRoles
     * const userRoles = await prisma.userRoles.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserRolesFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more UserRoles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserRoles
     * const userRoles = await prisma.userRoles.findMany()
     * 
     * // Get first 10 UserRoles
     * const userRoles = await prisma.userRoles.findMany({ take: 10 })
     * 
     * // Only select the `user_id`
     * const userRolesWithUser_idOnly = await prisma.userRoles.findMany({ select: { user_id: true } })
     * 
    **/
    findMany<T extends UserRolesFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a UserRoles.
     * @param {UserRolesCreateArgs} args - Arguments to create a UserRoles.
     * @example
     * // Create one UserRoles
     * const UserRoles = await prisma.userRoles.create({
     *   data: {
     *     // ... data to create a UserRoles
     *   }
     * })
     * 
    **/
    create<T extends UserRolesCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesCreateArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many UserRoles.
     * @param {UserRolesCreateManyArgs} args - Arguments to create many UserRoles.
     * @example
     * // Create many UserRoles
     * const userRoles = await prisma.userRoles.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends UserRolesCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserRoles and returns the data saved in the database.
     * @param {UserRolesCreateManyAndReturnArgs} args - Arguments to create many UserRoles.
     * @example
     * // Create many UserRoles
     * const userRoles = await prisma.userRoles.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserRoles and only return the `user_id`
     * const userRolesWithUser_idOnly = await prisma.userRoles.createManyAndReturn({ 
     *   select: { user_id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends UserRolesCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a UserRoles.
     * @param {UserRolesDeleteArgs} args - Arguments to delete one UserRoles.
     * @example
     * // Delete one UserRoles
     * const UserRoles = await prisma.userRoles.delete({
     *   where: {
     *     // ... filter to delete one UserRoles
     *   }
     * })
     * 
    **/
    delete<T extends UserRolesDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesDeleteArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one UserRoles.
     * @param {UserRolesUpdateArgs} args - Arguments to update one UserRoles.
     * @example
     * // Update one UserRoles
     * const userRoles = await prisma.userRoles.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserRolesUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesUpdateArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more UserRoles.
     * @param {UserRolesDeleteManyArgs} args - Arguments to filter UserRoles to delete.
     * @example
     * // Delete a few UserRoles
     * const { count } = await prisma.userRoles.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserRolesDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserRoles
     * const userRoles = await prisma.userRoles.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserRolesUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserRoles.
     * @param {UserRolesUpsertArgs} args - Arguments to update or create a UserRoles.
     * @example
     * // Update or create a UserRoles
     * const userRoles = await prisma.userRoles.upsert({
     *   create: {
     *     // ... data to create a UserRoles
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserRoles we want to update
     *   }
     * })
    **/
    upsert<T extends UserRolesUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesUpsertArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesCountArgs} args - Arguments to filter UserRoles to count.
     * @example
     * // Count the number of UserRoles
     * const count = await prisma.userRoles.count({
     *   where: {
     *     // ... the filter for the UserRoles we want to count
     *   }
     * })
    **/
    count<T extends UserRolesCountArgs>(
      args?: Subset<T, UserRolesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserRolesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserRolesAggregateArgs>(args: Subset<T, UserRolesAggregateArgs>): Prisma.PrismaPromise<GetUserRolesAggregateType<T>>

    /**
     * Group by UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserRolesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserRolesGroupByArgs['orderBy'] }
        : { orderBy?: UserRolesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserRolesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserRolesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserRoles model
   */
  readonly fields: UserRolesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserRoles.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserRolesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    role<T extends RoleDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RoleDefaultArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the UserRoles model
   */ 
  interface UserRolesFieldRefs {
    readonly user_id: FieldRef<"UserRoles", 'Int'>
    readonly role_id: FieldRef<"UserRoles", 'Int'>
    readonly company_id: FieldRef<"UserRoles", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * UserRoles findUnique
   */
  export type UserRolesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where: UserRolesWhereUniqueInput
  }

  /**
   * UserRoles findUniqueOrThrow
   */
  export type UserRolesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where: UserRolesWhereUniqueInput
  }

  /**
   * UserRoles findFirst
   */
  export type UserRolesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where?: UserRolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRolesOrderByWithRelationAndSearchRelevanceInput | UserRolesOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserRoles.
     */
    cursor?: UserRolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserRoles.
     */
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * UserRoles findFirstOrThrow
   */
  export type UserRolesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where?: UserRolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRolesOrderByWithRelationAndSearchRelevanceInput | UserRolesOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserRoles.
     */
    cursor?: UserRolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserRoles.
     */
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * UserRoles findMany
   */
  export type UserRolesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where?: UserRolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRolesOrderByWithRelationAndSearchRelevanceInput | UserRolesOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserRoles.
     */
    cursor?: UserRolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * UserRoles create
   */
  export type UserRolesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * The data needed to create a UserRoles.
     */
    data: XOR<UserRolesCreateInput, UserRolesUncheckedCreateInput>
  }

  /**
   * UserRoles createMany
   */
  export type UserRolesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserRoles.
     */
    data: UserRolesCreateManyInput | UserRolesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserRoles createManyAndReturn
   */
  export type UserRolesCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * The data used to create many UserRoles.
     */
    data: UserRolesCreateManyInput | UserRolesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserRoles update
   */
  export type UserRolesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * The data needed to update a UserRoles.
     */
    data: XOR<UserRolesUpdateInput, UserRolesUncheckedUpdateInput>
    /**
     * Choose, which UserRoles to update.
     */
    where: UserRolesWhereUniqueInput
  }

  /**
   * UserRoles updateMany
   */
  export type UserRolesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserRoles.
     */
    data: XOR<UserRolesUpdateManyMutationInput, UserRolesUncheckedUpdateManyInput>
    /**
     * Filter which UserRoles to update
     */
    where?: UserRolesWhereInput
  }

  /**
   * UserRoles upsert
   */
  export type UserRolesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * The filter to search for the UserRoles to update in case it exists.
     */
    where: UserRolesWhereUniqueInput
    /**
     * In case the UserRoles found by the `where` argument doesn't exist, create a new UserRoles with this data.
     */
    create: XOR<UserRolesCreateInput, UserRolesUncheckedCreateInput>
    /**
     * In case the UserRoles was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserRolesUpdateInput, UserRolesUncheckedUpdateInput>
  }

  /**
   * UserRoles delete
   */
  export type UserRolesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter which UserRoles to delete.
     */
    where: UserRolesWhereUniqueInput
  }

  /**
   * UserRoles deleteMany
   */
  export type UserRolesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserRoles to delete
     */
    where?: UserRolesWhereInput
  }

  /**
   * UserRoles without action
   */
  export type UserRolesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
  }


  /**
   * Model UserPermissions
   */

  export type AggregateUserPermissions = {
    _count: UserPermissionsCountAggregateOutputType | null
    _avg: UserPermissionsAvgAggregateOutputType | null
    _sum: UserPermissionsSumAggregateOutputType | null
    _min: UserPermissionsMinAggregateOutputType | null
    _max: UserPermissionsMaxAggregateOutputType | null
  }

  export type UserPermissionsAvgAggregateOutputType = {
    user_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type UserPermissionsSumAggregateOutputType = {
    user_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type UserPermissionsMinAggregateOutputType = {
    user_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type UserPermissionsMaxAggregateOutputType = {
    user_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type UserPermissionsCountAggregateOutputType = {
    user_id: number
    permission_id: number
    company_id: number
    _all: number
  }


  export type UserPermissionsAvgAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
  }

  export type UserPermissionsSumAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
  }

  export type UserPermissionsMinAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
  }

  export type UserPermissionsMaxAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
  }

  export type UserPermissionsCountAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
    _all?: true
  }

  export type UserPermissionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPermissions to aggregate.
     */
    where?: UserPermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPermissions to fetch.
     */
    orderBy?: UserPermissionsOrderByWithRelationAndSearchRelevanceInput | UserPermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserPermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserPermissions
    **/
    _count?: true | UserPermissionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserPermissionsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserPermissionsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserPermissionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserPermissionsMaxAggregateInputType
  }

  export type GetUserPermissionsAggregateType<T extends UserPermissionsAggregateArgs> = {
        [P in keyof T & keyof AggregateUserPermissions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserPermissions[P]>
      : GetScalarType<T[P], AggregateUserPermissions[P]>
  }




  export type UserPermissionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPermissionsWhereInput
    orderBy?: UserPermissionsOrderByWithAggregationInput | UserPermissionsOrderByWithAggregationInput[]
    by: UserPermissionsScalarFieldEnum[] | UserPermissionsScalarFieldEnum
    having?: UserPermissionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserPermissionsCountAggregateInputType | true
    _avg?: UserPermissionsAvgAggregateInputType
    _sum?: UserPermissionsSumAggregateInputType
    _min?: UserPermissionsMinAggregateInputType
    _max?: UserPermissionsMaxAggregateInputType
  }

  export type UserPermissionsGroupByOutputType = {
    user_id: number
    permission_id: number
    company_id: number
    _count: UserPermissionsCountAggregateOutputType | null
    _avg: UserPermissionsAvgAggregateOutputType | null
    _sum: UserPermissionsSumAggregateOutputType | null
    _min: UserPermissionsMinAggregateOutputType | null
    _max: UserPermissionsMaxAggregateOutputType | null
  }

  type GetUserPermissionsGroupByPayload<T extends UserPermissionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserPermissionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserPermissionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserPermissionsGroupByOutputType[P]>
            : GetScalarType<T[P], UserPermissionsGroupByOutputType[P]>
        }
      >
    >


  export type UserPermissionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    user_id?: boolean
    permission_id?: boolean
    company_id?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    permission?: boolean | PermissionsDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userPermissions"]>

  export type UserPermissionsSelectScalar = {
    user_id?: boolean
    permission_id?: boolean
    company_id?: boolean
  }


  export type UserPermissionsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    permission?: boolean | PermissionsDefaultArgs<ExtArgs>
  }


  export type $UserPermissionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserPermissions"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      permission: Prisma.$PermissionsPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      user_id: number
      permission_id: number
      company_id: number
    }, ExtArgs["result"]["userPermissions"]>
    composites: {}
  }


  type UserPermissionsGetPayload<S extends boolean | null | undefined | UserPermissionsDefaultArgs> = $Result.GetResult<Prisma.$UserPermissionsPayload, S>

  type UserPermissionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserPermissionsFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserPermissionsCountAggregateInputType | true
    }

  export interface UserPermissionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserPermissions'], meta: { name: 'UserPermissions' } }
    /**
     * Find zero or one UserPermissions that matches the filter.
     * @param {UserPermissionsFindUniqueArgs} args - Arguments to find a UserPermissions
     * @example
     * // Get one UserPermissions
     * const userPermissions = await prisma.userPermissions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserPermissionsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsFindUniqueArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one UserPermissions that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserPermissionsFindUniqueOrThrowArgs} args - Arguments to find a UserPermissions
     * @example
     * // Get one UserPermissions
     * const userPermissions = await prisma.userPermissions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserPermissionsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first UserPermissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsFindFirstArgs} args - Arguments to find a UserPermissions
     * @example
     * // Get one UserPermissions
     * const userPermissions = await prisma.userPermissions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserPermissionsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsFindFirstArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first UserPermissions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsFindFirstOrThrowArgs} args - Arguments to find a UserPermissions
     * @example
     * // Get one UserPermissions
     * const userPermissions = await prisma.userPermissions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserPermissionsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more UserPermissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserPermissions
     * const userPermissions = await prisma.userPermissions.findMany()
     * 
     * // Get first 10 UserPermissions
     * const userPermissions = await prisma.userPermissions.findMany({ take: 10 })
     * 
     * // Only select the `user_id`
     * const userPermissionsWithUser_idOnly = await prisma.userPermissions.findMany({ select: { user_id: true } })
     * 
    **/
    findMany<T extends UserPermissionsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a UserPermissions.
     * @param {UserPermissionsCreateArgs} args - Arguments to create a UserPermissions.
     * @example
     * // Create one UserPermissions
     * const UserPermissions = await prisma.userPermissions.create({
     *   data: {
     *     // ... data to create a UserPermissions
     *   }
     * })
     * 
    **/
    create<T extends UserPermissionsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsCreateArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many UserPermissions.
     * @param {UserPermissionsCreateManyArgs} args - Arguments to create many UserPermissions.
     * @example
     * // Create many UserPermissions
     * const userPermissions = await prisma.userPermissions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends UserPermissionsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserPermissions and returns the data saved in the database.
     * @param {UserPermissionsCreateManyAndReturnArgs} args - Arguments to create many UserPermissions.
     * @example
     * // Create many UserPermissions
     * const userPermissions = await prisma.userPermissions.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserPermissions and only return the `user_id`
     * const userPermissionsWithUser_idOnly = await prisma.userPermissions.createManyAndReturn({ 
     *   select: { user_id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends UserPermissionsCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a UserPermissions.
     * @param {UserPermissionsDeleteArgs} args - Arguments to delete one UserPermissions.
     * @example
     * // Delete one UserPermissions
     * const UserPermissions = await prisma.userPermissions.delete({
     *   where: {
     *     // ... filter to delete one UserPermissions
     *   }
     * })
     * 
    **/
    delete<T extends UserPermissionsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsDeleteArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one UserPermissions.
     * @param {UserPermissionsUpdateArgs} args - Arguments to update one UserPermissions.
     * @example
     * // Update one UserPermissions
     * const userPermissions = await prisma.userPermissions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserPermissionsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsUpdateArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more UserPermissions.
     * @param {UserPermissionsDeleteManyArgs} args - Arguments to filter UserPermissions to delete.
     * @example
     * // Delete a few UserPermissions
     * const { count } = await prisma.userPermissions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserPermissionsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserPermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserPermissions
     * const userPermissions = await prisma.userPermissions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserPermissionsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserPermissions.
     * @param {UserPermissionsUpsertArgs} args - Arguments to update or create a UserPermissions.
     * @example
     * // Update or create a UserPermissions
     * const userPermissions = await prisma.userPermissions.upsert({
     *   create: {
     *     // ... data to create a UserPermissions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserPermissions we want to update
     *   }
     * })
    **/
    upsert<T extends UserPermissionsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsUpsertArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of UserPermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsCountArgs} args - Arguments to filter UserPermissions to count.
     * @example
     * // Count the number of UserPermissions
     * const count = await prisma.userPermissions.count({
     *   where: {
     *     // ... the filter for the UserPermissions we want to count
     *   }
     * })
    **/
    count<T extends UserPermissionsCountArgs>(
      args?: Subset<T, UserPermissionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserPermissionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserPermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserPermissionsAggregateArgs>(args: Subset<T, UserPermissionsAggregateArgs>): Prisma.PrismaPromise<GetUserPermissionsAggregateType<T>>

    /**
     * Group by UserPermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserPermissionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserPermissionsGroupByArgs['orderBy'] }
        : { orderBy?: UserPermissionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserPermissionsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserPermissionsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserPermissions model
   */
  readonly fields: UserPermissionsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserPermissions.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserPermissionsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    permission<T extends PermissionsDefaultArgs<ExtArgs> = {}>(args?: Subset<T, PermissionsDefaultArgs<ExtArgs>>): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the UserPermissions model
   */ 
  interface UserPermissionsFieldRefs {
    readonly user_id: FieldRef<"UserPermissions", 'Int'>
    readonly permission_id: FieldRef<"UserPermissions", 'Int'>
    readonly company_id: FieldRef<"UserPermissions", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * UserPermissions findUnique
   */
  export type UserPermissionsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where: UserPermissionsWhereUniqueInput
  }

  /**
   * UserPermissions findUniqueOrThrow
   */
  export type UserPermissionsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where: UserPermissionsWhereUniqueInput
  }

  /**
   * UserPermissions findFirst
   */
  export type UserPermissionsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where?: UserPermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPermissions to fetch.
     */
    orderBy?: UserPermissionsOrderByWithRelationAndSearchRelevanceInput | UserPermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPermissions.
     */
    cursor?: UserPermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPermissions.
     */
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * UserPermissions findFirstOrThrow
   */
  export type UserPermissionsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where?: UserPermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPermissions to fetch.
     */
    orderBy?: UserPermissionsOrderByWithRelationAndSearchRelevanceInput | UserPermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPermissions.
     */
    cursor?: UserPermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPermissions.
     */
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * UserPermissions findMany
   */
  export type UserPermissionsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where?: UserPermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPermissions to fetch.
     */
    orderBy?: UserPermissionsOrderByWithRelationAndSearchRelevanceInput | UserPermissionsOrderByWithRelationAndSearchRelevanceInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserPermissions.
     */
    cursor?: UserPermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPermissions.
     */
    skip?: number
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * UserPermissions create
   */
  export type UserPermissionsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * The data needed to create a UserPermissions.
     */
    data: XOR<UserPermissionsCreateInput, UserPermissionsUncheckedCreateInput>
  }

  /**
   * UserPermissions createMany
   */
  export type UserPermissionsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserPermissions.
     */
    data: UserPermissionsCreateManyInput | UserPermissionsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserPermissions createManyAndReturn
   */
  export type UserPermissionsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserP