"use strict";var __awaiter=this&&this.__awaiter||function(e,t,r,i){return new(r||(r=Promise))((function(s,o){function a(e){try{n(i.next(e))}catch(e){o(e)}}function c(e){try{n(i.throw(e))}catch(e){o(e)}}function n(e){var t;e.done?s(e.value):(t=e.value,t instanceof r?t:new r((function(e){e(t)}))).then(a,c)}n((i=i.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.cronService=void 0;const lcp_cron_1=__importDefault(require("../utilities/lcp-cron")),response_1=require("../utilities/response"),import_master_service_1=require("./import-master.service"),prisma_service_1=__importDefault(require("./prisma.service")),common_service_1=require("../services/common.service");class cronService{static createCronJobs(e){return __awaiter(this,void 0,void 0,(function*(){try{console.log("Creating job with data:",e);return yield prisma_service_1.default.scheduledJob.create({data:{timing:e.timing,cron_url:e.cron_url,concat_base_url:e.concat_base_url,description:e.description}})}catch(e){console.error("Create error details:",e)}}))}static updateCronJob(e,t){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.scheduledJob.update({where:{id:e},data:{timing:t.timing,cron_url:t.cron_url,concat_base_url:t.concat_base_url,description:t.description}})}catch(e){throw console.error("Error updating cron job:",e),e}}))}static getCronJobs(){return __awaiter(this,void 0,void 0,(function*(){return{cron_list:yield prisma_service_1.default.scheduledJob.findMany(),cron_status:lcp_cron_1.default.getStatus()}}))}static removeCronJob(e){return __awaiter(this,void 0,void 0,(function*(){return yield prisma_service_1.default.scheduledJob.delete({where:{id:e}})}))}static runScheduledJob(e,t){return __awaiter(this,void 0,void 0,(function*(){let r=null;try{const i=yield prisma_service_1.default.scheduledJob.findFirst({where:{cron_url:e}});if(!i)throw new Error(`ScheduledJob not found for URL: ${e}`);r=i.id;const s=yield t();return yield prisma_service_1.default.scheduledJobLogs.create({data:{scheduled_job_id:r,executed_statement:`Executed job: ${e}`,schedule_status:s.status,response:s.message}}),s}catch(t){throw r&&(yield prisma_service_1.default.scheduledJobLogs.create({data:{scheduled_job_id:r,executed_statement:`Failed to execute job: ${e}`,schedule_status:"failed",response:t.message||"Unknown error"}})),console.error(`Error running scheduled job: ${e}`,t),t}}))}static processAuditLogs(){return __awaiter(this,void 0,void 0,(function*(){try{const e=new Date;e.setDate(e.getDate()-30);const t=yield prisma_service_1.default.auditLog.findMany({where:{deleted_at:null,created_at:{lt:e}},select:{id:!0}});if(0===t.length)return{status:"success",message:"No old logs to delete."};const r=t.map((e=>e.id));return yield prisma_service_1.default.auditLog.deleteMany({where:{id:{in:r}}}),{status:"success",message:`Marked ${r.length} request logs as deleted.`}}catch(e){throw console.error("Error processing request logs:",e),e}}))}static processRequestLogs(){return __awaiter(this,void 0,void 0,(function*(){try{return{status:"success",message:`Deleted ${(yield prisma_service_1.default.requestLog.deleteMany({})).count} request logs.`}}catch(e){throw console.error("Error deleting request logs:",e),e}}))}static scheduleImportJob(){return __awaiter(this,void 0,void 0,(function*(){try{const e=yield prisma_service_1.default.importJob.findFirst({where:{status_id:1,job_status:{not:"completed"}},orderBy:[{job_status:"desc"},{id:"asc"}]});if(!e)return{status:"success",message:"No pending jobs found."};const{id:t,total_rows:r,batch_process_count:i=50,header_details:s,last_processed_row_id:o=0,completed_rows:a,file_name:c,file_path:n}=e,d=e.company_id,l=e.created_by||1;console.log(`Processing Job ID: ${t}, Total Rows: ${r}, Batch Size: ${i}`);const _=yield prisma_service_1.default.importJobLineItem.findMany({where:{import_job_id:t,company_id:d,job_status:{not:"processed"}},orderBy:[{id:"asc"}],take:i,select:{id:!0,row_object:!0}});console.log(`Fetched ${_.length} items from index ${o} to ${o+i}`),console.log(`Total line items fetched for Job ID ${t}: ${_.length}`);const u={row_datas:_.map((e=>e.row_object)).filter(Boolean),ind_row_datas:s.ind_row_datas||[]},p={template_uuid:s.selectedTemplate,file_uuid:s.fileUploadLog};console.log(`Processing rows from ${o} to ${o+i} for Job ID: ${t}`);yield import_master_service_1.importMasterService.importTemplateDetail(d,p,u,l);const m=yield import_master_service_1.importMasterService.getTemplateDetail(d,p.template_uuid);for(const e of _)try{yield prisma_service_1.default.importJobLineItem.update({where:{id:e.id},data:{job_status:"processed",row_object:Object.assign(Object.assign({},e.row_object),{warning:!1,errorMessages:"This item has been processed successfully",errors:{},warnings:{},errorstatus:'<span class="badge text-xs badge-outline-success">Processed</span>'})}})}catch(t){const r={},i={status:500};(0,response_1.errorResponse)(r,i,[],`Failed to process line item ${e.id}:`,t),console.error(`Failed to process line item ${e.id}:`,t)}const h=a+i>=r?"completed":"in-progress",g=_.length>0?_[_.length-1].id:o;return console.log(`Updating job progress: Completed Rows: ${a}, Last Processed Row ID: ${g}, Job Status: ${h}`),yield prisma_service_1.default.importJob.update({where:{id:t},data:{last_processed_row_id:g,job_status:h,completed_rows:Math.min(a+i,r)}}),console.log("Import job processing completed."),r<=a+i&&c&&import_master_service_1.importMasterService.pushExcelToMail(n,l,c,m.records[0].email_process_slug),{status:"success",message:"Import job processing completed."}}catch(e){console.error("Error processing import job:",e);const t={},r={status:500};throw(0,response_1.errorResponse)(t,r,[],"Error processing import job:",e),e}}))}static getProcessEmailJobs(){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.emailProcessJob.findMany({orderBy:[{id:"asc"}],where:{status_id:1},take:10})}catch(e){throw console.error("Error getting getProcessEmailJobs:",e),e}}))}static updateProcessEmailJobs(e){return __awaiter(this,arguments,void 0,(function*(e,t=3){try{return yield prisma_service_1.default.emailProcessJob.updateMany({where:{id:{in:e}},data:{status_id:t}})}catch(e){throw console.error("Error getting getProcessEmailJobs:",e),e}}))}static getEmailProcess(e,t){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.emailTemplateProcess.findFirst({orderBy:[{id:"desc"}],where:{company_id:e,slug:t,status_id:1}})}catch(r){throw console.error(`Error getting getEmailProcess: company_id:${e} slug:${t}`,r),r}}))}static getAssignedMailData(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.emailTemplateAssignment.findMany({orderBy:[{id:"asc"}],where:{email_template_process_id:e},select:{id:!0,uuid:!0,email_template_process_id:!0,template_id:!0,recipient_type:!0,email_to:!0,email_template_cc_bcc:{select:{id:!0,email_to:!0,recipient_type:!0,send_type:!0}},email_template:{select:{id:!0,uuid:!0,slug:!0,name:!0,subject:!0,template_body:!0}}}})}catch(t){throw console.error(`Error getting getAssignedMailData: email_template_process_id:${e}}`,t),t}}))}static getMailRecipientTags(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.emailTemplateRecipientTag.findMany({orderBy:[{id:"asc"}],where:{id:{in:e}},select:{id:!0,uuid:!0,slug:!0,name:!0,query_information:!0}})}catch(t){throw console.error(`Error getting getMailRecipientTags: email_to_array:${e} `,t),t}}))}static getWhatsappRecipientTags(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.whatsappTemplateRecipientTag.findMany({orderBy:[{id:"asc"}],where:{id:{in:e}},select:{id:!0,uuid:!0,slug:!0,name:!0,query_information:!0}})}catch(t){throw console.error(`Error getting getWhatsappRecipientTags: whatsapp_to_array:${e} `,t),t}}))}static getWhatsappProcess(e,t){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.whatsappTemplateProcess.findFirst({orderBy:[{id:"desc"}],where:{company_id:e,slug:t,status_id:1}})}catch(r){throw console.error(`Error getting getWhatsappProcess: company_id:${e} slug:${t}`,r),r}}))}static getProcessWhatsappJobs(){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.whatsappProcessJob.findMany({orderBy:[{id:"asc"}],where:{status_id:1},take:10})}catch(e){throw console.error("Error getting getProcessWhatsappJobs:",e),e}}))}static processSingleWhatsappJob(e){return __awaiter(this,void 0,void 0,(function*(){try{const{unique_id:t,user_id:r,whatsapp_template_process_slug:i,prefill_data:s,company_id:o,created_by:a}=e,c=yield cronService.getWhatsappProcess(o,i);if(!c)return null;let n=cronService.replacePlaceholders(c.query_information||"",t,r,s);const d=n?yield cronService.getTagData(n,o):{},l=yield cronService.getAssignedWhatsappData(c.id);return(yield Promise.all(l.map((e=>cronService.processWhatsappData(e,d,r,s,o,a,i))))).filter((e=>null!==e))}catch(e){throw e}}))}static processWhatsappData(e,t,r,i,s,o,a){return __awaiter(this,void 0,void 0,(function*(){const{recipient_type:c,whatsapp_to:n,whatsapp_template:d}=e;let l=cronService.parseEmailToArray(n);if("tag"===c&&(l=yield cronService.getWhatsappForTagRecipients(l,r,i,s)),l.length>0){const e=Object.assign(Object.assign({},JSON.parse(i||"{}")),t),r=yield cronService.replaceContentPlaceholders(d.message,e);return l.map((e=>({process_slug:a,notification_type_id:"ac15",notification_status_id:"ac7",notification_to:e,notification_content:r,notification_type:"whatsapp",company_id:s,created_by:o})))}return null}))}static updateProcessWhatsappJobs(e){return __awaiter(this,arguments,void 0,(function*(e,t=3){try{return yield prisma_service_1.default.whatsappProcessJob.updateMany({where:{id:{in:e}},data:{status_id:t}})}catch(e){throw console.error("Error getting getProcessWhatsappJobs:",e),e}}))}static getWhatsappForTagRecipients(e,t,r,i){return __awaiter(this,void 0,void 0,(function*(){const s=e.map((e=>Number(e))),o=yield cronService.getWhatsappRecipientTags(s);return(yield Promise.all(o.map((e=>__awaiter(this,void 0,void 0,(function*(){let s=cronService.replacePlaceholders(e.query_information,"",t,r);const o=JSON.parse(s),a=yield common_service_1.commonService.getTableData(i,o);if(!(null==a?void 0:a.total_records)||a.total_records<1)return null;const c=a.records.map((e=>e.phone_number)).filter((e=>null!=e));return 1===c.length?c[0]:c})))))).flat().filter((e=>null!==e))}))}static insertNotificationJobs(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.notificationJob.createMany({data:e})}catch(t){throw console.error(`Error insertNotificationJobs: jobs:${e} `,t),t}}))}static getNonsentNotifications(){return __awaiter(this,void 0,void 0,(function*(){try{let e=yield prisma_service_1.default.notificationJob.findMany({where:{notification_type_id:{in:["ac4","ac15"]},notification_status_id:"ac7",status_id:1},orderBy:[{id:"asc"}],take:10}),t=e.map((e=>e.id));return yield prisma_service_1.default.notificationJob.updateMany({where:{id:{in:t}},data:{notification_status_id:"ac8"}}),e}catch(e){throw console.error("Error getNonsentEmailNotifications: ",e),e}}))}static updateNotificationStatus(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.notificationJob.update({where:{id:e.id},data:{notification_status_id:"ac9",sent_at:new Date,no_of_attempts:e.no_of_attempts+1}})}catch(t){throw console.error(`Error updateNotificationStatus: notification.id:${e.id} `,t),t}}))}static replacePlaceholders(e,t,r,i){if(e=(e=e.replace(/@process\.unique_id/g,t)).replace(/@process\.user_id/g,`${r||0}`),i){const t=JSON.parse(i);for(const r in t)if(t.hasOwnProperty(r)){const i=new RegExp(`@process\\.prefill_data\\.${r}`,"g");e=e.replace(i,t[r]||"")}}return e}static getTagData(e,t){return __awaiter(this,void 0,void 0,(function*(){const r=JSON.parse(e),i=yield common_service_1.commonService.getTableData(t,r);return(null==i?void 0:i.total_records)>0?i.records[0]:{}}))}static getAssignedWhatsappData(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.whatsappTemplateAssignment.findMany({orderBy:[{id:"asc"}],where:{whatsapp_template_process_id:e},select:{id:!0,uuid:!0,whatsapp_template_process_id:!0,template_id:!0,recipient_type:!0,whatsapp_to:!0,whatsapp_template:{select:{id:!0,uuid:!0,slug:!0,name:!0,message:!0}}}})}catch(t){throw console.error(`Error getting getAssignedwhatsappData: whatsapp_template_process_id:${e}}`,t),t}}))}static parseEmailToArray(e){return(null==e?void 0:e.replace(/\s+/g,"").split(","))||[]}static replaceContentPlaceholders(e,t){return __awaiter(this,void 0,void 0,(function*(){let r=e;for(const e in t)if(t.hasOwnProperty(e)){const i=Array.isArray(t[e])?yield cronService.generateTable(t[e]):t[e],s=new RegExp(`\\[${e}\\]`,"g");r=r.replace(s,i||"")}return r}))}static generateTable(e){return __awaiter(this,void 0,void 0,(function*(){if(!e||0===e.length)return"";const t=Object.keys(e[0]);let r='<table border="1" cellpadding="5" cellspacing="0"><thead><tr>';return t.forEach((e=>r+=`<th>${e}</th>`)),r+="</tr></thead><tbody>",e.forEach((e=>{r+="<tr>",t.forEach((t=>r+=`<td>${e[t]}</td>`)),r+="</tr>"})),r+="</tbody></table>",r}))}}exports.cronService=cronService;